/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgCloseContextMethodStart::dap_lifi_tclMsgCloseContextMethodStart(const dap_lifi_tclMsgCloseContextMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgCloseContextMethodStart& dap_lifi_tclMsgCloseContextMethodStart::operator=(const dap_lifi_tclMsgCloseContextMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgCloseContextMethodStart::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgCloseContextMethodStart::u16GetFunctionID() const {return DAP_LIFI_C_U16_CLOSECONTEXT;}
tU8 dap_lifi_tclMsgCloseContextMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 dap_lifi_tclMsgCloseContextMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (16 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+5;
}

tBool dap_lifi_tclMsgCloseContextMethodStart::operator==(const dap_lifi_tclMsgCloseContextMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (UserId == rfoCmp.UserId);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgCloseContextMethodStart::oRead(fi_tclInContext& oIn)
{
   if (16 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> DatasetId;
   oIn >> UserId;
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgCloseContextMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (16 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << DatasetId;
   oOut << UserId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgCloseContextMethodResult::dap_lifi_tclMsgCloseContextMethodResult(const dap_lifi_tclMsgCloseContextMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UnusedUserId = coRef.UnusedUserId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgCloseContextMethodResult& dap_lifi_tclMsgCloseContextMethodResult::operator=(const dap_lifi_tclMsgCloseContextMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UnusedUserId = coRef.UnusedUserId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgCloseContextMethodResult::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgCloseContextMethodResult::u16GetFunctionID() const {return DAP_LIFI_C_U16_CLOSECONTEXT;}
tU8 dap_lifi_tclMsgCloseContextMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 dap_lifi_tclMsgCloseContextMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool dap_lifi_tclMsgCloseContextMethodResult::operator==(const dap_lifi_tclMsgCloseContextMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UnusedUserId == rfoCmp.UnusedUserId);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgCloseContextMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UnusedUserId;
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgCloseContextMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UnusedUserId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetObjectsMethodStart::dap_lifi_tclMsgGetObjectsMethodStart(const dap_lifi_tclMsgGetObjectsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   SelectionCriteriaMask = coRef.SelectionCriteriaMask;
   GetOption = coRef.GetOption;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetObjectsMethodStart& dap_lifi_tclMsgGetObjectsMethodStart::operator=(const dap_lifi_tclMsgGetObjectsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   SelectionCriteriaMask = coRef.SelectionCriteriaMask;
   GetOption = coRef.GetOption;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgGetObjectsMethodStart::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgGetObjectsMethodStart::u16GetFunctionID() const {return DAP_LIFI_C_U16_GETOBJECTS;}
tU8 dap_lifi_tclMsgGetObjectsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_lifi_tclMsgGetObjectsMethodStart::vDestroy()
{
   LocationDescription.vDestroy(); 
}

tU32 dap_lifi_tclMsgGetObjectsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (16 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (19 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+8+LocationDescription.u32GetSize(u16MajorVersion);
}

tBool dap_lifi_tclMsgGetObjectsMethodStart::operator==(const dap_lifi_tclMsgGetObjectsMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (UserId == rfoCmp.UserId);
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
      bResult = bResult && (SelectionCriteriaMask == rfoCmp.SelectionCriteriaMask);
      bResult = bResult && (GetOption == rfoCmp.GetOption);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgGetObjectsMethodStart::oRead(fi_tclInContext& oIn)
{
   if (16 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> DatasetId;
   oIn >> UserId;
   oIn >> UILanguage;
   oIn >> LocationDescription;
   oIn >> SelectionCriteriaMask;
   if (19 <= oIn.u16GetMajorVersion())
   {
      oIn >> GetOption;
   }
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgGetObjectsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (16 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << DatasetId;
   oOut << UserId;
   oOut << UILanguage;
   oOut << LocationDescription;
   oOut << SelectionCriteriaMask;
   if (19 <= oOut.u16GetMajorVersion())
   {
      oOut << GetOption;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetObjectsMethodResult::dap_lifi_tclMsgGetObjectsMethodResult(const dap_lifi_tclMsgGetObjectsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   SelectionCriteriaList = coRef.SelectionCriteriaList;
   InputContinuationMask = coRef.InputContinuationMask;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetObjectsMethodResult& dap_lifi_tclMsgGetObjectsMethodResult::operator=(const dap_lifi_tclMsgGetObjectsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   SelectionCriteriaList = coRef.SelectionCriteriaList;
   InputContinuationMask = coRef.InputContinuationMask;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgGetObjectsMethodResult::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgGetObjectsMethodResult::u16GetFunctionID() const {return DAP_LIFI_C_U16_GETOBJECTS;}
tU8 dap_lifi_tclMsgGetObjectsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_lifi_tclMsgGetObjectsMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SelectionCriteriaList.size(); ++u32Idx)
         SelectionCriteriaList[u32Idx].vDestroy();
   }
   SelectionCriteriaList.clear();
}

tU32 dap_lifi_tclMsgGetObjectsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SelectionCriteriaList.size(); ++u32ListIdx)
      u32DynamicSize += SelectionCriteriaList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+7;
}

tBool dap_lifi_tclMsgGetObjectsMethodResult::operator==(const dap_lifi_tclMsgGetObjectsMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (SelectionCriteriaList.size() == rfoCmp.SelectionCriteriaList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SelectionCriteriaList.size()); ++u32Idx)
            bResult = bResult && (SelectionCriteriaList[u32Idx] == rfoCmp.SelectionCriteriaList[u32Idx]);
      }
      bResult = bResult && (InputContinuationMask == rfoCmp.InputContinuationMask);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgGetObjectsMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SelectionCriteriaList.size(); ++u32Idx)
      {
         SelectionCriteriaList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      SelectionCriteriaList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SelectionCriteriaList[u32Idx];
      }
   }
   oIn >> InputContinuationMask;
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgGetObjectsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << (tU32)SelectionCriteriaList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SelectionCriteriaList.size(); ++u32Idx)
         oOut << SelectionCriteriaList[u32Idx];
   }
   oOut << InputContinuationMask;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetObjectDescriptionMethodStart::dap_lifi_tclMsgGetObjectDescriptionMethodStart(const dap_lifi_tclMsgGetObjectDescriptionMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
   UILanguage = coRef.UILanguage;
   RefinementCriteriaMask = coRef.RefinementCriteriaMask;
   ObjectCodeList = coRef.ObjectCodeList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetObjectDescriptionMethodStart& dap_lifi_tclMsgGetObjectDescriptionMethodStart::operator=(const dap_lifi_tclMsgGetObjectDescriptionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
   UILanguage = coRef.UILanguage;
   RefinementCriteriaMask = coRef.RefinementCriteriaMask;
   ObjectCodeList = coRef.ObjectCodeList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgGetObjectDescriptionMethodStart::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgGetObjectDescriptionMethodStart::u16GetFunctionID() const {return DAP_LIFI_C_U16_GETOBJECTDESCRIPTION;}
tU8 dap_lifi_tclMsgGetObjectDescriptionMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_lifi_tclMsgGetObjectDescriptionMethodStart::vDestroy()
{
   ObjectCodeList.clear();
}

tU32 dap_lifi_tclMsgGetObjectDescriptionMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (16 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+12+ObjectCodeList.size()*2;
}

tBool dap_lifi_tclMsgGetObjectDescriptionMethodStart::operator==(const dap_lifi_tclMsgGetObjectDescriptionMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (UserId == rfoCmp.UserId);
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (RefinementCriteriaMask == rfoCmp.RefinementCriteriaMask);
      bResult = bResult && (ObjectCodeList.size() == rfoCmp.ObjectCodeList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ObjectCodeList.size()); ++u32Idx)
            bResult = bResult && (ObjectCodeList[u32Idx] == rfoCmp.ObjectCodeList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgGetObjectDescriptionMethodStart::oRead(fi_tclInContext& oIn)
{
   if (16 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> DatasetId;
   oIn >> UserId;
   oIn >> UILanguage;
   oIn >> RefinementCriteriaMask;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      ObjectCodeList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ObjectCodeList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgGetObjectDescriptionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (16 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << DatasetId;
   oOut << UserId;
   oOut << UILanguage;
   oOut << RefinementCriteriaMask;
   oOut << (tU32)ObjectCodeList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ObjectCodeList.size(); ++u32Idx)
         oOut << ObjectCodeList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetObjectDescriptionMethodResult::dap_lifi_tclMsgGetObjectDescriptionMethodResult(const dap_lifi_tclMsgGetObjectDescriptionMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   ObjectDescriptionList = coRef.ObjectDescriptionList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetObjectDescriptionMethodResult& dap_lifi_tclMsgGetObjectDescriptionMethodResult::operator=(const dap_lifi_tclMsgGetObjectDescriptionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   ObjectDescriptionList = coRef.ObjectDescriptionList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgGetObjectDescriptionMethodResult::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgGetObjectDescriptionMethodResult::u16GetFunctionID() const {return DAP_LIFI_C_U16_GETOBJECTDESCRIPTION;}
tU8 dap_lifi_tclMsgGetObjectDescriptionMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_lifi_tclMsgGetObjectDescriptionMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ObjectDescriptionList.size(); ++u32Idx)
         ObjectDescriptionList[u32Idx].vDestroy();
   }
   ObjectDescriptionList.clear();
}

tU32 dap_lifi_tclMsgGetObjectDescriptionMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ObjectDescriptionList.size(); ++u32ListIdx)
      u32DynamicSize += ObjectDescriptionList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6;
}

tBool dap_lifi_tclMsgGetObjectDescriptionMethodResult::operator==(const dap_lifi_tclMsgGetObjectDescriptionMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (ObjectDescriptionList.size() == rfoCmp.ObjectDescriptionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ObjectDescriptionList.size()); ++u32Idx)
            bResult = bResult && (ObjectDescriptionList[u32Idx] == rfoCmp.ObjectDescriptionList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgGetObjectDescriptionMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ObjectDescriptionList.size(); ++u32Idx)
      {
         ObjectDescriptionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ObjectDescriptionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ObjectDescriptionList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgGetObjectDescriptionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << (tU32)ObjectDescriptionList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ObjectDescriptionList.size(); ++u32Idx)
         oOut << ObjectDescriptionList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetElementNumberMethodStart::dap_lifi_tclMsgGetElementNumberMethodStart(const dap_lifi_tclMsgGetElementNumberMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   FilterAttributes = coRef.FilterAttributes;
   MaxNumberOfElements = coRef.MaxNumberOfElements;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetElementNumberMethodStart& dap_lifi_tclMsgGetElementNumberMethodStart::operator=(const dap_lifi_tclMsgGetElementNumberMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   FilterAttributes = coRef.FilterAttributes;
   MaxNumberOfElements = coRef.MaxNumberOfElements;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgGetElementNumberMethodStart::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgGetElementNumberMethodStart::u16GetFunctionID() const {return DAP_LIFI_C_U16_GETELEMENTNUMBER;}
tU8 dap_lifi_tclMsgGetElementNumberMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_lifi_tclMsgGetElementNumberMethodStart::vDestroy()
{
   LocationDescription.vDestroy(); 
   FilterAttributes.clear();
}

tU32 dap_lifi_tclMsgGetElementNumberMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (16 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+15+LocationDescription.u32GetSize(u16MajorVersion)+FilterAttributes.size()*2;
}

tBool dap_lifi_tclMsgGetElementNumberMethodStart::operator==(const dap_lifi_tclMsgGetElementNumberMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (UserId == rfoCmp.UserId);
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
      bResult = bResult && (FilterAttributes.size() == rfoCmp.FilterAttributes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FilterAttributes.size()); ++u32Idx)
            bResult = bResult && (FilterAttributes[u32Idx] == rfoCmp.FilterAttributes[u32Idx]);
      }
      bResult = bResult && (MaxNumberOfElements == rfoCmp.MaxNumberOfElements);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgGetElementNumberMethodStart::oRead(fi_tclInContext& oIn)
{
   if (16 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> DatasetId;
   oIn >> UserId;
   oIn >> UILanguage;
   oIn >> LocationDescription;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      FilterAttributes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> FilterAttributes[u32Idx];
      }
   }
   oIn >> MaxNumberOfElements;
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgGetElementNumberMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (16 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << DatasetId;
   oOut << UserId;
   oOut << UILanguage;
   oOut << LocationDescription;
   oOut << (tU32)FilterAttributes.size();
   {
      for (tU32 u32Idx = 0; u32Idx < FilterAttributes.size(); ++u32Idx)
         oOut << FilterAttributes[u32Idx];
   }
   oOut << MaxNumberOfElements;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetElementNumberMethodResult::dap_lifi_tclMsgGetElementNumberMethodResult(const dap_lifi_tclMsgGetElementNumberMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   NumberOfElements = coRef.NumberOfElements;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetElementNumberMethodResult& dap_lifi_tclMsgGetElementNumberMethodResult::operator=(const dap_lifi_tclMsgGetElementNumberMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   NumberOfElements = coRef.NumberOfElements;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgGetElementNumberMethodResult::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgGetElementNumberMethodResult::u16GetFunctionID() const {return DAP_LIFI_C_U16_GETELEMENTNUMBER;}
tU8 dap_lifi_tclMsgGetElementNumberMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 dap_lifi_tclMsgGetElementNumberMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

tBool dap_lifi_tclMsgGetElementNumberMethodResult::operator==(const dap_lifi_tclMsgGetElementNumberMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (NumberOfElements == rfoCmp.NumberOfElements);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgGetElementNumberMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   oIn >> NumberOfElements;
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgGetElementNumberMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << NumberOfElements;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetASFCharactersMethodStart::dap_lifi_tclMsgGetASFCharactersMethodStart(const dap_lifi_tclMsgGetASFCharactersMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   AttributeCodes = coRef.AttributeCodes;
   PartialNameRotation = coRef.PartialNameRotation;
   AllCharsInCountry = coRef.AllCharsInCountry;
   LowerCaseLetters = coRef.LowerCaseLetters;
   SortReferencePosition = coRef.SortReferencePosition;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetASFCharactersMethodStart& dap_lifi_tclMsgGetASFCharactersMethodStart::operator=(const dap_lifi_tclMsgGetASFCharactersMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   AttributeCodes = coRef.AttributeCodes;
   PartialNameRotation = coRef.PartialNameRotation;
   AllCharsInCountry = coRef.AllCharsInCountry;
   LowerCaseLetters = coRef.LowerCaseLetters;
   SortReferencePosition = coRef.SortReferencePosition;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgGetASFCharactersMethodStart::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgGetASFCharactersMethodStart::u16GetFunctionID() const {return DAP_LIFI_C_U16_GETASFCHARACTERS;}
tU8 dap_lifi_tclMsgGetASFCharactersMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_lifi_tclMsgGetASFCharactersMethodStart::vDestroy()
{
   LocationDescription.vDestroy(); 
   AttributeCodes.clear();
   SortReferencePosition.vDestroy(); 
}

tU32 dap_lifi_tclMsgGetASFCharactersMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (16 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (13 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (27 <= u16MajorVersion)
   {
      u32DynamicSize += 8;
   }
   return u32DynamicSize+13+LocationDescription.u32GetSize(u16MajorVersion)+AttributeCodes.size()*2;
}

tBool dap_lifi_tclMsgGetASFCharactersMethodStart::operator==(const dap_lifi_tclMsgGetASFCharactersMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (UserId == rfoCmp.UserId);
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
      bResult = bResult && (AttributeCodes.size() == rfoCmp.AttributeCodes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AttributeCodes.size()); ++u32Idx)
            bResult = bResult && (AttributeCodes[u32Idx] == rfoCmp.AttributeCodes[u32Idx]);
      }
      bResult = bResult && (PartialNameRotation == rfoCmp.PartialNameRotation);
      bResult = bResult && (AllCharsInCountry == rfoCmp.AllCharsInCountry);
      bResult = bResult && (LowerCaseLetters == rfoCmp.LowerCaseLetters);
      bResult = bResult && (SortReferencePosition == rfoCmp.SortReferencePosition);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgGetASFCharactersMethodStart::oRead(fi_tclInContext& oIn)
{
   if (16 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> DatasetId;
   oIn >> UserId;
   oIn >> UILanguage;
   oIn >> LocationDescription;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      AttributeCodes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> AttributeCodes[u32Idx];
      }
   }
   oIn >> PartialNameRotation;
   oIn >> AllCharsInCountry;
   if (13 <= oIn.u16GetMajorVersion())
   {
      oIn >> LowerCaseLetters;
   }
   if (27 <= oIn.u16GetMajorVersion())
   {
      oIn >> SortReferencePosition;
   }
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgGetASFCharactersMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (16 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << DatasetId;
   oOut << UserId;
   oOut << UILanguage;
   oOut << LocationDescription;
   oOut << (tU32)AttributeCodes.size();
   {
      for (tU32 u32Idx = 0; u32Idx < AttributeCodes.size(); ++u32Idx)
         oOut << AttributeCodes[u32Idx];
   }
   oOut << PartialNameRotation;
   oOut << AllCharsInCountry;
   if (13 <= oOut.u16GetMajorVersion())
   {
      oOut << LowerCaseLetters;
   }
   if (27 <= oOut.u16GetMajorVersion())
   {
      oOut << SortReferencePosition;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetASFCharactersMethodResult::dap_lifi_tclMsgGetASFCharactersMethodResult(const dap_lifi_tclMsgGetASFCharactersMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   Status = coRef.Status;
   RemainingEntries = coRef.RemainingEntries;
   CompletionString = coRef.CompletionString;
   SubsequentLetters = coRef.SubsequentLetters;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetASFCharactersMethodResult& dap_lifi_tclMsgGetASFCharactersMethodResult::operator=(const dap_lifi_tclMsgGetASFCharactersMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   Status = coRef.Status;
   RemainingEntries = coRef.RemainingEntries;
   CompletionString = coRef.CompletionString;
   SubsequentLetters = coRef.SubsequentLetters;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgGetASFCharactersMethodResult::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgGetASFCharactersMethodResult::u16GetFunctionID() const {return DAP_LIFI_C_U16_GETASFCHARACTERS;}
tU8 dap_lifi_tclMsgGetASFCharactersMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_lifi_tclMsgGetASFCharactersMethodResult::vDestroy()
{
   CompletionString.vDestroy();
   SubsequentLetters.vDestroy();
}

tU32 dap_lifi_tclMsgGetASFCharactersMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 7+CompletionString.u32GetSize(u16MajorVersion)+SubsequentLetters.u32GetSize(u16MajorVersion);
}

tBool dap_lifi_tclMsgGetASFCharactersMethodResult::operator==(const dap_lifi_tclMsgGetASFCharactersMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (Status == rfoCmp.Status);
      bResult = bResult && (RemainingEntries == rfoCmp.RemainingEntries);
      bResult = bResult && (CompletionString == rfoCmp.CompletionString);
      bResult = bResult && (SubsequentLetters == rfoCmp.SubsequentLetters);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgGetASFCharactersMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   oIn >> Status;
   oIn >> RemainingEntries;
   oIn >> CompletionString;
   oIn >> SubsequentLetters;
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgGetASFCharactersMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << Status;
   oOut << RemainingEntries;
   oOut << CompletionString;
   oOut << SubsequentLetters;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetEntryListMethodStart::dap_lifi_tclMsgGetEntryListMethodStart(const dap_lifi_tclMsgGetEntryListMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   Status = coRef.Status;
   SortOrder = coRef.SortOrder;
   ListOffset = coRef.ListOffset;
   Limit = coRef.Limit;
   SortReferencePosition = coRef.SortReferencePosition;
   FilterAttributes = coRef.FilterAttributes;
   NoMatchingChars = coRef.NoMatchingChars;
   MaxRadius = coRef.MaxRadius;
   CurrentPositionInfo = coRef.CurrentPositionInfo;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetEntryListMethodStart& dap_lifi_tclMsgGetEntryListMethodStart::operator=(const dap_lifi_tclMsgGetEntryListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   Status = coRef.Status;
   SortOrder = coRef.SortOrder;
   ListOffset = coRef.ListOffset;
   Limit = coRef.Limit;
   SortReferencePosition = coRef.SortReferencePosition;
   FilterAttributes = coRef.FilterAttributes;
   NoMatchingChars = coRef.NoMatchingChars;
   MaxRadius = coRef.MaxRadius;
   CurrentPositionInfo = coRef.CurrentPositionInfo;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgGetEntryListMethodStart::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgGetEntryListMethodStart::u16GetFunctionID() const {return DAP_LIFI_C_U16_GETENTRYLIST;}
tU8 dap_lifi_tclMsgGetEntryListMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_lifi_tclMsgGetEntryListMethodStart::vDestroy()
{
   LocationDescription.vDestroy(); 
   SortReferencePosition.vDestroy(); 
   FilterAttributes.clear();
   CurrentPositionInfo.vDestroy(); 
}

tU32 dap_lifi_tclMsgGetEntryListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (16 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (15 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (19 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (19 <= u16MajorVersion)
   {
      u32DynamicSize += CurrentPositionInfo.u32GetSize(u16MajorVersion);
   }
   return u32DynamicSize+29+LocationDescription.u32GetSize(u16MajorVersion)+FilterAttributes.size()*2;
}

tBool dap_lifi_tclMsgGetEntryListMethodStart::operator==(const dap_lifi_tclMsgGetEntryListMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (UserId == rfoCmp.UserId);
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
      bResult = bResult && (Status == rfoCmp.Status);
      bResult = bResult && (SortOrder == rfoCmp.SortOrder);
      bResult = bResult && (ListOffset == rfoCmp.ListOffset);
      bResult = bResult && (Limit == rfoCmp.Limit);
      bResult = bResult && (SortReferencePosition == rfoCmp.SortReferencePosition);
      bResult = bResult && (FilterAttributes.size() == rfoCmp.FilterAttributes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FilterAttributes.size()); ++u32Idx)
            bResult = bResult && (FilterAttributes[u32Idx] == rfoCmp.FilterAttributes[u32Idx]);
      }
      bResult = bResult && (NoMatchingChars == rfoCmp.NoMatchingChars);
      bResult = bResult && (MaxRadius == rfoCmp.MaxRadius);
      bResult = bResult && (CurrentPositionInfo == rfoCmp.CurrentPositionInfo);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgGetEntryListMethodStart::oRead(fi_tclInContext& oIn)
{
   if (16 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> DatasetId;
   oIn >> UserId;
   oIn >> UILanguage;
   oIn >> LocationDescription;
   oIn >> Status;
   oIn >> SortOrder;
   oIn >> ListOffset;
   oIn >> Limit;
   oIn >> SortReferencePosition;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      FilterAttributes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> FilterAttributes[u32Idx];
      }
   }
   if (15 <= oIn.u16GetMajorVersion())
   {
      oIn >> NoMatchingChars;
   }
   if (19 <= oIn.u16GetMajorVersion())
   {
      oIn >> MaxRadius;
   }
   if (19 <= oIn.u16GetMajorVersion())
   {
      oIn >> CurrentPositionInfo;
   }
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgGetEntryListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (16 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << DatasetId;
   oOut << UserId;
   oOut << UILanguage;
   oOut << LocationDescription;
   oOut << Status;
   oOut << SortOrder;
   oOut << ListOffset;
   oOut << Limit;
   oOut << SortReferencePosition;
   oOut << (tU32)FilterAttributes.size();
   {
      for (tU32 u32Idx = 0; u32Idx < FilterAttributes.size(); ++u32Idx)
         oOut << FilterAttributes[u32Idx];
   }
   if (15 <= oOut.u16GetMajorVersion())
   {
      oOut << NoMatchingChars;
   }
   if (19 <= oOut.u16GetMajorVersion())
   {
      oOut << MaxRadius;
   }
   if (19 <= oOut.u16GetMajorVersion())
   {
      oOut << CurrentPositionInfo;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetEntryListMethodResult::dap_lifi_tclMsgGetEntryListMethodResult(const dap_lifi_tclMsgGetEntryListMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   Status = coRef.Status;
   Elements = coRef.Elements;
   LocationDescription = coRef.LocationDescription;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetEntryListMethodResult& dap_lifi_tclMsgGetEntryListMethodResult::operator=(const dap_lifi_tclMsgGetEntryListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   Status = coRef.Status;
   Elements = coRef.Elements;
   LocationDescription = coRef.LocationDescription;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgGetEntryListMethodResult::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgGetEntryListMethodResult::u16GetFunctionID() const {return DAP_LIFI_C_U16_GETENTRYLIST;}
tU8 dap_lifi_tclMsgGetEntryListMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_lifi_tclMsgGetEntryListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Elements.size(); ++u32Idx)
         Elements[u32Idx].vDestroy();
   }
   Elements.clear();
   LocationDescription.vDestroy(); 
}

tU32 dap_lifi_tclMsgGetEntryListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Elements.size(); ++u32ListIdx)
      u32DynamicSize += Elements[u32ListIdx].u32GetSize(u16MajorVersion);
   if (19 <= u16MajorVersion)
   {
      u32DynamicSize += LocationDescription.u32GetSize(u16MajorVersion);
   }
   return u32DynamicSize+7;
}

tBool dap_lifi_tclMsgGetEntryListMethodResult::operator==(const dap_lifi_tclMsgGetEntryListMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (Status == rfoCmp.Status);
      bResult = bResult && (Elements.size() == rfoCmp.Elements.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Elements.size()); ++u32Idx)
            bResult = bResult && (Elements[u32Idx] == rfoCmp.Elements[u32Idx]);
      }
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgGetEntryListMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   oIn >> Status;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Elements.size(); ++u32Idx)
      {
         Elements[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Elements.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Elements[u32Idx];
      }
   }
   if (19 <= oIn.u16GetMajorVersion())
   {
      oIn >> LocationDescription;
   }
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgGetEntryListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << Status;
   oOut << (tU32)Elements.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Elements.size(); ++u32Idx)
         oOut << Elements[u32Idx];
   }
   if (19 <= oOut.u16GetMajorVersion())
   {
      oOut << LocationDescription;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetEntryListMethodResultFirst::dap_lifi_tclMsgGetEntryListMethodResultFirst(const dap_lifi_tclMsgGetEntryListMethodResultFirst& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   Status = coRef.Status;
   Elements = coRef.Elements;
   LocationDescription = coRef.LocationDescription;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetEntryListMethodResultFirst& dap_lifi_tclMsgGetEntryListMethodResultFirst::operator=(const dap_lifi_tclMsgGetEntryListMethodResultFirst& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   Status = coRef.Status;
   Elements = coRef.Elements;
   LocationDescription = coRef.LocationDescription;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgGetEntryListMethodResultFirst::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgGetEntryListMethodResultFirst::u16GetFunctionID() const {return DAP_LIFI_C_U16_GETENTRYLIST;}
tU8 dap_lifi_tclMsgGetEntryListMethodResultFirst::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULTFIRST;}

tVoid dap_lifi_tclMsgGetEntryListMethodResultFirst::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Elements.size(); ++u32Idx)
         Elements[u32Idx].vDestroy();
   }
   Elements.clear();
   LocationDescription.vDestroy(); 
}

tU32 dap_lifi_tclMsgGetEntryListMethodResultFirst::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Elements.size(); ++u32ListIdx)
      u32DynamicSize += Elements[u32ListIdx].u32GetSize(u16MajorVersion);
   if (19 <= u16MajorVersion)
   {
      u32DynamicSize += LocationDescription.u32GetSize(u16MajorVersion);
   }
   return u32DynamicSize+7;
}

tBool dap_lifi_tclMsgGetEntryListMethodResultFirst::operator==(const dap_lifi_tclMsgGetEntryListMethodResultFirst& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (Status == rfoCmp.Status);
      bResult = bResult && (Elements.size() == rfoCmp.Elements.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Elements.size()); ++u32Idx)
            bResult = bResult && (Elements[u32Idx] == rfoCmp.Elements[u32Idx]);
      }
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgGetEntryListMethodResultFirst::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   oIn >> Status;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Elements.size(); ++u32Idx)
      {
         Elements[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Elements.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Elements[u32Idx];
      }
   }
   if (19 <= oIn.u16GetMajorVersion())
   {
      oIn >> LocationDescription;
   }
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgGetEntryListMethodResultFirst::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << Status;
   oOut << (tU32)Elements.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Elements.size(); ++u32Idx)
         oOut << Elements[u32Idx];
   }
   if (19 <= oOut.u16GetMajorVersion())
   {
      oOut << LocationDescription;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetEntryListMethodResultMiddle::dap_lifi_tclMsgGetEntryListMethodResultMiddle(const dap_lifi_tclMsgGetEntryListMethodResultMiddle& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   Status = coRef.Status;
   Elements = coRef.Elements;
   LocationDescription = coRef.LocationDescription;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetEntryListMethodResultMiddle& dap_lifi_tclMsgGetEntryListMethodResultMiddle::operator=(const dap_lifi_tclMsgGetEntryListMethodResultMiddle& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   Status = coRef.Status;
   Elements = coRef.Elements;
   LocationDescription = coRef.LocationDescription;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgGetEntryListMethodResultMiddle::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgGetEntryListMethodResultMiddle::u16GetFunctionID() const {return DAP_LIFI_C_U16_GETENTRYLIST;}
tU8 dap_lifi_tclMsgGetEntryListMethodResultMiddle::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULTMIDDLE;}

tVoid dap_lifi_tclMsgGetEntryListMethodResultMiddle::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Elements.size(); ++u32Idx)
         Elements[u32Idx].vDestroy();
   }
   Elements.clear();
   LocationDescription.vDestroy(); 
}

tU32 dap_lifi_tclMsgGetEntryListMethodResultMiddle::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Elements.size(); ++u32ListIdx)
      u32DynamicSize += Elements[u32ListIdx].u32GetSize(u16MajorVersion);
   if (19 <= u16MajorVersion)
   {
      u32DynamicSize += LocationDescription.u32GetSize(u16MajorVersion);
   }
   return u32DynamicSize+7;
}

tBool dap_lifi_tclMsgGetEntryListMethodResultMiddle::operator==(const dap_lifi_tclMsgGetEntryListMethodResultMiddle& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (Status == rfoCmp.Status);
      bResult = bResult && (Elements.size() == rfoCmp.Elements.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Elements.size()); ++u32Idx)
            bResult = bResult && (Elements[u32Idx] == rfoCmp.Elements[u32Idx]);
      }
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgGetEntryListMethodResultMiddle::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   oIn >> Status;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Elements.size(); ++u32Idx)
      {
         Elements[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Elements.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Elements[u32Idx];
      }
   }
   if (19 <= oIn.u16GetMajorVersion())
   {
      oIn >> LocationDescription;
   }
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgGetEntryListMethodResultMiddle::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << Status;
   oOut << (tU32)Elements.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Elements.size(); ++u32Idx)
         oOut << Elements[u32Idx];
   }
   if (19 <= oOut.u16GetMajorVersion())
   {
      oOut << LocationDescription;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetEntryListMethodResultLast::dap_lifi_tclMsgGetEntryListMethodResultLast(const dap_lifi_tclMsgGetEntryListMethodResultLast& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   Status = coRef.Status;
   Elements = coRef.Elements;
   LocationDescription = coRef.LocationDescription;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetEntryListMethodResultLast& dap_lifi_tclMsgGetEntryListMethodResultLast::operator=(const dap_lifi_tclMsgGetEntryListMethodResultLast& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   Status = coRef.Status;
   Elements = coRef.Elements;
   LocationDescription = coRef.LocationDescription;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgGetEntryListMethodResultLast::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgGetEntryListMethodResultLast::u16GetFunctionID() const {return DAP_LIFI_C_U16_GETENTRYLIST;}
tU8 dap_lifi_tclMsgGetEntryListMethodResultLast::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULTLAST;}

tVoid dap_lifi_tclMsgGetEntryListMethodResultLast::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Elements.size(); ++u32Idx)
         Elements[u32Idx].vDestroy();
   }
   Elements.clear();
   LocationDescription.vDestroy(); 
}

tU32 dap_lifi_tclMsgGetEntryListMethodResultLast::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Elements.size(); ++u32ListIdx)
      u32DynamicSize += Elements[u32ListIdx].u32GetSize(u16MajorVersion);
   if (19 <= u16MajorVersion)
   {
      u32DynamicSize += LocationDescription.u32GetSize(u16MajorVersion);
   }
   return u32DynamicSize+7;
}

tBool dap_lifi_tclMsgGetEntryListMethodResultLast::operator==(const dap_lifi_tclMsgGetEntryListMethodResultLast& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (Status == rfoCmp.Status);
      bResult = bResult && (Elements.size() == rfoCmp.Elements.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Elements.size()); ++u32Idx)
            bResult = bResult && (Elements[u32Idx] == rfoCmp.Elements[u32Idx]);
      }
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgGetEntryListMethodResultLast::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   oIn >> Status;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Elements.size(); ++u32Idx)
      {
         Elements[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Elements.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Elements[u32Idx];
      }
   }
   if (19 <= oIn.u16GetMajorVersion())
   {
      oIn >> LocationDescription;
   }
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgGetEntryListMethodResultLast::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << Status;
   oOut << (tU32)Elements.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Elements.size(); ++u32Idx)
         oOut << Elements[u32Idx];
   }
   if (19 <= oOut.u16GetMajorVersion())
   {
      oOut << LocationDescription;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgReadBinaryDestinationMethodStart::dap_lifi_tclMsgReadBinaryDestinationMethodStart(const dap_lifi_tclMsgReadBinaryDestinationMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   MaxNumberOfCells = coRef.MaxNumberOfCells;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgReadBinaryDestinationMethodStart& dap_lifi_tclMsgReadBinaryDestinationMethodStart::operator=(const dap_lifi_tclMsgReadBinaryDestinationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   MaxNumberOfCells = coRef.MaxNumberOfCells;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgReadBinaryDestinationMethodStart::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgReadBinaryDestinationMethodStart::u16GetFunctionID() const {return DAP_LIFI_C_U16_READBINARYDESTINATION;}
tU8 dap_lifi_tclMsgReadBinaryDestinationMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_lifi_tclMsgReadBinaryDestinationMethodStart::vDestroy()
{
   LocationDescription.vDestroy(); 
}

tU32 dap_lifi_tclMsgReadBinaryDestinationMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (16 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+9+LocationDescription.u32GetSize(u16MajorVersion);
}

tBool dap_lifi_tclMsgReadBinaryDestinationMethodStart::operator==(const dap_lifi_tclMsgReadBinaryDestinationMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (UserId == rfoCmp.UserId);
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
      bResult = bResult && (MaxNumberOfCells == rfoCmp.MaxNumberOfCells);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgReadBinaryDestinationMethodStart::oRead(fi_tclInContext& oIn)
{
   if (16 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> DatasetId;
   oIn >> UserId;
   oIn >> UILanguage;
   oIn >> LocationDescription;
   oIn >> MaxNumberOfCells;
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgReadBinaryDestinationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (16 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << DatasetId;
   oOut << UserId;
   oOut << UILanguage;
   oOut << LocationDescription;
   oOut << MaxNumberOfCells;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgReadBinaryDestinationMethodResult::dap_lifi_tclMsgReadBinaryDestinationMethodResult(const dap_lifi_tclMsgReadBinaryDestinationMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   ElementPositions = coRef.ElementPositions;
   AccessCoordinates = coRef.AccessCoordinates;
   Properties = coRef.Properties;
   ClusterList = coRef.ClusterList;
   Category = coRef.Category;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgReadBinaryDestinationMethodResult& dap_lifi_tclMsgReadBinaryDestinationMethodResult::operator=(const dap_lifi_tclMsgReadBinaryDestinationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   ElementPositions = coRef.ElementPositions;
   AccessCoordinates = coRef.AccessCoordinates;
   Properties = coRef.Properties;
   ClusterList = coRef.ClusterList;
   Category = coRef.Category;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgReadBinaryDestinationMethodResult::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgReadBinaryDestinationMethodResult::u16GetFunctionID() const {return DAP_LIFI_C_U16_READBINARYDESTINATION;}
tU8 dap_lifi_tclMsgReadBinaryDestinationMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_lifi_tclMsgReadBinaryDestinationMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ElementPositions.size(); ++u32Idx)
         ElementPositions[u32Idx].vDestroy();
   }
   ElementPositions.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < AccessCoordinates.size(); ++u32Idx)
         AccessCoordinates[u32Idx].vDestroy();
   }
   AccessCoordinates.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterList.size(); ++u32Idx)
         ClusterList[u32Idx].vDestroy();
   }
   ClusterList.clear();
}

tU32 dap_lifi_tclMsgReadBinaryDestinationMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ClusterList.size(); ++u32ListIdx)
      u32DynamicSize += ClusterList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+17+ElementPositions.size()*8+AccessCoordinates.size()*8;
}

tBool dap_lifi_tclMsgReadBinaryDestinationMethodResult::operator==(const dap_lifi_tclMsgReadBinaryDestinationMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (ElementPositions.size() == rfoCmp.ElementPositions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ElementPositions.size()); ++u32Idx)
            bResult = bResult && (ElementPositions[u32Idx] == rfoCmp.ElementPositions[u32Idx]);
      }
      bResult = bResult && (AccessCoordinates.size() == rfoCmp.AccessCoordinates.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AccessCoordinates.size()); ++u32Idx)
            bResult = bResult && (AccessCoordinates[u32Idx] == rfoCmp.AccessCoordinates[u32Idx]);
      }
      bResult = bResult && (Properties == rfoCmp.Properties);
      bResult = bResult && (ClusterList.size() == rfoCmp.ClusterList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClusterList.size()); ++u32Idx)
            bResult = bResult && (ClusterList[u32Idx] == rfoCmp.ClusterList[u32Idx]);
      }
      bResult = bResult && (Category == rfoCmp.Category);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgReadBinaryDestinationMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ElementPositions.size(); ++u32Idx)
      {
         ElementPositions[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ElementPositions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ElementPositions[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AccessCoordinates.size(); ++u32Idx)
      {
         AccessCoordinates[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      AccessCoordinates.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> AccessCoordinates[u32Idx];
      }
   }
   oIn >> Properties;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ClusterList.size(); ++u32Idx)
      {
         ClusterList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ClusterList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ClusterList[u32Idx];
      }
   }
   oIn >> Category;
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgReadBinaryDestinationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << (tU32)ElementPositions.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ElementPositions.size(); ++u32Idx)
         oOut << ElementPositions[u32Idx];
   }
   oOut << (tU32)AccessCoordinates.size();
   {
      for (tU32 u32Idx = 0; u32Idx < AccessCoordinates.size(); ++u32Idx)
         oOut << AccessCoordinates[u32Idx];
   }
   oOut << Properties;
   oOut << (tU32)ClusterList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterList.size(); ++u32Idx)
         oOut << ClusterList[u32Idx];
   }
   oOut << Category;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetObjectDetailMethodStart::dap_lifi_tclMsgGetObjectDetailMethodStart(const dap_lifi_tclMsgGetObjectDetailMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetObjectDetailMethodStart& dap_lifi_tclMsgGetObjectDetailMethodStart::operator=(const dap_lifi_tclMsgGetObjectDetailMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgGetObjectDetailMethodStart::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgGetObjectDetailMethodStart::u16GetFunctionID() const {return DAP_LIFI_C_U16_GETOBJECTDETAIL;}
tU8 dap_lifi_tclMsgGetObjectDetailMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_lifi_tclMsgGetObjectDetailMethodStart::vDestroy()
{
   LocationDescription.vDestroy(); 
}

tU32 dap_lifi_tclMsgGetObjectDetailMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (16 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+7+LocationDescription.u32GetSize(u16MajorVersion);
}

tBool dap_lifi_tclMsgGetObjectDetailMethodStart::operator==(const dap_lifi_tclMsgGetObjectDetailMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (UserId == rfoCmp.UserId);
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgGetObjectDetailMethodStart::oRead(fi_tclInContext& oIn)
{
   if (16 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> DatasetId;
   oIn >> UserId;
   oIn >> UILanguage;
   oIn >> LocationDescription;
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgGetObjectDetailMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (16 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << DatasetId;
   oOut << UserId;
   oOut << UILanguage;
   oOut << LocationDescription;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetObjectDetailMethodResult::dap_lifi_tclMsgGetObjectDetailMethodResult(const dap_lifi_tclMsgGetObjectDetailMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   Information = coRef.Information;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetObjectDetailMethodResult& dap_lifi_tclMsgGetObjectDetailMethodResult::operator=(const dap_lifi_tclMsgGetObjectDetailMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   Information = coRef.Information;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgGetObjectDetailMethodResult::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgGetObjectDetailMethodResult::u16GetFunctionID() const {return DAP_LIFI_C_U16_GETOBJECTDETAIL;}
tU8 dap_lifi_tclMsgGetObjectDetailMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_lifi_tclMsgGetObjectDetailMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Information.size(); ++u32Idx)
         Information[u32Idx].vDestroy();
   }
   Information.clear();
}

tU32 dap_lifi_tclMsgGetObjectDetailMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Information.size(); ++u32ListIdx)
      u32DynamicSize += Information[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6;
}

tBool dap_lifi_tclMsgGetObjectDetailMethodResult::operator==(const dap_lifi_tclMsgGetObjectDetailMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (Information.size() == rfoCmp.Information.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Information.size()); ++u32Idx)
            bResult = bResult && (Information[u32Idx] == rfoCmp.Information[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgGetObjectDetailMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Information.size(); ++u32Idx)
      {
         Information[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Information.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Information[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgGetObjectDetailMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << (tU32)Information.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Information.size(); ++u32Idx)
         oOut << Information[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgResolveLocationDescriptionMethodStart::dap_lifi_tclMsgResolveLocationDescriptionMethodStart(const dap_lifi_tclMsgResolveLocationDescriptionMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   ResolutionType = coRef.ResolutionType;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgResolveLocationDescriptionMethodStart& dap_lifi_tclMsgResolveLocationDescriptionMethodStart::operator=(const dap_lifi_tclMsgResolveLocationDescriptionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   ResolutionType = coRef.ResolutionType;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgResolveLocationDescriptionMethodStart::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgResolveLocationDescriptionMethodStart::u16GetFunctionID() const {return DAP_LIFI_C_U16_RESOLVELOCATIONDESCRIPTION;}
tU8 dap_lifi_tclMsgResolveLocationDescriptionMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_lifi_tclMsgResolveLocationDescriptionMethodStart::vDestroy()
{
   LocationDescription.vDestroy(); 
}

tU32 dap_lifi_tclMsgResolveLocationDescriptionMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (16 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+8+LocationDescription.u32GetSize(u16MajorVersion);
}

tBool dap_lifi_tclMsgResolveLocationDescriptionMethodStart::operator==(const dap_lifi_tclMsgResolveLocationDescriptionMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (UserId == rfoCmp.UserId);
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
      bResult = bResult && (ResolutionType == rfoCmp.ResolutionType);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgResolveLocationDescriptionMethodStart::oRead(fi_tclInContext& oIn)
{
   if (16 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> DatasetId;
   oIn >> UserId;
   oIn >> UILanguage;
   oIn >> LocationDescription;
   oIn >> ResolutionType;
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgResolveLocationDescriptionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (16 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << DatasetId;
   oOut << UserId;
   oOut << UILanguage;
   oOut << LocationDescription;
   oOut << ResolutionType;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgResolveLocationDescriptionMethodResult::dap_lifi_tclMsgResolveLocationDescriptionMethodResult(const dap_lifi_tclMsgResolveLocationDescriptionMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgResolveLocationDescriptionMethodResult& dap_lifi_tclMsgResolveLocationDescriptionMethodResult::operator=(const dap_lifi_tclMsgResolveLocationDescriptionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgResolveLocationDescriptionMethodResult::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgResolveLocationDescriptionMethodResult::u16GetFunctionID() const {return DAP_LIFI_C_U16_RESOLVELOCATIONDESCRIPTION;}
tU8 dap_lifi_tclMsgResolveLocationDescriptionMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_lifi_tclMsgResolveLocationDescriptionMethodResult::vDestroy()
{
   LocationDescription.vDestroy(); 
}

tU32 dap_lifi_tclMsgResolveLocationDescriptionMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+LocationDescription.u32GetSize(u16MajorVersion);
}

tBool dap_lifi_tclMsgResolveLocationDescriptionMethodResult::operator==(const dap_lifi_tclMsgResolveLocationDescriptionMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgResolveLocationDescriptionMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   oIn >> LocationDescription;
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgResolveLocationDescriptionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << LocationDescription;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgReadLanguagesMethodStart::dap_lifi_tclMsgReadLanguagesMethodStart(const dap_lifi_tclMsgReadLanguagesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgReadLanguagesMethodStart& dap_lifi_tclMsgReadLanguagesMethodStart::operator=(const dap_lifi_tclMsgReadLanguagesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgReadLanguagesMethodStart::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgReadLanguagesMethodStart::u16GetFunctionID() const {return DAP_LIFI_C_U16_READLANGUAGES;}
tU8 dap_lifi_tclMsgReadLanguagesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 dap_lifi_tclMsgReadLanguagesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (16 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+5;
}

tBool dap_lifi_tclMsgReadLanguagesMethodStart::operator==(const dap_lifi_tclMsgReadLanguagesMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (UserId == rfoCmp.UserId);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgReadLanguagesMethodStart::oRead(fi_tclInContext& oIn)
{
   if (16 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> DatasetId;
   oIn >> UserId;
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgReadLanguagesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (16 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << DatasetId;
   oOut << UserId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgReadLanguagesMethodResult::dap_lifi_tclMsgReadLanguagesMethodResult(const dap_lifi_tclMsgReadLanguagesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   CurrentLanguage = coRef.CurrentLanguage;
   AvailableLanguages = coRef.AvailableLanguages;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgReadLanguagesMethodResult& dap_lifi_tclMsgReadLanguagesMethodResult::operator=(const dap_lifi_tclMsgReadLanguagesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   CurrentLanguage = coRef.CurrentLanguage;
   AvailableLanguages = coRef.AvailableLanguages;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgReadLanguagesMethodResult::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgReadLanguagesMethodResult::u16GetFunctionID() const {return DAP_LIFI_C_U16_READLANGUAGES;}
tU8 dap_lifi_tclMsgReadLanguagesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_lifi_tclMsgReadLanguagesMethodResult::vDestroy()
{
   AvailableLanguages.clear();
}

tU32 dap_lifi_tclMsgReadLanguagesMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+AvailableLanguages.size()*2;
}

tBool dap_lifi_tclMsgReadLanguagesMethodResult::operator==(const dap_lifi_tclMsgReadLanguagesMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CurrentLanguage == rfoCmp.CurrentLanguage);
      bResult = bResult && (AvailableLanguages.size() == rfoCmp.AvailableLanguages.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AvailableLanguages.size()); ++u32Idx)
            bResult = bResult && (AvailableLanguages[u32Idx] == rfoCmp.AvailableLanguages[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgReadLanguagesMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> CurrentLanguage;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      AvailableLanguages.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> AvailableLanguages[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgReadLanguagesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CurrentLanguage;
   oOut << (tU32)AvailableLanguages.size();
   {
      for (tU32 u32Idx = 0; u32Idx < AvailableLanguages.size(); ++u32Idx)
         oOut << AvailableLanguages[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgSetCurrentLanguageMethodStart::dap_lifi_tclMsgSetCurrentLanguageMethodStart(const dap_lifi_tclMsgSetCurrentLanguageMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
   NewLanguage = coRef.NewLanguage;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgSetCurrentLanguageMethodStart& dap_lifi_tclMsgSetCurrentLanguageMethodStart::operator=(const dap_lifi_tclMsgSetCurrentLanguageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
   NewLanguage = coRef.NewLanguage;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgSetCurrentLanguageMethodStart::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgSetCurrentLanguageMethodStart::u16GetFunctionID() const {return DAP_LIFI_C_U16_SETCURRENTLANGUAGE;}
tU8 dap_lifi_tclMsgSetCurrentLanguageMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 dap_lifi_tclMsgSetCurrentLanguageMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (16 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+7;
}

tBool dap_lifi_tclMsgSetCurrentLanguageMethodStart::operator==(const dap_lifi_tclMsgSetCurrentLanguageMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (UserId == rfoCmp.UserId);
      bResult = bResult && (NewLanguage == rfoCmp.NewLanguage);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgSetCurrentLanguageMethodStart::oRead(fi_tclInContext& oIn)
{
   if (16 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> DatasetId;
   oIn >> UserId;
   oIn >> NewLanguage;
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgSetCurrentLanguageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (16 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << DatasetId;
   oOut << UserId;
   oOut << NewLanguage;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgSetCurrentLanguageMethodResult::dap_lifi_tclMsgSetCurrentLanguageMethodResult(const dap_lifi_tclMsgSetCurrentLanguageMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   CurrentLanguage = coRef.CurrentLanguage;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgSetCurrentLanguageMethodResult& dap_lifi_tclMsgSetCurrentLanguageMethodResult::operator=(const dap_lifi_tclMsgSetCurrentLanguageMethodResult& coRef)
{
   if (this == &coRef) return *this;
   CurrentLanguage = coRef.CurrentLanguage;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgSetCurrentLanguageMethodResult::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgSetCurrentLanguageMethodResult::u16GetFunctionID() const {return DAP_LIFI_C_U16_SETCURRENTLANGUAGE;}
tU8 dap_lifi_tclMsgSetCurrentLanguageMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 dap_lifi_tclMsgSetCurrentLanguageMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool dap_lifi_tclMsgSetCurrentLanguageMethodResult::operator==(const dap_lifi_tclMsgSetCurrentLanguageMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CurrentLanguage == rfoCmp.CurrentLanguage);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgSetCurrentLanguageMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> CurrentLanguage;
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgSetCurrentLanguageMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CurrentLanguage;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetDataSetsMethodStart::dap_lifi_tclMsgGetDataSetsMethodStart(const dap_lifi_tclMsgGetDataSetsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   UnusedUserId = coRef.UnusedUserId;
   UILanguage = coRef.UILanguage;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetDataSetsMethodStart& dap_lifi_tclMsgGetDataSetsMethodStart::operator=(const dap_lifi_tclMsgGetDataSetsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   UnusedUserId = coRef.UnusedUserId;
   UILanguage = coRef.UILanguage;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgGetDataSetsMethodStart::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgGetDataSetsMethodStart::u16GetFunctionID() const {return DAP_LIFI_C_U16_GETDATASETS;}
tU8 dap_lifi_tclMsgGetDataSetsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 dap_lifi_tclMsgGetDataSetsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (16 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+3;
}

tBool dap_lifi_tclMsgGetDataSetsMethodStart::operator==(const dap_lifi_tclMsgGetDataSetsMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (UnusedUserId == rfoCmp.UnusedUserId);
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgGetDataSetsMethodStart::oRead(fi_tclInContext& oIn)
{
   if (16 <= oIn.u16GetMajorVersion())
   {
      oIn >> u8OrderType;
   }
   oIn >> UnusedUserId;
   oIn >> UILanguage;
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgGetDataSetsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   if (16 <= oOut.u16GetMajorVersion())
   {
      oOut << u8OrderType;
   }
   oOut << UnusedUserId;
   oOut << UILanguage;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetDataSetsMethodResult::dap_lifi_tclMsgGetDataSetsMethodResult(const dap_lifi_tclMsgGetDataSetsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   DataSets = coRef.DataSets;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetDataSetsMethodResult& dap_lifi_tclMsgGetDataSetsMethodResult::operator=(const dap_lifi_tclMsgGetDataSetsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DataSets = coRef.DataSets;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgGetDataSetsMethodResult::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgGetDataSetsMethodResult::u16GetFunctionID() const {return DAP_LIFI_C_U16_GETDATASETS;}
tU8 dap_lifi_tclMsgGetDataSetsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_lifi_tclMsgGetDataSetsMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DataSets.size(); ++u32Idx)
         DataSets[u32Idx].vDestroy();
   }
   DataSets.clear();
}

tU32 dap_lifi_tclMsgGetDataSetsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DataSets.size(); ++u32ListIdx)
      u32DynamicSize += DataSets[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool dap_lifi_tclMsgGetDataSetsMethodResult::operator==(const dap_lifi_tclMsgGetDataSetsMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (DataSets.size() == rfoCmp.DataSets.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DataSets.size()); ++u32Idx)
            bResult = bResult && (DataSets[u32Idx] == rfoCmp.DataSets[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgGetDataSetsMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DataSets.size(); ++u32Idx)
      {
         DataSets[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      DataSets.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> DataSets[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgGetDataSetsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)DataSets.size();
   {
      for (tU32 u32Idx = 0; u32Idx < DataSets.size(); ++u32Idx)
         oOut << DataSets[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetAddressFormatMethodStart::dap_lifi_tclMsgGetAddressFormatMethodStart(const dap_lifi_tclMsgGetAddressFormatMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
   LocationDescription = coRef.LocationDescription;
   UILanguage = coRef.UILanguage;
   CurrentPositionInfo = coRef.CurrentPositionInfo;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetAddressFormatMethodStart& dap_lifi_tclMsgGetAddressFormatMethodStart::operator=(const dap_lifi_tclMsgGetAddressFormatMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
   LocationDescription = coRef.LocationDescription;
   UILanguage = coRef.UILanguage;
   CurrentPositionInfo = coRef.CurrentPositionInfo;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgGetAddressFormatMethodStart::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgGetAddressFormatMethodStart::u16GetFunctionID() const {return DAP_LIFI_C_U16_GETADDRESSFORMAT;}
tU8 dap_lifi_tclMsgGetAddressFormatMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_lifi_tclMsgGetAddressFormatMethodStart::vDestroy()
{
   LocationDescription.vDestroy(); 
   CurrentPositionInfo.vDestroy(); 
}

tU32 dap_lifi_tclMsgGetAddressFormatMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+LocationDescription.u32GetSize(u16MajorVersion)+CurrentPositionInfo.u32GetSize(u16MajorVersion);
}

tBool dap_lifi_tclMsgGetAddressFormatMethodStart::operator==(const dap_lifi_tclMsgGetAddressFormatMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (UserId == rfoCmp.UserId);
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (CurrentPositionInfo == rfoCmp.CurrentPositionInfo);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgGetAddressFormatMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> u8OrderType;
   oIn >> DatasetId;
   oIn >> UserId;
   oIn >> LocationDescription;
   oIn >> UILanguage;
   oIn >> CurrentPositionInfo;
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgGetAddressFormatMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8OrderType;
   oOut << DatasetId;
   oOut << UserId;
   oOut << LocationDescription;
   oOut << UILanguage;
   oOut << CurrentPositionInfo;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetAddressFormatMethodResult::dap_lifi_tclMsgGetAddressFormatMethodResult(const dap_lifi_tclMsgGetAddressFormatMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   SelectionCriteriaList = coRef.SelectionCriteriaList;
   UILanguage = coRef.UILanguage;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetAddressFormatMethodResult& dap_lifi_tclMsgGetAddressFormatMethodResult::operator=(const dap_lifi_tclMsgGetAddressFormatMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SelectionCriteriaList = coRef.SelectionCriteriaList;
   UILanguage = coRef.UILanguage;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgGetAddressFormatMethodResult::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgGetAddressFormatMethodResult::u16GetFunctionID() const {return DAP_LIFI_C_U16_GETADDRESSFORMAT;}
tU8 dap_lifi_tclMsgGetAddressFormatMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_lifi_tclMsgGetAddressFormatMethodResult::vDestroy()
{
   SelectionCriteriaList.clear();
}

tU32 dap_lifi_tclMsgGetAddressFormatMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+SelectionCriteriaList.size()*2;
}

tBool dap_lifi_tclMsgGetAddressFormatMethodResult::operator==(const dap_lifi_tclMsgGetAddressFormatMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SelectionCriteriaList.size() == rfoCmp.SelectionCriteriaList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SelectionCriteriaList.size()); ++u32Idx)
            bResult = bResult && (SelectionCriteriaList[u32Idx] == rfoCmp.SelectionCriteriaList[u32Idx]);
      }
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgGetAddressFormatMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      SelectionCriteriaList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SelectionCriteriaList[u32Idx];
      }
   }
   oIn >> UILanguage;
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgGetAddressFormatMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)SelectionCriteriaList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SelectionCriteriaList.size(); ++u32Idx)
         oOut << SelectionCriteriaList[u32Idx];
   }
   oOut << UILanguage;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodStart::dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodStart(const dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   MaxRadius = coRef.MaxRadius;
   CurrentPositionInfo = coRef.CurrentPositionInfo;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodStart& dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodStart::operator=(const dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
   UILanguage = coRef.UILanguage;
   LocationDescription = coRef.LocationDescription;
   MaxRadius = coRef.MaxRadius;
   CurrentPositionInfo = coRef.CurrentPositionInfo;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodStart::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodStart::u16GetFunctionID() const {return DAP_LIFI_C_U16_GETNEARBYSTATESORCOUNTRIES;}
tU8 dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodStart::vDestroy()
{
   LocationDescription.vDestroy(); 
   CurrentPositionInfo.vDestroy(); 
}

tU32 dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 12+LocationDescription.u32GetSize(u16MajorVersion)+CurrentPositionInfo.u32GetSize(u16MajorVersion);
}

tBool dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodStart::operator==(const dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (UserId == rfoCmp.UserId);
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (LocationDescription == rfoCmp.LocationDescription);
      bResult = bResult && (MaxRadius == rfoCmp.MaxRadius);
      bResult = bResult && (CurrentPositionInfo == rfoCmp.CurrentPositionInfo);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> u8OrderType;
   oIn >> DatasetId;
   oIn >> UserId;
   oIn >> UILanguage;
   oIn >> LocationDescription;
   oIn >> MaxRadius;
   oIn >> CurrentPositionInfo;
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8OrderType;
   oOut << DatasetId;
   oOut << UserId;
   oOut << UILanguage;
   oOut << LocationDescription;
   oOut << MaxRadius;
   oOut << CurrentPositionInfo;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodResult::dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodResult(const dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UILanguage = coRef.UILanguage;
   Elements = coRef.Elements;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodResult& dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodResult::operator=(const dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UILanguage = coRef.UILanguage;
   Elements = coRef.Elements;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodResult::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodResult::u16GetFunctionID() const {return DAP_LIFI_C_U16_GETNEARBYSTATESORCOUNTRIES;}
tU8 dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Elements.size(); ++u32Idx)
         Elements[u32Idx].vDestroy();
   }
   Elements.clear();
}

tU32 dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Elements.size(); ++u32ListIdx)
      u32DynamicSize += Elements[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6;
}

tBool dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodResult::operator==(const dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UILanguage == rfoCmp.UILanguage);
      bResult = bResult && (Elements.size() == rfoCmp.Elements.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Elements.size()); ++u32Idx)
            bResult = bResult && (Elements[u32Idx] == rfoCmp.Elements[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UILanguage;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Elements.size(); ++u32Idx)
      {
         Elements[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Elements.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Elements[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgGetNearbyStatesOrCountriesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UILanguage;
   oOut << (tU32)Elements.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Elements.size(); ++u32Idx)
         oOut << Elements[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetAddressFormatTableMethodStart::dap_lifi_tclMsgGetAddressFormatTableMethodStart(const dap_lifi_tclMsgGetAddressFormatTableMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetAddressFormatTableMethodStart& dap_lifi_tclMsgGetAddressFormatTableMethodStart::operator=(const dap_lifi_tclMsgGetAddressFormatTableMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8OrderType = coRef.u8OrderType;
   DatasetId = coRef.DatasetId;
   UserId = coRef.UserId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgGetAddressFormatTableMethodStart::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgGetAddressFormatTableMethodStart::u16GetFunctionID() const {return DAP_LIFI_C_U16_GETADDRESSFORMATTABLE;}
tU8 dap_lifi_tclMsgGetAddressFormatTableMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 dap_lifi_tclMsgGetAddressFormatTableMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

tBool dap_lifi_tclMsgGetAddressFormatTableMethodStart::operator==(const dap_lifi_tclMsgGetAddressFormatTableMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u8OrderType == rfoCmp.u8OrderType);
      bResult = bResult && (DatasetId == rfoCmp.DatasetId);
      bResult = bResult && (UserId == rfoCmp.UserId);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgGetAddressFormatTableMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> u8OrderType;
   oIn >> DatasetId;
   oIn >> UserId;
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgGetAddressFormatTableMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u8OrderType;
   oOut << DatasetId;
   oOut << UserId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetAddressFormatTableMethodResult::dap_lifi_tclMsgGetAddressFormatTableMethodResult(const dap_lifi_tclMsgGetAddressFormatTableMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   Templates = coRef.Templates;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgGetAddressFormatTableMethodResult& dap_lifi_tclMsgGetAddressFormatTableMethodResult::operator=(const dap_lifi_tclMsgGetAddressFormatTableMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Templates = coRef.Templates;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgGetAddressFormatTableMethodResult::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgGetAddressFormatTableMethodResult::u16GetFunctionID() const {return DAP_LIFI_C_U16_GETADDRESSFORMATTABLE;}
tU8 dap_lifi_tclMsgGetAddressFormatTableMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_lifi_tclMsgGetAddressFormatTableMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Templates.size(); ++u32Idx)
         Templates[u32Idx].vDestroy();
   }
   Templates.clear();
}

tU32 dap_lifi_tclMsgGetAddressFormatTableMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Templates.size(); ++u32ListIdx)
      u32DynamicSize += Templates[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool dap_lifi_tclMsgGetAddressFormatTableMethodResult::operator==(const dap_lifi_tclMsgGetAddressFormatTableMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Templates.size() == rfoCmp.Templates.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Templates.size()); ++u32Idx)
            bResult = bResult && (Templates[u32Idx] == rfoCmp.Templates[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgGetAddressFormatTableMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Templates.size(); ++u32Idx)
      {
         Templates[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Templates.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Templates[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgGetAddressFormatTableMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)Templates.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Templates.size(); ++u32Idx)
         oOut << Templates[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgCurrentSearchProgressStatus::dap_lifi_tclMsgCurrentSearchProgressStatus(const dap_lifi_tclMsgCurrentSearchProgressStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Radius = coRef.Radius;
   ObjectCount = coRef.ObjectCount;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_lifi_tclMsgCurrentSearchProgressStatus& dap_lifi_tclMsgCurrentSearchProgressStatus::operator=(const dap_lifi_tclMsgCurrentSearchProgressStatus& coRef)
{
   if (this == &coRef) return *this;
   Radius = coRef.Radius;
   ObjectCount = coRef.ObjectCount;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_lifi_tclMsgCurrentSearchProgressStatus::u16GetServiceID() const {return DAP_LIFI_C_U16_SERVICE_ID;}
tU16 dap_lifi_tclMsgCurrentSearchProgressStatus::u16GetFunctionID() const {return DAP_LIFI_C_U16_CURRENTSEARCHPROGRESS;}
tU8 dap_lifi_tclMsgCurrentSearchProgressStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 dap_lifi_tclMsgCurrentSearchProgressStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool dap_lifi_tclMsgCurrentSearchProgressStatus::operator==(const dap_lifi_tclMsgCurrentSearchProgressStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Radius == rfoCmp.Radius);
      bResult = bResult && (ObjectCount == rfoCmp.ObjectCount);
   return bResult;
}

fi_tclInContext& dap_lifi_tclMsgCurrentSearchProgressStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Radius;
   oIn >> ObjectCount;
   return oIn;
}

fi_tclOutContext& dap_lifi_tclMsgCurrentSearchProgressStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Radius;
   oOut << ObjectCount;
   return oOut;
}

