#include "precompiled.hh"

tBool dap_lifi_tclDescription::bInitMessage(dap_lifi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case dap_lifi_tclToken::EN_LAST_TOKEN:
   case dap_lifi_tclToken::EN_LIST:
   case dap_lifi_tclToken::EN_END_OF_STRUCT:
   case dap_lifi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case dap_lifi_tclToken::EN_MSG_CLOSECONTEXTMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_USERID,dap_lifi_tclSemanticDomain::EN_MSG_USERID));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32,dap_lifi_tclSemanticDomain::EN_MSG_DATASETID));
      if (16 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_DAPORDERTYPE,dap_lifi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case dap_lifi_tclToken::EN_MSG_CLOSECONTEXTMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_USERID,dap_lifi_tclSemanticDomain::EN_MSG_UNUSEDUSERID));
   } break;
   case dap_lifi_tclToken::EN_MSG_GETOBJECTSMETHODSTART:
   {
      if (19 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_B8_CRITERIAGETOPTIONS,dap_lifi_tclSemanticDomain::EN_MSG_GETOPTION));
      }
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_B8_SELECTIONCRITERIAMASK,dap_lifi_tclSemanticDomain::EN_MSG_SELECTIONCRITERIAMASK));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LOCATIONDESCRIPTION,dap_lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_USERID,dap_lifi_tclSemanticDomain::EN_MSG_USERID));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32,dap_lifi_tclSemanticDomain::EN_MSG_DATASETID));
      if (16 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_DAPORDERTYPE,dap_lifi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case dap_lifi_tclToken::EN_MSG_GETOBJECTSMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_B8_INPUTCONTINUATION,dap_lifi_tclSemanticDomain::EN_MSG_INPUTCONTINUATIONMASK));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_DAPISELECTABLECRITERION,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_MSG_SELECTIONCRITERIALIST));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case dap_lifi_tclToken::EN_MSG_GETOBJECTDESCRIPTIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U16,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_MSG_OBJECTCODELIST));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_B8_REFINEMENTCRITERIAMASK,dap_lifi_tclSemanticDomain::EN_MSG_REFINEMENTCRITERIAMASK));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_USERID,dap_lifi_tclSemanticDomain::EN_MSG_USERID));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32,dap_lifi_tclSemanticDomain::EN_MSG_DATASETID));
      if (16 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_DAPORDERTYPE,dap_lifi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case dap_lifi_tclToken::EN_MSG_GETOBJECTDESCRIPTIONMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_OBJECTDESCRIPTION,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_MSG_OBJECTDESCRIPTIONLIST));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case dap_lifi_tclToken::EN_MSG_GETELEMENTNUMBERMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32,dap_lifi_tclSemanticDomain::EN_MSG_MAXNUMBEROFELEMENTS));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U16,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_MSG_FILTERATTRIBUTES));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LOCATIONDESCRIPTION,dap_lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_USERID,dap_lifi_tclSemanticDomain::EN_MSG_USERID));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32,dap_lifi_tclSemanticDomain::EN_MSG_DATASETID));
      if (16 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_DAPORDERTYPE,dap_lifi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case dap_lifi_tclToken::EN_MSG_GETELEMENTNUMBERMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32,dap_lifi_tclSemanticDomain::EN_MSG_NUMBEROFELEMENTS));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case dap_lifi_tclToken::EN_MSG_GETASFCHARACTERSMETHODSTART:
   {
      if (27 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_POSITIONWGS84,dap_lifi_tclSemanticDomain::EN_MSG_SORTREFERENCEPOSITION));
      }
      if (13 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_BOOL,dap_lifi_tclSemanticDomain::EN_MSG_LOWERCASELETTERS));
      }
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_BOOL,dap_lifi_tclSemanticDomain::EN_MSG_ALLCHARSINCOUNTRY));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_BOOL,dap_lifi_tclSemanticDomain::EN_MSG_PARTIALNAMEROTATION));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U16,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_MSG_ATTRIBUTECODES));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LOCATIONDESCRIPTION,dap_lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_USERID,dap_lifi_tclSemanticDomain::EN_MSG_USERID));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32,dap_lifi_tclSemanticDomain::EN_MSG_DATASETID));
      if (16 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_DAPORDERTYPE,dap_lifi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case dap_lifi_tclToken::EN_MSG_GETASFCHARACTERSMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_STRING,dap_lifi_tclSemanticDomain::EN_MSG_SUBSEQUENTLETTERS));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_STRING,dap_lifi_tclSemanticDomain::EN_MSG_COMPLETIONSTRING));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32,dap_lifi_tclSemanticDomain::EN_MSG_REMAININGENTRIES));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_BOOL,dap_lifi_tclSemanticDomain::EN_MSG_STATUS));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case dap_lifi_tclToken::EN_MSG_GETENTRYLISTMETHODSTART:
   {
      if (19 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LOCATIONDESCRIPTION,dap_lifi_tclSemanticDomain::EN_MSG_CURRENTPOSITIONINFO));
      }
      if (19 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_S32_METER,dap_lifi_tclSemanticDomain::EN_MSG_MAXRADIUS));
      }
      if (15 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32,dap_lifi_tclSemanticDomain::EN_MSG_NOMATCHINGCHARS));
      }
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U16,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_MSG_FILTERATTRIBUTES));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_POSITIONWGS84,dap_lifi_tclSemanticDomain::EN_MSG_SORTREFERENCEPOSITION));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32,dap_lifi_tclSemanticDomain::EN_MSG_LIMIT));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_S32,dap_lifi_tclSemanticDomain::EN_MSG_LISTOFFSET));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_B8_LISTSORTOPTIONS,dap_lifi_tclSemanticDomain::EN_MSG_SORTORDER));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_B8_LISTGETOPTIONS,dap_lifi_tclSemanticDomain::EN_MSG_STATUS));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LOCATIONDESCRIPTION,dap_lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_USERID,dap_lifi_tclSemanticDomain::EN_MSG_USERID));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32,dap_lifi_tclSemanticDomain::EN_MSG_DATASETID));
      if (16 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_DAPORDERTYPE,dap_lifi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case dap_lifi_tclToken::EN_MSG_GETENTRYLISTMETHODRESULT:
   {
      if (19 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LOCATIONDESCRIPTION,dap_lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
      }
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LISTELEMENT,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_MSG_ELEMENTS));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_B8_LISTRESULTOPTIONS,dap_lifi_tclSemanticDomain::EN_MSG_STATUS));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case dap_lifi_tclToken::EN_MSG_GETENTRYLISTMETHODRESULTFIRST:
   {
      if (19 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LOCATIONDESCRIPTION,dap_lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
      }
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LISTELEMENT,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_MSG_ELEMENTS));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_B8_LISTRESULTOPTIONS,dap_lifi_tclSemanticDomain::EN_MSG_STATUS));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case dap_lifi_tclToken::EN_MSG_GETENTRYLISTMETHODRESULTMIDDLE:
   {
      if (19 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LOCATIONDESCRIPTION,dap_lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
      }
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LISTELEMENT,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_MSG_ELEMENTS));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_B8_LISTRESULTOPTIONS,dap_lifi_tclSemanticDomain::EN_MSG_STATUS));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case dap_lifi_tclToken::EN_MSG_GETENTRYLISTMETHODRESULTLAST:
   {
      if (19 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LOCATIONDESCRIPTION,dap_lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
      }
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LISTELEMENT,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_MSG_ELEMENTS));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_B8_LISTRESULTOPTIONS,dap_lifi_tclSemanticDomain::EN_MSG_STATUS));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case dap_lifi_tclToken::EN_MSG_READBINARYDESTINATIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U16,dap_lifi_tclSemanticDomain::EN_MSG_MAXNUMBEROFCELLS));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LOCATIONDESCRIPTION,dap_lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_USERID,dap_lifi_tclSemanticDomain::EN_MSG_USERID));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32,dap_lifi_tclSemanticDomain::EN_MSG_DATASETID));
      if (16 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_DAPORDERTYPE,dap_lifi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case dap_lifi_tclToken::EN_MSG_READBINARYDESTINATIONMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_SELECTIONCRITERIONTYPE,dap_lifi_tclSemanticDomain::EN_MSG_CATEGORY));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_CLUSTERINFO,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_MSG_CLUSTERLIST));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_B8_NAVBINPROPERTIES,dap_lifi_tclSemanticDomain::EN_MSG_PROPERTIES));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_POSITIONWGS84,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_MSG_ACCESSCOORDINATES));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_POSITIONWGS84,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_MSG_ELEMENTPOSITIONS));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case dap_lifi_tclToken::EN_MSG_GETOBJECTDETAILMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LOCATIONDESCRIPTION,dap_lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_USERID,dap_lifi_tclSemanticDomain::EN_MSG_USERID));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32,dap_lifi_tclSemanticDomain::EN_MSG_DATASETID));
      if (16 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_DAPORDERTYPE,dap_lifi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case dap_lifi_tclToken::EN_MSG_GETOBJECTDETAILMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_OBJECTDETAIL,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_MSG_INFORMATION));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case dap_lifi_tclToken::EN_MSG_RESOLVELOCATIONDESCRIPTIONMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_B8_RESOLUTIONTYPE,dap_lifi_tclSemanticDomain::EN_MSG_RESOLUTIONTYPE));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LOCATIONDESCRIPTION,dap_lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_USERID,dap_lifi_tclSemanticDomain::EN_MSG_USERID));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32,dap_lifi_tclSemanticDomain::EN_MSG_DATASETID));
      if (16 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_DAPORDERTYPE,dap_lifi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case dap_lifi_tclToken::EN_MSG_RESOLVELOCATIONDESCRIPTIONMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LOCATIONDESCRIPTION,dap_lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case dap_lifi_tclToken::EN_MSG_READLANGUAGESMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_USERID,dap_lifi_tclSemanticDomain::EN_MSG_USERID));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32,dap_lifi_tclSemanticDomain::EN_MSG_DATASETID));
      if (16 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_DAPORDERTYPE,dap_lifi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case dap_lifi_tclToken::EN_MSG_READLANGUAGESMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_MSG_AVAILABLELANGUAGES));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_CURRENTLANGUAGE));
   } break;
   case dap_lifi_tclToken::EN_MSG_SETCURRENTLANGUAGEMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_NEWLANGUAGE));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_USERID,dap_lifi_tclSemanticDomain::EN_MSG_USERID));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32,dap_lifi_tclSemanticDomain::EN_MSG_DATASETID));
      if (16 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_DAPORDERTYPE,dap_lifi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case dap_lifi_tclToken::EN_MSG_SETCURRENTLANGUAGEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_CURRENTLANGUAGE));
   } break;
   case dap_lifi_tclToken::EN_MSG_GETDATASETSMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_USERID,dap_lifi_tclSemanticDomain::EN_MSG_UNUSEDUSERID));
      if (16 <= poOutContext->u16GetMajorVersion())
      {
         bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_DAPORDERTYPE,dap_lifi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
      }
   } break;
   case dap_lifi_tclToken::EN_MSG_GETDATASETSMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_DATASETELEMENT,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_MSG_DATASETS));
   } break;
   case dap_lifi_tclToken::EN_MSG_GETADDRESSFORMATMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LOCATIONDESCRIPTION,dap_lifi_tclSemanticDomain::EN_MSG_CURRENTPOSITIONINFO));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LOCATIONDESCRIPTION,dap_lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_USERID,dap_lifi_tclSemanticDomain::EN_MSG_USERID));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32,dap_lifi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_DAPORDERTYPE,dap_lifi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
   } break;
   case dap_lifi_tclToken::EN_MSG_GETADDRESSFORMATMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_SELECTIONCRITERIONTYPE,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_MSG_SELECTIONCRITERIALIST));
   } break;
   case dap_lifi_tclToken::EN_MSG_GETNEARBYSTATESORCOUNTRIESMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LOCATIONDESCRIPTION,dap_lifi_tclSemanticDomain::EN_MSG_CURRENTPOSITIONINFO));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_S32_METER,dap_lifi_tclSemanticDomain::EN_MSG_MAXRADIUS));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LOCATIONDESCRIPTION,dap_lifi_tclSemanticDomain::EN_MSG_LOCATIONDESCRIPTION));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_USERID,dap_lifi_tclSemanticDomain::EN_MSG_USERID));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32,dap_lifi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_DAPORDERTYPE,dap_lifi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
   } break;
   case dap_lifi_tclToken::EN_MSG_GETNEARBYSTATESORCOUNTRIESMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LISTELEMENT,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_MSG_ELEMENTS));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE,dap_lifi_tclSemanticDomain::EN_MSG_UILANGUAGE));
   } break;
   case dap_lifi_tclToken::EN_MSG_GETADDRESSFORMATTABLEMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_USERID,dap_lifi_tclSemanticDomain::EN_MSG_USERID));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32,dap_lifi_tclSemanticDomain::EN_MSG_DATASETID));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_DAPORDERTYPE,dap_lifi_tclSemanticDomain::EN_MSG_U8ORDERTYPE));
   } break;
   case dap_lifi_tclToken::EN_MSG_GETADDRESSFORMATTABLEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_ADDRESSTEMPLATE,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_MSG_TEMPLATES));
   } break;
   case dap_lifi_tclToken::EN_MSG_CURRENTSEARCHPROGRESSSTATUS:
   {
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32,dap_lifi_tclSemanticDomain::EN_MSG_OBJECTCOUNT));
      bResult &= oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_S32_METER,dap_lifi_tclSemanticDomain::EN_MSG_RADIUS));
   } break;
   case dap_lifi_tclToken::EN_BINCONTAINER:
   case dap_lifi_tclToken::EN_RESERVED:
   case dap_lifi_tclToken::EN_U16_INDEXINREFERENCELIST:
   case dap_lifi_tclToken::EN_S32_METER:
   case dap_lifi_tclToken::EN_S16_CENTIMETERSECOND:
   case dap_lifi_tclToken::EN_FIVERSION:
   case dap_lifi_tclToken::EN_S32_LONGITUDE:
   case dap_lifi_tclToken::EN_S32_LATITUDE:
   case dap_lifi_tclToken::EN_POSITIONWGS84:
   case dap_lifi_tclToken::EN_E16_ISOCOUNTRYCODE:
   case dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE:
   case dap_lifi_tclToken::EN_U8_DIRECTIONABSOLUTE:
   case dap_lifi_tclToken::EN_E8_BINCONTAINERTYPES:
   case dap_lifi_tclToken::EN_B16_POSITIONRELIABILITY:
   case dap_lifi_tclToken::EN_POSITIONHEADINGSPEED:
   case dap_lifi_tclToken::EN_U32_DATASETID:
   case dap_lifi_tclToken::EN_NAVCLUSTERDESC:
   case dap_lifi_tclToken::EN_E8_NAVONECELLDIRECTION:
   case dap_lifi_tclToken::EN_NAVONECELLDESC:
   case dap_lifi_tclToken::EN_E8_SIDEINFO:
   case dap_lifi_tclToken::EN_S32_EMU:
   case dap_lifi_tclToken::EN_NAVZEROCELLDESC:
   case dap_lifi_tclToken::EN_E8_NAVLOCATIONDESCTYPE:
   case dap_lifi_tclToken::EN_NAVLOCATIONDESC:
   case dap_lifi_tclToken::EN_NAVLOCATIONDESCUNION0:
   case dap_lifi_tclToken::EN_NAVLOCATIONBINCONTAINER:
   case dap_lifi_tclToken::EN_E8_NAVINDEXZFDESTINATIONTYPE:
   case dap_lifi_tclToken::EN_E8_NAVLOCATIONNAVDATATYPE:
   case dap_lifi_tclToken::EN_NAVLOCATIONDATADESC:
   case dap_lifi_tclToken::EN_NAVLOCATIONDATADESCUNION0:
   case dap_lifi_tclToken::EN_NAVSPOTDESTINATIONONECELLPROPERTY:
   case dap_lifi_tclToken::EN_NAVSPOTDESTINATIONONECELLDESC:
   case dap_lifi_tclToken::EN_NAVSPOTDESTINATIONONECELLLISTSET:
   case dap_lifi_tclToken::EN_NAVSTREETDESTINATIONONECELLPROPERTY:
   case dap_lifi_tclToken::EN_NAVSTREETDESTINATIONONECELLDESC:
   case dap_lifi_tclToken::EN_NAVSTREETDESTINATIONONECELLLISTSET:
   case dap_lifi_tclToken::EN_E8_NAVINTERSECTIONTYPE:
   case dap_lifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLPROPERTY:
   case dap_lifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLDESC:
   case dap_lifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
   case dap_lifi_tclToken::EN_NAVAREADESCRIPTIONCIRCLE:
   case dap_lifi_tclToken::EN_NAVAREADESCRIPTIONPOLYGON:
   case dap_lifi_tclToken::EN_E16_SELECTIONCRITERIONTYPE:
   case dap_lifi_tclToken::EN_ADDRESSTEMPLATE:
   case dap_lifi_tclToken::EN_E8_LOCATIONDESCRIPTIONDATATYPE:
   case dap_lifi_tclToken::EN_B8_LOCATIONDESCRIPTORSTATUS:
   case dap_lifi_tclToken::EN_LOCATIONDESCRIPTOR:
   case dap_lifi_tclToken::EN_LOCATIONDESCRIPTORUNION0:
   case dap_lifi_tclToken::EN_LOCATIONDESCRIPTION:
   case dap_lifi_tclToken::EN_STRINGPOSITION:
   case dap_lifi_tclToken::EN_STRINGID:
   case dap_lifi_tclToken::EN_FLISTRING:
   case dap_lifi_tclToken::EN_B8_POSITIONSTATUS:
   case dap_lifi_tclToken::EN_LISTOFPOSITIONS:
   case dap_lifi_tclToken::EN_B8_LISTRESULTOPTIONS:
   case dap_lifi_tclToken::EN_B8_LISTGETOPTIONS:
   case dap_lifi_tclToken::EN_B16_ELEMENTPROPERTIES:
   case dap_lifi_tclToken::EN_B8_CRITERIONSTATUS:
   case dap_lifi_tclToken::EN_B8_LISTSORTOPTIONS:
   case dap_lifi_tclToken::EN_B8_CRITERIAGETOPTIONS:
   case dap_lifi_tclToken::EN_E8_USERID:
   case dap_lifi_tclToken::EN_B8_INPUTCONTINUATION:
   case dap_lifi_tclToken::EN_DAPISELECTABLECRITERION:
   case dap_lifi_tclToken::EN_B8_SELECTIONCRITERIAMASK:
   case dap_lifi_tclToken::EN_B8_REFINEMENTCRITERIAMASK:
   case dap_lifi_tclToken::EN_OBJECTDESCRIPTION:
   case dap_lifi_tclToken::EN_LISTELEMENT:
   case dap_lifi_tclToken::EN_B8_NAVBINPROPERTIES:
   case dap_lifi_tclToken::EN_CLUSTERID:
   case dap_lifi_tclToken::EN_B8_CELLPROPERTIES:
   case dap_lifi_tclToken::EN_CELL:
   case dap_lifi_tclToken::EN_CLUSTERINFO:
   case dap_lifi_tclToken::EN_E8_DETAILTYPE:
   case dap_lifi_tclToken::EN_OBJECTDETAIL:
   case dap_lifi_tclToken::EN_B8_RESOLUTIONTYPE:
   case dap_lifi_tclToken::EN_B8_DATASETPROPERTIES:
   case dap_lifi_tclToken::EN_DATASETELEMENT:
   case dap_lifi_tclToken::EN_E8_DAPORDERTYPE:
   case dap_lifi_tclToken::EN_U8:   
   case dap_lifi_tclToken::EN_S8:   
   case dap_lifi_tclToken::EN_U16:   
   case dap_lifi_tclToken::EN_S16:   
   case dap_lifi_tclToken::EN_U24:   
   case dap_lifi_tclToken::EN_S24:   
   case dap_lifi_tclToken::EN_U32:   
   case dap_lifi_tclToken::EN_S32:   
   case dap_lifi_tclToken::EN_U64:   
   case dap_lifi_tclToken::EN_S64:   
   case dap_lifi_tclToken::EN_F32:   
   case dap_lifi_tclToken::EN_F64:   
   case dap_lifi_tclToken::EN_BOOL:   
   case dap_lifi_tclToken::EN_STRING:   
   case dap_lifi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(dap_lifi_tclKnot(enMsgToken,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool dap_lifi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool dap_lifi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      dap_lifi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      dap_lifi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      dap_lifi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(dap_lifi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(dap_lifi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(dap_lifi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case dap_lifi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == dap_lifi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case dap_lifi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            dap_lifi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(dap_lifi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            dap_lifi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(dap_lifi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case dap_lifi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case dap_lifi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_lifi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_lifi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_lifi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_lifi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_lifi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_lifi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_lifi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_lifi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_lifi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_lifi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_lifi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_lifi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_lifi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case dap_lifi_tclToken::EN_MSG_CLOSECONTEXTMETHODSTART:
   case dap_lifi_tclToken::EN_MSG_CLOSECONTEXTMETHODRESULT:
   case dap_lifi_tclToken::EN_MSG_GETOBJECTSMETHODSTART:
   case dap_lifi_tclToken::EN_MSG_GETOBJECTSMETHODRESULT:
   case dap_lifi_tclToken::EN_MSG_GETOBJECTDESCRIPTIONMETHODSTART:
   case dap_lifi_tclToken::EN_MSG_GETOBJECTDESCRIPTIONMETHODRESULT:
   case dap_lifi_tclToken::EN_MSG_GETELEMENTNUMBERMETHODSTART:
   case dap_lifi_tclToken::EN_MSG_GETELEMENTNUMBERMETHODRESULT:
   case dap_lifi_tclToken::EN_MSG_GETASFCHARACTERSMETHODSTART:
   case dap_lifi_tclToken::EN_MSG_GETASFCHARACTERSMETHODRESULT:
   case dap_lifi_tclToken::EN_MSG_GETENTRYLISTMETHODSTART:
   case dap_lifi_tclToken::EN_MSG_GETENTRYLISTMETHODRESULT:
   case dap_lifi_tclToken::EN_MSG_GETENTRYLISTMETHODRESULTFIRST:
   case dap_lifi_tclToken::EN_MSG_GETENTRYLISTMETHODRESULTMIDDLE:
   case dap_lifi_tclToken::EN_MSG_GETENTRYLISTMETHODRESULTLAST:
   case dap_lifi_tclToken::EN_MSG_READBINARYDESTINATIONMETHODSTART:
   case dap_lifi_tclToken::EN_MSG_READBINARYDESTINATIONMETHODRESULT:
   case dap_lifi_tclToken::EN_MSG_GETOBJECTDETAILMETHODSTART:
   case dap_lifi_tclToken::EN_MSG_GETOBJECTDETAILMETHODRESULT:
   case dap_lifi_tclToken::EN_MSG_RESOLVELOCATIONDESCRIPTIONMETHODSTART:
   case dap_lifi_tclToken::EN_MSG_RESOLVELOCATIONDESCRIPTIONMETHODRESULT:
   case dap_lifi_tclToken::EN_MSG_READLANGUAGESMETHODSTART:
   case dap_lifi_tclToken::EN_MSG_READLANGUAGESMETHODRESULT:
   case dap_lifi_tclToken::EN_MSG_SETCURRENTLANGUAGEMETHODSTART:
   case dap_lifi_tclToken::EN_MSG_SETCURRENTLANGUAGEMETHODRESULT:
   case dap_lifi_tclToken::EN_MSG_GETDATASETSMETHODSTART:
   case dap_lifi_tclToken::EN_MSG_GETDATASETSMETHODRESULT:
   case dap_lifi_tclToken::EN_MSG_GETADDRESSFORMATMETHODSTART:
   case dap_lifi_tclToken::EN_MSG_GETADDRESSFORMATMETHODRESULT:
   case dap_lifi_tclToken::EN_MSG_GETNEARBYSTATESORCOUNTRIESMETHODSTART:
   case dap_lifi_tclToken::EN_MSG_GETNEARBYSTATESORCOUNTRIESMETHODRESULT:
   case dap_lifi_tclToken::EN_MSG_GETADDRESSFORMATTABLEMETHODSTART:
   case dap_lifi_tclToken::EN_MSG_GETADDRESSFORMATTABLEMETHODRESULT:
   case dap_lifi_tclToken::EN_MSG_CURRENTSEARCHPROGRESSSTATUS:
      bInitMessage(enToken);
      break;
   case dap_lifi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U8,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_RESERVED:
   {
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_U16_INDEXINREFERENCELIST:
   {
      fi_tcl_u16_IndexInReferenceList o_u16_IndexInReferenceList;
      if (!bDoIt(o_u16_IndexInReferenceList))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_S32_METER:
   {
      fi_tcl_s32_Meter o_s32_Meter;
      if (!bDoIt(o_s32_Meter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_S16_CENTIMETERSECOND:
   {
      fi_tcl_s16_CentimeterSecond o_s16_CentimeterSecond;
      if (!bDoIt(o_s16_CentimeterSecond))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_FIVERSION:
   {
      if (poVisitor->bDoExpand_FIVersion(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U8,dap_lifi_tclSemanticDomain::EN_PATCHVERSION));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U8,dap_lifi_tclSemanticDomain::EN_MINORVERSION));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U8,dap_lifi_tclSemanticDomain::EN_MAJORVERSION));
      }
      else
      {
         fi_tcl_FIVersion o_FIVersion;
         if (!bDoIt(o_FIVersion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FIVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FIVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_S32_LONGITUDE:
   {
      fi_tcl_s32_Longitude o_s32_Longitude;
      if (!bDoIt(o_s32_Longitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_S32_LATITUDE:
   {
      fi_tcl_s32_Latitude o_s32_Latitude;
      if (!bDoIt(o_s32_Latitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_POSITIONWGS84:
   {
      if (poVisitor->bDoExpand_PositionWGS84(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_S32_LATITUDE,dap_lifi_tclSemanticDomain::EN_LATITUDE));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_S32_LONGITUDE,dap_lifi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         fi_tcl_PositionWGS84 o_PositionWGS84;
         if (!bDoIt(o_PositionWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_E16_ISOCOUNTRYCODE:
   {
      fi_tcl_e16_ISOCountryCode o_e16_ISOCountryCode;
      if (!bDoIt(o_e16_ISOCountryCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_E16_ISOLANGUAGECODE:
   {
      fi_tcl_e16_ISOLanguageCode o_e16_ISOLanguageCode;
      if (!bDoIt(o_e16_ISOLanguageCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_U8_DIRECTIONABSOLUTE:
   {
      fi_tcl_u8_DirectionAbsolute o_u8_DirectionAbsolute;
      if (!bDoIt(o_u8_DirectionAbsolute))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_E8_BINCONTAINERTYPES:
   {
      fi_tcl_e8_BinContainerTypes o_e8_BinContainerTypes;
      if (!bDoIt(o_e8_BinContainerTypes))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_B16_POSITIONRELIABILITY:
   {
      fi_tcl_b16_PositionReliability o_b16_PositionReliability;
      if (!bDoIt(o_b16_PositionReliability))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_POSITIONHEADINGSPEED:
   {
      if (poVisitor->bDoExpand_PositionHeadingSpeed(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U8_DIRECTIONABSOLUTE,dap_lifi_tclSemanticDomain::EN_HEADING));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_S16_CENTIMETERSECOND,dap_lifi_tclSemanticDomain::EN_SPEED));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_B16_POSITIONRELIABILITY,dap_lifi_tclSemanticDomain::EN_POSITIONRELIABILITY));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_POSITIONWGS84,dap_lifi_tclSemanticDomain::EN_POSITIONWGS84));
      }
      else
      {
         fi_tcl_PositionHeadingSpeed o_PositionHeadingSpeed;
         if (!bDoIt(o_PositionHeadingSpeed))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionHeadingSpeed.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionHeadingSpeed.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_U32_DATASETID:
   {
      fi_tcl_u32_DataSetId o_u32_DataSetId;
      if (!bDoIt(o_u32_DataSetId))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_NAVCLUSTERDESC:
   {
      if (poVisitor->bDoExpand_NavClusterDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U16,dap_lifi_tclSemanticDomain::EN_LENGTH));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32,dap_lifi_tclSemanticDomain::EN_FILEOFFSET));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U16,dap_lifi_tclSemanticDomain::EN_FILEID));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U8,dap_lifi_tclSemanticDomain::EN_LEVEL));
      }
      else
      {
         fi_tcl_NavClusterDesc o_NavClusterDesc;
         if (!bDoIt(o_NavClusterDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavClusterDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavClusterDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_E8_NAVONECELLDIRECTION:
   {
      fi_tcl_e8_NavOneCellDirection o_e8_NavOneCellDirection;
      if (!bDoIt(o_e8_NavOneCellDirection))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_NAVONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U16_INDEXINREFERENCELIST,dap_lifi_tclSemanticDomain::EN_INDEXINCLUSTERREFLIST));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_NAVONECELLDIRECTION,dap_lifi_tclSemanticDomain::EN_USEDIRECTION));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U16,dap_lifi_tclSemanticDomain::EN_ONECELLID));
      }
      else
      {
         fi_tcl_NavOneCellDesc o_NavOneCellDesc;
         if (!bDoIt(o_NavOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_E8_SIDEINFO:
   {
      fi_tcl_e8_SideInfo o_e8_SideInfo;
      if (!bDoIt(o_e8_SideInfo))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_S32_EMU:
   {
      fi_tcl_s32_EMU o_s32_EMU;
      if (!bDoIt(o_s32_EMU))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_NAVZEROCELLDESC:
   {
      if (poVisitor->bDoExpand_NavZeroCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U16_INDEXINREFERENCELIST,dap_lifi_tclSemanticDomain::EN_INDEXINCLUSTERREFLIST));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U16,dap_lifi_tclSemanticDomain::EN_ZEROCELLID));
      }
      else
      {
         fi_tcl_NavZeroCellDesc o_NavZeroCellDesc;
         if (!bDoIt(o_NavZeroCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavZeroCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavZeroCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_E8_NAVLOCATIONDESCTYPE:
   {
      fi_tcl_e8_NavLocationDescType o_e8_NavLocationDescType;
      if (!bDoIt(o_e8_NavLocationDescType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_NAVLOCATIONDESCUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_NavLocationDescType oDataType;
      oCallStack.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_NAVLOCATIONDESCTYPE,dap_lifi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_RESERVED:
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_RESERVED,dap_lifi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
         break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVLOCATIONDATADESC:
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_NAVLOCATIONDATADESC,dap_lifi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
         break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONCIRCLE:
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_NAVAREADESCRIPTIONCIRCLE,dap_lifi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
         break;
      case fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONPOLYGON:
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_NAVAREADESCRIPTIONPOLYGON,dap_lifi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
         break;
      }
   } break;
   case dap_lifi_tclToken::EN_NAVLOCATIONDESC:
   {
      if (poVisitor->bDoExpand_NavLocationDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_NAVLOCATIONDESCUNION0,dap_lifi_tclSemanticDomain::EN_NAVLOCATIONDESCTYPE));
      }
      else
      {
         fi_tcl_NavLocationDesc o_NavLocationDesc;
         if (!bDoIt(o_NavLocationDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#ifndef FI_S_EXTERNAL_FI
   case dap_lifi_tclToken::EN_NAVLOCATIONBINCONTAINER:
   {
      if (poVisitor->bDoExpand_NavLocationBinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         bInsideBinContainerVersion = true;
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_BINCONTAINER));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_NAVLOCATIONDESC,dap_lifi_tclSemanticDomain::EN_CONTAINERDATA));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_BINCONTAINERTYPES,dap_lifi_tclSemanticDomain::EN_CONTAINERTYPE));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_FIVERSION,dap_lifi_tclSemanticDomain::EN_CONTAINERFIVERSION));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U16,dap_lifi_tclSemanticDomain::EN_SERVICEID));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32,dap_lifi_tclSemanticDomain::EN_CONTAINERLENGTH));
      }
      else
      {
         fi_tcl_NavLocationBinContainer o_NavLocationBinContainer;
         if (!bDoIt(o_NavLocationBinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#endif // FI_S_EXTERNAL_FI
   case dap_lifi_tclToken::EN_E8_NAVINDEXZFDESTINATIONTYPE:
   {
      fi_tcl_e8_NavIndexZFDestinationType o_e8_NavIndexZFDestinationType;
      if (!bDoIt(o_e8_NavIndexZFDestinationType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_E8_NAVLOCATIONNAVDATATYPE:
   {
      fi_tcl_e8_NavLocationNavDataType o_e8_NavLocationNavDataType;
      if (!bDoIt(o_e8_NavLocationNavDataType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_NAVLOCATIONDATADESCUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_NavLocationNavDataType oDataType;
      oCallStack.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_NAVLOCATIONNAVDATATYPE,dap_lifi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      switch (oDataType.enType)
      {
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_RESERVED:
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_RESERVED,dap_lifi_tclSemanticDomain::EN_NAVDATATYPE));
         break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET,dap_lifi_tclSemanticDomain::EN_NAVDATATYPE));
         break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSTREETDESTINATIONONECELLLISTSET:
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_NAVSTREETDESTINATIONONECELLLISTSET,dap_lifi_tclSemanticDomain::EN_NAVDATATYPE));
         break;
      case fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSPOTDESTINATIONONECELLLISTSET:
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_NAVSPOTDESTINATIONONECELLLISTSET,dap_lifi_tclSemanticDomain::EN_NAVDATATYPE));
         break;
      }
   } break;
   case dap_lifi_tclToken::EN_NAVLOCATIONDATADESC:
   {
      if (poVisitor->bDoExpand_NavLocationDataDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_NAVLOCATIONDATADESCUNION0,dap_lifi_tclSemanticDomain::EN_NAVDATATYPE));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_POSITIONWGS84,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_ACCESSPOINTREFLIST));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_POSITIONWGS84,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_OBJECTPOINTREFLIST));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_NAVINDEXZFDESTINATIONTYPE,dap_lifi_tclSemanticDomain::EN_INDEXZFDESTTYPE));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32_DATASETID,dap_lifi_tclSemanticDomain::EN_NAVDATASETID));
      }
      else
      {
         fi_tcl_NavLocationDataDesc o_NavLocationDataDesc;
         if (!bDoIt(o_NavLocationDataDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationDataDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavLocationDataDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_NAVSPOTDESTINATIONONECELLPROPERTY:
   {
      if (poVisitor->bDoExpand_NavSpotDestinationOneCellProperty(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U16_INDEXINREFERENCELIST,dap_lifi_tclSemanticDomain::EN_INDEXINACCESSPOINTREFLIST));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U16_INDEXINREFERENCELIST,dap_lifi_tclSemanticDomain::EN_INDEXINOBJECTPOINTREFLIST));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_POSITIONWGS84,dap_lifi_tclSemanticDomain::EN_DECISIONPOINT));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_S32_EMU,dap_lifi_tclSemanticDomain::EN_DESTDISTANCE));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_S32_EMU,dap_lifi_tclSemanticDomain::EN_ONECELLLENGTH));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_S32_EMU,dap_lifi_tclSemanticDomain::EN_FROMZEROCELLTOSPOTLENGTH));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_SIDEINFO,dap_lifi_tclSemanticDomain::EN_SIDEINFO));
      }
      else
      {
         fi_tcl_NavSpotDestinationOneCellProperty o_NavSpotDestinationOneCellProperty;
         if (!bDoIt(o_NavSpotDestinationOneCellProperty))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_NAVSPOTDESTINATIONONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavSpotDestinationOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_NAVSPOTDESTINATIONONECELLPROPERTY,dap_lifi_tclSemanticDomain::EN_ONECELLPROPERTY));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_NAVONECELLDESC,dap_lifi_tclSemanticDomain::EN_ONECELLDESC));
      }
      else
      {
         fi_tcl_NavSpotDestinationOneCellDesc o_NavSpotDestinationOneCellDesc;
         if (!bDoIt(o_NavSpotDestinationOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_NAVSPOTDESTINATIONONECELLLISTSET:
   {
      if (poVisitor->bDoExpand_NavSpotDestinationOneCellListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_NAVSPOTDESTINATIONONECELLDESC,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_SPOTDESTINATIONONECELLREFLIST));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_NAVCLUSTERDESC,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_CLUSTERREFLIST));
      }
      else
      {
         fi_tcl_NavSpotDestinationOneCellListSet o_NavSpotDestinationOneCellListSet;
         if (!bDoIt(o_NavSpotDestinationOneCellListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavSpotDestinationOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_NAVSTREETDESTINATIONONECELLPROPERTY:
   {
      if (poVisitor->bDoExpand_NavStreetDestinationOneCellProperty(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U16_INDEXINREFERENCELIST,dap_lifi_tclSemanticDomain::EN_INDEXINACCESSPOINTREFLIST));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U16_INDEXINREFERENCELIST,dap_lifi_tclSemanticDomain::EN_INDEXINOBJECTPOINTREFLIST));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_SIDEINFO,dap_lifi_tclSemanticDomain::EN_SIDEINFO));
      }
      else
      {
         fi_tcl_NavStreetDestinationOneCellProperty o_NavStreetDestinationOneCellProperty;
         if (!bDoIt(o_NavStreetDestinationOneCellProperty))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_NAVSTREETDESTINATIONONECELLDESC:
   {
      if (poVisitor->bDoExpand_NavStreetDestinationOneCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_NAVSTREETDESTINATIONONECELLPROPERTY,dap_lifi_tclSemanticDomain::EN_ONECELLPROPERTY));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_NAVONECELLDESC,dap_lifi_tclSemanticDomain::EN_ONECELLDESC));
      }
      else
      {
         fi_tcl_NavStreetDestinationOneCellDesc o_NavStreetDestinationOneCellDesc;
         if (!bDoIt(o_NavStreetDestinationOneCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_NAVSTREETDESTINATIONONECELLLISTSET:
   {
      if (poVisitor->bDoExpand_NavStreetDestinationOneCellListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_NAVSTREETDESTINATIONONECELLDESC,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_STREETDESTINATIONONECELLREFLIST));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_NAVCLUSTERDESC,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_CLUSTERREFLIST));
      }
      else
      {
         fi_tcl_NavStreetDestinationOneCellListSet o_NavStreetDestinationOneCellListSet;
         if (!bDoIt(o_NavStreetDestinationOneCellListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavStreetDestinationOneCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_E8_NAVINTERSECTIONTYPE:
   {
      fi_tcl_e8_NavIntersectionType o_e8_NavIntersectionType;
      if (!bDoIt(o_e8_NavIntersectionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLPROPERTY:
   {
      if (poVisitor->bDoExpand_NavIntersectionDestinationZeroCellProperty(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U16_INDEXINREFERENCELIST,dap_lifi_tclSemanticDomain::EN_INDEXINACCESSPOINTREFLIST));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U16_INDEXINREFERENCELIST,dap_lifi_tclSemanticDomain::EN_INDEXINOBJECTPOINTREFLIST));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_NAVINTERSECTIONTYPE,dap_lifi_tclSemanticDomain::EN_INTERSECTIONTYPE));
      }
      else
      {
         fi_tcl_NavIntersectionDestinationZeroCellProperty o_NavIntersectionDestinationZeroCellProperty;
         if (!bDoIt(o_NavIntersectionDestinationZeroCellProperty))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLDESC:
   {
      if (poVisitor->bDoExpand_NavIntersectionDestinationZeroCellDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLPROPERTY,dap_lifi_tclSemanticDomain::EN_ZEROCELLPROPERTY));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_NAVZEROCELLDESC,dap_lifi_tclSemanticDomain::EN_ZEROCELLDESC));
      }
      else
      {
         fi_tcl_NavIntersectionDestinationZeroCellDesc o_NavIntersectionDestinationZeroCellDesc;
         if (!bDoIt(o_NavIntersectionDestinationZeroCellDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
   {
      if (poVisitor->bDoExpand_NavIntersectionDestinationZeroCellListSet(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLDESC,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_INTERSECTIONDESTINATIONZEROCELLREFLIST));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_NAVCLUSTERDESC,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_CLUSTERREFLIST));
      }
      else
      {
         fi_tcl_NavIntersectionDestinationZeroCellListSet o_NavIntersectionDestinationZeroCellListSet;
         if (!bDoIt(o_NavIntersectionDestinationZeroCellListSet))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavIntersectionDestinationZeroCellListSet.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_NAVAREADESCRIPTIONCIRCLE:
   {
      if (poVisitor->bDoExpand_NavAreaDescriptionCircle(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_POSITIONWGS84,dap_lifi_tclSemanticDomain::EN_COORDINATE));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_S32_METER,dap_lifi_tclSemanticDomain::EN_RADIUS));
      }
      else
      {
         fi_tcl_NavAreaDescriptionCircle o_NavAreaDescriptionCircle;
         if (!bDoIt(o_NavAreaDescriptionCircle))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavAreaDescriptionCircle.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavAreaDescriptionCircle.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_NAVAREADESCRIPTIONPOLYGON:
   {
      if (poVisitor->bDoExpand_NavAreaDescriptionPolygon(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_POSITIONWGS84,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_COORDINATELIST));
      }
      else
      {
         fi_tcl_NavAreaDescriptionPolygon o_NavAreaDescriptionPolygon;
         if (!bDoIt(o_NavAreaDescriptionPolygon))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavAreaDescriptionPolygon.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_NavAreaDescriptionPolygon.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_E16_SELECTIONCRITERIONTYPE:
   {
      fi_tcl_e16_SelectionCriterionType o_e16_SelectionCriterionType;
      if (!bDoIt(o_e16_SelectionCriterionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_ADDRESSTEMPLATE:
   {
      if (poVisitor->bDoExpand_AddressTemplate(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_SELECTIONCRITERIONTYPE,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_SELECTIONCRITERIA));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_ISOCOUNTRYCODE,dap_lifi_tclSemanticDomain::EN_COUNTRYCODE));
      }
      else
      {
         fi_tcl_AddressTemplate o_AddressTemplate;
         if (!bDoIt(o_AddressTemplate))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AddressTemplate.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AddressTemplate.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_E8_LOCATIONDESCRIPTIONDATATYPE:
   {
      fi_tcl_e8_LocationDescriptionDataType o_e8_LocationDescriptionDataType;
      if (!bDoIt(o_e8_LocationDescriptionDataType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_B8_LOCATIONDESCRIPTORSTATUS:
   {
      fi_tcl_b8_LocationDescriptorStatus o_b8_LocationDescriptorStatus;
      if (!bDoIt(o_b8_LocationDescriptorStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_LOCATIONDESCRIPTORUNION0:
   {
      oPath.bGoUp();
      oCallStack.bGoUp();
      fi_tcl_e8_LocationDescriptionDataType oDataType;
      oCallStack.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_LOCATIONDESCRIPTIONDATATYPE,dap_lifi_tclSemanticDomain::EN_DATA_TYPE));
      poVisitor->oIterator = oCallStack.oGetIterator();
      bDoIt(oDataType);
      oCallStack.bGoUp();
      if ((oDataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_LISTOFPOSITIONS) &&
          !(17 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED;
      }
      if ((oDataType.enType == fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_FLISTRING) &&
          !(11 <= u16MajorVersion))
      {
         oDataType.enType = fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED;
      }
      switch (oDataType.enType)
      {
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED:
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_RESERVED,dap_lifi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_TSTRING:
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_STRING,dap_lifi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGID:
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_STRINGID,dap_lifi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONHEADINGSPEED:
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_POSITIONHEADINGSPEED,dap_lifi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONWGS84:
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_POSITIONWGS84,dap_lifi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_NAVLOCATIONBINCONTAINER:
         #ifndef FI_S_EXTERNAL_FI
         if (bUseSpecialBinContainer)
         {
            oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_NAVLOCATIONBINCONTAINER,dap_lifi_tclSemanticDomain::EN_DATA));
         }
         else
         #endif // FI_S_EXTERNAL_FI
         {
            oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_BINCONTAINER,dap_lifi_tclSemanticDomain::EN_DATA));
         }
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGPOSITION:
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_STRINGPOSITION,dap_lifi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_FLISTRING:
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_FLISTRING,dap_lifi_tclSemanticDomain::EN_DATA));
         break;
      case fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_LISTOFPOSITIONS:
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LISTOFPOSITIONS,dap_lifi_tclSemanticDomain::EN_DATA));
         break;
      }
   } break;
   case dap_lifi_tclToken::EN_LOCATIONDESCRIPTOR:
   {
      if (poVisitor->bDoExpand_LocationDescriptor(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         if (25 <= u16MajorVersion)
         {
            oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_B8_LOCATIONDESCRIPTORSTATUS,dap_lifi_tclSemanticDomain::EN_STATUS));
         }
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LOCATIONDESCRIPTORUNION0,dap_lifi_tclSemanticDomain::EN_DATA));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_SELECTIONCRITERIONTYPE,dap_lifi_tclSemanticDomain::EN_SELECTIONCRITERION));
      }
      else
      {
         fi_tcl_LocationDescriptor o_LocationDescriptor;
         if (!bDoIt(o_LocationDescriptor))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocationDescriptor.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocationDescriptor.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_LOCATIONDESCRIPTION:
   {
      if (poVisitor->bDoExpand_LocationDescription(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LOCATIONDESCRIPTOR,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_DESCRIPTORS));
      }
      else
      {
         fi_tcl_LocationDescription o_LocationDescription;
         if (!bDoIt(o_LocationDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocationDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_LocationDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_STRINGPOSITION:
   {
      if (poVisitor->bDoExpand_StringPosition(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_POSITIONWGS84,dap_lifi_tclSemanticDomain::EN_POSITION));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_STRING,dap_lifi_tclSemanticDomain::EN_STRING));
      }
      else
      {
         fi_tcl_StringPosition o_StringPosition;
         if (!bDoIt(o_StringPosition))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringPosition.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_STRINGID:
   {
      if (poVisitor->bDoExpand_StringID(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32,dap_lifi_tclSemanticDomain::EN_ID));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_STRING,dap_lifi_tclSemanticDomain::EN_STRING));
      }
      else
      {
         fi_tcl_StringID o_StringID;
         if (!bDoIt(o_StringID))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StringID.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_FLISTRING:
   {
      if (poVisitor->bDoExpand_FLIString(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_STRING,dap_lifi_tclSemanticDomain::EN_STRING));
      }
      else
      {
         fi_tcl_FLIString o_FLIString;
         if (!bDoIt(o_FLIString))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FLIString.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FLIString.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_B8_POSITIONSTATUS:
   {
      fi_tcl_b8_PositionStatus o_b8_PositionStatus;
      if (!bDoIt(o_b8_PositionStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_LISTOFPOSITIONS:
   {
      if (poVisitor->bDoExpand_ListOfPositions(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_POSITIONWGS84,dap_lifi_tclSemanticDomain::EN_CURRENTPOSITION));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32,dap_lifi_tclSemanticDomain::EN_ID));
         if (26 <= u16MajorVersion)
         {
            oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_B8_POSITIONSTATUS,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_POSITIONSTATI));
         }
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_POSITIONWGS84,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_POSITIONS));
      }
      else
      {
         fi_tcl_ListOfPositions o_ListOfPositions;
         if (!bDoIt(o_ListOfPositions))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ListOfPositions.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ListOfPositions.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_B8_LISTRESULTOPTIONS:
   {
      fi_tcl_b8_ListResultOptions o_b8_ListResultOptions;
      if (!bDoIt(o_b8_ListResultOptions))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_B8_LISTGETOPTIONS:
   {
      fi_tcl_b8_ListGetOptions o_b8_ListGetOptions;
      if (!bDoIt(o_b8_ListGetOptions))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_B16_ELEMENTPROPERTIES:
   {
      fi_tcl_b16_ElementProperties o_b16_ElementProperties;
      if (!bDoIt(o_b16_ElementProperties))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_B8_CRITERIONSTATUS:
   {
      fi_tcl_b8_CriterionStatus o_b8_CriterionStatus;
      if (!bDoIt(o_b8_CriterionStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_B8_LISTSORTOPTIONS:
   {
      fi_tcl_b8_ListSortOptions o_b8_ListSortOptions;
      if (!bDoIt(o_b8_ListSortOptions))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_B8_CRITERIAGETOPTIONS:
   {
      fi_tcl_b8_CriteriaGetOptions o_b8_CriteriaGetOptions;
      if (!bDoIt(o_b8_CriteriaGetOptions))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_E8_USERID:
   {
      fi_tcl_e8_UserID o_e8_UserID;
      if (!bDoIt(o_e8_UserID))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_B8_INPUTCONTINUATION:
   {
      fi_tcl_b8_InputContinuation o_b8_InputContinuation;
      if (!bDoIt(o_b8_InputContinuation))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_DAPISELECTABLECRITERION:
   {
      if (poVisitor->bDoExpand_DAPISelectableCriterion(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         if (19 <= u16MajorVersion)
         {
            oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U16,dap_lifi_tclSemanticDomain::EN_NUMOFPOI));
         }
         if (13 <= u16MajorVersion)
         {
            oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_B8_CRITERIONSTATUS,dap_lifi_tclSemanticDomain::EN_STATUS));
         }
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_STRING,dap_lifi_tclSemanticDomain::EN_DESCRIPTION));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_BOOL,dap_lifi_tclSemanticDomain::EN_ATTRIBUTESAVAILABLE));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_B8_LISTSORTOPTIONS,dap_lifi_tclSemanticDomain::EN_SORTOPTION));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_LOCATIONDESCRIPTIONDATATYPE,dap_lifi_tclSemanticDomain::EN_DATATYPE));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E16_SELECTIONCRITERIONTYPE,dap_lifi_tclSemanticDomain::EN_SELECTIONCRITERION));
      }
      else
      {
         fi_tcl_DAPISelectableCriterion o_DAPISelectableCriterion;
         if (!bDoIt(o_DAPISelectableCriterion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DAPISelectableCriterion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DAPISelectableCriterion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_B8_SELECTIONCRITERIAMASK:
   {
      fi_tcl_b8_SelectionCriteriaMask o_b8_SelectionCriteriaMask;
      if (!bDoIt(o_b8_SelectionCriteriaMask))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_B8_REFINEMENTCRITERIAMASK:
   {
      fi_tcl_b8_RefinementCriteriaMask o_b8_RefinementCriteriaMask;
      if (!bDoIt(o_b8_RefinementCriteriaMask))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_OBJECTDESCRIPTION:
   {
      if (poVisitor->bDoExpand_ObjectDescription(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_STRING,dap_lifi_tclSemanticDomain::EN_DESCRIPTION));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U16,dap_lifi_tclSemanticDomain::EN_CODE));
      }
      else
      {
         fi_tcl_ObjectDescription o_ObjectDescription;
         if (!bDoIt(o_ObjectDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ObjectDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ObjectDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_LISTELEMENT:
   {
      if (poVisitor->bDoExpand_ListElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_STRING,dap_lifi_tclSemanticDomain::EN_DESCRIPTION));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_STRING,dap_lifi_tclSemanticDomain::EN_NAME));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_B16_ELEMENTPROPERTIES,dap_lifi_tclSemanticDomain::EN_PROPERTIES));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_POSITIONWGS84,dap_lifi_tclSemanticDomain::EN_POSITION));
      }
      else
      {
         fi_tcl_ListElement o_ListElement;
         if (!bDoIt(o_ListElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ListElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ListElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_B8_NAVBINPROPERTIES:
   {
      fi_tcl_b8_NavBinProperties o_b8_NavBinProperties;
      if (!bDoIt(o_b8_NavBinProperties))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_CLUSTERID:
   {
      if (poVisitor->bDoExpand_ClusterId(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U16,dap_lifi_tclSemanticDomain::EN_FILEID));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U16,dap_lifi_tclSemanticDomain::EN_LENGTH));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32,dap_lifi_tclSemanticDomain::EN_OFFSET));
      }
      else
      {
         fi_tcl_ClusterId o_ClusterId;
         if (!bDoIt(o_ClusterId))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ClusterId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ClusterId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_B8_CELLPROPERTIES:
   {
      fi_tcl_b8_CellProperties o_b8_CellProperties;
      if (!bDoIt(o_b8_CellProperties))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_CELL:
   {
      if (poVisitor->bDoExpand_Cell(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U8,dap_lifi_tclSemanticDomain::EN_INTERPOLATIONRATIO));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_B8_CELLPROPERTIES,dap_lifi_tclSemanticDomain::EN_PROPERTIES));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U16,dap_lifi_tclSemanticDomain::EN_ID));
      }
      else
      {
         fi_tcl_Cell o_Cell;
         if (!bDoIt(o_Cell))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Cell.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Cell.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_CLUSTERINFO:
   {
      if (poVisitor->bDoExpand_ClusterInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_CELL,dap_lifi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_LIST,dap_lifi_tclSemanticDomain::EN_CELLS));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_CLUSTERID,dap_lifi_tclSemanticDomain::EN_ID));
      }
      else
      {
         fi_tcl_ClusterInfo o_ClusterInfo;
         if (!bDoIt(o_ClusterInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ClusterInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ClusterInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_E8_DETAILTYPE:
   {
      fi_tcl_e8_DetailType o_e8_DetailType;
      if (!bDoIt(o_e8_DetailType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_OBJECTDETAIL:
   {
      if (poVisitor->bDoExpand_ObjectDetail(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_E8_DETAILTYPE,dap_lifi_tclSemanticDomain::EN_TYPE));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_STRING,dap_lifi_tclSemanticDomain::EN_STRING));
      }
      else
      {
         fi_tcl_ObjectDetail o_ObjectDetail;
         if (!bDoIt(o_ObjectDetail))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ObjectDetail.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ObjectDetail.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_B8_RESOLUTIONTYPE:
   {
      fi_tcl_b8_ResolutionType o_b8_ResolutionType;
      if (!bDoIt(o_b8_ResolutionType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_B8_DATASETPROPERTIES:
   {
      fi_tcl_b8_DataSetProperties o_b8_DataSetProperties;
      if (!bDoIt(o_b8_DataSetProperties))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_lifi_tclToken::EN_DATASETELEMENT:
   {
      if (poVisitor->bDoExpand_DataSetElement(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_END_OF_STRUCT,dap_lifi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_STRING,dap_lifi_tclSemanticDomain::EN_NAME));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_B8_DATASETPROPERTIES,dap_lifi_tclSemanticDomain::EN_PROPERTIES));
         oPath.bGoDown(dap_lifi_tclKnot(dap_lifi_tclToken::EN_U32,dap_lifi_tclSemanticDomain::EN_ID));
      }
      else
      {
         fi_tcl_DataSetElement o_DataSetElement;
         if (!bDoIt(o_DataSetElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DataSetElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DataSetElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_lifi_tclToken::EN_E8_DAPORDERTYPE:
   {
      fi_tcl_e8_DapOrderType o_e8_DapOrderType;
      if (!bDoIt(o_e8_DapOrderType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
      case dap_lifi_tclToken::EN_UNKNOWN:
      case dap_lifi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

