/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgReadDataBlocksMethodStart::dap_devmanfi_tclMsgReadDataBlocksMethodStart(const dap_devmanfi_tclMsgReadDataBlocksMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   bCloseFilesAfterProcessing = coRef.bCloseFilesAfterProcessing;
   oDataBlock = coRef.oDataBlock;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgReadDataBlocksMethodStart& dap_devmanfi_tclMsgReadDataBlocksMethodStart::operator=(const dap_devmanfi_tclMsgReadDataBlocksMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bCloseFilesAfterProcessing = coRef.bCloseFilesAfterProcessing;
   oDataBlock = coRef.oDataBlock;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgReadDataBlocksMethodStart::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgReadDataBlocksMethodStart::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_READDATABLOCKS;}
tU8 dap_devmanfi_tclMsgReadDataBlocksMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_devmanfi_tclMsgReadDataBlocksMethodStart::vDestroy()
{
   oDataBlock.vDestroy(); 
}

tU32 dap_devmanfi_tclMsgReadDataBlocksMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+oDataBlock.u32GetSize(u16MajorVersion);
}

tBool dap_devmanfi_tclMsgReadDataBlocksMethodStart::operator==(const dap_devmanfi_tclMsgReadDataBlocksMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (bCloseFilesAfterProcessing == rfoCmp.bCloseFilesAfterProcessing);
      bResult = bResult && (oDataBlock == rfoCmp.oDataBlock);
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgReadDataBlocksMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> bCloseFilesAfterProcessing;
   oIn >> oDataBlock;
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgReadDataBlocksMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << bCloseFilesAfterProcessing;
   oOut << oDataBlock;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgReadDataBlocksMethodResult::dap_devmanfi_tclMsgReadDataBlocksMethodResult(const dap_devmanfi_tclMsgReadDataBlocksMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   oDataBlock = coRef.oDataBlock;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgReadDataBlocksMethodResult& dap_devmanfi_tclMsgReadDataBlocksMethodResult::operator=(const dap_devmanfi_tclMsgReadDataBlocksMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oDataBlock = coRef.oDataBlock;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgReadDataBlocksMethodResult::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgReadDataBlocksMethodResult::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_READDATABLOCKS;}
tU8 dap_devmanfi_tclMsgReadDataBlocksMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_devmanfi_tclMsgReadDataBlocksMethodResult::vDestroy()
{
   oDataBlock.vDestroy(); 
}

tU32 dap_devmanfi_tclMsgReadDataBlocksMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+oDataBlock.u32GetSize(u16MajorVersion);
}

tBool dap_devmanfi_tclMsgReadDataBlocksMethodResult::operator==(const dap_devmanfi_tclMsgReadDataBlocksMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (oDataBlock == rfoCmp.oDataBlock);
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgReadDataBlocksMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> oDataBlock;
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgReadDataBlocksMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << oDataBlock;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgGetFileSizeMethodStart::dap_devmanfi_tclMsgGetFileSizeMethodStart(const dap_devmanfi_tclMsgGetFileSizeMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   bCloseFileAfterProcessing = coRef.bCloseFileAfterProcessing;
   oPhysicalAddress = coRef.oPhysicalAddress;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgGetFileSizeMethodStart& dap_devmanfi_tclMsgGetFileSizeMethodStart::operator=(const dap_devmanfi_tclMsgGetFileSizeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bCloseFileAfterProcessing = coRef.bCloseFileAfterProcessing;
   oPhysicalAddress = coRef.oPhysicalAddress;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgGetFileSizeMethodStart::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgGetFileSizeMethodStart::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_GETFILESIZE;}
tU8 dap_devmanfi_tclMsgGetFileSizeMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_devmanfi_tclMsgGetFileSizeMethodStart::vDestroy()
{
   oPhysicalAddress.vDestroy(); 
}

tU32 dap_devmanfi_tclMsgGetFileSizeMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+oPhysicalAddress.u32GetSize(u16MajorVersion);
}

tBool dap_devmanfi_tclMsgGetFileSizeMethodStart::operator==(const dap_devmanfi_tclMsgGetFileSizeMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (bCloseFileAfterProcessing == rfoCmp.bCloseFileAfterProcessing);
      bResult = bResult && (oPhysicalAddress == rfoCmp.oPhysicalAddress);
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgGetFileSizeMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> bCloseFileAfterProcessing;
   oIn >> oPhysicalAddress;
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgGetFileSizeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << bCloseFileAfterProcessing;
   oOut << oPhysicalAddress;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgGetFileSizeMethodResult::dap_devmanfi_tclMsgGetFileSizeMethodResult(const dap_devmanfi_tclMsgGetFileSizeMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   u32FileSize = coRef.u32FileSize;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgGetFileSizeMethodResult& dap_devmanfi_tclMsgGetFileSizeMethodResult::operator=(const dap_devmanfi_tclMsgGetFileSizeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32FileSize = coRef.u32FileSize;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgGetFileSizeMethodResult::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgGetFileSizeMethodResult::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_GETFILESIZE;}
tU8 dap_devmanfi_tclMsgGetFileSizeMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 dap_devmanfi_tclMsgGetFileSizeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool dap_devmanfi_tclMsgGetFileSizeMethodResult::operator==(const dap_devmanfi_tclMsgGetFileSizeMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u32FileSize == rfoCmp.u32FileSize);
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgGetFileSizeMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> u32FileSize;
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgGetFileSizeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u32FileSize;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgGetDirectoryMethodStart::dap_devmanfi_tclMsgGetDirectoryMethodStart(const dap_devmanfi_tclMsgGetDirectoryMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   oDirectoryDescription = coRef.oDirectoryDescription;
   u32ListOffset = coRef.u32ListOffset;
   oDirectoryList = coRef.oDirectoryList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgGetDirectoryMethodStart& dap_devmanfi_tclMsgGetDirectoryMethodStart::operator=(const dap_devmanfi_tclMsgGetDirectoryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   oDirectoryDescription = coRef.oDirectoryDescription;
   u32ListOffset = coRef.u32ListOffset;
   oDirectoryList = coRef.oDirectoryList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgGetDirectoryMethodStart::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgGetDirectoryMethodStart::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_GETDIRECTORY;}
tU8 dap_devmanfi_tclMsgGetDirectoryMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_devmanfi_tclMsgGetDirectoryMethodStart::vDestroy()
{
   oDirectoryDescription.vDestroy(); 
   oDirectoryList.vDestroy(); 
}

tU32 dap_devmanfi_tclMsgGetDirectoryMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+oDirectoryDescription.u32GetSize(u16MajorVersion)+oDirectoryList.u32GetSize(u16MajorVersion);
}

tBool dap_devmanfi_tclMsgGetDirectoryMethodStart::operator==(const dap_devmanfi_tclMsgGetDirectoryMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (oDirectoryDescription == rfoCmp.oDirectoryDescription);
      bResult = bResult && (u32ListOffset == rfoCmp.u32ListOffset);
      bResult = bResult && (oDirectoryList == rfoCmp.oDirectoryList);
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgGetDirectoryMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> oDirectoryDescription;
   oIn >> u32ListOffset;
   oIn >> oDirectoryList;
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgGetDirectoryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << oDirectoryDescription;
   oOut << u32ListOffset;
   oOut << oDirectoryList;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgGetDirectoryMethodResult::dap_devmanfi_tclMsgGetDirectoryMethodResult(const dap_devmanfi_tclMsgGetDirectoryMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   oDirectoryList = coRef.oDirectoryList;
   bComplete = coRef.bComplete;
   u32ListCounter = coRef.u32ListCounter;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgGetDirectoryMethodResult& dap_devmanfi_tclMsgGetDirectoryMethodResult::operator=(const dap_devmanfi_tclMsgGetDirectoryMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oDirectoryList = coRef.oDirectoryList;
   bComplete = coRef.bComplete;
   u32ListCounter = coRef.u32ListCounter;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgGetDirectoryMethodResult::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgGetDirectoryMethodResult::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_GETDIRECTORY;}
tU8 dap_devmanfi_tclMsgGetDirectoryMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid dap_devmanfi_tclMsgGetDirectoryMethodResult::vDestroy()
{
   oDirectoryList.vDestroy(); 
}

tU32 dap_devmanfi_tclMsgGetDirectoryMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+oDirectoryList.u32GetSize(u16MajorVersion);
}

tBool dap_devmanfi_tclMsgGetDirectoryMethodResult::operator==(const dap_devmanfi_tclMsgGetDirectoryMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (oDirectoryList == rfoCmp.oDirectoryList);
      bResult = bResult && (bComplete == rfoCmp.bComplete);
      bResult = bResult && (u32ListCounter == rfoCmp.u32ListCounter);
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgGetDirectoryMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> oDirectoryList;
   oIn >> bComplete;
   oIn >> u32ListCounter;
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgGetDirectoryMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << oDirectoryList;
   oOut << bComplete;
   oOut << u32ListCounter;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgGetDiscSpaceMethodStart::dap_devmanfi_tclMsgGetDiscSpaceMethodStart(const dap_devmanfi_tclMsgGetDiscSpaceMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   szDevice = coRef.szDevice;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgGetDiscSpaceMethodStart& dap_devmanfi_tclMsgGetDiscSpaceMethodStart::operator=(const dap_devmanfi_tclMsgGetDiscSpaceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   szDevice = coRef.szDevice;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgGetDiscSpaceMethodStart::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgGetDiscSpaceMethodStart::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_GETDISCSPACE;}
tU8 dap_devmanfi_tclMsgGetDiscSpaceMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_devmanfi_tclMsgGetDiscSpaceMethodStart::vDestroy()
{
   szDevice.vDestroy();
}

tU32 dap_devmanfi_tclMsgGetDiscSpaceMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+szDevice.u32GetSize(u16MajorVersion);
}

tBool dap_devmanfi_tclMsgGetDiscSpaceMethodStart::operator==(const dap_devmanfi_tclMsgGetDiscSpaceMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (szDevice == rfoCmp.szDevice);
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgGetDiscSpaceMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> szDevice;
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgGetDiscSpaceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << szDevice;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgGetDiscSpaceMethodResult::dap_devmanfi_tclMsgGetDiscSpaceMethodResult(const dap_devmanfi_tclMsgGetDiscSpaceMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   u32LowDiscSpace = coRef.u32LowDiscSpace;
   u32HighDiscSpace = coRef.u32HighDiscSpace;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgGetDiscSpaceMethodResult& dap_devmanfi_tclMsgGetDiscSpaceMethodResult::operator=(const dap_devmanfi_tclMsgGetDiscSpaceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32LowDiscSpace = coRef.u32LowDiscSpace;
   u32HighDiscSpace = coRef.u32HighDiscSpace;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgGetDiscSpaceMethodResult::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgGetDiscSpaceMethodResult::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_GETDISCSPACE;}
tU8 dap_devmanfi_tclMsgGetDiscSpaceMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 dap_devmanfi_tclMsgGetDiscSpaceMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool dap_devmanfi_tclMsgGetDiscSpaceMethodResult::operator==(const dap_devmanfi_tclMsgGetDiscSpaceMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u32LowDiscSpace == rfoCmp.u32LowDiscSpace);
      bResult = bResult && (u32HighDiscSpace == rfoCmp.u32HighDiscSpace);
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgGetDiscSpaceMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> u32LowDiscSpace;
   oIn >> u32HighDiscSpace;
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgGetDiscSpaceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u32LowDiscSpace;
   oOut << u32HighDiscSpace;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgGetFreeDiskSpaceMethodStart::dap_devmanfi_tclMsgGetFreeDiskSpaceMethodStart(const dap_devmanfi_tclMsgGetFreeDiskSpaceMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   szDevice = coRef.szDevice;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgGetFreeDiskSpaceMethodStart& dap_devmanfi_tclMsgGetFreeDiskSpaceMethodStart::operator=(const dap_devmanfi_tclMsgGetFreeDiskSpaceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   szDevice = coRef.szDevice;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgGetFreeDiskSpaceMethodStart::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgGetFreeDiskSpaceMethodStart::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_GETFREEDISKSPACE;}
tU8 dap_devmanfi_tclMsgGetFreeDiskSpaceMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_devmanfi_tclMsgGetFreeDiskSpaceMethodStart::vDestroy()
{
   szDevice.vDestroy();
}

tU32 dap_devmanfi_tclMsgGetFreeDiskSpaceMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+szDevice.u32GetSize(u16MajorVersion);
}

tBool dap_devmanfi_tclMsgGetFreeDiskSpaceMethodStart::operator==(const dap_devmanfi_tclMsgGetFreeDiskSpaceMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (szDevice == rfoCmp.szDevice);
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgGetFreeDiskSpaceMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> szDevice;
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgGetFreeDiskSpaceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << szDevice;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgGetFreeDiskSpaceMethodResult::dap_devmanfi_tclMsgGetFreeDiskSpaceMethodResult(const dap_devmanfi_tclMsgGetFreeDiskSpaceMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   u32LowDiscSpace = coRef.u32LowDiscSpace;
   u32HighDiscSpace = coRef.u32HighDiscSpace;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgGetFreeDiskSpaceMethodResult& dap_devmanfi_tclMsgGetFreeDiskSpaceMethodResult::operator=(const dap_devmanfi_tclMsgGetFreeDiskSpaceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u32LowDiscSpace = coRef.u32LowDiscSpace;
   u32HighDiscSpace = coRef.u32HighDiscSpace;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgGetFreeDiskSpaceMethodResult::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgGetFreeDiskSpaceMethodResult::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_GETFREEDISKSPACE;}
tU8 dap_devmanfi_tclMsgGetFreeDiskSpaceMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 dap_devmanfi_tclMsgGetFreeDiskSpaceMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool dap_devmanfi_tclMsgGetFreeDiskSpaceMethodResult::operator==(const dap_devmanfi_tclMsgGetFreeDiskSpaceMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u32LowDiscSpace == rfoCmp.u32LowDiscSpace);
      bResult = bResult && (u32HighDiscSpace == rfoCmp.u32HighDiscSpace);
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgGetFreeDiskSpaceMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> u32LowDiscSpace;
   oIn >> u32HighDiscSpace;
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgGetFreeDiskSpaceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u32LowDiscSpace;
   oOut << u32HighDiscSpace;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgCreateDirectoryMethodStart::dap_devmanfi_tclMsgCreateDirectoryMethodStart(const dap_devmanfi_tclMsgCreateDirectoryMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   szTargetAccessPath = coRef.szTargetAccessPath;
   szDirectoryName = coRef.szDirectoryName;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgCreateDirectoryMethodStart& dap_devmanfi_tclMsgCreateDirectoryMethodStart::operator=(const dap_devmanfi_tclMsgCreateDirectoryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   szTargetAccessPath = coRef.szTargetAccessPath;
   szDirectoryName = coRef.szDirectoryName;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgCreateDirectoryMethodStart::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgCreateDirectoryMethodStart::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_CREATEDIRECTORY;}
tU8 dap_devmanfi_tclMsgCreateDirectoryMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_devmanfi_tclMsgCreateDirectoryMethodStart::vDestroy()
{
   szTargetAccessPath.vDestroy();
   szDirectoryName.vDestroy();
}

tU32 dap_devmanfi_tclMsgCreateDirectoryMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+szTargetAccessPath.u32GetSize(u16MajorVersion)+szDirectoryName.u32GetSize(u16MajorVersion);
}

tBool dap_devmanfi_tclMsgCreateDirectoryMethodStart::operator==(const dap_devmanfi_tclMsgCreateDirectoryMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (szTargetAccessPath == rfoCmp.szTargetAccessPath);
      bResult = bResult && (szDirectoryName == rfoCmp.szDirectoryName);
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgCreateDirectoryMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> szTargetAccessPath;
   oIn >> szDirectoryName;
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgCreateDirectoryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << szTargetAccessPath;
   oOut << szDirectoryName;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgCreateDirectoryMethodResult::dap_devmanfi_tclMsgCreateDirectoryMethodResult(const dap_devmanfi_tclMsgCreateDirectoryMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgCreateDirectoryMethodResult& dap_devmanfi_tclMsgCreateDirectoryMethodResult::operator=(const dap_devmanfi_tclMsgCreateDirectoryMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgCreateDirectoryMethodResult::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgCreateDirectoryMethodResult::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_CREATEDIRECTORY;}
tU8 dap_devmanfi_tclMsgCreateDirectoryMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 dap_devmanfi_tclMsgCreateDirectoryMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_devmanfi_tclMsgCreateDirectoryMethodResult::operator==(const dap_devmanfi_tclMsgCreateDirectoryMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgCreateDirectoryMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgCreateDirectoryMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgCopyFilesMethodStart::dap_devmanfi_tclMsgCopyFilesMethodStart(const dap_devmanfi_tclMsgCopyFilesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   u32SourceMediumId = coRef.u32SourceMediumId;
   szSourceDevice = coRef.szSourceDevice;
   szTargetDevice = coRef.szTargetDevice;
   aoCopyFiles = coRef.aoCopyFiles;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgCopyFilesMethodStart& dap_devmanfi_tclMsgCopyFilesMethodStart::operator=(const dap_devmanfi_tclMsgCopyFilesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32SourceMediumId = coRef.u32SourceMediumId;
   szSourceDevice = coRef.szSourceDevice;
   szTargetDevice = coRef.szTargetDevice;
   aoCopyFiles = coRef.aoCopyFiles;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgCopyFilesMethodStart::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgCopyFilesMethodStart::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_COPYFILES;}
tU8 dap_devmanfi_tclMsgCopyFilesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_devmanfi_tclMsgCopyFilesMethodStart::vDestroy()
{
   szSourceDevice.vDestroy();
   szTargetDevice.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < aoCopyFiles.size(); ++u32Idx)
         aoCopyFiles[u32Idx].vDestroy();
   }
   aoCopyFiles.clear();
}

tU32 dap_devmanfi_tclMsgCopyFilesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < aoCopyFiles.size(); ++u32ListIdx)
      u32DynamicSize += aoCopyFiles[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+szSourceDevice.u32GetSize(u16MajorVersion)+szTargetDevice.u32GetSize(u16MajorVersion);
}

tBool dap_devmanfi_tclMsgCopyFilesMethodStart::operator==(const dap_devmanfi_tclMsgCopyFilesMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u32SourceMediumId == rfoCmp.u32SourceMediumId);
      bResult = bResult && (szSourceDevice == rfoCmp.szSourceDevice);
      bResult = bResult && (szTargetDevice == rfoCmp.szTargetDevice);
      bResult = bResult && (aoCopyFiles.size() == rfoCmp.aoCopyFiles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aoCopyFiles.size()); ++u32Idx)
            bResult = bResult && (aoCopyFiles[u32Idx] == rfoCmp.aoCopyFiles[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgCopyFilesMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> u32SourceMediumId;
   oIn >> szSourceDevice;
   oIn >> szTargetDevice;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aoCopyFiles.size(); ++u32Idx)
      {
         aoCopyFiles[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      aoCopyFiles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> aoCopyFiles[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgCopyFilesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u32SourceMediumId;
   oOut << szSourceDevice;
   oOut << szTargetDevice;
   oOut << (tU32)aoCopyFiles.size();
   {
      for (tU32 u32Idx = 0; u32Idx < aoCopyFiles.size(); ++u32Idx)
         oOut << aoCopyFiles[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgCopyFilesMethodResult::dap_devmanfi_tclMsgCopyFilesMethodResult(const dap_devmanfi_tclMsgCopyFilesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   u16OrderIndex = coRef.u16OrderIndex;
   u16ErrorCode = coRef.u16ErrorCode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgCopyFilesMethodResult& dap_devmanfi_tclMsgCopyFilesMethodResult::operator=(const dap_devmanfi_tclMsgCopyFilesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16OrderIndex = coRef.u16OrderIndex;
   u16ErrorCode = coRef.u16ErrorCode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgCopyFilesMethodResult::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgCopyFilesMethodResult::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_COPYFILES;}
tU8 dap_devmanfi_tclMsgCopyFilesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 dap_devmanfi_tclMsgCopyFilesMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool dap_devmanfi_tclMsgCopyFilesMethodResult::operator==(const dap_devmanfi_tclMsgCopyFilesMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u16OrderIndex == rfoCmp.u16OrderIndex);
      bResult = bResult && (u16ErrorCode == rfoCmp.u16ErrorCode);
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgCopyFilesMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> u16OrderIndex;
   oIn >> u16ErrorCode;
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgCopyFilesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u16OrderIndex;
   oOut << u16ErrorCode;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgWriteToFileMethodStart::dap_devmanfi_tclMsgWriteToFileMethodStart(const dap_devmanfi_tclMsgWriteToFileMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   oTarget = coRef.oTarget;
   u32FileOffset = coRef.u32FileOffset;
   oDataBufferDescriptor = coRef.oDataBufferDescriptor;
   bCloseAfterProcessing = coRef.bCloseAfterProcessing;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgWriteToFileMethodStart& dap_devmanfi_tclMsgWriteToFileMethodStart::operator=(const dap_devmanfi_tclMsgWriteToFileMethodStart& coRef)
{
   if (this == &coRef) return *this;
   oTarget = coRef.oTarget;
   u32FileOffset = coRef.u32FileOffset;
   oDataBufferDescriptor = coRef.oDataBufferDescriptor;
   bCloseAfterProcessing = coRef.bCloseAfterProcessing;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgWriteToFileMethodStart::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgWriteToFileMethodStart::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_WRITETOFILE;}
tU8 dap_devmanfi_tclMsgWriteToFileMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_devmanfi_tclMsgWriteToFileMethodStart::vDestroy()
{
   oTarget.vDestroy(); 
   oDataBufferDescriptor.vDestroy(); 
}

tU32 dap_devmanfi_tclMsgWriteToFileMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+oTarget.u32GetSize(u16MajorVersion)+oDataBufferDescriptor.u32GetSize(u16MajorVersion);
}

tBool dap_devmanfi_tclMsgWriteToFileMethodStart::operator==(const dap_devmanfi_tclMsgWriteToFileMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (oTarget == rfoCmp.oTarget);
      bResult = bResult && (u32FileOffset == rfoCmp.u32FileOffset);
      bResult = bResult && (oDataBufferDescriptor == rfoCmp.oDataBufferDescriptor);
      bResult = bResult && (bCloseAfterProcessing == rfoCmp.bCloseAfterProcessing);
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgWriteToFileMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> oTarget;
   oIn >> u32FileOffset;
   oIn >> oDataBufferDescriptor;
   oIn >> bCloseAfterProcessing;
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgWriteToFileMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << oTarget;
   oOut << u32FileOffset;
   oOut << oDataBufferDescriptor;
   oOut << bCloseAfterProcessing;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgWriteToFileMethodResult::dap_devmanfi_tclMsgWriteToFileMethodResult(const dap_devmanfi_tclMsgWriteToFileMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgWriteToFileMethodResult& dap_devmanfi_tclMsgWriteToFileMethodResult::operator=(const dap_devmanfi_tclMsgWriteToFileMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgWriteToFileMethodResult::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgWriteToFileMethodResult::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_WRITETOFILE;}
tU8 dap_devmanfi_tclMsgWriteToFileMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 dap_devmanfi_tclMsgWriteToFileMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_devmanfi_tclMsgWriteToFileMethodResult::operator==(const dap_devmanfi_tclMsgWriteToFileMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgWriteToFileMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgWriteToFileMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgRenameMethodStart::dap_devmanfi_tclMsgRenameMethodStart(const dap_devmanfi_tclMsgRenameMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   oSource = coRef.oSource;
   szNewFilename = coRef.szNewFilename;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgRenameMethodStart& dap_devmanfi_tclMsgRenameMethodStart::operator=(const dap_devmanfi_tclMsgRenameMethodStart& coRef)
{
   if (this == &coRef) return *this;
   oSource = coRef.oSource;
   szNewFilename = coRef.szNewFilename;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgRenameMethodStart::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgRenameMethodStart::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_RENAME;}
tU8 dap_devmanfi_tclMsgRenameMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_devmanfi_tclMsgRenameMethodStart::vDestroy()
{
   oSource.vDestroy(); 
   szNewFilename.vDestroy();
}

tU32 dap_devmanfi_tclMsgRenameMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+oSource.u32GetSize(u16MajorVersion)+szNewFilename.u32GetSize(u16MajorVersion);
}

tBool dap_devmanfi_tclMsgRenameMethodStart::operator==(const dap_devmanfi_tclMsgRenameMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (oSource == rfoCmp.oSource);
      bResult = bResult && (szNewFilename == rfoCmp.szNewFilename);
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgRenameMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> oSource;
   oIn >> szNewFilename;
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgRenameMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << oSource;
   oOut << szNewFilename;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgRenameMethodResult::dap_devmanfi_tclMsgRenameMethodResult(const dap_devmanfi_tclMsgRenameMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgRenameMethodResult& dap_devmanfi_tclMsgRenameMethodResult::operator=(const dap_devmanfi_tclMsgRenameMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgRenameMethodResult::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgRenameMethodResult::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_RENAME;}
tU8 dap_devmanfi_tclMsgRenameMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 dap_devmanfi_tclMsgRenameMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_devmanfi_tclMsgRenameMethodResult::operator==(const dap_devmanfi_tclMsgRenameMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgRenameMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgRenameMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgRemoveFilesMethodStart::dap_devmanfi_tclMsgRemoveFilesMethodStart(const dap_devmanfi_tclMsgRemoveFilesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   szPath = coRef.szPath;
   szFilenameList = coRef.szFilenameList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgRemoveFilesMethodStart& dap_devmanfi_tclMsgRemoveFilesMethodStart::operator=(const dap_devmanfi_tclMsgRemoveFilesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   szPath = coRef.szPath;
   szFilenameList = coRef.szFilenameList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgRemoveFilesMethodStart::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgRemoveFilesMethodStart::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_REMOVEFILES;}
tU8 dap_devmanfi_tclMsgRemoveFilesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_devmanfi_tclMsgRemoveFilesMethodStart::vDestroy()
{
   szPath.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < szFilenameList.size(); ++u32Idx)
         szFilenameList[u32Idx].vDestroy();
   }
   szFilenameList.clear();
}

tU32 dap_devmanfi_tclMsgRemoveFilesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < szFilenameList.size(); ++u32ListIdx)
      u32DynamicSize += szFilenameList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4+szPath.u32GetSize(u16MajorVersion);
}

tBool dap_devmanfi_tclMsgRemoveFilesMethodStart::operator==(const dap_devmanfi_tclMsgRemoveFilesMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (szPath == rfoCmp.szPath);
      bResult = bResult && (szFilenameList.size() == rfoCmp.szFilenameList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < szFilenameList.size()); ++u32Idx)
            bResult = bResult && (szFilenameList[u32Idx] == rfoCmp.szFilenameList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgRemoveFilesMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> szPath;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < szFilenameList.size(); ++u32Idx)
      {
         szFilenameList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      szFilenameList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> szFilenameList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgRemoveFilesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << szPath;
   oOut << (tU32)szFilenameList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < szFilenameList.size(); ++u32Idx)
         oOut << szFilenameList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgRemoveFilesMethodResult::dap_devmanfi_tclMsgRemoveFilesMethodResult(const dap_devmanfi_tclMsgRemoveFilesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   u16OrderIndex = coRef.u16OrderIndex;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgRemoveFilesMethodResult& dap_devmanfi_tclMsgRemoveFilesMethodResult::operator=(const dap_devmanfi_tclMsgRemoveFilesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16OrderIndex = coRef.u16OrderIndex;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgRemoveFilesMethodResult::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgRemoveFilesMethodResult::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_REMOVEFILES;}
tU8 dap_devmanfi_tclMsgRemoveFilesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 dap_devmanfi_tclMsgRemoveFilesMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool dap_devmanfi_tclMsgRemoveFilesMethodResult::operator==(const dap_devmanfi_tclMsgRemoveFilesMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u16OrderIndex == rfoCmp.u16OrderIndex);
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgRemoveFilesMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> u16OrderIndex;
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgRemoveFilesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u16OrderIndex;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgRemoveDirectoryMethodStart::dap_devmanfi_tclMsgRemoveDirectoryMethodStart(const dap_devmanfi_tclMsgRemoveDirectoryMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   szPath = coRef.szPath;
   szDirectoryName = coRef.szDirectoryName;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgRemoveDirectoryMethodStart& dap_devmanfi_tclMsgRemoveDirectoryMethodStart::operator=(const dap_devmanfi_tclMsgRemoveDirectoryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   szPath = coRef.szPath;
   szDirectoryName = coRef.szDirectoryName;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgRemoveDirectoryMethodStart::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgRemoveDirectoryMethodStart::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_REMOVEDIRECTORY;}
tU8 dap_devmanfi_tclMsgRemoveDirectoryMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid dap_devmanfi_tclMsgRemoveDirectoryMethodStart::vDestroy()
{
   szPath.vDestroy();
   szDirectoryName.vDestroy();
}

tU32 dap_devmanfi_tclMsgRemoveDirectoryMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+szPath.u32GetSize(u16MajorVersion)+szDirectoryName.u32GetSize(u16MajorVersion);
}

tBool dap_devmanfi_tclMsgRemoveDirectoryMethodStart::operator==(const dap_devmanfi_tclMsgRemoveDirectoryMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (szPath == rfoCmp.szPath);
      bResult = bResult && (szDirectoryName == rfoCmp.szDirectoryName);
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgRemoveDirectoryMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> szPath;
   oIn >> szDirectoryName;
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgRemoveDirectoryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << szPath;
   oOut << szDirectoryName;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgRemoveDirectoryMethodResult::dap_devmanfi_tclMsgRemoveDirectoryMethodResult(const dap_devmanfi_tclMsgRemoveDirectoryMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgRemoveDirectoryMethodResult& dap_devmanfi_tclMsgRemoveDirectoryMethodResult::operator=(const dap_devmanfi_tclMsgRemoveDirectoryMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgRemoveDirectoryMethodResult::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgRemoveDirectoryMethodResult::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_REMOVEDIRECTORY;}
tU8 dap_devmanfi_tclMsgRemoveDirectoryMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 dap_devmanfi_tclMsgRemoveDirectoryMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_devmanfi_tclMsgRemoveDirectoryMethodResult::operator==(const dap_devmanfi_tclMsgRemoveDirectoryMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgRemoveDirectoryMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgRemoveDirectoryMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgTimerProcessedMethodStart::dap_devmanfi_tclMsgTimerProcessedMethodStart(const dap_devmanfi_tclMsgTimerProcessedMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgTimerProcessedMethodStart& dap_devmanfi_tclMsgTimerProcessedMethodStart::operator=(const dap_devmanfi_tclMsgTimerProcessedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgTimerProcessedMethodStart::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgTimerProcessedMethodStart::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_TIMERPROCESSED;}
tU8 dap_devmanfi_tclMsgTimerProcessedMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 dap_devmanfi_tclMsgTimerProcessedMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_devmanfi_tclMsgTimerProcessedMethodStart::operator==(const dap_devmanfi_tclMsgTimerProcessedMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgTimerProcessedMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgTimerProcessedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgTimerProcessedMethodResult::dap_devmanfi_tclMsgTimerProcessedMethodResult(const dap_devmanfi_tclMsgTimerProcessedMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgTimerProcessedMethodResult& dap_devmanfi_tclMsgTimerProcessedMethodResult::operator=(const dap_devmanfi_tclMsgTimerProcessedMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgTimerProcessedMethodResult::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgTimerProcessedMethodResult::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_TIMERPROCESSED;}
tU8 dap_devmanfi_tclMsgTimerProcessedMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 dap_devmanfi_tclMsgTimerProcessedMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_devmanfi_tclMsgTimerProcessedMethodResult::operator==(const dap_devmanfi_tclMsgTimerProcessedMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgTimerProcessedMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgTimerProcessedMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDataTypeInfoUpReg::dap_devmanfi_tclMsgDataTypeInfoUpReg(const dap_devmanfi_tclMsgDataTypeInfoUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDataTypeInfoUpReg& dap_devmanfi_tclMsgDataTypeInfoUpReg::operator=(const dap_devmanfi_tclMsgDataTypeInfoUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgDataTypeInfoUpReg::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgDataTypeInfoUpReg::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_DATATYPEINFO;}
tU8 dap_devmanfi_tclMsgDataTypeInfoUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 dap_devmanfi_tclMsgDataTypeInfoUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_devmanfi_tclMsgDataTypeInfoUpReg::operator==(const dap_devmanfi_tclMsgDataTypeInfoUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgDataTypeInfoUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgDataTypeInfoUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDataTypeInfoRelUpReg::dap_devmanfi_tclMsgDataTypeInfoRelUpReg(const dap_devmanfi_tclMsgDataTypeInfoRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDataTypeInfoRelUpReg& dap_devmanfi_tclMsgDataTypeInfoRelUpReg::operator=(const dap_devmanfi_tclMsgDataTypeInfoRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgDataTypeInfoRelUpReg::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgDataTypeInfoRelUpReg::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_DATATYPEINFO;}
tU8 dap_devmanfi_tclMsgDataTypeInfoRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 dap_devmanfi_tclMsgDataTypeInfoRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_devmanfi_tclMsgDataTypeInfoRelUpReg::operator==(const dap_devmanfi_tclMsgDataTypeInfoRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgDataTypeInfoRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgDataTypeInfoRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDataTypeInfoStatus::dap_devmanfi_tclMsgDataTypeInfoStatus(const dap_devmanfi_tclMsgDataTypeInfoStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   aoDataInfos = coRef.aoDataInfos;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDataTypeInfoStatus& dap_devmanfi_tclMsgDataTypeInfoStatus::operator=(const dap_devmanfi_tclMsgDataTypeInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   aoDataInfos = coRef.aoDataInfos;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgDataTypeInfoStatus::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgDataTypeInfoStatus::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_DATATYPEINFO;}
tU8 dap_devmanfi_tclMsgDataTypeInfoStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid dap_devmanfi_tclMsgDataTypeInfoStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < aoDataInfos.size(); ++u32Idx)
         aoDataInfos[u32Idx].vDestroy();
   }
   aoDataInfos.clear();
}

tU32 dap_devmanfi_tclMsgDataTypeInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < aoDataInfos.size(); ++u32ListIdx)
      u32DynamicSize += aoDataInfos[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool dap_devmanfi_tclMsgDataTypeInfoStatus::operator==(const dap_devmanfi_tclMsgDataTypeInfoStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (aoDataInfos.size() == rfoCmp.aoDataInfos.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aoDataInfos.size()); ++u32Idx)
            bResult = bResult && (aoDataInfos[u32Idx] == rfoCmp.aoDataInfos[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgDataTypeInfoStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aoDataInfos.size(); ++u32Idx)
      {
         aoDataInfos[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      aoDataInfos.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> aoDataInfos[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgDataTypeInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)aoDataInfos.size();
   {
      for (tU32 u32Idx = 0; u32Idx < aoDataInfos.size(); ++u32Idx)
         oOut << aoDataInfos[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgMediaInfoUpReg::dap_devmanfi_tclMsgMediaInfoUpReg(const dap_devmanfi_tclMsgMediaInfoUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgMediaInfoUpReg& dap_devmanfi_tclMsgMediaInfoUpReg::operator=(const dap_devmanfi_tclMsgMediaInfoUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgMediaInfoUpReg::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgMediaInfoUpReg::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_MEDIAINFO;}
tU8 dap_devmanfi_tclMsgMediaInfoUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 dap_devmanfi_tclMsgMediaInfoUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_devmanfi_tclMsgMediaInfoUpReg::operator==(const dap_devmanfi_tclMsgMediaInfoUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgMediaInfoUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgMediaInfoUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgMediaInfoRelUpReg::dap_devmanfi_tclMsgMediaInfoRelUpReg(const dap_devmanfi_tclMsgMediaInfoRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgMediaInfoRelUpReg& dap_devmanfi_tclMsgMediaInfoRelUpReg::operator=(const dap_devmanfi_tclMsgMediaInfoRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgMediaInfoRelUpReg::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgMediaInfoRelUpReg::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_MEDIAINFO;}
tU8 dap_devmanfi_tclMsgMediaInfoRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 dap_devmanfi_tclMsgMediaInfoRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_devmanfi_tclMsgMediaInfoRelUpReg::operator==(const dap_devmanfi_tclMsgMediaInfoRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgMediaInfoRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgMediaInfoRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgMediaInfoStatus::dap_devmanfi_tclMsgMediaInfoStatus(const dap_devmanfi_tclMsgMediaInfoStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   aoMediaInfos = coRef.aoMediaInfos;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgMediaInfoStatus& dap_devmanfi_tclMsgMediaInfoStatus::operator=(const dap_devmanfi_tclMsgMediaInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   aoMediaInfos = coRef.aoMediaInfos;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgMediaInfoStatus::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgMediaInfoStatus::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_MEDIAINFO;}
tU8 dap_devmanfi_tclMsgMediaInfoStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid dap_devmanfi_tclMsgMediaInfoStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < aoMediaInfos.size(); ++u32Idx)
         aoMediaInfos[u32Idx].vDestroy();
   }
   aoMediaInfos.clear();
}

tU32 dap_devmanfi_tclMsgMediaInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < aoMediaInfos.size(); ++u32ListIdx)
      u32DynamicSize += aoMediaInfos[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool dap_devmanfi_tclMsgMediaInfoStatus::operator==(const dap_devmanfi_tclMsgMediaInfoStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (aoMediaInfos.size() == rfoCmp.aoMediaInfos.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aoMediaInfos.size()); ++u32Idx)
            bResult = bResult && (aoMediaInfos[u32Idx] == rfoCmp.aoMediaInfos[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgMediaInfoStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aoMediaInfos.size(); ++u32Idx)
      {
         aoMediaInfos[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      aoMediaInfos.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> aoMediaInfos[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgMediaInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)aoMediaInfos.size();
   {
      for (tU32 u32Idx = 0; u32Idx < aoMediaInfos.size(); ++u32Idx)
         oOut << aoMediaInfos[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDeviceStatusInfoUpReg::dap_devmanfi_tclMsgDeviceStatusInfoUpReg(const dap_devmanfi_tclMsgDeviceStatusInfoUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDeviceStatusInfoUpReg& dap_devmanfi_tclMsgDeviceStatusInfoUpReg::operator=(const dap_devmanfi_tclMsgDeviceStatusInfoUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgDeviceStatusInfoUpReg::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgDeviceStatusInfoUpReg::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_DEVICESTATUSINFO;}
tU8 dap_devmanfi_tclMsgDeviceStatusInfoUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 dap_devmanfi_tclMsgDeviceStatusInfoUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_devmanfi_tclMsgDeviceStatusInfoUpReg::operator==(const dap_devmanfi_tclMsgDeviceStatusInfoUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgDeviceStatusInfoUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgDeviceStatusInfoUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDeviceStatusInfoRelUpReg::dap_devmanfi_tclMsgDeviceStatusInfoRelUpReg(const dap_devmanfi_tclMsgDeviceStatusInfoRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDeviceStatusInfoRelUpReg& dap_devmanfi_tclMsgDeviceStatusInfoRelUpReg::operator=(const dap_devmanfi_tclMsgDeviceStatusInfoRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgDeviceStatusInfoRelUpReg::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgDeviceStatusInfoRelUpReg::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_DEVICESTATUSINFO;}
tU8 dap_devmanfi_tclMsgDeviceStatusInfoRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 dap_devmanfi_tclMsgDeviceStatusInfoRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_devmanfi_tclMsgDeviceStatusInfoRelUpReg::operator==(const dap_devmanfi_tclMsgDeviceStatusInfoRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgDeviceStatusInfoRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgDeviceStatusInfoRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDeviceStatusInfoStatus::dap_devmanfi_tclMsgDeviceStatusInfoStatus(const dap_devmanfi_tclMsgDeviceStatusInfoStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   aoDeviceInfos = coRef.aoDeviceInfos;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDeviceStatusInfoStatus& dap_devmanfi_tclMsgDeviceStatusInfoStatus::operator=(const dap_devmanfi_tclMsgDeviceStatusInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   aoDeviceInfos = coRef.aoDeviceInfos;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgDeviceStatusInfoStatus::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgDeviceStatusInfoStatus::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_DEVICESTATUSINFO;}
tU8 dap_devmanfi_tclMsgDeviceStatusInfoStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid dap_devmanfi_tclMsgDeviceStatusInfoStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < aoDeviceInfos.size(); ++u32Idx)
         aoDeviceInfos[u32Idx].vDestroy();
   }
   aoDeviceInfos.clear();
}

tU32 dap_devmanfi_tclMsgDeviceStatusInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < aoDeviceInfos.size(); ++u32ListIdx)
      u32DynamicSize += aoDeviceInfos[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool dap_devmanfi_tclMsgDeviceStatusInfoStatus::operator==(const dap_devmanfi_tclMsgDeviceStatusInfoStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (aoDeviceInfos.size() == rfoCmp.aoDeviceInfos.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aoDeviceInfos.size()); ++u32Idx)
            bResult = bResult && (aoDeviceInfos[u32Idx] == rfoCmp.aoDeviceInfos[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgDeviceStatusInfoStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aoDeviceInfos.size(); ++u32Idx)
      {
         aoDeviceInfos[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      aoDeviceInfos.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> aoDeviceInfos[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgDeviceStatusInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)aoDeviceInfos.size();
   {
      for (tU32 u32Idx = 0; u32Idx < aoDeviceInfos.size(); ++u32Idx)
         oOut << aoDeviceInfos[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgPRMNotificationStatus::dap_devmanfi_tclMsgPRMNotificationStatus(const dap_devmanfi_tclMsgPRMNotificationStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   u32NotificationData = coRef.u32NotificationData;
   enNotification = coRef.enNotification;
   szDevicePath = coRef.szDevicePath;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgPRMNotificationStatus& dap_devmanfi_tclMsgPRMNotificationStatus::operator=(const dap_devmanfi_tclMsgPRMNotificationStatus& coRef)
{
   if (this == &coRef) return *this;
   u32NotificationData = coRef.u32NotificationData;
   enNotification = coRef.enNotification;
   szDevicePath = coRef.szDevicePath;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgPRMNotificationStatus::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgPRMNotificationStatus::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_PRMNOTIFICATION;}
tU8 dap_devmanfi_tclMsgPRMNotificationStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid dap_devmanfi_tclMsgPRMNotificationStatus::vDestroy()
{
   szDevicePath.vDestroy();
}

tU32 dap_devmanfi_tclMsgPRMNotificationStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+szDevicePath.u32GetSize(u16MajorVersion);
}

tBool dap_devmanfi_tclMsgPRMNotificationStatus::operator==(const dap_devmanfi_tclMsgPRMNotificationStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u32NotificationData == rfoCmp.u32NotificationData);
      bResult = bResult && (enNotification == rfoCmp.enNotification);
      bResult = bResult && (szDevicePath == rfoCmp.szDevicePath);
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgPRMNotificationStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> u32NotificationData;
   oIn >> enNotification;
   oIn >> szDevicePath;
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgPRMNotificationStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u32NotificationData;
   oOut << enNotification;
   oOut << szDevicePath;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDefaultDataInfoUpReg::dap_devmanfi_tclMsgDefaultDataInfoUpReg(const dap_devmanfi_tclMsgDefaultDataInfoUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDefaultDataInfoUpReg& dap_devmanfi_tclMsgDefaultDataInfoUpReg::operator=(const dap_devmanfi_tclMsgDefaultDataInfoUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgDefaultDataInfoUpReg::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgDefaultDataInfoUpReg::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_DEFAULTDATAINFO;}
tU8 dap_devmanfi_tclMsgDefaultDataInfoUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 dap_devmanfi_tclMsgDefaultDataInfoUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_devmanfi_tclMsgDefaultDataInfoUpReg::operator==(const dap_devmanfi_tclMsgDefaultDataInfoUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgDefaultDataInfoUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgDefaultDataInfoUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDefaultDataInfoRelUpReg::dap_devmanfi_tclMsgDefaultDataInfoRelUpReg(const dap_devmanfi_tclMsgDefaultDataInfoRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDefaultDataInfoRelUpReg& dap_devmanfi_tclMsgDefaultDataInfoRelUpReg::operator=(const dap_devmanfi_tclMsgDefaultDataInfoRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgDefaultDataInfoRelUpReg::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgDefaultDataInfoRelUpReg::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_DEFAULTDATAINFO;}
tU8 dap_devmanfi_tclMsgDefaultDataInfoRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 dap_devmanfi_tclMsgDefaultDataInfoRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_devmanfi_tclMsgDefaultDataInfoRelUpReg::operator==(const dap_devmanfi_tclMsgDefaultDataInfoRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgDefaultDataInfoRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgDefaultDataInfoRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDefaultDataInfoStatus::dap_devmanfi_tclMsgDefaultDataInfoStatus(const dap_devmanfi_tclMsgDefaultDataInfoStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   aoDataInfos = coRef.aoDataInfos;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDefaultDataInfoStatus& dap_devmanfi_tclMsgDefaultDataInfoStatus::operator=(const dap_devmanfi_tclMsgDefaultDataInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   aoDataInfos = coRef.aoDataInfos;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgDefaultDataInfoStatus::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgDefaultDataInfoStatus::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_DEFAULTDATAINFO;}
tU8 dap_devmanfi_tclMsgDefaultDataInfoStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid dap_devmanfi_tclMsgDefaultDataInfoStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < aoDataInfos.size(); ++u32Idx)
         aoDataInfos[u32Idx].vDestroy();
   }
   aoDataInfos.clear();
}

tU32 dap_devmanfi_tclMsgDefaultDataInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < aoDataInfos.size(); ++u32ListIdx)
      u32DynamicSize += aoDataInfos[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool dap_devmanfi_tclMsgDefaultDataInfoStatus::operator==(const dap_devmanfi_tclMsgDefaultDataInfoStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (aoDataInfos.size() == rfoCmp.aoDataInfos.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < aoDataInfos.size()); ++u32Idx)
            bResult = bResult && (aoDataInfos[u32Idx] == rfoCmp.aoDataInfos[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgDefaultDataInfoStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < aoDataInfos.size(); ++u32Idx)
      {
         aoDataInfos[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      aoDataInfos.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> aoDataInfos[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgDefaultDataInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)aoDataInfos.size();
   {
      for (tU32 u32Idx = 0; u32Idx < aoDataInfos.size(); ++u32Idx)
         oOut << aoDataInfos[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDefaultDeviceSet::dap_devmanfi_tclMsgDefaultDeviceSet(const dap_devmanfi_tclMsgDefaultDeviceSet& coRef):fi_tclVisitableTypeBase(coRef)
{
   szDevice = coRef.szDevice;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDefaultDeviceSet& dap_devmanfi_tclMsgDefaultDeviceSet::operator=(const dap_devmanfi_tclMsgDefaultDeviceSet& coRef)
{
   if (this == &coRef) return *this;
   szDevice = coRef.szDevice;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgDefaultDeviceSet::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgDefaultDeviceSet::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_DEFAULTDEVICE;}
tU8 dap_devmanfi_tclMsgDefaultDeviceSet::u8GetOpCode() const {return CCA_C_U8_OPCODE_SET;}

tVoid dap_devmanfi_tclMsgDefaultDeviceSet::vDestroy()
{
   szDevice.vDestroy();
}

tU32 dap_devmanfi_tclMsgDefaultDeviceSet::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+szDevice.u32GetSize(u16MajorVersion);
}

tBool dap_devmanfi_tclMsgDefaultDeviceSet::operator==(const dap_devmanfi_tclMsgDefaultDeviceSet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (szDevice == rfoCmp.szDevice);
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgDefaultDeviceSet::oRead(fi_tclInContext& oIn)
{
   oIn >> szDevice;
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgDefaultDeviceSet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << szDevice;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDefaultDeviceStatus::dap_devmanfi_tclMsgDefaultDeviceStatus(const dap_devmanfi_tclMsgDefaultDeviceStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   szDevice = coRef.szDevice;
   ErrorState = coRef.ErrorState;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDefaultDeviceStatus& dap_devmanfi_tclMsgDefaultDeviceStatus::operator=(const dap_devmanfi_tclMsgDefaultDeviceStatus& coRef)
{
   if (this == &coRef) return *this;
   szDevice = coRef.szDevice;
   ErrorState = coRef.ErrorState;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgDefaultDeviceStatus::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgDefaultDeviceStatus::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_DEFAULTDEVICE;}
tU8 dap_devmanfi_tclMsgDefaultDeviceStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid dap_devmanfi_tclMsgDefaultDeviceStatus::vDestroy()
{
   szDevice.vDestroy();
}

tU32 dap_devmanfi_tclMsgDefaultDeviceStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+szDevice.u32GetSize(u16MajorVersion);
}

tBool dap_devmanfi_tclMsgDefaultDeviceStatus::operator==(const dap_devmanfi_tclMsgDefaultDeviceStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (szDevice == rfoCmp.szDevice);
      bResult = bResult && (ErrorState == rfoCmp.ErrorState);
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgDefaultDeviceStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> szDevice;
   oIn >> ErrorState;
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgDefaultDeviceStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << szDevice;
   oOut << ErrorState;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgRegionDescriptionsUpReg::dap_devmanfi_tclMsgRegionDescriptionsUpReg(const dap_devmanfi_tclMsgRegionDescriptionsUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgRegionDescriptionsUpReg& dap_devmanfi_tclMsgRegionDescriptionsUpReg::operator=(const dap_devmanfi_tclMsgRegionDescriptionsUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgRegionDescriptionsUpReg::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgRegionDescriptionsUpReg::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_REGIONDESCRIPTIONS;}
tU8 dap_devmanfi_tclMsgRegionDescriptionsUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 dap_devmanfi_tclMsgRegionDescriptionsUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_devmanfi_tclMsgRegionDescriptionsUpReg::operator==(const dap_devmanfi_tclMsgRegionDescriptionsUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgRegionDescriptionsUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgRegionDescriptionsUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgRegionDescriptionsRelUpReg::dap_devmanfi_tclMsgRegionDescriptionsRelUpReg(const dap_devmanfi_tclMsgRegionDescriptionsRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgRegionDescriptionsRelUpReg& dap_devmanfi_tclMsgRegionDescriptionsRelUpReg::operator=(const dap_devmanfi_tclMsgRegionDescriptionsRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgRegionDescriptionsRelUpReg::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgRegionDescriptionsRelUpReg::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_REGIONDESCRIPTIONS;}
tU8 dap_devmanfi_tclMsgRegionDescriptionsRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 dap_devmanfi_tclMsgRegionDescriptionsRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_devmanfi_tclMsgRegionDescriptionsRelUpReg::operator==(const dap_devmanfi_tclMsgRegionDescriptionsRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgRegionDescriptionsRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgRegionDescriptionsRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgRegionDescriptionsStatus::dap_devmanfi_tclMsgRegionDescriptionsStatus(const dap_devmanfi_tclMsgRegionDescriptionsStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   oRegionDescrLists = coRef.oRegionDescrLists;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgRegionDescriptionsStatus& dap_devmanfi_tclMsgRegionDescriptionsStatus::operator=(const dap_devmanfi_tclMsgRegionDescriptionsStatus& coRef)
{
   if (this == &coRef) return *this;
   oRegionDescrLists = coRef.oRegionDescrLists;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgRegionDescriptionsStatus::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgRegionDescriptionsStatus::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_REGIONDESCRIPTIONS;}
tU8 dap_devmanfi_tclMsgRegionDescriptionsStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid dap_devmanfi_tclMsgRegionDescriptionsStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oRegionDescrLists.size(); ++u32Idx)
         oRegionDescrLists[u32Idx].vDestroy();
   }
   oRegionDescrLists.clear();
}

tU32 dap_devmanfi_tclMsgRegionDescriptionsStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oRegionDescrLists.size(); ++u32ListIdx)
      u32DynamicSize += oRegionDescrLists[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool dap_devmanfi_tclMsgRegionDescriptionsStatus::operator==(const dap_devmanfi_tclMsgRegionDescriptionsStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (oRegionDescrLists.size() == rfoCmp.oRegionDescrLists.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oRegionDescrLists.size()); ++u32Idx)
            bResult = bResult && (oRegionDescrLists[u32Idx] == rfoCmp.oRegionDescrLists[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgRegionDescriptionsStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oRegionDescrLists.size(); ++u32Idx)
      {
         oRegionDescrLists[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      oRegionDescrLists.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> oRegionDescrLists[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgRegionDescriptionsStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)oRegionDescrLists.size();
   {
      for (tU32 u32Idx = 0; u32Idx < oRegionDescrLists.size(); ++u32Idx)
         oOut << oRegionDescrLists[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgRegionMetaDataUpReg::dap_devmanfi_tclMsgRegionMetaDataUpReg(const dap_devmanfi_tclMsgRegionMetaDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgRegionMetaDataUpReg& dap_devmanfi_tclMsgRegionMetaDataUpReg::operator=(const dap_devmanfi_tclMsgRegionMetaDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgRegionMetaDataUpReg::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgRegionMetaDataUpReg::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_REGIONMETADATA;}
tU8 dap_devmanfi_tclMsgRegionMetaDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 dap_devmanfi_tclMsgRegionMetaDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_devmanfi_tclMsgRegionMetaDataUpReg::operator==(const dap_devmanfi_tclMsgRegionMetaDataUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgRegionMetaDataUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgRegionMetaDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgRegionMetaDataRelUpReg::dap_devmanfi_tclMsgRegionMetaDataRelUpReg(const dap_devmanfi_tclMsgRegionMetaDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgRegionMetaDataRelUpReg& dap_devmanfi_tclMsgRegionMetaDataRelUpReg::operator=(const dap_devmanfi_tclMsgRegionMetaDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgRegionMetaDataRelUpReg::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgRegionMetaDataRelUpReg::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_REGIONMETADATA;}
tU8 dap_devmanfi_tclMsgRegionMetaDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 dap_devmanfi_tclMsgRegionMetaDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_devmanfi_tclMsgRegionMetaDataRelUpReg::operator==(const dap_devmanfi_tclMsgRegionMetaDataRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgRegionMetaDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgRegionMetaDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgRegionMetaDataStatus::dap_devmanfi_tclMsgRegionMetaDataStatus(const dap_devmanfi_tclMsgRegionMetaDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   u32DatasetId = coRef.u32DatasetId;
   oRegionMetaInfoList = coRef.oRegionMetaInfoList;
   oProfileMetaInfoList = coRef.oProfileMetaInfoList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgRegionMetaDataStatus& dap_devmanfi_tclMsgRegionMetaDataStatus::operator=(const dap_devmanfi_tclMsgRegionMetaDataStatus& coRef)
{
   if (this == &coRef) return *this;
   u32DatasetId = coRef.u32DatasetId;
   oRegionMetaInfoList = coRef.oRegionMetaInfoList;
   oProfileMetaInfoList = coRef.oProfileMetaInfoList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgRegionMetaDataStatus::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgRegionMetaDataStatus::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_REGIONMETADATA;}
tU8 dap_devmanfi_tclMsgRegionMetaDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid dap_devmanfi_tclMsgRegionMetaDataStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oRegionMetaInfoList.size(); ++u32Idx)
         oRegionMetaInfoList[u32Idx].vDestroy();
   }
   oRegionMetaInfoList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < oProfileMetaInfoList.size(); ++u32Idx)
         oProfileMetaInfoList[u32Idx].vDestroy();
   }
   oProfileMetaInfoList.clear();
}

tU32 dap_devmanfi_tclMsgRegionMetaDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oRegionMetaInfoList.size(); ++u32ListIdx)
      u32DynamicSize += oRegionMetaInfoList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < oProfileMetaInfoList.size(); ++u32ListIdx)
      u32DynamicSize += oProfileMetaInfoList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+12;
}

tBool dap_devmanfi_tclMsgRegionMetaDataStatus::operator==(const dap_devmanfi_tclMsgRegionMetaDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (u32DatasetId == rfoCmp.u32DatasetId);
      bResult = bResult && (oRegionMetaInfoList.size() == rfoCmp.oRegionMetaInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oRegionMetaInfoList.size()); ++u32Idx)
            bResult = bResult && (oRegionMetaInfoList[u32Idx] == rfoCmp.oRegionMetaInfoList[u32Idx]);
      }
      bResult = bResult && (oProfileMetaInfoList.size() == rfoCmp.oProfileMetaInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oProfileMetaInfoList.size()); ++u32Idx)
            bResult = bResult && (oProfileMetaInfoList[u32Idx] == rfoCmp.oProfileMetaInfoList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgRegionMetaDataStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> u32DatasetId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oRegionMetaInfoList.size(); ++u32Idx)
      {
         oRegionMetaInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      oRegionMetaInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> oRegionMetaInfoList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oProfileMetaInfoList.size(); ++u32Idx)
      {
         oProfileMetaInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      oProfileMetaInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> oProfileMetaInfoList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgRegionMetaDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << u32DatasetId;
   oOut << (tU32)oRegionMetaInfoList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < oRegionMetaInfoList.size(); ++u32Idx)
         oOut << oRegionMetaInfoList[u32Idx];
   }
   oOut << (tU32)oProfileMetaInfoList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < oProfileMetaInfoList.size(); ++u32Idx)
         oOut << oProfileMetaInfoList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDataVisibilitySet::dap_devmanfi_tclMsgDataVisibilitySet(const dap_devmanfi_tclMsgDataVisibilitySet& coRef):fi_tclVisitableTypeBase(coRef)
{
   bVisible = coRef.bVisible;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDataVisibilitySet& dap_devmanfi_tclMsgDataVisibilitySet::operator=(const dap_devmanfi_tclMsgDataVisibilitySet& coRef)
{
   if (this == &coRef) return *this;
   bVisible = coRef.bVisible;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgDataVisibilitySet::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgDataVisibilitySet::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_DATAVISIBILITY;}
tU8 dap_devmanfi_tclMsgDataVisibilitySet::u8GetOpCode() const {return CCA_C_U8_OPCODE_SET;}

tU32 dap_devmanfi_tclMsgDataVisibilitySet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool dap_devmanfi_tclMsgDataVisibilitySet::operator==(const dap_devmanfi_tclMsgDataVisibilitySet& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (bVisible == rfoCmp.bVisible);
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgDataVisibilitySet::oRead(fi_tclInContext& oIn)
{
   oIn >> bVisible;
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgDataVisibilitySet::oWrite(fi_tclOutContext& oOut) const
{
   oOut << bVisible;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDataVisibilityUpReg::dap_devmanfi_tclMsgDataVisibilityUpReg(const dap_devmanfi_tclMsgDataVisibilityUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDataVisibilityUpReg& dap_devmanfi_tclMsgDataVisibilityUpReg::operator=(const dap_devmanfi_tclMsgDataVisibilityUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgDataVisibilityUpReg::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgDataVisibilityUpReg::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_DATAVISIBILITY;}
tU8 dap_devmanfi_tclMsgDataVisibilityUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 dap_devmanfi_tclMsgDataVisibilityUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_devmanfi_tclMsgDataVisibilityUpReg::operator==(const dap_devmanfi_tclMsgDataVisibilityUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgDataVisibilityUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgDataVisibilityUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDataVisibilityRelUpReg::dap_devmanfi_tclMsgDataVisibilityRelUpReg(const dap_devmanfi_tclMsgDataVisibilityRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDataVisibilityRelUpReg& dap_devmanfi_tclMsgDataVisibilityRelUpReg::operator=(const dap_devmanfi_tclMsgDataVisibilityRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgDataVisibilityRelUpReg::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgDataVisibilityRelUpReg::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_DATAVISIBILITY;}
tU8 dap_devmanfi_tclMsgDataVisibilityRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 dap_devmanfi_tclMsgDataVisibilityRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool dap_devmanfi_tclMsgDataVisibilityRelUpReg::operator==(const dap_devmanfi_tclMsgDataVisibilityRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgDataVisibilityRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgDataVisibilityRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDataVisibilityStatus::dap_devmanfi_tclMsgDataVisibilityStatus(const dap_devmanfi_tclMsgDataVisibilityStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   bVisible = coRef.bVisible;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
dap_devmanfi_tclMsgDataVisibilityStatus& dap_devmanfi_tclMsgDataVisibilityStatus::operator=(const dap_devmanfi_tclMsgDataVisibilityStatus& coRef)
{
   if (this == &coRef) return *this;
   bVisible = coRef.bVisible;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 dap_devmanfi_tclMsgDataVisibilityStatus::u16GetServiceID() const {return DAP_DEVMANFI_C_U16_SERVICE_ID;}
tU16 dap_devmanfi_tclMsgDataVisibilityStatus::u16GetFunctionID() const {return DAP_DEVMANFI_C_U16_DATAVISIBILITY;}
tU8 dap_devmanfi_tclMsgDataVisibilityStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 dap_devmanfi_tclMsgDataVisibilityStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool dap_devmanfi_tclMsgDataVisibilityStatus::operator==(const dap_devmanfi_tclMsgDataVisibilityStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (bVisible == rfoCmp.bVisible);
   return bResult;
}

fi_tclInContext& dap_devmanfi_tclMsgDataVisibilityStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> bVisible;
   return oIn;
}

fi_tclOutContext& dap_devmanfi_tclMsgDataVisibilityStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << bVisible;
   return oOut;
}

