#include "precompiled.hh"

tBool dap_devmanfi_tclDescription::bInitMessage(dap_devmanfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case dap_devmanfi_tclToken::EN_LAST_TOKEN:
   case dap_devmanfi_tclToken::EN_LIST:
   case dap_devmanfi_tclToken::EN_END_OF_STRUCT:
   case dap_devmanfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case dap_devmanfi_tclToken::EN_MSG_READDATABLOCKSMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_DAPCOMPLEXPHYSICALBLOCKADDRESS,dap_devmanfi_tclSemanticDomain::EN_MSG_ODATABLOCK));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_BOOL,dap_devmanfi_tclSemanticDomain::EN_MSG_BCLOSEFILESAFTERPROCESSING));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_READDATABLOCKSMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_DAPCOMPLEXPHYSICALBLOCKADDRESS,dap_devmanfi_tclSemanticDomain::EN_MSG_ODATABLOCK));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_GETFILESIZEMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_DAPPHYSICALADDRESS,dap_devmanfi_tclSemanticDomain::EN_MSG_OPHYSICALADDRESS));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_BOOL,dap_devmanfi_tclSemanticDomain::EN_MSG_BCLOSEFILEAFTERPROCESSING));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_GETFILESIZEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U32,dap_devmanfi_tclSemanticDomain::EN_MSG_U32FILESIZE));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_GETDIRECTORYMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_MEMBLOCKDESC,dap_devmanfi_tclSemanticDomain::EN_MSG_ODIRECTORYLIST));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U32,dap_devmanfi_tclSemanticDomain::EN_MSG_U32LISTOFFSET));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_DAPPHYSICALADDRESS,dap_devmanfi_tclSemanticDomain::EN_MSG_ODIRECTORYDESCRIPTION));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_GETDIRECTORYMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U32,dap_devmanfi_tclSemanticDomain::EN_MSG_U32LISTCOUNTER));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_BOOL,dap_devmanfi_tclSemanticDomain::EN_MSG_BCOMPLETE));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_MEMBLOCKDESC,dap_devmanfi_tclSemanticDomain::EN_MSG_ODIRECTORYLIST));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_GETDISCSPACEMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_STRING,dap_devmanfi_tclSemanticDomain::EN_MSG_SZDEVICE));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_GETDISCSPACEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U32,dap_devmanfi_tclSemanticDomain::EN_MSG_U32HIGHDISCSPACE));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U32,dap_devmanfi_tclSemanticDomain::EN_MSG_U32LOWDISCSPACE));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_GETFREEDISKSPACEMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_STRING,dap_devmanfi_tclSemanticDomain::EN_MSG_SZDEVICE));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_GETFREEDISKSPACEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U32,dap_devmanfi_tclSemanticDomain::EN_MSG_U32HIGHDISCSPACE));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U32,dap_devmanfi_tclSemanticDomain::EN_MSG_U32LOWDISCSPACE));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_CREATEDIRECTORYMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_STRING,dap_devmanfi_tclSemanticDomain::EN_MSG_SZDIRECTORYNAME));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_STRING,dap_devmanfi_tclSemanticDomain::EN_MSG_SZTARGETACCESSPATH));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_COPYFILESMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_FILECOPY,dap_devmanfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_LIST,dap_devmanfi_tclSemanticDomain::EN_MSG_AOCOPYFILES));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_STRING,dap_devmanfi_tclSemanticDomain::EN_MSG_SZTARGETDEVICE));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_STRING,dap_devmanfi_tclSemanticDomain::EN_MSG_SZSOURCEDEVICE));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U32,dap_devmanfi_tclSemanticDomain::EN_MSG_U32SOURCEMEDIUMID));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_COPYFILESMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U16,dap_devmanfi_tclSemanticDomain::EN_MSG_U16ERRORCODE));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U16,dap_devmanfi_tclSemanticDomain::EN_MSG_U16ORDERINDEX));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_WRITETOFILEMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_BOOL,dap_devmanfi_tclSemanticDomain::EN_MSG_BCLOSEAFTERPROCESSING));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_MEMBLOCKDESC,dap_devmanfi_tclSemanticDomain::EN_MSG_ODATABUFFERDESCRIPTOR));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U32,dap_devmanfi_tclSemanticDomain::EN_MSG_U32FILEOFFSET));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_PATHFILENAME,dap_devmanfi_tclSemanticDomain::EN_MSG_OTARGET));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_RENAMEMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_STRING,dap_devmanfi_tclSemanticDomain::EN_MSG_SZNEWFILENAME));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_PATHFILENAME,dap_devmanfi_tclSemanticDomain::EN_MSG_OSOURCE));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_REMOVEFILESMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_STRING,dap_devmanfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_LIST,dap_devmanfi_tclSemanticDomain::EN_MSG_SZFILENAMELIST));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_STRING,dap_devmanfi_tclSemanticDomain::EN_MSG_SZPATH));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_REMOVEFILESMETHODRESULT:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U16,dap_devmanfi_tclSemanticDomain::EN_MSG_U16ORDERINDEX));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_REMOVEDIRECTORYMETHODSTART:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_STRING,dap_devmanfi_tclSemanticDomain::EN_MSG_SZDIRECTORYNAME));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_STRING,dap_devmanfi_tclSemanticDomain::EN_MSG_SZPATH));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_DATATYPEINFOSTATUS:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_DAPDATATYPEINFO,dap_devmanfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_LIST,dap_devmanfi_tclSemanticDomain::EN_MSG_AODATAINFOS));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_MEDIAINFOSTATUS:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_DEVMEDIAINFO,dap_devmanfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_LIST,dap_devmanfi_tclSemanticDomain::EN_MSG_AOMEDIAINFOS));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_DEVICESTATUSINFOSTATUS:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_DAPDEVICESTATUSINFO,dap_devmanfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_LIST,dap_devmanfi_tclSemanticDomain::EN_MSG_AODEVICEINFOS));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_PRMNOTIFICATIONSTATUS:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_STRING,dap_devmanfi_tclSemanticDomain::EN_MSG_SZDEVICEPATH));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_E8_DEVNOTIFICATION,dap_devmanfi_tclSemanticDomain::EN_MSG_ENNOTIFICATION));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U32,dap_devmanfi_tclSemanticDomain::EN_MSG_U32NOTIFICATIONDATA));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_DEFAULTDATAINFOSTATUS:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_DAPDATATYPEINFO,dap_devmanfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_LIST,dap_devmanfi_tclSemanticDomain::EN_MSG_AODATAINFOS));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_DEFAULTDEVICESET:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_STRING,dap_devmanfi_tclSemanticDomain::EN_MSG_SZDEVICE));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_DEFAULTDEVICESTATUS:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U16,dap_devmanfi_tclSemanticDomain::EN_MSG_ERRORSTATE));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_STRING,dap_devmanfi_tclSemanticDomain::EN_MSG_SZDEVICE));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_REGIONDESCRIPTIONSSTATUS:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_DAPREGIONDESCRLIST,dap_devmanfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_LIST,dap_devmanfi_tclSemanticDomain::EN_MSG_OREGIONDESCRLISTS));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_REGIONMETADATASTATUS:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_DAPPROFILEMETAINFO,dap_devmanfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_LIST,dap_devmanfi_tclSemanticDomain::EN_MSG_OPROFILEMETAINFOLIST));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_DAPREGIONMETAINFO,dap_devmanfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_LIST,dap_devmanfi_tclSemanticDomain::EN_MSG_OREGIONMETAINFOLIST));
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U32,dap_devmanfi_tclSemanticDomain::EN_MSG_U32DATASETID));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_DATAVISIBILITYSET:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_BOOL,dap_devmanfi_tclSemanticDomain::EN_MSG_BVISIBLE));
   } break;
   case dap_devmanfi_tclToken::EN_MSG_DATAVISIBILITYSTATUS:
   {
      bResult &= oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_BOOL,dap_devmanfi_tclSemanticDomain::EN_MSG_BVISIBLE));
   } break;
   case dap_devmanfi_tclToken::EN_BINCONTAINER:
   case dap_devmanfi_tclToken::EN_E8_DAPDATAAVAILABLE:
   case dap_devmanfi_tclToken::EN_E8_DAPDATATYPE:
   case dap_devmanfi_tclToken::EN_E8_DAPMEDIATYPE:
   case dap_devmanfi_tclToken::EN_E8_DAPDEVICEERROR:
   case dap_devmanfi_tclToken::EN_E8_DAPACCESSMODE:
   case dap_devmanfi_tclToken::EN_E8_DAPWRITEPROT:
   case dap_devmanfi_tclToken::EN_DAPVIRTUALMEDIAINFO:
   case dap_devmanfi_tclToken::EN_DAPREGIONMETAINFO:
   case dap_devmanfi_tclToken::EN_DAPPROFILEMETAINFO:
   case dap_devmanfi_tclToken::EN_E8_DEVNOTIFICATION:
   case dap_devmanfi_tclToken::EN_E8_DAPMEMTYPE:
   case dap_devmanfi_tclToken::EN_MEMBLOCKDESC:
   case dap_devmanfi_tclToken::EN_PATHFILENAME:
   case dap_devmanfi_tclToken::EN_DAPPHYSICALADDRESS:
   case dap_devmanfi_tclToken::EN_DAPPHYSICALBLOCKADDRESS:
   case dap_devmanfi_tclToken::EN_DAPCOMPLEXPHYSICALBLOCKADDRESS:
   case dap_devmanfi_tclToken::EN_DAPDEVICESTATUSINFO:
   case dap_devmanfi_tclToken::EN_DAPDATATYPEINFO:
   case dap_devmanfi_tclToken::EN_DEVMEDIAINFO:
   case dap_devmanfi_tclToken::EN_FILECOPY:
   case dap_devmanfi_tclToken::EN_DAPREGIONDESCR:
   case dap_devmanfi_tclToken::EN_DAPREGIONDESCRLIST:
   case dap_devmanfi_tclToken::EN_U8:   
   case dap_devmanfi_tclToken::EN_S8:   
   case dap_devmanfi_tclToken::EN_U16:   
   case dap_devmanfi_tclToken::EN_S16:   
   case dap_devmanfi_tclToken::EN_U24:   
   case dap_devmanfi_tclToken::EN_S24:   
   case dap_devmanfi_tclToken::EN_U32:   
   case dap_devmanfi_tclToken::EN_S32:   
   case dap_devmanfi_tclToken::EN_U64:   
   case dap_devmanfi_tclToken::EN_S64:   
   case dap_devmanfi_tclToken::EN_F32:   
   case dap_devmanfi_tclToken::EN_F64:   
   case dap_devmanfi_tclToken::EN_BOOL:   
   case dap_devmanfi_tclToken::EN_STRING:   
   case dap_devmanfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(dap_devmanfi_tclKnot(enMsgToken,dap_devmanfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool dap_devmanfi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool dap_devmanfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      dap_devmanfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      dap_devmanfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      dap_devmanfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == dap_devmanfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(dap_devmanfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(dap_devmanfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(dap_devmanfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case dap_devmanfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == dap_devmanfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case dap_devmanfi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            dap_devmanfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(dap_devmanfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            dap_devmanfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(dap_devmanfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case dap_devmanfi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case dap_devmanfi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_devmanfi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_devmanfi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_devmanfi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_devmanfi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_devmanfi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_devmanfi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_devmanfi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_devmanfi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_devmanfi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_devmanfi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_devmanfi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_devmanfi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case dap_devmanfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case dap_devmanfi_tclToken::EN_MSG_READDATABLOCKSMETHODSTART:
   case dap_devmanfi_tclToken::EN_MSG_READDATABLOCKSMETHODRESULT:
   case dap_devmanfi_tclToken::EN_MSG_GETFILESIZEMETHODSTART:
   case dap_devmanfi_tclToken::EN_MSG_GETFILESIZEMETHODRESULT:
   case dap_devmanfi_tclToken::EN_MSG_GETDIRECTORYMETHODSTART:
   case dap_devmanfi_tclToken::EN_MSG_GETDIRECTORYMETHODRESULT:
   case dap_devmanfi_tclToken::EN_MSG_GETDISCSPACEMETHODSTART:
   case dap_devmanfi_tclToken::EN_MSG_GETDISCSPACEMETHODRESULT:
   case dap_devmanfi_tclToken::EN_MSG_GETFREEDISKSPACEMETHODSTART:
   case dap_devmanfi_tclToken::EN_MSG_GETFREEDISKSPACEMETHODRESULT:
   case dap_devmanfi_tclToken::EN_MSG_CREATEDIRECTORYMETHODSTART:
   case dap_devmanfi_tclToken::EN_MSG_CREATEDIRECTORYMETHODRESULT:
   case dap_devmanfi_tclToken::EN_MSG_COPYFILESMETHODSTART:
   case dap_devmanfi_tclToken::EN_MSG_COPYFILESMETHODRESULT:
   case dap_devmanfi_tclToken::EN_MSG_WRITETOFILEMETHODSTART:
   case dap_devmanfi_tclToken::EN_MSG_WRITETOFILEMETHODRESULT:
   case dap_devmanfi_tclToken::EN_MSG_RENAMEMETHODSTART:
   case dap_devmanfi_tclToken::EN_MSG_RENAMEMETHODRESULT:
   case dap_devmanfi_tclToken::EN_MSG_REMOVEFILESMETHODSTART:
   case dap_devmanfi_tclToken::EN_MSG_REMOVEFILESMETHODRESULT:
   case dap_devmanfi_tclToken::EN_MSG_REMOVEDIRECTORYMETHODSTART:
   case dap_devmanfi_tclToken::EN_MSG_REMOVEDIRECTORYMETHODRESULT:
   case dap_devmanfi_tclToken::EN_MSG_TIMERPROCESSEDMETHODSTART:
   case dap_devmanfi_tclToken::EN_MSG_TIMERPROCESSEDMETHODRESULT:
   case dap_devmanfi_tclToken::EN_MSG_DATATYPEINFOUPREG:
   case dap_devmanfi_tclToken::EN_MSG_DATATYPEINFORELUPREG:
   case dap_devmanfi_tclToken::EN_MSG_DATATYPEINFOSTATUS:
   case dap_devmanfi_tclToken::EN_MSG_MEDIAINFOUPREG:
   case dap_devmanfi_tclToken::EN_MSG_MEDIAINFORELUPREG:
   case dap_devmanfi_tclToken::EN_MSG_MEDIAINFOSTATUS:
   case dap_devmanfi_tclToken::EN_MSG_DEVICESTATUSINFOUPREG:
   case dap_devmanfi_tclToken::EN_MSG_DEVICESTATUSINFORELUPREG:
   case dap_devmanfi_tclToken::EN_MSG_DEVICESTATUSINFOSTATUS:
   case dap_devmanfi_tclToken::EN_MSG_PRMNOTIFICATIONSTATUS:
   case dap_devmanfi_tclToken::EN_MSG_DEFAULTDATAINFOUPREG:
   case dap_devmanfi_tclToken::EN_MSG_DEFAULTDATAINFORELUPREG:
   case dap_devmanfi_tclToken::EN_MSG_DEFAULTDATAINFOSTATUS:
   case dap_devmanfi_tclToken::EN_MSG_DEFAULTDEVICESET:
   case dap_devmanfi_tclToken::EN_MSG_DEFAULTDEVICESTATUS:
   case dap_devmanfi_tclToken::EN_MSG_REGIONDESCRIPTIONSUPREG:
   case dap_devmanfi_tclToken::EN_MSG_REGIONDESCRIPTIONSRELUPREG:
   case dap_devmanfi_tclToken::EN_MSG_REGIONDESCRIPTIONSSTATUS:
   case dap_devmanfi_tclToken::EN_MSG_REGIONMETADATAUPREG:
   case dap_devmanfi_tclToken::EN_MSG_REGIONMETADATARELUPREG:
   case dap_devmanfi_tclToken::EN_MSG_REGIONMETADATASTATUS:
   case dap_devmanfi_tclToken::EN_MSG_DATAVISIBILITYSET:
   case dap_devmanfi_tclToken::EN_MSG_DATAVISIBILITYUPREG:
   case dap_devmanfi_tclToken::EN_MSG_DATAVISIBILITYRELUPREG:
   case dap_devmanfi_tclToken::EN_MSG_DATAVISIBILITYSTATUS:
      bInitMessage(enToken);
      break;
   case dap_devmanfi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_END_OF_STRUCT,dap_devmanfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U8,dap_devmanfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_LIST,dap_devmanfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_devmanfi_tclToken::EN_E8_DAPDATAAVAILABLE:
   {
      fi_tcl_e8_DapDataAvailable o_e8_DapDataAvailable;
      if (!bDoIt(o_e8_DapDataAvailable))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_devmanfi_tclToken::EN_E8_DAPDATATYPE:
   {
      fi_tcl_e8_DapDataType o_e8_DapDataType;
      if (!bDoIt(o_e8_DapDataType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_devmanfi_tclToken::EN_E8_DAPMEDIATYPE:
   {
      fi_tcl_e8_DapMediaType o_e8_DapMediaType;
      if (!bDoIt(o_e8_DapMediaType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_devmanfi_tclToken::EN_E8_DAPDEVICEERROR:
   {
      fi_tcl_e8_DapDeviceError o_e8_DapDeviceError;
      if (!bDoIt(o_e8_DapDeviceError))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_devmanfi_tclToken::EN_E8_DAPACCESSMODE:
   {
      fi_tcl_e8_DapAccessMode o_e8_DapAccessMode;
      if (!bDoIt(o_e8_DapAccessMode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_devmanfi_tclToken::EN_E8_DAPWRITEPROT:
   {
      fi_tcl_e8_DapWriteProt o_e8_DapWriteProt;
      if (!bDoIt(o_e8_DapWriteProt))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_devmanfi_tclToken::EN_DAPVIRTUALMEDIAINFO:
   {
      if (poVisitor->bDoExpand_DapVirtualMediaInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_END_OF_STRUCT,dap_devmanfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_STRING,dap_devmanfi_tclSemanticDomain::EN_SZMEDIADESCRIPTION));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_E8_DAPDATAAVAILABLE,dap_devmanfi_tclSemanticDomain::EN_ENDATAAVAILABLE));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U32,dap_devmanfi_tclSemanticDomain::EN_U32MEDIAID));
      }
      else
      {
         fi_tcl_DapVirtualMediaInfo o_DapVirtualMediaInfo;
         if (!bDoIt(o_DapVirtualMediaInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapVirtualMediaInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapVirtualMediaInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_devmanfi_tclToken::EN_DAPREGIONMETAINFO:
   {
      if (poVisitor->bDoExpand_DapRegionMetaInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_END_OF_STRUCT,dap_devmanfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_STRING,dap_devmanfi_tclSemanticDomain::EN_SZREGIONCODE));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U16,dap_devmanfi_tclSemanticDomain::EN_U16REGIONID));
      }
      else
      {
         fi_tcl_DapRegionMetaInfo o_DapRegionMetaInfo;
         if (!bDoIt(o_DapRegionMetaInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapRegionMetaInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapRegionMetaInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_devmanfi_tclToken::EN_DAPPROFILEMETAINFO:
   {
      if (poVisitor->bDoExpand_DapProfileMetaInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_END_OF_STRUCT,dap_devmanfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_STRING,dap_devmanfi_tclSemanticDomain::EN_SZPROFILE));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U8,dap_devmanfi_tclSemanticDomain::EN_U8PROFILEID));
      }
      else
      {
         fi_tcl_DapProfileMetaInfo o_DapProfileMetaInfo;
         if (!bDoIt(o_DapProfileMetaInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapProfileMetaInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapProfileMetaInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_devmanfi_tclToken::EN_E8_DEVNOTIFICATION:
   {
      fi_tcl_e8_DevNotification o_e8_DevNotification;
      if (!bDoIt(o_e8_DevNotification))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_devmanfi_tclToken::EN_E8_DAPMEMTYPE:
   {
      fi_tcl_e8_DapMemType o_e8_DapMemType;
      if (!bDoIt(o_e8_DapMemType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case dap_devmanfi_tclToken::EN_MEMBLOCKDESC:
   {
      if (poVisitor->bDoExpand_MemBlockDesc(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_END_OF_STRUCT,dap_devmanfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_STRING,dap_devmanfi_tclSemanticDomain::EN_SZSHAREDMEMNAME));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_E8_DAPMEMTYPE,dap_devmanfi_tclSemanticDomain::EN_ENMEMTYPE));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_BOOL,dap_devmanfi_tclSemanticDomain::EN_BISCOPY));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_S32,dap_devmanfi_tclSemanticDomain::EN_HSHAREDMEMHANDLE));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U32,dap_devmanfi_tclSemanticDomain::EN_PVMEMACCESS));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U32,dap_devmanfi_tclSemanticDomain::EN_U32SIZE));
      }
      else
      {
         fi_tcl_MemBlockDesc o_MemBlockDesc;
         if (!bDoIt(o_MemBlockDesc))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MemBlockDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_MemBlockDesc.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_devmanfi_tclToken::EN_PATHFILENAME:
   {
      if (poVisitor->bDoExpand_PathFilename(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_END_OF_STRUCT,dap_devmanfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_STRING,dap_devmanfi_tclSemanticDomain::EN_SZPATH));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_STRING,dap_devmanfi_tclSemanticDomain::EN_SZFILE));
      }
      else
      {
         fi_tcl_PathFilename o_PathFilename;
         if (!bDoIt(o_PathFilename))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PathFilename.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PathFilename.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_devmanfi_tclToken::EN_DAPPHYSICALADDRESS:
   {
      if (poVisitor->bDoExpand_DapPhysicalAddress(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_END_OF_STRUCT,dap_devmanfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_PATHFILENAME,dap_devmanfi_tclSemanticDomain::EN_OPATHFILENAME));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U32,dap_devmanfi_tclSemanticDomain::EN_U32MEDIAID));
      }
      else
      {
         fi_tcl_DapPhysicalAddress o_DapPhysicalAddress;
         if (!bDoIt(o_DapPhysicalAddress))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapPhysicalAddress.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapPhysicalAddress.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_devmanfi_tclToken::EN_DAPPHYSICALBLOCKADDRESS:
   {
      if (poVisitor->bDoExpand_DapPhysicalBlockAddress(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_END_OF_STRUCT,dap_devmanfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U32,dap_devmanfi_tclSemanticDomain::EN_U32BLOCKSIZE));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U32,dap_devmanfi_tclSemanticDomain::EN_U32FILEOFFSET));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_DAPPHYSICALADDRESS,dap_devmanfi_tclSemanticDomain::EN_OPHYSADR));
      }
      else
      {
         fi_tcl_DapPhysicalBlockAddress o_DapPhysicalBlockAddress;
         if (!bDoIt(o_DapPhysicalBlockAddress))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapPhysicalBlockAddress.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapPhysicalBlockAddress.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_devmanfi_tclToken::EN_DAPCOMPLEXPHYSICALBLOCKADDRESS:
   {
      if (poVisitor->bDoExpand_DapComplexPhysicalBlockAddress(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_END_OF_STRUCT,dap_devmanfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_MEMBLOCKDESC,dap_devmanfi_tclSemanticDomain::EN_OMEMADR));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_DAPPHYSICALBLOCKADDRESS,dap_devmanfi_tclSemanticDomain::EN_OPHYSBLOCKADR));
      }
      else
      {
         fi_tcl_DapComplexPhysicalBlockAddress o_DapComplexPhysicalBlockAddress;
         if (!bDoIt(o_DapComplexPhysicalBlockAddress))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapComplexPhysicalBlockAddress.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapComplexPhysicalBlockAddress.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_devmanfi_tclToken::EN_DAPDEVICESTATUSINFO:
   {
      if (poVisitor->bDoExpand_DapDeviceStatusInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_END_OF_STRUCT,dap_devmanfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_E8_DAPDEVICEERROR,dap_devmanfi_tclSemanticDomain::EN_ENDEVICEERROR));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_STRING,dap_devmanfi_tclSemanticDomain::EN_SZDEVICEPATH));
      }
      else
      {
         fi_tcl_DapDeviceStatusInfo o_DapDeviceStatusInfo;
         if (!bDoIt(o_DapDeviceStatusInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapDeviceStatusInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapDeviceStatusInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_devmanfi_tclToken::EN_DAPDATATYPEINFO:
   {
      if (poVisitor->bDoExpand_DapDataTypeInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_END_OF_STRUCT,dap_devmanfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U32,dap_devmanfi_tclSemanticDomain::EN_U32DATABASEID));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U32,dap_devmanfi_tclSemanticDomain::EN_U32DATASETID));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U32,dap_devmanfi_tclSemanticDomain::EN_U32MEDIUMID));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_E8_DAPDATAAVAILABLE,dap_devmanfi_tclSemanticDomain::EN_ENDATAAVAILABLILITY));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_E8_DAPDATATYPE,dap_devmanfi_tclSemanticDomain::EN_ENDATATYPE));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_STRING,dap_devmanfi_tclSemanticDomain::EN_SZACCESSPATH));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_STRING,dap_devmanfi_tclSemanticDomain::EN_SZDEVICE));
      }
      else
      {
         fi_tcl_DapDataTypeInfo o_DapDataTypeInfo;
         if (!bDoIt(o_DapDataTypeInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapDataTypeInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapDataTypeInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_devmanfi_tclToken::EN_DEVMEDIAINFO:
   {
      if (poVisitor->bDoExpand_DevMediaInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_END_OF_STRUCT,dap_devmanfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_DAPVIRTUALMEDIAINFO,dap_devmanfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_LIST,dap_devmanfi_tclSemanticDomain::EN_OVIRTUALMEDIAINFOLIST));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_E8_DAPWRITEPROT,dap_devmanfi_tclSemanticDomain::EN_ENWRITEPROTSTATE));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_BOOL,dap_devmanfi_tclSemanticDomain::EN_BDEFAULTDEVICE));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_E8_DAPMEDIATYPE,dap_devmanfi_tclSemanticDomain::EN_ENMEDIATYPE));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_E8_DAPACCESSMODE,dap_devmanfi_tclSemanticDomain::EN_ENACCESSMODE));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_BOOL,dap_devmanfi_tclSemanticDomain::EN_BMEDIAACCESSABLE));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_BOOL,dap_devmanfi_tclSemanticDomain::EN_BMEDIAAVAILABLE));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_STRING,dap_devmanfi_tclSemanticDomain::EN_SZDEVICEPATH));
      }
      else
      {
         fi_tcl_DevMediaInfo o_DevMediaInfo;
         if (!bDoIt(o_DevMediaInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DevMediaInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DevMediaInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_devmanfi_tclToken::EN_FILECOPY:
   {
      if (poVisitor->bDoExpand_FileCopy(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_END_OF_STRUCT,dap_devmanfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_BOOL,dap_devmanfi_tclSemanticDomain::EN_BCLOSEFILEAFTERPROCESSING));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_PATHFILENAME,dap_devmanfi_tclSemanticDomain::EN_OSOURCE));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_PATHFILENAME,dap_devmanfi_tclSemanticDomain::EN_OTARGET));
      }
      else
      {
         fi_tcl_FileCopy o_FileCopy;
         if (!bDoIt(o_FileCopy))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FileCopy.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FileCopy.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_devmanfi_tclToken::EN_DAPREGIONDESCR:
   {
      if (poVisitor->bDoExpand_DapRegionDescr(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_END_OF_STRUCT,dap_devmanfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_STRING,dap_devmanfi_tclSemanticDomain::EN_SZDEVICE));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U8,dap_devmanfi_tclSemanticDomain::EN_U8PROFILEID));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U16,dap_devmanfi_tclSemanticDomain::EN_U16REGIONID));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U32,dap_devmanfi_tclSemanticDomain::EN_U32CREATEDATE));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U32,dap_devmanfi_tclSemanticDomain::EN_U32MEDIUMID));
      }
      else
      {
         fi_tcl_DapRegionDescr o_DapRegionDescr;
         if (!bDoIt(o_DapRegionDescr))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapRegionDescr.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapRegionDescr.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case dap_devmanfi_tclToken::EN_DAPREGIONDESCRLIST:
   {
      if (poVisitor->bDoExpand_DapRegionDescrList(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_END_OF_STRUCT,dap_devmanfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_DAPREGIONDESCR,dap_devmanfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_LIST,dap_devmanfi_tclSemanticDomain::EN_OREGIONDESCLIST));
         oPath.bGoDown(dap_devmanfi_tclKnot(dap_devmanfi_tclToken::EN_U32,dap_devmanfi_tclSemanticDomain::EN_U32DATASETID));
      }
      else
      {
         fi_tcl_DapRegionDescrList o_DapRegionDescrList;
         if (!bDoIt(o_DapRegionDescrList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapRegionDescrList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DapRegionDescrList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case dap_devmanfi_tclToken::EN_UNKNOWN:
      case dap_devmanfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

