
#include "bpcl.h"
#include "bpcl_int.h"


tErrCode BPCL_Create_Symmetric_Key(
	const tU8 *p_seed,
	tU32 seed_len,
	tU8 *p_key_buffer,
	tU32 key_len
) {

	int i;
	tU8		int_seed[36];

	if(p_seed == (tU8 *)0) {
#ifdef _BPCL_TEST
		// Create reproducable keys
		for(i = 0; i < 36; ++i) {
			int_seed[i] = (i << 3) ^ 0x5C;
		}
#else
		for(i = 0; i < 36; ++i) {
			int_seed[i] = (tU8)rnd_word(0xFF) ^ 0xB3;
		}
#endif
		if(rnd_byte_array(int_seed, p_key_buffer, key_len) != 0) {
			return BPCL_ERR_RANDOM_GENERATION;
		}
	} else {
		if(seed_len < 36) {
			return BPCL_ERR_BAD_PARAMETER;
		}

		if(rnd_byte_array(p_seed, p_key_buffer, key_len) != 0) {
			return BPCL_ERR_RANDOM_GENERATION;
		}
	}

	M_MASK_KEY(p_key_buffer, key_len)
	return BPCL_OK;
} // BPCL_Create_Symmetric_Key()

