
// tU32 arrays
static tU32 curve32_words_secp160r1_prime_p[5]            = { 0x7fffffffUL, 0xffffffffUL, 0xffffffffUL, 0xffffffffUL, 0xffffffffUL };
static tU32 curve32_words_secp160r1_coefficient_a[5]      = { 0x7ffffffcUL, 0xffffffffUL, 0xffffffffUL, 0xffffffffUL, 0xffffffffUL };
static tU32 curve32_words_secp160r1_coefficient_b[5]      = { 0xc565fa45UL, 0x81d4d4adUL, 0x65acf89fUL, 0x54bd7a8bUL, 0x1c97befcUL };
static tU32 curve32_words_secp160r1_base_point_G_x[5]     = { 0x13cbfc82UL, 0x68c38bb9UL, 0x46646989UL, 0x8ef57328UL, 0x4a96b568UL };
static tU32 curve32_words_secp160r1_base_point_G_y[5]     = { 0x7ac5fb32UL, 0x04235137UL, 0x59dcc912UL, 0x3168947dUL, 0x23a62855UL };
static tU32 curve32_words_secp160r1_base_point_G_z[5]     = { 0x00000001UL, 0x00000000UL, 0x00000000UL, 0x00000000UL, 0x00000000UL };
static tU32 curve32_words_secp160r1_base_point_order_n[6] = { 0xca752257UL, 0xf927aed3UL, 0x0001f4c8UL, 0x00000000UL, 0x00000000UL, 0x00000001UL };

static tU32 curve32_words_secp160r1_my_p[6]               = { 0x80000001UL, 0x00000000UL, 0x00000000UL, 0x00000000UL, 0x00000000UL, 0x00000001UL };
static tU32 curve32_words_secp160r1_my_n[7]               = { 0x436AB204UL, 0xD3A1AB09UL, 0x358ADDACUL, 0x06D8512CUL, 0xFFFE0B37UL, 0xFFFFFFFFUL, 0xFFFFFFFFUL };

// secp160r1 precomputed base points: G[i] = 2^(5  i)  G, 0 <= i <= 45
static tU32 curve32_words_secp160r1_precomputed_G_w5[45][2][5] = 
{
{ {0x13cbfc82, 0x68c38bb9, 0x46646989, 0x8ef57328, 0x4a96b568}, /* 0 */
  {0x7ac5fb32, 0x4235137,  0x59dcc912, 0x3168947d, 0x23a62855} },
{ {0x3245ac53, 0xbdd4d216, 0xb5e4dde8, 0x31683e83, 0xc06c1283}, /* 1 */
  {0x258dd648, 0xafdb1bb7, 0x250b909c, 0x401e9d31, 0x6269ccd3} },
{ {0xa0864a48, 0x32ca6183, 0x6258bd23, 0x10a1a642, 0xc6a9cc54}, /* 2 */
  {0xb89c50b1, 0x9ab89c5f, 0xe9f174c0, 0xdc7f14f6, 0xbf0bcc9f} },
{ {0x9edec73a, 0x1ec13fed, 0x46efbc18, 0xce642cfc, 0xd7b6522c}, /* 3 */
  {0xa2b1e4ce, 0x82d833ea, 0x7fc0d66,  0xec8dea0b, 0xf1113702} },
{ {0xa530cce9, 0x953d81e6, 0xdebd8771, 0x4d04134f, 0xb8268a65}, /* 4 */
  {0x520264b4, 0xd37d75a6, 0xfb1861be, 0x3cf3fb13, 0x6f664e0c} },
{ {0xf7641d21, 0x614d476b, 0xdbe5aad,  0x465de5a,  0xaff77242}, /* 5 */
  {0xf425cc07, 0x8773fb09, 0x9d16894c, 0x176e12ce, 0xb5520952} },
{ {0x121add56, 0xf9ee18d6, 0xdb46738e, 0x451de990, 0x2ded5ba3}, /* 6 */
  {0xf3e7c54d, 0x70a6f79b, 0x6abb69f9, 0x73b4ae70, 0x30936dcf} },
{ {0x6b84fde0, 0xa7fd0c23, 0x9552cf81, 0x59861c61, 0x7c188638}, /* 7 */
  {0x91a11f0,  0x5e42f041, 0x2422518c, 0x8e9215c2, 0x6276335f} },
{ {0x49f0167,  0xe0594b15, 0x306557a0, 0xb0db743e, 0x8cf07374}, /* 8 */
  {0x8e0d9e9f, 0x1972401c, 0xb7b1d22a, 0x24d940cd, 0xa90e1d4f} },
{ {0xc9c9dc63, 0x623f7c82, 0x6d11e4ea, 0xb0f96001, 0x7eed1767}, /* 9 */
  {0x8cf76920, 0xd6c6e04d, 0x4d2dede9, 0x3ec27cd0, 0x51a3094f} },
{ {0xbe367f06, 0xb1ff043a, 0x627e8782, 0x3eeec801, 0x2822532}, /* 10 */
  {0x305ab8c3, 0x4d55de7b, 0xdfba297,  0x924f935a, 0xe31eedf7} },
{ {0x27e0178d, 0xa3bc26c1, 0xb2013675, 0x306a888b, 0xed2098e2}, /* 11 */
  {0xb7141a06, 0x84e6f94e, 0x421edea7, 0x5d8b0dc1, 0x509728ce} },
{ {0x372012f6, 0x3ded2e09, 0xbaa44bf3, 0xf83342c6, 0xfb8c9c4},  /* 12 */
  {0xc6bebd78, 0xf182058f, 0x822cbba0, 0xd9adc903, 0xef26a187} },
{ {0xa1a1899,  0xdaa9d6e4, 0x737b8c7b, 0xb754432,  0xb0852680}, /* 13 */
  {0x6381d78c, 0x48b32be3, 0xae21d7c4, 0x59cc6de7, 0x9397e508} },
{ {0xea268849, 0xa54d72f4, 0x6e1251f4, 0x4375e04f, 0xebde355},  /* 14 */
  {0x927dfedf, 0x771f5fb0, 0xf7026be9, 0x59a526e9, 0xdbb7afb5} },
{ {0x90b8ac0a, 0xcd03ccea, 0x46f387e2, 0x570fa1ec, 0xd53a813d}, /* 15 */
  {0xdc30f388, 0x5acebb0c, 0xc1846557, 0x6d1d9c72, 0xc20123f5} },
{ {0x89665347, 0xb21844a4, 0xa2961a17, 0xbe4ad4c7, 0xf2e0a32f}, /* 16 */
  {0x31b980ca, 0x6519e3de, 0x92dea640, 0xcaa2f378, 0x46b7032f} },
{ {0x3c05eed3, 0xa313d369, 0xc23bfea6, 0x61474faa, 0xc01fd0c1}, /* 17 */
  {0x349b9b44, 0x575412c9, 0x643134c4, 0x591550cf, 0xcdeab307} },
{ {0xc5d3124,  0x39ff6c54, 0xfbd8e60c, 0x501c98a6, 0xa48a1beb}, /* 18 */
  {0x2da9123,  0x9fc2f455, 0xb79da2d3, 0xa886d090, 0xf8f64d80} },
{ {0xf9b70745, 0x94ab982b, 0xcde16f4e, 0xf151c47e, 0xd5cafc78}, /* 19 */
  {0xf06d9e41, 0xbff76e82, 0x3d471d13, 0x8b0be579, 0x7f71a362} },
{ {0x5534eb67, 0xb0642eb6, 0x5604607e, 0xfef61587, 0xbc6ec2d},  /* 20 */
  {0x3140c4c9, 0x6382a22f, 0xb847573b, 0x9f3f2d6e, 0xd0af24d4} },
{ {0x29d7e42b, 0x9fd6ec0f, 0x699ccb63, 0x4cf2120a, 0x18d79b92}, /* 21 */
  {0x48b9a760, 0xbc04dd2,  0x4eefc01a, 0x46795417, 0xc991ce6c} },
{ {0x105b1fa5, 0x1d4a7f4,  0x7c0c45fe, 0x6fe3be5b, 0x41d2387},  /* 22 */
  {0xa0971a33, 0x433aed6b, 0x2825543b, 0xc8403885, 0x6a913769} },
{ {0xcc8242c5, 0x531232c3, 0xfbeb138,  0xd7321603, 0x5f427357}, /* 23 */
  {0xe08cd28f, 0xff8688ce, 0x507e1b0c, 0x82dd64d0, 0x554ab25d} },
{ {0xd408b269, 0x8ec7f46b, 0x644eaf62, 0xb77ae59d, 0xa22fb604}, /* 24 */
  {0x6d4d9e84, 0xafea8882, 0x3442194a, 0x44317378, 0x842f7872} },
{ {0x4d8d2e5e, 0x1a7f9031, 0x117f5013, 0x48cd368,  0xa9238466}, /* 25 */
  {0x8b4d779c, 0x56c1f706, 0x949aaceb, 0x5085703,  0x31ae55bf} },
{ {0x6e7adfb3, 0xf9d6d91e, 0x29e6656d, 0x579f5d56, 0xe970bafe}, /* 26 */
  {0x417e42e8, 0x5f4a9796, 0x6477866e, 0xd2edf330, 0x19bebedc} },
{ {0xd2444679, 0xa39df154, 0xf63ee8fc, 0xb8c532db, 0xa11e4ac6}, /* 27 */
  {0xdd3bc74b, 0x8ac365dd, 0xd1dbb57b, 0xec6f37cc, 0xfff8cb70} },
{ {0xffaf53a0, 0x413c980c, 0x8660f43b, 0x66163ba5, 0x5ceb5c43}, /* 28 */
  {0x2327ff4c, 0x61319887, 0x653ef8aa, 0x91fb3743, 0x17ed74ac} },
{ {0x4c36a71e, 0x7d657ee3, 0xbc069318, 0xadeaa0f,  0xa26ced11}, /* 29 */
  {0xbc95dd11, 0xbc11fe8e, 0x49200a96, 0xd5a2eb8e, 0xfa221dba} },
{ {0x3ad1660d, 0x9ab836c5, 0xa7e58476, 0x1f8c85db, 0x61e81df9}, /* 30 */
  {0x7c982d6c, 0xd7927032, 0x448e9e02, 0x2e1798c0, 0xc62800a3} },
{ {0xf0803920, 0x7d5f9393, 0xb7797632, 0xd36a9cb2, 0x99ac7859}, /* 31 */
  {0x30f80362, 0x5dd304ce, 0x5fdb7dd,  0x682acfdf, 0x9699f6e5} },
{ {0x5ca3c07a, 0xba0ac1f6, 0xab92b2e6, 0xf69be2de, 0x41e8f08c}, /* 32 */
  {0xe7b326c9, 0x57c2afd2, 0x994220f1, 0xcb3ff4be, 0x276e2f88} },
{ {0xf4c04d5f, 0x4c63be11, 0x91889c9b, 0x71beda51, 0x25a88fb9}, /* 33 */
  {0xfaa10f85, 0x14b3c248, 0x3e8d0a3e, 0x1ee73b1c, 0xed184f54} },
{ {0xc3dacbc5, 0x8a07cf2c, 0xda0d1995, 0x86a699aa, 0x35ed048e}, /* 34 */
  {0x50291773, 0x9b2a7504, 0x7e8471b7, 0x90c3ee5c, 0x11a8e28} },
{ {0x7ba58c0c, 0x3893e138, 0x9e589b37, 0x6ec3dbb0, 0x5b189db8}, /* 35 */
  {0xc18e3864, 0xcf272e41, 0x2519d638, 0xdae7d3bd, 0x2d13b454} },
{ {0xd4b00b63, 0xc5647a17, 0xced09f66, 0x8955b453, 0xa8f0afe3}, /* 36 */
  {0x9314fdb5, 0x6107f748, 0xb6515e8c, 0x469f25cc, 0x7aafb41e} },
{ {0xbcce0080, 0xb4b486aa, 0x89cd36ed, 0xf9a79b27, 0x35ea94b6}, /* 37 */
  {0x3191a478, 0xeaa06b10, 0x20dddd41, 0xd85f9a1f, 0xdc1d8fe2} },
{ {0x701903be, 0x80654ed6, 0x36ec0f37, 0xe4697672, 0xe577ebc0}, /* 38 */
  {0xbdc699c5, 0x8d6071eb, 0x46d57d1e, 0x6936b9a9, 0xb697c41f} },
{ {0xcc7fb364, 0xadbaf4d3, 0xa3f4fe4a, 0x8ba7243c, 0xc861e932}, /* 39 */
  {0xd9df08b4, 0xf395d97e, 0xa40419e1, 0x5af12bd9, 0xac64b019} },
{ {0x3a5ca674, 0xd22e4758, 0x6d69ad6d, 0x203069b0, 0xbb22c203}, /* 40 */
  {0xea177833, 0x101c2197, 0x22e17a0c, 0xa2c26ec7, 0x34e67e89} },
{ {0xa1917944, 0xd7bc4d19, 0x430e642c, 0x24efcd97, 0x2f871770}, /* 41 */
  {0x4c94215b, 0x5b1c780c, 0x4a67a700, 0x97aea47e, 0x5288d662} },
{ {0x86889a31, 0xaa64ea8b, 0x9fb60f9e, 0xa3ee2671, 0x4769a6c2}, /* 42 */
  {0x659cf6c2, 0xd1a754c0, 0x1c34572e, 0x78cdea4d, 0x4e19e3cb} },
{ {0x97dca818, 0x98ed373c, 0x2d1a580e, 0xc0ee323e, 0x2f5739f4}, /* 43 */
  {0x78c8e481, 0xc8bb6cde, 0xfd65fe6d, 0x675b247d, 0x693065f7} },
{ {0xe1cfd9b7, 0x1f18208f, 0x49405c52, 0x42fe6187, 0xf454c996}, /* 44 */
  {0x52956918, 0x38be9218, 0x17d05ab4, 0xa0b4cd05, 0xe19a9948} },
};

static tsECPoint curve32_point_secp160r1_precomputed_G_w5[45] = 
{
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[0][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[0][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,      5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[1][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[1][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,      5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[2][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[2][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,      5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[3][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[3][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,      5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[4][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[4][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,      5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[5][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[5][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,      5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[6][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[6][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,      5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[7][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[7][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,      5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[8][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[8][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,      5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[9][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[9][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,      5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[10][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[10][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[11][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[11][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[12][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[12][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[13][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[13][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[14][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[14][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[15][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[15][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[16][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[16][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[17][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[17][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[18][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[18][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[19][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[19][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[20][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[20][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[21][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[21][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[22][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[22][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[23][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[23][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[24][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[24][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[25][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[25][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[26][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[26][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[27][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[27][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[28][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[28][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[29][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[29][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[30][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[30][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[31][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[31][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[32][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[32][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[33][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[33][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[34][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[34][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[35][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[35][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[36][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[36][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[37][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[37][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[38][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[38][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[39][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[39][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[40][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[40][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[41][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[41][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[42][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[42][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[43][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[43][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
  { C_PT_AFFINE,
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[44][0], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_precomputed_G_w5[44][1], 5 },  
  { C_POSITIVE, curve32_words_secp160r1_base_point_G_z,       5 }, },
};

#if 0
// 45 precomputed base points with window size of 5
static const tsECPrecomputedP curve32_secp160r1_precomputed_G_w5 =
{
   curve32_point_secp160r1_precomputed_G_w5,  /* array of precomputed points       */
   45,                                        /* number of precomputed points      */       
   (tU8) 5                                    /* window size of precomputed points */
};

// secp160r1 curve (define ecc field parameter before first use!)
static const tsECCurve curve32_secp160r1 =
{
  { C_POSITIVE, curve32_words_secp160r1_prime_p, 5 },             /* prime_p             */
  { C_POSITIVE, curve32_words_secp160r1_coefficient_a, 5 },       /* coefficient_a       */
  { C_POSITIVE, curve32_words_secp160r1_coefficient_b, 5 },       /* coefficient_b       */
  {   C_PT_AFFINE,                                                /* base point G type   */
    { C_POSITIVE, curve32_words_secp160r1_base_point_G_x, 5 },    /* base point G->x     */   
    { C_POSITIVE, curve32_words_secp160r1_base_point_G_y, 5 },    /* base point G->y     */   
    { C_POSITIVE, curve32_words_secp160r1_base_point_G_z, 5 }, }, /* base point G->z     */   
  { C_POSITIVE, curve32_words_secp160r1_base_point_order_n, 6 },  /* base_point_order_n  */
  1,                                                              /* cofactor_h          */
  { C_POSITIVE, curve32_words_secp160r1_my_p, 6 },                /* precalculated my_p  */
  { C_POSITIVE, curve32_words_secp160r1_my_n, 7 },                /* precalculated my_n  */
  NULL,                                                           /* ecc field parameter */
};
#endif
