//-----------------------------------------------------------------------------
// ECC OVER GF(P) - Functions (see ecc_ecdh_ecdsa.c)
//-----------------------------------------------------------------------------


extern int ecc_public_key_generation(
	tsECPoint *pQ,
	const tsECFieldElement *d,
	const tsECCurve *cGP 
);

extern int ecc_public_key_validation(
	const tsECPoint *pQ,
	const tsECCurve *cGP 
);


/* ECDH ********************************************************************/
 
extern int ecdh_compute_shared_secret(
	tsECFieldElement *z,
	const tsECFieldElement *dA,
	const tsECPoint *pQB,
	const tsECCurve *cGP 
);

/* ECDSA *******************************************************************/


extern int ecdsa_signature_generation(
	tsECSignature *ecc_sig, 
	const tsECFieldElement *msg_hash,
	const tsECFieldElement *d,
	const tsECFieldElement *k,
	const tsECPrecomputedP *precomputed_G,
	const tsECCurve *cGP 
);

extern int ecdsa_signature_verification(
	const tsECFieldElement *msg_hash,
	const tsECSignature *ecc_sig,
	const tsECPoint *pQ,
	const tsECPrecomputedP *precomputed_G,
	const tsECCurve *cGP 
);


//-----------------------------------------------------------------------------
// FIELD ARITHMETIC OVER GF(P) (see ecc_field.c)
//-----------------------------------------------------------------------------

// field_element_allocate
#define field_element_allocate(a, word_length) {	\
  (a)->word = (tU32 *) M_MEM_ALLOC((size_t)((word_length) * sizeof(tU32))); \
  (a)->length = (word_length);                                                \
}

// field_element_free
#define field_element_free(a) {	\
  M_MEM_FREE( (a)->word );	\
  (a)->length = 0;			\
}

/* fundamental functions ***************************************************/

extern int field_element_set_zero( tsECFieldElement *a );
extern int field_element_set_one( tsECFieldElement *a );
extern int field_element_is_zero( const tsECFieldElement *a );
extern int field_element_is_one( const tsECFieldElement *a );
extern int field_element_is_negative( const tsECFieldElement *a );

extern int field_element_absolute_compare(
	const tsECFieldElement *a,
	const tsECFieldElement *b
);

extern int field_element_compare( 
	const tsECFieldElement *a,
	const tsECFieldElement *b 
);

extern int field_element_assign(
	tsECFieldElement *c,
	const tsECFieldElement *a,
	const tU32            word_length_of_a 
);

extern int field_element_shift_n_right(
	tsECFieldElement *c,
	const tsECFieldElement *a, 
	const tU32            n 
);

extern int field_element_shift_n_left(
	tsECFieldElement *c,
	const tsECFieldElement *a,
	const tU32            n 
);

extern int field_element_add(
	tsECFieldElement *c,
	const tsECFieldElement *a,
	const tsECFieldElement *b 
);

extern int field_element_subtract(
	tsECFieldElement *c,
	const tsECFieldElement *a,
	const tsECFieldElement *b 
);

/* multiply & square functions *********************************************/

extern int field_element_multiply_classical(
	tsECFieldElement *c,
	const tsECFieldElement *a,
	const tsECFieldElement *b 
);

extern int field_element_multiply_w5_fast(
	tsECFieldElement *c,
	const tsECFieldElement *a,
	const tsECFieldElement *b 
);

extern int field_element_square_classical( 
	tsECFieldElement *c,
	const tsECFieldElement *a 
);

extern int field_element_square_w5_fast( 
	tsECFieldElement *c,
	const tsECFieldElement *a 
);

/* reduction functions *****************************************************/

extern int field_element_reduce_barrett( 
	tsECFieldElement *c,
	const tsECFieldElement *a,
	const tsECFieldElement *my_p,
	const tsECFieldElement *p 
);

extern int field_element_reduce_secp160r1(
	tsECFieldElement *c,
	const tsECFieldElement *a,
	const tsECFieldElement *my_p,
	const tsECFieldElement *p 
);


/* general modular functions ***********************************************/

extern int field_element_modular_add(
	tsECFieldElement *c,
	const tsECFieldElement *a,
	const tsECFieldElement *b,
	const tsECField     *fGP 
);

extern int field_element_modular_subtract(
	tsECFieldElement *c,
	const tsECFieldElement *a,
	const tsECFieldElement *b,
	const tsECField     *fGP 
);

extern int field_element_modular_multiply(
	tsECFieldElement *c,
	const tsECFieldElement *a,
	const tsECFieldElement *b,
	const tsECField     *fGP 
);

extern int field_element_modular_square( 
	tsECFieldElement *c,
	const tsECFieldElement *a,
	const tsECField     *fGP 
);

extern int field_element_modular_invert( 
	tsECFieldElement *c,
	const tsECFieldElement *a,
	const tsECField     *fGP 
);

extern int field_element_modular_divide_2(
	tsECFieldElement *c,
	const tsECFieldElement *a,
	const tsECField     *fGP 
);
 
/* auxiliary functions *****************************************************/
extern int field_element_degree( const tsECFieldElement *a );

extern int field_element_wNAF( 
	tS8            *k_NAF,
	const tU32            k_NAF_length,
	const tsECFieldElement *k,
	const tU8             window_size
);

//-----------------------------------------------------------------------------
// ECC POINT ARITHMETIC (see ecc_point.c)
//-----------------------------------------------------------------------------


/* basic/util functions ****************************************************/

extern int point_set_zero		( tsECPoint *pX );
extern int point_set_infinity	( tsECPoint *pX );
extern int point_is_zero		( const tsECPoint *pX );
extern int point_is_infinity	( const tsECPoint *pX );

extern int point_assign(
	tsECPoint *pY, 
    const tsECPoint *pX
);

extern int point_invert(
	tsECPoint *pY,
    const tsECPoint *pX,
    const tsECCurve *cGP
);


/* conversion functions ****************************************************/
extern int point_convert_to_jacobian(
	tsECPoint *pJ,
	const tsECPoint *pX,
	const tsECCurve *cGP
);

extern int point_convert_to_affine(
	tsECPoint *pA,
	const tsECPoint *pX,
	const tsECCurve *cGP
);


/* point math functions ****************************************************/
extern int point_jacobian_double(
	tsECPoint *pJ,
	const tsECPoint *pJ0,
	const tsECCurve *cGP 
);

extern int point_jacobian_add_mixed( 
	tsECPoint *pJ,
	const tsECPoint *pJ1,
	const tsECPoint *pA2,
	const tsECCurve *cGP
);

extern int point_jacobian_add( 
	tsECPoint *pJ,
	const tsECPoint *pJ0,
	const tsECPoint *pJ1,
	const tsECCurve *cGP 
);

extern int point_jacobian_subtract_mixed(
	tsECPoint *pJ,
	const tsECPoint *pJ1,
	const tsECPoint *pA2,
	const tsECCurve *cGP
);

extern int point_jacobian_subtract(
	tsECPoint *pJ,
	const tsECPoint *pJ0,
	const tsECPoint *pJ1,
	const tsECCurve *cGP
);

extern int point_jacobian_multiply_k_ary_window(
	tsECPoint *pJ,
	const tsECFieldElement *k,
	const tsECPoint        *pA1,
	const tU8              window_size,
	const tsECCurve        *cGP
);

extern int point_jacobian_multiply_fixed_window( 
	tsECPoint				*pJ,
	const tsECFieldElement	*k,
	const tsECPrecomputedP	*precomputed_P,
	const tsECCurve			*cGP
);

extern int point_allocate(
	tsECPoint		*pX, 
	const tU32      word_quantity,
	const tU8       point_type
);

extern int point_free( tsECPoint *pX );

