/******************************************************************************
 * FILE: profilecontrolhelper.h         
 * SW-COMPONENT: ProfileControlHelper
 * DESCRIPTION:  Test component for the profile control helper 
 * AUTHOR:       TMS GmbH Roland Jentsch
 * COPYRIGHT:     (c) 2008 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 ******************************************************************************/

 /******************************************************************************
| includes of component-internal interface, if necessary
| (scope: component-local)
|-----------------------------------------------------------------------------*/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "profilecontrolhelper_internal.h"

#include "profilecontrolhelper.h"

// include trace functionality
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"


/******************************************************************************
| defines and macros (scope: global)
|-----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: global)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| variable declaration (scope: global)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function prototypes (scope: local)
|-----------------------------------------------------------------------------*/

tVoid pchlThreadProc(tVoid* pvArg)
{
    tChar szName[OSAL_C_U32_MAX_PATHLENGTH] = "";
    tChar szTrace[OSAL_C_U32_MAX_PATHLENGTH] = "";
    tU32 i;
    OSAL_tIODescriptor sTestHandle;
    #define PCHL_MAX_TEST_NAMES 9
    tCString sList[PCHL_MAX_TEST_NAMES] = {"/nand0/abc.cfg","/nand0/abc.","/nand0/abc", "abc.cfg", "abc.", "abc", "", ".", 
                                            "/longname/aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\
                                             aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\
                                             aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\
                                             aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\
                                             aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa.cfg"};
    tenProfileType eProfile;

    ET_TRACE_ERROR(TR_COMP_SYSTEM, "ProfileControlHelperLibrary:: Start of Test Thread\n");
    
    // delayed start for ebinder 
    OSAL_s32ThreadWait(90000);
    
    while (TRUE)
    {
    
        // delayed start for ebinder 
        OSAL_s32ThreadWait(10000);
        
        if (pvArg == NULL) {} // only for lint
        
        for (eProfile = eProfileReadNew; eProfile < eProfileMax; ++eProfile)
        {
        
            // 1. test read for profile
            if (pchl_nGetProfileNumber(eProfile) != OSAL_ERROR)
            {
              ET_TRACE_ERROR(TR_COMP_SYSTEM,"OK: ProfileControlHelperLibrary: Test for pchl_nGetProfileNumber eProfile.");
            }
            else
            {
              ET_TRACE_ERROR(TR_COMP_SYSTEM,"NOK: ProfileControlHelperLibrary: Test for pchl_nGetProfileNumber eProfile.");
            }

            // 2. Test create names for new Profiles
            for (i=0;i<PCHL_MAX_TEST_NAMES;++i)
            {
                OSALUTIL_s32NPrintFormat((tS8*)szTrace, OSAL_C_U32_MAX_PATHLENGTH, "ProfileControlHelperLibrary: Test for %s pchl_fGetProfileFilePathName eProfile%d.", sList[i], eProfile);
                ET_TRACE_ERROR(TR_COMP_SYSTEM,szTrace);
                szName[0] = 0;
                
                if (pchl_fGetProfileFilePathName(szName, sizeof(szName), sList[i], eProfile))
                {
                  OSALUTIL_s32NPrintFormat((tS8*)szTrace, OSAL_C_U32_MAX_PATHLENGTH, "Result OK: %s", szName);
                  ET_TRACE_ERROR(TR_COMP_SYSTEM, szTrace);
                }
                else
                {
                  OSALUTIL_s32NPrintFormat((tS8*)szTrace, OSAL_C_U32_MAX_PATHLENGTH, "Result NOK: %s", szName);
                  ET_TRACE_ERROR(TR_COMP_SYSTEM,szTrace);
                }
            }

            // test to create file (if file not exist)
            sTestHandle = OSAL_IOCreateProfileFile(OSAL_C_STRING_DEVICE_FFS"/abc.cfg", eProfile);
            if (sTestHandle != OSAL_ERROR)
            {
                ET_TRACE_ERROR(TR_COMP_SYSTEM,"OK: ProfileControlHelperLibrary: Test for create abc.cfg eProfile.");
                OSAL_s32IOClose(sTestHandle);
            }
            else
            {
                ET_TRACE_ERROR(TR_COMP_SYSTEM,"NOK: ProfileControlHelperLibrary: Test for create abc.cfg eProfile.");
            }
            
            // test to open file (file exist)
            sTestHandle = OSAL_IOOpenProfileFile(OSAL_C_STRING_DEVICE_FFS"/abc.cfg", eProfile);
            if (sTestHandle != OSAL_ERROR)
            {
                ET_TRACE_ERROR(TR_COMP_SYSTEM,"OK: ProfileControlHelperLibrary: Test for open abc.cfg eProfile.");
                OSAL_s32IOClose(sTestHandle);
            }
            else
            {
                ET_TRACE_ERROR(TR_COMP_SYSTEM,"NOK: ProfileControlHelperLibrary: Test for open abc.cfg eProfile.");
            }
            
            // test to remove file (if file exist)
            sTestHandle = OSAL_s32IORemoveProfileFile(OSAL_C_STRING_DEVICE_FFS"/abc.cfg", eProfile);
            if (sTestHandle != OSAL_ERROR)
            {
                ET_TRACE_ERROR(TR_COMP_SYSTEM,"OK: ProfileControlHelperLibrary: Test for remove abc.cfg eProfile.");
            }
            else
            {
                ET_TRACE_ERROR(TR_COMP_SYSTEM,"NOK: ProfileControlHelperLibrary: Test for remove abc.cfg eProfile.");
            }

            // test to remove file (if file not exist)
            sTestHandle = OSAL_s32IORemoveProfileFile(OSAL_C_STRING_DEVICE_FFS"/abc.cfg", eProfile);
            if (sTestHandle != OSAL_ERROR)
            {
                ET_TRACE_ERROR(TR_COMP_SYSTEM,"NOK: ProfileControlHelperLibrary: Test for remove not existing abc.cfg eProfile.");
            }
            else
            {
                ET_TRACE_ERROR(TR_COMP_SYSTEM,"OK: ProfileControlHelperLibrary: Test for remove not existing abc.cfg eProfile.");
            }

            // test to open file (file not exist)
            sTestHandle = OSAL_IOOpenProfileFile(OSAL_C_STRING_DEVICE_FFS"/abc.cfg", eProfile);
            if (sTestHandle != OSAL_ERROR)
            {
                ET_TRACE_ERROR(TR_COMP_SYSTEM,"NOK: ProfileControlHelperLibrary: Test for open not existing abc.cfg eProfile.");
                OSAL_s32IOClose(sTestHandle);
            }
            else
            {
                ET_TRACE_ERROR(TR_COMP_SYSTEM,"OK: ProfileControlHelperLibrary: Test for open not existing abc.cfg eProfile.");
            }
        }
    }
    
    // ET_TRACE_ERROR(TR_COMP_SYSTEM, "ProfileControlHelperLibrary:: End of Test Thread\n");
    
}

tVoid pchl_vInitTest(tVoid)
{
   OSAL_trThreadAttribute rThAttr;
   OSAL_tThreadID _oThreadID;
   rThAttr.szName = "pchlTest";
   rThAttr.u32Priority = 100;
   rThAttr.s32StackSize = 4096;
   rThAttr.pfEntry = (OSAL_tpfThreadEntry)pchlThreadProc; 
   rThAttr.pvArg = NULL;

   ET_TRACE_ERROR(TR_COMP_SYSTEM, "ProfileControlHelperLibrary:: Try to create Test Thread\n");
   
   // create thread suspended
   _oThreadID = OSAL_ThreadSpawn(&rThAttr);

   // open pool, if failure -> do nothing any more...
   if(_oThreadID == OSAL_ERROR)
   {
      ET_TRACE_ERROR(TR_COMP_SYSTEM, "ProfileControlHelperLibrary:: Could not create Test Thread\n");
   }
}


/* ###### Test of Basic function ####### */
