/******************************************************************************
 * FILE: profilecontrolhelper.h         
 * SW-COMPONENT: ProfileControlHelper
 * DESCRIPTION:  Interface Definition for ProfileControlHelper
 * AUTHOR:       TMS GmbH Roland Jentsch
 * COPYRIGHT:     (c) 2008 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 ******************************************************************************/

#ifndef PROFILE_CONTROL_HELPER_HEADER
#define PROFILE_CONTROL_HELPER_HEADER

#ifdef __cplusplus
extern "C"{
#endif

/******************************************************************************
| includes of component-internal interface, if necessary
| (scope: component-local)
|-----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|-----------------------------------------------------------------------------*/

typedef enum
{
    eProfileReadNew, // new profile which should be read
    eProfileWriteOld, // old profile which should be write
    eProfileMax
} tenProfileType;

/******************************************************************************
| typedefs (scope: global)
|-----------------------------------------------------------------------------*/
#define PROFILECTRL_PROFILE_1 1
#define PROFILECTRL_PROFILE_2 2
#define PROFILECTRL_PROFILE_OTHER 0

/*******************************************************************************
| variable declaration (scope: global)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function prototypes (scope: global)
|-----------------------------------------------------------------------------*/

/* pchl_ -> profile control helper library */

// low level functions
tBool pchl_fGetProfileFilePathName(tString szProfileFilePathName, tU32 nProfileFilePathNameMaxLength, tCString szFilePathName, tenProfileType eProfile);
tS32 pchl_nGetProfileNumber(tenProfileType eProfile);

// middle level functions
OSAL_tIODescriptor OSAL_IOOpenProfileFileById(tCString coszName, OSAL_tenAccess enAccess, tU32 nProfileId);
OSAL_tIODescriptor OSAL_IOCreateProfileFileById(tCString coszName, OSAL_tenAccess enAccess, tU32 nProfileId);
tS32 OSAL_s32IORemoveProfileFileById(tCString coszName, tU32 nProfileId);


// high level functions
OSAL_tIODescriptor OSAL_IOOpenProfileFile(tCString coszName, tenProfileType eProfile);
OSAL_tIODescriptor OSAL_IOOpenProfileFileEx(tCString coszName, tenProfileType eProfile, tBool fUseDefaultFileIfNotExist);
OSAL_tIODescriptor OSAL_IOCreateProfileFile(tCString coszName, tenProfileType eProfile);
tS32 OSAL_s32IORemoveProfileFile(tCString coszName, tenProfileType eProfile);

// only for test purposes
tVoid pchl_vInitTest(tVoid);

#ifdef __cplusplus
}
#endif

#endif


