/************************************************************************
 * FILE:         mm_MessageTarget.cpp
 * PROJECT:      VASCO
 * SW-COMPONENT: (framework)
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  
 *
 *               --> See header file
 *
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      | Author   | Modification
 * 10.04.01  | Bruns    | initial revision, extracted from WorkThread 
 *           |          | module
 * 26.06.01  | Perick   | gets the MessageMap-Mechanism for 
 *           |          | WorkThreads (WIL) and transformed it to a
 *           |          | universal MessageMap-Mechanism (MM)
 * 16.10.01  | Perick   | removed error in pFindMsgEntry
 *************************************************************************/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "mm_MessageTarget.h"            // use workthread's message map

#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"              // use CCA messages



// static variable creation: The MessageMap
const mm_tMsgMap mm_tclMessageTarget::msgMap = {NULL,NULL};



//-----------------------------------------------------------------------------
// wil_tclMessageTarget (constructor)
//
//-----------------------------------------------------------------------------
mm_tclMessageTarget::mm_tclMessageTarget()
{
   // nothing to be done, yet.
}



//-----------------------------------------------------------------------------
// ~wil_tclMessageTarget (destructor)
//
//-----------------------------------------------------------------------------
mm_tclMessageTarget::~mm_tclMessageTarget()
{
   // nothing to be done, yet.
}



//-----------------------------------------------------------------------------
// bDefaultSvcDataHandler (private, static)
//
// Handler for incomming ServiceData messages to this thread. Examines attached 
// message maps and calls spcific handler ;-)
//-----------------------------------------------------------------------------
tBool mm_tclMessageTarget::bDefaultSvcDataHandler(mm_tclMessageTarget *pThis, amt_tclServiceData *poMessage) 
{
   // printf("** wil_tclMessageTarget: bDefaultSvcDataHandler called\n");

   const mm_tMsgMap* pMessageMap;
   const mm_tMsgMapEntry* pEntry;

   // look through message map to see if it applies to us
   // printf("searching message map...\n");
   for (pMessageMap = pThis->GetMsgMap(); pMessageMap != NULL; pMessageMap = pMessageMap->pBaseMap)
   {
      // printf("searching entry ...\n");
      pEntry = pThis->pFindMsgEntry(pMessageMap->pEntries, poMessage);
      if(pEntry != 0)
      {
         // printf("function found: %d -> 0x%x\n", pEntry->u16FunctionID, pEntry->pHandlerFunction);
         mm_tMsgFunction fun = pEntry->pHandlerFunction;
         (pThis->*fun)(poMessage);
         return true;
      }
      //else
        //printf("end of entry list reached...\n");
   }
   return FALSE;
}

//-----------------------------------------------------------------------------
// pFindMsgEntry
//
// Searches callback entry in message map. Returns NULL if not found.
//-----------------------------------------------------------------------------
const mm_tMsgMapEntry* mm_tclMessageTarget::pFindMsgEntry(const mm_tMsgMapEntry* lpEntry, 
                                                          const amt_tclServiceData *pMessage) const
{
   // C version of search routine
   tU16 u16FunctionID = pMessage->u16GetFunctionID();
   // printf("pFindMsgEntry: searching for id = %d\n", u16FunctionID );
   if(lpEntry != 0)
   {
      // printf("pFindMsgEntry: current id = %d\n", u16CurrentId);
      while ( (lpEntry->u16FunctionID) != 0)
      {
         if (lpEntry->u16FunctionID == u16FunctionID)
         {
            if (lpEntry->u8OpCode == AMT_C_U8_CCAMSG_OPCODE_INVALID)
            {
               return lpEntry;
            }
            else
            {
               tU8 u8OpCode = pMessage->u8GetOpCode();
               if (lpEntry->u8OpCode == u8OpCode)
               {
                  return lpEntry;
               }
            }
         }
         lpEntry++;
      }
   }
   return NULL;    // not found
}

//-----------------------------------------------------------------------------
// GetMsgMap
//
// 
//-----------------------------------------------------------------------------
const mm_tMsgMap* mm_tclMessageTarget::GetMsgMap() const
{
   return &msgMap;
}



//-----------------------------------------------------------------------------
// _GetBaseMsgMap
//
// 
//-----------------------------------------------------------------------------
const mm_tMsgMap* mm_tclMessageTarget::_GetBaseMsgMap()
{
   return NULL;
}

