/************************************************************************
 * FILE:         mm_MessageMap.h
 * PROJECT:      ELeNa
 * SW-COMPONENT: (framework)
 *----------------------------------------------------------------------
 * DESCRIPTION:  Framework for message map abstraction
 *
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      | Author   | Modification
 * 04.04.01  | Bruns    | initial revision
 * 26.06.01  | Perick   | gets the MessageMap-Mechanism for 
 *           |          | WorkThreads (WIL) and transformed it to a
 *           |          | universal MessageMap-Mechanism (MM)
 *           |          | (only renamed :-) )
 * 25.06.02  | Perick   | Fixed problem with handlerfunction pointer.
 *                        
 *************************************************************************/

#ifndef MM_MESSAGEMAP_H
#define MM_MESSAGEMAP_H

#define SYSTEM_S_IMPORT_INTERFACE_IPC
#include "system_pif.h"

class amt_tclServiceData;

//-----------------------------------------------------------------------------
// MessageMap Framework
// - thread's message handling
// REMARK: using same technique as MFC... see "message maps" ;-)
//-----------------------------------------------------------------------------
class mm_tclMessageTarget;                        // forward decl. to use

// type of all function callbacks
typedef void (mm_tclMessageTarget::*mm_tMsgFunction) (amt_tclServiceData*);


// entry for message maps
struct mm_tMsgMapEntry
{
   // Client
   mm_tMsgFunction           pHandlerFunction;
   tU16                      u16FunctionID;
   tU8                       u8OpCode;
};


// the message map
struct mm_tMsgMap
{
   const mm_tMsgMap         *pBaseMap;
   const mm_tMsgMapEntry    *pEntries;
};


#ifndef AMT_C_U8_CCAMSG_OPCODE_INVALID
#define AMT_C_U8_CCAMSG_OPCODE_INVALID 0xFF
#endif

//-----------------------------------------------------------------------------
// macro to declare a message map
//-----------------------------------------------------------------------------
#define DECLARE_MSG_MAP(theClass) \
private: \
   static const mm_tMsgMapEntry _msgMyEntries[]; \
    typedef theClass    _theClass;        \
protected: \
   static const mm_tMsgMap msgMyMap; \
   virtual const mm_tMsgMap* GetMsgMap() const; \

//-----------------------------------------------------------------------------
// macro to begin a message map definition
//-----------------------------------------------------------------------------
#define BEGIN_MSG_MAP(theClass, baseClass) \
   const mm_tMsgMap* theClass::GetMsgMap() const\
      { return &theClass::msgMyMap; } \
   const mm_tMsgMap theClass::msgMyMap = \
   { &baseClass::msgMap, &theClass::_msgMyEntries[0] }; \
   const mm_tMsgMapEntry theClass::_msgMyEntries[] = \
   { \

//-----------------------------------------------------------------------------
// macro to end the message map definition
//-----------------------------------------------------------------------------
#define END_MSG_MAP() \
   { (mm_tMsgFunction)0, 0, AMT_C_U8_CCAMSG_OPCODE_INVALID } \
   }; \

//-----------------------------------------------------------------------------
// macro for every function
//-----------------------------------------------------------------------------
#define ON_MESSAGE(message, memberFxn) \
   { (mm_tMsgFunction)&_theClass::memberFxn, message, AMT_C_U8_CCAMSG_OPCODE_INVALID },

#define ON_MESSAGE_SVCDATA(message, OpCode, memberFxn) \
   { (mm_tMsgFunction)&_theClass::memberFxn, message, OpCode },

#endif
