#ifndef BINSTREAM_H
#define BINSTREAM_H
//#include <functional>
//#include <string>
//#include <map>
#include <vector>
//#include <list>
//#include <set>
//#include <queue>
//#include <new>
//#include <memory>
//#include <algorithm>


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

namespace std {

/**
* ucharStream = binStream<unsigned char>:
* charStream = binStream<char>:
*
* The template encapsulates a vector and adds two functions which copies  
* sizeof(T) bytes into the vector and takes them in same way back into a class
* refence. The class does not care about pointer referencing. Deep copy must 
* be done by multiple calls with the different heap members.
* Requirement to C : constant size element
* Requirement to T : availability of sizeof() operator and a linear memory array 
*                    beginning at position of operator&().
*/
template<class C>
class binStream : public vector<C>
{
   typedef vector<C> super;
public:

   binStream(void)
      :vector<C>()
   {}

   /**
   * put a binary copy of the given class T at the end of vector 
   */
   template <class T>
   void push(const T & val, unsigned off = sizeof(T)) {
      super::insert(super::end(), (const C*)&val, (const C*)(&val) + off);
   }
   /**
   * restore a class T from the begin of the vector and decrease the vector
   * according count of elements C
   */
   template <class T>
   bool pop(T & val, unsigned off = sizeof(T)) {
      if(super::size() >= sizeof(T)) {
         OSAL_pvMemoryCopy( &val, (const void*)&super::front(), off);
         super::erase(super::begin(), super::begin()+off);
         return true;
      }
      return false;
   }
 };//lint !e1509 PQM_authorized_deactivation 120. Reason: Base class destructor for class 'vector' is not virtual but called explictly

typedef binStream<unsigned char> ucharStream;
typedef binStream<char> charStream;

}

#endif // INSTREAM_H
