///////////////////////////////////////////////////////////
//  ahl_tclStreamConfigStore.h
//  Implementation of the Class ahl_tclStreamConfigStore
//  Created on:      20-Sep-2007 00:04:10
//  Original author: Matthias Heling
///////////////////////////////////////////////////////////

#if !defined(AHL_TCLSTREAMCONFIGSTORE_H)
#define AHL_TCLSTREAMCONFIGSTORE_H

#include "ahl_tclBaseConfigStore.h"
#include "binstream.h"
typedef std::ucharStream tclStream;

/**
* ---General---
* The class supports with all functionality needed to store configuration data into 
* the FFS in a standardized way. The developer inherits from the framework class and
* implements the set and get functions for his data.
* Additionally he can decide if data shall be stored in machine specific or user  
* specific file. He need not to care about which user is set; the framework checks 
* this already with the value set in the registry. The user id in registry is 
* expected to be only valid for the time when loadData is called. Therefore the 
* value is only read in loadData function and storeData uses this remembered value.
* This requires at least one successfull loadData before storeData is working.
* In exceptional case developer can adjust or retrieve the users id with given 
* functions. To set the user id from outside.
* --> more information see ahl_tclBaseConfigStore
* ahl_tclStreamConfigStore enriches ahl_tclBaseConfigStore with functions of 
* serialization of values.
* In case that the devlopper does not have an fixed array of configuration data 
* he may want to provide the data into and out of a "stream". Because stl::stream
* is not supported by std stream serialization is done with dump and restore
* function templates which put the data into the internal buffer.
* In case of classes with dynamic content the devlopper must provide copy constructor 
* with deep copy to ensure data is stored correctly. The additional dumpsize function 
* is called before call to dump to reserve enough space in the internal buffer.
*/
class ahl_tclStreamConfigStore : public ahl_tclBaseConfigStore
{

public:
	/**
    * ahl_tclStreamConfigStore inherits ahl_tclBaseConfigStore and adds streaming
    * configuration in and out by using std::binStream. This enables developer to put
    * dynamic content into the config store.
    */
	ahl_tclStreamConfigStore(tCString szConfigFileName, tU8 u8Major, tU8 u8Minor);
	virtual ~ahl_tclStreamConfigStore();

	/**
	 * This function provides the number of bytes expected to be stored in the 
    * config file. developer may want to override the function with the real size
    * of all config data to prevent binStream for multiple resizing its capacity
	 */
   virtual tU32 u32GetMachineDataSize() const {
      return 100;
   }
	/**
    * vSetMachineDataStream() is providing the data of the machine configuration
    * file. The framework reads the File and provides the data as tclStream.
    * developer can restore his data be calling is.pop_front() multiple times
    * in the same order as data was pushed in before.
    * @param oIstream tclStream conatining the data from te configuration file
    */
	virtual tVoid vSetMachineDataStream(tclStream& oIstream)=0;
   /**
   * vGetMachineDataStream() requests for the data to be put into the configuration 
   * file. 
   * The developer puts all his config data by calling os.push_back() in the same 
   * order into the stream as he wants to restore it later.
   * @param oOstream tclStream to add the config data
	*/
	virtual tVoid vGetMachineDataStream(tclStream& oOstream)=0;
	/**
   * vGetMachineDefaultDataStream() requests the default data in oOstream.
   * @param oOstream tclStream to add the default config data
	*/
	virtual tVoid vGetMachineDefaultDataStream(tclStream& oOstream)=0;
	/**
	 * This function provides the number of bytes expected to be stored in the 
    * config file. developer may want to override the function with the real size
    * of all config data to prevent binStream for multiple resizing its capacity
	 */
   virtual tU32 u32GetUserDataSize() const {
      return 100;
   }
	/**
	 * vSetUserDataStream() functions same as vSetMachineDataStream() but user specific
    * @param oIstream tclStream conatining the data from te configuration file
	 */
	virtual tVoid vSetUserDataStream(tclStream& oIstream)=0;
	/**
	 * vGetUserDataStream() functions same as vGetMachineDataStream() but user specific
    * @param oOstream tclStream to add the data
	 */
	virtual tVoid vGetUserDataStream(tclStream& oOstream)=0;
	/**
	 * vGetUserDefaultDataStream() functions same as vGetMachineDefaultDataStream() 
    * but user specific.
    * @param oOstream tclStream to add the data
	 */
	virtual tVoid vGetUserDefaultDataStream(tclStream& oOstream)=0;

private:
	/**
	 * the constructor definiert wo die daten gespeichert werden sollen. Der name ist
	 * ein file mit ordnern( vollstndiger pfad ab /dev/ffs) an dessen ende die userid
	 * angehngt wird
	 */
   ahl_tclStreamConfigStore();   //lint !e1704 prio3 reviewed: default constructor forbidden for this class

   /**
   * the base functions are implemented as calls to the according stream functions
   * therefore user shal not call this functions, because they are handled inside of this class.
   */
	virtual tVoid vSetMachineData(tPCU8 pcu8Buf, tU32 u32Length);//lint !e1768 prio3 reviewed: see comment above
	virtual tVoid vGetMachineData(tPCU8 &rpcu8Buf, tU32 &ru32Length);//lint !e1768 prio3 reviewed: see comment above
	virtual tVoid vGetMachineDefaultData(tPCU8 &rpcu8Buf, tU32 &ru32Length);//lint !e1768 prio3 reviewed: see comment above
	virtual tVoid vSetUserData(tPCU8 pcu8Buf, tU32 u32Length);//lint !e1768 prio3 reviewed: see comment above
   virtual tVoid vGetUserData(tPCU8 &rpcu8Buf, tU32 &ru32Length);//lint !e1768 prio3 reviewed: see comment above
   virtual tVoid vGetUserDefaultData(tPCU8 &rpcu8Buf, tU32 &ru32Length);//lint !e1768 prio3 reviewed: see comment above

   /**
   * data container for serialization of the config data
   */
   tclStream mStream;
};
#endif // !defined(AHL_TCLSTREAMCONFIGSTORE_H)
