/************************************************************************
* FILE:         ahl_tclEventThread.cpp
* PROJECT:      VWLLNF
* SW-COMPONENT: (framework)
*----------------------------------------------------------------------
*
* DESCRIPTION:  base workthread's with event communication
*              
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author   | Modification
* 30.07.08  | Hessling | added Thread with event comunication to AHL                     
* 13.02.09  | Hessling | start and stop handling changed for improving against dead locks
* 01.03.09  | Hessling | seperation in MessageThread and EventThread
*************************************************************************/
#include "ahl_tclEventThread.h"

#include "ahl_trace.h"

// -- trace identifier ------- define this value for __every__ file new 
// regardless if used or not ;-)
#ifdef FILE_NUMBER
#undef FILE_NUMBER
#endif
#define FILE_NUMBER TRC::ahl_Thread_cpp // TODO
#ifdef FILE_NUMBER
#endif
// -- trace identifier ------- end

#define AHL_THREAD_NAME "AHL________"

ahl_tclEventThread::ahl_tclEventThread(tU16 u16AppId,//=((tU16)-1), 
                                       tCString szThreadName,    //=0, 
                                       tS32 s32DefaultStackSize, //=1024, 
                                       tU32 u32DefaultPrio)      //=OSAL_C_U32_THREAD_PRIORITY_LOWEST)
                                       :ahl_tclBaseThread(u16AppId, szThreadName, s32DefaultStackSize, u32DefaultPrio),
                                       _oResultMask(0), _hEvent(OSAL_C_INVALID_HANDLE)
{
   TRACE_FLOW_DEF(TRC::FnConstructor);
   // event queue to communicate to the worker thread
   TRACE_ON_ERROR_OSAL(TRC::FnConstructor, 
      OSAL_s32EventCreate(_as8ThreadName, &_hEvent));
}

ahl_tclEventThread::~ahl_tclEventThread()
{
   TRACE_FLOW_DEF(TRC::FnDestructor);
   (tVoid)bStop(); //lint !e1551 Function may throw exception
   (tVoid)OSAL_s32EventClose(_hEvent);
   (tVoid)OSAL_s32EventDelete(_as8ThreadName);
}

tVoid ahl_tclEventThread::vPostEvent(OSAL_tEventMask u32Event)
{
   TRACE_FLOW_DEF(TRC::FnPostEventToThread);
   TRACE_ON_ERROR_OSAL(TRC::FnPostEventToThread,
      OSAL_s32EventPost(_hEvent, u32Event, OSAL_EN_EVENTMASK_OR));
}

tVoid ahl_tclEventThread::vTrigger() 
{
   TRACE_FLOW_DEF(TRC::FnTrigger);
   vPostEvent(1);
}

tBool ahl_tclEventThread::bWaitForTrigger(){
   TRACE_FLOW_DEF(TRC::FnWaitForTrigger);
   // check if event handle hasn't been closed
   if(_hEvent == OSAL_C_INVALID_HANDLE)
   {
      // we can't do anything else than stopp
      TRACE_ERROR(TRC::FnThreadProc, TRC::ErrNullPointerInstanceMissing);
      return FALSE;
   }
   // wait for next action to do
   if(OSAL_ERROR == OSAL_s32EventWait(_hEvent,((tU32)-1), 
                                      OSAL_EN_EVENTMASK_OR, 
                                      OSAL_C_TIMEOUT_FOREVER, 
                                      &_oResultMask ))
   {
      TRACE_ERROR_OSAL(TRC::FnWaitForTrigger);
      return FALSE;
   }
   // reset this events
   if(OSAL_ERROR == OSAL_s32EventPost(_hEvent,
                                      ~_oResultMask ,
                                      OSAL_EN_EVENTMASK_AND))
   {
      TRACE_ERROR_OSAL(TRC::FnWaitForTrigger);
      return FALSE;
   }
   return TRUE;
}

tBool ahl_tclEventThread::bBaseThreadFunction(tPVoid pvInst)
{
   TRACE_FLOW_DEF(TRC::FnBaseThreadFunction);
   // --------- call to the working function --------- 
   if(pvInst) {
      tBool bRes = ((ahl_tclEventThread*)pvInst)->bThreadFunction(_oResultMask);
      _oResultMask = 0;
      return bRes;
   }
   return FALSE;
}

tVoid ahl_tclEventThread::vClearTriggers()
{ 
   TRACE_FLOW_DEF(TRC::FnClearTriggers);
   TRACE_ON_ERROR_OSAL(TRC::FnClearTriggers,
      OSAL_s32EventPost (_hEvent, 0 , OSAL_EN_EVENTMASK_AND));   
}

tVoid ahl_tclEventThread::vClearEvents() 
{
   TRACE_FLOW_DEF(TRC::FnClearEvents);
   vClearTriggers();
}

// EOF

