/******************************************************************************
 * $Revision:   1.1  $
 * $Date:   05 Sep 2003 14:58:38  $
 * A changelog can be found at the end of this file.
 ******************************************************************************
 * FILE:         Voice_NotificationTable.h
 * SW-COMPONENT: FCVD_Voice
 * DESCRIPTION:  A specialised notification table
 * AUTHOR:       CM-CR/EES4-Grosse Pawig
 * COPYRIGHT:    (c) 2002 Blaupunkt Werke GmbH
 * HISTORY:
 * 22.07.03      Rev 1.0
 *               Initial revision
 *****************************************************************************/
#ifndef AHL_CCANOTIFICATIONTABLE_HEADER
#define AHL_CCANOTIFICATIONTABLE_HEADER

#define AHL_S_IMPORT_INTERFACE_NOTIFICTABLE
#include "ahl_if.h"

#include <map>
#include <iterator>


typedef std::map<tU16, tU16> tFunctionMap;

class ahl_tclCCANotificationTable
{
public:
   ahl_tclCCANotificationTable();

   tBool bInit(tU16 u16ApplID, tU16 u16ServiceID, tU16 u16Major, tU16 u16Minor, tU16 u16Patch);
   tBool bDestroy();

   tBool bLock();
   tVoid vUnlock();

   tBool bAddNotification(const amt_tclServiceData& corfoMsg);
   ahl_tNotification* poGetNotification(tU16 u16FktID, tU16 u16RegID);
   ahl_tNotification* poGetNextNotification(tU16 u16FktID, const ahl_tNotification* poPrevNotification = NULL);
   tBool bRemoveNotification(tU16 u16FktID, tU16 u16RegID);
   tBool bEraseNotifications(tU16 u16FktID, tU16 u16RegID);

   tBool bRemoveAllEntriesWithRegID(tU16 u16RegID);
   tFunctionMap             m_FktIdMap;

   tVoid vTraceTable(tU16 u16ClassID) const;

private:
   tBool bRemoveNotification(tU16 u16FktID, const ahl_tNotification* poNotify);

   ahl_tclNotificationTable m_oNotTable;
   OSAL_tSemHandle          m_hLock;
                                              //           "ahl_CC" + u16AppId + u16SrvId + u16Maj + u16Min + u16Patch + "\0"
   tChar                    m_szLockName[27]; // Space for     6    +    4     +     4    +    4   +   4    +     4    +  1  = 27
};

#endif
