/******************************************************************************
 * $Revision:   1.3  $
 * $Date:   14 Jun 2012 15:32:56  $
 * A changelog can be found at the end of this file.
 ******************************************************************************
 * FILE:         ahl_CCAMethodTable.h
 * SW-COMPONENT: AHL
 * DESCRIPTION:  A specialised notification table for methods
 * AUTHOR:       BSOT Jentsch
 * COPYRIGHT:    (c) 2012 Bosch
 * HISTORY:
 * 10.06.12      Rev 1.0
 *               Initial revision
 *****************************************************************************/
#ifndef AHL_CCAMETHODTABLE_HEADER
#define AHL_CCAMETHODTABLE_HEADER

#include <map>
#include <deque>
#include <iterator>


#define AHL_S_IMPORT_INTERFACE_NOTIFICTABLE
#define AHL_S_IMPORT_INTERFACE_TIMER
#include "ahl_if.h"

/* use AIL template */
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"


typedef enum 
{
   AHL_EN_METHOD_MRHT_NORMAL,
   AHL_EN_METHOD_MRHT_REJECT,
   AHL_EN_METHOD_MRHT_QUEUEING
} ahl_tenMethodMultipleRequestHandlingType;

#define AHL_MAX_LOCK_NAME 16
#define AHL_METHOD_TIMER_CYCLE 1000
#define AHL_METHOD_TIMER_DEFAULT_TIMEOUT 3600000

typedef std::deque<amt_tclServiceData*> ahl_tclServiceDataMessageArray;

typedef struct ahl_tMethodList_tag
{
   tU32                 u32EndTime;
   tU16                 u16AppID;
   tU16                 u16AppSubID;
   tU16                 u16SrvID;
   tU16                 u16RegisterID;
   tU16                 u16CmdCounter;   // Zuordnungsnummer(wird vom Server transparent durchgereicht)
   tU16                 u16FunctionID;
   tBool                bEntryIsFree;
} ahl_tRunningMethod;

typedef struct ahl_tMethodListHandlingType_tag
{
   tU32                                     u32Timeout;
   ahl_tenMethodMultipleRequestHandlingType eHandlingType;
} ahl_tMethodHandlingType;

typedef std::map<tU16, ahl_tRunningMethod> ahl_tRunningMethodMap;
typedef std::map<tU16, ahl_tMethodHandlingType> ahl_tMethodHandlingTypeMap;
typedef std::map<tU16, ahl_tclServiceDataMessageArray> ahl_tStoredMessagesMap;


class ahl_tclCCAMethodTable
{
public:
   ahl_tclCCAMethodTable(ail_tclOneThreadAppInterface* pMainApp);

   tBool bInit();
   tBool bDestroy();

   tBool bLock() const;
   tVoid vUnlock() const;

   // functions 
   tBool bSetMethodHandlingType(tU16 u16FktID, ahl_tenMethodMultipleRequestHandlingType eHandlingType, tU32 nTimeout);
   ahl_tenMethodMultipleRequestHandlingType sGetMethodHandlingType(tU16 u16FktID) const;
   tU32 nGetMethodHandlingTimeout(tU16 u16FktID);

   // functions for running methods
   tBool bSetRunningMethod(const amt_tclServiceData& corfoMsg);
   tBool bIsMethodRunning(tU16 u16FktID) const;
   tBool bClearRunningMethod(tU16 u16FktID);

   tBool bStoreMethodstartMessage(tU16 u16FunctionId, amt_tclServiceData* poMsg);
   amt_tclServiceData* pGetStoredMethodstartMessage(tU16 u16FunctionId);

   tVoid vTraceTable(tU16 u16ClassID) const;
private:
   ail_tclOneThreadAppInterface* _pMainApp;
   ahl_tRunningMethodMap        _oMethodTable;
   ahl_tMethodHandlingTypeMap   _oMethodHandlingTypeMap;
   ahl_tStoredMessagesMap       _oStoredMessagesMap;
   OSAL_tSemHandle              _hLock;
   tChar                        _szLockName[AHL_MAX_LOCK_NAME];

   // Functionality for Timer 
   tVoid vStartTimer();
   tVoid vStopTimer();
   tVoid vOnTimerCallback(tVoid* pParam);
   ahl_tclExCallbackTimer<ahl_tclCCAMethodTable> _atclTimer;
   tBool _abTimerCreated;
   tBool _abTimerStarted;
};

#endif
