/************************************************************************
* FILE:          ahl_BaseClient.h
* PROJECT:       none
* SW-COMPONENT:  AHL
*----------------------------------------------------------------------
*
* DESCRIPTION: 
*              
*----------------------------------------------------------------------
*
* AUTHOR:  ESE-Neumann  (jn82hi)
*          TMS-Kempen   (kmr2hi)
*          TMS-Jentsch  (jhr2hi)           
*
* COPYRIGHT:    (c) 2008 Robert Bosch GmbH, Hildesheim
*
* HISTORY:      
*************************************************************************/

#ifndef _AHL_BASECLIENTBASICS_H_
#define _AHL_BASECLIENTBASICS_H_

#include "ahl_ccaNotificationTable.h"

/* ################################# Defines ############################# */

#define AHL_C_U16_CMDCOUNT_UPREGMSG     1
#define AHL_C_U16_CMDCOUNT_RELUPREGMSG  2

// define the maximum number of properties which an clienthandler could register automatically
#ifndef AHL_MAX_FUIDS
#define AHL_MAX_FUIDS 20
#endif

#define AHL_STARTUP_NUMBER_OF_OBJECTS_LIST_CAPACITY 20

#define AHL_STARTUP_TRY_REGISTER_WITHOUT_WAIT
#define AHL_CHECK_FUID_STILL_ADDED

#define AHL_CHECK_FOR_CCA_MESSAGES_ON_EACH_EVENT
// #define AHL_WAITTIME_CCA_EVENTS OSAL_C_U32_INFINITE
#define AHL_WAITTIME_CCA_EVENTS 5000

// define the maximum size of the system state matrix 
#define AHL_MAX_PAIRLIST 16

/* ################################# Typedefs ############################# */


typedef enum 
{
   AHL_EN_SERVICE_STATE_INVALID,
   AHL_EN_SERVICE_STATE_SERVICE_REGISTERED,
   AHL_EN_SERVICE_STATE_FID_REGISTERED,
   AHL_EN_SERVICE_STATE_INITIALIZATION_FINISHED
} ahl_tenServiceState;

typedef enum 
{
   AHL_PAIRLIST_ALL,
   AHL_PAIRLIST_ALL_LOWER,
   AHL_PAIRLIST_ALL_GREATER
} ahl_tenPairListAdd;

typedef enum 
{
   AHL_PAIRLIST_DEFAULT_EMPTY,
   AHL_PAIRLIST_DEFAULT_LOAD_SETTINGS_FILE,
   AHL_PAIRLIST_DEFAULT_SAVE_SETTINGS_FILE,
   AHL_PAIRLIST_DEFAULT_REGISTER_FOR_SERVICE,
   AHL_PAIRLIST_DEFAULT_UNREGISTER_FOR_SERVICE,
   AHL_PAIRLIST_DEFAULT_SERVICE_AVAILABLE,
   AHL_PAIRLIST_DEFAULT_SERVICE_UNAVAILABLE
} ahl_tenPairListSetDefault;

struct ahl_sAppInfoRequest
{
   tU16 u16Service;
   tU16 u16App;
   tU8  u8AppState;
};

struct ahl_sServiceConfig
{
   tBool  bAutoHandleGet;
   tBool  bAutoHandleSet;
   tBool  bAutoHandleIncDec;
   tBool  bEnableHighPrioFIDs;
};

/* ################################# Functions ############################# */

tU8 ahl_u16ConvertAppStateToServiceState(tU8 u8SrvSupplierState);

/* ################################# Property Admin Class ############################# */

class ahl_tclPropertyAdmin
{
public:

   ahl_tclPropertyAdmin();

   inline tVoid vReset()
   {
      _bRegDone         = FALSE;
      _bRegInProgress   = FALSE;
      _bUnRegInProgress = FALSE;
   }

   inline tBool bIsRegDone() const
   {
      return( _bRegDone );
   }

   inline tVoid vRegStarted()
   {
      _bRegDone       = TRUE;
      _bRegInProgress = TRUE;
   }

   inline tVoid vRegFinished()
   {
      _bRegInProgress = FALSE;
   }

   inline tVoid vRegFailed()
   {
      _bRegDone       = FALSE;
      _bRegInProgress = FALSE;
   }

   inline tBool bIsRegInProgress() const
   {
      return( _bRegInProgress );
   }

   inline tVoid vUnRegStarted()
   {
      _bUnRegInProgress = TRUE;
   }

   inline tVoid vUnRegFinished()
   {
      _bRegDone         = FALSE;
      _bUnRegInProgress = FALSE;
   }

   inline tVoid vUnRegFailed()
   {
      _bRegDone         = FALSE;
      _bUnRegInProgress = FALSE;
   }

   inline tBool bIsUnRegInProgress() const
   {
      return( _bUnRegInProgress );
   }

   inline tBool bIsAnyReplyPending() const
   {
      return( _bRegInProgress || _bUnRegInProgress );
   }

   inline tBool bIsReadyForWork() const
   {
      return( _bRegDone && !_bRegInProgress && !_bUnRegInProgress );
   }

private:

   tBool  _bRegDone;
   tBool  _bRegInProgress;
   tBool  _bUnRegInProgress;
};

struct ahl_sAdminHelper
{
    ahl_tclPropertyAdmin tclAdmin;
    tU16 u16FID;
};


/* ################################# Pairlist class ############################# */

class ahl_tclPairList
{
private:
   tU32 _nMin, _nMax;
   tU32 _nMatrix[AHL_MAX_PAIRLIST];
   ahl_tclPairList();//lint !e1704 Info 1704 , eliminating lint warnings the way of Lars.
public:

   ahl_tclPairList(tU32 nMin, tU32 nMax);
   tBool bAddPair(tU32 nFrom, tU32 nTo);
   tBool bAddFrom(tU32 nFrom, ahl_tenPairListAdd enAddOption = AHL_PAIRLIST_ALL);
   tBool bAddTo(tU32 nTo, ahl_tenPairListAdd enAddOption = AHL_PAIRLIST_ALL);
   tBool bRemovePair(tU32 nFrom, tU32 nTo);
   tBool bSetDefault(ahl_tenPairListSetDefault enDefault);
   tBool bIfPairIncluded(tU32 nFrom, tU32 nTo) const;
};

/* ################################# ServerProperties class ############################# */

class tclServerProperties
{
public:
    tclServerProperties();
    ahl_tclCCANotificationTable _oNotificationTable;
};

#define CCA_EVENT 0x80000000
#define TIMER_EVENT_0 0x40000000
#define TIMER_EVENT_1 0x20000000
#define TIMER_EVENT_2 0x10000000
#define TIMER_EVENT_3 0x08000000
#define TIMER_EVENT_4 0x04000000
#define TIMER_EVENTS (TIMER_EVENT_0 | TIMER_EVENT_1 | TIMER_EVENT_2 | TIMER_EVENT_3 | TIMER_EVENT_4)
#define PROHIBITED_EVENTS (CCA_EVENT|TIMER_EVENTS)
#define OTHER_EVENTS ~PROHIBITED_EVENTS
#define AHL_MAX_TIMERS 5


#endif /* _AHL_BASECLIENTBASICS_H_ */
