/********************************************************************//**
 * @file         ahl_StreamFuncMsgMap.h
 * @ingroup      StreamMsgMap
 *
 * @component    Application Help Library
 *
 * @description  Framework for message map abstraction.
 *
 *               This module is copied from mm_MessageMap.h and is
 *               modified for the use of ahl_tclStreamer messages
 *               instead of amt_tclServiceData messages.
 *
 * @author       CM-AM/ENG-DI-Gieseke
 * @copyright    2002,2006 Blaupunkt GmbH
 ************************************************************************/

#ifndef AHL_STREAMFUNCMSGMAP_H
#define AHL_STREAMFUNCMSGMAP_H

#define OSAL_S_IMPORT_INTERFACE_GENERIC   /*!< Import all OSAL features */
#include "osal_if.h"

class ahl_tclStreamer;

class ahl_tclStreamMessageTarget;   // forward decl. to use

/********************************************************************//**
 * @typedef     ahl_tStrMsgFunction
 * @ingroup     StreamMsgMap
 *
 * @description Type of all function callbacks.
 *
 *              This type defines the notification callback function
 *              interface.
 *
 * @param       poStream (->I) \n
 *              Points to the ahl_tclStreamer object that is to be
 *              handled by the callback.
 *
 * @return      -
 ************************************************************************/
typedef void (ahl_tclStreamMessageTarget::*ahl_tStrMsgFunction) (ahl_tclStreamer* poStream);

/********************************************************************//**
 * @struct      ahl_tStreamMsgMapEntry
 * @ingroup     StreamMsgMap
 *
 * @description Entry for message maps.
 *
 ************************************************************************/
struct ahl_tStreamMsgMapEntry
{
   tU16                u16FunctionID;    /*!< Function ID of the message
                                          *   that is to be handled.    */
   ahl_tStrMsgFunction pHandlerFunction; /*!< The message handler for
                                          *   this function ID.         */
};

/********************************************************************//**
 * @struct      ahl_tStreamMsgMap
 * @ingroup     StreamMsgMap
 *
 * @description The message map.
 *
 ************************************************************************/
struct ahl_tStreamMsgMap
{
   const ahl_tStreamMsgMap      *pBaseMap; /*!< The message map of the
                                            *   base class. */
   const ahl_tStreamMsgMapEntry *pEntries; /*!< The entries of this message
                                            *   map. */
};


/********************************************************************//**
 * @define      DECLARE_STREAMMSG_MAP
 * @ingroup     StreamMsgMap
 *
 * @description Declare a message map.
 *
 *              This macro declares members that needed to install a
 *              message map in a class.
 *
 * @param       theClass \n
 *              Name of the class within which the message map is to
 *              be declared.
 ************************************************************************/
#define DECLARE_STREAMMSG_MAP(theClass) \
private: \
	static const ahl_tStreamMsgMapEntry _oStreamMsgEntries[]; \
    typedef theClass    _theClass;        \
protected: \
	static const ahl_tStreamMsgMap _oStreamMsgMap; \
	virtual const ahl_tStreamMsgMap* poGetStreamMsgMap() const; \

/********************************************************************//**
 * @define      BEGIN_STREAMMSG_MAP
 * @ingroup     StreamMsgMap
 *
 * @description Begin a message map definition.
 *
 *              This macro begins the concrete definition of a classes'
 *              message map.
 *
 * @param       theClass \n
 *              Name of the class within which the message map is to
 *              be declared.
 *
 * @param       baseClass \n
 *              Name of a base class whose message map will be inherited.
 ************************************************************************/
#define BEGIN_STREAMMSG_MAP(theClass, baseClass) \
	const ahl_tStreamMsgMap* theClass::poGetStreamMsgMap() const\
		{ return &theClass::_oStreamMsgMap; } \
	const ahl_tStreamMsgMap theClass::_oStreamMsgMap = \
	{ &baseClass::_oStreamMsgMap, &theClass::_oStreamMsgEntries[0] }; \
	const ahl_tStreamMsgMapEntry theClass::_oStreamMsgEntries[] = \
	{ \

/********************************************************************//**
 * @define      ON_STREAMMESSAGE
 * @ingroup     StreamMsgMap
 *
 * @description Define a message map entry.
 *
 *              This macro inserts an entry into the message map.
 *
 * @param       message \n
 *              Function ID for this entry.
 *
 * @param       memberFxn \n
 *              Name of the member function that is to be called to
 *              handle a message.
 ************************************************************************/
#define ON_STREAMMESSAGE(message, memberFxn) \
	{ message, (ahl_tStrMsgFunction)&_theClass::memberFxn },

/********************************************************************//**
 * @define      END_STREAMMSG_MAP
 * @ingroup     StreamMsgMap
 *
 * @description End the message map definition.
 *
 *              This macro concludes the definition of a classes'
 *              message map.
 ************************************************************************/
#define END_STREAMMSG_MAP() \
   { 0, (ahl_tStrMsgFunction)0 } \
	}; \

#endif
