/*****************************************************************************
 * FILE:         ahl_NotificationTable.h
 * PROJECT:      ELeNa
 * SW-COMPONENT: 
 *----------------------------------------------------------------------------
 *
 * DESCRIPTION:  This class handles a notification table structure. 
 *              
 *----------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2001 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      | Author            | Modification
 * 17.07.01  | CM/EPE Perick     | initial version
 * 23.11.01  | CM/EPE Perick     | removed dynamic list and changed the 
 *                                 NotifactionTable to a static mechanism
 *                                 (avoid memory fragmentation)
 * 12.09.03  | CM-CR/EES4 Perick | add bRemoveAllEntriesWithRegID
 * 
 *****************************************************************************/
#ifndef AHL_NOTIFICATIONTABLE_H
#define AHL_NOTIFICATIONTABLE_H 

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"

//-----------------------------------------------------------------------------
// stores informations about notifications
//-----------------------------------------------------------------------------
typedef struct ahl_tNotification_tag
{
   tBool                bOccupied;     
   tU16                 u16AppID;
   tBool                bNotification;
   tU16                 u16CmdCounter;   // Zuordnungsnummer(wird vom Server 
                                         // transparent durchgereicht)
   tU16					   u16RegisterID;
   tU16                 u16SubID;
   tU8                  u8Act;  
   ahl_tNotification_tag    *pNext;

} ahl_tNotification;

typedef struct ahl_tFunction_tag
{
    tU16                u16FuncID;
    ahl_tNotification_tag   *pFirst;
} ahl_tFunction;


//------------------------------------------------------------------------------
// class definition:
// stores notification information 
//------------------------------------------------------------------------------
class ahl_tclNotificationTable 
{
private:
    ahl_tFunction     *_pFuncArray;
    ahl_tNotification *_pNotArray;
    tU16               _u16FuncArraySize;
    tU16               _u16NotArraySize;
   tBool               _bIsArrayInternal;

   tVoid vEnlargeNotificationArray(tVoid);
   tVoid vEnlargeFunctionArray(tVoid);
   tVoid vInit(tVoid);
   // forbiggen to be used
   ahl_tclNotificationTable& operator=(const ahl_tclNotificationTable& right); //lint !e1704 prio3 reviewed: intention to forbid using of operator
   ahl_tclNotificationTable(const ahl_tclNotificationTable& that); //lint !e1704 prio3 reviewed: intention to forbid using of constructor

public:
   ahl_tclNotificationTable( ahl_tFunction     *pF, tU16 u16FuncArraySize,
                             ahl_tNotification *pN, tU16 u16NotArraySize   );
   
   ahl_tclNotificationTable(tU16 u16FuncArraySize = 4); // default constructor create arrys on its own

   virtual ~ahl_tclNotificationTable();
   
   ahl_tNotification* poGetNotificationList(tU16 u16FuncID);
   
   
   tBool bAddNotification(tU16 u16FuncID, tU16 u16AppID, tU16 u16RegisterID,
                          tBool bNotification, tU16 u16CmdCounter, 
                          tU16 u16SubID = AMT_C_U16_DEFAULT_NULL, 
                          tU8  u8Act = 0);

   tBool bRemoveNotification(tU16 u16FuncID, tU16 u16AppID, tU16 u16RegisterID,
                             tBool bNotification, tU16 u16CmdCounter,
                             tU16 u16SubID = AMT_C_U16_DEFAULT_NULL);

   tBool bRemoveAllEntriesWithRegID(tU16 u16RegID);

   tVoid vTraceTable(tU16 u16ClassID) const;

   // this values control increasing and maximum values
   // don't change if not required
   tU16 u16EnlrgFunc;
   tU16 u16EnlrgNot;
   tU16 u16FuncMax;
   tU16 u16NotMax; 
};


#endif // AHL_NOTIFICATIONTABLE_H

// ---------------------------------------------------------------------------
// Example
// ---------------------------------------------------------------------------
/*
   --------------------------------------------------------------------
   ahl_tFunction             FuncArray[20];
   ahl_tNotification         NotArray[50];
   ahl_tclNotificationTable  NotTable( FuncArray, 20, NotArray,  50  ); 
   ahl_tNotification         *pNot;

   
   NotTable.bAddNotification(100, 1, 0, 0);
   NotTable.bAddNotification(100, 2, 0, 0);
    
   NotTable.bAddNotification(200, 1, 0, 0);
   NotTable.bAddNotification(200, 2, 0, 0);
   NotTable.bAddNotification(200, 3, 0, 0);
   NotTable.bAddNotification(200, 4, 0, 0);
   NotTable.bAddNotification(200, 5, 0, 0);

   NotTable.bRemoveNotification(200, 3, 0, 0);

   for(pNot=NotTable.poGetNotificationList(200); pNot; pNot=pNot->pNext)
   {
       printf("Application %d\n", pNot->u16AppID);
   }
   ----------------------------------------------------------------------

   Output:
   Application 1
   Application 2
   Application 4
   Application 5
*/
