//*******************************************************************
//* FILE:         ahl_Lock.cpp
//*
//* SW-COMPONENT: Application Help Library
//*
//* DESCRIPTION:  This file implements the lock class.
//*
//* AUTHOR:       CM-CR/EES4-Grosse Pawig
//*
//* COPYRIGHT:    (c) 2002 Blaupunkt GmbH
//*
//* HISTORY:
//* 03.09.2002 CM-CR/EES4-Grosse Pawig
//*            Changed generated lock name
//* 02.07.2002 CM-CR/EES4-Grosse Pawig
//*            Initial Revision
//*******************************************************************

// ahl_Lock
#include "ahl_Lock.h"
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


// Class ahl_tclLock 


ahl_tclLock::ahl_tclLock()
  : m_hSemaphore(OSAL_C_INVALID_HANDLE)
{
   m_szName[EN_MAX_LEN-1] = '\0';
}



tBool ahl_tclLock::bInit ()
{
   if (m_hSemaphore == OSAL_C_INVALID_HANDLE)
   {
      (tVoid) OSALUTIL_s32NPrintFormat((tS8*)m_szName, EN_MAX_LEN, "ahl_Lock::%p",
                               (void *)(this));

      if (OSAL_s32SemaphoreCreate(m_szName, &m_hSemaphore, 1) != OSAL_OK)
      {
         m_hSemaphore = OSAL_C_INVALID_HANDLE;
      }
   }
   return (m_hSemaphore != OSAL_C_INVALID_HANDLE);
}

tBool ahl_tclLock::bLock ()
{
   tBool bSuccess = FALSE;

   if ((m_hSemaphore != OSAL_C_INVALID_HANDLE) &&
       (OSAL_s32SemaphoreWait(m_hSemaphore, OSAL_C_TIMEOUT_FOREVER) == OSAL_OK))
   {
      bSuccess = TRUE;
   }
   return bSuccess;
}

tBool ahl_tclLock::bUnlock ()
{
   tBool bSuccess = FALSE;

   if ((m_hSemaphore != OSAL_C_INVALID_HANDLE) &&
       (OSAL_s32SemaphorePost(m_hSemaphore) == OSAL_OK))
   {
      bSuccess = TRUE;
   }
   return bSuccess;
}

tBool ahl_tclLock::bDestroy ()
{
   tBool bSuccess = TRUE;

   if (m_hSemaphore != OSAL_C_INVALID_HANDLE)
   {
      if ((OSAL_s32SemaphoreClose(m_hSemaphore) == OSAL_OK) &&
          (OSAL_s32SemaphoreDelete(m_szName) == OSAL_OK))
      {
         m_hSemaphore = OSAL_C_INVALID_HANDLE;
      }
      else
      {
         bSuccess = FALSE;
      }
   }
   return bSuccess;
}

/*
 * $Log:   //hi230124/projects/Vasco/swnavi/archives/components/ahl/ahl_Lock.cpp-arc  $
 * 
 *    Rev 1.4   21 Mar 2003 13:51:02   GGS2HI
 * Adaptions for new system_types.h
 */
