#include "ahl_List.h"


tS32 ahl_tclComparator::s32Compare( tVoid* pv1, tVoid* pv2 )
{
   ahl_tclComparator* poActComparator = this;
   tS32 s32RetVal = 0;
   do 
   {
      s32RetVal = poActComparator->s32ConcreteCompareVoid(pv1, pv2);
      if(0 == s32RetVal)
      {
         //As comparison is equal, proceed with next possible comparison.
         poActComparator = poActComparator->_poNextComparator;
      }
      else
      {
         //No more comparison required.
         break;
      }
   } while (NULL != poActComparator);

   return s32RetVal;   
}


//##ModelId=415AA5350196
ahl_tclU16List::ahl_tclU16List()
{
   u16Size = 0;
   prActEntry = (rListEntry*)NULL;
   prBottomElement = (rListEntry*)NULL;
   prHeadElement = (rListEntry*)NULL;
}

//##ModelId=415AA53501B5
ahl_tclU16List::~ahl_tclU16List()
{
   rListEntry* prElement;
   while( prBottomElement )
   {
      prElement = prBottomElement->prNextListEntry;
      OSAL_DELETE prBottomElement;
      prBottomElement = prElement;
   }
}

//##ModelId=415AA53501C5
ahl_tclU16List::ahl_tclU16List(const ahl_tclU16List &roRight)
{
   *this = roRight;
}

//##ModelId=415AA5350222
const ahl_tclU16List & ahl_tclU16List::operator=(const ahl_tclU16List &roRight)
{
   if (this == &roRight)
   {
      return *this;
   }
   else
   {
      rListEntry* prElement;
      while( prBottomElement )
      {
         prElement = prBottomElement->prNextListEntry;
         OSAL_DELETE prBottomElement;
         prBottomElement = prElement;
      }
      u16Size = 0;
      prHeadElement = (rListEntry*)NULL;

      prElement = roRight.prBottomElement;
      prActEntry = roRight.prActEntry;
      while(prElement != NULL)
      {
         bAppend(prElement->pvObject);
         prElement = prElement->prNextListEntry;
      }
   }

   return *this;
}

//##ModelId=415AA5350280
tBool ahl_tclU16List::operator==(const ahl_tclU16List &roRight)
{
   if( u16Size != roRight.u16Size )
   {
      return FALSE;
   }

   rListEntry* prElementListLeft = prBottomElement;
   rListEntry* prElementListRight = roRight.prBottomElement;
   while( prElementListLeft )
   {
      if(
      prElementListLeft->pvObject !=
      prElementListRight->pvObject
      )
      {
         return FALSE;
      }
      prElementListLeft = prElementListLeft->prNextListEntry;
      if( prElementListRight != NULL )
      {
         prElementListRight = prElementListRight->prNextListEntry;
      }
      else
      {
         return FALSE;
      }
   }
   return TRUE;
}

//##ModelId=415AA53502EE
const ahl_tclU16List& ahl_tclU16List::operator += (const ahl_tclU16List &roRight)
{
   if (this == &roRight)
   {
      return *this;
   }
   else
   {
      rListEntry* prElement = roRight.prBottomElement;

      while(prElement != NULL)
      {
         bAppend(prElement->pvObject);
         prElement = prElement->prNextListEntry;
      }
   }

   return *this;
}

//##ModelId=415AA53700FA
ahl_tclU16List::rListEntry* ahl_tclU16List::prCreateNewEntry(tVoid *poObj )
{
   rListEntry * prListEntry = OSAL_NEW rListEntry;
   if (prListEntry != NULL)
   {
      prListEntry->prNextListEntry = (rListEntry*) NULL;
      prListEntry->pvObject = poObj;
   }
   return prListEntry;
};

//##ModelId=415AA53701A5
ahl_tclU16List::rListEntry* ahl_tclU16List::prFindListEntry(const tVoid *poObj ) const
{
   rListEntry* prElement = prBottomElement;

   while(prElement != NULL)
   {
      if( poObj == prElement->pvObject )
      {
         return prElement;
      }
      else
      {
         prElement = prElement->prNextListEntry;
      }
   }
   return NULL;
}

//##ModelId=415AA535035B
tBool ahl_tclU16List::bAppend(tVoid *poObj)
{

   if (poObj != 0)
   {
      if( prHeadElement != NULL )
      {
         rListEntry* prElement = prFindListEntry( poObj );

         if(prElement != NULL)
         {
            return FALSE;
         }

         prElement = prHeadElement;
         prHeadElement = prCreateNewEntry( poObj );
         prElement->prNextListEntry = prHeadElement;
      }
      else
      {
         prBottomElement = prCreateNewEntry( poObj );
         prHeadElement = prBottomElement;
      }

      prActEntry = prBottomElement;

      ++u16Size;

      return TRUE;
   }
   else
   {
      return FALSE;
   }
}

//##ModelId=415AA53503C8
tBool ahl_tclU16List::bAddAsFirst(tVoid *poObj)
{
   if (poObj != 0)
   {
      if( prHeadElement != NULL )
      {
         rListEntry* prElement = prFindListEntry( poObj );

         if(prElement != NULL)
         {
            return FALSE;
         }

         prElement = prCreateNewEntry( poObj );
         prElement->prNextListEntry = prBottomElement;
         prBottomElement = prElement;
      }
      else
      {
         prBottomElement = prCreateNewEntry( poObj );;
         prHeadElement = prBottomElement;
      }

      prActEntry = prBottomElement;

      ++u16Size;

      return TRUE;
   }
   else
   {
      return FALSE;
   }
}

//##ModelId=415AA53600BB
tVoid ahl_tclU16List::vRemoveFirstEntry()
{
   if (prBottomElement != NULL)
   {
      rListEntry *prTmp = prBottomElement;
      prBottomElement = prBottomElement->prNextListEntry;
      OSAL_DELETE prTmp;

      prActEntry = prBottomElement;

      if(prBottomElement == NULL)
      {
         prHeadElement = (rListEntry*) NULL;
      }

      --u16Size;
   }
}

//##ModelId=415AA536004E
tBool ahl_tclU16List::bRemove(const tVoid *poObj)
{
  rListEntry   *prTmp;

  if( (poObj == NULL) || (prBottomElement == NULL) )
    return FALSE;

  if( poObj == prBottomElement->pvObject )
  {
    prTmp = prBottomElement;
    prBottomElement = prBottomElement->prNextListEntry;
    OSAL_DELETE prTmp;

    prActEntry = prBottomElement;
    if(prBottomElement == NULL)
    {
       prHeadElement = (rListEntry*) NULL;
    }
  }
  else
  {
    rListEntry* prElement = prBottomElement;

    while((prElement->prNextListEntry != NULL) && (poObj != prElement->prNextListEntry->pvObject))
    {
       prElement = prElement->prNextListEntry;
    }

    if(prElement->prNextListEntry != NULL)
    {
       prTmp = prElement->prNextListEntry;
       prElement->prNextListEntry = prElement->prNextListEntry->prNextListEntry;

       OSAL_DELETE prTmp;

       if(prElement->prNextListEntry == NULL)
       {
          prHeadElement = prElement;
       }
    }
    else
    {
       return FALSE;
    }

  }

  --u16Size;

  return TRUE;
}

//##ModelId=415AA53600EA
tVoid* ahl_tclU16List::pvGetFirst() const
{
  tVoid *RetObj = NULL;
  if( prBottomElement )
  {
    RetObj = prBottomElement->pvObject;
  }
  return RetObj;
}

//##ModelId=415AA5360119
tVoid* ahl_tclU16List::pvGetLast() const
{
  tVoid *RetObj = NULL;
  if( prHeadElement )
  {
    RetObj = prHeadElement->pvObject;
  }
  return RetObj;
}

//##ModelId=415AA53602FD
tBool ahl_tclU16List::bSetActEntry(const tVoid *poObj ) const
{
   rListEntry *prElement = prFindListEntry( poObj );
   if(prElement != NULL)
   {
      prActEntry = prElement;
      return TRUE;
   }
   return FALSE;
}

//##ModelId=415AA53603B9
tVoid *ahl_tclU16List::pvReplaceEntry(tU16 u16Index, tVoid *pvNewObj)
{
   tVoid *pvOldObject = NULL;

   if(u16Index < u16Size)
   {
      rListEntry* prNewElement = prFindListEntry(pvNewObj);

      if (prNewElement == NULL)
         // NewObj doesn't exist already in list
      {

         rListEntry* prElement = prBottomElement;

         tUInt nI = 0;
         while((prElement != NULL) && nI != u16Size)
         {
            if( nI == u16Index )
            {
               prActEntry = prElement;
               break;
            }
            prElement = prElement->prNextListEntry;
            ++nI;
         }

         if (prActEntry != NULL)
         {
            pvOldObject = prActEntry->pvObject;
            prActEntry->pvObject = pvNewObj;
         }
      }
   }

   return pvOldObject;
}

//##ModelId=415AA76301B5
tU16 ahl_tclU16List::u16InsertEntryBefore(tU16 u16Index, tVoid *pvNewObj)
{
   if(u16Index < u16Size && pvNewObj != 0)
   {
      rListEntry* prNewElement = prFindListEntry(pvNewObj);

      if (prNewElement == NULL)
         // NewObj doesn't exist already in list
      {
         rListEntry* prElement = prBottomElement;
         rListEntry* prPrevElement = 0;

         // search the corresponding index
         tUInt nI = 0;
         while((prElement != NULL) && nI != u16Size)
         {
            if( nI == u16Index )
            {
               prActEntry = prElement;
               break;
            }
            prPrevElement = prElement;
            prElement = prElement->prNextListEntry;
            ++nI;
         }

         if (prPrevElement != 0)
         {
            prElement = prCreateNewEntry(pvNewObj);

            prElement->prNextListEntry = prPrevElement->prNextListEntry;
            prPrevElement->prNextListEntry = prElement;

            ++u16Size;

            return --nI;
         }
         else
         {
            if (bAddAsFirst(pvNewObj))
            {
               return 0;
            }
         }
      }
   }
   else if (pvNewObj != 0)
   {
      if (bAppend(pvNewObj))
      {
         return u16Size - 1;
      }
   }

   return 0xFFFF;
}

tVoid ahl_tclU16List::vSwitchElements(rListEntry *prFirst, rListEntry *prSecond)
{
   if (prFirst != 0 && prSecond != 0)
   {
      tVoid *prTemp = prFirst->pvObject;
      prFirst->pvObject = prSecond->pvObject;
      prSecond->pvObject = prTemp;
   }
}

tVoid ahl_tclU16List::vMoveNextElementAfter(rListEntry *prDest, rListEntry *prSource)
{
   if (prDest != 0 && prSource != 0 && prDest != prSource && prSource->prNextListEntry != 0)
   {
      // the entry which will be replaced
      rListEntry *prDestNext = prDest->prNextListEntry;
      // the entry after the cut
      rListEntry *prLast = prSource->prNextListEntry->prNextListEntry;
      // replace the entry
      prDest->prNextListEntry = prSource->prNextListEntry;
      // reset bottom if necessary
      if (prDestNext == prBottomElement)
         // this is possible if an anchor pointing to the list was passed
         // in order to also exchange the first list element
      {
         prBottomElement = prDest->prNextListEntry;
      }

      // concatenate the list after the inserted element
      prDest->prNextListEntry->prNextListEntry = prDestNext;
      // close the wound
      prSource->prNextListEntry = prLast;

      // reset head if necessary
      if(prSource->prNextListEntry == NULL)
      {
         prHeadElement = prSource;
      }
   }
}

//##ModelId=415AA53602BF
tVoid* ahl_tclU16List::pvGetActEntry() const
{
   if(prActEntry != 0)
   {
      return prActEntry->pvObject;
   }
   else
   {
      return 0;
   }
}

//##ModelId=415AA5360196
tVoid* ahl_tclU16List::pvGetSequential() const
{
   tVoid *RetObj = 0;
   if( prActEntry ) {
      RetObj = prActEntry->pvObject;
      prActEntry = prActEntry->prNextListEntry;
   }
   return RetObj;
}

//##ModelId=415AA53601D4
tVoid* ahl_tclU16List::pvGetByIndex(tU16 u16Index ) const
{
   if( u16Index < u16Size )
   {

      rListEntry* prElement = prBottomElement;

      tUInt nI = 0;
      while((prElement != NULL) && nI != u16Size)
      {
         if( nI == u16Index )
         {
            prActEntry = prElement;
            return( prElement->pvObject );
         }
         prElement = prElement->prNextListEntry;
         ++nI;
      }
   }
   return (tVoid*)0;
}

tVoid ahl_tclU16List::vInsertSortList( ahl_tclComparator &rfoComparator )
{
   rListEntry *prRun = prBottomElement;
   rListEntry rFrontOfList;
   rFrontOfList.prNextListEntry = prBottomElement;

   if (prRun == 0)
   {
      return;
   }

   while (prRun->prNextListEntry != 0)
   {
      if (rfoComparator.s32Compare(prRun->pvObject,prRun->prNextListEntry->pvObject) < 0)
      {
         prRun = prRun->prNextListEntry;
         continue;
      }

      rListEntry *prInsertPlace = &rFrontOfList;
      while (prInsertPlace != prRun)
      {
         //if (prRun->prNextListEntry.pvObject < prInsertPlace->prNextListEntry->pvObject)
         if (rfoComparator.s32Compare(prRun->prNextListEntry->pvObject, 
            prInsertPlace->prNextListEntry->pvObject) 
            < 0)
         {
            break;
         }

         prInsertPlace = prInsertPlace->prNextListEntry;
      }

      vMoveNextElementAfter(prInsertPlace,prRun);

      if (prInsertPlace == prRun)
      {
         prRun = prRun->prNextListEntry;
      }
   }
}

tVoid ahl_tclU16List::vInsertSortParallelList( ahl_tclComparator &rfoComparator, ahl_tclU16List &rfoExtList )
{
   if (u16GetSize() != rfoExtList.u16GetSize())
   {
      // no sorting if lists don't have the same size
      return;
   }

   rListEntry *prRun = prBottomElement;
   rListEntry *prExtRun = rfoExtList.prBottomElement;
   rListEntry rFrontOfList;
   rListEntry rFrontOfExtList;
   rFrontOfList.prNextListEntry = prBottomElement;
   rFrontOfExtList.prNextListEntry = rfoExtList.prBottomElement;

   if (prRun == 0)
   {
      return;
   }

   while (prRun->prNextListEntry != 0)
   {
      if (rfoComparator.s32Compare(prRun->pvObject,prRun->prNextListEntry->pvObject) < 0)
      {
         prRun = prRun->prNextListEntry;
         prExtRun = prExtRun->prNextListEntry;
         continue;
      }

      rListEntry *prInsertPlace = &rFrontOfList;
      rListEntry *prExtInsertPlace = &rFrontOfExtList;
      while (prInsertPlace != prRun)
      {
         //if (prRun->prNextListEntry.pvObject < prInsertPlace->prNextListEntry->pvObject)
         if (rfoComparator.s32Compare(prRun->prNextListEntry->pvObject, 
            prInsertPlace->prNextListEntry->pvObject) 
            < 0)
         {
            break;
         }

         prInsertPlace = prInsertPlace->prNextListEntry;
         prExtInsertPlace = prExtInsertPlace->prNextListEntry;
      }

      vMoveNextElementAfter(prInsertPlace,prRun);
      rfoExtList.vMoveNextElementAfter(prExtInsertPlace,prExtRun);

      if (prInsertPlace == prRun)
      {
         prRun = prRun->prNextListEntry;
         prExtRun = prExtRun->prNextListEntry;
      }
   }
}

//##ModelId=415AC1870000
ahl_tclList::ahl_tclList()
{
}

//##ModelId=415AC187000F
ahl_tclList::~ahl_tclList()
{
}

//##ModelId=415AC18701C5
tBool ahl_tclList::bAppend(tVoid *poObj)
{

   if (poObj != 0 && _oList.u16GetSize() < 0xFF)
   {
      return _oList.bAppend(poObj);
   }
   else
   {
      return FALSE;
   }
}

//##ModelId=415AC1870222
tBool ahl_tclList::bAddAsFirst(tVoid *poObj)
{
   if (poObj != 0 && _oList.u16GetSize() < 0xFF)
   {
      return _oList.bAddAsFirst(poObj);
   }
   else
   {
      return FALSE;
   }
}
