/*****************************************************************************
 *
 *   Projekt                : PROFI/DCAG33
 *   Dateiname              : crc_calc.h
 *   Original-Autor         : Richter
 *   Erstellungsdatum       : 10.02.2000
 *   Letzte Aenderung durch : Richter
 *   Letzte Aenderung am    : $16.02.00$
 *   Version                : $3$
 *
 *   Code-Review durch      : Unruh
 *   Code-Review am         : 25.02.2000
 *
 *
 *   (C) 1998  debis Systemhaus Information Security Services GmbH
 *             Rabinstrasse 8
 *             D-53111 Bonn
 *
 *****************************************************************************
 *
 *   Kurzbeschreibung
 *   ================
 *
 *  Die Funktionen crc_calc*() berechnen aus einem Datenstrom
 *   die 32-Bit-CRC-Summe. Die Berechnung erfolgt mit Hilfe einer 32-Bit-
 *   Tabelle, welche auf den 16-Bit-High-Teil bzw. -Low-Teil aufgesplittet
 *  worden ist.
 *   Folgende Randbedingungen sind zur Generierung der Tabelle festgelegt
 *  worden:
 *
 *      Name   : "CRC-32"
 *      Breite : 32 Bit
 *      Poly   : 04C11DB7
 *      RefIn  : True        (Reflexion des Input-Bytes)
 *      RefOut : True        (Reflexion der CRC-Summe vor dem XORieren)
 *
 *****************************************************************************
 *
 *   Aenderungen
 *   ===========
 *
 *   Log
 *
 ****************************************************************************/
#ifndef AHL_CRC_H
#define AHL_CRC_H 

#ifdef __cplusplus
extern "C" {
#endif

/* Includedateien ----------------------------------------------------------*/

#define OSAL_S_IMPORT_INTERFACE_TYPES
#include "osal_if.h"

/* Makros ------------------------------------------------------------------*/

/* Typdefinitionen ---------------------------------------------------------*/

/* Konstanten --------------------------------------------------------------*/

/* Globale Variablen -------------------------------------------------------*/

// 2x16-Bit-Tabellen
extern tU16 ahl_gaCrcTable_High[256];
extern tU16 ahl_gaCrcTable_Low[256];

/* Funktionsdefinitionen ---------------------------------------------------*/

// Berechnung der 32-Bit-CRC-Summe mit 16bit-Variablen
extern int ahl_calc_crc(const tUChar* pBlk_Adr,
                     tU32 blk_len,
                     tU16* nCrc32High,
                     tU16* nCrc32Low );

// Berechnung der 32-Bit-CRC-Summe mit 32bit-Variable fr CRC
extern int ahl_calc_crc_32(const tUChar* pBlk_Adr,
                        tU32 nBlk_Len,
                        tU32* pnCrc32 );

// Berechnung der 32-Bit-CRC-Summe mit 32bit-Variable fr CRC
extern int ahl_calc_crc_MBFS(const tChar* pFileName,
                          tU32* pnFileLength,
                          tU32* pnCrc32 );




#ifdef __cplusplus
}
#endif


/****************************************************************************
* FILE                      [ $RCSfile: crc_calc.h,v $ ]
* ---------------------------------------------------------------------------
* GENERAL :
* $Header:   //hi230124/projects/Vasco/swnavi/archives/components/ahl/ahl_Crc.h-arc   1.0   Sep 05 2003 10:26:46   PEC2HI  $
* ---------------------------------------------------------------------------
* HISTORY
* REV.  DATE        TIME                   AUTHOR
* COMMENT
* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
* $Revision:   1.0  $  $Date:   Sep 05 2003 10:26:46  $  $Author:   PEC2HI  $
* $Log:   //hi230124/projects/Vasco/swnavi/archives/components/ahl/ahl_Crc.h-arc  $
 * 
 *    Rev 1.0   Sep 05 2003 10:26:46   PEC2HI
 * Initial revision.
 * 
 *    Rev 1.0   Sep 27 2002 07:39:48   SZW2HI
 * Initial revision.
 * 
 *    Rev 1.0   Sep 26 2002 14:29:44   SZW2HI
 * Initial revision.
 * 
 *    Rev 1.0   23 Aug 2002 12:40:46   rao2hi
 * Initial revision.
* Revision 2.0  2002/08/05 09:14:51  kan2hi
* Change of Revision
*
* Revision 1.1.1.1  2002/08/05 08:09:37  kan2hi
* no message
*
* Revision 1.1  2002/06/13 12:54:52  kan2hi
* Newly added PC-SW for IRom Loader and Test-Access
*
* Revision 1.1  2001/07/03 14:15:41  KAN2HI
* New TM-Function for CRC32 calculation added
*
****************************************************************************/



#endif // AHL_CRC_H

