/************************************************************************
* FILE:          ahl_BaseObject.h
* PROJECT:       none
* SW-COMPONENT:  AHL
*----------------------------------------------------------------------
*
* DESCRIPTION: 
*              
*----------------------------------------------------------------------
*
* AUTHOR:  ESE-Neumann  (jn82hi)
*          TMS-Kempen   (kmr2hi)
*          TMS-Jentsch  (jhr2hi)           
*
* COPYRIGHT:    (c) 2008 Robert Bosch GmbH, Hildesheim
*
* HISTORY:      
*************************************************************************/

#ifndef _AHL_BASEOBJECTONETHREAD_H_
#define _AHL_BASEOBJECTONETHREAD_H_

/* Inclusion of OSAL Interface */
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

/* use AIL template */
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"

/* use Application Help Library */
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#include "ahl_ccaExtensionInternal.h"

class ahl_tclBaseOneThreadApp;

class ahl_tclBaseOneThreadObject : public ahl_tclBaseWork
{
public:
    ahl_tclBaseOneThreadObject(ahl_tclBaseOneThreadApp*  poMainAppl, tU16 u16ServiceID) : _poMainAppl(poMainAppl), _u16ServiceID(u16ServiceID)  {};

    inline tU16 u16GetServiceID() const { return _u16ServiceID; };
    virtual tVoid vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState) = 0;
    virtual tVoid vOnNewAppStateNotify(tU32 /*u32OldAppState*/, tU32 /*u32AppState*/) {};
    virtual tVoid vOnServiceState( tU16 u16ServiceId, tU16 u16ServerId, tU16 u16RegisterId, tU8  u8ServiceState, tU16 u16SubId) = 0;
    virtual tBool bGetServiceVersion (tU16 /*u16ServiceID*/, tU16 &/*rfu16MajorVersion*/, tU16 &/*rfu16MinorVersion*/, tU16 &/*rfu16PatchVersion*/) { return FALSE; };
    virtual tVoid vMyDispatchMessage(amt_tclServiceData* pServiceDataMessage) = 0;
    virtual tVoid vOnAsyncRegisterConf (tU16 /*u16RegisterId*/, tU16 /*u16ServerAppId*/, tU16 /*u16ServiceId*/, tU16 /*u16TargetSubId*/) {};
    virtual tVoid vOnAsyncRegisterConfExt (tU16 /*u16RegisterId*/, tU16 /*u16ServerAppId*/, tU16 /*u16ServiceId*/, tU16 /*u16TargetSubId*/, tU8 /*u8AsyncRegisterConfStatus*/) {};
    virtual tBool bOnAcceptNewRegister (tU16 /*u16ServiceId*/, tU16 /*u16ClientAppId*/, tU16 /*u16ClientSubId*/, tU16* /*pu16RegisterId*/) { return FALSE;};
    virtual tVoid vOnUnregister (tU16 /*u16ServiceId*/, tU16 /*u16RegisterId*/) {};
    virtual tVoid vRemoveRegistration() = 0;
    virtual tVoid vOnLoopback(tU16 /* u16ServiceID */, amt_tclServiceData* /* poMessage */) {};
    virtual tVoid vOnLoopback(tU16 /* u16ServiceID */, amt_tclBaseMessage* /* poMessage */) {};
    virtual tVoid vTraceInternalState(TR_tenTraceLevel enLevel) const = 0;
    virtual tBool bIsTargetFor(tU16 u16ServiceId, tU16 u16AppId, tU16 u16RegisterId, tU16 u16AppSubId) const = 0;
protected:
   ahl_tclBaseOneThreadApp* _poMainAppl;
   tU16                     _u16ServiceID;

   /* this function is a helper to filter trace from the specific app, clienthandler, service */
   virtual tBool bTraceClassFilter(tU16 u16Level) const = 0;

private:
   ahl_tclBaseOneThreadObject();//lint !e1704 Info 1704 , eliminating lint warnings the way of Lars.

};


#endif /* _AHL_BASECLIENTONETHREAD_H_ */
