#ifndef __cUtf8String_H_
#define __cUtf8String_H_

typedef tU32   cUtf8StringIter;

class cUtf8StringBase 
{
  protected:
   tU16  _wUtf8StringLen;
   tU8  *_pUtf8String;
  public:
   cUtf8StringBase();
   cUtf8StringBase(const tU8 *sUTF8Text);
   virtual ~cUtf8StringBase();
   virtual void vAssign(const tU8 *sUTF8Text, tU32 nBufferSize=0);
   // service
   tBool bIsEmpty () const;
   bool  bIsEqual (const cUtf8StringBase * pString) const;
   bool  bIsEqual (const tU8 * pubCStr) const;

   tBool bCheckValid () const;
   tU16  wGetLength () const;
   tU32  u32GetLength () const;

   tU16  wGetNumberOfCharacters () const;
   tU32  u32GetNumberOfCharacters () const;

   tChar *Duplicate (const tChar * pcstring, tU16 uwLen) const;

   // Unicode support
   tU32  GetCharCode (const cUtf8StringIter iter) const;
   tU16  encode16bitChars (const tU16 * pUTF16_string, char * pDestBuffer, tU16 uwDestBufferBytes) const;

   // get   
   const tU8 * pubGetCStr () const;
   const tU8 * c_str () const;

   tS32 s32ToInteger() const;

   // iterators
   cUtf8StringIter itBegin () const;
   cUtf8StringIter itEnd () const;
   cUtf8StringIter itNext (const cUtf8StringIter iter) const;
   cUtf8StringIter itPrevious (const cUtf8StringIter iter) const;
   // search
   cUtf8StringIter itStringSearchChar(const tU8* szSearchChar ) const;
   cUtf8StringIter itStringSearchChar(const cUtf8StringBase & oSearch ) const;
   const tU8* szStringSearchChar(const tU8* szSearchChar ) const;
};

class cUtf8String : public cUtf8StringBase
{
  private:
   tU16  _wUtf8AllocSize;
   tU16  _wDynAllocatedSize;
  public:
   cUtf8String();
   virtual ~cUtf8String();
   tU8* AllocMem(tU32 nAllocBufferSize);
   void vInit (tU8 * pubBuffer, tU16 uwBufferSize);
   virtual void vAssign(const tU8 *sUTF8Text, tU32 nBufferSize=0);
   void vClear ();
   void vSetCStr (const tU8 * pubCStr);
   void vSet16bitStr (const tU16 * puw16BStr);
   void vAppendCStr (const tU8 * pubCStr);
   void vAppendChar (tU32 ulwChar);
   void vAppendUtf8Sequence (const tU8 * pubUtf8Seq, tU32 ulwNumOfBytes);
   void vAppendChars (const tU8 * pubUtf8Seq, tU32 ulwNumOfChars);
   void vInsert (const cUtf8StringIter itPosition, const cUtf8String * pString);
   void vDeleteCharacter (cUtf8StringIter itPosition);
   tBool bFixString (tU8 * pubUtf8Seq) const;
   tBool bFixString ();

   void vDeleteLastCharacter ();
   tS32 s32NPrintFormat(tCString coszFormat, ... );
   tS32 s32VarNPrintFormat( tCString coszFormat, va_list argptr );
   // search
   cUtf8StringIter itFindChar (tU32 ulwChar, cUtf8StringIter iter) const;

};

#endif
