/* --DO NOT PROTECT THIS FILE AGAINST DOUBLE INCLUDE !!! */
/************************************************************* +IHDR * .IA *

 .DATEI                [ math_if.h       ]

 .BESCHREIBUNG

  ---General Information to the Component Maintainer

     Please remind that a modification of an interface can cause some trouble
     to the components which import the interface. The interface file may only
     export files from the component or another interface file.

 ---COMPONENT INTERFACE(S)

     Interface: GENERIC
                access to generic math functions

     Interface: GEOMETRICTYPES
                provides geometric types (length, angle, speed and combined units)
                
     Interface: GEOMETRICTYPECONV
                access to functions for converting geometric types
                
     Interface: GEOMETRICUTILS
                access to functions for converting geometric types
                
 .COPYRIGHT            [ (c) 2002 Robert Bosch GmbH, Hildesheim ]
 .AUTOR                [ J. Arnold ]

 * $Log:   //hi230124/projects/Vasco/swnavi/archives/components/interfaces/math_if.h-arc  $
 * 
 *    Rev 1.4   19 Feb 2009 10:10:07   WFK2HI
 * MT-Interface added
 *
 *    Rev 1.3   23 Oct 2002 14:28:02   VOA2HI
 * Matrix-Interface added
 * 
 *    Rev 1.2   15 Aug 2002 14:30:16   ArnoldJoerg
 * std::pair for ..GEOMETRICUTILS
 * 
 *    Rev 1.1   07 Jun 2002 14:02:08   ArnoldJoerg
 * optimized
 * 
 *    Rev 1.0   07 Jun 2002 13:49:58   ArnoldJoerg
 * Initial revision.

 .HISTORIE

  Datum    | Name          Modifikation
 ----------|---------------------------------------------------------------
  04.06.02 | CM-DI/ESA1-An new
************************************************************** -IHDR * .IE */

#if (                                                    \
      defined MATH_S_IMPORT_INTERFACE_GENERIC            \
      ||                                                 \
      defined MATH_S_IMPORT_INTERFACE_GEOMETRICTYPES     \
      ||                                                 \
      defined MATH_S_IMPORT_INTERFACE_GEOMETRICTYPECONV  \
      ||                                                 \
      defined MATH_S_IMPORT_INTERFACE_GEOMETRICUTILS     \
      ||                                                 \
      defined MATH_S_IMPORT_INTERFACE_INTERPOL           \
      ||                                                 \
      defined MATH_S_IMPORT_INTERFACE_MATRIX             \
      ||                                                 \
      defined MATH_S_IMPORT_INTERFACE_POLYGON            \
      ||                                                 \
      defined MATH_S_IMPORT_INTERFACE_MATRIX_UTILS       \
      ||                                                 \
      defined MATH_S_IMPORT_INTERFACE_HALF_FLOAT         \
    )


/* external includes needed for all interfaces */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


/* resolve the dependecy inside of this interface */

#ifdef MATH_S_IMPORT_INTERFACE_GEOMETRICUTILS
#define MATH_S_IMPORT_INTERFACE_GEOMETRICTYPES
#endif // MATH_S_IMPORT_INTERFACE_GEOMETRICUTILS

#ifdef MATH_S_IMPORT_INTERFACE_GEOMETRICTYPECONV
#define MATH_S_IMPORT_INTERFACE_GEOMETRICTYPES
#endif // MATH_S_IMPORT_INTERFACE_GEOMETRICTYPECONV



/* 
     Interface:   GENERIC
     Description: generic math functions
*/
#ifdef MATH_S_IMPORT_INTERFACE_GENERIC
/* --Protection against double include of the interface. */
#ifndef MATH_S_ALREADY_INCLUDE_GENERIC
#define MATH_S_ALREADY_INCLUDE_GENERIC
/* --Includes. */
#include "../math/mathgeneric.h"
#endif /* --MATH_S_ALREADY_INCLUDE_GENERIC */
#endif /* --MATH_S_IMPORT_INTERFACE_GENERIC */


/* 
     Interface:   GEOMETRICTYPES
     Description: geometric types  (length, angle, speed and combined units)
*/
#ifdef MATH_S_IMPORT_INTERFACE_GEOMETRICTYPES
/* --Protection against double include of the interface. */
#ifndef MATH_S_ALREADY_INCLUDE_GEOMETRICTYPES
#define MATH_S_ALREADY_INCLUDE_GEOMETRICTYPES
/* --Includes. */
#include "../math/mathgeometrictype.h"
#include "../math/length.h"
#include "../math/angle.h"
#include "../math/vector3d.h"
#endif /* --MATH_S_ALREADY_INCLUDE_GEOMETRICTYPES */
#endif /* --MATH_S_IMPORT_INTERFACE_GEOMETRICTYPES */


/* 
     Interface:   GEOMETRICTYPECONV
     Description: functions to convert specific geometric types
*/
#ifdef MATH_S_IMPORT_INTERFACE_GEOMETRICTYPECONV
/* --Protection against double include of the interface. */
#ifndef MATH_S_ALREADY_INCLUDE_GEOMETRICTYPECONV
#define MATH_S_ALREADY_INCLUDE_GEOMETRICTYPECONV
/* --Includes. */
#include "../math/mathgeometricconv.h"
#endif /* --MATH_S_ALREADY_INCLUDE_GEOMETRICTYPECONV */
#endif /* --MATH_S_IMPORT_INTERFACE_GEOMETRICTYPECONV */

/* 
     Interface:   GEOMETRICUTILS
     Description: helpful functions to use with geometric types
*/
#ifdef MATH_S_IMPORT_INTERFACE_GEOMETRICUTILS
/* --Protection against double include of the interface. */
#ifndef MATH_S_ALREADY_INCLUDE_GEOMETRICUTILS
#define MATH_S_ALREADY_INCLUDE_GEOMETRICUTILS
/* --Includes. */
#include <utility> // for std::pair<>
#include "../math/mathgeometricutil.h"
#endif /* --MATH_S_ALREADY_INCLUDE_GEOMETRICUTILS */
#endif /* --MATH_S_IMPORT_INTERFACE_GEOMETRICUTILS */

/*
     Interface: INTERPOL
     Description: access to the interpolation functions
*/
#ifdef MATH_S_IMPORT_INTERFACE_INTERPOL
/* --Protection against double include of the interface. */
#ifndef MATH_S_ALREADY_INCLUDE_INTERPOL
#define MATH_S_ALREADY_INCLUDE_INTERPOL
/* --Includes. */
#include "../math/interpol.h"
#endif /* --MATH_S_ALREADY_INCLUDE_INTERPOL */
#endif /* --MATH_S_IMPORT_INTERFACE_INTERPOL */

/*
     Interface: MATRIX
     Description: access to the matrix functions
*/
#ifdef MATH_S_IMPORT_INTERFACE_MATRIX
/* --Protection against double include of the interface. */
#ifndef MATH_S_ALREADY_INCLUDE_MATRIX
#define MATH_S_ALREADY_INCLUDE_MATRIX
/* --Includes. */
#include "../math/Matrix.h"
#endif /* --MATH_S_ALREADY_INCLUDE_MATRIX */
#endif /* --MATH_S_IMPORT_INTERFACE_MATRIX */

/*
     Interface: POLYGON
     Description: access to the polygon functions
*/
#ifdef MATH_S_IMPORT_INTERFACE_POLYGON
/* --Protection against double include of the interface. */
#ifndef MATH_S_ALREADY_INCLUDE_POLYGON
#define MATH_S_ALREADY_INCLUDE_POLYGON
/* --Includes. */
#include "../math/math_polygon.h"
#endif /* --MATH_S_ALREADY_INCLUDE_POLYGON*/
#endif /* --MATH_S_IMPORT_INTERFACE_POLYGON */


#ifdef MATH_S_IMPORT_INTERFACE_MATRIX_UTILS
#ifndef MATH_S_ALREADY_INCLUDE_MATRIX_UTILS
#define MATH_S_ALREADY_INCLUDE_MATRIX_UTILS
#include "../math/MatrixUtils/TypeDepFunctions.h"
#include "../math/MatrixUtils/vector2.h"
#include "../math/MatrixUtils/vector3.h"
#include "../math/MatrixUtils/vector4.h"
#include "../math/MatrixUtils/matrix2x2.h"
#include "../math/MatrixUtils/matrix3x3.h"
#include "../math/MatrixUtils/matrix4x4.h"
#endif /* MATH_S_ALREADY_INCLUDE_MATRIX_UTILS */
#endif /* --MATH_S_IMPORT_INTERFACE_MATRIX_UTILS */


#ifdef MATH_S_IMPORT_INTERFACE_HALF_FLOAT
#ifndef MATH_S_ALREADY_INCLUDE_HALF_FLOAT
#define MATH_S_ALREADY_INCLUDE_HALF_FLOAT
#include "../math/MatrixUtils/HalfFloat.h"
#endif /* MATH_S_ALREADY_INCLUDE_HALF_FLOAT */
#endif /* --MATH_S_IMPORT_INTERFACE_HALF_FLOAT */

#else
#pragma message ( "You have to define an interface for the component: MATH." ) 
#endif
