/*****************************************************************************
* FILE:         veda_ServiceVehicleIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: vehicledata
* Template:     ServiceIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here service handler specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/



// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

// veda_tclServiceVehicleIfIncludes: user specific code start
#include "I_veda_appl_handler.h"
#include "veda_AppMain_Trace.h"
#include "Iveda_ClientVcan.h"
// veda_tclServiceVehicleIfIncludes: user specific code end

#include "veda_ServiceVehicleIf.h"
#include "I_veda_ServiceVehicle.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VEHICLEDATA_SERVER_VEHICLE
#include "trcGenProj/Header/veda_ServiceVehicleIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: veda_tclServiceVehicleIf::
*             veda_tclServiceVehicleIf(veda_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
veda_tclServiceVehicleIf::veda_tclServiceVehicleIf(veda_tclAppMain* poMainAppl) : 
Iveda_tclServiceVehicleIf(poMainAppl)
{
   ETG_TRACE_USR4(("veda_tclServiceVehicleIf() entered."));
   _poServerRef = OSAL_NULL;

   // veda_tclServiceVehicleIfConstructor: user specific code start
   _poClientVcan = OSAL_NULL;
   u8RearGearCanStatus = 0;
   u8RearGearPinStatus = 0;
   // veda_tclServiceVehicleIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: veda_tclServiceVehicleIf::
*             ~veda_tclServiceVehicleIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
veda_tclServiceVehicleIf::~veda_tclServiceVehicleIf(tVoid)
{
   ETG_TRACE_USR4(("~veda_tclServiceVehicleIf() entered."));
   _poServerRef = OSAL_NULL;
   
   // veda_tclServiceVehicleIfDestructor: user specific code start
   _poClientVcan = OSAL_NULL;
   // veda_tclServiceVehicleIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid veda_tclServiceVehicleIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'veda_ServiceVehicleIf.h':
*     Add forward declaration:
*         class Ivehicledata_tclObject2Get;
*
*     Add declaration of object reference:
*         Ivehicledata_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ivehicledata_tclObject2Get*>(_cpoMain->getHandler("Ivehicledata_tclObject2Get"));
*     VEHICLE_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid veda_tclServiceVehicleIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("veda_tclServiceVehicleIf::vGetReferences() entered."));

   _poServerRef = dynamic_cast<Iveda_tclServiceVehicle*>(_cpoMain->getHandler("Iveda_tclServiceVehicle"));

   VEDA_NULL_POINTER_CHECK(_poServerRef);

   _poServerRef->vSetCallbackIf(this);

   //set callback interface

   // veda_tclServiceVehicleIfvGetReferences: user specific code start
   _poClientVcan = dynamic_cast<I_veda_tclClientVcan*>(_cpoMain->getHandler("I_veda_tclClientVcan"));
   VEDA_NULL_POINTER_CHECK(_poClientVcan);
   // veda_tclServiceVehicleIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid veda_tclServiceVehicleIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid veda_tclServiceVehicleIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("veda_tclServiceVehicleIf::vStartCommunication() entered."));
   // veda_tclServiceVehicleIfvStartCommunication: user specific code start
   // veda_tclServiceVehicleIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid veda_tclServiceVehicleIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid veda_tclServiceVehicleIf::vHandleMessage(veda_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("veda_tclServiceVehicleIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(veda_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // veda_tclServiceVehicleIfvHandleMessage: user specific code start
   // veda_tclServiceVehicleIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid veda_tclServiceVehicleIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid veda_tclServiceVehicleIf::vHandleTraceMessage(const tUChar* puchData)
{
   VEDA_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("veda_tclServiceVehicleIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // veda_tclServiceVehicleIfvHandleTraceMessage: user specific code start
   switch(u32MsgCode)
   {
       case VEHICLEDATA_VEDA_TRIGGER_METERLANGUAGESYNC:
       {
          veda_tclBaseIf::TMsg pMsg;
          (tVoid)memset((tVoid*)&pMsg, OSAL_NULL, sizeof(pMsg));
          pMsg.eCmd = veda_tclBaseIf::eLanguageSyncMenuRequested;
          strncpy(pMsg.strClassName, "veda_tclLanguageHandler", sizeof("veda_tclLanguageHandler"));
          pMsg.u.u8Data = static_cast<tU8>(puchData[3]);
          
          _cpoMain->theServer()->vPostInternalMessage(&pMsg);
       }
       break;
       
       default:
       break;
   }
   // veda_tclServiceVehicleIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid veda_tclServiceVehicleIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid veda_tclServiceVehicleIf::vTraceInfo()
{
   // veda_tclServiceVehicleIfvTraceInfo: user specific code start
   // veda_tclServiceVehicleIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid veda_tclServiceVehicleIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid veda_tclServiceVehicleIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("veda_tclServiceVehicleIf::onServiceAvailable() entered."));

   // veda_tclServiceVehicleIfvOnServiceAvailable: user specific code start
   // veda_tclServiceVehicleIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid veda_tclServiceVehicleIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid veda_tclServiceVehicleIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("veda_tclServiceVehicleIf::onServiceUnavailable() entered."));

   // veda_tclServiceVehicleIfvOnServiceUnavailable: user specific code start
   // veda_tclServiceVehicleIfvOnServiceUnavailable: user specific code end
}

tBool veda_tclServiceVehicleIf::onDistanceUnitSet(vehicle_fi_tcl_e8_Vehicle_DistanceUnit e8DistanceUnit, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onDistanceUnitSet: user specific code start
   (tVoid) u16ErrorCode;  // for lint
   (tVoid) bPropertyChanged; // for lint
   _bResult = TRUE;
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
   bPropertyChanged = FALSE;
   tU8 u8Unit = 0;
   
   // Send it to V-CAN Unit Display
   if ( e8DistanceUnit.enType == vehicle_fi_tcl_e8_Vehicle_DistanceUnit::FI_EN_MILES )
   {
      u8Unit = 2;
   }
   else if ( e8DistanceUnit.enType == vehicle_fi_tcl_e8_Vehicle_DistanceUnit::FI_EN_KM )
   {
      u8Unit = 1;
   }
   else
   {}

   VEDA_NULL_POINTER_CHECK_VAL(_poClientVcan);
   _poClientVcan->vSendUnitDistanceDisplayRequestUpdate(u8Unit);
#else
   (tVoid) e8DistanceUnit; // for lint
#endif
   // onDistanceUnitSet: user specific code end
   return _bResult;
}
tBool veda_tclServiceVehicleIf::onFuelConsumptionUnitSet(vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit e8FuelConsumpUnit, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onFuelConsumptionUnitSet: user specific code start
   (tVoid) u16ErrorCode;  // for lint
   (tVoid) bPropertyChanged; // for lint
   (tVoid) e8FuelConsumpUnit; // for lint
   _bResult = TRUE;
   // onFuelConsumptionUnitSet: user specific code end
   return _bResult;
}
tBool veda_tclServiceVehicleIf::onTemperatureUnitSet(vehicle_fi_tcl_e8_Vehicle_TemperatureUnit e8TempUnit, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onTemperatureUnitSet: user specific code start
   (tVoid) u16ErrorCode;  // for lint
   (tVoid) bPropertyChanged; // for lint
   (tVoid) e8TempUnit; // for lint
   _bResult = TRUE;
   // onTemperatureUnitSet: user specific code end
   return _bResult;
}
tBool veda_tclServiceVehicleIf::onLanguageSyncSourceSet(vehicle_fi_tcl_e8_Language_SourceId Language, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onLanguageSyncSourceSet: user specific code start
   (tVoid) bPropertyChanged;
   (tVoid) u16ErrorCode;

   _bResult = TRUE;

   veda_tclBaseIf::TMsg pMsg;
   (tVoid)memset((tVoid*)&pMsg, OSAL_NULL, sizeof(pMsg));
   pMsg.eCmd = veda_tclBaseIf::eSetLanguageSyncSource;
   strncpy(pMsg.strClassName, "veda_tclLanguageHandler", sizeof("veda_tclLanguageHandler"));
   pMsg.u.u8Data = (tU8) Language.enType;

   _cpoMain->theServer()->vPostInternalMessage(&pMsg);
   // onLanguageSyncSourceSet: user specific code end
   return _bResult;
}
tBool veda_tclServiceVehicleIf::onTirePressureSettingSet(vehicle_fi_tcl_e8_Vehicle_TirePressureInfo TirePressureRequestInfo, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onTirePressureSettingSet: user specific code start
   
   _bResult = TRUE;
   
    veda_tclBaseIf::TMsg pMsg;
	(tVoid)memset((tVoid*)&pMsg, OSAL_NULL, sizeof(pMsg));
	pMsg.eCmd = veda_tclBaseIf::eTirePressureSet;
	strncpy(pMsg.strClassName, "veda_tclClientVcan", sizeof("veda_tclClientVcan"));
	pMsg.u.u8Data = static_cast<tU8>(TirePressureRequestInfo.enType);

	_cpoMain->theServer()->vPostInternalMessage(&pMsg);
   
   // onTirePressureSettingSet: user specific code end
   return _bResult;
}

tVoid veda_tclServiceVehicleIf::onSetLanguageMStart(vehicle_fi_tcl_e8_Language_SourceId SourceId, vehicle_fi_tcl_e8_Language_Code Language) {

   // onSetLanguageMStart: user specific code start
   ETG_TRACE_USR4(("veda_tclServiceVehicleIf::onSetLanguageMStart() entered SourceId %u Language %u.", ETG_ENUM(VEDA_E8_LANGUAGE_SOURCEID, SourceId.enType), ETG_ENUM(VEDA_E8_LANGUAGE_CODE, Language.enType)));
// for Renault Scope 2.1 the Meter Language Information is received from V-CAN
//#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
   if ( vehicle_fi_tcl_e8_Language_SourceId::FI_EN_METER != SourceId.enType )
   {
//#endif
      veda_tclBaseIf::TMsg pMsg;
      (tVoid)memset((tVoid*)&pMsg, OSAL_NULL, sizeof(pMsg));
      pMsg.eCmd = veda_tclBaseIf::eSetLanguage;
      strncpy(pMsg.strClassName, "veda_tclLanguageHandler", sizeof("veda_tclLanguageHandler"));
      pMsg.u.au8Data[0] = static_cast<tU8>(SourceId.enType);
      pMsg.u.au8Data[1] = static_cast<tU8>(Language.enType);
      
      _cpoMain->theServer()->vPostInternalMessage(&pMsg);
//#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
   }
//#endif
   // onSetLanguageMStart: user specific code end
}
tVoid veda_tclServiceVehicleIf::onRequestMeterLanguageSyncMStart(vehicle_fi_tcl_e8_Meter_SyncRequest RequestId) {

   // onRequestMeterLanguageSyncMStart: user specific code start
   veda_tclBaseIf::TMsg pMsg;
   (tVoid)memset((tVoid*)&pMsg, OSAL_NULL, sizeof(pMsg));
   pMsg.eCmd = veda_tclBaseIf::eLanguageSyncMenuRequested;
   strncpy(pMsg.strClassName, "veda_tclLanguageHandler", sizeof("veda_tclLanguageHandler"));
   pMsg.u.u8Data = static_cast<tU8>(RequestId.enType);

   _cpoMain->theServer()->vPostInternalMessage(&pMsg);
   // onRequestMeterLanguageSyncMStart: user specific code end
}
tVoid veda_tclServiceVehicleIf::onCSMEngineeringDataMStart() {

   // onCSMEngineeringDataMStart: user specific code start
   char cClassName[] = "veda_tclApplHandler";
   _cpoMain->theServer()->vPostMsgGetCSMEnggData(cClassName, 0);
   // onCSMEngineeringDataMStart: user specific code end
}
tVoid veda_tclServiceVehicleIf::onSetOSPAlertsStatusMStart(tBool OSPAlert, tBool DangerousAreaAlert) {

   // onSetOSPAlertsStatusMStart: user specific code start
   (tVoid) OSPAlert;
   (tVoid) DangerousAreaAlert;
   // onSetOSPAlertsStatusMStart: user specific code end
}
//Cam1ManAct
tVoid veda_tclServiceVehicleIf::onCam1ManActMStart(tU8 RequestId){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendCam1ManActUpdate(RequestId);
	sendCam1ManActMResult(RequestId);
}
//Cam2ManAct
tVoid veda_tclServiceVehicleIf::onCam2ManActMStart(tU8 RequestId){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendCam2ManActUpdate(RequestId);
	sendCam2ManActMResult(RequestId);
}
//Cam3ManAct
tVoid veda_tclServiceVehicleIf::onCam3ManActMStart(tU8 RequestId){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendCam3ManActUpdate(RequestId);
	sendCam3ManActMResult(RequestId);
}
//Cam4ManAct
tVoid veda_tclServiceVehicleIf::onCam4ManActMStart(tU8 RequestId){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendCam4ManActUpdate(RequestId);
	sendCam4ManActMResult(RequestId);
}
//Cam5ManAct
tVoid veda_tclServiceVehicleIf::onCam5ManActMStart(tU8 RequestId){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendCam5ManActUpdate(RequestId);
	sendCam5ManActMResult(RequestId);
}
//Cam6ManAct
tVoid veda_tclServiceVehicleIf::onCam6ManActMStart(tU8 RequestId){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendCam6ManActUpdate(RequestId);
	sendCam6ManActMResult(RequestId);
}
//Cam7ManAct
tVoid veda_tclServiceVehicleIf::onCam7ManActMStart(tU8 RequestId){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendCam7ManActUpdate(RequestId);
	sendCam7ManActMResult(RequestId);
}
//Cam8ManAct
tVoid veda_tclServiceVehicleIf::onCam8ManActMStart(tU8 RequestId){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendCam8ManActUpdate(RequestId);
	sendCam8ManActMResult(RequestId);
}

//Cam9ManAct
tVoid veda_tclServiceVehicleIf::onCam9ManActMStart(tU8 RequestId){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendCam9ManActUpdate(RequestId);
	sendCam9ManActMResult(RequestId);
}

//Cam10ManAct
tVoid veda_tclServiceVehicleIf::onCam10ManActMStart(tU8 RequestId){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendCam10ManActUpdate(RequestId);
	sendCam10ManActMResult(RequestId);
}
//Cam11ManAct
tVoid veda_tclServiceVehicleIf::onCam11ManActMStart(tU8 RequestId){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendCam11ManActUpdate(RequestId);
	sendCam11ManActMResult(RequestId);
}

//Cam12ManAct
tVoid veda_tclServiceVehicleIf::onCam12ManActMStart(tU8 RequestId){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendCam12ManActUpdate(RequestId);
	sendCam12ManActMResult(RequestId);
}


//Cam13ManAct
tVoid veda_tclServiceVehicleIf::onCam13ManActMStart(tU8 RequestId){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendCam13ManActUpdate(RequestId);
	sendCam13ManActMResult(RequestId);
}

//Cam14ManAct
tVoid veda_tclServiceVehicleIf::onCam14ManActMStart(tU8 RequestId){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendCam14ManActUpdate(RequestId);
	sendCam14ManActMResult(RequestId);
}
//Cam15ManAct
tVoid veda_tclServiceVehicleIf::onCam15ManActMStart(tU8 RequestId){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendCam15ManActUpdate(RequestId);
	sendCam15ManActMResult(RequestId);
}
//Cam16ManAct
tVoid veda_tclServiceVehicleIf::onCam16ManActMStart(tU8 RequestId){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendCam16ManActUpdate(RequestId);
	sendCam16ManActMResult(RequestId);
}
//Cam17ManAct
tVoid veda_tclServiceVehicleIf::onCam17ManActMStart(tU8 RequestId){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendCam17ManActUpdate(RequestId);
	sendCam17ManActMResult(RequestId);
}
//PrivacyResetAck
tVoid veda_tclServiceVehicleIf::onPrivacyResetAckMStart(tU8 RequestId){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendPrivacyResetAckUpdate(RequestId);
	sendPrivacyResetAckMResult(RequestId);
}
//DispCamCls
tVoid veda_tclServiceVehicleIf::onDispCamClsMStart(tU8 RequestId){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendDispCamClsUpdate(RequestId);
	sendDispCamClsMResult(RequestId);
}

//PhoneBTLinkStatus
tVoid veda_tclServiceVehicleIf::onPhoneBTLinkStatusMStart(tU8 BTLinkStatus){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendPhoneBTLinkStatusUpdate(BTLinkStatus);
	sendPhoneBTLinkStatusMResult(BTLinkStatus);
}

//PhoneBookSyncstatus
tVoid veda_tclServiceVehicleIf::onPhoneBookSyncstatusMStart(tU8 PhoneBookSyncStatusValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendPhoneBookSyncstatusUpdate(PhoneBookSyncStatusValue);
	sendPhoneBookSyncstatusMResult(PhoneBookSyncStatusValue);
}
//CallHistorySyncStatus
tVoid veda_tclServiceVehicleIf::onCallHistorySyncStatusMStart(tU8 CallHistorySyncStatusValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendCallHistorySyncStatusUpdate(CallHistorySyncStatusValue);
	sendCallHistorySyncStatusMResult(CallHistorySyncStatusValue);
}

//PhoneStatusRoaming
tVoid veda_tclServiceVehicleIf::onPhoneStatusRoamingMStart(tU8 PhoneStatusRoamingValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendPhoneStatusRoamingUpdate(PhoneStatusRoamingValue);
	sendPhoneStatusRoamingMResult(PhoneStatusRoamingValue);
}


//CallDuration
tVoid veda_tclServiceVehicleIf::onCallDurationMStart(tU16 CallDurationValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendCallDurationUpdate(CallDurationValue);
	sendCallDurationMResult(CallDurationValue);
}
//GSMSignalStrength
tVoid veda_tclServiceVehicleIf::onGSMSignalStrengthMStart(tU8 GSMSignalStrengthValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendGSMSignalStrengthUpdate(GSMSignalStrengthValue);
	sendGSMSignalStrengthMResult(GSMSignalStrengthValue);
}

//PhoneCallStatus
tVoid veda_tclServiceVehicleIf::onPhoneCallStatusMStart(tU8 CallStatusValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendPhoneCallStatusUpdate(CallStatusValue);
	sendPhoneCallStatusMResult(CallStatusValue);
}

//PhoneBatteryLevelStatus
tVoid veda_tclServiceVehicleIf::onPhoneBatteryLevelStatusMStart(tU8 PhoneBatteryLevelStatusValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendPhoneBatteryLevelStatusUpdate(PhoneBatteryLevelStatusValue);
	sendPhoneBatteryLevelStatusMResult(PhoneBatteryLevelStatusValue);
}

//DeviceStatusWifiAvailable
tVoid veda_tclServiceVehicleIf::onDeviceStatusWifiAvailableMStart(tU8 DeviceStatusWifiStatus){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendDeviceStatusWifiAvailableUpdate(DeviceStatusWifiStatus);
	sendDeviceStatusWifiAvailableMResult(DeviceStatusWifiStatus);
}
//MediaStatusAudioSource
tVoid veda_tclServiceVehicleIf::onMediaStatusAudioSourceMStart(tU8 AudioSource){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendMediaStatusAudioSourceUpdate(AudioSource);
	sendMediaStatusAudioSourceMResult(AudioSource);
}

//PhoneAvailableStatus
tVoid veda_tclServiceVehicleIf::onPhoneAvailableStatusMStart(tU8 PhoneAvailableStatusValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendPhoneAvailableStatusUpdate(PhoneAvailableStatusValue);
	sendPhoneAvailableStatusMResult(PhoneAvailableStatusValue);
}


//PhoneVRAvailable
tVoid veda_tclServiceVehicleIf::onPhoneVRAvailableMStart(tU8 PhoneVRAvailableValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendPhoneVRAvailableUpdate(PhoneVRAvailableValue);
	sendPhoneVRAvailableMResult(PhoneVRAvailableValue);
}


//DeviceStatusBTStatus
tVoid veda_tclServiceVehicleIf::onDeviceStatusBTStatusMStart(tU8 DeviceStatusBTStatusValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendDeviceStatusBTStatusUpdate(DeviceStatusBTStatusValue);
	sendDeviceStatusBTStatusMResult(DeviceStatusBTStatusValue);
}

//DeviceStatusBluetoothAvail
tVoid veda_tclServiceVehicleIf::onDeviceStatusBluetoothAvailMStart(tU8 DeviceStatusBluetoothAvailValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendDeviceStatusBluetoothAvailUpdate(DeviceStatusBluetoothAvailValue);
	sendDeviceStatusBluetoothAvailMResult(DeviceStatusBluetoothAvailValue);
}

//Req_DeviceInfo
tVoid veda_tclServiceVehicleIf::onReq_DeviceInfoMStart(tU8 Req_DeviceInfoValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	/////////////////////
//	Req_DeviceInfoValue=0x12;
	_poClientVcan -> vSendReq_DeviceInfoUpdate(Req_DeviceInfoValue);
	sendReq_DeviceInfoMResult(Req_DeviceInfoValue);
}

//MediaStatusVolume
tVoid veda_tclServiceVehicleIf::onMediaStatusVolumeMStart(tU8 volume){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendMediaStatusVolumeUpdate(volume);
	sendMediaStatusVolumeMResult(volume);
}


//CabinMediaStatusAudioSource
tVoid veda_tclServiceVehicleIf::onCabinMediaStatusAudioSourceMStart(tU8 CabinAudioSource){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendCabinMediaStatusAudioSourceUpdate(CabinAudioSource);
	sendCabinMediaStatusAudioSourceMResult(CabinAudioSource);
}

//CabinMediaStatusTunerBand
tVoid veda_tclServiceVehicleIf::onCabinMediaStatusTunerBandMStart(tU8 CabinMediaStatusTunerBandValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendCabinMediaStatusTunerBandUpdate(CabinMediaStatusTunerBandValue);
	sendCabinMediaStatusTunerBandMResult(CabinMediaStatusTunerBandValue);
}
//CabinMediaStatusVolume
tVoid veda_tclServiceVehicleIf::onCabinMediaStatusVolumeMStart(tU8 CabinVolume){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendCabinMediaStatusVolumeUpdate(CabinVolume);
	sendCabinMediaStatusVolumeMResult(CabinVolume);
}
//MediaStatusMuteStatus
tVoid veda_tclServiceVehicleIf::onMediaStatusMuteStatusMStart(tU8 MediaStatusMuteValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendMediaStatusMuteStatusUpdate(MediaStatusMuteValue);
	sendMediaStatusMuteStatusMResult(MediaStatusMuteValue);
}
//CabinMediaStatusMuteStatus
tVoid veda_tclServiceVehicleIf::onCabinMediaStatusMuteStatusMStart(tU8 CabinMediaStatusMuteValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendCabinMediaStatusMuteStatusUpdate(CabinMediaStatusMuteValue);
	sendCabinMediaStatusMuteStatusMResult(CabinMediaStatusMuteValue);
}
//MediaStatusPlayStatus
tVoid veda_tclServiceVehicleIf::onMediaStatusPlayStatusMStart(tU8 MediaStatusPlayStatusValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendMediaStatusPlayStatusUpdate(MediaStatusPlayStatusValue);
	sendMediaStatusPlayStatusMResult(MediaStatusPlayStatusValue);
}
//MediaStatusMixState
tVoid veda_tclServiceVehicleIf::onMediaStatusMixStateMStart(tU8 MediaStatusMixStateValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendMediaStatusMixStateUpdate(MediaStatusMixStateValue);
	sendMediaStatusMixStateMResult(MediaStatusMixStateValue);
}
//MediaStatusPlaylistMode
tVoid veda_tclServiceVehicleIf::onMediaStatusPlaylistModeMStart(tU8 MediaStatusPlaylistModeValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendMediaStatusPlaylistModeUpdate(MediaStatusPlaylistModeValue);
	sendMediaStatusPlaylistModeMResult(MediaStatusPlaylistModeValue);
}
//MediaStatusTrackTime
tVoid veda_tclServiceVehicleIf::onMediaStatusTrackTimeMStart(tU16 MediaStatusTrackTimeValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendMediaStatusTrackTimeUpdate(MediaStatusTrackTimeValue);
	sendMediaStatusTrackTimeMResult(MediaStatusTrackTimeValue);
}
//MediaStatusCurrTrackNum
tVoid veda_tclServiceVehicleIf::onMediaStatusCurrTrackNumMStart(tU16 MediaStatusCurrTrackNumValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendMediaStatusCurrTrackNumUpdate(MediaStatusCurrTrackNumValue);
	sendMediaStatusCurrTrackNumMResult(MediaStatusCurrTrackNumValue);
}
//DeviceStatusRadioStatus
tVoid veda_tclServiceVehicleIf::onDeviceStatusRadioStatusMStart(tU8 DeviceStatusRadioStatusValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendDeviceStatusRadioStatusUpdate(DeviceStatusRadioStatusValue);
	sendDeviceStatusRadioStatusMResult(DeviceStatusRadioStatusValue);
}
//DeviceStatusDABAvailStatus
tVoid veda_tclServiceVehicleIf::onDeviceStatusDABAvailStatusMStart(tU8 DeviceStatusDABAvailStatusValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendDeviceStatusDABAvailStatusUpdate(DeviceStatusDABAvailStatusValue);
	sendDeviceStatusDABAvailStatusMResult(DeviceStatusDABAvailStatusValue);
}
//DeviceStatusNavData
tVoid veda_tclServiceVehicleIf::onDeviceStatusNavDataMStart(tU8 DeviceStatusNavDataValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendDeviceStatusNavDataUpdate(DeviceStatusNavDataValue);
	sendDeviceStatusNavDataMResult(DeviceStatusNavDataValue);
}
//DeviceStatusUSB1Present
tVoid veda_tclServiceVehicleIf::onDeviceStatusUSB1PresentMStart(tU8 DeviceStatusUSB1PresentValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendDeviceStatusUSB1PresentUpdate(DeviceStatusUSB1PresentValue);
	sendDeviceStatusUSB1PresentMResult(DeviceStatusUSB1PresentValue);
}
//DeviceStatusUSB2Present
tVoid veda_tclServiceVehicleIf::onDeviceStatusUSB2PresentMStart(tU8 DeviceStatusUSB2PresentValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendDeviceStatusUSB2PresentUpdate(DeviceStatusUSB2PresentValue);
	sendDeviceStatusUSB2PresentMResult(DeviceStatusUSB2PresentValue);
}
//DeviceStatusNaviAvail
tVoid veda_tclServiceVehicleIf::onDeviceStatusNaviAvailMStart(tU8 DeviceStatusNaviAvailValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendDeviceStatusNaviAvailUpdate(DeviceStatusNaviAvailValue);
	sendDeviceStatusNaviAvailMResult(DeviceStatusNaviAvailValue);
}
//DeviceStatusUSB1Src
tVoid veda_tclServiceVehicleIf::onDeviceStatusUSB1SrcMStart(tU8 DeviceStatusUSB1SrcValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendDeviceStatusUSB1SrcUpdate(DeviceStatusUSB1SrcValue);
	sendDeviceStatusUSB1SrcMResult(DeviceStatusUSB1SrcValue);
}
//DeviceStatusUSB2Src
tVoid veda_tclServiceVehicleIf::onDeviceStatusUSB2SrcMStart(tU8 DeviceStatusUSB2SrcValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendDeviceStatusUSB2SrcUpdate(DeviceStatusUSB2SrcValue);
	sendDeviceStatusUSB2SrcMResult(DeviceStatusUSB2SrcValue);
}
//DeviceStatusAMFMAvail
tVoid veda_tclServiceVehicleIf::onDeviceStatusAMFMAvailMStart(tU8 DeviceStatusAMFMAvailValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendDeviceStatusAMFMAvailUpdate(DeviceStatusAMFMAvailValue);
	sendDeviceStatusAMFMAvailMResult(DeviceStatusAMFMAvailValue);
}
//MediaStatusSeekStatus
tVoid veda_tclServiceVehicleIf::onMediaStatusSeekStatusMStart(tU8 MediaStatusSeekStatusValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendMediaStatusSeekStatusUpdate(MediaStatusSeekStatusValue);
	sendMediaStatusSeekStatusMResult(MediaStatusSeekStatusValue);
}
//MediaStatusRepeatStatus
tVoid veda_tclServiceVehicleIf::onMediaStatusRepeatStatusMStart(tU8 MediaStatusRepeatStatusValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendMediaStatusRepeatStatusUpdate(MediaStatusRepeatStatusValue);
	sendMediaStatusRepeatStatusMResult(MediaStatusRepeatStatusValue);
}

//MediaStatusDABFMStatus
tVoid veda_tclServiceVehicleIf::onMediaStatusDABFMStatusMStart(tU8 MediaStatusDABFMStatusValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendMediaStatusDABFMStatusUpdate(MediaStatusDABFMStatusValue);
	sendMediaStatusDABFMStatusMResult(MediaStatusDABFMStatusValue);
}
//VehicleNaviLatitude
tVoid veda_tclServiceVehicleIf::onVehicleNaviLatitudeMStart(tU32 VehicleNaviLatitudeValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendVehicleNaviLatitudeUpdate(VehicleNaviLatitudeValue);
	sendVehicleNaviLatitudeMResult(VehicleNaviLatitudeValue);
}
//VehicleNaviLongitude
tVoid veda_tclServiceVehicleIf::onVehicleNaviLongitudeMStart(tU32 VehicleNaviLongitudeValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendVehicleNaviLongitudeUpdate(VehicleNaviLongitudeValue);
	sendVehicleNaviLongitudeMResult(VehicleNaviLongitudeValue);
}
//MediaStatusTREGStatus
tVoid veda_tclServiceVehicleIf::onMediaStatusTREGStatusMStart(tU8 MediaStatusTREGStatusValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendMediaStatusTREGStatusUpdate(MediaStatusTREGStatusValue);
	sendMediaStatusTREGStatusMResult(MediaStatusTREGStatusValue);
}
//MediaStatusTREGRTMStatus
tVoid veda_tclServiceVehicleIf::onMediaStatusTREGRTMStatusMStart(tU8 MediaStatusTREGRTMStatusValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendMediaStatusTREGRTMStatusUpdate(MediaStatusTREGRTMStatusValue);
	sendMediaStatusTREGRTMStatusMResult(MediaStatusTREGRTMStatusValue);
}
//MediaStatusRDSStatus
tVoid veda_tclServiceVehicleIf::onMediaStatusRDSStatusMStart(tU8 MediaStatusRDSStatusValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendMediaStatusRDSStatusUpdate(MediaStatusRDSStatusValue);
	sendMediaStatusRDSStatusMResult(MediaStatusRDSStatusValue);
}
//MediaStatusTAStatus
tVoid veda_tclServiceVehicleIf::onMediaStatusTAStatusMStart(tU8 MediaStatusTAStatusValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendMediaStatusTAStatusUpdate(MediaStatusTAStatusValue);
	sendMediaStatusTAStatusMResult(MediaStatusTAStatusValue);
}
//MediaStatusTPStatus
tVoid veda_tclServiceVehicleIf::onMediaStatusTPStatusMStart(tU8 MediaStatusTPStatusValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendMediaStatusTPStatusUpdate(MediaStatusTPStatusValue);
	sendMediaStatusTPStatusMResult(MediaStatusTPStatusValue);
}
//MediaStatusTunerBandStatus
tVoid veda_tclServiceVehicleIf::onMediaStatusTunerBandStatusMStart(tU8 MediaStatusTunerBandStatusValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendMediaStatusTunerBandStatusUpdate(MediaStatusTunerBandStatusValue);
	sendMediaStatusTunerBandStatusMResult(MediaStatusTunerBandStatusValue);
}
//MediaStatusTunerPresetStatus
tVoid veda_tclServiceVehicleIf::onMediaStatusTunerPresetStatusMStart(tU8 MediaStatusTunerPresetStatusValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendMediaStatusTunerPresetStatusUpdate(MediaStatusTunerPresetStatusValue);
	sendMediaStatusTunerPresetStatusMResult(MediaStatusTunerPresetStatusValue);
}
//HUS_DM1_Status
tVoid veda_tclServiceVehicleIf::onHUS_DM1_StatusMStart(tU64 HUS_DM1_StatusValue){
	VEDA_NULL_POINTER_CHECK(_poClientVcan);
	_poClientVcan -> vSendHUS_DM1_StatusUpdate(HUS_DM1_StatusValue);
	sendHUS_DM1_StatusMResult(HUS_DM1_StatusValue);
}
tVoid veda_tclServiceVehicleIf::sendDistanceUnitStatus(vehicle_fi_tcl_e8_Vehicle_DistanceUnit e8DistanceUnit) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDistanceUnitStatus(e8DistanceUnit);
}

tVoid veda_tclServiceVehicleIf::sendFuelConsumptionUnitStatus(vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit e8FuelConsumpUnit) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendFuelConsumptionUnitStatus(e8FuelConsumpUnit);
}

tVoid veda_tclServiceVehicleIf::sendTemperatureUnitStatus(vehicle_fi_tcl_e8_Vehicle_TemperatureUnit e8TempUnit) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendTemperatureUnitStatus(e8TempUnit);
}

tVoid veda_tclServiceVehicleIf::sendLanguageStatus(vehicle_fi_tcl_e8_Language_Code Language, bpstl::vector<vehicle_fi_tcl_Language_SourceTable, bpstl::allocator<vehicle_fi_tcl_Language_SourceTable> > LangTable) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendLanguageStatus(Language, LangTable);
}

tVoid veda_tclServiceVehicleIf::sendLanguageSyncSourceStatus(vehicle_fi_tcl_e8_Language_SourceId Language) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendLanguageSyncSourceStatus(Language);
}

tVoid veda_tclServiceVehicleIf::sendMeterLanguageKnowledgeStatus(vehicle_fi_tcl_e8_Meter_LangKnowledge State) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendMeterLanguageKnowledgeStatus(State);
}

tVoid veda_tclServiceVehicleIf::sendHandBrakeStatus(vehicle_fi_tcl_e8_Vehicle_HandBrakeStatus e8Status) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendHandBrakeStatus(e8Status);
}

tVoid veda_tclServiceVehicleIf::sendIgnitionStatus(vehicle_fi_tcl_e8_Vehicle_Ignition e8Status) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendIgnitionStatus(e8Status);
}

tVoid veda_tclServiceVehicleIf::sendSpeedStatus(tU16 SpeedValue) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSpeedStatus(SpeedValue);
}

tVoid veda_tclServiceVehicleIf::sendPartialMuteStatus(tU8 PartialMuteValue){
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendPartialMuteStatus(PartialMuteValue);
}

tVoid veda_tclServiceVehicleIf::sendSwivMonAutoOpenStatus(tU8 SwivMonAutoOpenValue){
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSwivMonAutoOpenStatus(SwivMonAutoOpenValue);
}

tVoid veda_tclServiceVehicleIf::sendVehicleDriverDoorOpenStatus(tU8 DriverDoorOpenValue){
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendVehicleDriverDoorOpenStatus(DriverDoorOpenValue);
}

tVoid veda_tclServiceVehicleIf::sendDateModeStatus(tU8 DateModeValue){
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDateModeStatus(DateModeValue);
}

tVoid veda_tclServiceVehicleIf::sendTmModeStatus(tU8 TmModeValue){
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendTmModeStatus(TmModeValue);
}

//camera
tVoid veda_tclServiceVehicleIf::sendActCam1Status(tU8 ActCam1Value){
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendActCam1Status(ActCam1Value);
}

//camera2
tVoid veda_tclServiceVehicleIf::sendActCam2Status(tU8 ActCam2Value){
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendActCam2Status(ActCam2Value);
}
//camera3
tVoid veda_tclServiceVehicleIf::sendActCam3Status(tU8 ActCam3Value){
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendActCam3Status(ActCam3Value);
}
//camera4
tVoid veda_tclServiceVehicleIf::sendActCam4Status(tU8 ActCam4Value){
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendActCam4Status(ActCam4Value);
}
//camera5
tVoid veda_tclServiceVehicleIf::sendActCam5Status(tU8 ActCam5Value){
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendActCam5Status(ActCam5Value);
}
//camera6
tVoid veda_tclServiceVehicleIf::sendActCam6Status(tU8 ActCam6Value){
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendActCam6Status(ActCam6Value);
}
//camera7
tVoid veda_tclServiceVehicleIf::sendActCam7Status(tU8 ActCam7Value){
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendActCam7Status(ActCam7Value);
}
//camsplit
tVoid veda_tclServiceVehicleIf::sendCamSplitQuadStatus(tU16 CamSplitQuadValue){
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCamSplitQuadStatus(CamSplitQuadValue);
}
//MuteDev
tVoid veda_tclServiceVehicleIf::sendMuteDevStatus(tU8 MuteDevStatus){
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendMuteDevStatus(MuteDevStatus);
}
//SysVolt
tVoid veda_tclServiceVehicleIf::sendSysVoltStatus(tU8 SysVoltStatus){
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSysVoltStatus(SysVoltStatus);
}
//ParkingBreakSwitch
tVoid veda_tclServiceVehicleIf::sendParkingBreakSwitchStatus(tU8 ParkingBreakSwitchValue){
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendParkingBreakSwitchStatus(ParkingBreakSwitchValue);
}

//RearCamReq
tVoid veda_tclServiceVehicleIf::sendRearCamReqStatus(tU8 RearCamReqValue){
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendRearCamReqStatus(RearCamReqValue);
}

//VIN
tVoid veda_tclServiceVehicleIf::sendVINStatus(tU32 VINValue){
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendVINStatus(VINValue);
}

//TimeDate
tVoid veda_tclServiceVehicleIf::sendTimeDateStatus(tU64 TimeDateValue){
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendTimeDateStatus(TimeDateValue);
}


//PhoneCall
tVoid veda_tclServiceVehicleIf::sendPhoneCallCmdStatus(tU8 PhoneCallCmdValue){
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendPhoneCallCmdStatus(PhoneCallCmdValue);
}


//PhonePwr Cmd
tVoid veda_tclServiceVehicleIf::sendPhonePwrCmdStatus(tU8 PhonePwrCmdValue){
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendPhonePwrCmdStatus(PhonePwrCmdValue);
}


//RadioPwr Cmd
tVoid veda_tclServiceVehicleIf::sendRadioPwrCmdStatus(tU8 RadioPwrCmdValue){
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendRadioPwrCmdStatus(RadioPwrCmdValue);
}





//Volume Command
tVoid veda_tclServiceVehicleIf::sendVolumeCmdStatus(tU8 VolumeCmdValue) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendVolumeCmdStatus(VolumeCmdValue);
}



//ActCam8
tVoid veda_tclServiceVehicleIf::sendActCam8Status(tU8 ActCam8Value) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendActCam8Status(ActCam8Value);
}

//ActCam9
tVoid veda_tclServiceVehicleIf::sendActCam9Status(tU8 ActCam9Value) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendActCam9Status(ActCam9Value);
}
//ActCam10
tVoid veda_tclServiceVehicleIf::sendActCam10Status(tU8 ActCam10Value) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendActCam10Status(ActCam10Value);
}

//ActCam11
tVoid veda_tclServiceVehicleIf::sendActCam11Status(tU8 ActCam11Value) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendActCam11Status(ActCam11Value);
}

//ActCam12
tVoid veda_tclServiceVehicleIf::sendActCam12Status(tU8 ActCam12Value) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendActCam12Status(ActCam12Value);
}


//ActCam13
tVoid veda_tclServiceVehicleIf::sendActCam13Status(tU8 ActCam13Value) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendActCam13Status(ActCam13Value);
}

//ActCam14
tVoid veda_tclServiceVehicleIf::sendActCam14Status(tU8 ActCam14Value) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendActCam14Status(ActCam14Value);
}

//ActCam15
tVoid veda_tclServiceVehicleIf::sendActCam15Status(tU8 ActCam15Value) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendActCam15Status(ActCam15Value);
}

//ActCam16
tVoid veda_tclServiceVehicleIf::sendActCam16Status(tU8 ActCam16Value) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendActCam16Status(ActCam16Value);
}

//ActCam17
tVoid veda_tclServiceVehicleIf::sendActCam17Status(tU8 ActCam17Value) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendActCam17Status(ActCam17Value);
}

//CabinSource Command
tVoid veda_tclServiceVehicleIf::sendCabinSourceCmdStatus(tU8 CabinSourceCmdValue) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendCabinSourceCmdStatus(CabinSourceCmdValue);
}


//CabinVolume Command
tVoid veda_tclServiceVehicleIf::sendCabinVolumeCmdStatus(tU8 CabinVolumeCmdValue) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendCabinVolumeCmdStatus(CabinVolumeCmdValue);
}


//CabinTunerCommand
tVoid veda_tclServiceVehicleIf::sendCabinTunerCmdStatus(tU8 CabinTunerCmdValue) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendCabinTunerCmdStatus(CabinTunerCmdValue);
}


//CabinTrackCommand
tVoid veda_tclServiceVehicleIf::sendCabinTrackCmdStatus(tU8 CabinTrackCmdValue) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendCabinTrackCmdStatus(CabinTrackCmdValue);
}



//CabinPlaylistCommand
tVoid veda_tclServiceVehicleIf::sendCabinPlaylistCmdStatus(tU8 CabinPlaylistCmdValue) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendCabinPlaylistCmdStatus(CabinPlaylistCmdValue);
}


//Source Command
tVoid veda_tclServiceVehicleIf::sendSourceCmdStatus(tU8 SourceCmdValue) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendSourceCmdStatus(SourceCmdValue);
}



//RCNextBtn Command
tVoid veda_tclServiceVehicleIf::sendRCNextBtnStatus(tU8 RCNextBtnValue) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendRCNextBtnStatus(RCNextBtnValue);
}

//RCPrevBtn Command
tVoid veda_tclServiceVehicleIf::sendRCPrevBtnStatus(tU8 RCPrevBtnValue) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendRCPrevBtnStatus(RCPrevBtnValue);
}


//Track Command
tVoid veda_tclServiceVehicleIf::sendTrackCommandStatus(tU8 TrackCommandValue) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendTrackCommandStatus(TrackCommandValue);
}

//SMARTVR 
tVoid veda_tclServiceVehicleIf::sendSMARTVRStatus(tU8 SMARTVRValue) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
  _poServerRef->sendSMARTVRStatus(SMARTVRValue);
}

//Tuner Command
tVoid veda_tclServiceVehicleIf::sendTunerCommandStatus(tU8 TunerCommandValue) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendTunerCommandStatus(TunerCommandValue);
}
//TA Command
tVoid veda_tclServiceVehicleIf::sendTACommandStatus(tU8 TACommandValue) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendTACommandStatus(TACommandValue);
}

//RDS Command
tVoid veda_tclServiceVehicleIf::sendRDSCommandStatus(tU8 RDSCommandValue) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendRDSCommandStatus(RDSCommandValue);
}

//Voice Cmd Command
tVoid veda_tclServiceVehicleIf::sendVoiceRecgCmdStatus(tU8 VoiceRecgCommandValue) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->sendVoiceRecgCmdStatus(VoiceRecgCommandValue);
}


//SW Version Command
tVoid veda_tclServiceVehicleIf::SendDeviceInfoSWversionStatus(tU32 u32SWversionValue) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->SendDeviceInfoSWversionStatus(u32SWversionValue);
}


//TotalVehDistDiag
tVoid veda_tclServiceVehicleIf::SendTotalVehDistDiagStatus(tU32 u32TotalVehDistDiagValue) {
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->SendTotalVehDistDiagStatus(u32TotalVehDistDiagValue);
}



//CamTxt
tVoid veda_tclServiceVehicleIf::sendCamTxtStatus(tU64 CamTxtValue){
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCamTxtStatus(CamTxtValue);
}

//VIN_64
tVoid veda_tclServiceVehicleIf::sendVIN_64Status(tU64 VIN_64Value){
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendVIN_64Status(VIN_64Value);
}

//PrivacyResetReq
tVoid veda_tclServiceVehicleIf::sendPrivacyResetReqStatus(tU8 PrivacyResetReqValue){
	//just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendPrivacyResetReqStatus(PrivacyResetReqValue);
}

tVoid veda_tclServiceVehicleIf::sendSpeedLimitStatus(tU8 SpeedLimit1, tU8 SpeedLimit2, tU8 Display, vehicle_fi_tcl_e8_Vehicle_DistanceUnit DisplayUnit, tBool OverSpeed, tBool FreeSpeed) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSpeedLimitStatus(SpeedLimit1, SpeedLimit2, Display, DisplayUnit, OverSpeed, FreeSpeed);
}

tVoid veda_tclServiceVehicleIf::sendReverseGearPinStatus(tU8 State) {
    //just forward send request
	u8RearGearPinStatus = State;
	ETG_TRACE_USR4(("veda_tclServiceVehicleIf::sendReverseGearPinStatus() u8RearGearCanStatus as %d u8RearGearPinStatus as %d", u8RearGearCanStatus, u8RearGearPinStatus));
    VEDA_NULL_POINTER_CHECK(_poServerRef);
	if( u8RearGearCanStatus == 1 || u8RearGearPinStatus == 1)
		_poServerRef->sendReverseGearStatus(1);
	else if (u8RearGearPinStatus == 0 && u8RearGearCanStatus == 0)
		_poServerRef->sendReverseGearStatus(0);
	else{}
}

tVoid veda_tclServiceVehicleIf::sendReverseGearCANStatus(tU8 State) {
    //just forward send request
	u8RearGearCanStatus = State;
	ETG_TRACE_USR4(("veda_tclServiceVehicleIf::sendReverseGearCANStatus() u8RearGearCanStatus as %d u8RearGearPinStatus as %d", u8RearGearCanStatus, u8RearGearPinStatus));
    VEDA_NULL_POINTER_CHECK(_poServerRef);
	if(u8RearGearCanStatus == 1 || u8RearGearPinStatus == 1)
		_poServerRef->sendReverseGearStatus(1);
	else if (u8RearGearPinStatus == 0 && u8RearGearCanStatus == 0)
		_poServerRef->sendReverseGearStatus(0);
	else{}
}

tVoid veda_tclServiceVehicleIf::sendSpeedLockStatus(tU8 State) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSpeedLockStatus(State);
}

tVoid veda_tclServiceVehicleIf::sendDrivingStateStatus(tU8 State) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDrivingStateStatus(State);
}

tVoid veda_tclServiceVehicleIf::sendGlobalVehicleWarningStateStatus(vehicle_fi_tcl_e8_Vehicle_WarningState State) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendGlobalVehicleWarningStateStatus(State);
}

tVoid veda_tclServiceVehicleIf::sendVehicleStatesStatus(vehicle_fi_tcl_e8_Vehicle_States State) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendVehicleStatesStatus(State);
}

tVoid veda_tclServiceVehicleIf::sendNetworkStateStatus(tU8 u8BusState_MCAN, tU8 u8BusState_VCAN, tU8 u8MuteState_MCAN, tU8 u8MuteState_VCAN, tBool bBusOff_MCAN, tBool bBusOff_VCAN, tBool bBusOff, tBool bMute_MCAN, tBool bMute_VCAN, std::vector<tU8, std::allocator<tU8> > Listu8AbsentState_ECU, std::vector<tU8, std::allocator<tU8> > Listu8MuteStateMCAN_Channel) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendNetworkStateStatus(u8BusState_MCAN, u8BusState_VCAN, u8MuteState_MCAN, u8MuteState_VCAN, bBusOff_MCAN, bBusOff_VCAN, bBusOff, bMute_MCAN, bMute_VCAN, Listu8AbsentState_ECU, Listu8MuteStateMCAN_Channel);
}

tVoid veda_tclServiceVehicleIf::sendDistanceTotalizerStatus(tU32 DisTotal, tU32 lastValidDisTotal, tU8 Unit, tBool DisTotalStatus) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDistanceTotalizerStatus(DisTotal, lastValidDisTotal, Unit, DisTotalStatus);
}

tVoid veda_tclServiceVehicleIf::sendMileageStatus(tU32 Mileage) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendMileageStatus(Mileage);
}

tVoid veda_tclServiceVehicleIf::sendAvgFuelEconomyStatus(tU16 FuelEcon) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAvgFuelEconomyStatus(FuelEcon);
}

tVoid veda_tclServiceVehicleIf::sendTirePressureSupportStatus(tBool PressureSupport) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendTirePressureSupportStatus(PressureSupport);
}

tVoid veda_tclServiceVehicleIf::sendTPMSResetSupportStatus(vehicle_fi_tcl_e8_Vehicle_TPMSReset TPMSResetInfo) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendTPMSResetSupportStatus(TPMSResetInfo);
}

tVoid veda_tclServiceVehicleIf::sendTirePressureSettingStatus(tU16 SettingPressureFront, tU16 SettingPressureRear) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendTirePressureSettingStatus(SettingPressureFront, SettingPressureRear);
}


//Cam1ManAct
tVoid veda_tclServiceVehicleIf::sendCam1ManActMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCam1ManActMResult(Result);
}

//Cam2ManAct
tVoid veda_tclServiceVehicleIf::sendCam2ManActMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCam2ManActMResult(Result);
}

//Cam3ManAct
tVoid veda_tclServiceVehicleIf::sendCam3ManActMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCam3ManActMResult(Result);
}

//Cam4ManAct
tVoid veda_tclServiceVehicleIf::sendCam4ManActMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCam4ManActMResult(Result);
}

//Cam5ManAct
tVoid veda_tclServiceVehicleIf::sendCam5ManActMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCam5ManActMResult(Result);
}

//Cam6ManAct
tVoid veda_tclServiceVehicleIf::sendCam6ManActMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCam6ManActMResult(Result);
}

//Cam7ManAct
tVoid veda_tclServiceVehicleIf::sendCam7ManActMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCam7ManActMResult(Result);
}

//Cam8ManAct
tVoid veda_tclServiceVehicleIf::sendCam8ManActMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCam8ManActMResult(Result);
}

//Cam9ManAct
tVoid veda_tclServiceVehicleIf::sendCam9ManActMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCam9ManActMResult(Result);
}

//Cam10ManAct
tVoid veda_tclServiceVehicleIf::sendCam10ManActMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCam10ManActMResult(Result);
}

//Cam11ManAct
tVoid veda_tclServiceVehicleIf::sendCam11ManActMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCam11ManActMResult(Result);
}

//Cam12ManAct
tVoid veda_tclServiceVehicleIf::sendCam12ManActMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCam12ManActMResult(Result);
}
//Cam13ManAct
tVoid veda_tclServiceVehicleIf::sendCam13ManActMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCam13ManActMResult(Result);
}

//Cam14ManAct
tVoid veda_tclServiceVehicleIf::sendCam14ManActMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCam14ManActMResult(Result);
}

//Cam15ManAct
tVoid veda_tclServiceVehicleIf::sendCam15ManActMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCam15ManActMResult(Result);
}
//Cam16ManAct
tVoid veda_tclServiceVehicleIf::sendCam16ManActMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCam16ManActMResult(Result);
}
//Cam17ManAct
tVoid veda_tclServiceVehicleIf::sendCam17ManActMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCam17ManActMResult(Result);
}

//PrivacyResetAck
tVoid veda_tclServiceVehicleIf::sendPrivacyResetAckMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendPrivacyResetAckMResult(Result);
}

//DispCamCls
tVoid veda_tclServiceVehicleIf::sendDispCamClsMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDispCamClsMResult(Result);
}

//PhoneBTLinkStatus
tVoid veda_tclServiceVehicleIf::sendPhoneBTLinkStatusMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendPhoneBTLinkStatusMResult(Result);
}
//PhoneBookSyncstatus
tVoid veda_tclServiceVehicleIf::sendPhoneBookSyncstatusMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendPhoneBookSyncstatusMResult(Result);
}
//CallHistorySyncStatus
tVoid veda_tclServiceVehicleIf::sendCallHistorySyncStatusMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCallHistorySyncStatusMResult(Result);
}
//PhoneStatusRoaming
tVoid veda_tclServiceVehicleIf::sendPhoneStatusRoamingMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendPhoneStatusRoamingMResult(Result);
}
//CallDuration
tVoid veda_tclServiceVehicleIf::sendCallDurationMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCallDurationMResult(Result);
}

//GSMSignalStrength
tVoid veda_tclServiceVehicleIf::sendGSMSignalStrengthMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendGSMSignalStrengthMResult(Result);
}
//PhoneCallStatus
tVoid veda_tclServiceVehicleIf::sendPhoneCallStatusMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendPhoneCallStatusMResult(Result);
}
//PhoneBatteryLevelStatus
tVoid veda_tclServiceVehicleIf::sendPhoneBatteryLevelStatusMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendPhoneBatteryLevelStatusMResult(Result);
}

//DeviceStatusWifiAvailable
tVoid veda_tclServiceVehicleIf::sendDeviceStatusWifiAvailableMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDeviceStatusWifiAvailableMResult(Result);
}
//MediaStatusAudioSource
tVoid veda_tclServiceVehicleIf::sendMediaStatusAudioSourceMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendMediaStatusAudioSourceMResult(Result);
}

//PhoneAvailableStatus
tVoid veda_tclServiceVehicleIf::sendPhoneAvailableStatusMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendPhoneAvailableStatusMResult(Result);
}


//PhoneVRAvailable
tVoid veda_tclServiceVehicleIf::sendPhoneVRAvailableMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendPhoneVRAvailableMResult(Result);
}


//DeviceStatusBTStatus
tVoid veda_tclServiceVehicleIf::sendDeviceStatusBTStatusMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDeviceStatusBTStatusMResult(Result);
}
//DeviceStatusBluetoothAvail
tVoid veda_tclServiceVehicleIf::sendDeviceStatusBluetoothAvailMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDeviceStatusBluetoothAvailMResult(Result);
}
//Req_DeviceInfo
tVoid veda_tclServiceVehicleIf::sendReq_DeviceInfoMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendReq_DeviceInfoMResult(Result);
}

//MediaStatusVolume
tVoid veda_tclServiceVehicleIf::sendMediaStatusVolumeMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendMediaStatusVolumeMResult(Result);
}

//CabinMediaStatusAudioSource
tVoid veda_tclServiceVehicleIf::sendCabinMediaStatusAudioSourceMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCabinMediaStatusAudioSourceMResult(Result);
}

//CabinMediaStatusTunerBand
tVoid veda_tclServiceVehicleIf::sendCabinMediaStatusTunerBandMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCabinMediaStatusTunerBandMResult(Result);
}


//CabinMediaStatusVolume
tVoid veda_tclServiceVehicleIf::sendCabinMediaStatusVolumeMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCabinMediaStatusVolumeMResult(Result);
}

//MediaStatusMuteStatus
tVoid veda_tclServiceVehicleIf::sendMediaStatusMuteStatusMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendMediaStatusMuteStatusMResult(Result);
}

//CabinMediaStatusMuteStatus
tVoid veda_tclServiceVehicleIf::sendCabinMediaStatusMuteStatusMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCabinMediaStatusMuteStatusMResult(Result);
}

//MediaStatusPlayStatus
tVoid veda_tclServiceVehicleIf::sendMediaStatusPlayStatusMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendMediaStatusPlayStatusMResult(Result);
}
//MediaStatusMixState
tVoid veda_tclServiceVehicleIf::sendMediaStatusMixStateMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendMediaStatusMixStateMResult(Result);
}
//MediaStatusPlaylistMode
tVoid veda_tclServiceVehicleIf::sendMediaStatusPlaylistModeMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendMediaStatusPlaylistModeMResult(Result);
}
//MediaStatusTrackTime
tVoid veda_tclServiceVehicleIf::sendMediaStatusTrackTimeMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendMediaStatusTrackTimeMResult(Result);
}
//MediaStatusCurrTrackNum
tVoid veda_tclServiceVehicleIf::sendMediaStatusCurrTrackNumMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendMediaStatusCurrTrackNumMResult(Result);
}
//DeviceStatusRadioStatus
tVoid veda_tclServiceVehicleIf::sendDeviceStatusRadioStatusMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDeviceStatusRadioStatusMResult(Result);
}
//DeviceStatusDABAvailStatus
tVoid veda_tclServiceVehicleIf::sendDeviceStatusDABAvailStatusMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDeviceStatusDABAvailStatusMResult(Result);
}
//DeviceStatusNavData
tVoid veda_tclServiceVehicleIf::sendDeviceStatusNavDataMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDeviceStatusNavDataMResult(Result);
}
//DeviceStatusUSB1Present
tVoid veda_tclServiceVehicleIf::sendDeviceStatusUSB1PresentMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDeviceStatusUSB1PresentMResult(Result);
}
//DeviceStatusUSB2Present
tVoid veda_tclServiceVehicleIf::sendDeviceStatusUSB2PresentMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDeviceStatusUSB2PresentMResult(Result);
}
//DeviceStatusNaviAvail
tVoid veda_tclServiceVehicleIf::sendDeviceStatusNaviAvailMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDeviceStatusNaviAvailMResult(Result);
}
//DeviceStatusUSB1Src
tVoid veda_tclServiceVehicleIf::sendDeviceStatusUSB1SrcMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDeviceStatusUSB1SrcMResult(Result);
}
//DeviceStatusUSB2Src
tVoid veda_tclServiceVehicleIf::sendDeviceStatusUSB2SrcMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDeviceStatusUSB2SrcMResult(Result);
}
//DeviceStatusAMFMAvail
tVoid veda_tclServiceVehicleIf::sendDeviceStatusAMFMAvailMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDeviceStatusAMFMAvailMResult(Result);
}
//MediaStatusSeekStatus
tVoid veda_tclServiceVehicleIf::sendMediaStatusSeekStatusMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendMediaStatusSeekStatusMResult(Result);
}
//MediaStatusRepeatStatus
tVoid veda_tclServiceVehicleIf::sendMediaStatusRepeatStatusMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendMediaStatusRepeatStatusMResult(Result);
}

//MediaStatusDABFMStatus
tVoid veda_tclServiceVehicleIf::sendMediaStatusDABFMStatusMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendMediaStatusDABFMStatusMResult(Result);
}

//VehicleNaviLatitude
tVoid veda_tclServiceVehicleIf::sendVehicleNaviLatitudeMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendVehicleNaviLatitudeMResult(Result);
}
//VehicleNaviLongitude
tVoid veda_tclServiceVehicleIf::sendVehicleNaviLongitudeMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendVehicleNaviLongitudeMResult(Result);
}
//MediaStatusTREGStatus
tVoid veda_tclServiceVehicleIf::sendMediaStatusTREGStatusMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendMediaStatusTREGStatusMResult(Result);
}
//MediaStatusTREGRTMStatus
tVoid veda_tclServiceVehicleIf::sendMediaStatusTREGRTMStatusMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendMediaStatusTREGRTMStatusMResult(Result);
}

//MediaStatusRDSStatus
tVoid veda_tclServiceVehicleIf::sendMediaStatusRDSStatusMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendMediaStatusRDSStatusMResult(Result);
}
//MediaStatusTASatus
tVoid veda_tclServiceVehicleIf::sendMediaStatusTAStatusMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendMediaStatusTAStatusMResult(Result);
}
//MediaStatusTPSatus
tVoid veda_tclServiceVehicleIf::sendMediaStatusTPStatusMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendMediaStatusTPStatusMResult(Result);
}
//MediaStatusTunerBandSatus
tVoid veda_tclServiceVehicleIf::sendMediaStatusTunerBandStatusMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendMediaStatusTunerBandStatusMResult(Result);
}
//MediaStatusTunerPresetSatus
tVoid veda_tclServiceVehicleIf::sendMediaStatusTunerPresetStatusMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendMediaStatusTunerPresetStatusMResult(Result);
}

//HUS_DM1_Status
tVoid veda_tclServiceVehicleIf::sendHUS_DM1_StatusMResult(tU8 Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendHUS_DM1_StatusMResult(Result);
}

tVoid veda_tclServiceVehicleIf::sendSetLanguageMResult(tBool Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSetLanguageMResult(Result);
}

tVoid veda_tclServiceVehicleIf::sendRequestMeterLanguageSyncMResult(tBool Result) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendRequestMeterLanguageSyncMResult(Result);
}

tVoid veda_tclServiceVehicleIf::sendCSMEngineeringDataMResult(bpstl::vector<vehicle_fi_tcl_CAN_Message, bpstl::allocator<vehicle_fi_tcl_CAN_Message> > CanMessageList) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendCSMEngineeringDataMResult(CanMessageList);
}

tVoid veda_tclServiceVehicleIf::sendSetOSPAlertsStatusMResult(tBool Status) {
    //just forward send request
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSetOSPAlertsStatusMResult(Status);
}





// veda_tclServiceVehicleIfveda_ServiceVehicleIf: user specific code start
tVoid veda_tclServiceVehicleIf::vUpdateSpeedLimit1(tU8 u8SpeedLimit1) const
{
   VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->vUpdateCANSpeedLimit1(u8SpeedLimit1);
}

tVoid veda_tclServiceVehicleIf::vUpdateSpeedLimit2(tU8 u8SpeedLimit2) const
{
   VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->vUpdateCANSpeedLimit2(u8SpeedLimit2);
}

tVoid veda_tclServiceVehicleIf::vUpdateSpeedLimitDisplay(tU8 u8SpeedLimitDisplay) const
{
   VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->vUpdateCANSpeedLimitDisplay(u8SpeedLimitDisplay);
}

tVoid veda_tclServiceVehicleIf::vUpdateSpeedLimitDisplayUnit(tU8 u8SpeedLimitDisplayUnit) const
{
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->vUpdateCANSpeedLimitDisplay(u8SpeedLimitDisplayUnit);
}

tVoid veda_tclServiceVehicleIf::vUpdateOverSpeedDisplay(const tBool bOverSpeed) const
{
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->vUpdateCANSpeedLimitDisplay(bOverSpeed);
}

tVoid veda_tclServiceVehicleIf::vUpdateFreeSpeedDisplay(tBool FreeSpeed) const
{
    VEDA_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->vUpdateCANSpeedLimitDisplay(FreeSpeed);
}

tVoid veda_tclServiceVehicleIf::vUpdateDistanceTotal(tU32 u32DistanceTotal, tU32 u32LastValidDistanceTotal, tBool bStatus) const
{
   VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->vCANUpdateDistanceTotal(u32DistanceTotal, u32LastValidDistanceTotal, bStatus);
}

tVoid veda_tclServiceVehicleIf::vUpdateDistanceTotalUnit(tU8 u8DistanceTotalUnit, tBool bStatus) const
{
   ETG_TRACE_USR4(("veda_tclServiceVehicleIf()"));
   VEDA_NULL_POINTER_CHECK(_poServerRef);
   _poServerRef->vCANUpdateDistanceTotalUnit(u8DistanceTotalUnit, bStatus);
}

tVoid veda_tclServiceVehicleIf::onSendMediaInfoMStart(vehicle_fi_tcl_CAN_Mesg msg)
{
   ETG_TRACE_USR4(("veda_tclServiceVehicleIf() received MediaInfo CAN data from HMI ."));
   VEDA_NULL_POINTER_CHECK(_poClientVcan);
   _poClientVcan->vSendMediaInfo(msg);
}

tVoid veda_tclServiceVehicleIf::onSendCallInfoMStart(vehicle_fi_tcl_CAN_Mesg msg)
{
   ETG_TRACE_USR4(("veda_tclServiceVehicleIf() received Callinfo CAN data from HMI ."));
   VEDA_NULL_POINTER_CHECK(_poClientVcan);
   _poClientVcan->vSendCallInfo(msg);
}
tVoid veda_tclServiceVehicleIf::onSendPhoneInfoMStart(vehicle_fi_tcl_CAN_Mesg msg)
{
   ETG_TRACE_USR4(("veda_tclServiceVehicleIf() received Phoneinfo CAN data from HMI ."));
   VEDA_NULL_POINTER_CHECK(_poClientVcan);
   _poClientVcan->vSendPhoneInfo(msg);
}
tVoid veda_tclServiceVehicleIf::onSendXMInfoMStart(vehicle_fi_tcl_CAN_Mesg msg)
{
   ETG_TRACE_USR4(("veda_tclServiceVehicleIf() received XMinfo CAN data from HMI ."));
   VEDA_NULL_POINTER_CHECK(_poClientVcan);
   _poClientVcan->vSendXMInfo(msg);
}

tVoid veda_tclServiceVehicleIf::onSendMainlineInfoMStart(vehicle_fi_tcl_CAN_Mesg msg)
{
   ETG_TRACE_USR4(("veda_tclServiceVehicleIf() received Mainlineinfo CAN data from HMI ."));
   VEDA_NULL_POINTER_CHECK(_poClientVcan);
   _poClientVcan->vSendMainlineInfo(msg);
}
tVoid veda_tclServiceVehicleIf::onSendCabinAMediaInfoMStart(vehicle_fi_tcl_CAN_Mesg msg)
{
   ETG_TRACE_USR4(("veda_tclServiceVehicleIf() received CabinAMediainfo CAN data from HMI ."));
   VEDA_NULL_POINTER_CHECK(_poClientVcan);
   _poClientVcan->vSendCabAMediaInfo(msg);
}
tVoid veda_tclServiceVehicleIf::onSendCabinAMainlineInfoMStart(vehicle_fi_tcl_CAN_Mesg msg)
{
   ETG_TRACE_USR4(("veda_tclServiceVehicleIf() received CabinAMainlineinfo CAN data from HMI ."));
   VEDA_NULL_POINTER_CHECK(_poClientVcan);
   //_poClientVcan->vSendCabinAMainlineInfo(msg);
}
tVoid veda_tclServiceVehicleIf::onSendCabinAPhoneInfoMStart(vehicle_fi_tcl_CAN_Mesg msg)
{
   ETG_TRACE_USR4(("veda_tclServiceVehicleIf() received CabinAPhoneinfo CAN data from HMI ."));
   VEDA_NULL_POINTER_CHECK(_poClientVcan);
   //_poClientVcan->vSendCabinAPhoneInfo(msg);
}
tVoid veda_tclServiceVehicleIf::onSendCabinACallInfoMStart(vehicle_fi_tcl_CAN_Mesg msg)
{
   ETG_TRACE_USR4(("veda_tclServiceVehicleIf() received CabinACallinfo CAN data from HMI ."));
   VEDA_NULL_POINTER_CHECK(_poClientVcan);
   //_poClientVcan->vSendCabinACallInfo(msg);
}
tVoid veda_tclServiceVehicleIf::onSendCabinAXMInfoMStart(vehicle_fi_tcl_CAN_Mesg msg)
{
   ETG_TRACE_USR4(("veda_tclServiceVehicleIf() received CabinAXMinfo CAN data from HMI ."));
   VEDA_NULL_POINTER_CHECK(_poClientVcan);
   //_poClientVcan->vSendCabinAXMInfo(msg);
}
tVoid veda_tclServiceVehicleIf::onSendNaviCurrentStreetNameInfoMStart(vehicle_fi_tcl_CAN_Mesg msg)
{
   ETG_TRACE_USR4(("veda_tclServiceVehicleIf() received NaviCurrentStreetNameinfo CAN data from HMI ."));
   VEDA_NULL_POINTER_CHECK(_poClientVcan);
    _poClientVcan->vSendCurrentStreetName(msg);
}
tVoid veda_tclServiceVehicleIf::onSendNaviTurnToStreetNameInfoMStart(vehicle_fi_tcl_CAN_Mesg msg)
{
   ETG_TRACE_USR4(("veda_tclServiceVehicleIf() received NaviTurnToStreetNameinfo CAN data from HMI ."));
   VEDA_NULL_POINTER_CHECK(_poClientVcan);
    _poClientVcan->vSendTurnToStreetNameInfo(msg);
}
tVoid veda_tclServiceVehicleIf::onSendNaviDestinationInfoMStart(vehicle_fi_tcl_CAN_Navi_Mesg msg)
{
   ETG_TRACE_USR4(("veda_tclServiceVehicleIf() received NaviDestinationinfo CAN data from HMI ."));
   VEDA_NULL_POINTER_CHECK(_poClientVcan);
   _poClientVcan->VSendDestinationInfo(msg);
}
tVoid veda_tclServiceVehicleIf::onSendNaviTurnToSymbolsInfoMStart(vehicle_fi_tcl_CAN_Navi_Mesg msg)
{
   ETG_TRACE_USR4(("veda_tclServiceVehicleIf() received NaviTurnToSymbolsinfo CAN data from HMI ."));
   VEDA_NULL_POINTER_CHECK(_poClientVcan);
    _poClientVcan->VSendTurnToSymbolsInfo(msg);
}
tVoid veda_tclServiceVehicleIf::onSendNaviLaneGuidanceInfoMStart(vehicle_fi_tcl_CAN_Navi_Mesg msg)
{
   ETG_TRACE_USR4(("veda_tclServiceVehicleIf() received NaviLaneGuidanceinfo CAN data from HMI ."));
   VEDA_NULL_POINTER_CHECK(_poClientVcan);
   _poClientVcan->VSendLaneGuidanceInfo(msg);
}
tVoid veda_tclServiceVehicleIf::onSendNaviNavigationWarningInfoMStart(vehicle_fi_tcl_CAN_Navi_Mesg msg)
{
   ETG_TRACE_USR4(("veda_tclServiceVehicleIf() received NaviNavigationWarninginfo CAN data from HMI ."));
   VEDA_NULL_POINTER_CHECK(_poClientVcan);
   _poClientVcan->VSendNaviWarningInfo(msg);
}

// veda_tclServiceVehicleIfveda_ServiceVehicleIf: user specific code end

//EOF
