/*****************************************************************************
* FILE:         I_veda_ServiceVehicleIf.h
* PROJECT:      G3G project
* SW-COMPONENT: vehicledata
* Template:     I_ServiceIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the /event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef _I_veda_ServiceVehicleIf_H_
#define _I_veda_ServiceVehicleIf_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
//include base class
#include "veda_AppMain.h"
#include "I_veda_ServiceVehicle.h"

// Iveda_tclServiceVehicleIf_Include: user specific code start
// Iveda_tclServiceVehicleIf_Include: user specific code end

class Iveda_tclServiceVehicleIf : public veda_tclBaseIf
{
public:
   Iveda_tclServiceVehicleIf(veda_tclAppMain* poMainAppl):veda_tclBaseIf(poMainAppl) {;}
   virtual ~Iveda_tclServiceVehicleIf() {;}
   virtual const tChar* getIfName() const { return "Iveda_tclServiceVehicleIf"; };


   virtual tVoid sendDistanceUnitStatus(vehicle_fi_tcl_e8_Vehicle_DistanceUnit e8DistanceUnit) = 0;
   virtual tVoid sendFuelConsumptionUnitStatus(vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit e8FuelConsumpUnit) = 0;
   virtual tVoid sendTemperatureUnitStatus(vehicle_fi_tcl_e8_Vehicle_TemperatureUnit e8TempUnit) = 0;
   virtual tVoid sendLanguageStatus(vehicle_fi_tcl_e8_Language_Code Language, bpstl::vector<vehicle_fi_tcl_Language_SourceTable, bpstl::allocator<vehicle_fi_tcl_Language_SourceTable> > LangTable) = 0;
   virtual tVoid sendLanguageSyncSourceStatus(vehicle_fi_tcl_e8_Language_SourceId Language) = 0;
   virtual tVoid sendMeterLanguageKnowledgeStatus(vehicle_fi_tcl_e8_Meter_LangKnowledge State) = 0;
   virtual tVoid sendHandBrakeStatus(vehicle_fi_tcl_e8_Vehicle_HandBrakeStatus e8Status) = 0;
   virtual tVoid sendIgnitionStatus(vehicle_fi_tcl_e8_Vehicle_Ignition e8Status) = 0;
   virtual tVoid sendSpeedStatus(tU16 SpeedValue) = 0;
   virtual tVoid sendSpeedLimitStatus(tU8 SpeedLimit1, tU8 SpeedLimit2, tU8 Display, vehicle_fi_tcl_e8_Vehicle_DistanceUnit DisplayUnit, tBool OverSpeed, tBool FreeSpeed) = 0;
   virtual tVoid sendReverseGearPinStatus(tU8 State) = 0;
   virtual tVoid sendReverseGearCANStatus(tU8 State) = 0;
   virtual tVoid sendSpeedLockStatus(tU8 State) = 0;
   virtual tVoid sendDrivingStateStatus(tU8 State) = 0;
   virtual tVoid sendGlobalVehicleWarningStateStatus(vehicle_fi_tcl_e8_Vehicle_WarningState State) = 0;
   virtual tVoid sendVehicleStatesStatus(vehicle_fi_tcl_e8_Vehicle_States State) = 0;
   virtual tVoid sendNetworkStateStatus(tU8 u8BusState_MCAN, tU8 u8BusState_VCAN, tU8 u8MuteState_MCAN, tU8 u8MuteState_VCAN, tBool bBusOff_MCAN, tBool bBusOff_VCAN, tBool bBusOff, tBool bMute_MCAN, tBool bMute_VCAN, std::vector<tU8, std::allocator<tU8> > Listu8AbsentState_ECU, std::vector<tU8, std::allocator<tU8> > Listu8MuteStateMCAN_Channel) = 0;
   virtual tVoid sendDistanceTotalizerStatus(tU32 DisTotal, tU32 lastValidDisTotal, tU8 Unit, tBool DisTotalStatus) = 0;
   virtual tVoid sendMileageStatus(tU32 Mileage) = 0;
   virtual tVoid sendAvgFuelEconomyStatus(tU16 FuelEcon) = 0;
   virtual tVoid sendTirePressureSupportStatus(tBool PressureSupport) = 0;
   virtual tVoid sendTPMSResetSupportStatus(vehicle_fi_tcl_e8_Vehicle_TPMSReset TPMSResetInfo) = 0;
   virtual tVoid sendTirePressureSettingStatus(tU16 SettingPressureFront, tU16 SettingPressureRear) = 0;
   

   virtual tVoid sendPartialMuteStatus(tU8 PartialMuteValue)=0;
   virtual tVoid sendSwivMonAutoOpenStatus(tU8 SwivMonAutoOpenValue)=0;
   virtual tVoid sendVehicleDriverDoorOpenStatus(tU8 DriverDoorOpenValue)=0;
   virtual tVoid sendDateModeStatus(tU8 DateModeValue)=0;
   virtual tVoid sendTmModeStatus(tU8 TmModeValue)=0;
   //camera
   virtual tVoid sendActCam1Status(tU8 ActCam1Value)=0;
   //camera2
   virtual tVoid sendActCam2Status(tU8 ActCam2Value)=0;
   //camera3
   virtual tVoid sendActCam3Status(tU8 ActCam3Value)=0;
   //camera4
   virtual tVoid sendActCam4Status(tU8 ActCam4Value)=0;
   //camera5
   virtual tVoid sendActCam5Status(tU8 ActCam5Value)=0;
   //camera6
   virtual tVoid sendActCam6Status(tU8 ActCam6Value)=0;
   //camera7
   virtual tVoid sendActCam7Status(tU8 ActCam7Value)=0;
   //camsplit
   virtual tVoid sendCamSplitQuadStatus(tU16 CamSplitQuadValue)=0;
   //MuteDev
   virtual tVoid sendMuteDevStatus(tU8 MuteDevStatus)=0;
   //SysVolt
   virtual tVoid sendSysVoltStatus(tU8 SysVoltStatus)=0;
   //ParkingBreakSwitch
   virtual tVoid sendParkingBreakSwitchStatus(tU8 ParkingBreakSwitchValue) = 0;
   //RearCamReq
   virtual tVoid sendRearCamReqStatus(tU8 RearCamReqValue) = 0;
   //VIN
   virtual tVoid sendVINStatus(tU32 VINValue) = 0;
   //TimeDate
   virtual tVoid sendTimeDateStatus(tU64 TimeDateValue) = 0;
   //Phone Call Command
    virtual tVoid sendPhoneCallCmdStatus(tU8 PhoneCallCmdValue) = 0;
	//Volume Command 
	virtual tVoid sendVolumeCmdStatus(tU8 VolumeCmdValue) = 0;
	// ActCam8 
	virtual tVoid sendActCam8Status(tU8 ActCam8Value) = 0;
	// ActCam9 
	virtual tVoid sendActCam9Status(tU8 ActCam9Value) = 0;
	// ActCam10 
	virtual tVoid sendActCam10Status(tU8 ActCam10Value) = 0;
	// ActCam11
	virtual tVoid sendActCam11Status(tU8 ActCam11Value) = 0;
	// ActCam12
	virtual tVoid sendActCam12Status(tU8 ActCam12Value) = 0;
	// ActCam13
	virtual tVoid sendActCam13Status(tU8 ActCam13Value) = 0;
	// ActCam14
	virtual tVoid sendActCam14Status(tU8 ActCam14Value) = 0;
	// ActCam15
	virtual tVoid sendActCam15Status(tU8 ActCam15Value) = 0;
	// ActCam16
	virtual tVoid sendActCam16Status(tU8 ActCam16Value) = 0;
	// ActCam17
	virtual tVoid sendActCam17Status(tU8 ActCam17Value) = 0;
	//Source Command 
	virtual tVoid sendSourceCmdStatus(tU8 SourceCmdValue) = 0;
	//CabinSource Command 
	virtual tVoid sendCabinSourceCmdStatus(tU8 CabinSourceCmdValue) = 0;
	//CabinVolume Command 
	virtual tVoid sendCabinVolumeCmdStatus(tU8 CabinVolumeCmdValue) = 0;	
	//CabinTuner Command 
	virtual tVoid sendCabinTunerCmdStatus(tU8 CabinTunerCmdValue) = 0;
	//CabinTrack Command 
	virtual tVoid sendCabinTrackCmdStatus(tU8 CabinTrackCmdValue) = 0;
	//CabinPlaylist Command 
	virtual tVoid sendCabinPlaylistCmdStatus(tU8 CabinPlaylistCmdValue) = 0;
	//Track Command 
	virtual tVoid sendTrackCommandStatus(tU8 TrackCommandValue) = 0;
	//SMARTVR 
	virtual tVoid sendSMARTVRStatus(tU8 SMARTVRValue) = 0;
	//Tuner Command 
	virtual tVoid sendTunerCommandStatus(tU8 TunerCommandValue) = 0;
	//TA Command 
	virtual tVoid sendTACommandStatus(tU8 TACommandValue) = 0;
	//RDS Command 
	virtual tVoid sendRDSCommandStatus(tU8 RDSCommandValue) = 0;
	
	//Voice Cmd Command 
	virtual tVoid sendVoiceRecgCmdStatus(tU8 VoiceRecgCommandValue) = 0;
	
	//phone pwr Cmd  
	virtual tVoid sendPhonePwrCmdStatus(tU8 PhonePwrCmdValue) = 0;
		
	//Radio pwr Cmd  
	virtual tVoid sendRadioPwrCmdStatus(tU8 RadioPwrCmdValue) = 0;
		//Device Info SW version 
	virtual tVoid SendDeviceInfoSWversionStatus(tU32 u32SWversionValue) = 0;	
	//TotalVehDistDiag 
	virtual tVoid SendTotalVehDistDiagStatus(tU32 u32TotalVehDistDiagValue) = 0;
		
	//RC Next Btn
	virtual tVoid sendRCNextBtnStatus(tU8 RCNextBtnValue) = 0;
	
	//RC Prev Btn
	virtual tVoid sendRCPrevBtnStatus(tU8 RCPrevBtnValue) = 0;
	
   //CamTxt
   virtual tVoid sendCamTxtStatus(tU64 CamTxtValue)=0; 
   //VIN_64
   virtual tVoid sendVIN_64Status(tU64 VIN_64Value)=0;
   //PrivacyResetReq
   virtual tVoid sendPrivacyResetReqStatus(tU8 PrivacyResetReqValue)=0;
   //Cam1ManAct
   virtual tVoid onCam1ManActMStart(tU8 RequestId) = 0;
   //Cam2ManAct
   virtual tVoid onCam2ManActMStart(tU8 RequestId) = 0;
   //Cam3ManAct
   virtual tVoid onCam3ManActMStart(tU8 RequestId) = 0;
   //Cam4ManAct
   virtual tVoid onCam4ManActMStart(tU8 RequestId) = 0;
   //Cam5ManAct
   virtual tVoid onCam5ManActMStart(tU8 RequestId) = 0;
   //Cam6ManAct
   virtual tVoid onCam6ManActMStart(tU8 RequestId) = 0;
   //Cam7ManAct
   virtual tVoid onCam7ManActMStart(tU8 RequestId) = 0;
   //Cam8ManAct
   virtual tVoid onCam8ManActMStart(tU8 RequestId) = 0;
   //Cam9ManAct
   virtual tVoid onCam9ManActMStart(tU8 RequestId) = 0;
   //Cam10ManAct
   virtual tVoid onCam10ManActMStart(tU8 RequestId) = 0;
   //Cam11ManAct
   virtual tVoid onCam11ManActMStart(tU8 RequestId) = 0;
   //Cam12ManAct
   virtual tVoid onCam12ManActMStart(tU8 RequestId) = 0;
  //Cam13ManAct
   virtual tVoid onCam13ManActMStart(tU8 RequestId) = 0;
  //Cam14ManAct
   virtual tVoid onCam14ManActMStart(tU8 RequestId) = 0;
   //Cam15ManAct
   virtual tVoid onCam15ManActMStart(tU8 RequestId) = 0;
   //Cam16ManAct
   virtual tVoid onCam16ManActMStart(tU8 RequestId) = 0;
     //Cam17ManAct
   virtual tVoid onCam17ManActMStart(tU8 RequestId) = 0;
   
   //PrivacyResetAck
   virtual tVoid onPrivacyResetAckMStart(tU8 RequestId) = 0;
   //Long Data Transfer
   virtual tVoid onSendMediaInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) = 0;
   virtual tVoid onSendCallInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) = 0;
   virtual tVoid onSendPhoneInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) = 0;
   virtual tVoid onSendXMInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) = 0;
   virtual tVoid onSendMainlineInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) = 0;
   virtual tVoid onSendCabinAMediaInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) = 0;
   virtual tVoid onSendCabinAMainlineInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) = 0;
   virtual tVoid onSendCabinAPhoneInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) = 0;
   virtual tVoid onSendCabinACallInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) = 0;
   virtual tVoid onSendCabinAXMInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) = 0;
   virtual tVoid onSendNaviCurrentStreetNameInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) = 0;
   virtual tVoid onSendNaviTurnToStreetNameInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) = 0;
   virtual tVoid onSendNaviDestinationInfoMStart(vehicle_fi_tcl_CAN_Navi_Mesg msg) = 0;
   virtual tVoid onSendNaviTurnToSymbolsInfoMStart(vehicle_fi_tcl_CAN_Navi_Mesg msg) = 0;
   virtual tVoid onSendNaviLaneGuidanceInfoMStart(vehicle_fi_tcl_CAN_Navi_Mesg msg) = 0;
   virtual tVoid onSendNaviNavigationWarningInfoMStart(vehicle_fi_tcl_CAN_Navi_Mesg msg) = 0;
   //DispCamCls
   virtual tVoid onDispCamClsMStart(tU8 RequestId) = 0;
   //PhoneBtLinkStatus
   virtual tVoid onPhoneBTLinkStatusMStart(tU8 BTLinkStatus) = 0;
   //PhoneBookSyncstatus
   virtual tVoid onPhoneBookSyncstatusMStart(tU8 PhoneBookSyncStatusValue) = 0;
   //CallHistorySyncStatus
   virtual tVoid onCallHistorySyncStatusMStart(tU8 CallHistorySyncStatusValue) = 0;
   //PhoneStatusRoaming
   virtual tVoid onPhoneStatusRoamingMStart(tU8 PhoneStatusRoamingValue) = 0;
    //CallDuration
   virtual tVoid onCallDurationMStart(tU16 CallDurationValue) = 0;
   //GSMSignalStrength
   virtual tVoid onGSMSignalStrengthMStart(tU8 GSMSignalStrengthValue) = 0;
   //PhoneCallStatus
   virtual tVoid onPhoneCallStatusMStart(tU8 CallStatusValue) = 0;
   //PhoneBatteryLevelStatus
   virtual tVoid onPhoneBatteryLevelStatusMStart(tU8 PhoneBatteryLevelStatusValue) = 0;
   //DeviceStatusWifiAvailable
   virtual tVoid onDeviceStatusWifiAvailableMStart(tU8 DeviceStatusWifiStatus) = 0;
   //MediaStatusAudioSource
   virtual tVoid onMediaStatusAudioSourceMStart(tU8 AudioSource) = 0;
   //PhoneAvailableStatus
   virtual tVoid onPhoneAvailableStatusMStart(tU8 PhoneAvailableStatusValue) = 0;
   //PhoneVRAvailable
   virtual tVoid onPhoneVRAvailableMStart(tU8 PhoneVRAvailableValue) = 0;
   //DeviceStatusBTStatus
   virtual tVoid onDeviceStatusBTStatusMStart(tU8 DeviceStatusBTStatusValue) = 0;
   //DeviceStatusBluetoothAvail
   virtual tVoid onDeviceStatusBluetoothAvailMStart(tU8 DeviceStatusBluetoothAvailValue) = 0; 
   //Req_DeviceInfo
   virtual tVoid onReq_DeviceInfoMStart(tU8 Req_DeviceInfoValue) = 0;
   //MediaStatusVolume
   virtual tVoid onMediaStatusVolumeMStart(tU8 volume) = 0;
    //CabinMediaStatusAudioSource
   virtual tVoid onCabinMediaStatusAudioSourceMStart(tU8 CabinAudioSource) = 0;
    //CabinMediaStatusTunerBand
   virtual tVoid onCabinMediaStatusTunerBandMStart(tU8 CabinMediaStatusTunerBandValue) = 0;
   //CabinMediaStatusVolume
   virtual tVoid onCabinMediaStatusVolumeMStart(tU8 CabinVolume) = 0;
   //MediaStatusMuteStatus
   virtual tVoid onMediaStatusMuteStatusMStart(tU8 MediaStatusMuteValue) = 0;
   //CabinMediaStatusMuteStatus
   virtual tVoid onCabinMediaStatusMuteStatusMStart(tU8 CabinMediaStatusMuteValue) = 0;
  //MediaStatusPlayStatus
   virtual tVoid onMediaStatusPlayStatusMStart(tU8 MediaStatusPlayStatusValue) = 0;
   //MediaStatusMixState
   virtual tVoid onMediaStatusMixStateMStart(tU8 MediaStatusMixStateValue) = 0; 
   //MediaStatusPlaylistMode
   virtual tVoid onMediaStatusPlaylistModeMStart(tU8 MediaStatusPlaylistModeValue) = 0; 
   //MediaStatusTrackTime
   virtual tVoid onMediaStatusTrackTimeMStart(tU16 MediaStatusTrackTimeValue) = 0;
   //MediaStatusCurrTrackNum
   virtual tVoid onMediaStatusCurrTrackNumMStart(tU16 MediaStatusCurrTrackNumValue) = 0;
   //DeviceStatusRadioStatus
   virtual tVoid onDeviceStatusRadioStatusMStart(tU8 DeviceStatusRadioStatusValue) = 0; 
   //DeviceStatusDABAvailStatus
   virtual tVoid onDeviceStatusDABAvailStatusMStart(tU8 DeviceStatusDABAvailStatusValue) = 0;
   //DeviceStatusNavData
   virtual tVoid onDeviceStatusNavDataMStart(tU8 DeviceStatusNavDataValue) = 0; 
   //DeviceStatusUSB1Present
   virtual tVoid onDeviceStatusUSB1PresentMStart(tU8 DeviceStatusUSB1PresentValue) = 0;
   //DeviceStatusUSB2Present
   virtual tVoid onDeviceStatusUSB2PresentMStart(tU8 DeviceStatusUSB2PresentValue) = 0;
   //DeviceStatusNaviAvail
   virtual tVoid onDeviceStatusNaviAvailMStart(tU8 DeviceStatusNaviAvailValue) = 0;
   //DeviceStatusUSB1Src
   virtual tVoid onDeviceStatusUSB1SrcMStart(tU8 DeviceStatusUSB1SrcValue) = 0;
   //DeviceStatusUSB2Src
   virtual tVoid onDeviceStatusUSB2SrcMStart(tU8 DeviceStatusUSB2SrcValue) = 0;
   //DeviceStatusAMFMAvail
   virtual tVoid onDeviceStatusAMFMAvailMStart(tU8 DeviceStatusUSB2SrcValue) = 0;
  //MediaStatusSeekStatus
   virtual tVoid onMediaStatusSeekStatusMStart(tU8 MediaStatusSeekStatusValue) = 0;
  //MediaStatusRepeatStatus
   virtual tVoid onMediaStatusRepeatStatusMStart(tU8 MediaStatusRepeatStatusValue) = 0;
  //MediaStatusDABFMStatus
   virtual tVoid onMediaStatusDABFMStatusMStart(tU8 MediaStatusDABFMStatusValue) = 0;
   //VehicleNaviLatitude
   virtual tVoid onVehicleNaviLatitudeMStart(tU32 VehicleNaviLatitudeValue) = 0;
   //VehicleNaviLongitude
   virtual tVoid onVehicleNaviLongitudeMStart(tU32 VehicleNaviLongitudeValue) = 0;
   //MediaStatusTREGStatus
   virtual tVoid onMediaStatusTREGStatusMStart(tU8 MediaStatusTREGStatusValue) = 0;
   //MediaStatusTREGRTMStatus
   virtual tVoid onMediaStatusTREGRTMStatusMStart(tU8 MediaStatusTREGRTMStatusValue) = 0;
  //MediaStatusrdsStatus
   virtual tVoid onMediaStatusRDSStatusMStart(tU8 MediaStatusRDSStatusValue) = 0;
 //MediaStatusTAStatus
   virtual tVoid onMediaStatusTAStatusMStart(tU8 MediaStatusTAStatusValue) = 0;
   //MediaStatusTPStatus
   virtual tVoid onMediaStatusTPStatusMStart(tU8 MediaStatusTPStatusValue) = 0;
   //MediaStatusTunerBandStatus
   virtual tVoid onMediaStatusTunerBandStatusMStart(tU8 MediaStatusTunerBandStatusValue) = 0;
   //MediaStatusTunerPresetStatus
   virtual tVoid onMediaStatusTunerPresetStatusMStart(tU8 MediaStatusTunerPresetStatusValue) = 0;
  //HUS_DM1_Status
   virtual tVoid onHUS_DM1_StatusMStart(tU64 HUS_DM1_StatusValue) = 0;
   
   virtual tVoid sendSetLanguageMResult(tBool Result) = 0;
   virtual tVoid sendRequestMeterLanguageSyncMResult(tBool Result) = 0;
   virtual tVoid sendCSMEngineeringDataMResult(bpstl::vector<vehicle_fi_tcl_CAN_Message, bpstl::allocator<vehicle_fi_tcl_CAN_Message> > CanMessageList) = 0;
   virtual tVoid sendSetOSPAlertsStatusMResult(tBool Status) = 0;

   virtual void vGetDistanceUnitMsg(vehicle_mainfi_tclMsgDistanceUnitStatus& oStatus) = 0;
   virtual void vGetFuelConsumptionUnitMsg(vehicle_mainfi_tclMsgFuelConsumptionUnitStatus& oStatus) = 0;
   virtual void vGetTemperatureUnitMsg(vehicle_mainfi_tclMsgTemperatureUnitStatus& oStatus) = 0;
   virtual void vGetLanguageMsg(vehicle_mainfi_tclMsgLanguageStatus& oStatus) = 0;
   virtual void vGetLanguageSyncSourceMsg(vehicle_mainfi_tclMsgLanguageSyncSourceStatus& oStatus) = 0;
   virtual void vGetMeterLanguageKnowledgeMsg(vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus& oStatus) = 0;
   virtual void vGetHandBrakeMsg(vehicle_mainfi_tclMsgHandBrakeStatus& oStatus) = 0;
   virtual void vGetIgnitionMsg(vehicle_mainfi_tclMsgIgnitionStatus& oStatus) = 0;
   virtual void vGetSpeedMsg(vehicle_mainfi_tclMsgSpeedStatus& oStatus) = 0;
   
   virtual void vGetPartialMuteMsg(vehicle_mainfi_tclMsgPartialMuteStatus& oStatus) = 0;
   virtual void vGetSwivMonAutoOpenMsg(vehicle_mainfi_tclMsgSwivMonAutoOpenStatus& oStatus) = 0;
   virtual void vGetDriverDoorOpenMsg(vehicle_mainfi_tclMsgDriverDoorOpenStatus& oStatus) = 0;
   virtual void vGetDateModeMsg(vehicle_mainfi_tclMsgDateModeStatus& oStatus) = 0;
   virtual void vGetTmModeMsg(vehicle_mainfi_tclMsgTmModeStatus& oStatus) = 0;
   //camera
    virtual void vGetActCam1Msg(vehicle_mainfi_tclMsgActCam1Status& oStatus) = 0;
   //camera2
    virtual void vGetActCam2Msg(vehicle_mainfi_tclMsgActCam2Status& oStatus) = 0;
	//camera3
    virtual void vGetActCam3Msg(vehicle_mainfi_tclMsgActCam3Status& oStatus) = 0;
	//camera4
    virtual void vGetActCam4Msg(vehicle_mainfi_tclMsgActCam4Status& oStatus) = 0;
	//camera5
    virtual void vGetActCam5Msg(vehicle_mainfi_tclMsgActCam5Status& oStatus) = 0;
	//camera6
    virtual void vGetActCam6Msg(vehicle_mainfi_tclMsgActCam6Status& oStatus) = 0;
	//camera7
    virtual void vGetActCam7Msg(vehicle_mainfi_tclMsgActCam7Status& oStatus) = 0;
	//camsplit
    virtual void vGetCamSplitQuadMsg(vehicle_mainfi_tclMsgCamSplitQuadStatus& oStatus) = 0;
	//MuteDev
	virtual void vGetMuteDevStatusMsg(vehicle_mainfi_tclMsgMuteDevStatus& oStatus) = 0;
	//SysVolt
	virtual void vGetSysVoltStatusMsg(vehicle_mainfi_tclMsgSysVoltStatus& oStatus) = 0;
	//ParkingBreakSwitch
	virtual void vGetParkingBreakSwitchMsg(vehicle_mainfi_tclMsgParkingBreakSwitchStatus& oStatus) = 0;
	//RearCamReq
	virtual void vGetRearCamReqMsg(vehicle_mainfi_tclMsgRearCamReqStatus& oStatus) = 0;
	//VIN
	virtual void vGetVINMsg(vehicle_mainfi_tclMsgVINStatus& oStatus) = 0;
	//TimeDate
	virtual void vGetTimeDateMsg(vehicle_mainfi_tclMsgTimeDateStatus& oStatus) = 0;
	//PhoneCall Cmd
	virtual void vGetPhoneCallCommandMsg(vehicle_mainfi_tclMsgPhoneCallCommandStatus& oStatus) = 0;
	
	//RCnextBtn 
	virtual void vGetRCNextBtnMsg(vehicle_mainfi_tclMsgRCNextBtnStatus& oStatus) = 0;
	
		
	//RCPrevBtn 
	virtual void vGetRCPrevBtnMsg(vehicle_mainfi_tclMsgRCPrevBtnStatus& oStatus) = 0;
	
	//Volume Cmd
	virtual void vGetVolumeCommandMsg(vehicle_mainfi_tclMsgVolumeCommandStatus& oStatus) = 0;
	// ActCam8
	virtual void vGetActCam8Msg(vehicle_mainfi_tclMsgActCam8Status& oStatus) = 0;
	// ActCam9
	virtual void vGetActCam9Msg(vehicle_mainfi_tclMsgActCam9Status& oStatus) = 0;
	// ActCam10
	virtual void vGetActCam10Msg(vehicle_mainfi_tclMsgActCam10Status& oStatus) = 0;
	// ActCam11
	virtual void vGetActCam11Msg(vehicle_mainfi_tclMsgActCam11Status& oStatus) = 0;
	// ActCam12
	virtual void vGetActCam12Msg(vehicle_mainfi_tclMsgActCam12Status& oStatus) = 0;
	// ActCam13
	virtual void vGetActCam13Msg(vehicle_mainfi_tclMsgActCam13Status& oStatus) = 0;
	// ActCam14
	virtual void vGetActCam14Msg(vehicle_mainfi_tclMsgActCam14Status& oStatus) = 0;
	// ActCam15
	virtual void vGetActCam15Msg(vehicle_mainfi_tclMsgActCam15Status& oStatus) = 0;
	// ActCam16
	virtual void vGetActCam16Msg(vehicle_mainfi_tclMsgActCam16Status& oStatus) = 0;
	// ActCam17
	virtual void vGetActCam17Msg(vehicle_mainfi_tclMsgActCam17Status& oStatus) = 0;		
	//Source Cmd
	virtual void vGetSourceCommandMsg(vehicle_mainfi_tclMsgSourceCommandStatus& oStatus) = 0;	
	//CabinSource Cmd
	virtual void vGetCabinSourceCommandMsg(vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus& oStatus) = 0;	
	//CabinVolume Cmd
	virtual void vGetCabinVolumeCommandMsg(vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus& oStatus) = 0;	
	//CabinTuner Cmd
	virtual void vGetCabinTunerCommandMsg(vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus& oStatus) = 0;	
	//CabinTrack Cmd
	virtual void vGetCabinTrackCommandMsg(vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus& oStatus) = 0;	
	//CabinPlaylist Cmd
	virtual void vGetCabinPlaylistCommandMsg(vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus& oStatus) = 0;	
	//Track Cmd
	virtual void vGetTrackCommandMsg(vehicle_mainfi_tclMsgTrackCommandStatus& oStatus) = 0;
	//SMARTVR
	virtual void vGetSMARTVRMsg(vehicle_mainfi_tclMsgSMARTVRStatus& oStatus) = 0;	
	//Tuner Cmd
	virtual void vGetTunerCommandMsg(vehicle_mainfi_tclMsgTunerCommandStatus& oStatus) = 0;
	//TA Cmd
	virtual void vGetTACommandMsg(vehicle_mainfi_tclMsgTACommandStatus& oStatus) = 0;
	//RDS Cmd
	virtual void vGetRDSCommandMsg(vehicle_mainfi_tclMsgRDSCommandStatus& oStatus) = 0;
	
	//Voice Recgn Cmd
	virtual void vGetVoiceRecgCommandMsg(vehicle_mainfi_tclMsgVoiceRecgCommandStatus& oStatus) = 0;
	//Phone Pwr Cmd
	virtual void vGetPhonePwrCmdMsg(vehicle_mainfi_tclMsgPhonePwrCmdStatus& oStatus) = 0;
		//Radio Pwr Cmd
	virtual void vGetRadioPwrCmdMsg(vehicle_mainfi_tclMsgRadioPwrCmdStatus& oStatus) = 0;
		//SW Version 
	virtual void vGetDeviceInfoSWversionMsg(vehicle_mainfi_tclMsgDeviceInfoSWversionStatus& oStatus) = 0;
	//TotalVehDistDiag 
	virtual void vGetTotalVehDistDiagMsg(vehicle_mainfi_tclMsgTotalVehDistDiagStatus& oStatus) = 0;
	//CamTxt
    virtual void vGetCamTxtMsg(vehicle_mainfi_tclMsgCamTxtStatus& oStatus) = 0;
	//VIN_64
    virtual void vGetVIN_64Msg(vehicle_mainfi_tclMsgVIN_64Status& oStatus) = 0;
	//PrivacyResetReq
    virtual void vGetPrivacyResetRequestMsg(vehicle_mainfi_tclMsgPrivacyResetRequestStatus& oStatus) = 0;
	
   virtual void vGetSpeedLimitMsg(vehicle_mainfi_tclMsgSpeedLimitStatus& oStatus) = 0;
   virtual void vGetReverseGearMsg(vehicle_mainfi_tclMsgReverseGearStatus& oStatus) = 0;
   virtual void vGetSpeedLockMsg(vehicle_mainfi_tclMsgSpeedLockStatus& oStatus) = 0;
   virtual void vGetDrivingStateMsg(vehicle_mainfi_tclMsgDrivingStateStatus& oStatus) = 0;
   virtual void vGetGlobalVehicleWarningStateMsg(vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus& oStatus) = 0;
   virtual void vGetVehicleStatesMsg(vehicle_mainfi_tclMsgVehicleStatesStatus& oStatus) = 0;
   virtual void vGetNetworkStateMsg(vehicle_mainfi_tclMsgNetworkStateStatus& oStatus) = 0;
   virtual void vGetDistanceTotalizerMsg(vehicle_mainfi_tclMsgDistanceTotalizerStatus& oStatus) = 0;
   virtual void vGetMileageMsg(vehicle_mainfi_tclMsgMileageStatus& oStatus) = 0;
   virtual void vGetAvgFuelEconomyMsg(vehicle_mainfi_tclMsgAvgFuelEconomyStatus& oStatus) = 0;
   virtual void vGetTirePressureSupportMsg(vehicle_mainfi_tclMsgTirePressureSupportStatus& oStatus) = 0;
   virtual void vGetTPMSResetSupportMsg(vehicle_mainfi_tclMsgTPMSResetSupportStatus& oStatus) = 0;
   virtual void vGetTirePressureSettingMsg(vehicle_mainfi_tclMsgTirePressureSettingStatus& oStatus) = 0;

// Iveda_tclServiceVehicleIfDeclarations: user specific code start
   virtual tVoid vUpdateSpeedLimit1(const tU8 u8SpeedLimit1) const = 0;
   virtual tVoid vUpdateSpeedLimit2(const tU8 u8SpeedLimit2) const = 0;
   virtual tVoid vUpdateSpeedLimitDisplay(const tU8 u8SpeedLimitDisplay) const = 0;
   virtual tVoid vUpdateSpeedLimitDisplayUnit(const tBool u8SpeedLimitDisplayUnit) const = 0;
   virtual tVoid vUpdateOverSpeedDisplay(const tBool bOverSpeed) const = 0;
   virtual tVoid vUpdateFreeSpeedDisplay(const tBool bFreeSpeed) const = 0;
   virtual tVoid vUpdateDistanceTotal(tU32 u32DistanceTotal, tU32 u32LastValidDistanceTotal, tBool bStatus) const = 0;
   virtual tVoid vUpdateDistanceTotalUnit(tU8 u8DistanceTotalUnit, tBool bStatus) const = 0;
// Iveda_tclServiceVehicleIfDeclarations: user specific code end
};

#endif // _I_veda_ServiceVehicleIf_H_


