#ifndef __VEDA_vedaAsfComponent_H
#define __VEDA_vedaAsfComponent_H

/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file          vedaAsfComponent.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: vehicledata
  * @Template:     AsfClient.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                create the ASF component
  *
  *                Do manual changes only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2017 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#include <iostream>

#include "asf/core/BaseComponent.h"
#include "asf/core/Logger.h"

#include "asf/stream/MemoryStream.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "veda_AppMain.h"

namespace org { namespace bosch { namespace cm { namespace veda {

    using namespace::asf::core;
    using namespace::asf::stream;
    using namespace::asf::core;
    using namespace::org::bosch::cm::veda;

    void vProxyStarter(veda_tclAppMain *poServer);

    class CcaSrvProxy;

    class VedaAsfComponent : public BaseComponent
    {
    private:
        veda_tclAppMain  *_poCcaServer;
        CcaSrvProxy           *_poCcaSrvProxy;

        DECLARE_CLASS_LOGGER();

    public:
        VedaAsfComponent();
        virtual ~VedaAsfComponent();
    };

}}}} // namespace org { namespace bosch { namespace cm { namespace veda {

#endif // ifndef __VEDA_vedaAsfComponent_H
