/*****************************************************************************
* FILE:         veda_AppMain.h
* PROJECT:      G3G project
* SW-COMPONENT: vehicledata
* Template:     applMain.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end
*
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/


#ifndef _VEHICLEDATAMAIN_H_
#define _VEHICLEDATAMAIN_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#define SYSTEM_S_IMPORT_INTERFACE_MAP
#define SYSTEM_S_IMPORT_INTERFACE_SET
#include "stl_pif.h"

#include "veda_AppMain_Trace.h"

// veda_tclAppMainIncludes: user specific code start
#define DIAGLIB_INCLUDE_SYSTEM_SET
#include "diaglib_if.h"
// veda_tclAppMainIncludes: user specific code end

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/


#define VEDA_NULL_POINTER_CHECK(poClass) \
   if (poClass == NULL) {\
   FATAL_M_ASSERT_ALWAYS();\
   return;\
   }

#define VEDA_NULL_POINTER_CHECK_VAL(poClass) \
   if (poClass == NULL) {\
   FATAL_M_ASSERT_ALWAYS();\
   return 0;\
   }

// veda_tclAppMainDefine: user specific code start
// veda_tclAppMainDefine: user specific code end


#define TRACE_BUFFER_MAXSIZE  250
#define VEDAINTERNAL_MSG_LEN    4   

#ifdef SMARTPHONE_FEATURE_AVAILABLE
#undef SMARTPHONE_FEATURE_AVAILABLE // to enable if smartphone feature is available in the project 
#endif // ifdef SMARTPHONE_FEATURE_AVAILABLE    

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class ahl_tclBaseOneThreadApp;
class veda_tclAppMain;

// veda_tclAppMainForwardDecl: user specific code start
class veda_tclSystemSetListener;
// veda_tclAppMainForwardDecl: user specific code end

////////////////////////////////////////////////////////////////////////////////
// Base class for all Classes
class veda_tclBaseIf
{
protected:
   const veda_tclAppMain*   _cpoMain;

public:
   typedef enum {
      //internal messages
      eCvmEvent = 1,
      eOneSecondTimeoutEvent = 2,
      eCmdCsmBusIndReceived = 3,
      eReverseGearStateChanged = 4,
      eSetLanguage = 5,
      eSetLanguageSyncSource = 6,
      eGetCSMEnggData = 7,
      eAccessoryStateChanged = 8,
      eIgnitionStateChanged = 9,
      eRegCsmBusStates = 10,
      eReadCsmBusStates = 11,
      eDefaultSetting = 12,
      eTirePressureSet = 13,
	  eLongDataTimeoutEvent = 14,

      // veda_tclAppMainIMsgDef: user specific code start
      eLanguageSyncMenuRequested,
      // veda_tclAppMainIMsgDef: user specific code end

      eHeartbeat = 200,
      eCmdTraceCmdReceived,
      eCmdCsmSignalReceived,
      eMaxTypes
   }ECmdTypes;

   typedef struct TMsg{
      ECmdTypes  eCmd;
      tChar      strClassName[50];
      union {
         tBool bData;
         tU8   u8Data;
         tS8   s8Data;
         tU16  u16Data;
         tS16  s16Data;
         tU32  u32Data;
         tS32  s32Data;
         tU8   au8Data[VEDAINTERNAL_MSG_LEN];

         // veda_tclAppMainIMsgUnion: user specific code start
         // veda_tclAppMainIMsgUnion: user specific code end
      }u;
   } TMsg;

   veda_tclBaseIf(const veda_tclAppMain* cpoMain):_cpoMain(cpoMain) {;} 
   virtual ~veda_tclBaseIf() {_cpoMain = OSAL_NULL;} 
   virtual const tChar* getName() const = 0;
   virtual const tChar* getIfName() const = 0;

   virtual tVoid vHandleMessage(TMsg* pMsg) = 0;
   virtual tVoid vHandleTraceMessage(const tUChar* puchData) = 0;
   virtual tVoid vGetReferences() = 0;
   virtual tVoid vStartCommunication() = 0;
   virtual tVoid vTraceInfo() = 0;

   // veda_tclAppMainBaseIfDecl: user specific code start
   // veda_tclAppMainBaseIfDecl: user specific code end

};


class veda_tclAppMain : public ahl_tclBaseOneThreadApp
{

private:
   static veda_tclAppMain*   _poMainAppInstance;

public:
   static veda_tclAppMain* theServer();    


   veda_tclAppMain(tVoid);
   virtual ~veda_tclAppMain(tVoid);

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'veda_tclAppMain' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   veda_tclAppMain& operator= (const veda_tclAppMain &oApp);

   /**************************************************************************
   * Copy Constructor, will not be implemented.
   * Avoids Lint Prio 3 warning:Info 1733: new in constructor for class 
   * 'veda_tclAppMain' which has no copy constructor.
   * NOTE: This is a technique to disable the copy constructor for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   veda_tclAppMain(const veda_tclAppMain &oApp); 

   /**************************************************************************
   * Overriding ahl_tclBaseOneThreadApp methods.
   **************************************************************************/
   virtual tBool bOnInit();
   virtual tVoid vOnApplicationClose();
   virtual tVoid vOnTimer(tU16 nTimerId);

   using ahl_tclBaseOneThreadApp::vOnLoopback;
   virtual tVoid vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage);

   virtual tVoid vDispatchInternalMsg(veda_tclBaseIf::TMsg* pInternalMsg);

#ifndef _CCA_APPLICATION_WO_SERVICE
   virtual tVoid vPostInternalMessage(veda_tclBaseIf::TMsg* pInternalMsg);
#endif

   tVoid vAddObj(veda_tclBaseIf* client) {
      _oObjList.insert(client);
   }

   tVoid vRemoveObj(veda_tclBaseIf* client){
      if(_oObjList.find(client) != _oObjList.end()) {
         _oObjList.erase(_oObjList.find(client));
      }
   }

   tVoid vStart();

   //reference handling for __ created objects
private:
   bpstl::set<veda_tclBaseIf*>  _oObjList;

public:
   tVoid vStartCommunication() const {
      bpstl::set<veda_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         (*iter)->vStartCommunication();
      }
   }

   tVoid vGetReferences() const {
      bpstl::set<veda_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         (*iter)->vGetReferences();
      }
   }

public:
   veda_tclBaseIf*  getHandler(const tChar* cName) const{
      bpstl::set<veda_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         if (0 == OSAL_s32StringCompare((*iter)->getIfName(), cName)) {
            return (*iter);
         }
         if (0 == OSAL_s32StringCompare((*iter)->getName(), cName)) {
            return (*iter);
         }         
      }
      return NULL;
   }

   tVoid vLoadRegistry();

private:
   tVoid vTracePlugIn(tVoid);
   tVoid vTraceUnplug(tVoid);

   static tVoid vTraceCallbackFunction(const tUChar* puchData);
   static tVoid vHandleTraceMessage(const tUChar* puchData);
   static tVoid vHandleTraceMessageGen(const tUChar* puchData);

   static tUChar _auchTraceInputBuffer[TRACE_BUFFER_MAXSIZE];

public:
#ifndef _CCA_APPLICATION_WO_SERVICE
   virtual tVoid vPostMsgCvmEvent(const tChar* strIfName, tU32 u32CvmEvent);
   virtual tVoid vPostMsgOneSecondTimeoutEvent(const tChar* strIfName, tU32 u32OneSecondTimeoutEvent);
   virtual tVoid vPostMsgLongDataTimeoutEvent(const tChar* strIfName, tU32 u32OneSecondTimeoutEvent);
   virtual tVoid vPostMsgCmdCsmBusIndReceived(const tChar* strIfName, tU32 u32CmdCsmBusIndReceived);
   virtual tVoid vPostMsgReverseGearStateChanged(const tChar* strIfName, tU32 u32ReverseGearStateChanged);
   virtual tVoid vPostMsgSetLanguage(const tChar* strIfName, tU32 u32SetLanguage);
   virtual tVoid vPostMsgSetLanguageSyncSource(const tChar* strIfName, tU32 u32SetLanguageSyncSource);
   virtual tVoid vPostMsgGetCSMEnggData(const tChar* strIfName, tU32 u32GetCSMEnggData);
   virtual tVoid vPostMsgAccessoryStateChanged(const tChar* strIfName, tU32 u32AccessoryStateChanged);
   virtual tVoid vPostMsgIgnitionStateChanged(const tChar* strIfName, tU32 u32IgnitionStateChanged);
   virtual tVoid vPostMsgRegCsmBusStates(const tChar* strIfName, tU32 u32RegCsmBusStates);
   virtual tVoid vPostMsgReadCsmBusStates(const tChar* strIfName, tU32 u32ReadCsmBusStates);
   virtual tVoid vPostMsgDefaultSetting(const tChar* strIfName, tU32 u32DefaultSetting);
   virtual tVoid vPostMsgTirePressureSet(const tChar* strIfName, tU32 u32TirePressureSet);
#endif

   // veda_tclAppMainDecl: user specific code start
   virtual tVoid vOnNewAppStateNotify(tU32 u32OldAppState, tU32 u32AppState);
      
   static tVoid _vOneSecTimerCallback(tVoid *pArg);  
   static tVoid _vOneLongDataTimerCallback(tVoid *pArg);  

   OSAL_tTimerHandle _hOneSecTimer;
   OSAL_tTimerHandle _hLongDataTimer;
   diaglib::tclServiceDiaglib* m_poServiceDiaglib;
   veda_tclSystemSetListener* m_poSystemSetListener;
   // veda_tclAppMainDecl: user specific code end
}; 

#endif // _VEHICLEDATAMAIN_H_

