/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          veda_ServiceVehicleCallbackIF.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: vehicledata
  * @Template:     serviceCallbackIf.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                service callback interface
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2017 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#ifndef __vehicle_main_fi_CALLBACKIF_H_
#define __vehicle_main_fi_CALLBACKIF_H_

class veda_tclServiceVehicleCallbackIF
{
	public:
       virtual ~veda_tclServiceVehicleCallbackIF() {};

       virtual tVoid onServiceAvailable() = 0;
       virtual tVoid onServiceUnavailable() = 0;

       virtual tBool onDistanceUnitSet(vehicle_fi_tcl_e8_Vehicle_DistanceUnit e8DistanceUnit, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onFuelConsumptionUnitSet(vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit e8FuelConsumpUnit, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onTemperatureUnitSet(vehicle_fi_tcl_e8_Vehicle_TemperatureUnit e8TempUnit, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onLanguageSyncSourceSet(vehicle_fi_tcl_e8_Language_SourceId Language, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onTirePressureSettingSet(vehicle_fi_tcl_e8_Vehicle_TirePressureInfo TirePressureRequestInfo, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;

       virtual tVoid onSetLanguageMStart(vehicle_fi_tcl_e8_Language_SourceId SourceId, vehicle_fi_tcl_e8_Language_Code Language) = 0;
       virtual tVoid onRequestMeterLanguageSyncMStart(vehicle_fi_tcl_e8_Meter_SyncRequest RequestId) = 0;
       virtual tVoid onCSMEngineeringDataMStart() = 0;
       virtual tVoid onSetOSPAlertsStatusMStart(tBool OSPAlert, tBool DangerousAreaAlert) = 0;
	   virtual tVoid onCam1ManActMStart(tU8 RequestId) = 0;
	   virtual tVoid onCam2ManActMStart(tU8 RequestId) = 0;
	   virtual tVoid onCam3ManActMStart(tU8 RequestId) = 0;
	   virtual tVoid onCam4ManActMStart(tU8 RequestId) = 0;
	   virtual tVoid onCam5ManActMStart(tU8 RequestId) = 0;
	   virtual tVoid onCam6ManActMStart(tU8 RequestId) = 0;
	   virtual tVoid onCam7ManActMStart(tU8 RequestId) = 0;
	   virtual tVoid onCam8ManActMStart(tU8 RequestId) = 0;
	   virtual tVoid onCam9ManActMStart(tU8 RequestId) = 0;
	   virtual tVoid onCam10ManActMStart(tU8 RequestId) = 0;
	   virtual tVoid onCam11ManActMStart(tU8 RequestId) = 0;
	   virtual tVoid onCam12ManActMStart(tU8 RequestId) = 0;
	   virtual tVoid onCam13ManActMStart(tU8 RequestId) = 0;
	   virtual tVoid onCam14ManActMStart(tU8 RequestId) = 0;
	   virtual tVoid onCam15ManActMStart(tU8 RequestId) = 0;
	   virtual tVoid onCam16ManActMStart(tU8 RequestId) = 0;
	   virtual tVoid onCam17ManActMStart(tU8 RequestId) = 0;
	   virtual tVoid onPrivacyResetAckMStart(tU8 RequestId) = 0;
	   virtual tVoid onDispCamClsMStart(tU8 RequestId) = 0;
	   virtual tVoid onPhoneBTLinkStatusMStart(tU8 BTLinkStatus) = 0;
	   virtual tVoid onPhoneBookSyncstatusMStart(tU8 PhoneBookSyncStatusValue) = 0;
	   virtual tVoid onCallHistorySyncStatusMStart(tU8 CallHistorySyncStatusValue) = 0;
	   virtual tVoid onPhoneStatusRoamingMStart(tU8 PhoneStatusRoamingValue) = 0;
	   virtual tVoid onCallDurationMStart(tU16 CallDurationValue) = 0;
	   virtual tVoid onGSMSignalStrengthMStart(tU8 GSMSignalStrengthValue) = 0;
	   virtual tVoid onPhoneCallStatusMStart(tU8 CallStatusValue) = 0;
	   virtual tVoid onPhoneBatteryLevelStatusMStart(tU8 PhoneBatteryLevelStatusValue) = 0;
	   virtual tVoid onDeviceStatusWifiAvailableMStart(tU8 DeviceStatusWifiStatus) = 0;
	   virtual tVoid onMediaStatusAudioSourceMStart(tU8 AudioSource) = 0;
	   virtual tVoid onPhoneAvailableStatusMStart(tU8 PhoneAvailableStatusValue) = 0;
	   virtual tVoid onPhoneVRAvailableMStart(tU8 PhoneVRAvailableValue) = 0;
	   virtual tVoid onDeviceStatusBTStatusMStart(tU8 DeviceStatusBTStatusValue) = 0;
	   virtual tVoid onDeviceStatusBluetoothAvailMStart(tU8 DeviceStatusBluetoothAvailValue) = 0;
	   virtual tVoid onReq_DeviceInfoMStart(tU8 Req_DeviceInfoValue) = 0;
	   virtual tVoid onMediaStatusVolumeMStart(tU8 volume) = 0;
	   virtual tVoid onCabinMediaStatusAudioSourceMStart(tU8 CabinAudioSource) = 0;
	   virtual tVoid onCabinMediaStatusTunerBandMStart(tU8 CabinMediaStatusTunerBandValue) = 0;
	   virtual tVoid onCabinMediaStatusVolumeMStart(tU8 CabinVolume) = 0;
	   virtual tVoid onMediaStatusMuteStatusMStart(tU8 MediaStatusMuteValue) = 0;
	   virtual tVoid onCabinMediaStatusMuteStatusMStart(tU8 CabinMediaStatusMuteValue) = 0;
	   virtual tVoid onMediaStatusPlayStatusMStart(tU8 MediaStatusPlayStatusValue) = 0;
	   virtual tVoid onMediaStatusSeekStatusMStart(tU8 MediaStatusSeekStatusValue) = 0;
	   virtual tVoid onMediaStatusRepeatStatusMStart(tU8 MediaStatusRepeatStatusValue) = 0;
	   virtual tVoid onMediaStatusDABFMStatusMStart(tU8 MediaStatusDABFMStatusValue) = 0;
	   virtual tVoid onVehicleNaviLatitudeMStart(tU32 VehicleNaviLatitudeValue) = 0;
	   virtual tVoid onVehicleNaviLongitudeMStart(tU32 VehicleNaviLongitudeValue) = 0;
	   virtual tVoid onMediaStatusTREGStatusMStart(tU8 MediaStatusTREGStatusValue) = 0;
	   virtual tVoid onMediaStatusTREGRTMStatusMStart(tU8 MediaStatusTREGRTMStatusValue) = 0;
	   virtual tVoid onMediaStatusRDSStatusMStart(tU8 MediaStatusRDSStatusValue) = 0;
	   virtual tVoid onMediaStatusTAStatusMStart(tU8 MediaStatusTAStatusValue) = 0;
	   virtual tVoid onMediaStatusTPStatusMStart(tU8 MediaStatusTPStatusValue) = 0;
	   virtual tVoid onMediaStatusTunerBandStatusMStart(tU8 MediaStatusTunerBandStatusValue) = 0;
	   virtual tVoid onMediaStatusTunerPresetStatusMStart(tU8 MediaStatusTunerPresetStatusValue) = 0;
	   virtual tVoid onMediaStatusMixStateMStart(tU8 MediaStatusMixStateValue) = 0;
	   virtual tVoid onMediaStatusPlaylistModeMStart(tU8 MediaStatusPlaylistModeValue) = 0;
	   virtual tVoid onMediaStatusTrackTimeMStart(tU16 MediaStatusTrackTimeValue) = 0;
	   virtual tVoid onMediaStatusCurrTrackNumMStart(tU16 MediaStatusCurrTrackNumValue) = 0;
	   virtual tVoid onDeviceStatusRadioStatusMStart(tU8 DeviceStatusRadioStatusValue) = 0;
	   virtual tVoid onDeviceStatusDABAvailStatusMStart(tU8 DeviceStatusDABAvailStatusValue) = 0;
	   virtual tVoid onDeviceStatusNavDataMStart(tU8 DeviceStatusNavDataValue) = 0;
	   virtual tVoid onDeviceStatusUSB1PresentMStart(tU8 DeviceStatusUSB1PresentValue) = 0;
	   virtual tVoid onDeviceStatusUSB2PresentMStart(tU8 DeviceStatusUSB2PresentValue) = 0;
	   virtual tVoid onDeviceStatusNaviAvailMStart(tU8 DeviceStatusNaviAvailValue) = 0;
	   virtual tVoid onDeviceStatusUSB1SrcMStart(tU8 DeviceStatusUSB1SrcValue) = 0;
	   virtual tVoid onDeviceStatusUSB2SrcMStart(tU8 DeviceStatusUSB2SrcValue) = 0;
	   virtual tVoid onDeviceStatusAMFMAvailMStart(tU8 DeviceStatusAMFMAvailValue) = 0;
	   virtual tVoid onHUS_DM1_StatusMStart(tU64 HUS_DM1_StatusValue) = 0;
	   virtual tVoid onSendMediaInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) = 0;
	   virtual tVoid onSendCallInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) = 0;
	   virtual tVoid onSendPhoneInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) = 0;
	   virtual tVoid onSendXMInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) = 0;
	   virtual tVoid onSendMainlineInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) = 0;
	   virtual tVoid onSendCabinAMediaInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) = 0;
	   virtual tVoid onSendCabinAMainlineInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) = 0;
	   virtual tVoid onSendCabinACallInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) = 0;
	   virtual tVoid onSendCabinAPhoneInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) = 0;
	   virtual tVoid onSendCabinAXMInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) = 0;
	   virtual tVoid onSendNaviCurrentStreetNameInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) = 0;
	   virtual tVoid onSendNaviTurnToStreetNameInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) = 0;
	   virtual tVoid onSendNaviDestinationInfoMStart(vehicle_fi_tcl_CAN_Navi_Mesg msg) = 0;
	   virtual tVoid onSendNaviTurnToSymbolsInfoMStart(vehicle_fi_tcl_CAN_Navi_Mesg msg) = 0;
	   virtual tVoid onSendNaviLaneGuidanceInfoMStart(vehicle_fi_tcl_CAN_Navi_Mesg msg) = 0;
	   virtual tVoid onSendNaviNavigationWarningInfoMStart(vehicle_fi_tcl_CAN_Navi_Mesg msg) = 0;
	   
};

#endif //__vehicle_main_fi_CALLBACKIF_H_


