/*****************************************************************************
* FILE:         veda_ServiceVehicle.cpp
* PROJECT:      G3G project
* SW-COMPONENT: vehicledata
* Template:     ServiceHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

// veda_tclServiceVehicleIncludes: user specific code start
#include "UnitList.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#include "dp_vd_vehicle_data_if.h"

#define KDS_DISTANCEUNIT_KMS 0
#define KDS_DISTANCEUNIT_UK_MILES 1
#define KDS_DISTANCEUNIT_US_MILES 2
#define KDS_DISTANCEUNIT_KMS_PER_L 3
// veda_tclServiceVehicleIncludes: user specific code end

#include "veda_ServiceVehicle.h"
#include "veda_ServiceVehicleCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VEHICLEDATA_SERVER_VEHICLE
#include "trcGenProj/Header/veda_ServiceVehicle.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define VEHICLE_SERVICE_ID              63
#define VEHICLE_FI_MAJOR_VERSION        1
#define VEHICLE_FI_MINOR_VERSION        0

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(veda_tclServiceVehicle, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_SETLANGUAGE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSetLanguageOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_REQUESTMETERLANGUAGESYNC, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleRequestMeterLanguageSyncOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_CSMENGINEERINGDATA, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleCSMEngineeringDataOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_SETOSPALERTSSTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSetOSPAlertsStatusOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_CAM1MANACT, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleCam1ManActOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_CAM2MANACT, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleCam2ManActOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_CAM3MANACT, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleCam3ManActOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_CAM4MANACT, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleCam4ManActOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_CAM5MANACT, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleCam5ManActOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_CAM6MANACT, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleCam6ManActOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_CAM7MANACT, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleCam7ManActOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_CAM8MANACT, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleCam8ManActOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_CAM9MANACT, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleCam9ManActOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_CAM10MANACT,AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleCam10ManActOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_CAM11MANACT,AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleCam11ManActOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_CAM12MANACT,AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleCam12ManActOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_CAM13MANACT,AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleCam13ManActOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_CAM14MANACT,AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleCam14ManActOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_CAM15MANACT,AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleCam15ManActOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_CAM16MANACT,AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleCam16ManActOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_CAM17MANACT,AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleCam17ManActOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_PRIVACYRESETACK, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandlePrivacyResetAckOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_SENDMEDIAINFO, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSendMediaInfoMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_SENDCALLINFO, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSendCallInfoMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_SENDPHONEINFO, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSendPhoneInfoMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_SENDXMINFO, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSendXMInfoMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_SENDMAINLINEINFO, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSendMainlineInfoMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_SENDCABINAMEDIAINFO, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSendCabinAMediaInfoMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_SENDCABINAMAINLINEINFO, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSendCabinAMainlineInfoMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_SENDCABINACALLINFO, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSendCabinACallInfoMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_SENDCABINAPHONEINFO, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSendCabinAPhoneInfoMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_SENDCABINAXMINFO, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSendCabinAXMInfoMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_SENDNAVICURRENTSTREETNAMEINFO, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSendNaviCurrentStreetNameInfoMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_SENDNAVITURNTOSTREETNAMEINFO, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSendNaviTurnToStreetNameInfoMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_SENDNAVIDESTINATIONINFO, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSendNaviDestinationInfoMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_SENDNAVITURNTOSYMBOLSINFO, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSendNaviTurnToSymbolsInfoMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_SENDNAVILANEGUIDANCEINFO, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSendNaviLaneGuidanceInfoMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_SENDNAVINAVIGATIONWARNINGINFO, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleSendNaviNavigationWarningInfoMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_DISPCAMCLS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDispCamClsOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_PHONEBTLINKSTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandlePhoneBTLinkStatusOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_PHONEBOOKSYNCSTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandlePhoneBookSyncstatusOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_CALLHISTORYSYNCSTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleCallHistorySyncStatusOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_PHONESTATUSROAMING, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandlePhoneStatusRoamingOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_CALLDURATION, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleCallDurationOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_GSMSIGNALSTRENGTH, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleGSMSignalStrengthOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_PHONECALLSTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandlePhoneCallStatusOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_PHONEBATTERYLEVELSTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandlePhoneBatteryLevelStatusOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_DEVICESTATUSWIFIAVAILABLE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDeviceStatusWifiAvailableOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_MEDIASTATUSAUDIOSOURCE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleMediaStatusAudioSourceOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_PHONEAVAILABLESTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandlePhoneAvailableStatusOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_DEVICESTATUSBTSTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDeviceStatusBTStatusOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_DEVICESTATUSBLUETOOTHAVAIL, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDeviceStatusBluetoothAvailOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_REQ_DEVICEINFO, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleReq_DeviceInfoOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_MEDIASTATUSVOLUME, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleMediaStatusVolumeOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_CABINMEDIASTATUSAUDIOSOURCE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleCabinMediaStatusAudioSourceOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_CABINMEDIASTATUSTUNERBAND, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleCabinMediaStatusTunerBandOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_CABINMEDIASTATUSVOLUME, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleCabinMediaStatusVolumeOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_MEDIASTATUSMUTESTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleMediaStatusMuteStatusOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_CABINMEDIASTATUSMUTESTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleCabinMediaStatusMuteStatusOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_PHONEVRAVAILABLE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandlePhoneVRAvailableOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_MEDIASTATUSPLAYSTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleMediaStatusPlayStatusOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_MEDIASTATUSSEEKSTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleMediaStatusSeekStatusOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_MEDIASTATUSREPEATSTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleMediaStatusRepeatStatusOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_MEDIASTATUSDABFMSTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleMediaStatusDABFMStatusOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_MEDIASTATUSTREGSTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleMediaStatusTREGStatusOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_MEDIASTATUSTREGRTMSTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleMediaStatusTREGRTMStatusOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_MEDIASTATUSRDSSTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleMediaStatusRDSStatusOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_MEDIASTATUSTASTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleMediaStatusTAStatusOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_MEDIASTATUSTPSTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleMediaStatusTPStatusOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_MEDIASTATUSTUNERBANDSTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleMediaStatusTunerBandStatusOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_MEDIASTATUSTUNERPRESETSTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleMediaStatusTunerPresetStatusOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_MEDIASTATUSMIXSTATE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleMediaStatusMixStateOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_MEDIASTATUSPLAYLISTMODE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleMediaStatusPlaylistModeOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_MEDIASTATUSTRACKTIME, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleMediaStatusTrackTimeOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_MEDIASTATUSCURRTRACKNUM, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleMediaStatusCurrTrackNumOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_DEVICESTATUSRADIOSTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDeviceStatusRadioStatusOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_DEVICESTATUSDABAVAILSTATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDeviceStatusDABAvailStatusOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_DEVICESTATUSNAVDATA, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDeviceStatusNavDataOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_DEVICESTATUSUSB1PRESENT, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDeviceStatusUSB1PresentOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_DEVICESTATUSUSB2PRESENT, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDeviceStatusUSB2PresentOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_DEVICESTATUSNAVIAVAIL, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDeviceStatusNaviAvailOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_DEVICESTATUSUSB1SRC, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDeviceStatusUSB1SrcOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_DEVICESTATUSUSB2SRC, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDeviceStatusUSB2SrcOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_DEVICESTATUSAMFMAVAIL, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleDeviceStatusAMFMAvailOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_HUS_DM1_STATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleHUS_DM1_StatusOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_VEHICLENAVILATITUDE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleVehicleNaviLatitudeOpMStart)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_VEHICLENAVILONGITUDE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleVehicleNaviLongitudeOpMStart)
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: veda_tclServiceVehicle::
*             veda_tclServiceVehicle(veda_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
veda_tclServiceVehicle::veda_tclServiceVehicle(veda_tclAppMain* poMainAppl) : 
Iveda_tclServiceVehicle(poMainAppl, VEHICLE_SERVICE_ID, VEHICLE_FI_MAJOR_VERSION, VEHICLE_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("veda_tclServiceVehicle() entered."));
   _poCallbackIf = OSAL_NULL;

   _tSpeed_SpeedValue = 0;
   
   _tPartialMute_PartialMuteValue = 0;
   _tSwivMonAutoOpen_SwivMonAutoOpenValue = 0;
   _tDateMode_DateModeValue = 0;
   _tTmMode_TmModeValue = 0;
   //VIN
   _tVIN_VINValue = 0;
      //TimeDate
   _tTimeDate_TimeDateValue = 0;
   //PhoneCallCommand
   _tPhoneCallCmd_PhoneCallCmdValue=0xFF;
     //VolumeCmd
   _tVolumeCmd_VolumeCmdValue=0xFF;
   //ActCam8
   _tActCam8_ActCam8Value=0xFF;
    //ActCam9
   _tActCam9_ActCam9Value=0xFF;
   //ActCam10
   _tActCam10_ActCam10Value=0xFF;
    //ActCam11
   _tActCam11_ActCam11Value=0xFF;
    //ActCam12
   _tActCam12_ActCam12Value=0xFF;
    //ActCam13
   _tActCam13_ActCam13Value=0xFF;
   //ActCam14
   _tActCam14_ActCam14Value=0xFF;
    //ActCam15
   _tActCam15_ActCam15Value=0xFF;
   //ActCam16
   _tActCam16_ActCam16Value=0xFF;
    //ActCam17
   _tActCam17_ActCam17Value=0xFF;   
    //SourceCmd
   _tSourceCmd_SourceCmdValue=0xFF;   
        //RCNextBtn
   _tRCNextBtn_RCNextBtnValue=0xFF;
      //RCPrevBtn
   _tRCPrevBtn_RCPrevBtnValue=0xFF;
        //Track Cmd
   _tTrackCmd_TrackCmdValue=0xFF;
   //SMARTVR
   _tSMARTVR_SMARTVRValue=0xFF;
   //Tuner Cmd
   _tTunerCmd_TunerCmdValue=0xFF;
   //TA Cmd
   _tTACmd_TACmdValue=0xFF;
   //RDS Cmd
   _tRDSCmd_RDSCmdValue=0xFF;
   //Voice Recgn
   _tVoiceRecgCmd_VoiceRecgCmdValue=0x0F;
     //SW version 
   _tSWversion_SWversionValue=0xFFFFFFFF;    
   //TotalVehDistDiag
   _tTotalVehDistDiag_TotalVehDistDiagValue=0xFFFFFFFF;
   //Phone Pwr Command
   _tPhonePwrCmd_PhonePwrCmdValue=0xFF;
   //Radio Pwr Command
   _tRadioPwrCmd_RadioPwrCmdValue=0xFF;
   //Speed
   _tSpeed_SpeedValue=0;
   
   _tSpeedLimit_SpeedLimit1 = 0;
   _tSpeedLimit_SpeedLimit2 = 0;
   _tSpeedLimit_Display = 0;
   _tSpeedLimit_OverSpeed = FALSE;
   _tSpeedLimit_FreeSpeed = FALSE;
   _tReverseGear_State = 0;
   _tSpeedLock_State = 0;
   _tDrivingState_State = 0;
   _tNetworkState_u8BusState_MCAN = 0;
   _tNetworkState_u8BusState_VCAN = 0;
   _tNetworkState_u8MuteState_MCAN = 0;
   _tNetworkState_u8MuteState_VCAN = 0;
   _tNetworkState_bBusOff_MCAN = FALSE;
   _tNetworkState_bBusOff_VCAN = FALSE;
   _tNetworkState_bBusOff = FALSE;
   _tNetworkState_bMute_MCAN = FALSE;
   _tNetworkState_bMute_VCAN = FALSE;
   _tDistanceTotalizer_DisTotal = 0;
   _tDistanceTotalizer_lastValidDisTotal = 0;
   _tDistanceTotalizer_Unit = 0;
   _tDistanceTotalizer_DisTotalStatus = FALSE;
   _tMileage_Mileage = 0;
   _tAvgFuelEconomy_FuelEcon = 0;
   _tTirePressureSupport_PressureSupport = FALSE;
   _tTirePressureSetting_SettingPressureFront = 0;
   _tTirePressureSetting_SettingPressureRear = 0;
   _tSetOSPAlertsStatus_OSPAlert = FALSE;
   _tSetOSPAlertsStatus_DangerousAreaAlert = FALSE;

   // veda_tclServiceVehicleConstructor: user specific code start
   _tSpeed_SpeedValue = 0xFFFF; // Default Invalid value
   
   _tPartialMute_PartialMuteValue = 0xFF; // Default Invalid value
   _tSwivMonAutoOpen_SwivMonAutoOpenValue = 0xFF; // Default Invalid value
   _tDriverDoorOpen_DriverDoorOpenValue = 0xFF;
   _tDateMode_DateModeValue = 0xFF; // Default Invalid value
   _tTmMode_TmModeValue = 0xFF; // Default Invalid value
   //camera
   _tActCam1_ActCam1Value = 0x03; // Default Invalid value
   //camera2
   _tActCam2_ActCam2Value = 0x03; // Default Invalid value
   //camera3
   _tActCam3_ActCam3Value = 0x03; // Default Invalid value
   //camera4
   _tActCam4_ActCam4Value = 0x03; // Default Invalid value
   //camera5
   _tActCam5_ActCam5Value = 0x03; // Default Invalid value
   //camera6
   _tActCam6_ActCam6Value = 0x03; // Default Invalid value
   //camera7
   _tActCam7_ActCam7Value = 0x03; // Default Invalid value
   //camsplit
   _tCamSplitQuad_CamSplitQuadValue = 0xFFFF; // Default Invalid value
   //MuteDev
   _tMuteDev_MuteDevStatus = 0xFF; // Default Invalid value
   //sysVolt
   _tSysVolt_SysVoltStatus = 0x03; // Default Invalid value
   //ParkingBreakSwitch
   _tParkingBreakSwitch_ParkingBreakSwitchValue = 0x03; //Default Invalid value
   //RearCamReq
   _tRearCamReq_RearCamReqValue = 0x03; //Default Invalid value
   //VIN
   _tVIN_VINValue = 0xFFFFFFFF; // Default Invalid value
    //TimeDate
   _tTimeDate_TimeDateValue = 0xFFFFFFFFFFFFFFFF; // Default Invalid value
   //PhoneCallCommand
   _tPhoneCallCmd_PhoneCallCmdValue=0xFF;//Default invalid value
      //Phone Pwr Command
   _tPhonePwrCmd_PhonePwrCmdValue=0xFF; // default invalid value
    //Volumecmd
   _tVolumeCmd_VolumeCmdValue=0xFF;//Default invalid value
    //Sourcecmd
   _tSourceCmd_SourceCmdValue=0xFF;//Default invalid value 
   //CabinSourcecmd
   _tCabinSourceCmd_CabinSourceCmdValue=0xFF;//Default invalid value 
   //CabinVolumecmd
   _tCabinVolumeCmd_CabinVolumeCmdValue=0xFF;//Default invalid value
   //CabinTunercmd
   _tCabinTunerCmd_CabinTunerCmdValue=0xFF;//Default invalid value
   //CabinTrackcmd
   _tCabinTrackCmd_CabinTrackCmdValue=0xFF;//Default invalid value
   //CabinPlaylistcmd
   _tCabinPlaylistCmd_CabinPlaylistCmdValue=0xFF;//Default invalid value
   //RCNextBtn
   _tRCNextBtn_RCNextBtnValue=0xFF;//Default invalid value
     //RCPrevBtn
   _tRCPrevBtn_RCPrevBtnValue=0xFF;//Default invalid value
//   track cmd
   _tTrackCmd_TrackCmdValue=0xFF;//Default invalid value
   //Tuner cmd
   _tTunerCmd_TunerCmdValue=0xFF;//Default invalid value
   //TA cmd
   _tTACmd_TACmdValue=0xFF;//Default invalid value
   //RDS cmd
   _tRDSCmd_RDSCmdValue=0xFF;//Default invalid value
         //Radio Pwr Command
   _tRadioPwrCmd_RadioPwrCmdValue=0xFF; // default invalid value
   //System Language
	//CamTxt
   _tCamTxt_CamTxtValue = 0xFFFFFFFFFFFFFFFF; // Default Invalid value
   //VIN_64
   _tVIN_64_VIN_64Value = 0xFFFFFFFFFFFFFFFF; // Default Invalid value
   //PrivacyResetReq
   _tPrivacyResetReq_PrivacyResetReqValue = 0xFF; // Default Invalid value
   //Cam1ManAct
   _tCam1ManAct_RequestId = 0x03;
   //Cam2ManAct
   _tCam2ManAct_RequestId = 0x03;
   //Cam3ManAct
   _tCam3ManAct_RequestId = 0x03;
   //Cam4ManAct
   _tCam4ManAct_RequestId = 0x03;
   //Cam5ManAct
   _tCam5ManAct_RequestId = 0x03;
   //Cam6ManAct
   _tCam6ManAct_RequestId = 0x03;
   //Cam7ManAct
   _tCam7ManAct_RequestId = 0x03;
   //Cam8ManAct
   _tCam8ManAct_RequestId = 0x03;
   //Cam9ManAct
   _tCam9ManAct_RequestId = 0x03;
   //Cam10ManAct
   _tCam10ManAct_RequestId = 0x03;
   //Cam11ManAct
   _tCam11ManAct_RequestId = 0x03;
   //Cam12ManAct
   _tCam12ManAct_RequestId = 0x03;
   //Cam13ManAct
   _tCam13ManAct_RequestId = 0x03;
   //Cam14ManAct
   _tCam14ManAct_RequestId = 0x03;
   //Cam15ManAct
   _tCam15ManAct_RequestId = 0x03;
   //Cam16ManAct
   _tCam16ManAct_RequestId = 0x03;
   //Cam17ManAct
   _tCam17ManAct_RequestId = 0x03;
   //_tHUS_DM1_Status
   _tHUS_DM1_Status_HUS_DM1_StatusValue =0xFFFFFFFFFFFFFFFF;
   //PrivacyResetAck
   _tPrivacyResetAck_RequestId = 0xFF;
   //DispCamCls
   _tDispCamCls_RequestId = 0x03;
   //PhoneBTLinkStatus
   _tPhoneBTLinkStatus_BTLinkStatus = 0x0F;
   //PhoneBookSyncStatus
   _tPhoneBookSyncStatus_PhoneBookSyncStatusValue= 0x0F;
    //CallHistorySyncStatus
   _tCallHistorySyncStatus_CallHistorySyncStatusValue= 0x0F;
   //PhoneStatusRoaming
   _tPhoneStatusRoaming_PhoneStatusRoamingValue=0x0F;
   //CallDuration 
   _tCallDuration_CallDurationValue= 0xFFFF;
   //GSMSignalStrength
   _tGSMSignalStrength_GSMSignalStrengthValue=0x0F;
   //PhoneCallStatus
   _tPhoneCallStatus_CallStatusValue=0x0F;
   //PhoneBatteryLevelStatus
   _tPhoneBatteryLevelStatus_PhoneBatteryLevelStatusValue=0x0F;
   //DeviceStatusWifiAvailable
   _tDeviceStatusWifiAvailable_DeviceStatusWifiStatus=0x03;
   //MediaStatusAudioSource
   _tMediaStatusAudioSource_AudioSource=0x3F;
   //PhoneAvailableStatus
   _tPhoneAvailableStatus_PhoneAvailableStatusValue=0x03;
   //PhoneVRAvailable
   _tPhoneVRAvailable_PhoneVRAvailableValue=0x03;
   //DeviceStatusBTStatus
   _tDeviceStatusBTStatus_DeviceStatusBTStatusValue=0x03; 
   //DeviceStatusBluetoothAvail
   _tDeviceStatusBluetoothAvail_DeviceStatusBluetoothAvailValue=0x03; 
   //Req_DeviceInfo
   _tReq_DeviceInfo_Req_DeviceInfoValue=0x03;
   //MediaStatusVolume
   _tMediaStatusVolume_volume=0x3F;
   //CabinMediaStatusAudioSource
   _tCabinMediaStatusAudioSource_CabinAudioSource=0x3F;
   //CabinMediaStatusTunerBand
   _tCabinMediaStatusTunerBand_CabinTunerBand=0x3F;
   //CabinMediaStatusVolume
   _tCabinMediaStatusVolume_CabinVolume=0x3F;
   //MediaStatusMuteStatus
   _tMediaStatusMuteStatus_MediaStatusMuteValue=0x03;
   //CabinMediaStatusMuteStatus
   _tCabinMediaStatusMuteStatus_CabinMediaStatusMuteValue=0x03;
   //MediaStatusPlayStatus
   _tMediaStatusPlayStatus_MediaStatusPlayStatusValue=0x03;
  //MediaStatusSeekStatus
   _tMediaStatusSeekStatus_MediaStatusSeekStatusValue=0x03;
    //MediaStatusRepeatStatus
   _tMediaStatusRepeatStatus_MediaStatusRepeatStatusValue=0x03;
   //MediaStatusDABFMStatus
   _tMediaStatusDABFMStatus_MediaStatusDABFMStatusValue=0x03;
   //VehicleNaviLatitude
   _tVehicleNaviLatitude_VehicleNaviLatitudeValue=0xFFFFFFFF;
   //VehicleNaviLongitude
   _tVehicleNaviLongitude_VehicleNaviLongitudeValue=0xFFFFFFFF;
   //MediaStatusTREGStatus
   _tMediaStatusTREGStatus_MediaStatusTREGStatusValue=0x03; 
   //MediaStatusTREGRTMStatus
   _tMediaStatusTREGRTMStatus_MediaStatusTREGRTMStatusValue=0x03;
  //MediaStatusRDSStatus
   _tMediaStatusRDSStatus_MediaStatusRDSStatusValue=0x03;
  //MediaStatusTAStatus
   _tMediaStatusTAStatus_MediaStatusTAStatusValue=0x03;
   //MediaStatusTPStatus
   _tMediaStatusTPStatus_MediaStatusTPStatusValue=0x03;
  //MediaStatusTunerBandStatus
   _tMediaStatusTunerBandStatus_MediaStatusTunerBandStatusValue=0x03;
   //MediaStatusTunerPresetStatus
   _tMediaStatusTunerPresetStatus_MediaStatusTunerPresetStatusValue=0x03;
    //MediaStatusMixState
   _tMediaStatusMixState_MediaStatusMixStateValue=0x0F;
    //MediaStatusPlaylistMode
   _tMediaStatusPlaylistMode_MediaStatusPlaylistModeValue=0x03;
   //MediaStatusTrackTime
   _tMediaStatusTrackTime_MediaStatusTrackTimeValue=0xFFFF;
   //MediaStatusCurrTrackNum
   _tMediaStatusCurrTrackNum_MediaStatusCurrTrackNumValue=0xFFFF;
   //DeviceStatusRadioStatus
   _tDeviceStatusRadioStatus_DeviceStatusRadioStatusValue=0x03;
   //DeviceStatusDABAvailStatus
   _tDeviceStatusDABAvailStatus_DeviceStatusDABAvailStatusValue=0x03;
   //DeviceStatusNavData
   _tDeviceStatusNavData_DeviceStatusNavDataValue=0x03;
   //DeviceStatusUSB1Present
   _tDeviceStatusUSB1Present_DeviceStatusUSB1PresentValue=0x03;
   //DeviceStatusUSB2Present
   _tDeviceStatusUSB2Present_DeviceStatusUSB2PresentValue=0x03;
   //DeviceStatusNaviAvail
   _tDeviceStatusNaviAvail_DeviceStatusNaviAvailValue=0x03;
   //DeviceStatusUSB1Src
   _tDeviceStatusUSB1Src_DeviceStatusUSB1SrcValue=0x03;
   //DeviceStatusUSB2Src
   _tDeviceStatusUSB2Src_DeviceStatusUSB2SrcValue=0x03;
   //DeviceStatusAMFMAvail
   _tDeviceStatusAMFMAvail_DeviceStatusAMFMAvailValue=0x03;
   _tHandBrake_e8Status.enType = vehicle_fi_tcl_e8_Vehicle_HandBrakeStatus::FI_EN_UNKNOWN;
   _tDistanceUnit_e8DistanceUnit.enType = vehicle_fi_tcl_e8_Vehicle_DistanceUnit::FI_EN_UNKNOWN;
   _tSpeedLimit_DisplayUnit.enType = vehicle_fi_tcl_e8_Vehicle_DistanceUnit::FI_EN_UNKNOWN;
   _tFuelConsumptionUnit_e8FuelConsumpUnit.enType = vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit::FI_EN_UNKNOWN;
   _tTemperatureUnit_e8TempUnit.enType = vehicle_fi_tcl_e8_Vehicle_TemperatureUnit::FI_EN_UNKNOWN;

   m_bISAConfigured = FALSE;
   m_bTrafficSignConfigured = FALSE;

   _tNetworkState_Listu8AbsentState_ECU.clear();
   _tNetworkState_Listu8MuteStateMCAN_Channel.clear();
   // veda_tclServiceVehicleConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: veda_tclServiceVehicle::
*             ~veda_tclServiceVehicle(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
veda_tclServiceVehicle::~veda_tclServiceVehicle(tVoid)
{
   ETG_TRACE_USR4(("~veda_tclServiceVehicle() entered."));
   _poCallbackIf = OSAL_NULL;
   
   // veda_tclServiceVehicleDestructor: user specific code start
   // veda_tclServiceVehicleDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid veda_tclServiceVehicle::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'veda_ServiceVehicle.h':
*     Add forward declaration:
*         class Ivehicledata_tclObject2Get;
*
*     Add declaration of object reference:
*         Ivehicledata_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ivehicledata_tclObject2Get*>(_cpoMain->getHandler("Ivehicledata_tclObject2Get"));
*     VEHICLE_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid veda_tclServiceVehicle::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("veda_tclServiceVehicle::vGetReferences() entered."));
   // veda_tclServiceVehiclevGetReferences: user specific code start
   // veda_tclServiceVehiclevGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid veda_tclServiceVehicle::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid veda_tclServiceVehicle::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("veda_tclServiceVehicle::vStartCommunication() entered."));
   // veda_tclServiceVehiclevStartCommunication: user specific code start
   _vInitializeLangSourceTableList();
   _vReadLastModeLanguageSettings();
   vReadDefaultUnitSettings();

   tU8 u8ISAConfigured = 0x00;
   if ( DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation", "IntelligentSpeedAssist", &u8ISAConfigured, 1) )
   {
      // ISA Configured
      if ( 0x01 == u8ISAConfigured )
      {
          m_bISAConfigured = TRUE;
          _tSpeedLimit_OverSpeed = FALSE;
          _tSpeedLimit_FreeSpeed = FALSE;
      }
   }

   tU8 u8TrafficSignConfigured = 0x00;
   if ( DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation", "TrafficSignRecognition", &u8TrafficSignConfigured, 1) )
   {
      if ( 0x01 == u8TrafficSignConfigured ) // Only if TSR is configured
      {
          m_bTrafficSignConfigured = TRUE;
      }
   }
   // veda_tclServiceVehiclevStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid veda_tclServiceVehicle::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   veda_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid veda_tclServiceVehicle::vHandleMessage(veda_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("veda_tclServiceVehicle::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(veda_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // veda_tclServiceVehiclevHandleMessage: user specific code start
   switch(pMsg->eCmd)
   {
      case eDefaultSetting:
      {
         vSetDefaultUnitSettings();
      }
      break;
      default:
         break;

   }
   // veda_tclServiceVehiclevHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid veda_tclServiceVehicle::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid veda_tclServiceVehicle::vHandleTraceMessage(const tUChar* puchData)
{
   VEDA_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("veda_tclServiceVehicle::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // veda_tclServiceVehiclevHandleTraceMessage: user specific code start
   switch(u32MsgCode)
   {
   case VEHICLEDATA_VEDA_DISTANCEUNIT_INPUT:
   {
       // Input the Distance Unit input from HMI System
       tU8 u8DistanceUnit = puchData[3];
       _tDistanceUnit_e8DistanceUnit.enType = static_cast<vehicle_fi_tcl_e8_Vehicle_DistanceUnit::tenType>(u8DistanceUnit);
       eUpdateClients(VEHICLE_MAINFI_C_U16_DISTANCEUNIT);
   }
   break;

   case VEHICLEDATA_VEDA_FUELCONSUMPTIONUNIT_INPUT:
   {
       // Input the FuelConsumption Unit input from HMI System
       tU8 u8FuelCnsmpUnit = puchData[3];

       _tFuelConsumptionUnit_e8FuelConsumpUnit.enType = static_cast<vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit::tenType>(u8FuelCnsmpUnit);
       eUpdateClients(VEHICLE_MAINFI_C_U16_FUELCONSUMPTIONUNIT);
   }
   break;

   case VEHICLEDATA_VEDA_TEMPERATUREUNIT_INPUT:
   {
       // Input the Temperature Unit input from HMI System
       tU8 u8TempUnit = puchData[3];

       _tTemperatureUnit_e8TempUnit.enType = static_cast<vehicle_fi_tcl_e8_Vehicle_TemperatureUnit::tenType>(u8TempUnit);
       eUpdateClients(VEHICLE_MAINFI_C_U16_TEMPERATUREUNIT);
   }
   break;

   default:
       break;
   }
   // veda_tclServiceVehiclevHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid veda_tclServiceVehicle::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid veda_tclServiceVehicle::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      DistanceUnit (VEHICLE_MAINFI_C_U16_DISTANCEUNIT) -> Opcode: UpReg, RelUpReg, Get, Set, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      FuelConsumptionUnit (VEHICLE_MAINFI_C_U16_FUELCONSUMPTIONUNIT) -> Opcode: UpReg, RelUpReg, Get, Set, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      TemperatureUnit (VEHICLE_MAINFI_C_U16_TEMPERATUREUNIT) -> Opcode: UpReg, RelUpReg, Get, Set, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      Language (VEHICLE_MAINFI_C_U16_LANGUAGE) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      LanguageSyncSource (VEHICLE_MAINFI_C_U16_LANGUAGESYNCSOURCE) -> Opcode: UpReg, RelUpReg, Get, Set, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      MeterLanguageKnowledge (VEHICLE_MAINFI_C_U16_METERLANGUAGEKNOWLEDGE) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      HandBrake (VEHICLE_MAINFI_C_U16_HANDBRAKE) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      Ignition (VEHICLE_MAINFI_C_U16_IGNITION) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      Speed (VEHICLE_MAINFI_C_U16_SPEED) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      SpeedLimit (VEHICLE_MAINFI_C_U16_SPEEDLIMIT) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      ReverseGear (VEHICLE_MAINFI_C_U16_REVERSEGEAR) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      SpeedLock (VEHICLE_MAINFI_C_U16_SPEEDLOCK) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DrivingState (VEHICLE_MAINFI_C_U16_DRIVINGSTATE) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      GlobalVehicleWarningState (VEHICLE_MAINFI_C_U16_GLOBALVEHICLEWARNINGSTATE) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      VehicleStates (VEHICLE_MAINFI_C_U16_VEHICLESTATES) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      NetworkState (VEHICLE_MAINFI_C_U16_NETWORKSTATE) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DistanceTotalizer (VEHICLE_MAINFI_C_U16_DISTANCETOTALIZER) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      Mileage (VEHICLE_MAINFI_C_U16_MILEAGE) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      AvgFuelEconomy (VEHICLE_MAINFI_C_U16_AVGFUELECONOMY) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      TirePressureSupport (VEHICLE_MAINFI_C_U16_TIREPRESSURESUPPORT) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      TPMSResetSupport (VEHICLE_MAINFI_C_U16_TPMSRESETSUPPORT) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      TirePressureSetting (VEHICLE_MAINFI_C_U16_TIREPRESSURESETTING) -> Opcode: UpReg, RelUpReg, Get, Set, Status, Error, "));
   ETG_TRACE_FATAL(("Method   support:      SetLanguage (VEHICLE_MAINFI_C_U16_SETLANGUAGE) -> Opcode: MethodStart, MethodResult, "));
   ETG_TRACE_FATAL(("Method   support:      RequestMeterLanguageSync (VEHICLE_MAINFI_C_U16_REQUESTMETERLANGUAGESYNC) -> Opcode: MethodStart, MethodResult, "));
   ETG_TRACE_FATAL(("Method   support:      CSMEngineeringData (VEHICLE_MAINFI_C_U16_CSMENGINEERINGDATA) -> Opcode: MethodStart, MethodResult, "));
   ETG_TRACE_FATAL(("Method   support:      SetOSPAlertsStatus (VEHICLE_MAINFI_C_U16_SETOSPALERTSSTATUS) -> Opcode: MethodStart, MethodResult, "));

   // veda_tclServiceVehiclevTraceInfo: user specific code start
   // veda_tclServiceVehiclevTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid veda_tclServiceVehicle::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid veda_tclServiceVehicle::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // veda_tclServiceVehiclevOnServiceAvailable: user specific code start
   // veda_tclServiceVehiclevOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid veda_tclServiceVehicle::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid veda_tclServiceVehicle::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // veda_tclServiceVehiclevOnServiceUnavailable: user specific code start
   // veda_tclServiceVehiclevOnServiceUnavailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tBool veda_tclServiceVehicle
*                 ::bStatusMessageFactory(tU16 u16FunctionId,
*                                         amt_tclServiceData& roOutMsg,
*                                         amt_tclServiceData* poInMsg)
*
* DESCRIPTION: This function is called by the CCA framework to request ANY
*              property which is offered by this service. For each property
*              accessed via parameter 'u16FunctionId' the user has to prepare
*              the corresponding FI data object which is then copied to the
*              referenced parameter 'roOutMsg'.
*
* PARAMETER: [IN] u16FunctionId = Function ID of the requested property.
*            [OUT] roOutMsg = Reference to the service data object to which the
*                             content of the prepared FI data object should be
*                             copied to.
*            [IN] poInMsg = Selector message which is used to select dedicated
*                           content to be copied to 'roOutMsg' instead of
*                           updating the entire FI data object.
*
* RETURNVALUE: TRUE = Status message for property successfully generated.
*              FALSE = Failed to generate status message for property.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bStatusMessageFactory().
*******************************************************************************/
tBool veda_tclServiceVehicle
::bStatusMessageFactory(tU16 u16FunctionId,
                        amt_tclServiceData& roOutMsg,
                        amt_tclServiceData* poInMsg)
{
   (tVoid)poInMsg;   // These lines are added to avoid LINT warnings. Please
   (tVoid)roOutMsg;  // remove as soon as variables are used.

   tBool bSuccess = FALSE;

   ETG_TRACE_USR4(("veda_tclServiceVehicle:bStatusMessageFactory() entered. FID = 0x%04x.", u16FunctionId));

   switch (u16FunctionId)
   {
   case VEHICLE_MAINFI_C_U16_DISTANCEUNIT:
      {
         vehicle_mainfi_tclMsgDistanceUnitStatus oStatus;

         oStatus.e8DistanceUnit = _tDistanceUnit_e8DistanceUnit;

         // CaseDistanceUnitStatus_Pre: user specific code start
         // CaseDistanceUnitStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         // CaseDistanceUnitStatus: user specific code start
         // CaseDistanceUnitStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case VEHICLE_MAINFI_C_U16_FUELCONSUMPTIONUNIT:
      {
         vehicle_mainfi_tclMsgFuelConsumptionUnitStatus oStatus;

         oStatus.e8FuelConsumpUnit = _tFuelConsumptionUnit_e8FuelConsumpUnit;

         // CaseFuelConsumptionUnitStatus_Pre: user specific code start
         // CaseFuelConsumptionUnitStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         // CaseFuelConsumptionUnitStatus: user specific code start
         // CaseFuelConsumptionUnitStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case VEHICLE_MAINFI_C_U16_TEMPERATUREUNIT:
      {
         vehicle_mainfi_tclMsgTemperatureUnitStatus oStatus;

         oStatus.e8TempUnit = _tTemperatureUnit_e8TempUnit;

         // CaseTemperatureUnitStatus_Pre: user specific code start
         // CaseTemperatureUnitStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         // CaseTemperatureUnitStatus: user specific code start
         // CaseTemperatureUnitStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case VEHICLE_MAINFI_C_U16_LANGUAGE:
      {
         vehicle_mainfi_tclMsgLanguageStatus oStatus;

         oStatus.Language = _tLanguage_Language;
         oStatus.LangTable = _tLanguage_LangTable;
		 ETG_TRACE_USR4(("Language update sent as %d", _tLanguage_Language.enType))

         // CaseLanguageStatus_Pre: user specific code start
         // CaseLanguageStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         // CaseLanguageStatus: user specific code start
         // CaseLanguageStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case VEHICLE_MAINFI_C_U16_LANGUAGESYNCSOURCE:
      {
         vehicle_mainfi_tclMsgLanguageSyncSourceStatus oStatus;

         oStatus.Language = _tLanguageSyncSource_Language;

         // CaseLanguageSyncSourceStatus_Pre: user specific code start
         // CaseLanguageSyncSourceStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         // CaseLanguageSyncSourceStatus: user specific code start
         // CaseLanguageSyncSourceStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case VEHICLE_MAINFI_C_U16_METERLANGUAGEKNOWLEDGE:
      {
         vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus oStatus;

         oStatus.State = _tMeterLanguageKnowledge_State;

         // CaseMeterLanguageKnowledgeStatus_Pre: user specific code start
         // CaseMeterLanguageKnowledgeStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         // CaseMeterLanguageKnowledgeStatus: user specific code start
         // CaseMeterLanguageKnowledgeStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case VEHICLE_MAINFI_C_U16_HANDBRAKE:
      {
         vehicle_mainfi_tclMsgHandBrakeStatus oStatus;

         oStatus.e8Status = _tHandBrake_e8Status;

         // CaseHandBrakeStatus_Pre: user specific code start
         // CaseHandBrakeStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         // CaseHandBrakeStatus: user specific code start
         // CaseHandBrakeStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case VEHICLE_MAINFI_C_U16_IGNITION:
      {
         vehicle_mainfi_tclMsgIgnitionStatus oStatus;

         oStatus.e8Status = _tIgnition_e8Status;

         // CaseIgnitionStatus_Pre: user specific code start
         // CaseIgnitionStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         // CaseIgnitionStatus: user specific code start
         // CaseIgnitionStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
	  //Speed value status message handover
   case VEHICLE_MAINFI_C_U16_SPEED:
      {
         vehicle_mainfi_tclMsgSpeedStatus oStatus;

         oStatus.SpeedValue = _tSpeed_SpeedValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("Speed Status update sent as %d.%02d km/hr", _tSpeed_SpeedValue/100, _tSpeed_SpeedValue%100));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
	  //Partial mute value status message handover
	   case VEHICLE_MAINFI_C_U16_PARTIALMUTE:
      {
         vehicle_mainfi_tclMsgPartialMuteStatus oStatus;

         oStatus.PartialMuteValue = _tPartialMute_PartialMuteValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("Mute Status update sent as %d", _tPartialMute_PartialMuteValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
	  break;
	  //SWIV Monitor status message handover
	   case VEHICLE_MAINFI_C_U16_SWIVMONAUTOOPEN:
      {
         vehicle_mainfi_tclMsgSwivMonAutoOpenStatus oStatus;

         oStatus.SwivMonAutoOpenValue = _tSwivMonAutoOpen_SwivMonAutoOpenValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("SwivMonAutoOpen Status update sent as %d", _tSwivMonAutoOpen_SwivMonAutoOpenValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
	  break;
          case VEHICLE_MAINFI_C_U16_DRIVERDOOROPEN:
      {
	 vehicle_mainfi_tclMsgDriverDoorOpenStatus oStatus;

	 oStatus.DriverDoorOpenValue = _tDriverDoorOpen_DriverDoorOpenValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("DriverDoorOpen Status update sent as %d", _tDriverDoorOpen_DriverDoorOpenValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
	  break;
	  //Current Date mode value status message handover
	   case VEHICLE_MAINFI_C_U16_DATEMODE:
      {
         vehicle_mainfi_tclMsgDateModeStatus oStatus;

         oStatus.DateModeValue = _tDateMode_DateModeValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);
		 
         ETG_TRACE_USR4(("Date Status update sent as %d", _tDateMode_DateModeValue));
         // CaseSpeedStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
	  break;
	  //Current Time mode value status message handover
	   case VEHICLE_MAINFI_C_U16_TMMODE:
      {
         vehicle_mainfi_tclMsgTmModeStatus oStatus;

         oStatus.TmModeValue = _tTmMode_TmModeValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("Time Status update sent as %d", _tTmMode_TmModeValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
	  break;
	 //Current Date Time  value status message handover
	   case VEHICLE_MAINFI_C_U16_TIMEDATE:
      {
         vehicle_mainfi_tclMsgTimeDateStatus oStatus;

         oStatus.TimeDateValue = _tTimeDate_TimeDateValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("Time Date Status update sent as %d", _tTimeDate_TimeDateValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	  
	  break;
	  	 //PhoneCallCommand  value status message handover
	   case VEHICLE_MAINFI_C_U16_PHONECALLCOMMAND:
      {

         vehicle_mainfi_tclMsgPhoneCallCommandStatus oStatus;

         oStatus.PhoneCallCommandValue = _tPhoneCallCmd_PhoneCallCmdValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("PhoneCallCommand Status update sent as %d", _tPhoneCallCmd_PhoneCallCmdValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
		 
 
      }	  
	  break;
	  	  	 //PhonePwrCmd  value status message handover
	   case VEHICLE_MAINFI_C_U16_PHONEPWRCMD:
      {
         vehicle_mainfi_tclMsgPhonePwrCmdStatus oStatus;

         oStatus.PhonePwrCmdValue = _tPhonePwrCmd_PhonePwrCmdValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("PhonePwrCmd Status update sent as %d", _tPhonePwrCmd_PhonePwrCmdValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	  
	  break;
	  	//RadioPwrCmd  value status message handover
	   case VEHICLE_MAINFI_C_U16_RADIOPWRCMD:
      {
         vehicle_mainfi_tclMsgRadioPwrCmdStatus oStatus;

         oStatus.RadioPwrCmdValue = _tRadioPwrCmd_RadioPwrCmdValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("RadioPwrCmd Status update sent as %d", _tRadioPwrCmd_RadioPwrCmdValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	  
	  break;
	  	  	 //VolumeCommand  value status message handover
	   case VEHICLE_MAINFI_C_U16_VOLUMECOMMAND:
      {
         vehicle_mainfi_tclMsgVolumeCommandStatus oStatus;

         oStatus.VolumeCommandValue = _tVolumeCmd_VolumeCmdValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("Volume Status update sent as %d", _tVolumeCmd_VolumeCmdValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	
	  break;
	  	  	  	 //RCNextBtn  value status message handover
	   case VEHICLE_MAINFI_C_U16_RCNEXTBTN:
      {
         vehicle_mainfi_tclMsgRCNextBtnStatus oStatus;

         oStatus.RCNextBtnValue = _tRCNextBtn_RCNextBtnValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("RC Next Btn Status update sent as %d", _tRCNextBtn_RCNextBtnValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	
	  break;
	  	  	  	 //RCPrevBtn  value status message handover
	   case VEHICLE_MAINFI_C_U16_RCPREVBTN:
      {
         vehicle_mainfi_tclMsgRCPrevBtnStatus oStatus;

         oStatus.RCPrevBtnValue = _tRCPrevBtn_RCPrevBtnValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("RC Prev Btn Status update sent as %d", _tRCPrevBtn_RCPrevBtnValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	
	  break;
	  	  	  	 //TrackCommand  value status message handover
	   case VEHICLE_MAINFI_C_U16_TRACKCOMMAND:
      {
         vehicle_mainfi_tclMsgTrackCommandStatus oStatus;

         oStatus.TrackCommandValue = _tTrackCmd_TrackCmdValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("Track cmd Status update sent as %d", _tTrackCmd_TrackCmdValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	
	  break;
	  	  	 //Voice RecgCommand value status message handover
	  case VEHICLE_MAINFI_C_U16_VOICERECGCOMMAND:
      {
         vehicle_mainfi_tclMsgVoiceRecgCommandStatus oStatus;

         oStatus.VoiceRecgCommandValue = _tVoiceRecgCmd_VoiceRecgCmdValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("Voice Recgn Status update sent as %d", _tVoiceRecgCmd_VoiceRecgCmdValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }		  
	  break;
	 	//SW Version value status message handover
	case VEHICLE_MAINFI_C_U16_DEVICEINFOSWVERSION:
      {
         vehicle_mainfi_tclMsgDeviceInfoSWversionStatus oStatus;

         oStatus.SWversionValue = _tSWversion_SWversionValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("SW version Status update sent as %d", _tSWversion_SWversionValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	  
	  break;
	  //camera
	   case VEHICLE_MAINFI_C_U16_ACTCAM1:
      {
         vehicle_mainfi_tclMsgActCam1Status oStatus;

         oStatus.ActCam1Value = _tActCam1_ActCam1Value;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("Camera1 Status update sent as %d", _tActCam1_ActCam1Value));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      } 
	  break;
	  //camera2
	   case VEHICLE_MAINFI_C_U16_ACTCAM2:
      {
         vehicle_mainfi_tclMsgActCam2Status oStatus;

         oStatus.ActCam2Value = _tActCam2_ActCam2Value;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("Camera2 Status update sent as %d", _tActCam2_ActCam2Value));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      } 
	  break;
	 //camera3
	   case VEHICLE_MAINFI_C_U16_ACTCAM3:
      {
         vehicle_mainfi_tclMsgActCam3Status oStatus;

         oStatus.ActCam3Value = _tActCam3_ActCam3Value;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("Camera3 Status update sent as %d", _tActCam3_ActCam3Value));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      } 
	  break; 
	  //camera4
	   case VEHICLE_MAINFI_C_U16_ACTCAM4:
      {
         vehicle_mainfi_tclMsgActCam4Status oStatus;

         oStatus.ActCam4Value = _tActCam4_ActCam4Value;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("Camera4 Status update sent as %d", _tActCam4_ActCam4Value));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      } 
	  break; 
	  //camera5
	   case VEHICLE_MAINFI_C_U16_ACTCAM5:
      {
         vehicle_mainfi_tclMsgActCam5Status oStatus;

         oStatus.ActCam5Value = _tActCam5_ActCam5Value;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("Camera5 Status update sent as %d", _tActCam5_ActCam5Value));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      } 
	  break; 
	    //camera6
	   case VEHICLE_MAINFI_C_U16_ACTCAM6:
      {
         vehicle_mainfi_tclMsgActCam6Status oStatus;

         oStatus.ActCam6Value = _tActCam6_ActCam6Value;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("Camera6 Status update sent as %d", _tActCam6_ActCam6Value));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      } 
	  break;
	    //camera7
	   case VEHICLE_MAINFI_C_U16_ACTCAM7:
      {
         vehicle_mainfi_tclMsgActCam7Status oStatus;

         oStatus.ActCam7Value = _tActCam7_ActCam7Value;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("Camera7 Status update sent as %d", _tActCam7_ActCam7Value));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      } 
	  break;
	  //camsplit
	   case VEHICLE_MAINFI_C_U16_CAMSPLITQUAD:
      {
         vehicle_mainfi_tclMsgCamSplitQuadStatus oStatus;

         oStatus.CamSplitQuadValue = _tCamSplitQuad_CamSplitQuadValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("Camsplit Status update sent as %d", _tCamSplitQuad_CamSplitQuadValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      } 
	  break;
	  //MuteDev
	   case VEHICLE_MAINFI_C_U16_MUTEDEV:
      {
         vehicle_mainfi_tclMsgMuteDevStatus oStatus;

         oStatus.MuteDevStatus = _tMuteDev_MuteDevStatus;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("Mute Status update sent as %d", _tMuteDev_MuteDevStatus));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
	  break;
	  //sysVolt status message handover
	   case VEHICLE_MAINFI_C_U16_SYSVOLT:
      {
         vehicle_mainfi_tclMsgSysVoltStatus oStatus;

         oStatus.SysVoltStatus = _tSysVolt_SysVoltStatus;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("sysVolt Status update sent as %d", _tSysVolt_SysVoltStatus));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
	  break;
	  //camtxt status message handover:
	  case VEHICLE_MAINFI_C_U16_CAMTXT:
	  {
         vehicle_mainfi_tclMsgCamTxtStatus oStatus;

         oStatus.CamTxtValue = _tCamTxt_CamTxtValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("CamTxt Status update sent as %d", _tCamTxt_CamTxtValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
	  break;
	  //ParkingBreakSwitch status message handover
	  case VEHICLE_MAINFI_C_U16_PARKINGBREAKSWITCH:
      {
         vehicle_mainfi_tclMsgParkingBreakSwitchStatus oStatus;

         oStatus.ParkingBreakSwitchValue = _tParkingBreakSwitch_ParkingBreakSwitchValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("ParkingBreakSwitch value update sent as %d", _tParkingBreakSwitch_ParkingBreakSwitchValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
	  break;
	  //RearCamReq status message handover
	  case VEHICLE_MAINFI_C_U16_REARCAMREQ:
      {
         vehicle_mainfi_tclMsgRearCamReqStatus oStatus;

         oStatus.RearCamReqValue = _tRearCamReq_RearCamReqValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("RearCamReq value update sent as %d", _tRearCamReq_RearCamReqValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
	  break;
	  //VIN
	   case VEHICLE_MAINFI_C_U16_VIN:
      {
         vehicle_mainfi_tclMsgVINStatus oStatus;

         oStatus.VINValue = _tVIN_VINValue;

         // CaseSpeedStatus_Pre: user specific code start
         // CaseSpeedStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         // CaseSpeedStatus: user specific code start
         ETG_TRACE_USR4(("Time Status update sent as %d", _tVIN_VINValue));
         // CaseSpeedStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
	  
	  break;
	  //PrivacyResetReq
	   case VEHICLE_MAINFI_C_U16_PRIVACYRESETREQUEST:
      {
         vehicle_mainfi_tclMsgPrivacyResetRequestStatus oStatus;

         oStatus.PrivacyResetRequestValue = _tPrivacyResetReq_PrivacyResetReqValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("PrivacyResetReq Status update sent as %d", _tPrivacyResetReq_PrivacyResetReqValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      } 
	  break;
	  //SourceCommand  value status message handover
	   case VEHICLE_MAINFI_C_U16_SOURCECOMMAND:
      {
         vehicle_mainfi_tclMsgSourceCommandStatus oStatus;

         oStatus.SourceCommandValue = _tSourceCmd_SourceCmdValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("Source Status update sent as %d", _tSourceCmd_SourceCmdValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	
	  break;
			//TunerCommand  value status message handover
	   case VEHICLE_MAINFI_C_U16_TUNERCOMMAND:
      {
         vehicle_mainfi_tclMsgTunerCommandStatus oStatus;

         oStatus.TunerCommandValue = _tTunerCmd_TunerCmdValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("Tuner cmd Status update sent as %d", _tTunerCmd_TunerCmdValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	
	  break;
	  
	  //TACommand  value status message handover
	   case VEHICLE_MAINFI_C_U16_TACOMMAND:
      {
         vehicle_mainfi_tclMsgTACommandStatus oStatus;

         oStatus.TACommandValue = _tTACmd_TACmdValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("TA cmd Status update sent as %d", _tTACmd_TACmdValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	
	  break;
			//RDSCommand  value status message handover
	   case VEHICLE_MAINFI_C_U16_RDSCOMMAND:
      {
         vehicle_mainfi_tclMsgRDSCommandStatus oStatus;

         oStatus.RDSCommandValue = _tRDSCmd_RDSCmdValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("RDS cmd Status update sent as %d", _tRDSCmd_RDSCmdValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	
	  break;
	  			//Cam8  value status message handover
	   case VEHICLE_MAINFI_C_U16_ACTCAM8:
      {
         vehicle_mainfi_tclMsgActCam8Status oStatus;

         oStatus.ActCam8Value = _tActCam8_ActCam8Value;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("ActCam8 Status update sent as %d", _tActCam8_ActCam8Value));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	
	  break;
	  	  			//Cam9  value status message handover
	   case VEHICLE_MAINFI_C_U16_ACTCAM9:
      {
         vehicle_mainfi_tclMsgActCam9Status oStatus;

         oStatus.ActCam9Value = _tActCam9_ActCam9Value;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("ActCam9 Status update sent as %d", _tActCam9_ActCam9Value));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	
	  break;
	  
	  	  	  			//Cam10 value status message handover
	   case VEHICLE_MAINFI_C_U16_ACTCAM10:
      {
         vehicle_mainfi_tclMsgActCam10Status oStatus;

         oStatus.ActCam10Value = _tActCam10_ActCam10Value;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("ActCam10 Status update sent as %d", _tActCam10_ActCam10Value));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	
	  break;
	  	  	  	  			//Cam11 value status message handover
	   case VEHICLE_MAINFI_C_U16_ACTCAM11:
      {
         vehicle_mainfi_tclMsgActCam11Status oStatus;

         oStatus.ActCam11Value = _tActCam11_ActCam11Value;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("ActCam11 Status update sent as %d", _tActCam11_ActCam11Value));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	
	  break;
	  	  	  	  	  			//Cam12 value status message handover
	   case VEHICLE_MAINFI_C_U16_ACTCAM12:
      {
         vehicle_mainfi_tclMsgActCam12Status oStatus;

         oStatus.ActCam12Value = _tActCam12_ActCam12Value;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("ActCam12 Status update sent as %d", _tActCam12_ActCam12Value));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	
	  break;
	  	  	  	  	  	  			//Cam13 value status message handover
	   case VEHICLE_MAINFI_C_U16_ACTCAM13:
      {
         vehicle_mainfi_tclMsgActCam13Status oStatus;

         oStatus.ActCam13Value = _tActCam13_ActCam13Value;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("ActCam13 Status update sent as %d", _tActCam13_ActCam13Value));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	
	  break;
	  	  	  	  	  	  //Cam14 value status message handover
	   case VEHICLE_MAINFI_C_U16_ACTCAM14:
      {
         vehicle_mainfi_tclMsgActCam14Status oStatus;

         oStatus.ActCam14Value = _tActCam14_ActCam14Value;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("ActCam14 Status update sent as %d", _tActCam14_ActCam14Value));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	
	  break;
	  
	  	  	  	  	  	  	  //Cam15 value status message handover
	   case VEHICLE_MAINFI_C_U16_ACTCAM15:
      {
         vehicle_mainfi_tclMsgActCam15Status oStatus;

         oStatus.ActCam15Value = _tActCam15_ActCam15Value;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("ActCam15 Status update sent as %d", _tActCam15_ActCam15Value));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	
	  break;
	  	  	  	  	  	  	  	  //Cam16 value status message handover
	   case VEHICLE_MAINFI_C_U16_ACTCAM16:
      {
         vehicle_mainfi_tclMsgActCam16Status oStatus;

         oStatus.ActCam16Value = _tActCam16_ActCam16Value;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("ActCam16 Status update sent as %d", _tActCam16_ActCam16Value));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	
	  break;
	  	  	  	  	  	  	  	  	  //Cam17 value status message handover
	   case VEHICLE_MAINFI_C_U16_ACTCAM17:
      {
         vehicle_mainfi_tclMsgActCam17Status oStatus;

         oStatus.ActCam17Value = _tActCam17_ActCam17Value;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("ActCam17 Status update sent as %d", _tActCam17_ActCam17Value));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	
	  break;
	  
 
	  	  	  	  	  	  	  	  	  	  //SMARTVR value status message handover
	   case VEHICLE_MAINFI_C_U16_SMARTVR:
      {
         vehicle_mainfi_tclMsgSMARTVRStatus oStatus;

         oStatus.SMARTVRValue = _tSMARTVR_SMARTVRValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("SMARTVR Status update sent as %d", _tSMARTVR_SMARTVRValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	
	  break;

	  	  	  	  	  	  	  	  	  	  //TotalVehDistDiag value status message handover
	   case VEHICLE_MAINFI_C_U16_TOTALVEHDISTDIAG:
      {
         vehicle_mainfi_tclMsgTotalVehDistDiagStatus oStatus;

         oStatus.TotalVehDistDiagValue = _tTotalVehDistDiag_TotalVehDistDiagValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("TotalVehDistDiag Status update sent as %d", _tTotalVehDistDiag_TotalVehDistDiagValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	
	  break;	  
	  //VIN_64 value status message handover
	   case VEHICLE_MAINFI_C_U16_VIN_64:
      {
         vehicle_mainfi_tclMsgVIN_64Status oStatus;

         oStatus.VIN_64Value = _tVIN_64_VIN_64Value;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("VIN_64 Status update sent as %d", _tVIN_64_VIN_64Value));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	
	  break;

	  	  //CabinMediaSourceCommand value status message handover
	   case VEHICLE_MAINFI_C_U16_CABINMEDIASOURCECOMMAND:
      {
         vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus oStatus;

         oStatus.CabinMediaSourceCommandValue = _tCabinSourceCmd_CabinSourceCmdValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("CabinMediaSourceCommand Status update sent as %d", _tCabinSourceCmd_CabinSourceCmdValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	
	  break;

	  	  //CabinMediaVolumeCommand value status message handover
	   case VEHICLE_MAINFI_C_U16_CABINMEDIAVOLUMECOMMAND:
      {
         vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus oStatus;

         oStatus.CabinMediaVolumeCommandValue = _tCabinVolumeCmd_CabinVolumeCmdValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("CabinMediaVolumeCommand Status update sent as %d", _tCabinVolumeCmd_CabinVolumeCmdValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	
	  break;

	  
	  	  //CabinMediaTunerCommand value status message handover
	   case VEHICLE_MAINFI_C_U16_CABINMEDIATUNERCOMMAND:
      {
         vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus oStatus;

         oStatus.CabinMediaTunerCommandValue = _tCabinTunerCmd_CabinTunerCmdValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("CabinMediaTunerCommand Status update sent as %d", _tCabinTunerCmd_CabinTunerCmdValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	
	  break;

	  
	  
	  	  //CabinMediaTrackCommand value status message handover
	   case VEHICLE_MAINFI_C_U16_CABINMEDIATRACKCOMMAND:
      {
         vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus oStatus;

         oStatus.CabinMediaTrackCommandValue = _tCabinTrackCmd_CabinTrackCmdValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("CabinMediaTrackCommand Status update sent as %d", _tCabinTrackCmd_CabinTrackCmdValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	
	  break;

	  	  
	  
	  	  //CabinMediaPlaylistCommand value status message handover
	   case VEHICLE_MAINFI_C_U16_CABINMEDIAPLAYLISTCOMMAND:
      {
         vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus oStatus;

         oStatus.CabinMediaPlaylistCommandValue = _tCabinPlaylistCmd_CabinPlaylistCmdValue;

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         ETG_TRACE_USR4(("CabinMediaPlaylistCommand Status update sent as %d", _tCabinPlaylistCmd_CabinPlaylistCmdValue));

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }	
	  break;

	  
   case VEHICLE_MAINFI_C_U16_SPEEDLIMIT:
      {
         vehicle_mainfi_tclMsgSpeedLimitStatus oStatus;

         oStatus.SpeedLimit1 = _tSpeedLimit_SpeedLimit1;
         oStatus.SpeedLimit2 = _tSpeedLimit_SpeedLimit2;
         oStatus.Display = _tSpeedLimit_Display;
         oStatus.DisplayUnit = _tSpeedLimit_DisplayUnit;
         oStatus.OverSpeed = _tSpeedLimit_OverSpeed;
         oStatus.FreeSpeed = _tSpeedLimit_FreeSpeed;

         // CaseSpeedLimitStatus_Pre: user specific code start
         // CaseSpeedLimitStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         // CaseSpeedLimitStatus: user specific code start
         // CaseSpeedLimitStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case VEHICLE_MAINFI_C_U16_REVERSEGEAR:
      {
         vehicle_mainfi_tclMsgReverseGearStatus oStatus;

         oStatus.State = _tReverseGear_State;

         // CaseReverseGearStatus_Pre: user specific code start
         // CaseReverseGearStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         // CaseReverseGearStatus: user specific code start
         // CaseReverseGearStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case VEHICLE_MAINFI_C_U16_SPEEDLOCK:
      {
         vehicle_mainfi_tclMsgSpeedLockStatus oStatus;

         oStatus.State = _tSpeedLock_State;

         // CaseSpeedLockStatus_Pre: user specific code start
         // CaseSpeedLockStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         // CaseSpeedLockStatus: user specific code start
         // CaseSpeedLockStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case VEHICLE_MAINFI_C_U16_DRIVINGSTATE:
      {
         vehicle_mainfi_tclMsgDrivingStateStatus oStatus;

         oStatus.State = _tDrivingState_State;

         // CaseDrivingStateStatus_Pre: user specific code start
         // CaseDrivingStateStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         // CaseDrivingStateStatus: user specific code start
         // CaseDrivingStateStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case VEHICLE_MAINFI_C_U16_GLOBALVEHICLEWARNINGSTATE:
      {
         vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus oStatus;

         oStatus.State = _tGlobalVehicleWarningState_State;

         // CaseGlobalVehicleWarningStateStatus_Pre: user specific code start
         // CaseGlobalVehicleWarningStateStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         // CaseGlobalVehicleWarningStateStatus: user specific code start
         // CaseGlobalVehicleWarningStateStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case VEHICLE_MAINFI_C_U16_VEHICLESTATES:
      {
         vehicle_mainfi_tclMsgVehicleStatesStatus oStatus;

         oStatus.State = _tVehicleStates_State;

         // CaseVehicleStatesStatus_Pre: user specific code start
         // CaseVehicleStatesStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         // CaseVehicleStatesStatus: user specific code start
         // CaseVehicleStatesStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case VEHICLE_MAINFI_C_U16_NETWORKSTATE:
      {
         vehicle_mainfi_tclMsgNetworkStateStatus oStatus;

         oStatus.u8BusState_MCAN = _tNetworkState_u8BusState_MCAN;
         oStatus.u8BusState_VCAN = _tNetworkState_u8BusState_VCAN;
         oStatus.u8MuteState_MCAN = _tNetworkState_u8MuteState_MCAN;
         oStatus.u8MuteState_VCAN = _tNetworkState_u8MuteState_VCAN;
         oStatus.bBusOff_MCAN = _tNetworkState_bBusOff_MCAN;
         oStatus.bBusOff_VCAN = _tNetworkState_bBusOff_VCAN;
         oStatus.bBusOff = _tNetworkState_bBusOff;
         oStatus.bMute_MCAN = _tNetworkState_bMute_MCAN;
         oStatus.bMute_VCAN = _tNetworkState_bMute_VCAN;
         oStatus.Listu8AbsentState_ECU = _tNetworkState_Listu8AbsentState_ECU;
         oStatus.Listu8MuteStateMCAN_Channel = _tNetworkState_Listu8MuteStateMCAN_Channel;

         // CaseNetworkStateStatus_Pre: user specific code start
         // CaseNetworkStateStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         // CaseNetworkStateStatus: user specific code start
         // CaseNetworkStateStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case VEHICLE_MAINFI_C_U16_DISTANCETOTALIZER:
      {
         vehicle_mainfi_tclMsgDistanceTotalizerStatus oStatus;

         oStatus.DisTotal = _tDistanceTotalizer_DisTotal;
         oStatus.lastValidDisTotal = _tDistanceTotalizer_lastValidDisTotal;
         oStatus.Unit = _tDistanceTotalizer_Unit;
         oStatus.DisTotalStatus = _tDistanceTotalizer_DisTotalStatus;

         // CaseDistanceTotalizerStatus_Pre: user specific code start
         // CaseDistanceTotalizerStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         // CaseDistanceTotalizerStatus: user specific code start
         // CaseDistanceTotalizerStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case VEHICLE_MAINFI_C_U16_MILEAGE:
      {
         vehicle_mainfi_tclMsgMileageStatus oStatus;

         oStatus.Mileage = _tMileage_Mileage;

         // CaseMileageStatus_Pre: user specific code start
         // CaseMileageStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         // CaseMileageStatus: user specific code start
         // CaseMileageStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case VEHICLE_MAINFI_C_U16_AVGFUELECONOMY:
      {
         vehicle_mainfi_tclMsgAvgFuelEconomyStatus oStatus;

         oStatus.FuelEcon = _tAvgFuelEconomy_FuelEcon;

         // CaseAvgFuelEconomyStatus_Pre: user specific code start
         // CaseAvgFuelEconomyStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         // CaseAvgFuelEconomyStatus: user specific code start
         // CaseAvgFuelEconomyStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case VEHICLE_MAINFI_C_U16_TIREPRESSURESUPPORT:
      {
         vehicle_mainfi_tclMsgTirePressureSupportStatus oStatus;

         oStatus.PressureSupport = _tTirePressureSupport_PressureSupport;

         // CaseTirePressureSupportStatus_Pre: user specific code start
         // CaseTirePressureSupportStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         // CaseTirePressureSupportStatus: user specific code start
         // CaseTirePressureSupportStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case VEHICLE_MAINFI_C_U16_TPMSRESETSUPPORT:
      {
         vehicle_mainfi_tclMsgTPMSResetSupportStatus oStatus;

         oStatus.TPMSResetInfo = _tTPMSResetSupport_TPMSResetInfo;

         // CaseTPMSResetSupportStatus_Pre: user specific code start
         // CaseTPMSResetSupportStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         // CaseTPMSResetSupportStatus: user specific code start
         // CaseTPMSResetSupportStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case VEHICLE_MAINFI_C_U16_TIREPRESSURESETTING:
      {
         vehicle_mainfi_tclMsgTirePressureSettingStatus oStatus;

         oStatus.SettingPressureFront = _tTirePressureSetting_SettingPressureFront;
         oStatus.SettingPressureRear = _tTirePressureSetting_SettingPressureRear;

         // CaseTirePressureSettingStatus_Pre: user specific code start
         // CaseTirePressureSettingStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, VEHICLE_FI_MAJOR_VERSION);

         // CaseTirePressureSettingStatus: user specific code start
         // CaseTirePressureSettingStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;

   default:
      {
         // Case_Default_Status: user specific code start
         // Case_Default_Status: user specific code end
	  }
	  break;
   } // switch



   if (!bSuccess)
   {
      ETG_TRACE_ERR(("bStatusMessageFactory(). Creation of message with 'FID = %u' failed.", u16FunctionId));

      NORMAL_M_ASSERT_ALWAYS();
   }

   return bSuccess;
} // bStatusMessageFactory


/*******************************************************************************
*
* FUNCTION: tBool veda_tclServiceVehicle
*                 ::bProcessSet(amt_tclServiceData* poMessage,
*                               tBool& bPropertyChanged,
*                               tU16& u16ErrorCode)
*
* DESCRIPTION: This function is called by the CCA framework when it has
*              received a message for a property with Opcode 'SET' or 'PURESET'
*              and there is no dedicated handler function defined in the
*              message map for this pair of FID and opcode. The user has to
*              set the application specific property to the requested value
*              and the CCA framework then cares about informing the requesting
*              client as well as other registered clients.
*
* PARAMETER: [IN] poMessage = Property to be set.
*            [OUT] bPropertyChanged = Property changed flag to be set to TRUE
*                                     if property has changed. Otherwise to be
*                                     set to FALSE (default).
*            [OUT] u16ErrorCode = Error code to be set if a CCA error occurs,
*                                 otherwise don't touch.
*
* RETURNVALUE: TRUE = Send 'STATUS' message to the requesting client if opcode
*                     was 'SET'. Send 'STATUS' message to other registered
*                     clients as well if [OUT] parameter 'bPropertyChanged'
*                     is set to TRUE.
*              FALSE = Send an error message to the requesting client.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bProcessSet().
*******************************************************************************/
tBool veda_tclServiceVehicle
::bProcessSet(amt_tclServiceData* poMessage,
              tBool& bPropertyChanged,
              tU16& u16ErrorCode)
{
   (tVoid)bPropertyChanged;  // These lines are added to avoid LINT warnings.
   (tVoid)u16ErrorCode;      // Please remove as soon as variables are used.

   tBool bSuccess = FALSE;

   tU16 u16FunctionId = poMessage->u16GetFunctionID();

   ETG_TRACE_USR4(("veda_tclServiceVehicle:bProcessSet() entered. FID = 0x%04x.", u16FunctionId));

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   switch (u16FunctionId)
   {
   case VEHICLE_MAINFI_C_U16_DISTANCEUNIT:
      {
         vehicle_mainfi_tclMsgDistanceUnitSet oSet;

         if (oVisitorMsg.s32GetData(oSet, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onDistanceUnitSet(oSet.e8DistanceUnit, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf) {
                bSuccess |= _poCallbackIf->onDistanceUnitSet(oSet.e8DistanceUnit, bPropertyChanged, u16ErrorCode);
             }
         }
         // CaseDistanceUnitSet: user specific code start
         // CaseDistanceUnitSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case VEHICLE_MAINFI_C_U16_FUELCONSUMPTIONUNIT:
      {
         vehicle_mainfi_tclMsgFuelConsumptionUnitSet oSet;

         if (oVisitorMsg.s32GetData(oSet, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onFuelConsumptionUnitSet(oSet.e8FuelConsumpUnit, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf) {
                bSuccess |= _poCallbackIf->onFuelConsumptionUnitSet(oSet.e8FuelConsumpUnit, bPropertyChanged, u16ErrorCode);
             }
         }
         // CaseFuelConsumptionUnitSet: user specific code start
         // CaseFuelConsumptionUnitSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case VEHICLE_MAINFI_C_U16_TEMPERATUREUNIT:
      {
         vehicle_mainfi_tclMsgTemperatureUnitSet oSet;

         if (oVisitorMsg.s32GetData(oSet, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onTemperatureUnitSet(oSet.e8TempUnit, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf) {
                bSuccess |= _poCallbackIf->onTemperatureUnitSet(oSet.e8TempUnit, bPropertyChanged, u16ErrorCode);
             }
         }
         // CaseTemperatureUnitSet: user specific code start
         // CaseTemperatureUnitSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case VEHICLE_MAINFI_C_U16_LANGUAGESYNCSOURCE:
      {
         vehicle_mainfi_tclMsgLanguageSyncSourceSet oSet;

         if (oVisitorMsg.s32GetData(oSet, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onLanguageSyncSourceSet(oSet.Language, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf) {
                bSuccess |= _poCallbackIf->onLanguageSyncSourceSet(oSet.Language, bPropertyChanged, u16ErrorCode);
             }
         }
         // CaseLanguageSyncSourceSet: user specific code start
         // CaseLanguageSyncSourceSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case VEHICLE_MAINFI_C_U16_TIREPRESSURESETTING:
      {
         vehicle_mainfi_tclMsgTirePressureSettingSet oSet;

         if (oVisitorMsg.s32GetData(oSet, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onTirePressureSettingSet(oSet.TirePressureRequestInfo, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf) {
                bSuccess |= _poCallbackIf->onTirePressureSettingSet(oSet.TirePressureRequestInfo, bPropertyChanged, u16ErrorCode);
             }
         }
         // CaseTirePressureSettingSet: user specific code start
         // CaseTirePressureSettingSet: user specific code end

         oSet.vDestroy();
      }
      break;

   default:
      {
         // Case_Default_Set: user specific code start
         // Case_Default_Set: user specific code end
      }
      break;
   } //lint !e764: switch statement possibly does not have a case --> generated process function
   return bSuccess;
} // bProcessSet

tVoid veda_tclServiceVehicle::sendDistanceUnitStatus(vehicle_fi_tcl_e8_Vehicle_DistanceUnit e8DistanceUnit)
{

   _tDistanceUnit_e8DistanceUnit = e8DistanceUnit;


   ETG_TRACE_USR4(("sendDistanceUnitStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_DISTANCEUNIT);
}
tVoid veda_tclServiceVehicle::sendFuelConsumptionUnitStatus(vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit e8FuelConsumpUnit)
{

   _tFuelConsumptionUnit_e8FuelConsumpUnit = e8FuelConsumpUnit;


   ETG_TRACE_USR4(("sendFuelConsumptionUnitStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_FUELCONSUMPTIONUNIT);
}
tVoid veda_tclServiceVehicle::sendTemperatureUnitStatus(vehicle_fi_tcl_e8_Vehicle_TemperatureUnit e8TempUnit)
{

   _tTemperatureUnit_e8TempUnit = e8TempUnit;


   ETG_TRACE_USR4(("sendTemperatureUnitStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_TEMPERATUREUNIT);
}
tVoid veda_tclServiceVehicle::sendLanguageStatus(vehicle_fi_tcl_e8_Language_Code Language, bpstl::vector<vehicle_fi_tcl_Language_SourceTable, bpstl::allocator<vehicle_fi_tcl_Language_SourceTable> > LangTable)
{

   _tLanguage_Language = Language;
   _tLanguage_LangTable = LangTable;


   ETG_TRACE_USR4(("sendLanguageStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_LANGUAGE);
}
tVoid veda_tclServiceVehicle::sendLanguageSyncSourceStatus(vehicle_fi_tcl_e8_Language_SourceId Language)
{

   _tLanguageSyncSource_Language = Language;


   ETG_TRACE_USR4(("sendLanguageSyncSourceStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_LANGUAGESYNCSOURCE);
}
tVoid veda_tclServiceVehicle::sendMeterLanguageKnowledgeStatus(vehicle_fi_tcl_e8_Meter_LangKnowledge State)
{

   _tMeterLanguageKnowledge_State = State;


   ETG_TRACE_USR4(("sendMeterLanguageKnowledgeStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_METERLANGUAGEKNOWLEDGE);
}
tVoid veda_tclServiceVehicle::sendHandBrakeStatus(vehicle_fi_tcl_e8_Vehicle_HandBrakeStatus e8Status)
{

   _tHandBrake_e8Status = e8Status;


   ETG_TRACE_USR4(("sendHandBrakeStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_HANDBRAKE);
}
tVoid veda_tclServiceVehicle::sendIgnitionStatus(vehicle_fi_tcl_e8_Vehicle_Ignition e8Status)
{

   _tIgnition_e8Status = e8Status;


   ETG_TRACE_USR4(("sendIgnitionStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_IGNITION);
}
tVoid veda_tclServiceVehicle::sendSpeedStatus(tU16 SpeedValue)
{

   _tSpeed_SpeedValue = SpeedValue;


   ETG_TRACE_USR4(("sendSpeedStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_SPEED);
}
//partial mute property update to clients
tVoid veda_tclServiceVehicle::sendPartialMuteStatus(tU8 PartialMuteValue)
{
   _tPartialMute_PartialMuteValue = PartialMuteValue;

   ETG_TRACE_USR4(("sendPartialMuteStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_PARTIALMUTE);
}
//SWIV Monitor property update to clients
tVoid veda_tclServiceVehicle::sendSwivMonAutoOpenStatus(tU8 SwivMonAutoOpenValue)
{
   _tSwivMonAutoOpen_SwivMonAutoOpenValue = SwivMonAutoOpenValue;
   
   ETG_TRACE_USR4(("sendSwivMonAutoOpenStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_SWIVMONAUTOOPEN);
}
//
tVoid veda_tclServiceVehicle::sendVehicleDriverDoorOpenStatus(tU8 DriverDoorOpenValue)
{
   _tDriverDoorOpen_DriverDoorOpenValue = DriverDoorOpenValue;
   
   ETG_TRACE_USR4(("sendVehicleDriverDoorOpenStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_DRIVERDOOROPEN);
}
//Date mode property update to clients
tVoid veda_tclServiceVehicle::sendDateModeStatus(tU8 DateModeValue)
{
   _tDateMode_DateModeValue = DateModeValue;

   ETG_TRACE_USR4(("sendDateModeStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_DATEMODE);
}
//Time mode property update to clients
tVoid veda_tclServiceVehicle::sendTmModeStatus(tU8 TmModeValue)
{
   _tTmMode_TmModeValue = TmModeValue;

   ETG_TRACE_USR4(("sendTmeModeStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_TMMODE);
}
//camera
tVoid veda_tclServiceVehicle::sendActCam1Status(tU8 ActCam1Value)
{
   _tActCam1_ActCam1Value = ActCam1Value;

   ETG_TRACE_USR4(("sendActCam1Status() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_ACTCAM1);
}
//camera2
tVoid veda_tclServiceVehicle::sendActCam2Status(tU8 ActCam2Value)
{
   _tActCam2_ActCam2Value = ActCam2Value;

   ETG_TRACE_USR4(("sendActCam2Status() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_ACTCAM2);
}
//camera3
tVoid veda_tclServiceVehicle::sendActCam3Status(tU8 ActCam3Value)
{
   _tActCam3_ActCam3Value = ActCam3Value;

   ETG_TRACE_USR4(("sendActCam3Status() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_ACTCAM3);
}
//camera4
tVoid veda_tclServiceVehicle::sendActCam4Status(tU8 ActCam4Value)
{
   _tActCam4_ActCam4Value = ActCam4Value;

   ETG_TRACE_USR4(("sendActCam4Status() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_ACTCAM4);
}
//camera5
tVoid veda_tclServiceVehicle::sendActCam5Status(tU8 ActCam5Value)
{
   _tActCam5_ActCam5Value = ActCam5Value;

   ETG_TRACE_USR4(("sendActCam5Status() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_ACTCAM5);
}
//camera6
tVoid veda_tclServiceVehicle::sendActCam6Status(tU8 ActCam6Value)
{
   _tActCam6_ActCam6Value = ActCam6Value;

   ETG_TRACE_USR4(("sendActCam6Status() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_ACTCAM6);
}
//camera7
tVoid veda_tclServiceVehicle::sendActCam7Status(tU8 ActCam7Value)
{
   _tActCam7_ActCam7Value = ActCam7Value;

   ETG_TRACE_USR4(("sendActCam7Status() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_ACTCAM7);
}
//camsplit
tVoid veda_tclServiceVehicle::sendCamSplitQuadStatus(tU16 CamSplitQuadValue)
{
   _tCamSplitQuad_CamSplitQuadValue = CamSplitQuadValue;

   ETG_TRACE_USR4(("sendCamSplitQuadStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_CAMSPLITQUAD);
}
//MuteDev
tVoid veda_tclServiceVehicle::sendMuteDevStatus(tU8 MuteDevStatus)
{
   _tMuteDev_MuteDevStatus = MuteDevStatus;

   ETG_TRACE_USR4(("sendMuteDevStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_MUTEDEV);
}
//sysVolt property update to clients
tVoid veda_tclServiceVehicle::sendSysVoltStatus(tU8 SysVoltStatus)
{
   _tSysVolt_SysVoltStatus = SysVoltStatus;

   ETG_TRACE_USR4(("sendSysVoltStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_SYSVOLT);
}
//ParkingBreakSwitch property upadte to clients
tVoid veda_tclServiceVehicle::sendParkingBreakSwitchStatus(tU8 ParkingBreakSwitchValue)
{
   _tParkingBreakSwitch_ParkingBreakSwitchValue = ParkingBreakSwitchValue;

   ETG_TRACE_USR4(("sendParkingBreakSwitchStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_PARKINGBREAKSWITCH);
}
//RearCamReq property upadte to clients
tVoid veda_tclServiceVehicle::sendRearCamReqStatus(tU8 RearCamReqValue)
{
   _tRearCamReq_RearCamReqValue = RearCamReqValue;

   ETG_TRACE_USR4(("sendRearCamReqStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_REARCAMREQ);
}
//VIN
tVoid veda_tclServiceVehicle::sendVINStatus(tU32 VINValue)
{

   _tVIN_VINValue = VINValue;


   ETG_TRACE_USR4(("sendVINStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_VIN);
}
//TimeDate
tVoid veda_tclServiceVehicle::sendTimeDateStatus(tU64 TimeDateValue)
{

   _tTimeDate_TimeDateValue = TimeDateValue;


   ETG_TRACE_USR4(("sendTimeDateStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_TIMEDATE);
}


//PhoneCallCommand
tVoid veda_tclServiceVehicle::sendPhoneCallCmdStatus(tU8 PhoneCallCmdValue)
{

   _tPhoneCallCmd_PhoneCallCmdValue = PhoneCallCmdValue;


   ETG_TRACE_USR4(("sendPhoneCallCmdStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_PHONECALLCOMMAND);
}



//PhonePwrCmd
tVoid veda_tclServiceVehicle::sendPhonePwrCmdStatus(tU8 PhonePwrCmdValue)
{

   _tPhonePwrCmd_PhonePwrCmdValue = PhonePwrCmdValue;


   ETG_TRACE_USR4(("sendPhonePwrCmdStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_PHONEPWRCMD);
}



//RadioPwrCmd
tVoid veda_tclServiceVehicle::sendRadioPwrCmdStatus(tU8 RadioPwrCmdValue)
{

   _tRadioPwrCmd_RadioPwrCmdValue = RadioPwrCmdValue;


   ETG_TRACE_USR4(("sendRadioPwrCmdStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_RADIOPWRCMD);
}


//VolumeCommand
tVoid veda_tclServiceVehicle::sendVolumeCmdStatus(tU8 VolumeCmdValue)
{

   _tVolumeCmd_VolumeCmdValue = VolumeCmdValue;


   ETG_TRACE_USR4(("sendVolumeCmdStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_VOLUMECOMMAND);
}

//ActCam8
tVoid veda_tclServiceVehicle::sendActCam8Status(tU8 ActCam8Value)
{

   _tActCam8_ActCam8Value = ActCam8Value;


   ETG_TRACE_USR4(("sendActCam8Status() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_ACTCAM8);
}

//ActCam9
tVoid veda_tclServiceVehicle::sendActCam9Status(tU8 ActCam9Value)
{

   _tActCam9_ActCam9Value = ActCam9Value;


   ETG_TRACE_USR4(("sendActCam9Status() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_ACTCAM9);
}

//ActCam10
tVoid veda_tclServiceVehicle::sendActCam10Status(tU8 ActCam10Value)
{

   _tActCam10_ActCam10Value = ActCam10Value;


   ETG_TRACE_USR4(("sendActCam10Status() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_ACTCAM10);
}

//ActCam11
tVoid veda_tclServiceVehicle::sendActCam11Status(tU8 ActCam11Value)
{

   _tActCam11_ActCam11Value = ActCam11Value;


   ETG_TRACE_USR4(("sendActCam11Status() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_ACTCAM11);
}

//ActCam12
tVoid veda_tclServiceVehicle::sendActCam12Status(tU8 ActCam12Value)
{

   _tActCam12_ActCam12Value = ActCam12Value;


   ETG_TRACE_USR4(("sendActCam12Status() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_ACTCAM12);
}

//ActCam13
tVoid veda_tclServiceVehicle::sendActCam13Status(tU8 ActCam13Value)
{

   _tActCam13_ActCam13Value = ActCam13Value;


   ETG_TRACE_USR4(("sendActCam13Status() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_ACTCAM13);
}

//ActCam14
tVoid veda_tclServiceVehicle::sendActCam14Status(tU8 ActCam14Value)
{

   _tActCam14_ActCam14Value = ActCam14Value;


   ETG_TRACE_USR4(("sendActCam14Status() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_ACTCAM14);
}


//ActCam15
tVoid veda_tclServiceVehicle::sendActCam15Status(tU8 ActCam15Value)
{

   _tActCam15_ActCam15Value = ActCam15Value;


   ETG_TRACE_USR4(("sendActCam15Status() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_ACTCAM15);
}

//ActCam16
tVoid veda_tclServiceVehicle::sendActCam16Status(tU8 ActCam16Value)
{

   _tActCam16_ActCam16Value = ActCam16Value;


   ETG_TRACE_USR4(("sendActCam16Status() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_ACTCAM16);
}


//ActCam17
tVoid veda_tclServiceVehicle::sendActCam17Status(tU8 ActCam17Value)
{

   _tActCam17_ActCam17Value = ActCam17Value;


   ETG_TRACE_USR4(("sendActCam17Status() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_ACTCAM17);
}
//SourceCommand
tVoid veda_tclServiceVehicle::sendSourceCmdStatus(tU8 SourceCmdValue)
{

   _tSourceCmd_SourceCmdValue = SourceCmdValue;


   ETG_TRACE_USR4(("sendSourceCmdStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_SOURCECOMMAND);
}

//CabinSourceCommand
tVoid veda_tclServiceVehicle::sendCabinSourceCmdStatus(tU8 CabinSourceCmdValue)
{

   _tCabinSourceCmd_CabinSourceCmdValue = CabinSourceCmdValue;


   ETG_TRACE_USR4(("sendCabinSourceCmdStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_CABINMEDIASOURCECOMMAND);
}



//CabinVolumeCommand
tVoid veda_tclServiceVehicle::sendCabinVolumeCmdStatus(tU8 CabinVolumeCmdValue)
{

   _tCabinVolumeCmd_CabinVolumeCmdValue = CabinVolumeCmdValue;


   ETG_TRACE_USR4(("sendCabinVolumeCmdStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_CABINMEDIAVOLUMECOMMAND);
}




//CabinTunerCommand
tVoid veda_tclServiceVehicle::sendCabinTunerCmdStatus(tU8 CabinTunerCmdValue)
{

   _tCabinTunerCmd_CabinTunerCmdValue = CabinTunerCmdValue;


   ETG_TRACE_USR4(("sendCabinTunerCmdStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_CABINMEDIATUNERCOMMAND);
}





//CabinTrackCommand
tVoid veda_tclServiceVehicle::sendCabinTrackCmdStatus(tU8 CabinTrackCmdValue)
{

   _tCabinTrackCmd_CabinTrackCmdValue = CabinTrackCmdValue;


   ETG_TRACE_USR4(("sendCabinTrackCmdStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_CABINMEDIATRACKCOMMAND);
}





//CabinPLaylistCommand
tVoid veda_tclServiceVehicle::sendCabinPlaylistCmdStatus(tU8 CabinPlaylistCmdValue)
{

   _tCabinPlaylistCmd_CabinPlaylistCmdValue = CabinPlaylistCmdValue;


   ETG_TRACE_USR4(("sendCabinPlaylistCmdStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_CABINMEDIAPLAYLISTCOMMAND);
}




//Track Command
tVoid veda_tclServiceVehicle::sendTrackCommandStatus(tU8 TrackCommandValue)
{

   _tTrackCmd_TrackCmdValue = TrackCommandValue;


   ETG_TRACE_USR4(("sendTrackCommandStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_TRACKCOMMAND);
}


// SMARTVR
tVoid veda_tclServiceVehicle::sendSMARTVRStatus(tU8 SMARTVRValue)
{

   _tSMARTVR_SMARTVRValue = SMARTVRValue;


   ETG_TRACE_USR4(("sendSMARTVRStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_SMARTVR);

}


//Tuner Command
tVoid veda_tclServiceVehicle::sendTunerCommandStatus(tU8 TunerCommandValue)
{

   _tTunerCmd_TunerCmdValue = TunerCommandValue;


   ETG_TRACE_USR4(("sendTunerCommandStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_TUNERCOMMAND);
}

//TA Command
tVoid veda_tclServiceVehicle::sendTACommandStatus(tU8 TACommandValue)
{

   _tTACmd_TACmdValue = TACommandValue;


   ETG_TRACE_USR4(("sendTACommandStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_TACOMMAND);
}

//RDS Command
tVoid veda_tclServiceVehicle::sendRDSCommandStatus(tU8 RDSCommandValue)
{

   _tRDSCmd_RDSCmdValue = RDSCommandValue;


   ETG_TRACE_USR4(("sendRDSCommandStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_RDSCOMMAND);
}


//VoiceRecgnCommand
tVoid veda_tclServiceVehicle::sendVoiceRecgCmdStatus(tU8 VoiceRecgCommandValue)
{

   _tVoiceRecgCmd_VoiceRecgCmdValue = VoiceRecgCommandValue;


   ETG_TRACE_USR4(("sendVoiceRecgCmdStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_VOICERECGCOMMAND);
}


//RC NextBtn
tVoid veda_tclServiceVehicle::sendRCNextBtnStatus(tU8 RCNextBtnValue)
{

   _tRCNextBtn_RCNextBtnValue = RCNextBtnValue;


   ETG_TRACE_USR4(("sendRCNextBtnStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_RCNEXTBTN);
}


//RC PrevBtn
tVoid veda_tclServiceVehicle::sendRCPrevBtnStatus(tU8 RCPrevBtnValue)
{

   _tRCPrevBtn_RCPrevBtnValue = RCPrevBtnValue;


   ETG_TRACE_USR4(("sendRCPrevBtnStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_RCPREVBTN);
}




//SW Version
tVoid veda_tclServiceVehicle::SendDeviceInfoSWversionStatus(tU32 u32SWversionValue)
{
   _tSWversion_SWversionValue = u32SWversionValue;

   ETG_TRACE_USR4(("SendDeviceInfoSWversionStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_DEVICEINFOSWVERSION);
}



//TotalVehDistDiag
tVoid veda_tclServiceVehicle::SendTotalVehDistDiagStatus(tU32 u32TotalVehDistDiagValue)
{
   _tTotalVehDistDiag_TotalVehDistDiagValue = u32TotalVehDistDiagValue;

   ETG_TRACE_USR4(("SendTotalVehDistDiagStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_TOTALVEHDISTDIAG);
}



//CamTxt
tVoid veda_tclServiceVehicle::sendCamTxtStatus(tU64 CamTxtValue)
{
   _tCamTxt_CamTxtValue = CamTxtValue;

   ETG_TRACE_USR4(("sendCamTxtStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_CAMTXT);
}
//VIN_64
tVoid veda_tclServiceVehicle::sendVIN_64Status(tU64 VIN_64Value)
{
   _tVIN_64_VIN_64Value = VIN_64Value;

   ETG_TRACE_USR4(("sendVIN_64Status() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_VIN_64);
}
//PrivacyResetReq
tVoid veda_tclServiceVehicle::sendPrivacyResetReqStatus(tU8 PrivacyResetReqValue)
{
   _tPrivacyResetReq_PrivacyResetReqValue = PrivacyResetReqValue;

   ETG_TRACE_USR4(("sendPrivacyResetReqStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_PRIVACYRESETREQUEST);
}

tVoid veda_tclServiceVehicle::sendSpeedLimitStatus(tU8 SpeedLimit1, tU8 SpeedLimit2, tU8 Display, vehicle_fi_tcl_e8_Vehicle_DistanceUnit DisplayUnit, tBool OverSpeed, tBool FreeSpeed)
{

   _tSpeedLimit_SpeedLimit1 = SpeedLimit1;
   _tSpeedLimit_SpeedLimit2 = SpeedLimit2;
   _tSpeedLimit_Display = Display;
   _tSpeedLimit_DisplayUnit = DisplayUnit;
   _tSpeedLimit_OverSpeed = OverSpeed;
   _tSpeedLimit_FreeSpeed = FreeSpeed;


   ETG_TRACE_USR4(("sendSpeedLimitStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_SPEEDLIMIT);
}
tVoid veda_tclServiceVehicle::sendReverseGearStatus(tU8 State)
{

   _tReverseGear_State = State;


   ETG_TRACE_USR4(("sendReverseGearStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_REVERSEGEAR);
}
tVoid veda_tclServiceVehicle::sendSpeedLockStatus(tU8 State)
{

   _tSpeedLock_State = State;


   ETG_TRACE_USR4(("sendSpeedLockStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_SPEEDLOCK);
}
tVoid veda_tclServiceVehicle::sendDrivingStateStatus(tU8 State)
{

   _tDrivingState_State = State;


   ETG_TRACE_USR4(("sendDrivingStateStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_DRIVINGSTATE);
}
tVoid veda_tclServiceVehicle::sendGlobalVehicleWarningStateStatus(vehicle_fi_tcl_e8_Vehicle_WarningState State)
{

   _tGlobalVehicleWarningState_State = State;


   ETG_TRACE_USR4(("sendGlobalVehicleWarningStateStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_GLOBALVEHICLEWARNINGSTATE);
}
tVoid veda_tclServiceVehicle::sendVehicleStatesStatus(vehicle_fi_tcl_e8_Vehicle_States State)
{

   _tVehicleStates_State = State;


   ETG_TRACE_USR4(("sendVehicleStatesStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_VEHICLESTATES);
}

tVoid veda_tclServiceVehicle::sendNetworkStateStatus(tU8 u8BusState_MCAN, tU8 u8BusState_VCAN, tU8 u8MuteState_MCAN, tU8 u8MuteState_VCAN, tBool bBusOff_MCAN, tBool bBusOff_VCAN, tBool bBusOff, tBool bMute_MCAN, tBool bMute_VCAN, std::vector<tU8, std::allocator<tU8> > Listu8AbsentState_ECU, std::vector<tU8, std::allocator<tU8> > Listu8MuteStateMCAN_Channel)
{

   _tNetworkState_u8BusState_MCAN = u8BusState_MCAN;
   _tNetworkState_u8BusState_VCAN = u8BusState_VCAN;
   _tNetworkState_u8MuteState_MCAN = u8MuteState_MCAN;
   _tNetworkState_u8MuteState_VCAN = u8MuteState_VCAN;
   _tNetworkState_bBusOff_MCAN = bBusOff_MCAN;
   _tNetworkState_bBusOff_VCAN = bBusOff_VCAN;
   _tNetworkState_bBusOff = bBusOff;
   _tNetworkState_bMute_MCAN = bMute_MCAN;
   _tNetworkState_bMute_VCAN = bMute_VCAN;
   _tNetworkState_Listu8AbsentState_ECU = Listu8AbsentState_ECU;
   _tNetworkState_Listu8MuteStateMCAN_Channel = Listu8MuteStateMCAN_Channel;


   ETG_TRACE_USR4(("sendNetworkStateStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_NETWORKSTATE);
}
tVoid veda_tclServiceVehicle::sendDistanceTotalizerStatus(tU32 DisTotal, tU32 lastValidDisTotal, tU8 Unit, tBool DisTotalStatus)
{

   _tDistanceTotalizer_DisTotal = DisTotal;
   _tDistanceTotalizer_lastValidDisTotal = lastValidDisTotal;
   _tDistanceTotalizer_Unit = Unit;
   _tDistanceTotalizer_DisTotalStatus = DisTotalStatus;


   ETG_TRACE_USR4(("sendDistanceTotalizerStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_DISTANCETOTALIZER);
}
tVoid veda_tclServiceVehicle::sendMileageStatus(tU32 Mileage)
{

   _tMileage_Mileage = Mileage;


   ETG_TRACE_USR4(("sendMileageStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_MILEAGE);
}
tVoid veda_tclServiceVehicle::sendAvgFuelEconomyStatus(tU16 FuelEcon)
{

   _tAvgFuelEconomy_FuelEcon = FuelEcon;


   ETG_TRACE_USR4(("sendAvgFuelEconomyStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_AVGFUELECONOMY);
}
tVoid veda_tclServiceVehicle::sendTirePressureSupportStatus(tBool PressureSupport)
{

   _tTirePressureSupport_PressureSupport = PressureSupport;


   ETG_TRACE_USR4(("sendTirePressureSupportStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_TIREPRESSURESUPPORT);
}
tVoid veda_tclServiceVehicle::sendTPMSResetSupportStatus(vehicle_fi_tcl_e8_Vehicle_TPMSReset TPMSResetInfo)
{

   _tTPMSResetSupport_TPMSResetInfo = TPMSResetInfo;


   ETG_TRACE_USR4(("sendTPMSResetSupportStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_TPMSRESETSUPPORT);
}
tVoid veda_tclServiceVehicle::sendTirePressureSettingStatus(tU16 SettingPressureFront, tU16 SettingPressureRear)
{

   _tTirePressureSetting_SettingPressureFront = SettingPressureFront;
   _tTirePressureSetting_SettingPressureRear = SettingPressureRear;


   ETG_TRACE_USR4(("sendTirePressureSettingStatus() called."));
   eUpdateClients(VEHICLE_MAINFI_C_U16_TIREPRESSURESETTING);
}

tBool veda_tclServiceVehicle::onDistanceUnitSet(vehicle_fi_tcl_e8_Vehicle_DistanceUnit e8DistanceUnit, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)e8DistanceUnit;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onDistanceUnitSet: user specific code start
#ifndef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
   _bResult = TRUE;
   if (vehicle_fi_tcl_e8_Vehicle_DistanceUnit::FI_EN_UNKNOWN != e8DistanceUnit.enType)
   {
      if (_tDistanceUnit_e8DistanceUnit.enType != e8DistanceUnit.enType)
      {
         ETG_TRACE_USR1(("veda_tclServiceVehicle::Distance Unit Updated as %u", \
            ETG_ENUM(VEDA_E8_VEHICLE_DISTANCEUNIT, e8DistanceUnit.enType)));
         _tDistanceUnit_e8DistanceUnit.enType = e8DistanceUnit.enType;
         // save persistently
         dp_tclVehDataDistanceUnit oDPUnit;
         oDPUnit << e8DistanceUnit.enType;

         bPropertyChanged = TRUE;
      }
   }
#endif
   // onDistanceUnitSet: user specific code end
   return _bResult;
}
tBool veda_tclServiceVehicle::onFuelConsumptionUnitSet(vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit e8FuelConsumpUnit, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)e8FuelConsumpUnit;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onFuelConsumptionUnitSet: user specific code start
   _bResult = TRUE;
   if (vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit::FI_EN_UNKNOWN != e8FuelConsumpUnit.enType)
   {
       if (_tFuelConsumptionUnit_e8FuelConsumpUnit.enType != e8FuelConsumpUnit.enType)
       {
           ETG_TRACE_USR1(("veda_tclServiceVehicle:: FuelConsumption Unit Updated as %u", \
                   ETG_ENUM(VEDA_E8_VEHICLE_FUELCONSUMPTIONUNIT, e8FuelConsumpUnit.enType)));
           _tFuelConsumptionUnit_e8FuelConsumpUnit.enType = e8FuelConsumpUnit.enType;
           // save persistently
           dp_tclVehDataFuelConsumptionUnit oDPUnit;
           oDPUnit << e8FuelConsumpUnit.enType;
           bPropertyChanged = TRUE;
       }
   }
   // onFuelConsumptionUnitSet: user specific code end
   return _bResult;
}
tBool veda_tclServiceVehicle::onTemperatureUnitSet(vehicle_fi_tcl_e8_Vehicle_TemperatureUnit e8TempUnit, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)e8TempUnit;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onTemperatureUnitSet: user specific code start
   _bResult = TRUE;
   if (vehicle_fi_tcl_e8_Vehicle_TemperatureUnit::FI_EN_UNKNOWN != e8TempUnit.enType)
   {
       if (_tTemperatureUnit_e8TempUnit.enType != e8TempUnit.enType)
       {
           ETG_TRACE_USR1(("veda_tclServiceVehicle:: TemperatureUnit Updated as %u", \
                   ETG_ENUM(VEDA_E8_VEHICLE_TEMPERATUREUNIT, e8TempUnit.enType)));
           _tTemperatureUnit_e8TempUnit.enType = e8TempUnit.enType;
           // save persistently
           dp_tclVehDataTemperatureUnit oDPUnit;
           oDPUnit << e8TempUnit.enType;
           bPropertyChanged = TRUE;
       }
   }
   // onTemperatureUnitSet: user specific code end
   return _bResult;
}
tBool veda_tclServiceVehicle::onLanguageSyncSourceSet(vehicle_fi_tcl_e8_Language_SourceId Language, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)Language;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onLanguageSyncSourceSet: user specific code start
   _bResult = TRUE;
   if (vehicle_fi_tcl_e8_Language_SourceId::FI_EN_UNKNOWN != Language.enType)
   {
       if ( _tLanguageSyncSource_Language.enType != Language.enType )
       {
           ETG_TRACE_USR1(("veda_tclServiceVehicle:: LanguageSyncSource Updated as %u", \
                   ETG_ENUM(VEDA_E8_LANGUAGE_SOURCEID, Language.enType)));
           _tLanguageSyncSource_Language.enType = Language.enType;
           // Handle property update to clients
           bPropertyChanged = TRUE;
       }
   }
   // onLanguageSyncSourceSet: user specific code end
   return _bResult;
}
tBool veda_tclServiceVehicle::onTirePressureSettingSet(vehicle_fi_tcl_e8_Vehicle_TirePressureInfo TirePressureRequestInfo, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)TirePressureRequestInfo;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onTirePressureSettingSet: user specific code start
   // onTirePressureSettingSet: user specific code end
   return _bResult;
}


tVoid veda_tclServiceVehicle::vHandleSetLanguageOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgSetLanguageMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tSetLanguage_SourceId = oMStart.SourceId;
            _tSetLanguage_Language = oMStart.Language;



            // Remember that we have to send an answer to this request
            _oMemSetLanguage.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSetLanguageMStart(oMStart.SourceId, oMStart.Language);
            if (_poCallbackIf) _poCallbackIf->onSetLanguageMStart(oMStart.SourceId, oMStart.Language);
            // vHandleSetLanguageOpMStart: user specific code start
            // vHandleSetLanguageOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSetLanguageOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid veda_tclServiceVehicle::vHandleSendMediaInfoMStart(amt_tclServiceData* poMessage) {

            ETG_TRACE_USR4(("vHandleSendMediaInfoMStart: Received message"));
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgSendMediaInfoMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCAN_Mesg  = oMStart.MediaInfo;



            // Remember that we have to send an answer to this request
            _oMemSendMediaInfoMStart.vMemorize(
               TRUE,
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSendMediaInfoMStart(oMStart.MediaInfo);
            if (_poCallbackIf) _poCallbackIf->onSendMediaInfoMStart(oMStart.MediaInfo);
            // vHandleSetLanguageOpMStart: user specific code start
            // vHandleSetLanguageOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSendMediaInfoMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}


tVoid veda_tclServiceVehicle::onSendMediaInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) {
}
//call info
tVoid veda_tclServiceVehicle::vHandleSendCallInfoMStart(amt_tclServiceData* poMessage) {

            ETG_TRACE_USR4(("vHandleSendCallInfoMStart: Received message is invalid!"));
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgSendCallInfoMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCAN_Mesg  = oMStart.CallInfo;



            // Remember that we have to send an answer to this request
            _oMemSendCallInfoMStart.vMemorize(
               TRUE,
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSendCallInfoMStart(oMStart.CallInfo);
            if (_poCallbackIf) _poCallbackIf->onSendCallInfoMStart(oMStart.CallInfo);
            // vHandleSetLanguageOpMStart: user specific code start
            // vHandleSetLanguageOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSendCallInfoMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
tVoid veda_tclServiceVehicle::onSendCallInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) {
}
//Phone info
tVoid veda_tclServiceVehicle::vHandleSendPhoneInfoMStart(amt_tclServiceData* poMessage) {

            ETG_TRACE_USR4(("vHandleSendPhoneInfoMStart: Received message is invalid!"));
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgSendPhoneInfoMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCAN_Mesg  = oMStart.PhoneInfo;



            // Remember that we have to send an answer to this request
            _oMemSendPhoneInfoMStart.vMemorize(
               TRUE,
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSendPhoneInfoMStart(oMStart.PhoneInfo);
            if (_poCallbackIf) _poCallbackIf->onSendPhoneInfoMStart(oMStart.PhoneInfo);
            // vHandleSetLanguageOpMStart: user specific code start
            // vHandleSetLanguageOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSendPhoneInfoMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
tVoid veda_tclServiceVehicle::onSendPhoneInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) {
}
//XM Info
tVoid veda_tclServiceVehicle::vHandleSendXMInfoMStart(amt_tclServiceData* poMessage) {

            ETG_TRACE_USR4(("vHandleSendXMInfoMStart: Received message is invalid!"));
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgSendXMInfoMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCAN_Mesg  = oMStart.XMInfo;



            // Remember that we have to send an answer to this request
            _oMemSendXMInfoMStart.vMemorize(
               TRUE,
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSendXMInfoMStart(oMStart.XMInfo);
            if (_poCallbackIf) _poCallbackIf->onSendXMInfoMStart(oMStart.XMInfo);
            // vHandleSetLanguageOpMStart: user specific code start
            // vHandleSetLanguageOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSendXMInfoMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
tVoid veda_tclServiceVehicle::onSendXMInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) {
}
//Mainline info
tVoid veda_tclServiceVehicle::vHandleSendMainlineInfoMStart(amt_tclServiceData* poMessage) {

            ETG_TRACE_USR4(("vHandleSendMainlineInfoMStart: Received message is invalid!"));
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgSendMainlineInfoMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCAN_Mesg  = oMStart.MainlineInfo;



            // Remember that we have to send an answer to this request
            _oMemSendMainlineInfoMStart.vMemorize(
               TRUE,
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSendMainlineInfoMStart(oMStart.MainlineInfo);
            if (_poCallbackIf) _poCallbackIf->onSendMainlineInfoMStart(oMStart.MainlineInfo);
            // vHandleSetLanguageOpMStart: user specific code start
            // vHandleSetLanguageOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSendMainlineInfoMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
tVoid veda_tclServiceVehicle::onSendMainlineInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) {
}

//CabinAMediaInfo

tVoid veda_tclServiceVehicle::vHandleSendCabinAMediaInfoMStart(amt_tclServiceData* poMessage) {

            ETG_TRACE_USR4(("vHandleSendCabinAMediaInfoMStart: Received message is invalid!"));
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCAN_Mesg  = oMStart.CabinAMediaInfo;



            // Remember that we have to send an answer to this request
            _oMemSendCabinAMediaInfoMStart.vMemorize(
               TRUE,
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSendCabinAMediaInfoMStart(oMStart.CabinAMediaInfo);
            if (_poCallbackIf) _poCallbackIf->onSendCabinAMediaInfoMStart(oMStart.CabinAMediaInfo);
            // vHandleSetLanguageOpMStart: user specific code start
            // vHandleSetLanguageOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSendCabinAMediaInfoMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
tVoid veda_tclServiceVehicle::onSendCabinAMediaInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) {
}
//CabinAMainlineInfo

tVoid veda_tclServiceVehicle::vHandleSendCabinAMainlineInfoMStart(amt_tclServiceData* poMessage) {

            ETG_TRACE_USR4(("vHandleSendCabinAMainlineInfoMStart: Received message is invalid!"));
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCAN_Mesg  = oMStart.CabinAMainlineInfo;



            // Remember that we have to send an answer to this request
            _oMemSendCabinAMainlineInfoMStart.vMemorize(
               TRUE,
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSendCabinAMainlineInfoMStart(oMStart.CabinAMainlineInfo);
            if (_poCallbackIf) _poCallbackIf->onSendCabinAMainlineInfoMStart(oMStart.CabinAMainlineInfo);
            // vHandleSetLanguageOpMStart: user specific code start
            // vHandleSetLanguageOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSendCabinAMainlineInfoMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
tVoid veda_tclServiceVehicle::onSendCabinAMainlineInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) {
}

//CabinAPhoneInfo

tVoid veda_tclServiceVehicle::vHandleSendCabinAPhoneInfoMStart(amt_tclServiceData* poMessage) {

            ETG_TRACE_USR4(("vHandleSendCabinAPhoneInfoMStart: Received message is invalid!"));
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCAN_Mesg  = oMStart.CabinAPhoneInfo;



            // Remember that we have to send an answer to this request
            _oMemSendCabinAPhoneInfoMStart.vMemorize(
               TRUE,
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSendCabinAPhoneInfoMStart(oMStart.CabinAPhoneInfo);
            if (_poCallbackIf) _poCallbackIf->onSendCabinAPhoneInfoMStart(oMStart.CabinAPhoneInfo);
            // vHandleSetLanguageOpMStart: user specific code start
            // vHandleSetLanguageOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSendCabinAPhoneInfoMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
tVoid veda_tclServiceVehicle::onSendCabinAPhoneInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) {
}

//CabinACallInfo

tVoid veda_tclServiceVehicle::vHandleSendCabinACallInfoMStart(amt_tclServiceData* poMessage) {

            ETG_TRACE_USR4(("vHandleSendCabinACallInfoMStart: Received message is invalid!"));
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCAN_Mesg  = oMStart.CabinACallInfo;



            // Remember that we have to send an answer to this request
            _oMemSendCabinACallInfoMStart.vMemorize(
               TRUE,
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSendCabinACallInfoMStart(oMStart.CabinACallInfo);
            if (_poCallbackIf) _poCallbackIf->onSendCabinACallInfoMStart(oMStart.CabinACallInfo);
            // vHandleSetLanguageOpMStart: user specific code start
            // vHandleSetLanguageOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSendCabinACallInfoMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
tVoid veda_tclServiceVehicle::onSendCabinACallInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) {
}

//CabinAXMInfo

tVoid veda_tclServiceVehicle::vHandleSendCabinAXMInfoMStart(amt_tclServiceData* poMessage) {

            ETG_TRACE_USR4(("vHandleSendCabinAXMInfoMStart: Received message is invalid!"));
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCAN_Mesg  = oMStart.CabinAXMInfo;



            // Remember that we have to send an answer to this request
            _oMemSendCabinAXMInfoMStart.vMemorize(
               TRUE,
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSendCabinAXMInfoMStart(oMStart.CabinAXMInfo);
            if (_poCallbackIf) _poCallbackIf->onSendCabinAXMInfoMStart(oMStart.CabinAXMInfo);
            // vHandleSetLanguageOpMStart: user specific code start
            // vHandleSetLanguageOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSendCabinAXMInfoMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
tVoid veda_tclServiceVehicle::onSendCabinAXMInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) {
}

//NaviCurrentStreetName info

tVoid veda_tclServiceVehicle::vHandleSendNaviCurrentStreetNameInfoMStart(amt_tclServiceData* poMessage) {

            ETG_TRACE_USR4(("vHandleSendNaviCurrentStreetNameInfoMStart: Received message is invalid!"));
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCAN_Mesg  = oMStart.NaviCurrentStreetNameInfo;



            // Remember that we have to send an answer to this request
            _oMemSendNaviCurrentStreetNameInfoMStart.vMemorize(
               TRUE,
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSendNaviCurrentStreetNameInfoMStart(oMStart.NaviCurrentStreetNameInfo);
            if (_poCallbackIf) _poCallbackIf->onSendNaviCurrentStreetNameInfoMStart(oMStart.NaviCurrentStreetNameInfo);
            // vHandleSetLanguageOpMStart: user specific code start
            // vHandleSetLanguageOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSendNaviCurrentStreetNameInfoMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
tVoid veda_tclServiceVehicle::onSendNaviCurrentStreetNameInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) {
}

//NaviTurnToStreetName info

tVoid veda_tclServiceVehicle::vHandleSendNaviTurnToStreetNameInfoMStart(amt_tclServiceData* poMessage) {

            ETG_TRACE_USR4(("vHandleSendNaviTurnToStreetNameInfoMStart: Received message is invalid!"));
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCAN_Mesg  = oMStart.NaviTurnToStreetNameInfo;



            // Remember that we have to send an answer to this request
            _oMemSendNaviTurnToStreetNameInfoMStart.vMemorize(
               TRUE,
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSendNaviTurnToStreetNameInfoMStart(oMStart.NaviTurnToStreetNameInfo);
            if (_poCallbackIf) _poCallbackIf->onSendNaviTurnToStreetNameInfoMStart(oMStart.NaviTurnToStreetNameInfo);
            // vHandleSetLanguageOpMStart: user specific code start
            // vHandleSetLanguageOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSendNaviTurnToStreetNameInfoMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
tVoid veda_tclServiceVehicle::onSendNaviTurnToStreetNameInfoMStart(vehicle_fi_tcl_CAN_Mesg msg) {
}

//NaviDestinationInfo

tVoid veda_tclServiceVehicle::vHandleSendNaviDestinationInfoMStart(amt_tclServiceData* poMessage) {

            ETG_TRACE_USR4(("vHandleSendNaviDestinationInfoMStart: Received message is invalid!"));
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCAN_Navi_Mesg  = oMStart.NaviDestinationInfo;



            // Remember that we have to send an answer to this request
            _oMemSendNaviDestinationInfoMStart.vMemorize(
               TRUE,
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSendNaviDestinationInfoMStart(oMStart.NaviDestinationInfo);
            if (_poCallbackIf) _poCallbackIf->onSendNaviDestinationInfoMStart(oMStart.NaviDestinationInfo);
            // vHandleSetLanguageOpMStart: user specific code start
            // vHandleSetLanguageOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSendNaviDestinationInfoMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
tVoid veda_tclServiceVehicle::onSendNaviDestinationInfoMStart(vehicle_fi_tcl_CAN_Navi_Mesg msg) {
}
//NaviTurnToSymbols info

tVoid veda_tclServiceVehicle::vHandleSendNaviTurnToSymbolsInfoMStart(amt_tclServiceData* poMessage) {

            ETG_TRACE_USR4(("vHandleSendNaviTurnToSymbolsInfoMStart: Received message is invalid!"));
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCAN_Navi_Mesg  = oMStart.NaviTurnToSymbolsInfo;



            // Remember that we have to send an answer to this request
            _oMemSendNaviTurnToSymbolsInfoMStart.vMemorize(
               TRUE,
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSendNaviTurnToSymbolsInfoMStart(oMStart.NaviTurnToSymbolsInfo);
            if (_poCallbackIf) _poCallbackIf->onSendNaviTurnToSymbolsInfoMStart(oMStart.NaviTurnToSymbolsInfo);
            // vHandleSetLanguageOpMStart: user specific code start
            // vHandleSetLanguageOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSendNaviTurnToSymbolsInfoMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
tVoid veda_tclServiceVehicle::onSendNaviTurnToSymbolsInfoMStart(vehicle_fi_tcl_CAN_Navi_Mesg msg) {
}

//NaviLaneGuidanceInfo

tVoid veda_tclServiceVehicle::vHandleSendNaviLaneGuidanceInfoMStart(amt_tclServiceData* poMessage) {

            ETG_TRACE_USR4(("vHandleSendNaviLaneGuidanceInfoMStart: Received message is invalid!"));
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCAN_Navi_Mesg  = oMStart.NaviLaneGuidanceInfo;



            // Remember that we have to send an answer to this request
            _oMemSendNaviLaneGuidanceInfoMStart.vMemorize(
               TRUE,
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSendNaviLaneGuidanceInfoMStart(oMStart.NaviLaneGuidanceInfo);
            if (_poCallbackIf) _poCallbackIf->onSendNaviLaneGuidanceInfoMStart(oMStart.NaviLaneGuidanceInfo);
            // vHandleSetLanguageOpMStart: user specific code start
            // vHandleSetLanguageOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSendNaviLaneGuidanceInfoMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
tVoid veda_tclServiceVehicle::onSendNaviLaneGuidanceInfoMStart(vehicle_fi_tcl_CAN_Navi_Mesg msg) {
}

//NaviNavigationWarningInfo

tVoid veda_tclServiceVehicle::vHandleSendNaviNavigationWarningInfoMStart(amt_tclServiceData* poMessage) {

            ETG_TRACE_USR4(("vHandleSendNaviNavigationWarningInfoMStart: Received message is invalid!"));
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCAN_Navi_Mesg  = oMStart.NaviNavigationWarningInfo;



            // Remember that we have to send an answer to this request
            _oMemSendNaviNavigationWarningInfoMStart.vMemorize(
               TRUE,
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSendNaviNavigationWarningInfoMStart(oMStart.NaviNavigationWarningInfo);
            if (_poCallbackIf) _poCallbackIf->onSendNaviNavigationWarningInfoMStart(oMStart.NaviNavigationWarningInfo);
            // vHandleSetLanguageOpMStart: user specific code start
            // vHandleSetLanguageOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSendNaviNavigationWarningInfoMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
tVoid veda_tclServiceVehicle::onSendNaviNavigationWarningInfoMStart(vehicle_fi_tcl_CAN_Navi_Mesg msg) {
}

tVoid veda_tclServiceVehicle::onSetLanguageMStart(vehicle_fi_tcl_e8_Language_SourceId SourceId, vehicle_fi_tcl_e8_Language_Code Language) {

   // onSetLanguageMStart: user specific code start
   (tVoid) SourceId;
   (tVoid) Language;
   // onSetLanguageMStart: user specific code end
}
tVoid veda_tclServiceVehicle::sendSetLanguageMResult(tBool Result) {
   if (_oMemSetLanguage.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgSetLanguageMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemSetLanguage.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemSetLanguage.u16GetSourceAppID(), 
         _oMemSetLanguage.u16GetRegisterID(), 
         _oMemSetLanguage.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_SETLANGUAGE, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendSetLanguageMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_SETLANGUAGE, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid veda_tclServiceVehicle::vHandleRequestMeterLanguageSyncOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tRequestMeterLanguageSync_RequestId = oMStart.RequestId;



            // Remember that we have to send an answer to this request
            _oMemRequestMeterLanguageSync.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onRequestMeterLanguageSyncMStart(oMStart.RequestId);
            if (_poCallbackIf) _poCallbackIf->onRequestMeterLanguageSyncMStart(oMStart.RequestId);
            // vHandleRequestMeterLanguageSyncOpMStart: user specific code start
            // vHandleRequestMeterLanguageSyncOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleRequestMeterLanguageSyncOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid veda_tclServiceVehicle::onRequestMeterLanguageSyncMStart(vehicle_fi_tcl_e8_Meter_SyncRequest RequestId) {

   // onRequestMeterLanguageSyncMStart: user specific code start
   (tVoid) RequestId;
   // onRequestMeterLanguageSyncMStart: user specific code end
}
tVoid veda_tclServiceVehicle::sendRequestMeterLanguageSyncMResult(tBool Result) {
   if (_oMemRequestMeterLanguageSync.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemRequestMeterLanguageSync.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemRequestMeterLanguageSync.u16GetSourceAppID(), 
         _oMemRequestMeterLanguageSync.u16GetRegisterID(), 
         _oMemRequestMeterLanguageSync.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_REQUESTMETERLANGUAGESYNC, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendRequestMeterLanguageSyncMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_REQUESTMETERLANGUAGESYNC, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid veda_tclServiceVehicle::vHandleCSMEngineeringDataOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgCSMEngineeringDataMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {



            // Remember that we have to send an answer to this request
            _oMemCSMEngineeringData.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onCSMEngineeringDataMStart();
            if (_poCallbackIf) _poCallbackIf->onCSMEngineeringDataMStart();
            // vHandleCSMEngineeringDataOpMStart: user specific code start
            // vHandleCSMEngineeringDataOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleCSMEngineeringDataOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid veda_tclServiceVehicle::onCSMEngineeringDataMStart() {

   // onCSMEngineeringDataMStart: user specific code start
   // onCSMEngineeringDataMStart: user specific code end
}
tVoid veda_tclServiceVehicle::sendCSMEngineeringDataMResult(bpstl::vector<vehicle_fi_tcl_CAN_Message, bpstl::allocator<vehicle_fi_tcl_CAN_Message> > CanMessageList) {
   if (_oMemCSMEngineeringData.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult  oMResult;
      //the data content

      oMResult.CanMessageList = CanMessageList;


      _oMemCSMEngineeringData.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemCSMEngineeringData.u16GetSourceAppID(), 
         _oMemCSMEngineeringData.u16GetRegisterID(), 
         _oMemCSMEngineeringData.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_CSMENGINEERINGDATA, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendCSMEngineeringDataMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_CSMENGINEERINGDATA, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid veda_tclServiceVehicle::vHandleSetOSPAlertsStatusOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tSetOSPAlertsStatus_OSPAlert = oMStart.OSPAlert;
            _tSetOSPAlertsStatus_DangerousAreaAlert = oMStart.DangerousAreaAlert;



            // Remember that we have to send an answer to this request
            _oMemSetOSPAlertsStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onSetOSPAlertsStatusMStart(oMStart.OSPAlert, oMStart.DangerousAreaAlert);
            if (_poCallbackIf) _poCallbackIf->onSetOSPAlertsStatusMStart(oMStart.OSPAlert, oMStart.DangerousAreaAlert);
            // vHandleSetOSPAlertsStatusOpMStart: user specific code start
            // vHandleSetOSPAlertsStatusOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleSetOSPAlertsStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid veda_tclServiceVehicle::onSetOSPAlertsStatusMStart(tBool OSPAlert, tBool DangerousAreaAlert) {

   // onSetOSPAlertsStatusMStart: user specific code start
   (tVoid) OSPAlert;
   (tVoid) DangerousAreaAlert;
   // onSetOSPAlertsStatusMStart: user specific code end
}
tVoid veda_tclServiceVehicle::sendSetOSPAlertsStatusMResult(tBool Status) {
   if (_oMemSetOSPAlertsStatus.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodResult  oMResult;
      //the data content

      oMResult.Status = Status;


      _oMemSetOSPAlertsStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemSetOSPAlertsStatus.u16GetSourceAppID(), 
         _oMemSetOSPAlertsStatus.u16GetRegisterID(), 
         _oMemSetOSPAlertsStatus.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_SETOSPALERTSSTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendSetOSPAlertsStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_SETOSPALERTSSTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
//Cam1ManAct
tVoid veda_tclServiceVehicle::vHandleCam1ManActOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgCam1ManActMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCam1ManAct_RequestId = oMStart.RequestId;



            // Remember that we have to send an answer to this request
            _oMemCam1ManAct.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onCam1ManActMStart(oMStart.RequestId);
            if (_poCallbackIf) _poCallbackIf->onCam1ManActMStart(oMStart.RequestId);          
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleCam1ManActOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
//Cam2ManAct
tVoid veda_tclServiceVehicle::vHandleCam2ManActOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgCam2ManActMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCam2ManAct_RequestId = oMStart.RequestId;



            // Remember that we have to send an answer to this request
            _oMemCam2ManAct.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onCam2ManActMStart(oMStart.RequestId);
            if (_poCallbackIf) _poCallbackIf->onCam2ManActMStart(oMStart.RequestId);          
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleCam2ManActOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
//Cam3ManAct
tVoid veda_tclServiceVehicle::vHandleCam3ManActOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgCam3ManActMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCam3ManAct_RequestId = oMStart.RequestId;



            // Remember that we have to send an answer to this request
            _oMemCam3ManAct.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onCam3ManActMStart(oMStart.RequestId);
            if (_poCallbackIf) _poCallbackIf->onCam3ManActMStart(oMStart.RequestId);          
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleCam3ManActOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
//Cam4ManAct
tVoid veda_tclServiceVehicle::vHandleCam4ManActOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgCam4ManActMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCam4ManAct_RequestId = oMStart.RequestId;



            // Remember that we have to send an answer to this request
            _oMemCam4ManAct.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onCam4ManActMStart(oMStart.RequestId);
            if (_poCallbackIf) _poCallbackIf->onCam4ManActMStart(oMStart.RequestId);          
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleCam4ManActOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
//Cam5ManAct
tVoid veda_tclServiceVehicle::vHandleCam5ManActOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgCam5ManActMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCam5ManAct_RequestId = oMStart.RequestId;



            // Remember that we have to send an answer to this request
            _oMemCam5ManAct.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onCam5ManActMStart(oMStart.RequestId);
            if (_poCallbackIf) _poCallbackIf->onCam5ManActMStart(oMStart.RequestId);          
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleCam5ManActOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
//Cam6ManAct
tVoid veda_tclServiceVehicle::vHandleCam6ManActOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgCam6ManActMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCam6ManAct_RequestId = oMStart.RequestId;



            // Remember that we have to send an answer to this request
            _oMemCam6ManAct.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onCam6ManActMStart(oMStart.RequestId);
            if (_poCallbackIf) _poCallbackIf->onCam6ManActMStart(oMStart.RequestId);          
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleCam6ManActOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
//Cam7ManAct
tVoid veda_tclServiceVehicle::vHandleCam7ManActOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgCam7ManActMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCam7ManAct_RequestId = oMStart.RequestId;



            // Remember that we have to send an answer to this request
            _oMemCam7ManAct.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onCam7ManActMStart(oMStart.RequestId);
            if (_poCallbackIf) _poCallbackIf->onCam7ManActMStart(oMStart.RequestId);          
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleCam7ManActOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
//Cam8ManAct
tVoid veda_tclServiceVehicle::vHandleCam8ManActOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgCam8ManActMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCam8ManAct_RequestId = oMStart.RequestId;



            // Remember that we have to send an answer to this request
            _oMemCam8ManAct.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            
            if (_poCallbackIf) _poCallbackIf->onCam8ManActMStart(oMStart.RequestId);          
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleCam8ManActOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}



//Cam9ManAct
tVoid veda_tclServiceVehicle::vHandleCam9ManActOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgCam9ManActMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCam9ManAct_RequestId = oMStart.RequestId;



            // Remember that we have to send an answer to this request
            _oMemCam9ManAct.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onCam9ManActMStart(oMStart.RequestId);          
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleCam9ManActOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}

//Cam10ManAct
tVoid veda_tclServiceVehicle::vHandleCam10ManActOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgCam10ManActMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCam10ManAct_RequestId = oMStart.RequestId;



            // Remember that we have to send an answer to this request
            _oMemCam10ManAct.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onCam10ManActMStart(oMStart.RequestId);          
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleCam10ManActOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}

//Cam11ManAct
tVoid veda_tclServiceVehicle::vHandleCam11ManActOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgCam11ManActMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCam11ManAct_RequestId = oMStart.RequestId;



            // Remember that we have to send an answer to this request
            _oMemCam11ManAct.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onCam11ManActMStart(oMStart.RequestId);          
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleCam11ManActOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}


//Cam12ManAct
tVoid veda_tclServiceVehicle::vHandleCam12ManActOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgCam12ManActMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCam12ManAct_RequestId = oMStart.RequestId;



            // Remember that we have to send an answer to this request
            _oMemCam12ManAct.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onCam12ManActMStart(oMStart.RequestId);          
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleCam12ManActOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}


//Cam13ManAct
tVoid veda_tclServiceVehicle::vHandleCam13ManActOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgCam13ManActMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCam13ManAct_RequestId = oMStart.RequestId;



            // Remember that we have to send an answer to this request
            _oMemCam13ManAct.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onCam13ManActMStart(oMStart.RequestId);          
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleCam13ManActOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}


//Cam14ManAct
tVoid veda_tclServiceVehicle::vHandleCam14ManActOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgCam14ManActMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCam14ManAct_RequestId = oMStart.RequestId;



            // Remember that we have to send an answer to this request
            _oMemCam14ManAct.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

          
            if (_poCallbackIf) _poCallbackIf->onCam14ManActMStart(oMStart.RequestId);          
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleCam14ManActOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}

//Cam15ManAct
tVoid veda_tclServiceVehicle::vHandleCam15ManActOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgCam15ManActMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCam15ManAct_RequestId = oMStart.RequestId;



            // Remember that we have to send an answer to this request
            _oMemCam15ManAct.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

          
            if (_poCallbackIf) _poCallbackIf->onCam15ManActMStart(oMStart.RequestId);          
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleCam15ManActOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}

//Cam16ManAct
tVoid veda_tclServiceVehicle::vHandleCam16ManActOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgCam16ManActMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCam16ManAct_RequestId = oMStart.RequestId;



            // Remember that we have to send an answer to this request
            _oMemCam16ManAct.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onCam16ManActMStart(oMStart.RequestId);          
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleCam16ManActOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}

//Cam17ManAct
tVoid veda_tclServiceVehicle::vHandleCam17ManActOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgCam17ManActMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCam17ManAct_RequestId = oMStart.RequestId;



            // Remember that we have to send an answer to this request
            _oMemCam17ManAct.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

          
            if (_poCallbackIf) _poCallbackIf->onCam17ManActMStart(oMStart.RequestId);          
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleCam17ManActOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}

//PrivacyResetAck
tVoid veda_tclServiceVehicle::vHandlePrivacyResetAckOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgPrivacyResetAckMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tPrivacyResetAck_RequestId = oMStart.RequestId;



            // Remember that we have to send an answer to this request
            _oMemCam1ManAct.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onPrivacyResetAckMStart(oMStart.RequestId);
            if (_poCallbackIf) _poCallbackIf->onPrivacyResetAckMStart(oMStart.RequestId);          
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandlePrivacyResetAckOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
//DispCamCls
tVoid veda_tclServiceVehicle::vHandleDispCamClsOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgDispCamClsMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDispCamCls_RequestId = oMStart.RequestId;



            // Remember that we have to send an answer to this request
            _oMemDispCamCls.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onDispCamClsMStart(oMStart.RequestId);
            if (_poCallbackIf) _poCallbackIf->onDispCamClsMStart(oMStart.RequestId);          
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleDispCamClsOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
//PhoneBTLinkStatus
tVoid veda_tclServiceVehicle::vHandlePhoneBTLinkStatusOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tPhoneBTLinkStatus_BTLinkStatus = oMStart.BTLinkStatus;



            // Remember that we have to send an answer to this request
            _oMemPhoneBTLinkStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onPhoneBTLinkStatusMStart(oMStart.BTLinkStatus);          
         } else {
            ETG_TRACE_ERR(("vHandlePhoneBTLinkStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}

//PhoneBooksyncStatus
tVoid veda_tclServiceVehicle::vHandlePhoneBookSyncstatusOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tPhoneBookSyncStatus_PhoneBookSyncStatusValue = oMStart.PhoneBookSyncStatusValue;



            // Remember that we have to send an answer to this request
            _oMemPhoneBookSyncStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onPhoneBookSyncstatusMStart(oMStart.PhoneBookSyncStatusValue);          
         } else {
            ETG_TRACE_ERR(("vHandlePhoneBookSyncstatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}


//CallHistorySyncStatus
tVoid veda_tclServiceVehicle::vHandleCallHistorySyncStatusOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCallHistorySyncStatus_CallHistorySyncStatusValue = oMStart.CallHistorySyncStatusValue;



            // Remember that we have to send an answer to this request
            _oMemCallHistorySyncStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onCallHistorySyncStatusMStart(oMStart.CallHistorySyncStatusValue);          
         } else {
            ETG_TRACE_ERR(("vHandleCallHistorySyncStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}


//PhoneStatusRoaming
tVoid veda_tclServiceVehicle::vHandlePhoneStatusRoamingOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tPhoneStatusRoaming_PhoneStatusRoamingValue = oMStart.PhoneStatusRoamingValue;



            // Remember that we have to send an answer to this request
            _oMemPhoneStatusRoaming.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onPhoneStatusRoamingMStart(oMStart.PhoneStatusRoamingValue);          
         } else {
            ETG_TRACE_ERR(("vHandlePhoneStatusRoamingOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}


//CallDuration
tVoid veda_tclServiceVehicle::vHandleCallDurationOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgCallDurationMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCallDuration_CallDurationValue = oMStart.CallDurationValue;



            // Remember that we have to send an answer to this request
            _oMemCallDuration.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onCallDurationMStart(oMStart.CallDurationValue);          
         } else {
            ETG_TRACE_ERR(("vHandleCallDurationOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}

//GSMSignalStrength
tVoid veda_tclServiceVehicle::vHandleGSMSignalStrengthOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tGSMSignalStrength_GSMSignalStrengthValue = oMStart.GSMSignalStrengthValue;



            // Remember that we have to send an answer to this request
            _oMemGSMSignalStrength.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onGSMSignalStrengthMStart(oMStart.GSMSignalStrengthValue);          
         } else {
            ETG_TRACE_ERR(("vHandleGSMSignalStrengthOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}

//PhoneCallStatus
tVoid veda_tclServiceVehicle::vHandlePhoneCallStatusOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgPhoneCallStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tPhoneCallStatus_CallStatusValue = oMStart.CallStatusValue;



            // Remember that we have to send an answer to this request
            _oMemPhoneCallStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onPhoneCallStatusMStart(oMStart.CallStatusValue);          
         } else {
            ETG_TRACE_ERR(("vHandlePhoneCallStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}


//PhoneBatteryLevelStatus
tVoid veda_tclServiceVehicle::vHandlePhoneBatteryLevelStatusOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tPhoneBatteryLevelStatus_PhoneBatteryLevelStatusValue = oMStart.PhoneBatteryLevelStatusValue;



            // Remember that we have to send an answer to this request
            _oMemPhoneBatteryLevelStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onPhoneBatteryLevelStatusMStart(oMStart.PhoneBatteryLevelStatusValue);          
         } else {
            ETG_TRACE_ERR(("vHandlePhoneBatteryLevelStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}

//DeviceStatusWifiAvailable
tVoid veda_tclServiceVehicle::vHandleDeviceStatusWifiAvailableOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDeviceStatusWifiAvailable_DeviceStatusWifiStatus = oMStart.DeviceStatusWifiStatus;



            // Remember that we have to send an answer to this request
            _oMemDeviceStatusWifiAvailable.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onDeviceStatusWifiAvailableMStart(oMStart.DeviceStatusWifiStatus);          
         } else {
            ETG_TRACE_ERR(("vHandleDeviceStatusWifiAvailableOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}

//MediaStatusAudioSource
tVoid veda_tclServiceVehicle::vHandleMediaStatusAudioSourceOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tMediaStatusAudioSource_AudioSource = oMStart.AudioSource;



            // Remember that we have to send an answer to this request
            _oMemMediaStatusAudioSource.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onMediaStatusAudioSourceMStart(oMStart.AudioSource);          
         } else {
            ETG_TRACE_ERR(("vHandleMediaStatusAudioSourceOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}


//PhoneAvailableStatus
tVoid veda_tclServiceVehicle::vHandlePhoneAvailableStatusOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tPhoneAvailableStatus_PhoneAvailableStatusValue = oMStart.PhoneAvailableStatusValue;



            // Remember that we have to send an answer to this request
            _oMemPhoneAvailableStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onPhoneAvailableStatusMStart(oMStart.PhoneAvailableStatusValue);          
         } else {
            ETG_TRACE_ERR(("vHandlePhoneAvailableStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}


//PhoneVRAvailable
tVoid veda_tclServiceVehicle::vHandlePhoneVRAvailableOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tPhoneVRAvailable_PhoneVRAvailableValue = oMStart.PhoneVRAvailableValue;



            // Remember that we have to send an answer to this request
            _oMemPhoneVRAvailable.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            if (_poCallbackIf) _poCallbackIf->onPhoneVRAvailableMStart(oMStart.PhoneVRAvailableValue); 
			
         } else {
            ETG_TRACE_ERR(("vHandlePhoneVRAvailableOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}



//DeviceStatusBTStatus
tVoid veda_tclServiceVehicle::vHandleDeviceStatusBTStatusOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDeviceStatusBTStatus_DeviceStatusBTStatusValue = oMStart.DeviceStatusBTStatusValue;



            // Remember that we have to send an answer to this request
            _oMemDeviceStatusBTStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onDeviceStatusBTStatusMStart(oMStart.DeviceStatusBTStatusValue);          
         } else {
            ETG_TRACE_ERR(("vHandleDeviceStatusBTStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}



//Req_DeviceInfo
tVoid veda_tclServiceVehicle::vHandleReq_DeviceInfoOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tReq_DeviceInfo_Req_DeviceInfoValue = oMStart.Req_DeviceInfoValue;



            // Remember that we have to send an answer to this request
            _oMemReq_DeviceInfo.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onReq_DeviceInfoMStart(oMStart.Req_DeviceInfoValue);          
         } else {
            ETG_TRACE_ERR(("vHandleReq_DeviceInfoOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}



//DeviceStatusBluetoothAvail
tVoid veda_tclServiceVehicle::vHandleDeviceStatusBluetoothAvailOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDeviceStatusBluetoothAvail_DeviceStatusBluetoothAvailValue = oMStart.DeviceStatusBluetoothAvailValue;



            // Remember that we have to send an answer to this request
            _oMemDeviceStatusBluetoothAvail.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onDeviceStatusBluetoothAvailMStart(oMStart.DeviceStatusBluetoothAvailValue);          
         } else {
            ETG_TRACE_ERR(("vHandleDeviceStatusBluetoothAvailOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}


//MediaStatusVolume
tVoid veda_tclServiceVehicle::vHandleMediaStatusVolumeOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tMediaStatusVolume_volume = oMStart.volume;



            // Remember that we have to send an answer to this request
            _oMemMediaStatusVolume.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onMediaStatusVolumeMStart(oMStart.volume);          
         } else {
            ETG_TRACE_ERR(("vHandleMediaStatusVolumeOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}

//CabinMediaStatusAudioSource
tVoid veda_tclServiceVehicle::vHandleCabinMediaStatusAudioSourceOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCabinMediaStatusAudioSource_CabinAudioSource = oMStart.CabinAudioSource;



            // Remember that we have to send an answer to this request
            _oMemCabinMediaStatusAudioSource.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onCabinMediaStatusAudioSourceMStart(oMStart.CabinAudioSource);          
         } else {
            ETG_TRACE_ERR(("vHandleCabinMediaStatusAudioSourceOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}

//CabinMediaStatusTunerBand
tVoid veda_tclServiceVehicle::vHandleCabinMediaStatusTunerBandOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCabinMediaStatusTunerBand_CabinTunerBand = oMStart.CabinMediaStatusTunerBandValue;



            // Remember that we have to send an answer to this request
            _oMemCabinMediaStatusTunerBand.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onCabinMediaStatusTunerBandMStart(oMStart.CabinMediaStatusTunerBandValue);          
         } else {
            ETG_TRACE_ERR(("vHandleCabinMediaStatusTunerBandOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}


//CabinMediaStatusVolume
tVoid veda_tclServiceVehicle::vHandleCabinMediaStatusVolumeOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCabinMediaStatusVolume_CabinVolume = oMStart.CabinVolume;



            // Remember that we have to send an answer to this request
            _oMemCabinMediaStatusVolume.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onCabinMediaStatusVolumeMStart(oMStart.CabinVolume);          
         } else {
            ETG_TRACE_ERR(("vHandleCabinMediaStatusVolumeOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}

//MediaStatusMuteStatus
tVoid veda_tclServiceVehicle::vHandleMediaStatusMuteStatusOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tMediaStatusMuteStatus_MediaStatusMuteValue = oMStart.MediaStatusMuteValue;



            // Remember that we have to send an answer to this request
            _oMemMediaStatusMuteStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onMediaStatusMuteStatusMStart(oMStart.MediaStatusMuteValue);          
         } else {
            ETG_TRACE_ERR(("vHandleMediaStatusMuteStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}

//CabinMediaStatusMuteStatus
tVoid veda_tclServiceVehicle::vHandleCabinMediaStatusMuteStatusOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tCabinMediaStatusMuteStatus_CabinMediaStatusMuteValue = oMStart.CabinMediaStatusMuteValue;



            // Remember that we have to send an answer to this request
            _oMemCabinMediaStatusMuteStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onCabinMediaStatusMuteStatusMStart(oMStart.CabinMediaStatusMuteValue);          
         } else {
            ETG_TRACE_ERR(("vHandleCabinMediaStatusMuteStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}


//MediaStatusPlayStatus
tVoid veda_tclServiceVehicle::vHandleMediaStatusPlayStatusOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tMediaStatusPlayStatus_MediaStatusPlayStatusValue = oMStart.MediaStatusPlayStatusValue;



            // Remember that we have to send an answer to this request
            _oMemMediaStatusPlayStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onMediaStatusPlayStatusMStart(oMStart.MediaStatusPlayStatusValue);          
         } else {
            ETG_TRACE_ERR(("vHandleMediaStatusPlayStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}

//MediaStatusMixState
tVoid veda_tclServiceVehicle::vHandleMediaStatusMixStateOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tMediaStatusMixState_MediaStatusMixStateValue = oMStart.MediaStatusMixStateValue;



            // Remember that we have to send an answer to this request
            _oMemMediaStatusMixState.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onMediaStatusMixStateMStart(oMStart.MediaStatusMixStateValue);          
         } else {
            ETG_TRACE_ERR(("vHandleMediaStatusMixStateOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}


//MediaStatusCurrTrackNum
tVoid veda_tclServiceVehicle::vHandleMediaStatusCurrTrackNumOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tMediaStatusCurrTrackNum_MediaStatusCurrTrackNumValue = oMStart.MediaStatusCurrTrackNumValue;



            // Remember that we have to send an answer to this request
            _oMemMediaStatusCurrTrackNum.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onMediaStatusCurrTrackNumMStart(oMStart.MediaStatusCurrTrackNumValue);          
         } else {
            ETG_TRACE_ERR(("vHandleMediaStatusCurrTrackNumOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}

//DeviceStatusRadioStatus
tVoid veda_tclServiceVehicle::vHandleDeviceStatusRadioStatusOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDeviceStatusRadioStatus_DeviceStatusRadioStatusValue = oMStart.DeviceStatusRadioStatusValue;



            // Remember that we have to send an answer to this request
            _oMemDeviceStatusRadioStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onDeviceStatusRadioStatusMStart(oMStart.DeviceStatusRadioStatusValue);          
         } else {
            ETG_TRACE_ERR(("vHandleDeviceStatusRadioStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}


//DeviceStatusDABAvailStatus
tVoid veda_tclServiceVehicle::vHandleDeviceStatusDABAvailStatusOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDeviceStatusDABAvailStatus_DeviceStatusDABAvailStatusValue = oMStart.DeviceStatusDABAvailStatusValue;



            // Remember that we have to send an answer to this request
            _oMemDeviceStatusDABAvailStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onDeviceStatusDABAvailStatusMStart(oMStart.DeviceStatusDABAvailStatusValue);          
         } else {
            ETG_TRACE_ERR(("vHandleDeviceStatusDABAvailStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}

//DeviceStatusNavData
tVoid veda_tclServiceVehicle::vHandleDeviceStatusNavDataOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDeviceStatusNavData_DeviceStatusNavDataValue = oMStart.DeviceStatusNavDataValue;



            // Remember that we have to send an answer to this request
            _oMemDeviceStatusNavData.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onDeviceStatusNavDataMStart(oMStart.DeviceStatusNavDataValue);          
         } else {
            ETG_TRACE_ERR(("vHandleDeviceStatusNavDataOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
//DeviceStatusUSB1Present
tVoid veda_tclServiceVehicle::vHandleDeviceStatusUSB1PresentOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDeviceStatusUSB1Present_DeviceStatusUSB1PresentValue = oMStart.DeviceStatusUSB1PresentValue;



            // Remember that we have to send an answer to this request
            _oMemDeviceStatusUSB1Present.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onDeviceStatusUSB1PresentMStart(oMStart.DeviceStatusUSB1PresentValue);          
         } else {
            ETG_TRACE_ERR(("vHandleDeviceStatusUSB1PresentOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
//DeviceStatusUSB2Present
tVoid veda_tclServiceVehicle::vHandleDeviceStatusUSB2PresentOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDeviceStatusUSB2Present_DeviceStatusUSB2PresentValue = oMStart.DeviceStatusUSB2PresentValue;



            // Remember that we have to send an answer to this request
            _oMemDeviceStatusUSB2Present.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onDeviceStatusUSB2PresentMStart(oMStart.DeviceStatusUSB2PresentValue);          
         } else {
            ETG_TRACE_ERR(("vHandleDeviceStatusUSB2PresentOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
//DeviceStatusNaviAvail
tVoid veda_tclServiceVehicle::vHandleDeviceStatusNaviAvailOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDeviceStatusNaviAvail_DeviceStatusNaviAvailValue = oMStart.DeviceStatusNaviAvailValue;



            // Remember that we have to send an answer to this request
            _oMemDeviceStatusNaviAvail.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onDeviceStatusNaviAvailMStart(oMStart.DeviceStatusNaviAvailValue);          
         } else {
            ETG_TRACE_ERR(("vHandleDeviceStatusNaviAvailOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
//DeviceStatusUSB1Src
tVoid veda_tclServiceVehicle::vHandleDeviceStatusUSB1SrcOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDeviceStatusUSB1Src_DeviceStatusUSB1SrcValue = oMStart.DeviceStatusUSB1SrcValue;



            // Remember that we have to send an answer to this request
            _oMemDeviceStatusUSB1Src.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onDeviceStatusUSB1SrcMStart(oMStart.DeviceStatusUSB1SrcValue);          
         } else {
            ETG_TRACE_ERR(("vHandleDeviceStatusUSB1SrcOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}

//DeviceStatusUSB2Src
tVoid veda_tclServiceVehicle::vHandleDeviceStatusUSB2SrcOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDeviceStatusUSB2Src_DeviceStatusUSB2SrcValue = oMStart.DeviceStatusUSB2SrcValue;



            // Remember that we have to send an answer to this request
            _oMemDeviceStatusUSB2Src.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onDeviceStatusUSB2SrcMStart(oMStart.DeviceStatusUSB2SrcValue);          
         } else {
            ETG_TRACE_ERR(("vHandleDeviceStatusUSB2SrcOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}
//DeviceStatusAMFMAvail
tVoid veda_tclServiceVehicle::vHandleDeviceStatusAMFMAvailOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tDeviceStatusAMFMAvail_DeviceStatusAMFMAvailValue = oMStart.DeviceStatusAMFMAvailValue;



            // Remember that we have to send an answer to this request
            _oMemDeviceStatusAMFMAvail.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onDeviceStatusAMFMAvailMStart(oMStart.DeviceStatusAMFMAvailValue);          
         } else {
            ETG_TRACE_ERR(("vHandleDeviceStatusAMFMAvailOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}


//MediaStatusTrackTime
tVoid veda_tclServiceVehicle::vHandleMediaStatusTrackTimeOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tMediaStatusTrackTime_MediaStatusTrackTimeValue = oMStart.MediaStatusTrackTimeValue;



            // Remember that we have to send an answer to this request
            _oMemMediaStatusTrackTime.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onMediaStatusTrackTimeMStart(oMStart.MediaStatusTrackTimeValue);          
         } else {
            ETG_TRACE_ERR(("vHandleMediaStatusTrackTimeOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}


//MediaStatusPlaylistMode
tVoid veda_tclServiceVehicle::vHandleMediaStatusPlaylistModeOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tMediaStatusPlaylistMode_MediaStatusPlaylistModeValue = oMStart.MediaStatusPlaylistModeValue;



            // Remember that we have to send an answer to this request
            _oMemMediaStatusPlaylistMode.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onMediaStatusPlaylistModeMStart(oMStart.MediaStatusPlaylistModeValue);          
         } else {
            ETG_TRACE_ERR(("vHandleMediaStatusPlaylistModeOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}



//MediaStatusSeekStatus
tVoid veda_tclServiceVehicle::vHandleMediaStatusSeekStatusOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tMediaStatusSeekStatus_MediaStatusSeekStatusValue = oMStart.MediaStatusSeekStatusValue;



            // Remember that we have to send an answer to this request
            _oMemMediaStatusSeekStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onMediaStatusSeekStatusMStart(oMStart.MediaStatusSeekStatusValue);          
         } else {
            ETG_TRACE_ERR(("vHandleMediaStatusSeekStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}



//MediaStatusRepeatStatus
tVoid veda_tclServiceVehicle::vHandleMediaStatusRepeatStatusOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tMediaStatusRepeatStatus_MediaStatusRepeatStatusValue = oMStart.MediaStatusRepeatStatusValue;



            // Remember that we have to send an answer to this request
            _oMemMediaStatusRepeatStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onMediaStatusRepeatStatusMStart(oMStart.MediaStatusRepeatStatusValue);          
         } else {
            ETG_TRACE_ERR(("vHandleMediaStatusRepeatStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}

//MediaStatusDABFMStatus
tVoid veda_tclServiceVehicle::vHandleMediaStatusDABFMStatusOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tMediaStatusDABFMStatus_MediaStatusDABFMStatusValue = oMStart.MediaStatusDABFMStatusValue;



            // Remember that we have to send an answer to this request
            _oMemMediaStatusDABFMStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onMediaStatusDABFMStatusMStart(oMStart.MediaStatusDABFMStatusValue);          
         } else {
            ETG_TRACE_ERR(("vHandleMediaStatusDABFMStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}

//VehicleNaviLatitude
tVoid veda_tclServiceVehicle::vHandleVehicleNaviLatitudeOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tVehicleNaviLatitude_VehicleNaviLatitudeValue = oMStart.VehicleNaviLatitudeValue;



            // Remember that we have to send an answer to this request
            _oMemVehicleNaviLatitude.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onVehicleNaviLatitudeMStart(oMStart.VehicleNaviLatitudeValue);          
         } else {
            ETG_TRACE_ERR(("vHandleVehicleNaviLatitudeOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}

//VehicleNaviLongitude
tVoid veda_tclServiceVehicle::vHandleVehicleNaviLongitudeOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tVehicleNaviLongitude_VehicleNaviLongitudeValue = oMStart.VehicleNaviLongitudeValue;



            // Remember that we have to send an answer to this request
            _oMemVehicleNaviLongitude.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onVehicleNaviLongitudeMStart(oMStart.VehicleNaviLongitudeValue);          
         } else {
            ETG_TRACE_ERR(("vHandleVehicleNaviLongitudeOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}

//MediaStatusTREGStatus
tVoid veda_tclServiceVehicle::vHandleMediaStatusTREGStatusOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tMediaStatusTREGStatus_MediaStatusTREGStatusValue = oMStart.MediaStatusTREGStatusValue;



            // Remember that we have to send an answer to this request
            _oMemMediaStatusTREGStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onMediaStatusTREGStatusMStart(oMStart.MediaStatusTREGStatusValue);          
         } else {
            ETG_TRACE_ERR(("vHandleMediaStatusTREGStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}

//MediaStatusTREGRTMStatus
tVoid veda_tclServiceVehicle::vHandleMediaStatusTREGRTMStatusOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tMediaStatusTREGRTMStatus_MediaStatusTREGRTMStatusValue = oMStart.MediaStatusTREGRTMStatusValue;



            // Remember that we have to send an answer to this request
            _oMemMediaStatusTREGRTMStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onMediaStatusTREGRTMStatusMStart(oMStart.MediaStatusTREGRTMStatusValue);          
         } else {
            ETG_TRACE_ERR(("vHandleMediaStatusTREGRTMStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}



//MediaStatusRDSStatus
tVoid veda_tclServiceVehicle::vHandleMediaStatusRDSStatusOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tMediaStatusRDSStatus_MediaStatusRDSStatusValue = oMStart.MediaStatusRDSStatusValue;



            // Remember that we have to send an answer to this request
            _oMemMediaStatusRDSStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onMediaStatusRDSStatusMStart(oMStart.MediaStatusRDSStatusValue);          
         } else {
            ETG_TRACE_ERR(("vHandleMediaStatusRDSStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}



//MediaStatusTAStatus
tVoid veda_tclServiceVehicle::vHandleMediaStatusTAStatusOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tMediaStatusTAStatus_MediaStatusTAStatusValue = oMStart.MediaStatusTAStatusValue;



            // Remember that we have to send an answer to this request
            _oMemMediaStatusTAStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onMediaStatusTAStatusMStart(oMStart.MediaStatusTAStatusValue);          
         } else {
            ETG_TRACE_ERR(("vHandleMediaStatusTAStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}



//MediaStatusTPStatus
tVoid veda_tclServiceVehicle::vHandleMediaStatusTPStatusOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tMediaStatusTPStatus_MediaStatusTPStatusValue = oMStart.MediaStatusTPStatusValue;



            // Remember that we have to send an answer to this request
            _oMemMediaStatusTPStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onMediaStatusTPStatusMStart(oMStart.MediaStatusTPStatusValue);          
         } else {
            ETG_TRACE_ERR(("vHandleMediaStatusTPStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}


//MediaStatusTunerBandStatus
tVoid veda_tclServiceVehicle::vHandleMediaStatusTunerBandStatusOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tMediaStatusTunerBandStatus_MediaStatusTunerBandStatusValue = oMStart.MediaStatusTunerBandStatusValue;



            // Remember that we have to send an answer to this request
            _oMemMediaStatusTunerBandStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onMediaStatusTunerBandStatusMStart(oMStart.MediaStatusTunerBandStatusValue);          
         } else {
            ETG_TRACE_ERR(("vHandleMediaStatusTunerBandStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}



//MediaStatusTunerPresetStatus
tVoid veda_tclServiceVehicle::vHandleMediaStatusTunerPresetStatusOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tMediaStatusTunerPresetStatus_MediaStatusTunerPresetStatusValue = oMStart.MediaStatusTunerPresetStatusValue;



            // Remember that we have to send an answer to this request
            _oMemMediaStatusTunerPresetStatus.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onMediaStatusTunerPresetStatusMStart(oMStart.MediaStatusTunerPresetStatusValue);          
         } else {
            ETG_TRACE_ERR(("vHandleMediaStatusTunerPresetStatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}



//HUS_DM1_Status
tVoid veda_tclServiceVehicle::vHandleHUS_DM1_StatusOpMStart(amt_tclServiceData* poMessage){
	if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgHUS_DM1_StatusMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, VEHICLE_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tHUS_DM1_Status_HUS_DM1_StatusValue = oMStart.HUS_DM1_StatusValue;



            // Remember that we have to send an answer to this request
            _oMemHUS_DM1_Status.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

           
            if (_poCallbackIf) _poCallbackIf->onHUS_DM1_StatusMStart(oMStart.HUS_DM1_StatusValue);          
         } else {
            ETG_TRACE_ERR(("vHandleHUS_DM1_StatusOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }
}



tVoid veda_tclServiceVehicle::onCam1ManActMStart(tU8 RequestId){
	(tVoid) RequestId;
}
tVoid veda_tclServiceVehicle::onCam2ManActMStart(tU8 RequestId){
	(tVoid) RequestId;
}
tVoid veda_tclServiceVehicle::onCam3ManActMStart(tU8 RequestId){
	(tVoid) RequestId;
}
tVoid veda_tclServiceVehicle::onCam4ManActMStart(tU8 RequestId){
	(tVoid) RequestId;
}
tVoid veda_tclServiceVehicle::onCam5ManActMStart(tU8 RequestId){
	(tVoid) RequestId;
}
tVoid veda_tclServiceVehicle::onCam6ManActMStart(tU8 RequestId){
	(tVoid) RequestId;
}
tVoid veda_tclServiceVehicle::onCam7ManActMStart(tU8 RequestId){
	(tVoid) RequestId;
}
tVoid veda_tclServiceVehicle::onCam8ManActMStart(tU8 RequestId){
	(tVoid) RequestId;
}
tVoid veda_tclServiceVehicle::onCam9ManActMStart(tU8 RequestId){
	(tVoid) RequestId;
}
tVoid veda_tclServiceVehicle::onCam10ManActMStart(tU8 RequestId){
	(tVoid) RequestId;
}
tVoid veda_tclServiceVehicle::onCam11ManActMStart(tU8 RequestId){
	(tVoid) RequestId;
}
tVoid veda_tclServiceVehicle::onCam12ManActMStart(tU8 RequestId){
	(tVoid) RequestId;
}
tVoid veda_tclServiceVehicle::onCam13ManActMStart(tU8 RequestId){
	(tVoid) RequestId;
}
tVoid veda_tclServiceVehicle::onCam14ManActMStart(tU8 RequestId){
	(tVoid) RequestId;
}
tVoid veda_tclServiceVehicle::onCam15ManActMStart(tU8 RequestId){
	(tVoid) RequestId;
}
tVoid veda_tclServiceVehicle::onCam16ManActMStart(tU8 RequestId){
	(tVoid) RequestId;
}
tVoid veda_tclServiceVehicle::onCam17ManActMStart(tU8 RequestId){
	(tVoid) RequestId;
}
tVoid veda_tclServiceVehicle::onPrivacyResetAckMStart(tU8 RequestId){
	(tVoid) RequestId;
}
tVoid veda_tclServiceVehicle::onDispCamClsMStart(tU8 RequestId){
	(tVoid) RequestId;
}
tVoid veda_tclServiceVehicle::onPhoneBTLinkStatusMStart(tU8 BTLinkStatus){
	(tVoid) BTLinkStatus;
}
tVoid veda_tclServiceVehicle::onPhoneBookSyncstatusMStart(tU8 PhoneBookSyncStatusValue){
	(tVoid) PhoneBookSyncStatusValue;
}
tVoid veda_tclServiceVehicle::onCallHistorySyncStatusMStart(tU8 CallHistorySyncStatusValue){
	(tVoid) CallHistorySyncStatusValue;
}
tVoid veda_tclServiceVehicle::onPhoneStatusRoamingMStart(tU8 PhoneStatusRoamingValue){
	(tVoid) PhoneStatusRoamingValue;
}
tVoid veda_tclServiceVehicle::onCallDurationMStart(tU16 CallDurationValue){
	(tVoid) CallDurationValue;
}
tVoid veda_tclServiceVehicle::onGSMSignalStrengthMStart(tU8 GSMSignalStrengthValue){
	(tVoid) GSMSignalStrengthValue;
}
tVoid veda_tclServiceVehicle::onPhoneCallStatusMStart(tU8 CallStatusValue){
	(tVoid) CallStatusValue;
}
tVoid veda_tclServiceVehicle::onPhoneBatteryLevelStatusMStart(tU8 PhoneBatteryLevelStatusValue){
	(tVoid) PhoneBatteryLevelStatusValue;
}
tVoid veda_tclServiceVehicle::onDeviceStatusWifiAvailableMStart(tU8 DeviceStatusWifiStatus){
	(tVoid) DeviceStatusWifiStatus;
}
tVoid veda_tclServiceVehicle::onMediaStatusAudioSourceMStart(tU8 AudioSource){
	(tVoid) AudioSource;
}
tVoid veda_tclServiceVehicle::onPhoneAvailableStatusMStart(tU8 PhoneAvailableStatusValue){
	(tVoid) PhoneAvailableStatusValue;
}
tVoid veda_tclServiceVehicle::onPhoneVRAvailableMStart(tU8 PhoneVRAvailableValue){
	(tVoid) PhoneVRAvailableValue;
}
tVoid veda_tclServiceVehicle::onDeviceStatusBTStatusMStart(tU8 DeviceStatusBTStatusValue){
	(tVoid) DeviceStatusBTStatusValue;
}
tVoid veda_tclServiceVehicle::onDeviceStatusBluetoothAvailMStart(tU8 DeviceStatusBluetoothAvailValue){
	(tVoid) DeviceStatusBluetoothAvailValue;
}
tVoid veda_tclServiceVehicle::onReq_DeviceInfoMStart(tU8 Req_DeviceInfoValue){
	(tVoid) Req_DeviceInfoValue;
}
tVoid veda_tclServiceVehicle::onMediaStatusVolumeMStart(tU8 volume){
	(tVoid) volume;
}
tVoid veda_tclServiceVehicle::onCabinMediaStatusAudioSourceMStart(tU8 CabinAudioSource){
	(tVoid) CabinAudioSource;
}
tVoid veda_tclServiceVehicle::onCabinMediaStatusTunerBandMStart(tU8 CabinMediaStatusTunerBandValue){
	(tVoid) CabinMediaStatusTunerBandValue;
}
tVoid veda_tclServiceVehicle::onCabinMediaStatusVolumeMStart(tU8 CabinVolume){
	(tVoid) CabinVolume;
}
tVoid veda_tclServiceVehicle::onVehicleNaviLatitudeMStart(tU32 VehicleNaviLatitudeValue){
	(tVoid) VehicleNaviLatitudeValue;
}
tVoid veda_tclServiceVehicle::onVehicleNaviLongitudeMStart(tU32 VehicleNaviLongitudeValue){
	(tVoid) VehicleNaviLongitudeValue;
}
tVoid veda_tclServiceVehicle::onMediaStatusMuteStatusMStart(tU8 MediaStatusMuteValue){
	(tVoid) MediaStatusMuteValue;
}
tVoid veda_tclServiceVehicle::onCabinMediaStatusMuteStatusMStart(tU8 CabinMediaStatusMuteValue){
	(tVoid) CabinMediaStatusMuteValue;
}
tVoid veda_tclServiceVehicle::onMediaStatusPlayStatusMStart(tU8 MediaStatusPlayStatusValue){
	(tVoid) MediaStatusPlayStatusValue;
}
tVoid veda_tclServiceVehicle::onMediaStatusSeekStatusMStart(tU8 MediaStatusSeekStatusValue){
	(tVoid) MediaStatusSeekStatusValue;
}
tVoid veda_tclServiceVehicle::onMediaStatusRepeatStatusMStart(tU8 MediaStatusRepeatStatusValue){
	(tVoid) MediaStatusRepeatStatusValue;
}
tVoid veda_tclServiceVehicle::onMediaStatusDABFMStatusMStart(tU8 MediaStatusDABFMStatusValue){
	(tVoid) MediaStatusDABFMStatusValue;
}
tVoid veda_tclServiceVehicle::onMediaStatusTREGStatusMStart(tU8 MediaStatusTREGStatusValue){
	(tVoid) MediaStatusTREGStatusValue;
}
tVoid veda_tclServiceVehicle::onMediaStatusTREGRTMStatusMStart(tU8 MediaStatusTREGRTMStatusValue){
	(tVoid) MediaStatusTREGRTMStatusValue;
}
tVoid veda_tclServiceVehicle::onMediaStatusRDSStatusMStart(tU8 MediaStatusRDSStatusValue){
	(tVoid) MediaStatusRDSStatusValue;
}
tVoid veda_tclServiceVehicle::onMediaStatusTAStatusMStart(tU8 MediaStatusTAStatusValue){
	(tVoid) MediaStatusTAStatusValue;
}
tVoid veda_tclServiceVehicle::onMediaStatusTPStatusMStart(tU8 MediaStatusTPStatusValue){
	(tVoid) MediaStatusTPStatusValue;
}
tVoid veda_tclServiceVehicle::onMediaStatusTunerBandStatusMStart(tU8 MediaStatusTunerBandStatusValue){
	(tVoid) MediaStatusTunerBandStatusValue;
}
tVoid veda_tclServiceVehicle::onMediaStatusTunerPresetStatusMStart(tU8 MediaStatusTunerPresetStatusValue){
	(tVoid) MediaStatusTunerPresetStatusValue;
}
tVoid veda_tclServiceVehicle::onMediaStatusMixStateMStart(tU8 MediaStatusMixStateValue){
	(tVoid) MediaStatusMixStateValue;
}
tVoid veda_tclServiceVehicle::onMediaStatusPlaylistModeMStart(tU8 MediaStatusPlaylistModeValue){
	(tVoid) MediaStatusPlaylistModeValue;
}
tVoid veda_tclServiceVehicle::onMediaStatusTrackTimeMStart(tU16 MediaStatusTrackTimeValue){
	(tVoid) MediaStatusTrackTimeValue;
}
tVoid veda_tclServiceVehicle::onMediaStatusCurrTrackNumMStart(tU16 MediaStatusCurrTrackNumValue){
	(tVoid) MediaStatusCurrTrackNumValue;
}
tVoid veda_tclServiceVehicle::onDeviceStatusRadioStatusMStart(tU8 DeviceStatusRadioStatusValue){
	(tVoid) DeviceStatusRadioStatusValue;
}
tVoid veda_tclServiceVehicle::onDeviceStatusDABAvailStatusMStart(tU8 DeviceStatusDABAvailStatusValue){
	(tVoid) DeviceStatusDABAvailStatusValue;
}
tVoid veda_tclServiceVehicle::onDeviceStatusNavDataMStart(tU8 DeviceStatusNavDataValue){
	(tVoid) DeviceStatusNavDataValue;
}
tVoid veda_tclServiceVehicle::onDeviceStatusUSB1PresentMStart(tU8 DeviceStatusUSB1PresentValue){
	(tVoid) DeviceStatusUSB1PresentValue;
}
tVoid veda_tclServiceVehicle::onDeviceStatusUSB2PresentMStart(tU8 DeviceStatusUSB2PresentValue){
	(tVoid) DeviceStatusUSB2PresentValue;
}
tVoid veda_tclServiceVehicle::onDeviceStatusNaviAvailMStart(tU8 DeviceStatusNaviAvailValue){
	(tVoid) DeviceStatusNaviAvailValue;
}
tVoid veda_tclServiceVehicle::onDeviceStatusUSB1SrcMStart(tU8 DeviceStatusUSB1SrcValue){
	(tVoid) DeviceStatusUSB1SrcValue;
}
tVoid veda_tclServiceVehicle::onDeviceStatusUSB2SrcMStart(tU8 DeviceStatusUSB2SrcValue){
	(tVoid) DeviceStatusUSB2SrcValue;
}
tVoid veda_tclServiceVehicle::onDeviceStatusAMFMAvailMStart(tU8 DeviceStatusAMFMAvailValue){
	(tVoid) DeviceStatusAMFMAvailValue;
}
tVoid veda_tclServiceVehicle::onHUS_DM1_StatusMStart(tU64 HUS_DM1_StatusValue){
	(tVoid) HUS_DM1_StatusValue;
}

tVoid veda_tclServiceVehicle::sendCam1ManActMResult(tU8 Result){
	if (_oMemCam1ManAct.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgCam1ManActMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemCam1ManAct.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemCam1ManAct.u16GetSourceAppID(), 
         _oMemCam1ManAct.u16GetRegisterID(), 
         _oMemCam1ManAct.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_CAM1MANACT, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);
	  ETG_TRACE_USR4(("sendCam1ManActMResult(): enPostMessage value %u", (tU32)enResult));

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendCam1ManActMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_CAM1MANACT, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid veda_tclServiceVehicle::sendCam2ManActMResult(tU8 Result){
	if (_oMemCam2ManAct.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgCam2ManActMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemCam2ManAct.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemCam2ManAct.u16GetSourceAppID(), 
         _oMemCam2ManAct.u16GetRegisterID(), 
         _oMemCam2ManAct.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_CAM2MANACT, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendCam2ManActMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_CAM2MANACT, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid veda_tclServiceVehicle::sendCam3ManActMResult(tU8 Result){
	if (_oMemCam3ManAct.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgCam3ManActMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemCam3ManAct.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemCam3ManAct.u16GetSourceAppID(), 
         _oMemCam3ManAct.u16GetRegisterID(), 
         _oMemCam3ManAct.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_CAM3MANACT, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendCam3ManActMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_CAM3MANACT, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid veda_tclServiceVehicle::sendCam4ManActMResult(tU8 Result){
	if (_oMemCam4ManAct.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgCam4ManActMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemCam4ManAct.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemCam4ManAct.u16GetSourceAppID(), 
         _oMemCam4ManAct.u16GetRegisterID(), 
         _oMemCam4ManAct.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_CAM4MANACT, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendCam4ManActMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_CAM4MANACT, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid veda_tclServiceVehicle::sendCam5ManActMResult(tU8 Result){
	if (_oMemCam5ManAct.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgCam5ManActMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemCam5ManAct.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemCam5ManAct.u16GetSourceAppID(), 
         _oMemCam5ManAct.u16GetRegisterID(), 
         _oMemCam5ManAct.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_CAM5MANACT, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendCam5ManActMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_CAM5MANACT, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid veda_tclServiceVehicle::sendCam6ManActMResult(tU8 Result){
	if (_oMemCam6ManAct.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgCam6ManActMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemCam6ManAct.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemCam6ManAct.u16GetSourceAppID(), 
         _oMemCam6ManAct.u16GetRegisterID(), 
         _oMemCam6ManAct.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_CAM6MANACT, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendCam6ManActMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_CAM6MANACT, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid veda_tclServiceVehicle::sendCam7ManActMResult(tU8 Result){
	if (_oMemCam7ManAct.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgCam7ManActMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemCam7ManAct.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemCam7ManAct.u16GetSourceAppID(), 
         _oMemCam7ManAct.u16GetRegisterID(), 
         _oMemCam7ManAct.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_CAM7MANACT, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendCam7ManActMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_CAM7MANACT, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}


tVoid veda_tclServiceVehicle::sendCam8ManActMResult(tU8 Result){
	if (_oMemCam8ManAct.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgCam8ManActMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemCam8ManAct.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemCam8ManAct.u16GetSourceAppID(), 
         _oMemCam8ManAct.u16GetRegisterID(), 
         _oMemCam8ManAct.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_CAM8MANACT, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendCam8ManActMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_CAM8MANACT, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}


tVoid veda_tclServiceVehicle::sendCam9ManActMResult(tU8 Result){
	if (_oMemCam9ManAct.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgCam9ManActMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemCam9ManAct.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemCam9ManAct.u16GetSourceAppID(), 
         _oMemCam9ManAct.u16GetRegisterID(), 
         _oMemCam9ManAct.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_CAM9MANACT, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendCam9ManActMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_CAM9MANACT, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}


tVoid veda_tclServiceVehicle::sendCam10ManActMResult(tU8 Result){
	if (_oMemCam10ManAct.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgCam10ManActMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemCam10ManAct.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemCam10ManAct.u16GetSourceAppID(), 
         _oMemCam10ManAct.u16GetRegisterID(), 
         _oMemCam10ManAct.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_CAM10MANACT, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendCam10ManActMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_CAM10MANACT, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}


tVoid veda_tclServiceVehicle::sendCam11ManActMResult(tU8 Result){
	if (_oMemCam11ManAct.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgCam11ManActMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemCam10ManAct.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemCam11ManAct.u16GetSourceAppID(), 
         _oMemCam11ManAct.u16GetRegisterID(), 
         _oMemCam11ManAct.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_CAM11MANACT, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendCam11ManActMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_CAM11MANACT, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}


tVoid veda_tclServiceVehicle::sendCam12ManActMResult(tU8 Result){
	if (_oMemCam12ManAct.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgCam12ManActMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemCam12ManAct.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemCam12ManAct.u16GetSourceAppID(), 
         _oMemCam12ManAct.u16GetRegisterID(), 
         _oMemCam12ManAct.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_CAM12MANACT, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendCam12ManActMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_CAM12MANACT, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}

tVoid veda_tclServiceVehicle::sendCam13ManActMResult(tU8 Result){
	if (_oMemCam13ManAct.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgCam13ManActMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemCam13ManAct.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemCam13ManAct.u16GetSourceAppID(), 
         _oMemCam13ManAct.u16GetRegisterID(), 
         _oMemCam13ManAct.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_CAM13MANACT, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendCam13ManActMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_CAM13MANACT, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}


tVoid veda_tclServiceVehicle::sendCam14ManActMResult(tU8 Result){
	if (_oMemCam14ManAct.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgCam14ManActMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemCam14ManAct.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemCam14ManAct.u16GetSourceAppID(), 
         _oMemCam14ManAct.u16GetRegisterID(), 
         _oMemCam14ManAct.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_CAM14MANACT, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendCam14ManActMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_CAM14MANACT, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}



tVoid veda_tclServiceVehicle::sendCam15ManActMResult(tU8 Result){
	if (_oMemCam15ManAct.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgCam15ManActMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemCam15ManAct.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemCam15ManAct.u16GetSourceAppID(), 
         _oMemCam15ManAct.u16GetRegisterID(), 
         _oMemCam15ManAct.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_CAM15MANACT, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendCam15ManActMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_CAM15MANACT, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}


tVoid veda_tclServiceVehicle::sendCam16ManActMResult(tU8 Result){
	if (_oMemCam16ManAct.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgCam16ManActMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemCam16ManAct.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemCam16ManAct.u16GetSourceAppID(), 
         _oMemCam16ManAct.u16GetRegisterID(), 
         _oMemCam16ManAct.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_CAM16MANACT, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendCam16ManActMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_CAM16MANACT, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}

tVoid veda_tclServiceVehicle::sendCam17ManActMResult(tU8 Result){
	if (_oMemCam17ManAct.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgCam17ManActMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemCam17ManAct.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemCam17ManAct.u16GetSourceAppID(), 
         _oMemCam17ManAct.u16GetRegisterID(), 
         _oMemCam17ManAct.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_CAM17MANACT, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendCam17ManActMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_CAM17MANACT, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}


tVoid veda_tclServiceVehicle::sendPrivacyResetAckMResult(tU8 Result){
	if (_oMemPrivacyResetAck.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgPrivacyResetAckMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemPrivacyResetAck.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemPrivacyResetAck.u16GetSourceAppID(), 
         _oMemPrivacyResetAck.u16GetRegisterID(), 
         _oMemPrivacyResetAck.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_PRIVACYRESETACK, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendPrivacyResetAckMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_PRIVACYRESETACK, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
//DispCamCls
tVoid veda_tclServiceVehicle::sendDispCamClsMResult(tU8 Result){
	if (_oMemDispCamCls.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgDispCamClsMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemDispCamCls.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDispCamCls.u16GetSourceAppID(), 
         _oMemDispCamCls.u16GetRegisterID(), 
         _oMemDispCamCls.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_DISPCAMCLS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);
	  ETG_TRACE_USR4(("sendDispCamClsMResult(): enPostMessage value %u", (tU32)enResult));

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendDispCamClsMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_DISPCAMCLS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}

tVoid veda_tclServiceVehicle::sendPhoneBTLinkStatusMResult(tU8 Result){
	if (_oMemPhoneBTLinkStatus.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemPhoneBTLinkStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemPhoneBTLinkStatus.u16GetSourceAppID(), 
         _oMemPhoneBTLinkStatus.u16GetRegisterID(), 
         _oMemPhoneBTLinkStatus.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_PHONEBTLINKSTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendPhoneBTLinkStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_PHONEBTLINKSTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}


tVoid veda_tclServiceVehicle::sendPhoneBookSyncstatusMResult(tU8 Result){
	if (_oMemPhoneBookSyncStatus.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemPhoneBookSyncStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemPhoneBookSyncStatus.u16GetSourceAppID(), 
         _oMemPhoneBookSyncStatus.u16GetRegisterID(), 
         _oMemPhoneBookSyncStatus.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_PHONEBOOKSYNCSTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendPhoneBookSyncstatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_PHONEBOOKSYNCSTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}


tVoid veda_tclServiceVehicle::sendCallHistorySyncStatusMResult(tU8 Result){
	if (_oMemCallHistorySyncStatus.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgCallHistorySyncStatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemCallHistorySyncStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemCallHistorySyncStatus.u16GetSourceAppID(), 
         _oMemCallHistorySyncStatus.u16GetRegisterID(), 
         _oMemCallHistorySyncStatus.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_CALLHISTORYSYNCSTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendCallHistorySyncStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_CALLHISTORYSYNCSTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}


tVoid veda_tclServiceVehicle::sendPhoneStatusRoamingMResult(tU8 Result){
	if (_oMemPhoneStatusRoaming.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgPhoneStatusRoamingMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemPhoneStatusRoaming.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemPhoneStatusRoaming.u16GetSourceAppID(), 
         _oMemPhoneStatusRoaming.u16GetRegisterID(), 
         _oMemPhoneStatusRoaming.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_PHONESTATUSROAMING, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendPhoneStatusRoamingMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_PHONESTATUSROAMING, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}

tVoid veda_tclServiceVehicle::sendCallDurationMResult(tU8 Result){
	if (_oMemCallDuration.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgCallDurationMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemCallDuration.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemCallDuration.u16GetSourceAppID(), 
         _oMemCallDuration.u16GetRegisterID(), 
         _oMemCallDuration.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_CALLDURATION, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendCallDurationMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_CALLDURATION, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}


tVoid veda_tclServiceVehicle::sendGSMSignalStrengthMResult(tU8 Result){
	if (_oMemGSMSignalStrength.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgGSMSignalStrengthMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemGSMSignalStrength.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemGSMSignalStrength.u16GetSourceAppID(), 
         _oMemGSMSignalStrength.u16GetRegisterID(), 
         _oMemGSMSignalStrength.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_GSMSIGNALSTRENGTH, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendGSMSignalStrengthMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_GSMSIGNALSTRENGTH, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}

tVoid veda_tclServiceVehicle::sendPhoneCallStatusMResult(tU8 Result){
	if (_oMemPhoneCallStatus.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgPhoneCallStatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemPhoneCallStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemPhoneCallStatus.u16GetSourceAppID(), 
         _oMemPhoneCallStatus.u16GetRegisterID(), 
         _oMemPhoneCallStatus.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_PHONECALLSTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendPhoneCallStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_PHONECALLSTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}

tVoid veda_tclServiceVehicle::sendPhoneBatteryLevelStatusMResult(tU8 Result){
	if (_oMemPhoneBatteryLevelStatus.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemPhoneBatteryLevelStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemPhoneBatteryLevelStatus.u16GetSourceAppID(), 
         _oMemPhoneBatteryLevelStatus.u16GetRegisterID(), 
         _oMemPhoneBatteryLevelStatus.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_PHONEBATTERYLEVELSTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendPhoneBatteryLevelStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_PHONEBATTERYLEVELSTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}


tVoid veda_tclServiceVehicle::sendDeviceStatusWifiAvailableMResult(tU8 Result){
	if (_oMemDeviceStatusWifiAvailable.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemDeviceStatusWifiAvailable.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDeviceStatusWifiAvailable.u16GetSourceAppID(), 
         _oMemDeviceStatusWifiAvailable.u16GetRegisterID(), 
         _oMemDeviceStatusWifiAvailable.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_DEVICESTATUSWIFIAVAILABLE, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendDeviceStatusWifiAvailableMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_DEVICESTATUSWIFIAVAILABLE, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}


tVoid veda_tclServiceVehicle::sendMediaStatusAudioSourceMResult(tU8 Result){
	if (_oMemMediaStatusAudioSource.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemMediaStatusAudioSource.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemMediaStatusAudioSource.u16GetSourceAppID(), 
         _oMemMediaStatusAudioSource.u16GetRegisterID(), 
         _oMemMediaStatusAudioSource.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_MEDIASTATUSAUDIOSOURCE, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendMediaStatusAudioSourceMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_MEDIASTATUSAUDIOSOURCE, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}

tVoid veda_tclServiceVehicle::sendPhoneAvailableStatusMResult(tU8 Result){
	if (_oMemPhoneAvailableStatus.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgPhoneAvailableStatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemPhoneAvailableStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemPhoneAvailableStatus.u16GetSourceAppID(), 
         _oMemPhoneAvailableStatus.u16GetRegisterID(), 
         _oMemPhoneAvailableStatus.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_PHONEAVAILABLESTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendPhoneAvailableStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_PHONEAVAILABLESTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}


tVoid veda_tclServiceVehicle::sendPhoneVRAvailableMResult(tU8 Result){
	if (_oMemPhoneVRAvailable.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgPhoneVRAvailableMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemPhoneVRAvailable.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemPhoneVRAvailable.u16GetSourceAppID(), 
         _oMemPhoneVRAvailable.u16GetRegisterID(), 
         _oMemPhoneVRAvailable.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_PHONEVRAVAILABLE, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendPhoneVRAvailableMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_PHONEVRAVAILABLE, (tU32)enResult));
      }
      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}


tVoid veda_tclServiceVehicle::sendDeviceStatusBTStatusMResult(tU8 Result){
	if (_oMemDeviceStatusBTStatus.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemDeviceStatusBTStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDeviceStatusBTStatus.u16GetSourceAppID(), 
         _oMemDeviceStatusBTStatus.u16GetRegisterID(), 
         _oMemDeviceStatusBTStatus.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_DEVICESTATUSBTSTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendDeviceStatusBTStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_DEVICESTATUSBTSTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}

tVoid veda_tclServiceVehicle::sendDeviceStatusBluetoothAvailMResult(tU8 Result){
	if (_oMemDeviceStatusBluetoothAvail.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemDeviceStatusBluetoothAvail.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDeviceStatusBluetoothAvail.u16GetSourceAppID(), 
         _oMemDeviceStatusBluetoothAvail.u16GetRegisterID(), 
         _oMemDeviceStatusBluetoothAvail.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_DEVICESTATUSBLUETOOTHAVAIL, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendDeviceStatusBluetoothAvailMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_DEVICESTATUSBLUETOOTHAVAIL, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}

tVoid veda_tclServiceVehicle::sendReq_DeviceInfoMResult(tU8 Result){
	if (_oMemReq_DeviceInfo.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgReq_DeviceInfoMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemReq_DeviceInfo.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemReq_DeviceInfo.u16GetSourceAppID(), 
         _oMemReq_DeviceInfo.u16GetRegisterID(), 
         _oMemReq_DeviceInfo.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_REQ_DEVICEINFO, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendReq_DeviceInfoMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_REQ_DEVICEINFO, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}

tVoid veda_tclServiceVehicle::sendMediaStatusVolumeMResult(tU8 Result){
	if (_oMemMediaStatusVolume.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgMediaStatusVolumeMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemMediaStatusVolume.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemMediaStatusVolume.u16GetSourceAppID(), 
         _oMemMediaStatusVolume.u16GetRegisterID(), 
         _oMemMediaStatusVolume.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_MEDIASTATUSVOLUME, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendMediaStatusVolumeMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_MEDIASTATUSVOLUME, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}

tVoid veda_tclServiceVehicle::sendCabinMediaStatusAudioSourceMResult(tU8 Result){
	if (_oMemCabinMediaStatusAudioSource.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemCabinMediaStatusAudioSource.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemCabinMediaStatusAudioSource.u16GetSourceAppID(), 
         _oMemCabinMediaStatusAudioSource.u16GetRegisterID(), 
         _oMemCabinMediaStatusAudioSource.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_CABINMEDIASTATUSAUDIOSOURCE, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendCabinMediaStatusAudioSourceMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_CABINMEDIASTATUSAUDIOSOURCE, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}



tVoid veda_tclServiceVehicle::sendCabinMediaStatusTunerBandMResult(tU8 Result){
	if (_oMemCabinMediaStatusTunerBand.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemCabinMediaStatusTunerBand.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemCabinMediaStatusTunerBand.u16GetSourceAppID(), 
         _oMemCabinMediaStatusTunerBand.u16GetRegisterID(), 
         _oMemCabinMediaStatusTunerBand.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_CABINMEDIASTATUSTUNERBAND, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendCabinMediaStatusTunerBandMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_CABINMEDIASTATUSTUNERBAND, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}





tVoid veda_tclServiceVehicle::sendCabinMediaStatusVolumeMResult(tU8 Result){
	if (_oMemCabinMediaStatusVolume.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemCabinMediaStatusVolume.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemCabinMediaStatusVolume.u16GetSourceAppID(), 
         _oMemCabinMediaStatusVolume.u16GetRegisterID(), 
         _oMemCabinMediaStatusVolume.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_CABINMEDIASTATUSVOLUME, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendCabinMediaStatusVolumeMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_CABINMEDIASTATUSVOLUME, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}

tVoid veda_tclServiceVehicle::sendMediaStatusMuteStatusMResult(tU8 Result){
	if (_oMemMediaStatusMuteStatus.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemMediaStatusMuteStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemMediaStatusMuteStatus.u16GetSourceAppID(), 
         _oMemMediaStatusMuteStatus.u16GetRegisterID(), 
         _oMemMediaStatusMuteStatus.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_MEDIASTATUSMUTESTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendMediaStatusMuteStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_MEDIASTATUSMUTESTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}


tVoid veda_tclServiceVehicle::sendCabinMediaStatusMuteStatusMResult(tU8 Result){
	if (_oMemCabinMediaStatusMuteStatus.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemCabinMediaStatusMuteStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemCabinMediaStatusMuteStatus.u16GetSourceAppID(), 
         _oMemCabinMediaStatusMuteStatus.u16GetRegisterID(), 
         _oMemCabinMediaStatusMuteStatus.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_CABINMEDIASTATUSMUTESTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendCabinMediaStatusMuteStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_CABINMEDIASTATUSMUTESTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}



tVoid veda_tclServiceVehicle::sendMediaStatusPlayStatusMResult(tU8 Result){
	if (_oMemMediaStatusPlayStatus.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemMediaStatusPlayStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemMediaStatusPlayStatus.u16GetSourceAppID(), 
         _oMemMediaStatusPlayStatus.u16GetRegisterID(), 
         _oMemMediaStatusPlayStatus.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_MEDIASTATUSPLAYSTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendMediaStatusPlayStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_MEDIASTATUSPLAYSTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid veda_tclServiceVehicle::sendMediaStatusMixStateMResult(tU8 Result){
	if (_oMemMediaStatusMixState.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgMediaStatusMixStateMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemMediaStatusMixState.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemMediaStatusMixState.u16GetSourceAppID(), 
         _oMemMediaStatusMixState.u16GetRegisterID(), 
         _oMemMediaStatusMixState.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_MEDIASTATUSMIXSTATE, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendMediaStatusMixStateMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_MEDIASTATUSMIXSTATE, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}

tVoid veda_tclServiceVehicle::sendMediaStatusCurrTrackNumMResult(tU8 Result){
	if (_oMemMediaStatusCurrTrackNum.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemMediaStatusCurrTrackNum.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemMediaStatusCurrTrackNum.u16GetSourceAppID(), 
         _oMemMediaStatusCurrTrackNum.u16GetRegisterID(), 
         _oMemMediaStatusCurrTrackNum.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_MEDIASTATUSCURRTRACKNUM, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendMediaStatusCurrTrackNumMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_MEDIASTATUSCURRTRACKNUM, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}

tVoid veda_tclServiceVehicle::sendDeviceStatusRadioStatusMResult(tU8 Result){
	if (_oMemDeviceStatusRadioStatus.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemDeviceStatusRadioStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDeviceStatusRadioStatus.u16GetSourceAppID(), 
         _oMemDeviceStatusRadioStatus.u16GetRegisterID(), 
         _oMemDeviceStatusRadioStatus.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_DEVICESTATUSRADIOSTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendDeviceStatusRadioStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_DEVICESTATUSRADIOSTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}

tVoid veda_tclServiceVehicle::sendDeviceStatusDABAvailStatusMResult(tU8 Result){
	if (_oMemDeviceStatusDABAvailStatus.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemDeviceStatusDABAvailStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDeviceStatusDABAvailStatus.u16GetSourceAppID(), 
         _oMemDeviceStatusDABAvailStatus.u16GetRegisterID(), 
         _oMemDeviceStatusDABAvailStatus.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_DEVICESTATUSDABAVAILSTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendDeviceStatusDABAvailStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_DEVICESTATUSDABAVAILSTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}

tVoid veda_tclServiceVehicle::sendDeviceStatusNavDataMResult(tU8 Result){
	if (_oMemDeviceStatusNavData.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgDeviceStatusNavDataMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemDeviceStatusNavData.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDeviceStatusNavData.u16GetSourceAppID(), 
         _oMemDeviceStatusNavData.u16GetRegisterID(), 
         _oMemDeviceStatusNavData.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_DEVICESTATUSNAVDATA, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendDeviceStatusNavDataMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_DEVICESTATUSNAVDATA, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}

tVoid veda_tclServiceVehicle::sendDeviceStatusUSB1PresentMResult(tU8 Result){
	if (_oMemDeviceStatusUSB1Present.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemDeviceStatusUSB1Present.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDeviceStatusUSB1Present.u16GetSourceAppID(), 
         _oMemDeviceStatusUSB1Present.u16GetRegisterID(), 
         _oMemDeviceStatusUSB1Present.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_DEVICESTATUSUSB1PRESENT, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendDeviceStatusUSB1PresentMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_DEVICESTATUSUSB1PRESENT, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid veda_tclServiceVehicle::sendDeviceStatusUSB2PresentMResult(tU8 Result){
	if (_oMemDeviceStatusUSB2Present.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemDeviceStatusUSB2Present.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDeviceStatusUSB2Present.u16GetSourceAppID(), 
         _oMemDeviceStatusUSB2Present.u16GetRegisterID(), 
         _oMemDeviceStatusUSB2Present.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_DEVICESTATUSUSB2PRESENT, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendDeviceStatusUSB2PresentMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_DEVICESTATUSUSB2PRESENT, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid veda_tclServiceVehicle::sendDeviceStatusUSB1SrcMResult(tU8 Result){
	if (_oMemDeviceStatusUSB1Src.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemDeviceStatusUSB1Src.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDeviceStatusUSB1Src.u16GetSourceAppID(), 
         _oMemDeviceStatusUSB1Src.u16GetRegisterID(), 
         _oMemDeviceStatusUSB1Src.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_DEVICESTATUSUSB1SRC, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendDeviceStatusUSB1SrcMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_DEVICESTATUSUSB1SRC, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid veda_tclServiceVehicle::sendDeviceStatusUSB2SrcMResult(tU8 Result){
	if (_oMemDeviceStatusUSB2Src.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemDeviceStatusUSB2Src.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDeviceStatusUSB2Src.u16GetSourceAppID(), 
         _oMemDeviceStatusUSB2Src.u16GetRegisterID(), 
         _oMemDeviceStatusUSB2Src.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_DEVICESTATUSUSB2SRC, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendDeviceStatusUSB2SrcMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_DEVICESTATUSUSB2SRC, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid veda_tclServiceVehicle::sendDeviceStatusAMFMAvailMResult(tU8 Result){
	if (_oMemDeviceStatusAMFMAvail.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemDeviceStatusAMFMAvail.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDeviceStatusAMFMAvail.u16GetSourceAppID(), 
         _oMemDeviceStatusAMFMAvail.u16GetRegisterID(), 
         _oMemDeviceStatusAMFMAvail.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_DEVICESTATUSAMFMAVAIL, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendDeviceStatusAMFMAvailMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_DEVICESTATUSAMFMAVAIL, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid veda_tclServiceVehicle::sendDeviceStatusNaviAvailMResult(tU8 Result){
	if (_oMemDeviceStatusNaviAvail.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemDeviceStatusNaviAvail.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemDeviceStatusNaviAvail.u16GetSourceAppID(), 
         _oMemDeviceStatusNaviAvail.u16GetRegisterID(), 
         _oMemDeviceStatusNaviAvail.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_DEVICESTATUSNAVIAVAIL, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendDeviceStatusNaviAvailMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_DEVICESTATUSNAVIAVAIL, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}

tVoid veda_tclServiceVehicle::sendMediaStatusTrackTimeMResult(tU8 Result){
	if (_oMemMediaStatusTrackTime.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemMediaStatusTrackTime.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemMediaStatusTrackTime.u16GetSourceAppID(), 
         _oMemMediaStatusTrackTime.u16GetRegisterID(), 
         _oMemMediaStatusTrackTime.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_MEDIASTATUSTRACKTIME, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendMediaStatusTrackTimeMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_MEDIASTATUSTRACKTIME, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}

tVoid veda_tclServiceVehicle::sendMediaStatusPlaylistModeMResult(tU8 Result){
	if (_oMemMediaStatusPlaylistMode.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemMediaStatusPlaylistMode.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemMediaStatusPlaylistMode.u16GetSourceAppID(), 
         _oMemMediaStatusPlaylistMode.u16GetRegisterID(), 
         _oMemMediaStatusPlaylistMode.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_MEDIASTATUSPLAYLISTMODE, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendMediaStatusPlaylistModeMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_MEDIASTATUSPLAYLISTMODE, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}


tVoid veda_tclServiceVehicle::sendMediaStatusSeekStatusMResult(tU8 Result){
	if (_oMemMediaStatusSeekStatus.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemMediaStatusSeekStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemMediaStatusSeekStatus.u16GetSourceAppID(), 
         _oMemMediaStatusSeekStatus.u16GetRegisterID(), 
         _oMemMediaStatusSeekStatus.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_MEDIASTATUSSEEKSTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendMediaStatusSeekStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_MEDIASTATUSSEEKSTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}



tVoid veda_tclServiceVehicle::sendMediaStatusRepeatStatusMResult(tU8 Result){
	if (_oMemMediaStatusRepeatStatus.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemMediaStatusRepeatStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemMediaStatusRepeatStatus.u16GetSourceAppID(), 
         _oMemMediaStatusRepeatStatus.u16GetRegisterID(), 
         _oMemMediaStatusRepeatStatus.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_MEDIASTATUSREPEATSTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendMediaStatusRepeatStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_MEDIASTATUSREPEATSTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}


tVoid veda_tclServiceVehicle::sendMediaStatusDABFMStatusMResult(tU8 Result){
	if (_oMemMediaStatusDABFMStatus.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemMediaStatusDABFMStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemMediaStatusDABFMStatus.u16GetSourceAppID(), 
         _oMemMediaStatusDABFMStatus.u16GetRegisterID(), 
         _oMemMediaStatusDABFMStatus.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_MEDIASTATUSDABFMSTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendMediaStatusDABFMStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_MEDIASTATUSDABFMSTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}



tVoid veda_tclServiceVehicle::sendVehicleNaviLatitudeMResult(tU8 Result){
	if (_oMemVehicleNaviLatitude.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemVehicleNaviLatitude.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemVehicleNaviLatitude.u16GetSourceAppID(), 
         _oMemVehicleNaviLatitude.u16GetRegisterID(), 
         _oMemVehicleNaviLatitude.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_VEHICLENAVILATITUDE, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendVehicleNaviLatitudeMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_VEHICLENAVILATITUDE, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}





tVoid veda_tclServiceVehicle::sendVehicleNaviLongitudeMResult(tU8 Result){
	if (_oMemVehicleNaviLongitude.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemVehicleNaviLongitude.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemVehicleNaviLongitude.u16GetSourceAppID(), 
         _oMemVehicleNaviLongitude.u16GetRegisterID(), 
         _oMemVehicleNaviLongitude.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_VEHICLENAVILONGITUDE, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendVehicleNaviLongitudeMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_VEHICLENAVILONGITUDE, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}



tVoid veda_tclServiceVehicle::sendMediaStatusTREGStatusMResult(tU8 Result){
	if (_oMemMediaStatusTREGStatus.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemMediaStatusTREGStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemMediaStatusTREGStatus.u16GetSourceAppID(), 
         _oMemMediaStatusTREGStatus.u16GetRegisterID(), 
         _oMemMediaStatusTREGStatus.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_MEDIASTATUSTREGSTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendMediaStatusTREGStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_MEDIASTATUSTREGSTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}

tVoid veda_tclServiceVehicle::sendMediaStatusTREGRTMStatusMResult(tU8 Result){
	if (_oMemMediaStatusTREGRTMStatus.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemMediaStatusTREGRTMStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemMediaStatusTREGRTMStatus.u16GetSourceAppID(), 
         _oMemMediaStatusTREGRTMStatus.u16GetRegisterID(), 
         _oMemMediaStatusTREGRTMStatus.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_MEDIASTATUSTREGRTMSTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendMediaStatusTREGRTMStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_MEDIASTATUSTREGRTMSTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}




tVoid veda_tclServiceVehicle::sendMediaStatusRDSStatusMResult(tU8 Result){
	if (_oMemMediaStatusRDSStatus.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemMediaStatusRDSStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemMediaStatusRDSStatus.u16GetSourceAppID(), 
         _oMemMediaStatusRDSStatus.u16GetRegisterID(), 
         _oMemMediaStatusRDSStatus.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_MEDIASTATUSRDSSTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendMediaStatusRDSStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_MEDIASTATUSRDSSTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}

tVoid veda_tclServiceVehicle::sendMediaStatusTAStatusMResult(tU8 Result){
	if (_oMemMediaStatusTAStatus.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgMediaStatusTAStatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemMediaStatusTAStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemMediaStatusTAStatus.u16GetSourceAppID(), 
         _oMemMediaStatusTAStatus.u16GetRegisterID(), 
         _oMemMediaStatusTAStatus.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_MEDIASTATUSTASTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendMediaStatusTAStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_MEDIASTATUSTASTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}

tVoid veda_tclServiceVehicle::sendMediaStatusTunerBandStatusMResult(tU8 Result){
	if (_oMemMediaStatusTunerBandStatus.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemMediaStatusTunerBandStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemMediaStatusTunerBandStatus.u16GetSourceAppID(), 
         _oMemMediaStatusTunerBandStatus.u16GetRegisterID(), 
         _oMemMediaStatusTunerBandStatus.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_MEDIASTATUSTUNERBANDSTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendMediaStatusTunerBandStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_MEDIASTATUSTUNERBANDSTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}

tVoid veda_tclServiceVehicle::sendMediaStatusTPStatusMResult(tU8 Result){
	if (_oMemMediaStatusTPStatus.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgMediaStatusTPStatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemMediaStatusTPStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemMediaStatusTPStatus.u16GetSourceAppID(), 
         _oMemMediaStatusTPStatus.u16GetRegisterID(), 
         _oMemMediaStatusTPStatus.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_MEDIASTATUSTPSTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendMediaStatusTPStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_MEDIASTATUSTPSTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}

tVoid veda_tclServiceVehicle::sendMediaStatusTunerPresetStatusMResult(tU8 Result){
	if (_oMemMediaStatusTunerPresetStatus.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemMediaStatusTunerPresetStatus.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemMediaStatusTunerPresetStatus.u16GetSourceAppID(), 
         _oMemMediaStatusTunerPresetStatus.u16GetRegisterID(), 
         _oMemMediaStatusTunerPresetStatus.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_MEDIASTATUSTUNERPRESETSTATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendMediaStatusTunerPresetStatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_MEDIASTATUSTUNERPRESETSTATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}

tVoid veda_tclServiceVehicle::sendHUS_DM1_StatusMResult(tU8 Result){
	if (_oMemHUS_DM1_Status.bIsPending() == TRUE) {
      vehicle_mainfi_tclMsgHUS_DM1_StatusMethodResult  oMResult;
      //the data content

      oMResult.Result = Result;


      _oMemHUS_DM1_Status.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemHUS_DM1_Status.u16GetSourceAppID(), 
         _oMemHUS_DM1_Status.u16GetRegisterID(), 
         _oMemHUS_DM1_Status.u16GetCMDCounter(), 
         (tU16) VEHICLE_MAINFI_C_U16_HUS_DM1_STATUS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "sendHUS_DM1_StatusMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_HUS_DM1_STATUS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}




// veda_tclServiceVehicleveda_ServiceVehicle: user specific code start
tVoid veda_tclServiceVehicle::vSetDefaultUnitSettings()
{
   tU8 u8DistanceUnit = vehicle_fi_tcl_e8_Vehicle_DistanceUnit::FI_EN_UNKNOWN;
   tU8 u8FuelConsumptionUnit = vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit::FI_EN_UNKNOWN;
   tU8 u8TemperatureUnit = vehicle_fi_tcl_e8_Vehicle_TemperatureUnit::FI_EN_UNKNOWN;

   if ( DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1", "DefaultTemperatureUnit", &u8TemperatureUnit, 1) )
   {
      if ( 0x00 == u8TemperatureUnit )
      {
         u8TemperatureUnit = vehicle_fi_tcl_e8_Vehicle_TemperatureUnit::FI_EN_DEG_C;
      }
      else if ( 0x01 == u8TemperatureUnit )
      {
         u8TemperatureUnit = vehicle_fi_tcl_e8_Vehicle_TemperatureUnit::FI_EN_DEG_F;
      }

      ETG_TRACE_USR1(("vSetDefaultUnitSettings: DefaultTemperatureUnit read %u", ETG_ENUM(VEDA_E8_VEHICLE_TEMPERATUREUNIT, u8TemperatureUnit)));
   }

   if ( DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1", "DefaultDistanceUnits", &u8DistanceUnit, 1) )
   {
      switch ( u8DistanceUnit )
      {
      case KDS_DISTANCEUNIT_KMS: // km
         u8DistanceUnit = vehicle_fi_tcl_e8_Vehicle_DistanceUnit::FI_EN_KM;
         u8FuelConsumptionUnit = vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit::FI_EN_L_PER_100KM;
         break;
      case KDS_DISTANCEUNIT_UK_MILES: // UK miles
         u8DistanceUnit = vehicle_fi_tcl_e8_Vehicle_DistanceUnit::FI_EN_MILES;
         u8FuelConsumptionUnit = vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit::FI_EN_UK_MPG;
         break;
      case KDS_DISTANCEUNIT_US_MILES: // US miles
         u8DistanceUnit = vehicle_fi_tcl_e8_Vehicle_DistanceUnit::FI_EN_MILES;
         u8FuelConsumptionUnit = vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit::FI_EN_US_MPG;
         break;
      case KDS_DISTANCEUNIT_KMS_PER_L: // kms and km/L
         u8DistanceUnit = vehicle_fi_tcl_e8_Vehicle_DistanceUnit::FI_EN_KM;
         u8FuelConsumptionUnit = vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit::FI_EN_KM_PER_L;
         break;
      default:
         break;
      }

      ETG_TRACE_USR1(("vSetDefaultUnitSettings: DefaultDistanceUnits read %u", ETG_ENUM(VEDA_E8_VEHICLE_DISTANCEUNIT, u8DistanceUnit)));
      ETG_TRACE_USR1(("vSetDefaultUnitSettings: u8FuelConsumptionUnit read %u", ETG_ENUM(VEDA_E8_VEHICLE_FUELCONSUMPTIONUNIT, u8FuelConsumptionUnit)));
   }

   // update the clients if the value is changed
   if ( _tDistanceUnit_e8DistanceUnit.enType != u8DistanceUnit )
   {
       vehicle_fi_tcl_e8_Vehicle_DistanceUnit oDistanceUnit;
       oDistanceUnit.enType = static_cast<vehicle_fi_tcl_e8_Vehicle_DistanceUnit::tenType>(u8DistanceUnit);
       sendDistanceUnitStatus(oDistanceUnit);
   }
   else
   {
      ETG_TRACE_USR1(("vSetDefaultUnitSettings: DistanceUnits read already as %u", ETG_ENUM(VEDA_E8_VEHICLE_DISTANCEUNIT, _tDistanceUnit_e8DistanceUnit.enType)));
   }

   // update the clients if the value is changed
   if ( _tFuelConsumptionUnit_e8FuelConsumpUnit.enType != u8FuelConsumptionUnit )
   {
       vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit oFuelConsumptionUnit;
       oFuelConsumptionUnit.enType = static_cast<vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit::tenType>(u8FuelConsumptionUnit);
       _tFuelConsumptionUnit_e8FuelConsumpUnit.enType = static_cast<vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit::tenType>(u8FuelConsumptionUnit);
       sendFuelConsumptionUnitStatus(oFuelConsumptionUnit);
   }
   else
   {
      ETG_TRACE_USR1(("vSetDefaultUnitSettings: FuelConsumptionUnits read already as %u", ETG_ENUM(VEDA_E8_VEHICLE_FUELCONSUMPTIONUNIT, _tFuelConsumptionUnit_e8FuelConsumpUnit.enType)));
   }

   // update the clients if the value is changed
   if ( _tTemperatureUnit_e8TempUnit.enType != u8TemperatureUnit )
   {
       vehicle_fi_tcl_e8_Vehicle_TemperatureUnit oTemperatureUnit;
       oTemperatureUnit.enType = static_cast<vehicle_fi_tcl_e8_Vehicle_TemperatureUnit::tenType>(u8TemperatureUnit);
       _tTemperatureUnit_e8TempUnit.enType = static_cast<vehicle_fi_tcl_e8_Vehicle_TemperatureUnit::tenType>(u8TemperatureUnit);
       sendTemperatureUnitStatus(oTemperatureUnit);
   }
   else
   {
      ETG_TRACE_USR1(("vSetDefaultUnitSettings: TemperatureUnit read already as %u", ETG_ENUM(VEDA_E8_VEHICLE_TEMPERATUREUNIT, _tTemperatureUnit_e8TempUnit.enType)));
   }
   
   dp_tclVehDataDistanceUnit oDistUnit;
   oDistUnit << u8DistanceUnit;
   
   dp_tclVehDataTemperatureUnit oTempUnit;
   oTempUnit << u8TemperatureUnit;
   
   dp_tclVehDataFuelConsumptionUnit oFuelCnsmpUnit;
   oFuelCnsmpUnit << u8FuelConsumptionUnit;
}

tVoid veda_tclServiceVehicle::vReadDefaultUnitSettings()
{
   tU8 u8DistanceUnit = vehicle_fi_tcl_e8_Vehicle_DistanceUnit::FI_EN_UNKNOWN;
   tU8 u8FuelConsumptionUnit = vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit::FI_EN_UNKNOWN;
   tU8 u8TemperatureUnit = vehicle_fi_tcl_e8_Vehicle_TemperatureUnit::FI_EN_UNKNOWN;

   dp_tclVehDataTemperatureUnit oTempUnit;
   if ( DP_U8_ELEM_STATUS_VALID == oTempUnit.u8GetElementStatus() )
   {
      u8TemperatureUnit = oTempUnit.tGetData();
      ETG_TRACE_USR1(("vReadDefaultUnitSettings: DP Temperature Unit read %u", ETG_ENUM(VEDA_E8_VEHICLE_TEMPERATUREUNIT, u8TemperatureUnit)));
   }
   else
   {
      if ( DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1", "DefaultTemperatureUnit", &u8TemperatureUnit, 1) )
      {
         if ( 0x00 == u8TemperatureUnit )
         {
            u8TemperatureUnit = vehicle_fi_tcl_e8_Vehicle_TemperatureUnit::FI_EN_DEG_C;
         }
         else if ( 0x01 == u8TemperatureUnit )
         {
            u8TemperatureUnit = vehicle_fi_tcl_e8_Vehicle_TemperatureUnit::FI_EN_DEG_F;
         }

         ETG_TRACE_USR1(("vReadDefaultUnitSettings: DefaultTemperatureUnit read %u", ETG_ENUM(VEDA_E8_VEHICLE_TEMPERATUREUNIT, u8TemperatureUnit)));
         
         oTempUnit << u8TemperatureUnit;
      }
   }

   dp_tclVehDataDistanceUnit oDistUnit;
   if ( DP_U8_ELEM_STATUS_VALID == oDistUnit.u8GetElementStatus() )
   {
      u8DistanceUnit = oDistUnit.tGetData();
      ETG_TRACE_USR1(("vReadDefaultUnitSettings: DP Distance Unit read %u", ETG_ENUM(VEDA_E8_VEHICLE_DISTANCEUNIT, u8DistanceUnit)));
   }
   else
   {
      if ( DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1", "DefaultDistanceUnits", &u8DistanceUnit, 1) )
      {
         switch ( u8DistanceUnit )
         {
         case KDS_DISTANCEUNIT_KMS: // km
            u8DistanceUnit = vehicle_fi_tcl_e8_Vehicle_DistanceUnit::FI_EN_KM;
            u8FuelConsumptionUnit = vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit::FI_EN_L_PER_100KM;
            break;
         case KDS_DISTANCEUNIT_UK_MILES: // UK miles
            u8DistanceUnit = vehicle_fi_tcl_e8_Vehicle_DistanceUnit::FI_EN_MILES;
            u8FuelConsumptionUnit = vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit::FI_EN_UK_MPG;
            break;
         case KDS_DISTANCEUNIT_US_MILES: // US miles
            u8DistanceUnit = vehicle_fi_tcl_e8_Vehicle_DistanceUnit::FI_EN_MILES;
            u8FuelConsumptionUnit = vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit::FI_EN_US_MPG;
            break;
         case KDS_DISTANCEUNIT_KMS_PER_L: // kms and km/L
        	u8DistanceUnit = vehicle_fi_tcl_e8_Vehicle_DistanceUnit::FI_EN_KM;
            u8FuelConsumptionUnit = vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit::FI_EN_KM_PER_L;
            break;
         default:
            break;
         }
         ETG_TRACE_USR1(("vReadDefaultUnitSettings: DefaultDistanceUnits read %u", ETG_ENUM(VEDA_E8_VEHICLE_DISTANCEUNIT, u8DistanceUnit)));
         ETG_TRACE_USR1(("vReadDefaultUnitSettings: u8FuelConsumptionUnit read %u", ETG_ENUM(VEDA_E8_VEHICLE_FUELCONSUMPTIONUNIT, u8FuelConsumptionUnit)));
         
         oDistUnit << u8DistanceUnit;
      }
   }

   dp_tclVehDataFuelConsumptionUnit oFuelCnsmpUnit;
   if ( DP_U8_ELEM_STATUS_VALID == oFuelCnsmpUnit.u8GetElementStatus() )
   {
      u8FuelConsumptionUnit = oFuelCnsmpUnit.tGetData();
      ETG_TRACE_USR1(("vReadDefaultUnitSettings: Dp Fuel Consumption Unit read %u", ETG_ENUM(VEDA_E8_VEHICLE_FUELCONSUMPTIONUNIT, u8FuelConsumptionUnit)));
   }
   else
   {
      oFuelCnsmpUnit << u8FuelConsumptionUnit;
   }

   // update the clients if the value is changed
   if ( _tDistanceUnit_e8DistanceUnit.enType != u8DistanceUnit )
   {
      vehicle_fi_tcl_e8_Vehicle_DistanceUnit oDistanceUnit;
      oDistanceUnit.enType = static_cast<vehicle_fi_tcl_e8_Vehicle_DistanceUnit::tenType>(u8DistanceUnit);
      sendDistanceUnitStatus(oDistanceUnit);
      
      _tSpeedLimit_DisplayUnit.enType = static_cast<vehicle_fi_tcl_e8_Vehicle_DistanceUnit::tenType>(u8DistanceUnit);
   }

   // update the clients if the value is changed
   if ( _tFuelConsumptionUnit_e8FuelConsumpUnit.enType != u8FuelConsumptionUnit )
   {
      vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit oFuelConsumptionUnit;
      oFuelConsumptionUnit.enType = static_cast<vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit::tenType>(u8FuelConsumptionUnit);
      sendFuelConsumptionUnitStatus(oFuelConsumptionUnit);
   }

   // update the clients if the value is changed
   if ( _tTemperatureUnit_e8TempUnit.enType != u8TemperatureUnit )
   {
      vehicle_fi_tcl_e8_Vehicle_TemperatureUnit oTemperatureUnit;
      oTemperatureUnit.enType = static_cast<vehicle_fi_tcl_e8_Vehicle_TemperatureUnit::tenType>(u8TemperatureUnit);
      sendTemperatureUnitStatus(oTemperatureUnit);
   }
}

tU8 veda_tclServiceVehicle::_u8ReadKDSDefaultLanguage(tVoid) const
{
   tU8 u8Language = vehicle_fi_tcl_e8_Language_Code::FI_EN_UNKNOWN;

   // Read KDS default Language data if cold start
   if ( DP_S32_NO_ERR != DP_s32GetConfigItem("SystemConfiguration1", "DefaultLanguage", &u8Language, 1) )
   {
      // If KDS read for Default language fails,
      // Set the language as the Default language known from the static data
      u8Language = vehicle_fi_tcl_e8_Language_Code::FI_EN_ENGLISH_US;
      ETG_TRACE_USR1(("vGetKDSDefaultLanguage(): KDS Default Language Read Error hardcoding it to %u", ETG_ENUM(VEDA_E8_LANGUAGE_CODE, u8Language)));
   }
   else
   {
      ETG_TRACE_USR1(("vGetKDSDefaultLanguage(): Using KDS Default Language %u.", ETG_ENUM(VEDA_E8_LANGUAGE_CODE, u8Language)));
   }

   return u8Language;
}

tVoid veda_tclServiceVehicle::_vInitializeLangSourceTableList(tVoid)
{
   for ( tU8 i = vehicle_fi_tcl_e8_Language_SourceId::FI_EN_HMI; i <= vehicle_fi_tcl_e8_Language_SourceId::FI_EN_SYSTEM; i++ )
   {
      vehicle_fi_tcl_Language_SourceTable otempSrcTable;

      otempSrcTable.enLangSrcId.enType = static_cast<vehicle_fi_tcl_e8_Language_SourceId::tenType>(i);
      otempSrcTable.enLanguage.enType = vehicle_fi_tcl_e8_Language_Code::FI_EN_UNKNOWN;
      otempSrcTable.bHasChanged = TRUE;

      _tLanguage_LangTable.push_back(otempSrcTable);
   }
}

tVoid veda_tclServiceVehicle::_vReadLastModeLanguageSettings()
{
   // Read Language Sync Source data from Vehicle data DP
   dp_tclVehDataProfileLanguageSyncSource oLanguageSyncSource;
   if ( DP_U8_ELEM_STATUS_VALID == oLanguageSyncSource.u8GetElementStatus() )
   {
      // DP data Valid load into member variable
      _tLanguageSyncSource_Language.enType = static_cast<vehicle_fi_tcl_e8_Language_SourceId::tenType>(oLanguageSyncSource.tGetData());
      ETG_TRACE_USR1(("_vReadLastModeLanguageSettings(): LanguageSyncSource DP Read Success, SyncSource = %d", \
         ETG_ENUM(VEDA_E8_LANGUAGE_SOURCEID, _tLanguageSyncSource_Language.enType)));
   }

   for ( tU8 i = vehicle_fi_tcl_e8_Language_SourceId::FI_EN_HMI; i <= vehicle_fi_tcl_e8_Language_SourceId::FI_EN_SYSTEM; i++ )
   {
      _tLanguage_LangTable[i].enLanguage.enType = static_cast<vehicle_fi_tcl_e8_Language_Code::tenType>(_u8GetDPLangForSource(i));
   }
}

tU8 veda_tclServiceVehicle::_u8GetDPLangForSource(const tU8 u8Source) const
{
   tU8 u8Lang = static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_UNKNOWN);

   switch(u8Source)
   {
   case vehicle_fi_tcl_e8_Language_SourceId::FI_EN_HMI:
      {
    	  dp_tclVehDataHMILanguage oHMILang;
         if (DP_U8_ELEM_STATUS_VALID == oHMILang.u8GetElementStatus())
         {
            oHMILang >> u8Lang;
         }
      }
      break;
   case vehicle_fi_tcl_e8_Language_SourceId::FI_EN_METER:
      {
         dp_tclVehDataMeterLanguage oMeterLang;
         if (DP_U8_ELEM_STATUS_VALID == oMeterLang.u8GetElementStatus())
         {
            oMeterLang >> u8Lang;
         }
      }
      break;
   case vehicle_fi_tcl_e8_Language_SourceId::FI_EN_SDS:
      {
         dp_tclVehDataSDSLanguage oSDSLang;
         if (DP_U8_ELEM_STATUS_VALID == oSDSLang.u8GetElementStatus())
         {
            oSDSLang >> u8Lang;
         }
      }
      break;
   case vehicle_fi_tcl_e8_Language_SourceId::FI_EN_SYSTEM:
      {
         dp_tclVehDataProfileLanguage oVehLang;
         if (DP_U8_ELEM_STATUS_VALID == oVehLang.u8GetElementStatus())
         {
            oVehLang >> u8Lang;
         }

         // System language cannot not be any of the below
         if ( ( u8Lang == static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_UNKNOWN) ) ||
            ( u8Lang == static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_UNUSED) ) ||
            ( u8Lang == static_cast<tU8>(vehicle_fi_tcl_e8_Language_Code::FI_EN_UNSUPPORTED) ) )
         {
            // if the language is not supported than fall back to the default KDS Language
            u8Lang = _u8ReadKDSDefaultLanguage();
         }
      }
      break;
   default:
      break;
   }

   ETG_TRACE_USR1(("_u8GetDPLangForSource() entered for Source %u Lang %u", \
      ETG_ENUM(VEDA_E8_LANGUAGE_SOURCEID, u8Source), ETG_ENUM(VEDA_E8_LANGUAGE_CODE, u8Lang)));

   return u8Lang;
}

tVoid veda_tclServiceVehicle::vUpdateCANSpeedLimit1(const tU8 u8SpeedLimit1)
{
   if ( u8SpeedLimit1 != _tSpeedLimit_SpeedLimit1 )
   {
      _tSpeedLimit_SpeedLimit1 = u8SpeedLimit1;
      sendSpeedLimitStatus(_tSpeedLimit_SpeedLimit1, _tSpeedLimit_SpeedLimit2, _tSpeedLimit_Display, _tDistanceUnit_e8DistanceUnit, _tSpeedLimit_OverSpeed, _tSpeedLimit_FreeSpeed);
   }
}

tVoid veda_tclServiceVehicle::vUpdateCANSpeedLimit2(const tU8 u8SpeedLimit2)
{
   if ( u8SpeedLimit2 != _tSpeedLimit_SpeedLimit2 )
   {
      _tSpeedLimit_SpeedLimit2 = u8SpeedLimit2;
      sendSpeedLimitStatus(_tSpeedLimit_SpeedLimit1, _tSpeedLimit_SpeedLimit2, _tSpeedLimit_Display, _tDistanceUnit_e8DistanceUnit, _tSpeedLimit_OverSpeed, _tSpeedLimit_FreeSpeed);
   }
}

tVoid veda_tclServiceVehicle::vUpdateCANSpeedLimitDisplay(const tU8 u8SpeedLimitDisplay)
{
   if ( u8SpeedLimitDisplay != _tSpeedLimit_Display )
   {
      _tSpeedLimit_Display = u8SpeedLimitDisplay;
      sendSpeedLimitStatus(_tSpeedLimit_SpeedLimit1, _tSpeedLimit_SpeedLimit2, _tSpeedLimit_Display, _tDistanceUnit_e8DistanceUnit, _tSpeedLimit_OverSpeed, _tSpeedLimit_FreeSpeed);
   }
}

tVoid veda_tclServiceVehicle::vUpdateSpeedLimitDisplayUnit(const tU8 u8SpeedLimitDisplayUnit)
{
    if ( m_bISAConfigured )
    {
       _tSpeedLimit_DisplayUnit = _tDistanceUnit_e8DistanceUnit;
    }
    else if ( m_bTrafficSignConfigured )
    {
       _tSpeedLimit_DisplayUnit.enType = static_cast<vehicle_fi_tcl_e8_Vehicle_DistanceUnit::tenType>(u8SpeedLimitDisplayUnit);
    }
    else
    {
       _tSpeedLimit_DisplayUnit = _tDistanceUnit_e8DistanceUnit;
    }

    sendSpeedLimitStatus(_tSpeedLimit_SpeedLimit1, _tSpeedLimit_SpeedLimit2, _tSpeedLimit_Display, _tSpeedLimit_DisplayUnit, _tSpeedLimit_OverSpeed, _tSpeedLimit_FreeSpeed);
}

tVoid veda_tclServiceVehicle::vUpdateOverSpeedDisplay(tBool bOverSpeed)
{
    if ( m_bISAConfigured )
    {
        bOverSpeed = FALSE;
    }

    if ( _tSpeedLimit_OverSpeed != bOverSpeed )
    {
       _tSpeedLimit_OverSpeed = bOverSpeed;
       sendSpeedLimitStatus(_tSpeedLimit_SpeedLimit1, _tSpeedLimit_SpeedLimit2, _tSpeedLimit_Display, _tSpeedLimit_DisplayUnit, _tSpeedLimit_OverSpeed, _tSpeedLimit_FreeSpeed);
    }
}

tVoid veda_tclServiceVehicle::vUpdateFreeSpeedDisplay(tBool bFreeSpeed)
{
    if ( m_bISAConfigured )
    {
        bFreeSpeed = FALSE;
    }

    if ( _tSpeedLimit_FreeSpeed != bFreeSpeed )
    {
        _tSpeedLimit_FreeSpeed = bFreeSpeed;
       sendSpeedLimitStatus(_tSpeedLimit_SpeedLimit1, _tSpeedLimit_SpeedLimit2, _tSpeedLimit_Display, _tSpeedLimit_DisplayUnit, _tSpeedLimit_OverSpeed, _tSpeedLimit_FreeSpeed);
    }
}

tVoid veda_tclServiceVehicle::vCANUpdateDistanceTotal(tU32 u32DistanceTotal, tU32 u32LastValidDistanceTotal, tBool bStatus)
{
   if (  ( _tDistanceTotalizer_DisTotal != u32DistanceTotal ) 
      || ( _tDistanceTotalizer_DisTotalStatus != bStatus ) 
      || ( _tDistanceTotalizer_lastValidDisTotal != u32LastValidDistanceTotal) )
   {
      _tDistanceTotalizer_DisTotal = u32DistanceTotal;
      _tDistanceTotalizer_DisTotalStatus = bStatus;
      _tDistanceTotalizer_lastValidDisTotal = u32LastValidDistanceTotal;

      sendDistanceTotalizerStatus(_tDistanceTotalizer_DisTotal, _tDistanceTotalizer_lastValidDisTotal, _tDistanceTotalizer_Unit, _tDistanceTotalizer_DisTotalStatus);
   }
}

tVoid veda_tclServiceVehicle::vCANUpdateDistanceTotalUnit(tU8 u8DistanceTotalUnit, tBool bStatus)
{
   if ( ( _tDistanceTotalizer_Unit != u8DistanceTotalUnit ) ||
      ( _tDistanceTotalizer_DisTotalStatus != bStatus ) )
   {
      _tDistanceTotalizer_Unit = u8DistanceTotalUnit;
      _tDistanceTotalizer_DisTotalStatus = bStatus;

      sendDistanceTotalizerStatus(_tDistanceTotalizer_DisTotal, _tDistanceTotalizer_lastValidDisTotal, _tDistanceTotalizer_Unit, _tDistanceTotalizer_DisTotalStatus);
   }
}

// veda_tclServiceVehicleveda_ServiceVehicle: user specific code end

//EOF
