/*****************************************************************************
* Template:     csmAdaptor.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               DO NOT CHANGE --> 
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#define MIDW_COMMON_S_IMPORT_INTERFACE_CSM
#define CSM_C_PROJECT_USERSPACE_SMART_HU
#include "midw_common_if.h"
// veda_tclClientVcanCanAdaptor::Include: user specific code start
#include "veda_config.h"
// veda_tclClientVcanCanAdaptor::Include: user specific code end

//include base class
#include "veda_AppMain.h"

#include "veda_ClientVcanSmartCanAdaptor.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VEHICLEDATA_CLIENT_VCAN
#include "trcGenProj/Header/veda_ClientVcanSmartCanAdaptor.cpp.trc.h"
#endif



veda_tclClientVcanCanAdaptor* veda_tclClientVcanCanAdaptor::_pMyStaticRef = 0;

/* ---------------- */
/* public functions */
/* ---------------- */

veda_tclClientVcanCanAdaptor::veda_tclClientVcanCanAdaptor(veda_tclAppMain* poMainAppl):
I_veda_tclClientVcanCanAdaptor(poMainAppl)
{
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::veda_tclClientVcanCanAdaptor() entered."));

    _pMyStaticRef = this;
    _pCallbackIf = NULL;
    _poMyCSMInterface = NULL;

    // veda_tclClientVcanCanAdaptor::veda_tclClientVcanCanAdaptor: user specific code start
    // veda_tclClientVcanCanAdaptor::veda_tclClientVcanCanAdaptor: user specific code end

    return;
}

veda_tclClientVcanCanAdaptor::~veda_tclClientVcanCanAdaptor()
{
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::~veda_tclClientVcanCanAdaptor() entered."));
    
    _pCallbackIf = OSAL_NULL;
    
    if (OSAL_NULL != _poMyCSMInterface) {
        OSAL_DELETE _poMyCSMInterface;
    }
    _poMyCSMInterface = OSAL_NULL;
}

tVoid veda_tclClientVcanCanAdaptor::vHandleMessage(veda_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(veda_tclBaseIf::ECmdTypes, pMsg->eCmd), pMsg->u.u32Data));
   if (pMsg->eCmd == veda_tclBaseIf::eCmdCsmSignalReceived) {
       vSignalIndSync(pMsg->u.u32Data);
   }

   // veda_tclClientVcanCanAdaptor::vHandleMessage: user specific code start
   switch(pMsg->eCmd)
   {
   case eCmdCsmBusIndReceived:
      if (_pCallbackIf)
         _pCallbackIf->vHandleCsmFaultIndication(pMsg->u.au8Data[0], pMsg->u.au8Data[1], pMsg->u.au8Data[2]);
      break;

   case eDefaultSetting:
      if (pMsg->u.u8Data == 0x02) // if coding changed
         _vSendKDSCodingChangedInfoToCSM();
      break;

   default:
      break;
   }
   // veda_tclClientVcanCanAdaptor::vHandleMessage: user specific code end
}

tVoid veda_tclClientVcanCanAdaptor::vHandleTraceMessage(const tUChar* puchData)
{
   VEDA_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // veda_tclClientVcanCanAdaptor::vHandleTraceMessage: user specific code start
   // veda_tclClientVcanCanAdaptor::vHandleTraceMessage: user specific code end
}

tVoid veda_tclClientVcanCanAdaptor::vGetReferences() {
   // veda_tclClientVcanCanAdaptor::vGetReferences: user specific code start
   _poMyCSMInterface = new CSMInterface();
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
   // veda_tclClientVcanCanAdaptor::vGetReferences: user specific code end
}


tVoid veda_tclClientVcanCanAdaptor::vTraceInfo()
{
   ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vTraceInfo() entered."));
   // veda_tclClientVcanCanAdaptor::vTraceInfo: user specific code start
   // veda_tclClientVcanCanAdaptor::vTraceInfo: user specific code end

}


tVoid veda_tclClientVcanCanAdaptor::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vStartCommunication() entered."));

   // veda_tclClientVcanCanAdaptor::vStartCommunication: user specific code start
   // veda_tclClientVcanCanAdaptor::vStartCommunication: user specific code end
}


tVoid veda_tclClientVcanCanAdaptor::vConnect()
{

   tU32 u32CsmHandle;
   ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vConnect() entered."));

   // veda_tclClientVcanCanAdaptor::vConnect: user specific code start
   VEDA_NULL_POINTER_CHECK(_pCallbackIf);
   _pCallbackIf->vHandleKDSConfigRead();
   // veda_tclClientVcanCanAdaptor::vConnect: user specific code end

   _poMyCSMInterface = new CSMInterface();
   VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);

   ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vConnect(): Install Callback now."));

   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle,CSM_C_SIG_RX_VehicleSpeed_MM_GW_PositionInfo, NULL) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_SIG_RX_VehicleSpeed_CruiseControl'."));
   }
   vReadVehicleSpeed();
  if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_SoundCommand_GW_MMI_Info1, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_SoundCommand_GW_MMI_Info1'."));
   }
   vReadMuteDevStatus();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_RearGearEngaged_MM_GW_PositionInfo, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to 'CSM_C_SIG_RX_RearGearEngaged_MM_GW_PositionInfo'."));
   }
   vReadRearGearEngaged();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle,  CSM_C_SIG_RX_VehicleID_MM_GW_RadioInfo , vSignalIndCallback) < CSM_C_NO_ERROR)
   {
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_VehicleID_MM_GW_RadioInfo'."));
   }
   vReadVINValue();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_GearLeverPosition_MM_GW_Chassis_Data3 , vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_GearLeverPosition_MM_GW_Chassis_Data3 '."));
   }
   vReadParkingBreakSwitchValue();
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_PrivacyResetReq_MFD_PrivacyReset , vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_PrivacyResetReq_MFD_PrivacyReset '."));
   }
   vReadPrivacyResetReqValue();
}

tVoid veda_tclClientVcanCanAdaptor::vSignalIndCallback(tVoid* pHandle, tU32 u32SignalId, tU32 u32SignalStatus)
{
    // lint
    (tVoid)pHandle;
    (tVoid)u32SignalStatus;

     veda_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));

     oMsg.eCmd = veda_tclBaseIf::eCmdCsmSignalReceived;
     OSAL_szStringNCopy(oMsg.strClassName, "veda_tclClientVcanCanAdaptor", strlen("veda_tclClientVcanCanAdaptor "));
     oMsg.u.u32Data = u32SignalId;

     _pMyStaticRef->_cpoMain->theServer()->vPostInternalMessage(&oMsg);

}

tVoid veda_tclClientVcanCanAdaptor::vSignalIndSync(tU32 u32SignalId)
{
    /* Check which signal is changed ! */
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vSignalInd(): Signal Indication received: ID 0x%08x", u32SignalId));

    switch(u32SignalId)
    {
	case CSM_C_SIG_RX_VehicleSpeed_MM_GW_PositionInfo:
        vReadVehicleSpeed();
        break;
	case CSM_C_SIG_RX_SoundCommand_GW_MMI_Info1:
        vReadMuteDevStatus();
        break;
	case CSM_C_SIG_RX_RearGearEngaged_MM_GW_PositionInfo :
        vReadRearGearEngaged();
        break;
	case CSM_C_SIG_RX_VehicleID_MM_GW_RadioInfo:
		vReadVINValue();
		break;
	case CSM_C_SIG_RX_GearLeverPosition_MM_GW_Chassis_Data3 :
        vReadParkingBreakSwitchValue();
        break;
	case CSM_C_SIG_RX_PrivacyResetReq_MFD_PrivacyReset:
		vReadPrivacyResetReqValue();
		
    default:
        break;
    }
}

/* ------------------------------------------------------------------------- */
tVoid veda_tclClientVcanCanAdaptor::vSendCsmBroadcastSignal(tU8* pabData, tU8 u8Len, tU32 u32CsmSignal, tU8 u8TxType)
/*!
* \fn
*  \brief
*  
*  \param
*
*  \return
*
*  \note
*  \bug
*    no bugs known
*  \todo
*    nothing left
*  \version
*    1.0   - Initial
******
*/
{

    tU32 u32CsmHandle;
    tS32 s32Ret;

    // veda_tclClientVcanCanAdaptor_vSendCsmBroadcastSignal: user specific code start
    // veda_tclClientVcanCanAdaptor_vSendCsmBroadcastSignal: user specific code end

    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);

    s32Ret = _poMyCSMInterface->CSM_lSignalWrite((tVoid *)&u32CsmHandle,u32CsmSignal,
        pabData,
        u8Len,
        u8TxType);

    if(CSM_C_NO_ERROR > s32Ret) {
        ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vSendCsmBroadcastSignal(): !!!!!! Error detected !!!!!!"));
    }

    return;

}

tVoid veda_tclClientVcanCanAdaptor::vReadSpeed_Limit_Display_Request()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSpeed_Limit_Display_Request(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    /* if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_Speed_Limit_Display_Request,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }
 */
    if(_tSpeed_Limit_Display_Request.u32Status != u32StatusRead) {
        _tSpeed_Limit_Display_Request.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	//CID: 172321
	/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tSpeed_Limit_Display_Request.Speed_Limit_Display_Request, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tSpeed_Limit_Display_Request.Speed_Limit_Display_Request, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSpeed_Limit_Display_Request(): Called!"));
        _pCallbackIf->onSpeed_Limit_Display_RequestStatus(_tSpeed_Limit_Display_Request);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadNavi_display_speed_limit_1()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadNavi_display_speed_limit_1(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

 /*    if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_Navi_display_speed_limit_1,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tNavi_display_speed_limit_1.u32Status != u32StatusRead) {
        _tNavi_display_speed_limit_1.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	//CID: 172306
	/*

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tNavi_display_speed_limit_1.Navi_display_speed_limit_1, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tNavi_display_speed_limit_1.Navi_display_speed_limit_1, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
	*/

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadNavi_display_speed_limit_1(): Called!"));
        _pCallbackIf->onNavi_display_speed_limit_1Status(_tNavi_display_speed_limit_1);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadNavi_display_speed_limit_2()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadNavi_display_speed_limit_2(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

  /*   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_Navi_display_speed_limit_2,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tNavi_display_speed_limit_2.u32Status != u32StatusRead) {
        _tNavi_display_speed_limit_2.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
//CID: 172291

/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tNavi_display_speed_limit_2.Navi_display_speed_limit_2, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tNavi_display_speed_limit_2.Navi_display_speed_limit_2, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
	
*/

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadNavi_display_speed_limit_2(): Called!"));
        _pCallbackIf->onNavi_display_speed_limit_2Status(_tNavi_display_speed_limit_2);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadIgnitionSupplyConfirmation()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadIgnitionSupplyConfirmation(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;
//PIYUSH
   /* if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_IgnSw_Stat_SCA_SCA_C2,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tIgnitionSupplyConfirmation.u32Status != u32StatusRead) {
        _tIgnitionSupplyConfirmation.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

  //CID: 172280
/*
  if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tIgnitionSupplyConfirmation.IgnitionSupplyConfirmation, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tIgnitionSupplyConfirmation.IgnitionSupplyConfirmation, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadIgnitionSupplyConfirmation(): Called!"));
        _pCallbackIf->onIgnitionSupplyConfirmationStatus(_tIgnitionSupplyConfirmation);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadVehicleSpeed()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadVehicleSpeed(): Called!"));
    tU8  au8Data_ReadBuffer[2];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_VehicleSpeed_MM_GW_PositionInfo, &au8Data_ReadBuffer[0],2,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }
 
    if(_tVehicleSpeed.u32Status != u32StatusRead) {
        _tVehicleSpeed.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tVehicleSpeed.VehicleSpeed[0], &au8Data_ReadBuffer[0], 2) != 0) {
            memcpy(&_tVehicleSpeed.VehicleSpeed[0], &au8Data_ReadBuffer[0], 2);
            bChanged = TRUE;
        }
    }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadVehicleSpeed(): Called!"));
        _pCallbackIf->onVehicleSpeedStatus(_tVehicleSpeed);
    }
}
//MuteDev
tVoid veda_tclClientVcanCanAdaptor::vReadMuteDevStatus()
{
	VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadMuteDevStatus(): Called!"));
    tU8  au8Data_ReadBuffer;
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

   tBool bChanged = FALSE;
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_SoundCommand_GW_MMI_Info1, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadMuteDevStatus,CSM_C_SIGNAL_DATA_INVALID "));
    }
	ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadMuteDevStatus: called %d",au8Data_ReadBuffer ));
	
	if(_tMuteDevStatus.u32Status != u32StatusRead) {
        _tMuteDevStatus.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tMuteDevStatus.MuteDevStatus, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tMuteDevStatus.MuteDevStatus, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadMuteDevStatus(): Called!"));
        _pCallbackIf-> onVehicleMuteDevStatus(_tMuteDevStatus);
    }
}
//Rear Gear
tVoid veda_tclClientVcanCanAdaptor::vReadRearGearEngaged()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadRearGearEngaged(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_RearGearEngaged_MM_GW_PositionInfo ,
        &au8Data_ReadBuffer[0],1,&u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

    if(_tRearGearEngaged.u32Status != u32StatusRead) {
        _tRearGearEngaged.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tRearGearEngaged.RearGearEngaged, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tRearGearEngaged.RearGearEngaged, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadRearGearEngaged(): Called!"));
        _pCallbackIf->onRearGearEngagedStatus(_tRearGearEngaged);
    }
}
//TCOVehiclespeed
/*tVoid veda_tclClientVcanCanAdaptor::vReadTCOVehicleSpeed()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadTCOVehicleSpeed(): Called!"));
    tU8  au8Data_ReadBuffer[2];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_TCOVehSpeed_TCO1, &au8Data_ReadBuffer[0],2,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }
 
    if(_tTCOVehicleSpeed.u32Status != u32StatusRead) {
        _tTCOVehicleSpeed.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tTCOVehicleSpeed.TCOVehicleSpeed[0], &au8Data_ReadBuffer[0], 2) != 0) {
            memcpy(&_tTCOVehicleSpeed.TCOVehicleSpeed[0], &au8Data_ReadBuffer[0], 2);
            bChanged = TRUE;
        }
    }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadTCOVehicleSpeed(): Called!"));
        _pCallbackIf->onTCOVehicleSpeedStatus(_tTCOVehicleSpeed);
    }
}*/
//piyush-->PartialMute
tVoid veda_tclClientVcanCanAdaptor::vReadPartialMuteValue()
{
	VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadPartialMuteValue(): Called!"));
    tU8  au8Data_ReadBuffer[2];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;
	/*if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_SystemMute_SystemEnvironment, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }*/
	if(_tPartialMuteValue.u32Status != u32StatusRead) {
        _tPartialMuteValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	//CID:465576
	/*
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tPartialMuteValue.PartialMuteValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tPartialMuteValue.PartialMuteValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }
	*/

    if ((bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadPartialMuteValue(): Called!"));
        _pCallbackIf-> onVehiclePartialMuteStatus(_tPartialMuteValue);
    }
}
//VIN
tVoid veda_tclClientVcanCanAdaptor::vReadVINValue()
{
	VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadVINValue(): Called!"));
    tU32  au32Data_ReadBuffer;
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

   tBool bChanged = FALSE;
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_VehicleID_MM_GW_RadioInfo, &au32Data_ReadBuffer,4,&u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadVINValue(),CSM_C_SIGNAL_DATA_INVALID "));
    }
	ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadVINValue(): called %d",au32Data_ReadBuffer ));
	
	if(_tVINValue.u32Status != u32StatusRead) {
        _tVINValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tVINValue.VINValue, &au32Data_ReadBuffer, 4) != 0) {
            memcpy(&_tVINValue.VINValue, &au32Data_ReadBuffer, 4);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadVINValue(): Called!"));
        _pCallbackIf-> onVehicleVINStatus(_tVINValue);
    }
}
//ParkingBreakSwitch
tVoid veda_tclClientVcanCanAdaptor::vReadParkingBreakSwitchValue()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadParkingBreakSwitchValue(): Called!"));
    tU8  au8Data_ReadBuffer;
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
	

    tBool bChanged = FALSE;

   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_GearLeverPosition_MM_GW_Chassis_Data3, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }
 
    if(_tParkingBreakSwitchValue.u32Status != u32StatusRead) {
        _tParkingBreakSwitchValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tParkingBreakSwitchValue.ParkingBreakSwitchValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tParkingBreakSwitchValue.ParkingBreakSwitchValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadParkingBreakSwitchValue(): Called!"));
        _pCallbackIf->onVehicleParkingBreakSwitchStatus(_tParkingBreakSwitchValue);
    }
}
//PrivacyResetReq
tVoid veda_tclClientVcanCanAdaptor::vReadPrivacyResetReqValue()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadPrivacyResetReqValue(): Called!"));
    tU8  au8Data_ReadBuffer;
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
	

    tBool bChanged = FALSE;

   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_PrivacyResetReq_MFD_PrivacyReset, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }
 
    if(_tPrivacyResetReqValue.u32Status != u32StatusRead) {
        _tPrivacyResetReqValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tPrivacyResetReqValue.PrivacyResetReqValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tPrivacyResetReqValue.PrivacyResetReqValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadPrivacyResetReqValue(): Called!"));
        _pCallbackIf->onVehiclePrivacyResetReqStatus(_tPrivacyResetReqValue);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadHandBrakeSwitch()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadHandBrakeSwitch(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

/*     if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_HandBrakeSwitch,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tHandBrakeSwitch.u32Status != u32StatusRead) {
        _tHandBrakeSwitch.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	//CID: 172317
/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tHandBrakeSwitch.HandBrakeSwitch, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tHandBrakeSwitch.HandBrakeSwitch, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadHandBrakeSwitch(): Called!"));
        _pCallbackIf->onHandBrakeSwitchStatus(_tHandBrakeSwitch);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadDistanceTotalizer()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadDistanceTotalizer(): Called!"));
    tU8  au8Data_ReadBuffer[4];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

   /*  if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_DistanceTotalizer,
        &au8Data_ReadBuffer[0],
        4,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tDistanceTotalizer.u32Status != u32StatusRead) {
        _tDistanceTotalizer.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
		//CID: 172322
	/*

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tDistanceTotalizer.DistanceTotalizer[0], &au8Data_ReadBuffer[0], 4) != 0) {
            memcpy(&_tDistanceTotalizer.DistanceTotalizer[0], &au8Data_ReadBuffer[0], 4);
            bChanged = TRUE;
        }
    }
	*/

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadDistanceTotalizer(): Called!"));
        _pCallbackIf->onDistanceTotalizerStatus(_tDistanceTotalizer);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadDistanceUnit()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadDistanceUnit(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

  /*   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_DistanceUnit,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tDistanceUnit.u32Status != u32StatusRead) {
        _tDistanceUnit.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	//CID:172297
/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tDistanceUnit.DistanceUnit, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tDistanceUnit.DistanceUnit, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadDistanceUnit(): Called!"));
        _pCallbackIf->onDistanceUnitStatus(_tDistanceUnit);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadAverage_Fuel_Economy()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadAverage_Fuel_Economy(): Called!"));
    tU8  au8Data_ReadBuffer[2];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

  /*   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_Average_Fuel_Economy,
        &au8Data_ReadBuffer[0],
        2,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tAverage_Fuel_Economy.u32Status != u32StatusRead) {
        _tAverage_Fuel_Economy.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	//CID: 172308
	/*

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tAverage_Fuel_Economy.Average_Fuel_Economy[0], &au8Data_ReadBuffer[0], 2) != 0) {
            memcpy(&_tAverage_Fuel_Economy.Average_Fuel_Economy[0], &au8Data_ReadBuffer[0], 2);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadAverage_Fuel_Economy(): Called!"));
        _pCallbackIf->onAverage_Fuel_EconomyStatus(_tAverage_Fuel_Economy);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadDiagMuxOn()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadDiagMuxOn(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

  /*   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_DiagMuxOn,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tDiagMuxOn.u32Status != u32StatusRead) {
        _tDiagMuxOn.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
//CID: 172296
/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tDiagMuxOn.DiagMuxOn, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tDiagMuxOn.DiagMuxOn, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadDiagMuxOn(): Called!"));
        _pCallbackIf->onDiagMuxOnStatus(_tDiagMuxOn);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadDiagMuxOn_84()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadDiagMuxOn_84(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

 /*    if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_DiagMuxOn_84,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tDiagMuxOn_84.u32Status != u32StatusRead) {
        _tDiagMuxOn_84.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	//CID: 172315
/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tDiagMuxOn_84.DiagMuxOn_84, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tDiagMuxOn_84.DiagMuxOn_84, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadDiagMuxOn_84(): Called!"));
        _pCallbackIf->onDiagMuxOn_84Status(_tDiagMuxOn_84);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadGADE()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadGADE(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

   /* if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_GADE,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }*/

    if(_tGADE.u32Status != u32StatusRead) {
        _tGADE.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172709
	/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tGADE.GADE, &au8Data_ReadBuffer[0], 1) != 0)
			{
			
		   memcpy(&_tGADE.GADE, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
	*/

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadGADE(): Called!"));
        _pCallbackIf->onGADEStatus(_tGADE);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadOSPOverSpeedDisplayRequest()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadOSPOverSpeedDisplayRequest(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

   /* if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_OSPOverSpeedDisplayRequest,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }*/

    if(_tOSPOverSpeedDisplayRequest.u32Status != u32StatusRead) {
        _tOSPOverSpeedDisplayRequest.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
//CID:172319
/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tOSPOverSpeedDisplayRequest.OSPOverSpeedDisplayRequest, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tOSPOverSpeedDisplayRequest.OSPOverSpeedDisplayRequest, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
	*/

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadOSPOverSpeedDisplayRequest(): Called!"));
        _pCallbackIf->onOSPOverSpeedDisplayRequestStatus(_tOSPOverSpeedDisplayRequest);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadOSPSpeedUnit()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadOSPSpeedUnit(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

  /*   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_OSPSpeedUnit,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tOSPSpeedUnit.u32Status != u32StatusRead) {
        _tOSPSpeedUnit.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	
	
	//CID: 172292
	/*

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tOSPSpeedUnit.OSPSpeedUnit, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tOSPSpeedUnit.OSPSpeedUnit, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadOSPSpeedUnit(): Called!"));
        _pCallbackIf->onOSPSpeedUnitStatus(_tOSPSpeedUnit);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadTSR_OSP_ActivationStatus()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadTSR_OSP_ActivationStatus(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

 /*    if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_TSR_OSP_ActivationStatus,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tTSR_OSP_ActivationStatus.u32Status != u32StatusRead) {
        _tTSR_OSP_ActivationStatus.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
//CID: 172294	
	/*

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tTSR_OSP_ActivationStatus.TSR_OSP_ActivationStatus, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tTSR_OSP_ActivationStatus.TSR_OSP_ActivationStatus, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
	
	*/

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadTSR_OSP_ActivationStatus(): Called!"));
        _pCallbackIf->onTSR_OSP_ActivationStatusStatus(_tTSR_OSP_ActivationStatus);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadMeterLanguageKnowledge()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadMeterLanguageKnowledge(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

 /*    if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_MeterLanguageKnowledge,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tMeterLanguageKnowledge.u32Status != u32StatusRead) {
        _tMeterLanguageKnowledge.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	
	//CID: 172325
	/*

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tMeterLanguageKnowledge.MeterLanguageKnowledge, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tMeterLanguageKnowledge.MeterLanguageKnowledge, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
	*/

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadMeterLanguageKnowledge(): Called!"));
        _pCallbackIf->onMeterLanguageKnowledgeStatus(_tMeterLanguageKnowledge);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadMeterLanguageStatus()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadMeterLanguageStatus(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

 /*    if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_MeterLanguageStatus,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tMeterLanguageStatus.u32Status != u32StatusRead) {
        _tMeterLanguageStatus.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	
//CID: 172293	
/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tMeterLanguageStatus.MeterLanguageStatus, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tMeterLanguageStatus.MeterLanguageStatus, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadMeterLanguageStatus(): Called!"));
        _pCallbackIf->onMeterLanguageStatusStatus(_tMeterLanguageStatus);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadUnitDistanceDisplayState()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadUnitDistanceDisplayState(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

 /*    if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_UnitDistanceDisplayState,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tUnitDistanceDisplayState.u32Status != u32StatusRead) {
        _tUnitDistanceDisplayState.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	
	//CID: 172285

/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tUnitDistanceDisplayState.UnitDistanceDisplayState, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tUnitDistanceDisplayState.UnitDistanceDisplayState, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadUnitDistanceDisplayState(): Called!"));
        _pCallbackIf->onUnitDistanceDisplayStateStatus(_tUnitDistanceDisplayState);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadReset_TPMS_answer_back()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadReset_TPMS_answer_back(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

  /*   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_Reset_TPMS_answer_back,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tReset_TPMS_answer_back.u32Status != u32StatusRead) {
        _tReset_TPMS_answer_back.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

//CID: 172283
/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tReset_TPMS_answer_back.Reset_TPMS_answer_back, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tReset_TPMS_answer_back.Reset_TPMS_answer_back, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadReset_TPMS_answer_back(): Called!"));
        _pCallbackIf->onReset_TPMS_answer_backStatus(_tReset_TPMS_answer_back);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadSelect_pressure_support()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSelect_pressure_support(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

/*     if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_Select_pressure_support,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tSelect_pressure_support.u32Status != u32StatusRead) {
        _tSelect_pressure_support.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	//CID:172298

/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tSelect_pressure_support.Select_pressure_support, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tSelect_pressure_support.Select_pressure_support, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
	*/

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSelect_pressure_support(): Called!"));
        _pCallbackIf->onSelect_pressure_supportStatus(_tSelect_pressure_support);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadSetting_pressure_Front_answer_back()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSetting_pressure_Front_answer_back(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

  /*   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_Setting_pressure_Front_answer_back,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tSetting_pressure_Front_answer_back.u32Status != u32StatusRead) {
        _tSetting_pressure_Front_answer_back.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

//CID: 172281
/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tSetting_pressure_Front_answer_back.Setting_pressure_Front_answer_back, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tSetting_pressure_Front_answer_back.Setting_pressure_Front_answer_back, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSetting_pressure_Front_answer_back(): Called!"));
        _pCallbackIf->onSetting_pressure_Front_answer_backStatus(_tSetting_pressure_Front_answer_back);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadSetting_pressure_Rear_answer_back()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSetting_pressure_Rear_answer_back(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

  /*   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_Setting_pressure_Rear_answer_back,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tSetting_pressure_Rear_answer_back.u32Status != u32StatusRead) {
        _tSetting_pressure_Rear_answer_back.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	//CID : 172311
	/*

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tSetting_pressure_Rear_answer_back.Setting_pressure_Rear_answer_back, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tSetting_pressure_Rear_answer_back.Setting_pressure_Rear_answer_back, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSetting_pressure_Rear_answer_back(): Called!"));
        _pCallbackIf->onSetting_pressure_Rear_answer_backStatus(_tSetting_pressure_Rear_answer_back);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadGlobalVehicleWarningState()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadGlobalVehicleWarningState(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

   /* if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_GlobalVehicleWarningState,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }*/

    if(_tGlobalVehicleWarningState.u32Status != u32StatusRead) {
        _tGlobalVehicleWarningState.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	//CID: 172279
	
	/*

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tGlobalVehicleWarningState.GlobalVehicleWarningState, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tGlobalVehicleWarningState.GlobalVehicleWarningState, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadGlobalVehicleWarningState(): Called!"));
        _pCallbackIf->onGlobalVehicleWarningStateStatus(_tGlobalVehicleWarningState);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadVehicleStates()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadVehicleStates(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

   /* if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_VehicleStates,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }*/

    if(_tVehicleStates.u32Status != u32StatusRead) {
        _tVehicleStates.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
//CID:172300
/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tVehicleStates.VehicleStates, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tVehicleStates.VehicleStates, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
	*/

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadVehicleStates(): Called!"));
        _pCallbackIf->onVehicleStatesStatus(_tVehicleStates);
    }
}

// veda_tclClientVcanCanAdaptor::ClassImplementation: user specific code start
tBool veda_tclClientVcanCanAdaptor::_bRegisterForBusOffErrorIndication(const tU8 u8Bus, tBool& bInitializationError) const
{
   VEDA_NULL_POINTER_CHECK_VAL(_poMyCSMInterface);

   tBool bRegistrationSuccess = FALSE; // Return value about Registration result
   tCSM_OSEKI_NWM_APPL_CALLBACK sCallBackFkt;

   sCallBackFkt.u16ApplID = (tU16) 0x01;/*Jayashree: CSM_C_APPL_ID_RN_CAN_NM_VEHICLE_DATA replaced with 0x01 as per g3inf4cv */
#if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
   sCallBackFkt.pvHandle = NULL;
#endif
#if (CSM_S_USE_TKSE == CSM_C_F_ON)
   sCallBackFkt.rTaskInfo = NULL;
#endif

  /* tU8 au8AddressField[2];
   au8AddressField[0] = 0x01; // Bus off monitoring
   au8AddressField[1] = 0xFF;
   sCallBackFkt.pfvCommunicationInd = veda_tclClientVcanCanAdaptor::vBusOffErrorIndication;*/

   // Bus off registration
  /* tS32 s32RoutineRetVal = _poMyCSMInterface->CSM_lApplCallbackInit(NULL, u8Bus, 0x01, au8AddressField, &sCallBackFkt);Jayashree: CSM_C_PTYPE_RN_OSEKI_NWM replaced with 0x01 as per g3inf4cv */



   return bRegistrationSuccess;
}

tBool veda_tclClientVcanCanAdaptor::_bRegisterForRxBusErrorIndication(const tU8 u8Bus, const tU8 u8Node) const
{
   VEDA_NULL_POINTER_CHECK_VAL(_poMyCSMInterface);

   tBool bRegistrationSuccess = FALSE;
   tU8 au8AddressField[2];
   tCSM_OSEKI_NWM_APPL_CALLBACK sCallBackFkt;

   sCallBackFkt.u16ApplID = (tU16) 0x01;/*Jayashree: CSM_C_APPL_ID_RN_CAN_NM_VEHICLE_DATA replaced with 0x01 as per g3inf4cv */
#if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
   sCallBackFkt.pvHandle = NULL;
#endif
#if (CSM_S_USE_TKSE == CSM_C_F_ON)
   sCallBackFkt.rTaskInfo = NULL;
#endif

   // Rx monitoring
 

   return bRegistrationSuccess;
}

tBool veda_tclClientVcanCanAdaptor::_bRegisterForTxBusErrorIndication(const tU8 u8Bus, const tU8 u8Node) const
{
   VEDA_NULL_POINTER_CHECK_VAL(_poMyCSMInterface);

   tBool bRegistrationSuccess = FALSE;
   tCSM_OSEKI_NWM_APPL_CALLBACK  sCallBackFkt;

   sCallBackFkt.u16ApplID = (tU16) 0x01;/*Jayashree: CSM_C_APPL_ID_RN_CAN_NM_VEHICLE_DATA replaced with 0x01 as per g3inf4cv */
#if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
   sCallBackFkt.pvHandle = OSAL_NULL;
#endif
#if (CSM_S_USE_TKSE == CSM_C_F_ON)
   sCallBackFkt.rTaskInfo = OSAL_NULL;
#endif

   

   return bRegistrationSuccess;
}

tVoid veda_tclClientVcanCanAdaptor::vBusOffErrorIndication( tVoid* /* pvHandle */,
                                                           tU8 u8Bus,
                                                           tU32 /* u32ProtocolType */,
                                                           const tVoid * pvAddressField,
                                                           tU8 u8State,
                                                           tU16 /* u16ApplId */)
{
   ETG_TRACE_USR1(("vBusOffErrorIndication() triggered"));

  
}


tVoid veda_tclClientVcanCanAdaptor::vRxBusErrorIndication( tVoid* /* pvHandle */,
                                                          tU8 /*u8Bus*/,
                                                          tU32 /* u32ProtocolType */,
                                                          const tVoid * pvAddressField,
                                                          tU8 u8State,
                                                          tU16 /* u16ApplId */)
{
   ETG_TRACE_USR1(("vRxBusErrorIndication() triggered"));

  /*if ( CSM_C_ADR_FLD_DC_NM_RX_INDICATOR == *(((tU8*)pvAddressField)+0) ) //lint !e1773: Attempt to cast away const (or volatile)
   {
      tU8 u8Node = (tU8) *(((tU8*)pvAddressField)+1); //lint !e1773: Attempt to cast away const (or volatile)
      tU8 u8DiagIndex = VEDA_DIAG_LAST;

      switch (u8Node)
      {*/
    /*  case CSM_C_ADR_FLD_RN_NM_454: //VCAN - BCM
         u8DiagIndex = VEDA_DIAG_ECU_BCM_454___;
         break;

      case CSM_C_ADR_FLD_RN_NM_224: //VCAN - USM
         u8DiagIndex = VEDA_DIAG_ECU_USM_224___;
         break;

      case CSM_C_ADR_FLD_RN_NM_4F2: //VCAN - Cluster/Meter
         u8DiagIndex = VEDA_DIAG_ECU_METER_4F2_;
         break;

      case CSM_C_ADR_FLD_RN_NM_5EA: //VCAN - COP
         u8DiagIndex = VEDA_DIAG_ECU_ISA_5EA___;
         break;

      case CSM_C_ADR_FLD_RN_NM_AVM: //VCAN - AVM
         u8DiagIndex = VEDA_DIAG_ECU_AVM_5C2___;
         break;

      case CSM_C_ADR_FLD_RN_NM_STRG: //VCAN - STRG 002
         u8DiagIndex = VEDA_DIAG_ECU_STRG_002__;
         break;

      case CSM_C_ADR_FLD_RN_NM_HCM: //VCAN - HCM
         u8DiagIndex = VEDA_DIAG_ECU_HCM_15C___;
         break;

      case CSM_C_ADR_FLD_RN_NM_SBW: //VCAN - SBW
         u8DiagIndex = VEDA_DIAG_ECU_SBW_0C1___;
         break;

      case CSM_C_ADR_FLD_RN_NM_SONAR: //VCAN - SONAR
         u8DiagIndex = VEDA_DIAG_ECU_SONAR_57A_;
         break;

      case CSM_C_ADR_FLD_RN_NM_ATCU: //VCAN - ATCU
         u8DiagIndex = VEDA_DIAG_ECU_ATCU______;
         break;

      case CSM_C_ADR_FLD_RN_NM_EPS: //VCAN - EPS
         u8DiagIndex = VEDA_DIAG_ECU_EPS_A3___;
         break;

      case CSM_C_ADR_FLD_RN_NM_VDC: //VCAN - VDC
         u8DiagIndex = VEDA_DIAG_ECU_VDC_438__;
         break;

      case CSM_C_ADR_FLD_RN_NM_FCAM: //VCAN - FRONT CAMERA
         u8DiagIndex = VEDA_DIAG_ECU_FCAM_____;
         break;

      case CSM_C_ADR_FLD_RN_NM_FWS: //VCAN - FWS
         u8DiagIndex = VEDA_DIAG_ECU_FWS_179___;
         break;

      case CSM_C_ADR_FLD_RN_NM_HFM: //VCAN - HFM
         u8DiagIndex = VEDA_DIAG_ECU_HFM_46F___;
         break;

      case CSM_C_ADR_FLD_RN_NM_HVAC: //VCAN - HVAC
         u8DiagIndex = VEDA_DIAG_ECU_HVAC_A1__;
         break;

      case CSM_C_ADR_FLD_RN_NM_HUD: //VCAN - HUD
         u8DiagIndex = VEDA_DIAG_ECU_HUD_______;
         break;

      case CSM_C_ADR_FLD_RN_NM_VTCU: //VCAN - TCU
         u8DiagIndex = VEDA_DIAG_ECU_TCU_43C___;
         break;

      case CSM_C_ADR_FLD_RN_NM_ACU: //VCAN - ACU
         u8DiagIndex = VEDA_DIAG_ECU_ACU_538___;
         break;

      case CSM_C_ADR_FLD_RN_NM_ADAS: //VCAN - ADAS
         u8DiagIndex = VEDA_DIAG_ECU_ADAS_A6___;
         break;

      case CSM_C_ADR_FLD_RN_NM_BSW: //VCAN - BSW
         u8DiagIndex = VEDA_DIAG_ECU_BSW_______;
         break;

      case CSM_C_ADR_FLD_RN_NM_HSM: //VCAN - HSM
         u8DiagIndex = VEDA_DIAG_ECU_HSM_______;
         break;

      case CSM_C_ADR_FLD_RN_NM_SR: //VCAN - SR
         u8DiagIndex = VEDA_DIAG_ECU_SR________;
         break;

      case CSM_C_ADR_FLD_RN_NM_DSMU: //VCAN - DSMU
         u8DiagIndex = VEDA_DIAG_ECU_DSMU______;
         break;

      case CSM_C_ADR_FLD_RN_NM_PSCU: //VCAN - PSCU
         u8DiagIndex = VEDA_DIAG_ECU_PSCU______;
         break;

      case CSM_C_ADR_FLD_RN_NM_ECM: //VCAN - ECM
         u8DiagIndex = VEDA_DIAG_ECU_ECM_______;
         break;
		 
      case CSM_C_ADR_FLD_RN_NM_AMP: //VCAN - AMP
         u8DiagIndex = VEDA_DIAG_ECU_AMP_______;
         break;*/

      /*default:
         u8DiagIndex = VEDA_DIAG_LAST;
         break;
      }*/

      /*if (_pMyStaticRef)
         _pMyStaticRef->_vHandleMessagePosting(veda_tclBaseIf::eCmdCsmBusIndReceived, u8DiagIndex, u8State, FALSE);
   }
   else
   {
      ETG_TRACE_USR1(("WARNING! Wrong Call back for CSM_C_ADR_FLD_RN_NM_RX_INDICATOR registered"));
   }*/
}

tVoid veda_tclClientVcanCanAdaptor::vTxBusErrorIndication( tVoid* /* pvHandle */,
                                                          tU8 /*u8Bus*/,
                                                          tU32 /* u32ProtocolType */,
                                                          const tVoid * pvAddressField,
                                                          tU8 u8State,
                                                          tU16 /* u16ApplId */)
{
   ETG_TRACE_USR1(("vTxBusErrorIndication() triggered"));

  /*if ( CSM_C_ADR_FLD_DC_NM_TX_INDICATOR == *(((tU8*)pvAddressField)+0) ) //lint !e1773: Attempt to cast away const (or volatile)
   {
      tU8 u8Node = (tU8) *(((tU8*)pvAddressField)+1); //lint !e1773: Attempt to cast away const (or volatile)
      tU8 u8DiagIndex;
      switch (u8Node)
      {*/
		  /*
      case CSM_C_ADR_FLD_RN_NM_AUDIO: //MCAN - AUDIO
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_AUD_;
         break;

      case CSM_C_ADR_FLD_RN_NM_SWC: //MCAN - SWC
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_SWC_;
         break;

      case CSM_C_ADR_FLD_RN_NM_NAVI: //MCAN - NAVI
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_NAV_;
         break;

      case CSM_C_ADR_FLD_RN_NM_NAVI2: // MCAN Navi Gen2
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_NAV2;
         break;

      case CSM_C_ADR_FLD_RN_NM_TCU: //MCAN - TCU
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_TCU_;
         break;

      case CSM_C_ADR_FLD_RN_NM_BOSE: //MCAN - BOSE
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_BOSE;
         break;

      case CSM_C_ADR_FLD_RN_NM_RSE: //MCAN - RSE
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_RSE_;
         break;

      case CSM_C_ADR_FLD_RN_NM_AVM:
         // VCAN Tx Telegram 0x5FE
         u8DiagIndex = VEDA_DIAG_MUTE_VCAN_____;
         break;*/
      /*default:
         u8DiagIndex = VEDA_DIAG_LAST;
         break;
      }*/

     /* if (_pMyStaticRef)
         _pMyStaticRef->_vHandleMessagePosting(veda_tclBaseIf::eCmdCsmBusIndReceived, u8DiagIndex, u8State, FALSE);
   }
   else
   {
      ETG_TRACE_USR1(("WARNING! Wrong Call back for CSM_C_ADR_FLD_RN_NM_TX_INDICATOR registered"));
   }*/
}


tBool veda_tclClientVcanCanAdaptor::_bCheckCommunicationState_RX(const tU8 u8Bus, const tU8 u8Node, tU8& u8FaultState) const
{
   VEDA_NULL_POINTER_CHECK_VAL(_poMyCSMInterface);

   tBool bRequest = TRUE;
   tU8  u8CommunicationState = CNM_OSEKI_C_STATE_NODE_PRESENT;
   tU8 au8AddressField[2];
   au8AddressField[0] = CSM_C_ADR_FLD_DC_NM_RX_INDICATOR;
   au8AddressField[1] = u8Node;
#if 0
   if ( 0)/*Jayashree: CSM_C_APPL_ID_RN_CAN_NM_VEHICLE_DATA replaced with 0x01 as per g3inf4cv */
   {
      bRequest = FALSE;
     // ETG_TRACE_USR1(("_bCheckCommunicationState_RX() CSM_lGetCommunicationState failed !!"));
   }
   else
   {
#endif
      tU8 u8DiagIndex;
      switch (au8AddressField[1])
      {
		  /*
      case CSM_C_ADR_FLD_RN_NM_454: //VCAN - BCM
         u8DiagIndex = VEDA_DIAG_ECU_BCM_454___;
         break;

      case CSM_C_ADR_FLD_RN_NM_224: //VCAN - USM
         u8DiagIndex = VEDA_DIAG_ECU_USM_224___;
         break;

      case CSM_C_ADR_FLD_RN_NM_4F2: //VCAN - Cluster/Meter
         u8DiagIndex = VEDA_DIAG_ECU_METER_4F2_;
         break;

      case CSM_C_ADR_FLD_RN_NM_5EA: //VCAN - COP
         u8DiagIndex = VEDA_DIAG_ECU_ISA_5EA___;
         break;

      case CSM_C_ADR_FLD_RN_NM_AVM: //VCAN - AVM
         u8DiagIndex = VEDA_DIAG_ECU_AVM_5C2___;
         break;

      case CSM_C_ADR_FLD_RN_NM_STRG: //VCAN - STRG 002
         u8DiagIndex = VEDA_DIAG_ECU_STRG_002__;
         break;

      case CSM_C_ADR_FLD_RN_NM_HCM: //VCAN - HCM
         u8DiagIndex = VEDA_DIAG_ECU_HCM_15C___;
         break;

      case CSM_C_ADR_FLD_RN_NM_SBW: //VCAN - SBW
         u8DiagIndex = VEDA_DIAG_ECU_SBW_0C1___;
         break;

      case CSM_C_ADR_FLD_RN_NM_SONAR: //VCAN - SONAR
         u8DiagIndex = VEDA_DIAG_ECU_SONAR_57A_;
         break;
      default:
         u8DiagIndex = VEDA_DIAG_LAST;
         break;
      }

      switch (u8CommunicationState)
      {
      case CNM_OSEKI_C_STATE_BUS_ON:
    	  u8FaultState = BUS_FAULT_INACTIVE;
         break;
      case CNM_OSEKI_C_STATE_BUS_OFF:
    	  u8FaultState = BUS_FAULT_ACTIVE;
         break;
      case CNM_OSEKI_C_STATE_CONFIRMED_BUS_OFF:
    	  u8FaultState = BUS_FAULT_CONFIRMED;
         break;*/
      default:
    	  u8FaultState = BUS_FAULT_UNKNOWN;
         break;
      }
//   }

   return bRequest;
}

tBool veda_tclClientVcanCanAdaptor::_bCheckCommunicationState_TX(const tU8 u8Bus, const tU8 u8Node, tU8& u8FaultState) const
{
   VEDA_NULL_POINTER_CHECK_VAL(_poMyCSMInterface);

   tBool bRequest = TRUE;


   tU8 au8AddressField[2];
  // au8AddressField[0] = CSM_C_ADR_FLD_DC_NM_TX_INDICATOR;
   au8AddressField[1] = u8Node;
#if 0 //Due to coverity warning
   if ( 0 )
   {
      bRequest = FALSE;
      //ETG_TRACE_USR1(("_bCheckCommunicationState_TX() CSM_lGetCommunicationState failed !!"));
   }
   else
   {
#endif
      tU8 u8DiagIndex;
      switch (au8AddressField[1])
      {
		  /*
      case CSM_C_ADR_FLD_RN_NM_AUDIO: //MCAN - AUDIO
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_AUD_;
         break;

      case CSM_C_ADR_FLD_RN_NM_SWC: //MCAN - SWC
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_SWC_;
         break;

      case CSM_C_ADR_FLD_RN_NM_NAVI: //MCAN - NAVI
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_NAV_;
         break;

      case CSM_C_ADR_FLD_RN_NM_NAVI2: // MCAN Navi Gen2
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_NAV2;
         break;

      case CSM_C_ADR_FLD_RN_NM_TCU: //MCAN - TCU
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_TCU_;
         break;

      case CSM_C_ADR_FLD_RN_NM_BOSE: //MCAN - BOSE
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_BOSE;
         break;

      case CSM_C_ADR_FLD_RN_NM_RSE: //MCAN - RSE
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_RSE_;
         break;

      case CSM_C_ADR_FLD_RN_NM_AVM:
         // VCAN Tx Telegram 0x5FE
         u8DiagIndex = VEDA_DIAG_MUTE_VCAN_____;
         break;*/
      default:
         u8DiagIndex = VEDA_DIAG_LAST;
         break;
      }

	u8FaultState = BUS_FAULT_UNKNOWN;

//   }

   return bRequest;
}

tBool veda_tclClientVcanCanAdaptor::_bCheckCommunicationState_BusOff(const tU8 u8Bus, tU8& u8FaultState) const
{
   tBool bRequest = TRUE;
   tU8  u8CommunicationState = CNM_OSEKI_C_STATE_ERROR;

   tU8 au8AddressField[2];
   //au8AddressField[0] = CSM_C_ADR_FLD_DC_NM_BUSOFF_INDICATOR;  (piyush)
   au8AddressField[1] = 0xFF;

   VEDA_NULL_POINTER_CHECK_VAL(_poMyCSMInterface);
#if 0   //Due to coverity warning
   if ( 0 )
   {
      bRequest = FALSE;
     // ETG_TRACE_USR1(("_bCheckCommunicationState_BusOff() CSM_lGetCommunicationState failed !!"));
   }
   
   else
   {
#endif
      tU8 u8DiagIndex;
      switch (u8Bus)
      {
      case CSM_C_CAN_BUS_MCAN:
         u8DiagIndex = VEDA_DIAG_BUS_OFF_MCAN__;
         break;
      case CSM_C_CAN_BUS_VCAN:
         u8DiagIndex = VEDA_DIAG_BUS_OFF_VCAN__;
         break;
      default:
         u8DiagIndex = VEDA_DIAG_LAST;
         break;
      }

      switch (u8CommunicationState)
      {
		  //CID:220026
		  /*
      case CNM_OSEKI_C_STATE_BUS_ON:
    	  u8FaultState = BUS_FAULT_INACTIVE;
         break;
      case CNM_OSEKI_C_STATE_BUS_OFF:
    	  u8FaultState = BUS_FAULT_ACTIVE;
         break;
      case CNM_OSEKI_C_STATE_CONFIRMED_BUS_OFF:
    	  u8FaultState = BUS_FAULT_CONFIRMED;
         break;
		 */
      default:
    	  u8FaultState = BUS_FAULT_UNKNOWN;
         break;
      }
//   }

   return bRequest;
}

tVoid veda_tclClientVcanCanAdaptor::_vHandleMessagePosting(const veda_tclBaseIf::ECmdTypes, const tU8 u8DiagIndex, const tU8 u8Result, const tU8 u8ForceUpdate) const
{
   veda_tclBaseIf::TMsg oMsg;
   (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
   oMsg.eCmd = veda_tclBaseIf::eCmdCsmBusIndReceived;
   memset(oMsg.strClassName, 0, 50);
   OSAL_szStringNCopy(oMsg.strClassName, "veda_tclClientVcan", strlen("veda_tclClientVcan"));

   oMsg.u.au8Data[0] = u8DiagIndex;
   oMsg.u.au8Data[2] = u8ForceUpdate;

   // Map the received error state to vehicle data internally defined state
   switch (u8Result)
   {
   case CNM_OSEKI_C_STATE_BUS_ON:
      oMsg.u.au8Data[1] = BUS_FAULT_INACTIVE;
      break;
   case CNM_OSEKI_C_STATE_BUS_OFF:
      oMsg.u.au8Data[1] = BUS_FAULT_ACTIVE;
      break;
   case CNM_OSEKI_C_STATE_CONFIRMED_BUS_OFF:
      oMsg.u.au8Data[1] = BUS_FAULT_CONFIRMED;
      break;
   default:
      oMsg.u.au8Data[1] = BUS_FAULT_UNKNOWN;
      break;
   }

   _pMyStaticRef->_cpoMain->theServer()->vPostInternalMessage(&oMsg);
}

tVoid veda_tclClientVcanCanAdaptor::_vSendKDSCodingChangedInfoToCSM() const
{
   tU8 pbData = 0;
   tU32 wDataLength = 0x01;
	 //CID: 578161
   tU8 au8AddressField[4];
   au8AddressField[0] = 0x27;//CSM_C_ADDRESS_FIELD_LCTRL_DIA_KDS_CHANGED;// (== 0x27)
   au8AddressField[1] = 0x00;

   VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);

   if ( CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lDataReq( NULL, CSM_C_PTYPE_USED_STD_CAN_LOCAL_CTRL/*CSM_C_PTYPE_PSGEN_CAN_LOCAL_CTRL CSM_C_PTYPE_RN_CAN_LOCAL_CTRL commented as it is not required for g3inf4cv*/,
      &au8AddressField[0], &pbData, wDataLength) )
   {
      ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::vSendKDSCodingChangedInfoToCSM() Failed!!"));
   }
   else
   {
      ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::vSendKDSCodingChangedInfoToCSM() Sent Success!!"));
   }
}

/*tVoid veda_tclClientVcanCanAdaptor::vReinitCsmNetworkManagement(tVoid) const
{
	//CID: 578165
	tU8 au8AddressField[4];
	//au8AddressField[0] = CSM_C_ADR_FLD_DC_NM_CMD_INDICATOR; (piyush)
	au8AddressField[1] = 0xFF;

	VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);

	if( _poMyCSMInterface->CSM_lCommunicationReq(OSAL_NULL,
			CSM_C_CAN_BUS_VCAN,
			CSM_C_PTYPE_USED_STD_CAN_LOCAL_CTRL,Jayashree: CSM_C_PTYPE_RN_OSEKI_NWM replaced with 0x01 as per g3inf4cv 
			au8AddressField,
			CNM_OSEKI_CMD_REINIT_MONITOR,
			(tU16) CSM_C_APPL_ID_DC_CAN_NM_VEHICLE_DATA) < CSM_C_NO_ERROR ) Jayashree: CSM_C_APPL_ID_RN_CAN_NM_VEHICLE_DATA replaced with 0x01 as per g3inf4cv 
	{
		ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::vReinitCsmNetworkManagement() CSM_lCommunicationReq failed"));
	}
}*/
tVoid veda_tclClientVcanCanAdaptor::vSendCallInfoToCluster(TMediaInfo tTxSignal)
{
}
tVoid veda_tclClientVcanCanAdaptor::vSendPhoneInfoToCluster(TMediaInfo tTxSignal)
{
}
tVoid veda_tclClientVcanCanAdaptor::vSendTurnToStreetInfoToCluster(TStreetInfo tTxSignal)
{
}
tVoid veda_tclClientVcanCanAdaptor::vSendCurrentStreetInfoToCluster(TStreetInfo tTxSignal)
{
}
 tVoid  veda_tclClientVcanCanAdaptor::vSendDestinationInfoToCluster(TNaviInfo tTxSignal)
 {
 }
 tVoid veda_tclClientVcanCanAdaptor::vSendTurnToSymbolsInfoToCluster(TNaviInfo tTxSignal)
 {
 }
 tVoid veda_tclClientVcanCanAdaptor::vSendNaviLaneGuidanceInfoToCluster(TNaviInfo tTxSignal)
 {
 }
 tVoid veda_tclClientVcanCanAdaptor::vSendNaviWarningInfoToCluster(TNaviInfo tTxSignal)
 {
 }
tVoid veda_tclClientVcanCanAdaptor::vSendMeidaDataToCluster(vehicle_fi_tcl_CAN_Mesg msg)
{
}
tVoid  veda_tclClientVcanCanAdaptor::vSendCallDataToCluster(vehicle_fi_tcl_CAN_Mesg msg)
{
}
tVoid  veda_tclClientVcanCanAdaptor::vSendPhoneDataToCluster(vehicle_fi_tcl_CAN_Mesg msg)
{
}
tVoid veda_tclClientVcanCanAdaptor::vGetSpeed_Limit_Display_Request(TSpeed_Limit_Display_Request& tSpeed_Limit_Display_Request) {
        vReadSpeed_Limit_Display_Request();
        memcpy(&tSpeed_Limit_Display_Request, &_tSpeed_Limit_Display_Request, sizeof(TSpeed_Limit_Display_Request));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetNavi_display_speed_limit_1(TNavi_display_speed_limit_1& tNavi_display_speed_limit_1) {
        vReadNavi_display_speed_limit_1();
        memcpy(&tNavi_display_speed_limit_1, &_tNavi_display_speed_limit_1, sizeof(TNavi_display_speed_limit_1));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetNavi_display_speed_limit_2(TNavi_display_speed_limit_2& tNavi_display_speed_limit_2) {
        vReadNavi_display_speed_limit_2();
        memcpy(&tNavi_display_speed_limit_2, &_tNavi_display_speed_limit_2, sizeof(TNavi_display_speed_limit_2));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetIgnitionSupplyConfirmation(TIgnitionSupplyConfirmation& tIgnitionSupplyConfirmation) {
        vReadIgnitionSupplyConfirmation();
        memcpy(&tIgnitionSupplyConfirmation, &_tIgnitionSupplyConfirmation, sizeof(TIgnitionSupplyConfirmation));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetVehicleSpeed(TVehicleSpeed& tVehicleSpeed) {
        vReadVehicleSpeed();
        memcpy(&tVehicleSpeed, &_tVehicleSpeed, sizeof(TVehicleSpeed));
    }
	//TCOVehiclespeed
	tVoid veda_tclClientVcanCanAdaptor::vGetTCOVehicleSpeed(TTCOVehicleSpeed& tTCOVehicleSpeed) {
        
    }
	//piyush
	tVoid veda_tclClientVcanCanAdaptor::vGetPartialMuteValue(TPartialMuteValue& tPartialMuteValue) {
        vReadPartialMuteValue();
        memcpy(&tPartialMuteValue, &_tPartialMuteValue, sizeof(TPartialMuteValue));
    }
	//VIN
	tVoid veda_tclClientVcanCanAdaptor::vGetVINValue(TVINValue& tVINValue) {
        vReadVINValue();
        memcpy(&tVINValue, &_tVINValue, sizeof(TVINValue));
    }
	//Time Date
	tVoid veda_tclClientVcanCanAdaptor::vGetTimeDateValue(TTimeDateValue& tTimeDateValue) {


    }
	//phonecallCommand
	 tVoid veda_tclClientVcanCanAdaptor::vGetPhoneCallCmdValue(TPhoneCallCommand& tPhoneCallCommand)
	 {
	 }		 
	
	
	//ParkingBreakSwitch
	tVoid veda_tclClientVcanCanAdaptor::vGetParkingBreakSwitchValue(TParkingBreakSwitchValue& tParkingBreakSwitchValue) {
        vReadParkingBreakSwitchValue();
        memcpy(&tParkingBreakSwitchValue, &_tParkingBreakSwitchValue, sizeof(TParkingBreakSwitchValue));
    }
	tVoid veda_tclClientVcanCanAdaptor::vGetSwivMonAutoOpenValue(TSwivMonAutoOpenValue& tSwivMonAutoOpenValue) {
        
    }
	tVoid veda_tclClientVcanCanAdaptor::vGetDateModeValue(TDateModeValue& tDateModeValue) {
        
    }
	tVoid veda_tclClientVcanCanAdaptor::vGetTmModeValue(TTmModeValue& tTmModeValue) {
        
    }
	//camera
	tVoid veda_tclClientVcanCanAdaptor::vGetActCam1Value(TActCam1Value& tActCam1Value) {
        
    }
	//camera2
	tVoid veda_tclClientVcanCanAdaptor::vGetActCam2Value(TActCam2Value& tActCam2Value) {
        
    }
	//camera3
	tVoid veda_tclClientVcanCanAdaptor::vGetActCam3Value(TActCam3Value& tActCam3Value) {
        
    }
	//camera4
	tVoid veda_tclClientVcanCanAdaptor::vGetActCam4Value(TActCam4Value& tActCam4Value) {
        
    }
	//camera5
	tVoid veda_tclClientVcanCanAdaptor::vGetActCam5Value(TActCam5Value& tActCam5Value) {
        
    }
	//camera6
	tVoid veda_tclClientVcanCanAdaptor::vGetActCam6Value(TActCam6Value& tActCam6Value) {
        
    }
	//camera7
	tVoid veda_tclClientVcanCanAdaptor::vGetActCam7Value(TActCam7Value& tActCam7Value) {
        
    }
	//camsplit
	tVoid veda_tclClientVcanCanAdaptor::vGetCamSplitQuadValue(TCamSplitQuadValue& tCamSplitQuadValue) {
        
    }
	//MuteDev
	tVoid veda_tclClientVcanCanAdaptor::vGetMuteDevStatus(TMuteDevStatus& tMuteDevStatus) {
        vReadMuteDevStatus();
        memcpy(&tMuteDevStatus, &_tMuteDevStatus, sizeof(TMuteDevStatus));
    }
	//Rear gear
	tVoid veda_tclClientVcanCanAdaptor::vGetRearGearEngaged(TRearGearEngaged& tRearGearEngaged) {
        vReadRearGearEngaged();
        memcpy(&tRearGearEngaged, &_tRearGearEngaged, sizeof(TRearGearEngaged));
    }
	//sysVolt
	tVoid veda_tclClientVcanCanAdaptor::vGetSysVoltStatus(TSysVoltStatus& tSysVoltStatus) {
        
    }
	
	//Distance Unit
	tVoid veda_tclClientVcanCanAdaptor::vGetUnitDistanceDisplayState(TUnitDistanceDisplayState& tUnitDistanceDisplayState) {
    
    }
	
	//RearCamReq
	tVoid veda_tclClientVcanCanAdaptor::vGetRearCamReqValue(TRearCamReqValue& tRearCamReqValue){
		
	}
	//System Language
	tVoid veda_tclClientVcanCanAdaptor::vGetSystemLanguageValue(TSystemLanguageValue& tSystemLanguageValue){
		
	}
	
	//CurrLang
	tVoid veda_tclClientVcanCanAdaptor::vGetCurrLangValue(TCurrLangValue& tCurrLangValue){
		
	}
	//CamTxt
	tVoid veda_tclClientVcanCanAdaptor::vGetCamTxtValue(TCamTxtValue& tCamTxtValue) {
        
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetHandBrakeSwitch(THandBrakeSwitch& tHandBrakeSwitch) {
        vReadHandBrakeSwitch();
        memcpy(&tHandBrakeSwitch, &_tHandBrakeSwitch, sizeof(THandBrakeSwitch));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetDistanceTotalizer(TDistanceTotalizer& tDistanceTotalizer) {
        vReadDistanceTotalizer();
        memcpy(&tDistanceTotalizer, &_tDistanceTotalizer, sizeof(TDistanceTotalizer));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetDistanceUnit(TDistanceUnit& tDistanceUnit) {
        vReadDistanceUnit();
        memcpy(&tDistanceUnit, &_tDistanceUnit, sizeof(TDistanceUnit));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetAverage_Fuel_Economy(TAverage_Fuel_Economy& tAverage_Fuel_Economy) {
        vReadAverage_Fuel_Economy();
        memcpy(&tAverage_Fuel_Economy, &_tAverage_Fuel_Economy, sizeof(TAverage_Fuel_Economy));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetDiagMuxOn(TDiagMuxOn& tDiagMuxOn) {
        vReadDiagMuxOn();
        memcpy(&tDiagMuxOn, &_tDiagMuxOn, sizeof(TDiagMuxOn));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetDiagMuxOn_84(TDiagMuxOn_84& tDiagMuxOn_84) {
        vReadDiagMuxOn_84();
        memcpy(&tDiagMuxOn_84, &_tDiagMuxOn_84, sizeof(TDiagMuxOn_84));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetGADE(TGADE& tGADE) {
        vReadGADE();
        memcpy(&tGADE, &_tGADE, sizeof(TGADE));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetOSPOverSpeedDisplayRequest(TOSPOverSpeedDisplayRequest& tOSPOverSpeedDisplayRequest) {
        vReadOSPOverSpeedDisplayRequest();
        memcpy(&tOSPOverSpeedDisplayRequest, &_tOSPOverSpeedDisplayRequest, sizeof(TOSPOverSpeedDisplayRequest));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetOSPSpeedUnit(TOSPSpeedUnit& tOSPSpeedUnit) {
        vReadOSPSpeedUnit();
        memcpy(&tOSPSpeedUnit, &_tOSPSpeedUnit, sizeof(TOSPSpeedUnit));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetTSR_OSP_ActivationStatus(TTSR_OSP_ActivationStatus& tTSR_OSP_ActivationStatus) {
        vReadTSR_OSP_ActivationStatus();
        memcpy(&tTSR_OSP_ActivationStatus, &_tTSR_OSP_ActivationStatus, sizeof(TTSR_OSP_ActivationStatus));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetMeterLanguageKnowledge(TMeterLanguageKnowledge& tMeterLanguageKnowledge) {
        vReadMeterLanguageKnowledge();
        memcpy(&tMeterLanguageKnowledge, &_tMeterLanguageKnowledge, sizeof(TMeterLanguageKnowledge));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetMeterLanguageStatus(TMeterLanguageStatus& tMeterLanguageStatus) {
        vReadMeterLanguageStatus();
        memcpy(&tMeterLanguageStatus, &_tMeterLanguageStatus, sizeof(TMeterLanguageStatus));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetReset_TPMS_answer_back(TReset_TPMS_answer_back& tReset_TPMS_answer_back) {
        vReadReset_TPMS_answer_back();
        memcpy(&tReset_TPMS_answer_back, &_tReset_TPMS_answer_back, sizeof(TReset_TPMS_answer_back));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetSelect_pressure_support(TSelect_pressure_support& tSelect_pressure_support) {
        vReadSelect_pressure_support();
        memcpy(&tSelect_pressure_support, &_tSelect_pressure_support, sizeof(TSelect_pressure_support));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetSetting_pressure_Front_answer_back(TSetting_pressure_Front_answer_back& tSetting_pressure_Front_answer_back) {
        vReadSetting_pressure_Front_answer_back();
        memcpy(&tSetting_pressure_Front_answer_back, &_tSetting_pressure_Front_answer_back, sizeof(TSetting_pressure_Front_answer_back));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetSetting_pressure_Rear_answer_back(TSetting_pressure_Rear_answer_back& tSetting_pressure_Rear_answer_back) {
        vReadSetting_pressure_Rear_answer_back();
        memcpy(&tSetting_pressure_Rear_answer_back, &_tSetting_pressure_Rear_answer_back, sizeof(TSetting_pressure_Rear_answer_back));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetGlobalVehicleWarningState(TGlobalVehicleWarningState& tGlobalVehicleWarningState) {
        vReadGlobalVehicleWarningState();
        memcpy(&tGlobalVehicleWarningState, &_tGlobalVehicleWarningState, sizeof(TGlobalVehicleWarningState));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetVehicleStates(TVehicleStates& tVehicleStates) {
        vReadVehicleStates();
        memcpy(&tVehicleStates, &_tVehicleStates, sizeof(TVehicleStates));
    }

    //Cam1ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam1ManAct(TCam1ManAct tTxSignal){
	}
	//Cam2ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam2ManAct(TCam2ManAct tTxSignal) {
    }
	//Cam3ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam3ManAct(TCam3ManAct tTxSignal) {
    }
	//Cam4ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam4ManAct(TCam4ManAct tTxSignal) {
    }
	//Cam5ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam5ManAct(TCam5ManAct tTxSignal) {
    }
	//Cam6ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam6ManAct(TCam6ManAct tTxSignal) {
    }
	//Cam7ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam7ManAct(TCam7ManAct tTxSignal) {
    }
	//Cam8ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam8ManAct(TCam8ManAct tTxSignal) {
    }
	//Cam9ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam9ManAct(TCam9ManAct tTxSignal) {
    }
	//Cam10ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam10ManAct(TCam10ManAct tTxSignal) {
    }
	//Cam11ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam11ManAct(TCam11ManAct tTxSignal) {
    }
	//Cam12ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam12ManAct(TCam12ManAct tTxSignal) {
    }
	//Cam13ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam13ManAct(TCam13ManAct tTxSignal) {
    }
	//Cam14ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam14ManAct(TCam14ManAct tTxSignal) {
    }
	//Cam15ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam15ManAct(TCam15ManAct tTxSignal) {
    }
	//Cam16ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam16ManAct(TCam16ManAct tTxSignal) {
    }
	//Cam17ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam17ManAct(TCam17ManAct tTxSignal) {
    }
	//PrivacyResetAck
	tVoid veda_tclClientVcanCanAdaptor::vSendPrivacyResetAck(TPrivacyResetAck tTxSignal) {
		vSendCsmBroadcastSignal(&tTxSignal.PrivacyResetAck, 1, CSM_C_SIG_TX_PrivacyResetAck_ITM_State, tTxSignal.u8TxType);
    }
	//DispCamCls
	tVoid veda_tclClientVcanCanAdaptor::vSendDispCamCls(TDispCamCls tTxSignal) {
    }
	//PhoneBTLinkStatus
	tVoid veda_tclClientVcanCanAdaptor::vSendPhoneBTLinkStatus(TPhoneBTLinkStatus tTxSignal) {
    }
	//PhoneBookSyncstatus
	tVoid veda_tclClientVcanCanAdaptor::vSendPhoneBookSyncstatus(TPhoneBookSyncStatus tTxSignal) {
    }
	//CallHistorySyncStatus
	tVoid veda_tclClientVcanCanAdaptor::vSendCallHistorySyncStatus(TCallHistorySyncStatus tTxSignal) {
    }
	//PhoneStatusRoaming
	tVoid veda_tclClientVcanCanAdaptor::vSendPhoneStatusRoaming(TPhoneStatusRoaming tTxSignal) {
    }
	//CallDuration
	tVoid veda_tclClientVcanCanAdaptor::vSendCallDuration(TCallDuration tTxSignal) {
    }
	//GSMSignalStrength
	tVoid veda_tclClientVcanCanAdaptor::vSendGSMSignalStrength(TGSMSignalStrength tTxSignal) {
    }
	//PhoneCallStatus
	tVoid veda_tclClientVcanCanAdaptor::vSendPhoneCallStatus(TPhoneCallStatus tTxSignal) {
    }
	//PhoneBatteryLevelStatus
	tVoid veda_tclClientVcanCanAdaptor::vSendPhoneBatteryLevelStatus(TPhoneBatteryLevelStatus tTxSignal) {
    }
	//DeviceStatusWifiAvailable
	tVoid veda_tclClientVcanCanAdaptor::vSendDeviceStatusWifiAvailable(TDeviceStatusWifiAvailable tTxSignal) {
    }
	//MediaStatusAudioSource
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusAudioSource(TMediaStatusAudioSource tTxSignal) {
    }
	//PhoneAvailableStatus
	tVoid veda_tclClientVcanCanAdaptor::vSendPhoneAvailableStatus(TPhoneAvailableStatus tTxSignal) {
    }
		//PhoneVRAvailable
	tVoid veda_tclClientVcanCanAdaptor::vSendPhoneVRAvailable(TPhoneVRAvailable tTxSignal) {
    }
	//DeviceStatusBTStatus
	tVoid veda_tclClientVcanCanAdaptor::vSendDeviceStatusBTStatus(TDeviceStatusBTStatus tTxSignal) {
    }
	//DeviceStatusBluetoothAvail
	tVoid veda_tclClientVcanCanAdaptor::vSendDeviceStatusBluetoothAvail(TDeviceStatusBluetoothAvail tTxSignal) {
    }	
	//Req_DeviceInfo
	tVoid veda_tclClientVcanCanAdaptor::vSendReq_DeviceInfo(TReq_DeviceInfo tTxSignal) {
    }
	//MediaStatusVolume
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusVolume(TMediaStatusVolume tTxSignal) {
    }
	//CabinMediaStatusAudioSource
	tVoid veda_tclClientVcanCanAdaptor::vSendCabinMediaStatusAudioSource(TCabinMediaStatusAudioSource tTxSignal) {
    }
		//CabinMediaStatusTunerBand
	tVoid veda_tclClientVcanCanAdaptor::vSendCabinMediaStatusTunerBand(TCabinMediaStatusTunerBand tTxSignal) {
    }
	//CabinMediaStatusVolume
	tVoid veda_tclClientVcanCanAdaptor::vSendCabinMediaStatusVolume(TCabinMediaStatusVolume tTxSignal) {
    }
	//MediaStatusMuteStatus
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusMuteStatus(TMediaStatusMuteStatus tTxSignal) {
    }
	//CabinMediaStatusMuteStatus
	tVoid veda_tclClientVcanCanAdaptor::vSendCabinMediaStatusMuteStatus(TCabinMediaStatusMuteStatus tTxSignal) {
    }
	//MediaStatusPlayStatus
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusPlayStatus(TMediaStatusPlayStatus tTxSignal) {
    }
	//MediaStatusMixState
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusMixState(TMediaStatusMixState tTxSignal) {
    }
	//MediaStatusPlaylistMode
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusPlaylistMode(TMediaStatusPlaylistMode tTxSignal) {
    }
	//MediaStatusTrackTime
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusTrackTime(TMediaStatusTrackTime tTxSignal) {
    }	
	//MediaStatusCurrTrackNum
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusCurrTrackNum(TMediaStatusCurrTrackNum tTxSignal) {
    }	
	//DeviceStatusRadioStatus
	tVoid veda_tclClientVcanCanAdaptor::vSendDeviceStatusRadioStatus(TDeviceStatusRadioStatus tTxSignal) {
    }	
	//DeviceStatusDABAvailStatus
	tVoid veda_tclClientVcanCanAdaptor::vSendDeviceStatusDABAvailStatus(TDeviceStatusDABAvailStatus tTxSignal) {
    }	
	//DeviceStatusNavData
	tVoid veda_tclClientVcanCanAdaptor::vSendDeviceStatusNavData(TDeviceStatusNavData tTxSignal) {
    }	
	//DeviceStatusUSB1Present
	tVoid veda_tclClientVcanCanAdaptor::vSendDeviceStatusUSB1Present(TDeviceStatusUSB1Present tTxSignal) {
    }
	//DeviceStatusUSB2Present
	tVoid veda_tclClientVcanCanAdaptor::vSendDeviceStatusUSB2Present(TDeviceStatusUSB2Present tTxSignal) {
    }	
	//DeviceStatusNaviAvail
	tVoid veda_tclClientVcanCanAdaptor::vSendDeviceStatusNaviAvail(TDeviceStatusNaviAvail tTxSignal) {
    }	
	//DeviceStatusUSB1Src
	tVoid veda_tclClientVcanCanAdaptor::vSendDeviceStatusUSB1Src(TDeviceStatusUSB1Src tTxSignal) {
    }	
	//DeviceStatusUSB2Src
	tVoid veda_tclClientVcanCanAdaptor::vSendDeviceStatusUSB2Src(TDeviceStatusUSB2Src tTxSignal) {
    }
	//DeviceStatusAMFMAvail
	tVoid veda_tclClientVcanCanAdaptor::vSendDeviceStatusAMFMAvail(TDeviceStatusAMFMAvail tTxSignal) {
    }
	//MediaStatusSeekStatus
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusSeekStatus(TMediaStatusSeekStatus tTxSignal) {
    }
	//MediaStatusRepeatStatus
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusRepeatStatus(TMediaStatusRepeatStatus tTxSignal) {
    }
	//MediaStatusDABFMStatus
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusDABFMStatus(TMediaStatusDABFMStatus tTxSignal) {
    }
	//VehicleNaviLatitude
	tVoid veda_tclClientVcanCanAdaptor::vSendVehicleNaviLatitude(TVehicleNaviLatitude tTxSignal) {
    }
	//VehicleNaviLongitude
	tVoid veda_tclClientVcanCanAdaptor::vSendVehicleNaviLongitude(TVehicleNaviLongitude tTxSignal) {
    }
	//MediaStatusTREGStatus
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusTREGStatus(TMediaStatusTREGStatus tTxSignal) {
    }
	//MediaStatusTREGRTMStatus
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusTREGRTMStatus(TMediaStatusTREGRTMStatus tTxSignal) {
    }
	//MediaStatusRDSStatus
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusRDSStatus(TMediaStatusRDSStatus tTxSignal) {
    }
	//MediaStatusTAStatus
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusTAStatus(TMediaStatusTAStatus tTxSignal) {
    }
	//MediaStatusTPStatus
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusTPStatus(TMediaStatusTPStatus tTxSignal) {
    }
	//MediaStatusTunerBandStatus
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusTunerBandStatus(TMediaStatusTunerBandStatus tTxSignal) {
    }
	//MediaStatusTunerPresetStatus
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusTunerPresetStatus(TMediaStatusTunerPresetStatus tTxSignal) {
    }
	//HUS_DM1_Status
	tVoid veda_tclClientVcanCanAdaptor::vSendHUS_DM1_Status(THUS_DM1_Status tTxSignal) {
    }
	tVoid veda_tclClientVcanCanAdaptor::vSendVoice_Recognition_Executing(TVoice_Recognition_Executing tTxSignal) {
        /* vSendCsmBroadcastSignal (&tTxSignal.Voice_Recognition_Executing, 1, CSM_C_ASIG_TX_Voice_Recognition_Executing, tTxSignal.u8TxType); */
    }
    tVoid veda_tclClientVcanCanAdaptor::vSendBlowerReductionRequest(TBlowerReductionRequest tTxSignal) {
        /* vSendCsmBroadcastSignal(&tTxSignal.BlowerReductionRequest, 1, CSM_C_ASIG_TX_BlowerReductionRequest, tTxSignal.u8TxType); */
    }
    tVoid veda_tclClientVcanCanAdaptor::vSendTSR_OSPActivationRequest2(TTSR_OSPActivationRequest2 tTxSignal) {
        /* vSendCsmBroadcastSignal(&tTxSignal.TSR_OSPActivationRequest2, 1, CSM_C_ASIG_TX_TSR_OSPActivationRequest2, tTxSignal.u8TxType); */
    }
    tVoid veda_tclClientVcanCanAdaptor::vSendMeterLanguageSyncMenu(TMeterLanguageSyncMenu tTxSignal) {
        /* vSendCsmBroadcastSignal(&tTxSignal.MeterLanguageSyncMenu, 1, CSM_C_ASIG_TX_MeterLanguageSyncMenu, tTxSignal.u8TxType); */
    }
    tVoid veda_tclClientVcanCanAdaptor::vSendCockpitLanguageRequest(TCockpitLanguageRequest tTxSignal) {
        /* vSendCsmBroadcastSignal(&tTxSignal.CockpitLanguageRequest, 1, CSM_C_ASIG_TX_CockpitLanguageRequest, tTxSignal.u8TxType); */
    }
    tVoid veda_tclClientVcanCanAdaptor::vSendUnitDistanceDisplayRequest(TUnitDistanceDisplayRequest tTxSignal) {
        /* vSendCsmBroadcastSignal(&tTxSignal.UnitDistanceDisplayRequest, 1, CSM_C_ASIG_TX_UnitDistanceDisplayRequest, tTxSignal.u8TxType); */
    }
    tVoid veda_tclClientVcanCanAdaptor::vSendMediaInfoToCluster(TMediaInfo tTxSignal){
    }
    tVoid veda_tclClientVcanCanAdaptor::vSendSetting_Change_Request_for_TPMS(TSetting_Change_Request_for_TPMS tTxSignal) {
        /* vSendCsmBroadcastSignal(&tTxSignal.Setting_Change_Request_for_TPMS, 1, CSM_C_ASIG_TX_Setting_Change_Request_for_TPMS, tTxSignal.u8TxType); */
    }
    tVoid veda_tclClientVcanCanAdaptor::onEveryFiveSeconds()
    {
    }
	tVoid veda_tclClientVcanCanAdaptor::vSendCabinAMeidaDataToCluster(vehicle_fi_tcl_CAN_Mesg msg)
    {
    }

// veda_tclClientVcanCanAdaptor::ClassImplementation: user specific code end

//EOF
