/*****************************************************************************
* Template:     csmAdaptor.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               DO NOT CHANGE --> 
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#define MIDW_COMMON_S_IMPORT_INTERFACE_CSM
#define CSM_C_PROJECT_USERSPACE_INF4CV
#include "midw_common_if.h"
// veda_tclClientVcanCanAdaptor::Include: user specific code start
#include "veda_config.h"
// veda_tclClientVcanCanAdaptor::Include: user specific code end

//include base class
#include "veda_AppMain.h"

#include "veda_ClientVcanInf4cvCanAdaptor.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VEHICLEDATA_CLIENT_VCAN
#include "trcGenProj/Header/veda_ClientVcanInf4cvCanAdaptor.cpp.trc.h"
#endif

veda_tclClientVcanCanAdaptor *adapterInstance = NULL;
TMediaInfo stCabinAMediaInfo;
csmState mediaCabinACsmState;
dataReqState mediaCabADataReqState;
tU8 currentCabinADataReqType;
struct sJ1939Addr
{
	tU8  uSrcNodeId;
	tU8  uTrgetNodeId;
	tU16 wPgn;

	sJ1939Addr(): uTrgetNodeId(CSM_C_J1939_NODE_ICL),
				  uSrcNodeId(CSM_C_J1939_NODE_RAD),
				  wPgn(CSM_C_J1939_PGN_MEDDATA_ICAN) {}
}abJ1939Addr;

struct sJ1939NavAddr
{
	tU8  uSrcNodeId;
	tU8  uTrgetNodeId;
	tU16 wPgn;

	sJ1939NavAddr(): uSrcNodeId(CSM_C_J1939_NODE_NAV),
					 uTrgetNodeId(CSM_C_J1939_NODE_ICL),
					 wPgn(CSM_C_J1939_PGN_NAVDATA_ICAN) {}
}abJ1939NavAddr;

struct sJ1939CabinAAddr
{
	tU8  uSrcNodeId;
	tU8  uTrgetNodeId;
	tU16 wPgn;

	sJ1939CabinAAddr(): uSrcNodeId(CSM_C_J1939_NODE_RAD),
						uTrgetNodeId(CSM_C_J1939_NODE_ICL),
						wPgn(CSM_C_J1939_PGN_CABINAMEDIADATA_ICAN) {}
}abJ1939CabAAddr;

static tCSM_J1939_APPL_CALLBACK  rPduRJ1939Callback1 =
{
  NULL,
  NULL,
 &veda_tclClientVcanCanAdaptor::CCS_J1939_vCSMMsgCon,
 &veda_tclClientVcanCanAdaptor::CCS_J1939_vCSMMsgReceived,
  NULL,
  NULL
};
static tCSM_J1939_APPL_CALLBACK  rPduRJ1939NavCallback1 =
{
  NULL,
  NULL,
 &veda_tclClientVcanCanAdaptor::CCS_J1939Nav_vCSMMsgCon,
 &veda_tclClientVcanCanAdaptor::CCS_J1939Nav_vCSMMsgReceived,
  NULL,
  NULL
};
static tCSM_J1939_APPL_CALLBACK  rPduRJ1939CabinACallback1 =
{
  NULL,
  NULL,
 &veda_tclClientVcanCanAdaptor::CCS_J1939CabinA_vCSMMsgCon,
 &veda_tclClientVcanCanAdaptor::CCS_J1939CabinA_vCSMMsgReceived,
  NULL,
  NULL
};
veda_tclClientVcanCanAdaptor* veda_tclClientVcanCanAdaptor::_pMyStaticRef = 0;

/* ---------------- */
/* public functions */
/* ---------------- */

veda_tclClientVcanCanAdaptor::veda_tclClientVcanCanAdaptor(veda_tclAppMain* poMainAppl):
I_veda_tclClientVcanCanAdaptor(poMainAppl)
{
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::veda_tclClientVcanCanAdaptor() entered."));

    _pMyStaticRef = this;
    _pCallbackIf = NULL;
    _poMyCSMInterface = NULL;
	mediaDataReqState = notreceived;
	mediaCsmState = Idle;
	naviCsmState = Idle;
	mediaCabinACsmState = Idle;
	mediaDataReqState = notreceived;
	phoneCallDataReqState = notreceived;
	phoneInfoDataReqState = notreceived;
	currentstreetDataReqState = notreceived;
	turntoStreetDataReqState = notreceived;
	destinationInfoDataReqState = notreceived;
	turntoSymbolsDataReqState = notreceived;
	laneGuidanceInfoDataReqState = notreceived;
	warningInfoDataReqState = notreceived;
	mediaCabADataReqState = notreceived;
	currentDataReqType = 0x0;
	currentCabinADataReqType = 0x0;
	currentNaviDataReqType = 0x0;
	adapterInstance = this;
    
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::value of mediaCsmState is %d",mediaCsmState));
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::value of mediaCabinACsmState is %d",mediaCabinACsmState));
//   if ( OSAL_s32TimerCreate( (OSAL_tpfCallback)_pfCallbackTimer_InputHandler, (tPVoid)this, &m_hTimerHandle_InputHandler) != OSAL_OK)
  // {
    //  ETG_TRACE_FATAL(("ERROR - Could not create InputHandler timer!"));
     // m_hTimerHandle_InputHandler = OSAL_C_INVALID_HANDLE;
  // }

    // veda_tclClientVcanCanAdaptor::veda_tclClientVcanCanAdaptor: user specific code start
    // veda_tclClientVcanCanAdaptor::veda_tclClientVcanCanAdaptor: user specific code end

    return;
}

veda_tclClientVcanCanAdaptor::~veda_tclClientVcanCanAdaptor()
{
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::~veda_tclClientVcanCanAdaptor() entered."));
    
    _pCallbackIf = OSAL_NULL;
    
    if (OSAL_NULL != _poMyCSMInterface) {
        OSAL_DELETE _poMyCSMInterface;
    }
    _poMyCSMInterface = OSAL_NULL;
}
void veda_tclClientVcanCanAdaptor::checkPendingStatus()
{
	ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::CheckPending Status Called"));
	if(getPhoneCallDataReqState() == Pending)
    {
	       SendPendingCallInfo();
	}
     if(getPhoneInfoDataReqState() == Pending)
	{
		   SendPendingPhoneInfo();
	}
    if(getMediaInfoDataReqState() == Pending)
	{
			SendPendingMediaInfo();
	}
   if(getNaviCurrentStreetInfoReqState() == Pending)
    {
		    SendPendingCurrentStreetInfo();
	}
   if(getDestinationInfoDataReqState() == Pending)
	{
	       SendPendingDestingnationInfo();
	}
    if(getTurnToSymbolsDataReqState() == Pending)
	{
		   SendPendingTurnToSymbolsInfo();
	}
    if(getNaviLaneGuidanceReqState() == Pending)
	{
          SendPendingNaviLaneGuidanceInfo();
	}
     if(getNaviTurnToStreetInfoReqState() == Pending)
	{
		 SendPendingTurnToStreetInfo();
    }
     if(getNaviWarningInfoReqState() == Pending)
	{
		 SendPendingNaviWarningInfo();
	}
      if(mediaCabADataReqState == Pending)
	{
            SendPendingCabinAMeidaDataToCluster();
	}
}
/******************************************************************************/
/* FUNCTION     _bSetTimer_InputHandler()                                     */
/******************************************************************************/
/**
*  \brief       set/reset the Input Handler general purpose timer
*               timer is used as non cyclic timer
*
*  \param       time out value
*  \return      none
*/
/******************************************************************************/
/*tBool veda_tclClientVcanCanAdaptor::_bSetTimer_InputHandler(OSAL_tMSecond msTimeout)
{
	ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::_bSetTimer_InputHandler() entered."));
    tBool bSuccess = TRUE;
    setTimerStatus(true);
    if ( OSAL_C_INVALID_HANDLE != m_hTimerHandle_InputHandler ) {
        if ( OSAL_s32TimerSetTime( m_hTimerHandle_InputHandler, msTimeout, 0 ) != OSAL_OK ) {
            bSuccess = FALSE;
			ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::Timer is not successful"));
        }
    }
    return(bSuccess);
}

/******************************************************************************/
/* FUNCTION     _pfCallbackTimer_InputHandler                                 */
/******************************************************************************/
/**
*  \brief       timer callback
*
*  \param       pointer to argument
*  \return
*/
/******************************************************************************
OSAL_tpfCallback veda_tclClientVcanCanAdaptor::_pfCallbackTimer_InputHandler(tVoid* pArg)
{
	ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::_pfCallbackTimer_InputHandler() entered."));
        adapterInstance->setTimerStatus(false);
    	           if(adapterInstance->getPhoneCallDataReqState() == Pending)
		   {
	        	adapterInstance->SendPendingCallInfo();
		   }
		   else if(adapterInstance->getPhoneInfoDataReqState() == Pending)
		   {
			adapterInstance->SendPendingPhoneInfo();
		   }
		   else if(adapterInstance->getMediaInfoDataReqState() == Pending)
		   {
			adapterInstance->SendPendingMediaInfo();
		   }
		   else if(adapterInstance->getNaviCurrentStreetInfoReqState() == Pending)
		   {
					adapterInstance->SendPendingCurrentStreetInfo();
		   }
		   else if(adapterInstance->getDestinationInfoDataReqState() == Pending)
		   {
					adapterInstance->SendPendingDestingnationInfo();
		   }
		   else if(adapterInstance->getTurnToSymbolsDataReqState() == Pending)
		   {
					adapterInstance->SendPendingTurnToSymbolsInfo();
		   }
		   else if(adapterInstance->getNaviLaneGuidanceReqState() == Pending)
		   {
					adapterInstance->SendPendingNaviLaneGuidanceInfo();
		   }
		   else if(adapterInstance->getNaviTurnToStreetInfoReqState() == Pending)
		   {
					adapterInstance->SendPendingTurnToStreetInfo();
		   }
		   else if(adapterInstance->getNaviWarningInfoReqState() == Pending)
		   {
					adapterInstance->SendPendingNaviWarningInfo();
		   }
		   else
		   {
		      //	 //Do nothing
		   }
}*/

dataReqState veda_tclClientVcanCanAdaptor::getPhoneCallDataReqState()
{
	return phoneCallDataReqState;
}
dataReqState veda_tclClientVcanCanAdaptor::getPhoneInfoDataReqState()
{
	return phoneInfoDataReqState;
}
dataReqState veda_tclClientVcanCanAdaptor::getMediaInfoDataReqState()
{
	return mediaDataReqState;
}
tVoid veda_tclClientVcanCanAdaptor::onEveryFiveSeconds()
{
   ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::On Every Five Second"));
	  if(getPhoneCallDataReqState() == Sent)
          {
	        	SendPendingCallInfo();
	  }
	  if(getPhoneInfoDataReqState() == Sent)
	   {
		SendPendingPhoneInfo();
	   }
	  if(getMediaInfoDataReqState() == Sent)
           {
		 SendPendingMediaInfo();
	   }
	  /* else if(getNaviCurrentStreetInfoReqState() == Sent)
	   {
		SendPendingCurrentStreetInfo();
	   }
	   else if(getDestinationInfoDataReqState() == Sent)
           {
	        SendPendingDestingnationInfo();
	   }
	   else if(getTurnToSymbolsDataReqState() == Sent)
           {
	        SendPendingTurnToSymbolsInfo();
	   }
	   else if(getNaviLaneGuidanceReqState() == Sent)
           {
	        SendPendingNaviLaneGuidanceInfo();
	   }
	   else  if(getNaviTurnToStreetInfoReqState() == Sent)
           {
	        SendPendingTurnToStreetInfo();
	   }
	   else if(getNaviWarningInfoReqState() == Sent)
           {
	        SendPendingNaviWarningInfo();
	   }*/
	   if(mediaCabADataReqState == Sent)
	   {
               SendPendingCabinAMeidaDataToCluster();
	   }
}

tVoid veda_tclClientVcanCanAdaptor::vHandleMessage(veda_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(veda_tclBaseIf::ECmdTypes, pMsg->eCmd), pMsg->u.u32Data));
   if (pMsg->eCmd == veda_tclBaseIf::eCmdCsmSignalReceived) {
       vSignalIndSync(pMsg->u.u32Data);
   }

   // veda_tclClientVcanCanAdaptor::vHandleMessage: user specific code start
   switch(pMsg->eCmd)
   {
   case eCmdCsmBusIndReceived:
      if (_pCallbackIf)
         _pCallbackIf->vHandleCsmFaultIndication(pMsg->u.au8Data[0], pMsg->u.au8Data[1], pMsg->u.au8Data[2]);
      break;

   case eDefaultSetting:
      if (pMsg->u.u8Data == 0x02) // if coding changed
         _vSendKDSCodingChangedInfoToCSM();
      break;

   case eLongDataTimeoutEvent:
	  checkPendingStatus();
	   break;

   default:
      break;
   }
   // veda_tclClientVcanCanAdaptor::vHandleMessage: user specific code end
}

tVoid veda_tclClientVcanCanAdaptor::vHandleTraceMessage(const tUChar* puchData)
{
   VEDA_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // veda_tclClientVcanCanAdaptor::vHandleTraceMessage: user specific code start
   // veda_tclClientVcanCanAdaptor::vHandleTraceMessage: user specific code end
}

tVoid veda_tclClientVcanCanAdaptor::vGetReferences() {
   // veda_tclClientVcanCanAdaptor::vGetReferences: user specific code start
   _poMyCSMInterface = new CSMInterface();
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
   // veda_tclClientVcanCanAdaptor::vGetReferences: user specific code end
}


tVoid veda_tclClientVcanCanAdaptor::vTraceInfo()
{
   ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vTraceInfo() entered."));
   // veda_tclClientVcanCanAdaptor::vTraceInfo: user specific code start
   // veda_tclClientVcanCanAdaptor::vTraceInfo: user specific code end

}


tVoid veda_tclClientVcanCanAdaptor::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vStartCommunication() entered."));

   // veda_tclClientVcanCanAdaptor::vStartCommunication: user specific code start
   // veda_tclClientVcanCanAdaptor::vStartCommunication: user specific code end
}


tVoid veda_tclClientVcanCanAdaptor::vConnect()
{

   tU32 u32CsmHandle;
   tU32 u32CsmNaviHandle;
   tU32 u32CsmCabinAHandle;
   ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vConnect() entered."));

   // veda_tclClientVcanCanAdaptor::vConnect: user specific code start
   VEDA_NULL_POINTER_CHECK(_pCallbackIf);
   _pCallbackIf->vHandleKDSConfigRead();
   // veda_tclClientVcanCanAdaptor::vConnect: user specific code end

   _poMyCSMInterface = new CSMInterface();
   VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);

   ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vConnect(): Install Callback now."));

   //ParkingBreakSwitch
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_ParkingBreakSwitch_CruiseControl, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_ParkingBreakSwitch_CruiseControl'."));
   }
   vReadParkingBreakSwitchValue();
      //Generic-->Time Date
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_TimeDate, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_TimeDate'."));
   }
   vReadTimeDateValue();
   //Distance Unit
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_DistanceScale_SystemEnvironment, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_DistanceScale_SystemEnvironment'."));
   }
   vReadUnitDistanceDisplayState();
    //ReverseSwitch
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_ReverseSwitch_ETC5, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_ReverseSwitch_ETC5'."));
   }
   vReadReverseValue();
   //DirectionIndicator
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_DirectionIndicator_TCO1, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_DirectionIndicator_TCO1'."));
   }
   vReadReverseValue();
  // vReadDirectionIndicatorValue();
   //RearCamReq
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_RearCamReq_SystemEnvironment, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_RearCamReq_SystemEnvironment'."));
   }
   vReadRearCamReqValue();
   // System Language
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_SystemLanguage_SystemEnvironment, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_SystemLanguage_SystemEnvironment'."));
   }
   vReadSystemLanguageValue();
   //Cam1_Req
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera1_Req_Camera_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Camera1_Req_Camera_Request'."));
   }
   vReadCam1_ReqValue();
   //Cam2_Req
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera2_Req_Camera_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Camera2_Req_Camera_Request'."));
   }
   vReadCam2_ReqValue();
   //Cam3_Req
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera3_Req_Camera_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Camera3_Req_Camera_Request'."));
   }
   vReadCam3_ReqValue();
   //Cam4_Req
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera4_Req_Camera_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Camera4_Req_Camera_Request'."));
   }
   vReadCam4_ReqValue();
   //Cam5_Req
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera5_Req_Camera_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Camera5_Req_Camera_Request'."));
   }
   vReadCam5_ReqValue();
   //Cam6_Req
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera6_Req_Camera_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Camera6_Req_Camera_Request'."));
   }
   vReadCam6_ReqValue();
   //Cam7_Req
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera7_Req_Camera_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Camera7_Req_Camera_Request'."));
   }
   vReadCam7_ReqValue();
      //Cam8_Req
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera8_Req_Camera_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Camera8_Req_Camera_Request'."));
   }
   vReadCam8_ReqValue();
    //Cam9_Req
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera9_Req_Camera_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Camera9_Req_Camera_Request'."));
   }
   vReadCam9_ReqValue();
   //Cam10_Req
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera10_Req_Camera_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Camera10_Req_Camera_Request'."));
   }
   vReadCam10_ReqValue();
      //Cam11_Req
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera11_Req_Camera_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Camera11_Req_Camera_Request'."));
   }
   vReadCam11_ReqValue();
     //Cam12_Req
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera12_Req_Camera_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Camera12_Req_Camera_Request'."));
   }
   vReadCam12_ReqValue();
    //Cam13_Req
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera13_Req_Camera_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Camera13_Req_Camera_Request'."));
   }
   vReadCam13_ReqValue();
     //Cam14_Req
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera14_Req_Camera_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Camera14_Req_Camera_Request'."));
   }
   vReadCam14_ReqValue();
        //Cam15_Req
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera15_Req_Camera_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Camera15_Req_Camera_Request'."));
   }
   vReadCam15_ReqValue();
    //Cam16_Req
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera16_Req_Camera_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Camera16_Req_Camera_Request'."));
   }
   vReadCam16_ReqValue();
       //Cam17_Req
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera17_Req_Camera_Request, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Camera17_Req_Camera_Request'."));
   }
   vReadCam17_ReqValue();
   //DateMode
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Date_Mode_SystemEnvironmentExtended, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Date_Mode_SystemEnvironmentExtended'."));
   }
   vReadDateModeValue();
    //TmMode
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Time_Mode_SystemEnvironment, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Time_Mode_SystemEnvironment'."));
   }
   vReadTmModeValue();
   //ExpectedBehaviour-->SwivMonAutoOpen
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Passenger_DOOR_Status_SystemEnvironmentExtended, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Passenger_DOOR_Status_SystemEnvironmentExtended'."));
   }
   vReadSwivMonAutoOpenValue();
   //ExpectedBehaviour-->SystemMute
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_SystemMute_SystemEnvironment, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_SystemMute_SystemEnvironment'."));
   }
   vReadMuteDevStatus();
   
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_PhoneCallCmd_MediaCommand, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_PhoneCallCmd_MediaCommand'."));
   }
   vReadPhoneCallCommandValue();
   
      if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_VolumeCmd_MediaCommand, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_VolumeCmd_MediaCommand'."));
   }
   vReadVolumeCommandValue();
   
      
      if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle,CSM_C_SIG_RX_TrackCmd_MediaCommand, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_TrackCmd_MediaCommand'."));
   }
   vReadTrackCommandValue();

      if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle,CSM_C_SIG_RX_Smartphone_Voice_Recognition_MediaCommand, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Smartphone_Voice_Recognition_MediaCommand'."));
   }
   vReadSMARTVRValue(); 
   
    if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_B_SW_Ver_MCP_Resp_DeviceInformation2, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_B_SW_Ver_MCP_Resp_DeviceInformation2'."));
   }
   vReadDeviceInfoSWversionValue();
      
      if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Voice_recognition_command_MediaCommand, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Voice_recognition_command_MediaCommand'."));
   }
   vReadVoiceRecgCommandValue();
   
         
      if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_PhonePwrCmd_MediaCommand, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_PhonePwrCmd_MediaCommand'."));
   }
   vReadPhonePwrCmdValue();
   
   
    if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_RadioPwrCmd_MediaCommand, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_RadioPwrCmd_MediaCommand'."));
   }
   vReadRadioPwrCmdValue();
   
     
    if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Button_Next_RemoteControl, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Button_Next_RemoteControl'."));
   }
   vReadRCNextBtnValue();
   
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Button_Previous_RemoteControl, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Button_Previous_RemoteControl'."));
   }
   vReadRCPrevBtnValue();
   
         if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_SourceCmd_MediaCommand, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_SourceCmd_MediaCommand'."));
   }
   vReadSourceCommandValue();
   
    if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Cabin_Source_Command_CabinMediaCommand, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Cabin_Source_Command_CabinMediaCommand'."));
   }
   vReadCabinSourceCommandValue(); 
   
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Cabin_Volume_Command_CabinMediaCommand, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Cabin_Volume_Command_CabinMediaCommand'."));
   }
   vReadCabinVolumeCommandValue();
   
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Cabin_Tuner_Command_CabinMediaCommand, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Cabin_Tuner_Command_CabinMediaCommand'."));
   }
   vReadCabinTunerCommandValue();
    
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Cabin_TrackCommand_CabinMediaCommand, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Cabin_TrackCommand_CabinMediaCommand'."));
   }
   vReadCabinTrackCommandValue();
       
   if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_CabinPlaylistCmd_CabinMediaCommand, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_CabinPlaylistCmd_CabinMediaCommand'."));
   }
   vReadCabinPlaylistCommandValue();
   
    if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_TunerCmd_MediaCommand, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_TunerCmd_MediaCommand'."));
   }
   vReadTunerCommandValue();
    if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_TAcmd_MediaCommand, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_TAcmd_MediaCommand'."));
   }
   vReadTACommandValue();
    if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_RDScmd_MediaCommand, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_RDScmd_MediaCommand'."));
   }
   vReadRDSCommandValue();

    if (_poMyCSMInterface->CSM_lSignalCallbackInit( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Driver_DOORStatus_SystemEnvironmentExtended, vSignalIndCallback) < CSM_C_NO_ERROR){
       ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vConnect(): Cannot register to ' CSM_C_SIG_RX_Driver_DOORStatus_SystemEnvironmentExtended'."));
   }
   vReadDriverDoorStatusValue();


    // Protocol Type J1939
  _poMyCSMInterface->CSM_lApplCallbackInit(u32CsmHandle,CSM_C_PTYPE_J1939,&abJ1939Addr, &rPduRJ1939Callback1);

  _poMyCSMInterface->CSM_lApplCallbackInit(u32CsmNaviHandle,CSM_C_PTYPE_J1939,&abJ1939NavAddr, &rPduRJ1939NavCallback1);

   _poMyCSMInterface->CSM_lApplCallbackInit(u32CsmCabinAHandle,CSM_C_PTYPE_J1939,&abJ1939CabAAddr, &rPduRJ1939CabinACallback1);

 
}

tVoid veda_tclClientVcanCanAdaptor::vSignalIndCallback(tVoid* pHandle, tU32 u32SignalId, tU32 u32SignalStatus)
{
    // lint
    (tVoid)pHandle;
    (tVoid)u32SignalStatus;

     veda_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));

     oMsg.eCmd = veda_tclBaseIf::eCmdCsmSignalReceived;
     OSAL_szStringNCopy(oMsg.strClassName, "veda_tclClientVcanCanAdaptor", strlen("veda_tclClientVcanCanAdaptor "));
     oMsg.u.u32Data = u32SignalId;

     _pMyStaticRef->_cpoMain->theServer()->vPostInternalMessage(&oMsg);

}

tVoid veda_tclClientVcanCanAdaptor::vSignalIndSync(tU32 u32SignalId)
{
    /* Check which signal is changed ! */
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vSignalInd(): Signal Indication received: ID 0x%08x", u32SignalId));

    switch(u32SignalId)
    {
	case CSM_C_SIG_RX_VehicleSpeed_CruiseControl:
        vReadVehicleSpeed();
        break;
	//TCOVehiclespeed
	case CSM_C_SIG_RX_TCOVehSpeed_TCO1:
        vReadTCOVehicleSpeed();
        break;
	//ParkingBreakSwitch
	case CSM_C_SIG_RX_ParkingBreakSwitch_CruiseControl:
        vReadParkingBreakSwitchValue();
        break;
    //Generic clock
		case CSM_C_SIG_RX_TimeDate:
		vReadTimeDateValue();
		break;
	case CSM_C_SIG_RX_DistanceScale_SystemEnvironment:
		vReadUnitDistanceDisplayState();
		break;
	//ReverseSwitch
	case CSM_C_SIG_RX_ReverseSwitch_ETC5:
        vReadReverseValue();
		break;
	//DirectionIndicator
	case CSM_C_SIG_RX_DirectionIndicator_TCO1:
       vReadReverseValue();
	   // vReadDirectionIndicatorValue();
		break;
	//RearCamReq
	case CSM_C_SIG_RX_RearCamReq_SystemEnvironment:
        vReadRearCamReqValue();
        break;
	//System Language
	case CSM_C_SIG_RX_SystemLanguage_SystemEnvironment:
		vReadSystemLanguageValue();
		break;
	//Cam1_Req
	case CSM_C_SIG_RX_Camera1_Req_Camera_Request:
		vReadCam1_ReqValue();
		break;
	//Cam2_Req
	case CSM_C_SIG_RX_Camera2_Req_Camera_Request:
		vReadCam2_ReqValue();
		break;
	//Cam3_Req
	case CSM_C_SIG_RX_Camera3_Req_Camera_Request:
		vReadCam3_ReqValue();
		break;
	//Cam4_Req
	case CSM_C_SIG_RX_Camera4_Req_Camera_Request:
		vReadCam4_ReqValue();
		break;
	//Cam5_Req
	case CSM_C_SIG_RX_Camera5_Req_Camera_Request:
		vReadCam5_ReqValue();
		break;
	//Cam6_Req
	case CSM_C_SIG_RX_Camera6_Req_Camera_Request:
		vReadCam6_ReqValue();
		break;
	//Cam7_Req
	case CSM_C_SIG_RX_Camera7_Req_Camera_Request:
		vReadCam7_ReqValue();
		break;
	//Cam8_Req
	case CSM_C_SIG_RX_Camera8_Req_Camera_Request:
		vReadCam8_ReqValue();
		break;
	//Cam9_Req
	case CSM_C_SIG_RX_Camera9_Req_Camera_Request:
		vReadCam9_ReqValue();
		break;
	//Cam10_Req
	case CSM_C_SIG_RX_Camera10_Req_Camera_Request:
		vReadCam10_ReqValue();
		break;
	//Cam11_Req
	case CSM_C_SIG_RX_Camera11_Req_Camera_Request:
		vReadCam11_ReqValue();
		break;
	//Cam12_Req
	case CSM_C_SIG_RX_Camera12_Req_Camera_Request:
		vReadCam12_ReqValue();
		break;
	//Cam13_Req
	case CSM_C_SIG_RX_Camera13_Req_Camera_Request:
		vReadCam13_ReqValue();
		break;
		//Cam14_Req
	case CSM_C_SIG_RX_Camera14_Req_Camera_Request:
		vReadCam14_ReqValue();
		break;
	//Cam15_Req
	case CSM_C_SIG_RX_Camera15_Req_Camera_Request:
		vReadCam15_ReqValue();
		break;
	//Cam16_Req
	case CSM_C_SIG_RX_Camera16_Req_Camera_Request:
		vReadCam16_ReqValue();
		break;
	//Cam17_Req
	case CSM_C_SIG_RX_Camera17_Req_Camera_Request:
		vReadCam17_ReqValue();
		break;
	//DateMode
	case CSM_C_SIG_RX_Date_Mode_SystemEnvironmentExtended:
        vReadDateModeValue();
		break;
		//TmMode
	case CSM_C_SIG_RX_Time_Mode_SystemEnvironment:
        vReadTmModeValue();
		break;
	//ExpectedBehaviour-->SwivMonAutoOpen
	case CSM_C_SIG_RX_Passenger_DOOR_Status_SystemEnvironmentExtended:
        vReadSwivMonAutoOpenValue();
		break;
	//SystemMute
	case CSM_C_SIG_RX_SystemMute_SystemEnvironment:
		vReadMuteDevStatus();
		break;
	case CSM_C_SIG_RX_PhoneCallCmd_MediaCommand:
		vReadPhoneCallCommandValue();
		break;
	case CSM_C_SIG_RX_VolumeCmd_MediaCommand:
		vReadVolumeCommandValue();
		break;
	case CSM_C_SIG_RX_TrackCmd_MediaCommand:
		vReadTrackCommandValue();
		break;
	case CSM_C_SIG_RX_Smartphone_Voice_Recognition_MediaCommand:
		vReadSMARTVRValue();
		break;
	 case CSM_C_SIG_RX_Voice_recognition_command_MediaCommand:
		 vReadVoiceRecgCommandValue();
		 break;	
	case CSM_C_SIG_RX_B_SW_Ver_MCP_Resp_DeviceInformation2:
		vReadDeviceInfoSWversionValue();
		break;	
	case CSM_C_SIG_RX_PhonePwrCmd_MediaCommand:
		vReadPhonePwrCmdValue();
		break;	
	case CSM_C_SIG_RX_RadioPwrCmd_MediaCommand:
		vReadRadioPwrCmdValue();
		break;
	case CSM_C_SIG_RX_Button_Next_RemoteControl:
		vReadRCNextBtnValue();
		break;
	case CSM_C_SIG_RX_Button_Previous_RemoteControl:
		vReadRCPrevBtnValue();
		break;
	case CSM_C_SIG_RX_SourceCmd_MediaCommand:
		vReadSourceCommandValue();	
		break;
	case CSM_C_SIG_RX_Cabin_Source_Command_CabinMediaCommand:
		vReadCabinSourceCommandValue();
		break;	
	case CSM_C_SIG_RX_Cabin_Volume_Command_CabinMediaCommand:
		vReadCabinVolumeCommandValue();
		break;	
	case CSM_C_SIG_RX_Cabin_Tuner_Command_CabinMediaCommand:
		vReadCabinTunerCommandValue();
		break;	
	case CSM_C_SIG_RX_Cabin_TrackCommand_CabinMediaCommand:
		vReadCabinTrackCommandValue();
		break;	
	case CSM_C_SIG_RX_CabinPlaylistCmd_CabinMediaCommand:
		vReadCabinPlaylistCommandValue();
		break;
	case CSM_C_SIG_RX_TunerCmd_MediaCommand:
		vReadTunerCommandValue();
		break;	
	case CSM_C_SIG_RX_TAcmd_MediaCommand:
		vReadTACommandValue();
		break;		
	case CSM_C_SIG_RX_RDScmd_MediaCommand:
		vReadRDSCommandValue();
		break;
	case CSM_C_SIG_RX_Driver_DOORStatus_SystemEnvironmentExtended:
		vReadDriverDoorStatusValue();
		break;	
    default:
        break;
    }
}

//Driver Door open status
tVoid veda_tclClientVcanCanAdaptor::vReadDriverDoorStatusValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadDriverDoorStatusValue(): Called!"));
	tU8  au8Data_ReadBuffer;
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;

	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Driver_DOORStatus_SystemEnvironmentExtended, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadDriverDoorStatusValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadDriverDoorStatusValue(): called %d",au8Data_ReadBuffer ));

	if(_tDriverDoorstatusCmdValue.u32Status != u32StatusRead) {
        _tDriverDoorstatusCmdValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tDriverDoorstatusCmdValue.DriverDoorstatusCmdValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tDriverDoorstatusCmdValue.DriverDoorstatusCmdValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadDriverDoorStatusValue(): Called!"));
         _pCallbackIf->onVehicleDriverDoorOpenStatus(_tDriverDoorstatusCmdValue);
    }

}

/* ------------------------------------------------------------------------- */
tVoid veda_tclClientVcanCanAdaptor::vSendCsmBroadcastSignal(tU8* pabData, tU8 u8Len, tU32 u32CsmSignal, tU8 u8TxType)
/*!
* \fn
*  \brief
*  
*  \param
*
*  \return
*
*  \note
*  \bug
*    no bugs known
*  \todo
*    nothing left
*  \version
*    1.0   - Initial
******
*/
{

    tU32 u32CsmHandle;
    tS32 s32Ret;

    // veda_tclClientVcanCanAdaptor_vSendCsmBroadcastSignal: user specific code start
    // veda_tclClientVcanCanAdaptor_vSendCsmBroadcastSignal: user specific code end

    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);

    s32Ret = _poMyCSMInterface->CSM_lSignalWrite((tVoid *)&u32CsmHandle,u32CsmSignal,
        pabData,
        u8Len,
        u8TxType);

    if(CSM_C_NO_ERROR > s32Ret) {
        ETG_TRACE_ERR(("veda_tclClientVcanCanAdaptor::vSendCsmBroadcastSignal(): !!!!!! Error detected !!!!!!"));
    }

    return;

}

tVoid veda_tclClientVcanCanAdaptor::vReadSpeed_Limit_Display_Request()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSpeed_Limit_Display_Request(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    /* if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_Speed_Limit_Display_Request,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }
 */
    if(_tSpeed_Limit_Display_Request.u32Status != u32StatusRead) {
        _tSpeed_Limit_Display_Request.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

//CID: 172321
/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tSpeed_Limit_Display_Request.Speed_Limit_Display_Request, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tSpeed_Limit_Display_Request.Speed_Limit_Display_Request, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSpeed_Limit_Display_Request(): Called!"));
        _pCallbackIf->onSpeed_Limit_Display_RequestStatus(_tSpeed_Limit_Display_Request);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadNavi_display_speed_limit_1()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadNavi_display_speed_limit_1(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

 /*    if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_Navi_display_speed_limit_1,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tNavi_display_speed_limit_1.u32Status != u32StatusRead) {
        _tNavi_display_speed_limit_1.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	//CID: 172306

	/*

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tNavi_display_speed_limit_1.Navi_display_speed_limit_1, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tNavi_display_speed_limit_1.Navi_display_speed_limit_1, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
	*/

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadNavi_display_speed_limit_1(): Called!"));
        _pCallbackIf->onNavi_display_speed_limit_1Status(_tNavi_display_speed_limit_1);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadNavi_display_speed_limit_2()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadNavi_display_speed_limit_2(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

  /*   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_Navi_display_speed_limit_2,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tNavi_display_speed_limit_2.u32Status != u32StatusRead) {
        _tNavi_display_speed_limit_2.u32Status = u32StatusRead;
        bChanged = TRUE;
    }


//CID: 172291

/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tNavi_display_speed_limit_2.Navi_display_speed_limit_2, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tNavi_display_speed_limit_2.Navi_display_speed_limit_2, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadNavi_display_speed_limit_2(): Called!"));
        _pCallbackIf->onNavi_display_speed_limit_2Status(_tNavi_display_speed_limit_2);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadIgnitionSupplyConfirmation()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadIgnitionSupplyConfirmation(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;
//PIYUSH
   /* if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_IgnSw_Stat_SCA_SCA_C2,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tIgnitionSupplyConfirmation.u32Status != u32StatusRead) {
        _tIgnitionSupplyConfirmation.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	
	//CID: 172280

	/*

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tIgnitionSupplyConfirmation.IgnitionSupplyConfirmation, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tIgnitionSupplyConfirmation.IgnitionSupplyConfirmation, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadIgnitionSupplyConfirmation(): Called!"));
        _pCallbackIf->onIgnitionSupplyConfirmationStatus(_tIgnitionSupplyConfirmation);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadVehicleSpeed()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadVehicleSpeed(): Called!"));
    tU16  u16DataReadBuffer;
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
	tU16 u16CalcSpeed;
	

    tBool bChanged = FALSE;
    
   
   if ((_tTCOVehicleSpeed.u32Status & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {

   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_VehicleSpeed_CruiseControl, &u16DataReadBuffer,2,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }
 
    if(_tVehicleSpeed.u32Status != u32StatusRead) {
        _tVehicleSpeed.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
		u16CalcSpeed = (u16DataReadBuffer * 100) >> 8;
		if(memcmp(&_tVehicleSpeed.VehicleSpeed[0], &u16CalcSpeed, 2) != 0) {
            memcpy(&_tVehicleSpeed.VehicleSpeed[0], &u16CalcSpeed, 2);
            bChanged = TRUE;
        }
    }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadVehicleSpeed(): Called!"));
        _pCallbackIf->onVehicleSpeedStatus(_tVehicleSpeed);
    }
    }
}
//TCOVehiclespeed
tVoid veda_tclClientVcanCanAdaptor::vReadTCOVehicleSpeed()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadTCOVehicleSpeed(): Called!"));
    tU16  au16Data_ReadBuffer;
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
	tU16 u16CalcSpeed;

    tBool bChanged = FALSE;

   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_TCOVehSpeed_TCO1, &au16Data_ReadBuffer,2,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }
 
    if(_tTCOVehicleSpeed.u32Status != u32StatusRead) {
        _tTCOVehicleSpeed.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        u16CalcSpeed = (au16Data_ReadBuffer * 100) >> 8;
		if(memcmp(&_tTCOVehicleSpeed.TCOVehicleSpeed[0], &u16CalcSpeed, 2) != 0) {
            memcpy(&_tTCOVehicleSpeed.TCOVehicleSpeed[0], &u16CalcSpeed, 2);
            bChanged = TRUE;
        }
    }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadTCOVehicleSpeed(): Called!"));
        _pCallbackIf->onTCOVehicleSpeedStatus(_tTCOVehicleSpeed);
    }
}
//piyush-->PartialMute
tVoid veda_tclClientVcanCanAdaptor::vReadPartialMuteValue()
{
	VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadPartialMuteValue(): Called!"));
    tU8  au8Data_ReadBuffer[2];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;
	/*if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_SystemMute_SystemEnvironment, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }*/
	if(_tPartialMuteValue.u32Status != u32StatusRead) {
        _tPartialMuteValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	
	//CID:465576
	/*
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tPartialMuteValue.PartialMuteValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tPartialMuteValue.PartialMuteValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }
	*/

    if ((bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadPartialMuteValue(): Called!"));
        _pCallbackIf-> onVehiclePartialMuteStatus(_tPartialMuteValue);
    }
}
//ParkingBreakSwitch
tVoid veda_tclClientVcanCanAdaptor::vReadParkingBreakSwitchValue()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadParkingBreakSwitchValue(): Called!"));
    tU8  au8Data_ReadBuffer;
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_ParkingBreakSwitch_CruiseControl, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }
 
    if(_tParkingBreakSwitchValue.u32Status != u32StatusRead) {
        _tParkingBreakSwitchValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tParkingBreakSwitchValue.ParkingBreakSwitchValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tParkingBreakSwitchValue.ParkingBreakSwitchValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadParkingBreakSwitchValue(): Called!"));
        _pCallbackIf->onVehicleParkingBreakSwitchStatus(_tParkingBreakSwitchValue);
    }
}

//Reading the current Date Time  value
tVoid veda_tclClientVcanCanAdaptor::vReadTimeDateValue()
{
	VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadTimeDateValue(): Called!"));
    tU64  au8Data_ReadBuffer; //// TIME
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
	tU8 temp;
   tBool bChanged = FALSE;
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_TimeDate, &au8Data_ReadBuffer,8,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadTimeDateValue(),CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadTimeDateValue() low : called %d",au8Data_ReadBuffer));
	ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadTimeDateValue() high : called %d",(au8Data_ReadBuffer >> 32)));
	

	if(_tTimeDateValue.u32Status != u32StatusRead) {
        _tTimeDateValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tTimeDateValue.TimeDateValue, &au8Data_ReadBuffer, 8) != 0) {
            memcpy(&_tTimeDateValue.TimeDateValue, &au8Data_ReadBuffer, 8);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadTimeDateValue(): Called!"));
        _pCallbackIf-> onTimeDateStatus(_tTimeDateValue);
    }
}

//Distance Unit
tVoid veda_tclClientVcanCanAdaptor::vReadUnitDistanceDisplayState()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadUnitDistanceDisplayState(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_DistanceScale_SystemEnvironment,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } 

    if(_tUnitDistanceDisplayState.u32Status != u32StatusRead) {
        _tUnitDistanceDisplayState.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tUnitDistanceDisplayState.UnitDistanceDisplayState, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tUnitDistanceDisplayState.UnitDistanceDisplayState, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadUnitDistanceDisplayState(): Called!"));
        _pCallbackIf->onUnitDistanceDisplayStateStatus(_tUnitDistanceDisplayState);
    }
}

//ReverseSwitch
tVoid veda_tclClientVcanCanAdaptor::vReadReverseValue()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadReversValue(): for reverse switch Called!"));
	ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadReverseValue(): for direction indication Called!"));
    tU8  au8Data_ReadBuffer_reverse;
	tU8  au8Data_ReadBuffer_DirectionInd;
    tU32 u32StatusRead      	= CSM_C_SIGNAL_DATA_INVALID;
	tU32 u32PrevStatusRead   	 = _tRearGearEngaged.u32Status;
    tU32 u32CsmHandle;
	tU8 RearGear;
	tBool bChanged = FALSE;
	
   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_ReverseSwitch_ETC5, &au8Data_ReadBuffer_reverse,1,
        &u32StatusRead))
    {
        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }	
	if(_tReverseSwitch.u32Status != u32StatusRead) {
        _tReverseSwitch.u32Status = u32StatusRead;
    } 
      
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_DirectionIndicator_TCO1, &au8Data_ReadBuffer_DirectionInd,1,
        &u32StatusRead))
    {
        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }	
	if(_tDirectionIndication.u32Status != u32StatusRead) {
        _tDirectionIndication.u32Status = u32StatusRead;
    }
	
	
	if((0 == (_tReverseSwitch.u32Status & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) ||
	(0 == (_tDirectionIndication.u32Status & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))))
	{
		_tRearGearEngaged.u32Status=CSM_C_SIGNAL_ARRIVED;			
	}
	else
	{
		_tRearGearEngaged.u32Status=CSM_C_SIGNAL_DATA_INVALID;
	}
		
	
	if(u32PrevStatusRead !=_tRearGearEngaged.u32Status)
	{
		bChanged = TRUE;
	}
		
		
		
	if(memcmp(&_tReverseSwitch.RearGearEngaged, &au8Data_ReadBuffer_reverse, 1) != 0) {
		   memcpy(&_tReverseSwitch.RearGearEngaged, &au8Data_ReadBuffer_reverse, 1);
        }
		
  if(memcmp(&_tDirectionIndication.RearGearEngaged, &au8Data_ReadBuffer_DirectionInd, 1) != 0) {
		  memcpy(&_tDirectionIndication.RearGearEngaged, &au8Data_ReadBuffer_DirectionInd, 1);
       }
	   
	   
	   
	if((_tReverseSwitch.RearGearEngaged==0x01) || (_tDirectionIndication.RearGearEngaged==0x01))
	{
		RearGear=0x01;
	}
	else{
		RearGear=0x00;
	}
	  

	  
	if(0 == (_tRearGearEngaged.u32Status & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED)))  
	{
		if(RearGear!= _tRearGearEngaged.RearGearEngaged)
		{
			_tRearGearEngaged.RearGearEngaged=RearGear;
			bChanged = TRUE;
		}
	}
	   
	if ((bChanged) && (_pCallbackIf))
	{
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadReverseValue(): Called!"));
        _pCallbackIf->onRearGearEngagedStatus(_tRearGearEngaged);
    }
	  
	   
	
	
}


//RearCamReq
tVoid veda_tclClientVcanCanAdaptor::vReadRearCamReqValue()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadRearCamReqValue(): Called!"));
    tU8  au8Data_ReadBuffer;
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_RearCamReq_SystemEnvironment, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }
 
    if(_tRearCamReqValue.u32Status != u32StatusRead) {
        _tRearCamReqValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tRearCamReqValue.RearCamReqValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tRearCamReqValue.RearCamReqValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadRearCamReqValue(): Called!"));
        _pCallbackIf->onVehicleRearCamReqStatus(_tRearCamReqValue);
    }
}
//System Language
tVoid veda_tclClientVcanCanAdaptor::vReadSystemLanguageValue()
{
	VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSystemLanguageValue(): Called!"));
	tU16  au16Data_ReadBuffer;
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

   tBool bChanged = FALSE;
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_SystemLanguage_SystemEnvironment, &au16Data_ReadBuffer,2,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSystemLanguageValue(),CSM_C_SIGNAL_DATA_INVALID"));
    }
	ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSystemLanguageValue(): called %x",au16Data_ReadBuffer));
	
	if(_tSystemLanguageValue.u32Status != u32StatusRead) {
        _tSystemLanguageValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED)))
		{
			if(memcmp(&_tSystemLanguageValue.SystemLanguageValue, &au16Data_ReadBuffer, 2) != 0) 
			{
				
				memcpy(&_tSystemLanguageValue.SystemLanguageValue, &au16Data_ReadBuffer, 2);
				bChanged = TRUE;
			}
    }
    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSystemLanguageValue(): Called!"));
        _pCallbackIf-> onVehicleSystemLanguageStatus(_tSystemLanguageValue);
    }
}
//Cam1_Req
tVoid veda_tclClientVcanCanAdaptor::vReadCam1_ReqValue()
{
	VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam1_ReqValue(): Called!"));
    tU8  au8Data_ReadBuffer;
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera1_Req_Camera_Request, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }
 
    if(_tActCam1Value.u32Status != u32StatusRead) {
        _tActCam1Value.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tActCam1Value.ActCam1Value, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tActCam1Value.ActCam1Value, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam1_ReqValue(): Called!"));
        _pCallbackIf->onVehicleActCam1Status(_tActCam1Value);
    }
}
//Cam2_Req
tVoid veda_tclClientVcanCanAdaptor::vReadCam2_ReqValue()
{
	VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam2_ReqValue(): Called!"));
    tU8  au8Data_ReadBuffer;
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera2_Req_Camera_Request, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }
 
    if(_tActCam2Value.u32Status != u32StatusRead) {
        _tActCam2Value.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tActCam2Value.ActCam2Value, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tActCam2Value.ActCam2Value, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam2_ReqValue(): Called!"));
        _pCallbackIf->onVehicleActCam2Status(_tActCam2Value);
    }
}
//Cam3_Req
tVoid veda_tclClientVcanCanAdaptor::vReadCam3_ReqValue()
{
	VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam3_ReqValue(): Called!"));
    tU8  au8Data_ReadBuffer;
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera3_Req_Camera_Request, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }
 
    if(_tActCam3Value.u32Status != u32StatusRead) {
        _tActCam3Value.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tActCam3Value.ActCam3Value, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tActCam3Value.ActCam3Value, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam3_ReqValue(): Called!"));
        _pCallbackIf->onVehicleActCam3Status(_tActCam3Value);
    }
}
//Cam4_Req
tVoid veda_tclClientVcanCanAdaptor::vReadCam4_ReqValue()
{
	VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam4_ReqValue(): Called!"));
    tU8  au8Data_ReadBuffer;
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera4_Req_Camera_Request, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }
 
    if(_tActCam4Value.u32Status != u32StatusRead) {
        _tActCam4Value.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tActCam4Value.ActCam4Value, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tActCam4Value.ActCam4Value, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam4_ReqValue(): Called!"));
        _pCallbackIf->onVehicleActCam4Status(_tActCam4Value);
    }
}
//Cam5_Req
tVoid veda_tclClientVcanCanAdaptor::vReadCam5_ReqValue()
{
	VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam5_ReqValue(): Called!"));
    tU8  au8Data_ReadBuffer;
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera5_Req_Camera_Request, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }
 
    if(_tActCam5Value.u32Status != u32StatusRead) {
        _tActCam5Value.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tActCam5Value.ActCam5Value, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tActCam5Value.ActCam5Value, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam5_ReqValue(): Called!"));
        _pCallbackIf->onVehicleActCam5Status(_tActCam5Value);
    }
}
//Cam6_Req
tVoid veda_tclClientVcanCanAdaptor::vReadCam6_ReqValue()
{
	VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam6_ReqValue(): Called!"));
    tU8  au8Data_ReadBuffer;
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera6_Req_Camera_Request, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }
 
    if(_tActCam6Value.u32Status != u32StatusRead) {
        _tActCam6Value.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tActCam6Value.ActCam6Value, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tActCam6Value.ActCam6Value, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam6_ReqValue(): Called!"));
        _pCallbackIf->onVehicleActCam6Status(_tActCam6Value);
    }
}
//Cam7_Req
tVoid veda_tclClientVcanCanAdaptor::vReadCam7_ReqValue()
{
	VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam7_ReqValue(): Called!"));
    tU8  au8Data_ReadBuffer;
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera7_Req_Camera_Request, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }
 
    if(_tActCam7Value.u32Status != u32StatusRead) {
        _tActCam7Value.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tActCam7Value.ActCam7Value, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tActCam7Value.ActCam7Value, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam7_ReqValue(): Called!"));
        _pCallbackIf->onVehicleActCam7Status(_tActCam7Value);
    }
}
//Reading the current Date Mode value
tVoid veda_tclClientVcanCanAdaptor::vReadDateModeValue()
{
	VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadDateModeValue(): Called!"));
    tU8  au8Data_ReadBuffer;
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

   tBool bChanged = FALSE;
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Date_Mode_SystemEnvironmentExtended, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadDateModeValue(),CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tDateModeValue.u32Status != u32StatusRead) {
        _tDateModeValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tDateModeValue.DateModeValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tDateModeValue.DateModeValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadDateModeValue(): Called!"));
        _pCallbackIf-> onVehicleDateModeStatus(_tDateModeValue);
    }
}

//Reading the current Time Mode value
tVoid veda_tclClientVcanCanAdaptor::vReadTmModeValue()
{
	VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadTmModeValue(): Called!"));
    tU8  au8Data_ReadBuffer;
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

   tBool bChanged = FALSE;
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Time_Mode_SystemEnvironment, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadTmModeValue(),CSM_C_SIGNAL_DATA_INVALID "));
    }
	ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadTmModeValue(): called %d",au8Data_ReadBuffer ));
	
	if(_tTmModeValue.u32Status != u32StatusRead) {
        _tTmModeValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tTmModeValue.TmModeValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tTmModeValue.TmModeValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadTmModeValue(): Called!"));
        _pCallbackIf-> onVehicleTmModeStatus(_tTmModeValue);
    }
}
//SwivMonAutoOpen
tVoid veda_tclClientVcanCanAdaptor::vReadSwivMonAutoOpenValue()
{
	VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSwivMonAutoOpenValue(): Called!"));
    tU8  au8Data_ReadBuffer;
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

   tBool bChanged = FALSE;
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Passenger_DOOR_Status_SystemEnvironmentExtended, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSwivMonAutoOpenValue(),CSM_C_SIGNAL_DATA_INVALID "));
    }
	ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSwivMonAutoOpenValue(): called %d",au8Data_ReadBuffer ));
	
	if(_tSwivMonAutoOpenValue.u32Status != u32StatusRead) {
        _tSwivMonAutoOpenValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tSwivMonAutoOpenValue.SwivMonAutoOpenValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tSwivMonAutoOpenValue.SwivMonAutoOpenValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSwivMonAutoOpenValue(): Called!"));
        _pCallbackIf-> onVehicleSwivMonAutoOpenStatus(_tSwivMonAutoOpenValue);
    }
}
//SystemMute
tVoid veda_tclClientVcanCanAdaptor::vReadMuteDevStatus()
{
	VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadMuteDevStatus(): Called!"));
    tU8  au8Data_ReadBuffer;
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

   tBool bChanged = FALSE;
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_SystemMute_SystemEnvironment, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadMuteDevStatus,CSM_C_SIGNAL_DATA_INVALID "));
    }
	ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadMuteDevStatus: called %d",au8Data_ReadBuffer ));
	
	if(_tMuteDevStatus.u32Status != u32StatusRead) {
        _tMuteDevStatus.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tMuteDevStatus.MuteDevStatus, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tMuteDevStatus.MuteDevStatus, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadMuteDevStatus(): Called!"));
        _pCallbackIf-> onVehicleMuteDevStatus(_tMuteDevStatus);
    }
}


tVoid veda_tclClientVcanCanAdaptor::vReadPhoneCallCommandValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadPhoneCallCommandValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_PhoneCallCmd_MediaCommand, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadPhoneCallCommandValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tPhoneCallCommandStatus.u32Status != u32StatusRead) {
        _tPhoneCallCommandStatus.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tPhoneCallCommandStatus.PhoneCallCmdValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tPhoneCallCommandStatus.PhoneCallCmdValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadPhoneCallCommandValue(): Called!"));
        _pCallbackIf->onPhoneCallCommandStatus(_tPhoneCallCommandStatus);
    }
		
}


tVoid veda_tclClientVcanCanAdaptor::vReadRCNextBtnValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadRCNextBtnValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Button_Next_RemoteControl, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadRCNextBtnValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tRCNextBtnValue.u32Status != u32StatusRead) {
        _tRCNextBtnValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tRCNextBtnValue.RCNextBtnValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tRCNextBtnValue.RCNextBtnValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadRCNextBtnValue(): Called!"));
        _pCallbackIf->onRCNextBtnStatus(_tRCNextBtnValue);
    }
		
}

tVoid veda_tclClientVcanCanAdaptor::vReadRCPrevBtnValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadRCPrevBtnValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Button_Previous_RemoteControl, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadRCPrevBtnValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tRCPrevBtnValue.u32Status != u32StatusRead) {
        _tRCPrevBtnValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tRCPrevBtnValue.RCPrevBtnValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tRCPrevBtnValue.RCPrevBtnValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadRCPrevBtnValue(): Called!"));
        _pCallbackIf->onRCPrevBtnStatus(_tRCPrevBtnValue);
    }
		
}







tVoid veda_tclClientVcanCanAdaptor::vReadVolumeCommandValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadVolumeCommandValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_VolumeCmd_MediaCommand, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadVolumeCommandValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tVolumeCommandValue.u32Status != u32StatusRead) {
        _tVolumeCommandValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tVolumeCommandValue.VolumeCmdValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tVolumeCommandValue.VolumeCmdValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadVolumeCommandValue(): Called!"));
        _pCallbackIf->onVolumeCommandStatus(_tVolumeCommandValue);
    }
		
}


tVoid veda_tclClientVcanCanAdaptor::vReadCam8_ReqValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam8_ReqValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera8_Req_Camera_Request, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam8_ReqValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tActCam8Value.u32Status != u32StatusRead) {
        _tActCam8Value.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tActCam8Value.ActCam8Value, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tActCam8Value.ActCam8Value, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam8_ReqValue(): Called!"));
        _pCallbackIf->onActCam8Status(_tActCam8Value);
    }
		
}



tVoid veda_tclClientVcanCanAdaptor::vReadCam9_ReqValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam9_ReqValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera9_Req_Camera_Request, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam9_ReqValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tActCam9Value.u32Status != u32StatusRead) {
        _tActCam9Value.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tActCam9Value.ActCam9Value, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tActCam9Value.ActCam9Value, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam9_ReqValue(): Called!"));
        _pCallbackIf->onActCam9Status(_tActCam9Value);
    }
		
}



tVoid veda_tclClientVcanCanAdaptor::vReadCam10_ReqValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam10_ReqValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera10_Req_Camera_Request, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam10_ReqValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tActCam10Value.u32Status != u32StatusRead) {
        _tActCam10Value.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tActCam10Value.ActCam10Value, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tActCam10Value.ActCam10Value, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam10_ReqValue(): Called!"));
        _pCallbackIf->onActCam10Status(_tActCam10Value);
    }
		
}


tVoid veda_tclClientVcanCanAdaptor::vReadCam11_ReqValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam11_ReqValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera11_Req_Camera_Request, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam11_ReqValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tActCam11Value.u32Status != u32StatusRead) {
        _tActCam11Value.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tActCam11Value.ActCam11Value, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tActCam11Value.ActCam11Value, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam11_ReqValue(): Called!"));
        _pCallbackIf->onActCam11Status(_tActCam11Value);
    }
		
}


tVoid veda_tclClientVcanCanAdaptor::vReadCam12_ReqValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam12_ReqValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera12_Req_Camera_Request, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam12_ReqValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tActCam12Value.u32Status != u32StatusRead) {
        _tActCam12Value.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tActCam12Value.ActCam12Value, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tActCam12Value.ActCam12Value, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam12_ReqValue(): Called!"));
        _pCallbackIf->onActCam12Status(_tActCam12Value);
    }
		
}


tVoid veda_tclClientVcanCanAdaptor::vReadCam13_ReqValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam13_ReqValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera13_Req_Camera_Request, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam13_ReqValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tActCam13Value.u32Status != u32StatusRead) {
        _tActCam13Value.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tActCam13Value.ActCam13Value, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tActCam13Value.ActCam13Value, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam13_ReqValue(): Called!"));
        _pCallbackIf->onActCam13Status(_tActCam13Value);
    }
		
}


tVoid veda_tclClientVcanCanAdaptor::vReadCam14_ReqValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam14_ReqValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera14_Req_Camera_Request, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam14_ReqValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tActCam14Value.u32Status != u32StatusRead) {
        _tActCam14Value.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tActCam14Value.ActCam14Value, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tActCam14Value.ActCam14Value, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam14_ReqValue(): Called!"));
        _pCallbackIf->onActCam14Status(_tActCam14Value);
    }
		
}


tVoid veda_tclClientVcanCanAdaptor::vReadCam15_ReqValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam15_ReqValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera15_Req_Camera_Request, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam15_ReqValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tActCam15Value.u32Status != u32StatusRead) {
        _tActCam15Value.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tActCam15Value.ActCam15Value, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tActCam15Value.ActCam15Value, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam15_ReqValue(): Called!"));
        _pCallbackIf->onActCam15Status(_tActCam15Value);
    }
		
}

tVoid veda_tclClientVcanCanAdaptor::vReadCam16_ReqValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam16_ReqValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera16_Req_Camera_Request, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam16_ReqValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tActCam16Value.u32Status != u32StatusRead) {
        _tActCam16Value.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tActCam16Value.ActCam16Value, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tActCam16Value.ActCam16Value, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam16_ReqValue(): Called!"));
        _pCallbackIf->onActCam16Status(_tActCam16Value);
    }
		
}


tVoid veda_tclClientVcanCanAdaptor::vReadCam17_ReqValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam17_ReqValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Camera17_Req_Camera_Request, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam17_ReqValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tActCam17Value.u32Status != u32StatusRead) {
        _tActCam17Value.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tActCam17Value.ActCam17Value, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tActCam17Value.ActCam17Value, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCam17_ReqValue(): Called!"));
        _pCallbackIf->onActCam17Status(_tActCam17Value);
    }
		
}


tVoid veda_tclClientVcanCanAdaptor::vReadSourceCommandValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSourceCommandValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_SourceCmd_MediaCommand, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSourceCommandValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tSourceCommandValue.u32Status != u32StatusRead) {
        _tSourceCommandValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tSourceCommandValue.SourceCmdValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tSourceCommandValue.SourceCmdValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSourceCommandValue(): Called!"));
       _pCallbackIf->onSourceCommandStatus(_tSourceCommandValue);
    }
		
}



tVoid veda_tclClientVcanCanAdaptor::vReadCabinSourceCommandValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCabinSourceCommandValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Cabin_Source_Command_CabinMediaCommand, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCabinSourceCommandValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tCabinSourceCommandValue.u32Status != u32StatusRead) {
        _tCabinSourceCommandValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tCabinSourceCommandValue.CabinSourceCmdValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tCabinSourceCommandValue.CabinSourceCmdValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCabinSourceCommandValue(): Called!"));
       _pCallbackIf->onCabinSourceCommandStatus(_tCabinSourceCommandValue);
    }
		
}




tVoid veda_tclClientVcanCanAdaptor::vReadCabinVolumeCommandValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCabinVolumeCommandValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Cabin_Volume_Command_CabinMediaCommand, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCabinVolumeCommandValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tCabinVolumeCommandValue.u32Status != u32StatusRead) {
        _tCabinVolumeCommandValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tCabinVolumeCommandValue.CabinVolumeCmdValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tCabinVolumeCommandValue.CabinVolumeCmdValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCabinVolumeCommandValue(): Called!"));
       _pCallbackIf->onCabinVolumeCommandStatus(_tCabinVolumeCommandValue);
    }
		
}




tVoid veda_tclClientVcanCanAdaptor::vReadCabinTunerCommandValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCabinTunerCommandValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Cabin_Tuner_Command_CabinMediaCommand, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCabinTunerCommandValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tCabinTunerCommandValue.u32Status != u32StatusRead) {
        _tCabinTunerCommandValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tCabinTunerCommandValue.CabinTunerCmdValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tCabinTunerCommandValue.CabinTunerCmdValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCabinTunerCommandValue(): Called!"));
       _pCallbackIf->onCabinTunerCommandStatus(_tCabinTunerCommandValue);
    }
		
}






tVoid veda_tclClientVcanCanAdaptor::vReadCabinTrackCommandValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCabinTrackCommandValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Cabin_TrackCommand_CabinMediaCommand, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCabinTrackCommandValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tCabinTrackCommandValue.u32Status != u32StatusRead) {
        _tCabinTrackCommandValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tCabinTrackCommandValue.CabinTrackCmdValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tCabinTrackCommandValue.CabinTrackCmdValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCabinTrackCommandValue(): Called!"));
       _pCallbackIf->onCabinTrackCommandStatus(_tCabinTrackCommandValue);
    }
		
}




tVoid veda_tclClientVcanCanAdaptor::vReadCabinPlaylistCommandValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCabinPlaylistCommandValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_CabinPlaylistCmd_CabinMediaCommand, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCabinPlaylistCommandValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tCabinPlaylistCommandValue.u32Status != u32StatusRead) {
        _tCabinPlaylistCommandValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tCabinPlaylistCommandValue.CabinPlaylistCmdValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tCabinPlaylistCommandValue.CabinPlaylistCmdValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadCabinPlaylistCommandValue(): Called!"));
       _pCallbackIf->onCabinPlaylistCommandStatus(_tCabinPlaylistCommandValue);
    }
		
}



tVoid veda_tclClientVcanCanAdaptor::vReadTunerCommandValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadTunerCommandValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_TunerCmd_MediaCommand, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadTunerCommandValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tTunerCommandValue.u32Status != u32StatusRead) {
        _tTunerCommandValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tTunerCommandValue.TunerCommandValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tTunerCommandValue.TunerCommandValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadTunerCommandValue(): Called!"));
       _pCallbackIf->onTunerCommandStatus(_tTunerCommandValue);
    }
		
}

tVoid veda_tclClientVcanCanAdaptor::vReadTACommandValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadTACommandValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_TAcmd_MediaCommand, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadTACommandValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tTACommandValue.u32Status != u32StatusRead) {
        _tTACommandValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tTACommandValue.TACommandValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tTACommandValue.TACommandValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadTACommandValue(): Called!"));
       _pCallbackIf->onTACommandStatus(_tTACommandValue);
    }
		
}

tVoid veda_tclClientVcanCanAdaptor::vReadRDSCommandValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadRDSCommandValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_RDScmd_MediaCommand, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadrdsCommandValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tRDSCommandValue.u32Status != u32StatusRead) {
        _tRDSCommandValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tRDSCommandValue.RDSCommandValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tRDSCommandValue.RDSCommandValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadRDSCommandValue(): Called!"));
       _pCallbackIf->onRDSCommandStatus(_tRDSCommandValue);
    }
		
}




tVoid veda_tclClientVcanCanAdaptor::vReadTrackCommandValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadTrackCommandValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_TrackCmd_MediaCommand, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadTrackCommandValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tTrackCommandValue.u32Status != u32StatusRead) {
        _tTrackCommandValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tTrackCommandValue.TrackCommandValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tTrackCommandValue.TrackCommandValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadTrackCommandValue(): Called!"));
        _pCallbackIf->onTrackCommandStatus(_tTrackCommandValue);
    }
		
}


tVoid veda_tclClientVcanCanAdaptor::vReadSMARTVRValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSMARTVRValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;

	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Smartphone_Voice_Recognition_MediaCommand, &au8Data_ReadBuffer,1,
        &u32StatusRead)) {
        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSMARTVRValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tSMARTVRValue.u32Status != u32StatusRead) {
        _tSMARTVRValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tSMARTVRValue.SMARTVRValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tSMARTVRValue.SMARTVRValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vSMARTVRValue(): Called!"));
        _pCallbackIf->onSMARTVRStatus(_tSMARTVRValue);
    }
		
}




tVoid veda_tclClientVcanCanAdaptor::vReadVoiceRecgCommandValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadVoiceRecgCommandValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_Voice_recognition_command_MediaCommand, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadVoiceRecgCommandValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tVoiceRecgCommandValue.u32Status != u32StatusRead) {
        _tVoiceRecgCommandValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tVoiceRecgCommandValue.VoiceRecgCmdValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tVoiceRecgCommandValue.VoiceRecgCmdValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadVoiceRecgCommandValue(): Called!"));
        _pCallbackIf->onVoiceRecgCommandStatus(_tVoiceRecgCommandValue);
    }
		
}

tVoid veda_tclClientVcanCanAdaptor::vReadPhonePwrCmdValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadPhonePwrCmdValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_PhonePwrCmd_MediaCommand, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadPhonePwrCmdValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tPhonePwrCmdValue.u32Status != u32StatusRead) {
        _tPhonePwrCmdValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tPhonePwrCmdValue.PhonePwrCmdValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tPhonePwrCmdValue.PhonePwrCmdValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadPhonePwrCmdValue(): Called!"));
        _pCallbackIf->onPhonePwrCmdStatus(_tPhonePwrCmdValue);
    }
		
}





tVoid veda_tclClientVcanCanAdaptor::vReadRadioPwrCmdValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadRadioPwrCmdValue(): Called!"));
	tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_RadioPwrCmd_MediaCommand, &au8Data_ReadBuffer,1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadRadioPwrCmdValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tRadioPwrCmdValue.u32Status != u32StatusRead) {
        _tRadioPwrCmdValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tRadioPwrCmdValue.RadioPwrCmdValue, &au8Data_ReadBuffer, 1) != 0) {
            memcpy(&_tRadioPwrCmdValue.RadioPwrCmdValue, &au8Data_ReadBuffer, 1);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadRadioPwrCmdValue(): Called!"));
        _pCallbackIf->onRadioPwrCmdStatus(_tRadioPwrCmdValue);
    }
		
}







tVoid veda_tclClientVcanCanAdaptor::vReadDeviceInfoSWversionValue()
{
	 VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadDeviceInfoSWversionValue(): Called!"));
	tU32  au8Data_ReadBuffer;
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
	
	if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_B_SW_Ver_MCP_Resp_DeviceInformation2, &au8Data_ReadBuffer,4,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadDeviceInfoSWversionValue,CSM_C_SIGNAL_DATA_INVALID "));
    }
	
	if(_tDeviceInfoSWversionValue.u32Status != u32StatusRead) {
        _tDeviceInfoSWversionValue.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tDeviceInfoSWversionValue.SWversionValue, &au8Data_ReadBuffer, 4) != 0) {
            memcpy(&_tDeviceInfoSWversionValue.SWversionValue, &au8Data_ReadBuffer, 4);
            bChanged = TRUE;
        }
    }

    if (( bChanged && _pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadDeviceInfoSWversionValue(): Called!"));
       _pCallbackIf->onDeviceInfoSWversionStatus(_tDeviceInfoSWversionValue);
    }
		
}


tVoid veda_tclClientVcanCanAdaptor::vReadDistanceUnit()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadDistanceUnit(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

    /* if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_SIG_RX_DistanceScale_SystemEnvironment,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tDistanceUnit.u32Status != u32StatusRead) {
        _tDistanceUnit.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	
	//CID:172297

/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tDistanceUnit.DistanceUnit, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tDistanceUnit.DistanceUnit, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadDistanceUnit(): Called!"));
        _pCallbackIf->onDistanceUnitStatus(_tDistanceUnit);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadHandBrakeSwitch()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadHandBrakeSwitch(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

/*     if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_HandBrakeSwitch,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tHandBrakeSwitch.u32Status != u32StatusRead) {
        _tHandBrakeSwitch.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
//CID: 172317

/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tHandBrakeSwitch.HandBrakeSwitch, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tHandBrakeSwitch.HandBrakeSwitch, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadHandBrakeSwitch(): Called!"));
        _pCallbackIf->onHandBrakeSwitchStatus(_tHandBrakeSwitch);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadDistanceTotalizer()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadDistanceTotalizer(): Called!"));
    tU8  au8Data_ReadBuffer[4];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

   /*  if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_DistanceTotalizer,
        &au8Data_ReadBuffer[0],
        4,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tDistanceTotalizer.u32Status != u32StatusRead) {
        _tDistanceTotalizer.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	//CID: 172322
	/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tDistanceTotalizer.DistanceTotalizer[0], &au8Data_ReadBuffer[0], 4) != 0) {
            memcpy(&_tDistanceTotalizer.DistanceTotalizer[0], &au8Data_ReadBuffer[0], 4);
            bChanged = TRUE;
        }
    }
	*/

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadDistanceTotalizer(): Called!"));
        _pCallbackIf->onDistanceTotalizerStatus(_tDistanceTotalizer);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadAverage_Fuel_Economy()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadAverage_Fuel_Economy(): Called!"));
    tU8  au8Data_ReadBuffer[2];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

  /*   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_Average_Fuel_Economy,
        &au8Data_ReadBuffer[0],
        2,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tAverage_Fuel_Economy.u32Status != u32StatusRead) {
        _tAverage_Fuel_Economy.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	//CID: 172308
	/*

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tAverage_Fuel_Economy.Average_Fuel_Economy[0], &au8Data_ReadBuffer[0], 2) != 0) {
            memcpy(&_tAverage_Fuel_Economy.Average_Fuel_Economy[0], &au8Data_ReadBuffer[0], 2);
            bChanged = TRUE;
        }
    }
	
	*/

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadAverage_Fuel_Economy(): Called!"));
        _pCallbackIf->onAverage_Fuel_EconomyStatus(_tAverage_Fuel_Economy);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadDiagMuxOn()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadDiagMuxOn(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

  /*   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_DiagMuxOn,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tDiagMuxOn.u32Status != u32StatusRead) {
        _tDiagMuxOn.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	
	//CID: 172296

	
	/*

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tDiagMuxOn.DiagMuxOn, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tDiagMuxOn.DiagMuxOn, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadDiagMuxOn(): Called!"));
        _pCallbackIf->onDiagMuxOnStatus(_tDiagMuxOn);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadDiagMuxOn_84()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadDiagMuxOn_84(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

 /*    if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_DiagMuxOn_84,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tDiagMuxOn_84.u32Status != u32StatusRead) {
        _tDiagMuxOn_84.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	
	//CID: 172315
/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tDiagMuxOn_84.DiagMuxOn_84, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tDiagMuxOn_84.DiagMuxOn_84, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
	*/

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadDiagMuxOn_84(): Called!"));
        _pCallbackIf->onDiagMuxOn_84Status(_tDiagMuxOn_84);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadGADE()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadGADE(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

   /* if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_GADE,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }*/

    if(_tGADE.u32Status != u32StatusRead) {
        _tGADE.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

	//CID: 172709
	/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tGADE.GADE, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tGADE.GADE, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
	*/

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadGADE(): Called!"));
        _pCallbackIf->onGADEStatus(_tGADE);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadRearGearEngaged()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadRearGearEngaged(): Called!"));
    tU8  au8Data_ReadBuffer;
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

   /* if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_RearGearEngaged,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }*/

    if(_tRearGearEngaged.u32Status != u32StatusRead) {
        _tRearGearEngaged.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

//CID :172287
/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tRearGearEngaged.RearGearEngaged, &au8Data_ReadBuffer[0], 1) != 0) {
		   memcpy(&_tRearGearEngaged.RearGearEngaged, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadRearGearEngaged(): Called!"));
        _pCallbackIf->onRearGearEngagedStatus(_tRearGearEngaged);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadOSPOverSpeedDisplayRequest()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadOSPOverSpeedDisplayRequest(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

   /* if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_OSPOverSpeedDisplayRequest,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }*/

    if(_tOSPOverSpeedDisplayRequest.u32Status != u32StatusRead) {
        _tOSPOverSpeedDisplayRequest.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	//CID:172319
/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tOSPOverSpeedDisplayRequest.OSPOverSpeedDisplayRequest, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tOSPOverSpeedDisplayRequest.OSPOverSpeedDisplayRequest, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadOSPOverSpeedDisplayRequest(): Called!"));
        _pCallbackIf->onOSPOverSpeedDisplayRequestStatus(_tOSPOverSpeedDisplayRequest);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadOSPSpeedUnit()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadOSPSpeedUnit(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

  /*   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_OSPSpeedUnit,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tOSPSpeedUnit.u32Status != u32StatusRead) {
        _tOSPSpeedUnit.u32Status = u32StatusRead;
        bChanged = TRUE;
    }


//CID: 172292

/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tOSPSpeedUnit.OSPSpeedUnit, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tOSPSpeedUnit.OSPSpeedUnit, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadOSPSpeedUnit(): Called!"));
        _pCallbackIf->onOSPSpeedUnitStatus(_tOSPSpeedUnit);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadTSR_OSP_ActivationStatus()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadTSR_OSP_ActivationStatus(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

 /*    if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_TSR_OSP_ActivationStatus,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tTSR_OSP_ActivationStatus.u32Status != u32StatusRead) {
        _tTSR_OSP_ActivationStatus.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
//CID: 172294

/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tTSR_OSP_ActivationStatus.TSR_OSP_ActivationStatus, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tTSR_OSP_ActivationStatus.TSR_OSP_ActivationStatus, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadTSR_OSP_ActivationStatus(): Called!"));
        _pCallbackIf->onTSR_OSP_ActivationStatusStatus(_tTSR_OSP_ActivationStatus);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadMeterLanguageKnowledge()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadMeterLanguageKnowledge(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

 /*    if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_MeterLanguageKnowledge,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tMeterLanguageKnowledge.u32Status != u32StatusRead) {
        _tMeterLanguageKnowledge.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

    /*if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tMeterLanguageKnowledge.MeterLanguageKnowledge, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tMeterLanguageKnowledge.MeterLanguageKnowledge, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }*/

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadMeterLanguageKnowledge(): Called!"));
        _pCallbackIf->onMeterLanguageKnowledgeStatus(_tMeterLanguageKnowledge);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadMeterLanguageStatus()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadMeterLanguageStatus(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

 /*    if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_MeterLanguageStatus,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tMeterLanguageStatus.u32Status != u32StatusRead) {
        _tMeterLanguageStatus.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	
//CID: 172293
	
/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tMeterLanguageStatus.MeterLanguageStatus, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tMeterLanguageStatus.MeterLanguageStatus, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadMeterLanguageStatus(): Called!"));
        _pCallbackIf->onMeterLanguageStatusStatus(_tMeterLanguageStatus);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadReset_TPMS_answer_back()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadReset_TPMS_answer_back(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

  /*   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_Reset_TPMS_answer_back,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tReset_TPMS_answer_back.u32Status != u32StatusRead) {
        _tReset_TPMS_answer_back.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
//CID: 172283


/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tReset_TPMS_answer_back.Reset_TPMS_answer_back, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tReset_TPMS_answer_back.Reset_TPMS_answer_back, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadReset_TPMS_answer_back(): Called!"));
        _pCallbackIf->onReset_TPMS_answer_backStatus(_tReset_TPMS_answer_back);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadSelect_pressure_support()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSelect_pressure_support(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

/*     if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_Select_pressure_support,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tSelect_pressure_support.u32Status != u32StatusRead) {
        _tSelect_pressure_support.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	//CID:172298

/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tSelect_pressure_support.Select_pressure_support, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tSelect_pressure_support.Select_pressure_support, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSelect_pressure_support(): Called!"));
        _pCallbackIf->onSelect_pressure_supportStatus(_tSelect_pressure_support);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadSetting_pressure_Front_answer_back()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSetting_pressure_Front_answer_back(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

  /*   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_Setting_pressure_Front_answer_back,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tSetting_pressure_Front_answer_back.u32Status != u32StatusRead) {
        _tSetting_pressure_Front_answer_back.u32Status = u32StatusRead;
        bChanged = TRUE;
    }

//CID: 172281

/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tSetting_pressure_Front_answer_back.Setting_pressure_Front_answer_back, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tSetting_pressure_Front_answer_back.Setting_pressure_Front_answer_back, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSetting_pressure_Front_answer_back(): Called!"));
        _pCallbackIf->onSetting_pressure_Front_answer_backStatus(_tSetting_pressure_Front_answer_back);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadSetting_pressure_Rear_answer_back()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSetting_pressure_Rear_answer_back(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

  /*   if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_Setting_pressure_Rear_answer_back,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    } */

    if(_tSetting_pressure_Rear_answer_back.u32Status != u32StatusRead) {
        _tSetting_pressure_Rear_answer_back.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	
	//CID : 172311
	/*

    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tSetting_pressure_Rear_answer_back.Setting_pressure_Rear_answer_back, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tSetting_pressure_Rear_answer_back.Setting_pressure_Rear_answer_back, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
	*/

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadSetting_pressure_Rear_answer_back(): Called!"));
        _pCallbackIf->onSetting_pressure_Rear_answer_backStatus(_tSetting_pressure_Rear_answer_back);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadGlobalVehicleWarningState()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadGlobalVehicleWarningState(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

   /* if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_GlobalVehicleWarningState,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }*/

    if(_tGlobalVehicleWarningState.u32Status != u32StatusRead) {
        _tGlobalVehicleWarningState.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	
	//CID: 172279

/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tGlobalVehicleWarningState.GlobalVehicleWarningState, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tGlobalVehicleWarningState.GlobalVehicleWarningState, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
*/
    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadGlobalVehicleWarningState(): Called!"));
        _pCallbackIf->onGlobalVehicleWarningStateStatus(_tGlobalVehicleWarningState);
    }
}
tVoid veda_tclClientVcanCanAdaptor::vReadVehicleStates()
{
    VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);
    ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadVehicleStates(): Called!"));
    tU8  au8Data_ReadBuffer[1];
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;

   /* if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, CSM_C_ASIG_RX_VehicleStates,
        &au8Data_ReadBuffer[0],
        1,
        &u32StatusRead))
    {

        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }*/

    if(_tVehicleStates.u32Status != u32StatusRead) {
        _tVehicleStates.u32Status = u32StatusRead;
        bChanged = TRUE;
    }
	
	//CID:172300
/*
    if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED))) {
        if(memcmp(&_tVehicleStates.VehicleStates, &au8Data_ReadBuffer[0], 1) != 0) {
            memcpy(&_tVehicleStates.VehicleStates, &au8Data_ReadBuffer[0], 1);
            bChanged = TRUE;
        }
    }
	*/

    if ((bChanged) && (_pCallbackIf)) {
        ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vReadVehicleStates(): Called!"));
        _pCallbackIf->onVehicleStatesStatus(_tVehicleStates);
    }
}

// veda_tclClientVcanCanAdaptor::ClassImplementation: user specific code start
tBool veda_tclClientVcanCanAdaptor::_bRegisterForBusOffErrorIndication(const tU8 u8Bus, tBool& bInitializationError) const
{
   VEDA_NULL_POINTER_CHECK_VAL(_poMyCSMInterface);

   tBool bRegistrationSuccess = FALSE; // Return value about Registration result
   tCSM_OSEKI_NWM_APPL_CALLBACK sCallBackFkt;

   sCallBackFkt.u16ApplID = (tU16) 0x01;/*Jayashree: CSM_C_APPL_ID_RN_CAN_NM_VEHICLE_DATA replaced with 0x01 as per g3inf4cv */
#if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
   sCallBackFkt.pvHandle = NULL;
#endif
#if (CSM_S_USE_TKSE == CSM_C_F_ON)
   sCallBackFkt.rTaskInfo = NULL;
#endif

  /* tU8 au8AddressField[2];
   au8AddressField[0] = 0x01; // Bus off monitoring
   au8AddressField[1] = 0xFF;
   sCallBackFkt.pfvCommunicationInd = veda_tclClientVcanCanAdaptor::vBusOffErrorIndication;*/

   // Bus off registration
  /* tS32 s32RoutineRetVal = _poMyCSMInterface->CSM_lApplCallbackInit(NULL, u8Bus, 0x01, au8AddressField, &sCallBackFkt);Jayashree: CSM_C_PTYPE_RN_OSEKI_NWM replaced with 0x01 as per g3inf4cv */



   return bRegistrationSuccess;
}

tBool veda_tclClientVcanCanAdaptor::_bRegisterForRxBusErrorIndication(const tU8 u8Bus, const tU8 u8Node) const
{
   VEDA_NULL_POINTER_CHECK_VAL(_poMyCSMInterface);

   tBool bRegistrationSuccess = FALSE;
   tU8 au8AddressField[2];
   tCSM_OSEKI_NWM_APPL_CALLBACK sCallBackFkt;

   sCallBackFkt.u16ApplID = (tU16) 0x01;/*Jayashree: CSM_C_APPL_ID_RN_CAN_NM_VEHICLE_DATA replaced with 0x01 as per g3inf4cv */
#if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
   sCallBackFkt.pvHandle = NULL;
#endif
#if (CSM_S_USE_TKSE == CSM_C_F_ON)
   sCallBackFkt.rTaskInfo = NULL;
#endif

   // Rx monitoring
 

   return bRegistrationSuccess;
}

tBool veda_tclClientVcanCanAdaptor::_bRegisterForTxBusErrorIndication(const tU8 u8Bus, const tU8 u8Node) const
{
   VEDA_NULL_POINTER_CHECK_VAL(_poMyCSMInterface);

   tBool bRegistrationSuccess = FALSE;
   tCSM_OSEKI_NWM_APPL_CALLBACK  sCallBackFkt;

   sCallBackFkt.u16ApplID = (tU16) 0x01;/*Jayashree: CSM_C_APPL_ID_RN_CAN_NM_VEHICLE_DATA replaced with 0x01 as per g3inf4cv */
#if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
   sCallBackFkt.pvHandle = OSAL_NULL;
#endif
#if (CSM_S_USE_TKSE == CSM_C_F_ON)
   sCallBackFkt.rTaskInfo = OSAL_NULL;
#endif

   

   return bRegistrationSuccess;
}

tVoid veda_tclClientVcanCanAdaptor::vBusOffErrorIndication( tVoid* /* pvHandle */,
                                                           tU8 u8Bus,
                                                           tU32 /* u32ProtocolType */,
                                                           const tVoid * pvAddressField,
                                                           tU8 u8State,
                                                           tU16 /* u16ApplId */)
{
   ETG_TRACE_USR1(("vBusOffErrorIndication() triggered"));

  
}


tVoid veda_tclClientVcanCanAdaptor::vRxBusErrorIndication( tVoid* /* pvHandle */,
                                                          tU8 /*u8Bus*/,
                                                          tU32 /* u32ProtocolType */,
                                                          const tVoid * pvAddressField,
                                                          tU8 u8State,
                                                          tU16 /* u16ApplId */)
{
   ETG_TRACE_USR1(("vRxBusErrorIndication() triggered"));

  /*if ( CSM_C_ADR_FLD_DC_NM_RX_INDICATOR == *(((tU8*)pvAddressField)+0) ) //lint !e1773: Attempt to cast away const (or volatile)
   {
      tU8 u8Node = (tU8) *(((tU8*)pvAddressField)+1); //lint !e1773: Attempt to cast away const (or volatile)
      tU8 u8DiagIndex = VEDA_DIAG_LAST;

      switch (u8Node)
      {*/
    /*  case CSM_C_ADR_FLD_RN_NM_454: //VCAN - BCM
         u8DiagIndex = VEDA_DIAG_ECU_BCM_454___;
         break;

      case CSM_C_ADR_FLD_RN_NM_224: //VCAN - USM
         u8DiagIndex = VEDA_DIAG_ECU_USM_224___;
         break;

      case CSM_C_ADR_FLD_RN_NM_4F2: //VCAN - Cluster/Meter
         u8DiagIndex = VEDA_DIAG_ECU_METER_4F2_;
         break;

      case CSM_C_ADR_FLD_RN_NM_5EA: //VCAN - COP
         u8DiagIndex = VEDA_DIAG_ECU_ISA_5EA___;
         break;

      case CSM_C_ADR_FLD_RN_NM_AVM: //VCAN - AVM
         u8DiagIndex = VEDA_DIAG_ECU_AVM_5C2___;
         break;

      case CSM_C_ADR_FLD_RN_NM_STRG: //VCAN - STRG 002
         u8DiagIndex = VEDA_DIAG_ECU_STRG_002__;
         break;

      case CSM_C_ADR_FLD_RN_NM_HCM: //VCAN - HCM
         u8DiagIndex = VEDA_DIAG_ECU_HCM_15C___;
         break;

      case CSM_C_ADR_FLD_RN_NM_SBW: //VCAN - SBW
         u8DiagIndex = VEDA_DIAG_ECU_SBW_0C1___;
         break;

      case CSM_C_ADR_FLD_RN_NM_SONAR: //VCAN - SONAR
         u8DiagIndex = VEDA_DIAG_ECU_SONAR_57A_;
         break;

      case CSM_C_ADR_FLD_RN_NM_ATCU: //VCAN - ATCU
         u8DiagIndex = VEDA_DIAG_ECU_ATCU______;
         break;

      case CSM_C_ADR_FLD_RN_NM_EPS: //VCAN - EPS
         u8DiagIndex = VEDA_DIAG_ECU_EPS_A3___;
         break;

      case CSM_C_ADR_FLD_RN_NM_VDC: //VCAN - VDC
         u8DiagIndex = VEDA_DIAG_ECU_VDC_438__;
         break;

      case CSM_C_ADR_FLD_RN_NM_FCAM: //VCAN - FRONT CAMERA
         u8DiagIndex = VEDA_DIAG_ECU_FCAM_____;
         break;

      case CSM_C_ADR_FLD_RN_NM_FWS: //VCAN - FWS
         u8DiagIndex = VEDA_DIAG_ECU_FWS_179___;
         break;

      case CSM_C_ADR_FLD_RN_NM_HFM: //VCAN - HFM
         u8DiagIndex = VEDA_DIAG_ECU_HFM_46F___;
         break;

      case CSM_C_ADR_FLD_RN_NM_HVAC: //VCAN - HVAC
         u8DiagIndex = VEDA_DIAG_ECU_HVAC_A1__;
         break;

      case CSM_C_ADR_FLD_RN_NM_HUD: //VCAN - HUD
         u8DiagIndex = VEDA_DIAG_ECU_HUD_______;
         break;

      case CSM_C_ADR_FLD_RN_NM_VTCU: //VCAN - TCU
         u8DiagIndex = VEDA_DIAG_ECU_TCU_43C___;
         break;

      case CSM_C_ADR_FLD_RN_NM_ACU: //VCAN - ACU
         u8DiagIndex = VEDA_DIAG_ECU_ACU_538___;
         break;

      case CSM_C_ADR_FLD_RN_NM_ADAS: //VCAN - ADAS
         u8DiagIndex = VEDA_DIAG_ECU_ADAS_A6___;
         break;

      case CSM_C_ADR_FLD_RN_NM_BSW: //VCAN - BSW
         u8DiagIndex = VEDA_DIAG_ECU_BSW_______;
         break;

      case CSM_C_ADR_FLD_RN_NM_HSM: //VCAN - HSM
         u8DiagIndex = VEDA_DIAG_ECU_HSM_______;
         break;

      case CSM_C_ADR_FLD_RN_NM_SR: //VCAN - SR
         u8DiagIndex = VEDA_DIAG_ECU_SR________;
         break;

      case CSM_C_ADR_FLD_RN_NM_DSMU: //VCAN - DSMU
         u8DiagIndex = VEDA_DIAG_ECU_DSMU______;
         break;

      case CSM_C_ADR_FLD_RN_NM_PSCU: //VCAN - PSCU
         u8DiagIndex = VEDA_DIAG_ECU_PSCU______;
         break;

      case CSM_C_ADR_FLD_RN_NM_ECM: //VCAN - ECM
         u8DiagIndex = VEDA_DIAG_ECU_ECM_______;
         break;
		 
      case CSM_C_ADR_FLD_RN_NM_AMP: //VCAN - AMP
         u8DiagIndex = VEDA_DIAG_ECU_AMP_______;
         break;*/

      /*default:
         u8DiagIndex = VEDA_DIAG_LAST;
         break;
      }*/

      /*if (_pMyStaticRef)
         _pMyStaticRef->_vHandleMessagePosting(veda_tclBaseIf::eCmdCsmBusIndReceived, u8DiagIndex, u8State, FALSE);
   }
   else
   {
      ETG_TRACE_USR1(("WARNING! Wrong Call back for CSM_C_ADR_FLD_RN_NM_RX_INDICATOR registered"));
   }*/
}

tVoid veda_tclClientVcanCanAdaptor::vTxBusErrorIndication( tVoid* /* pvHandle */,
                                                          tU8 /*u8Bus*/,
                                                          tU32 /* u32ProtocolType */,
                                                          const tVoid * pvAddressField,
                                                          tU8 u8State,
                                                          tU16 /* u16ApplId */)
{
   ETG_TRACE_USR1(("vTxBusErrorIndication() triggered"));

  /*if ( CSM_C_ADR_FLD_DC_NM_TX_INDICATOR == *(((tU8*)pvAddressField)+0) ) //lint !e1773: Attempt to cast away const (or volatile)
   {
      tU8 u8Node = (tU8) *(((tU8*)pvAddressField)+1); //lint !e1773: Attempt to cast away const (or volatile)
      tU8 u8DiagIndex;
      switch (u8Node)
      {*/
		  /*
      case CSM_C_ADR_FLD_RN_NM_AUDIO: //MCAN - AUDIO
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_AUD_;
         break;

      case CSM_C_ADR_FLD_RN_NM_SWC: //MCAN - SWC
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_SWC_;
         break;

      case CSM_C_ADR_FLD_RN_NM_NAVI: //MCAN - NAVI
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_NAV_;
         break;

      case CSM_C_ADR_FLD_RN_NM_NAVI2: // MCAN Navi Gen2
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_NAV2;
         break;

      case CSM_C_ADR_FLD_RN_NM_TCU: //MCAN - TCU
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_TCU_;
         break;

      case CSM_C_ADR_FLD_RN_NM_BOSE: //MCAN - BOSE
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_BOSE;
         break;

      case CSM_C_ADR_FLD_RN_NM_RSE: //MCAN - RSE
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_RSE_;
         break;

      case CSM_C_ADR_FLD_RN_NM_AVM:
         // VCAN Tx Telegram 0x5FE
         u8DiagIndex = VEDA_DIAG_MUTE_VCAN_____;
         break;*/
      /*default:
         u8DiagIndex = VEDA_DIAG_LAST;
         break;
      }*/

     /* if (_pMyStaticRef)
         _pMyStaticRef->_vHandleMessagePosting(veda_tclBaseIf::eCmdCsmBusIndReceived, u8DiagIndex, u8State, FALSE);
   }
   else
   {
      ETG_TRACE_USR1(("WARNING! Wrong Call back for CSM_C_ADR_FLD_RN_NM_TX_INDICATOR registered"));
   }*/
}


tBool veda_tclClientVcanCanAdaptor::_bCheckCommunicationState_RX(const tU8 u8Bus, const tU8 u8Node, tU8& u8FaultState) const
{
   VEDA_NULL_POINTER_CHECK_VAL(_poMyCSMInterface);

   tBool bRequest = TRUE;
   tU8  u8CommunicationState = CNM_OSEKI_C_STATE_NODE_PRESENT;
   tU8 au8AddressField[2];
   au8AddressField[0] = CSM_C_ADR_FLD_DC_NM_RX_INDICATOR;
   au8AddressField[1] = u8Node;
#if 0   //Due to coverity warning
   if ( 0)/*Jayashree: CSM_C_APPL_ID_RN_CAN_NM_VEHICLE_DATA replaced with 0x01 as per g3inf4cv */
   {
      bRequest = FALSE;
     // ETG_TRACE_USR1(("_bCheckCommunicationState_RX() CSM_lGetCommunicationState failed !!"));
   }
   else
   {
#endif
      tU8 u8DiagIndex;
      switch (au8AddressField[1])
      {
		  /*
      case CSM_C_ADR_FLD_RN_NM_454: //VCAN - BCM
         u8DiagIndex = VEDA_DIAG_ECU_BCM_454___;
         break;

      case CSM_C_ADR_FLD_RN_NM_224: //VCAN - USM
         u8DiagIndex = VEDA_DIAG_ECU_USM_224___;
         break;

      case CSM_C_ADR_FLD_RN_NM_4F2: //VCAN - Cluster/Meter
         u8DiagIndex = VEDA_DIAG_ECU_METER_4F2_;
         break;

      case CSM_C_ADR_FLD_RN_NM_5EA: //VCAN - COP
         u8DiagIndex = VEDA_DIAG_ECU_ISA_5EA___;
         break;

      case CSM_C_ADR_FLD_RN_NM_AVM: //VCAN - AVM
         u8DiagIndex = VEDA_DIAG_ECU_AVM_5C2___;
         break;

      case CSM_C_ADR_FLD_RN_NM_STRG: //VCAN - STRG 002
         u8DiagIndex = VEDA_DIAG_ECU_STRG_002__;
         break;

      case CSM_C_ADR_FLD_RN_NM_HCM: //VCAN - HCM
         u8DiagIndex = VEDA_DIAG_ECU_HCM_15C___;
         break;

      case CSM_C_ADR_FLD_RN_NM_SBW: //VCAN - SBW
         u8DiagIndex = VEDA_DIAG_ECU_SBW_0C1___;
         break;

      case CSM_C_ADR_FLD_RN_NM_SONAR: //VCAN - SONAR
         u8DiagIndex = VEDA_DIAG_ECU_SONAR_57A_;
         break;
      default:
         u8DiagIndex = VEDA_DIAG_LAST;
         break;
      }

      switch (u8CommunicationState)
      {
      case CNM_OSEKI_C_STATE_BUS_ON:
    	  u8FaultState = BUS_FAULT_INACTIVE;
         break;
      case CNM_OSEKI_C_STATE_BUS_OFF:
    	  u8FaultState = BUS_FAULT_ACTIVE;
         break;
      case CNM_OSEKI_C_STATE_CONFIRMED_BUS_OFF:
    	  u8FaultState = BUS_FAULT_CONFIRMED;
         break;*/
      default:
    	  u8FaultState = BUS_FAULT_UNKNOWN;
         break;
      }
//   }

   return bRequest;
}

tBool veda_tclClientVcanCanAdaptor::_bCheckCommunicationState_TX(const tU8 u8Bus, const tU8 u8Node, tU8& u8FaultState) const
{
   VEDA_NULL_POINTER_CHECK_VAL(_poMyCSMInterface);

   tBool bRequest = TRUE;

   tU8 au8AddressField[2];
  // au8AddressField[0] = CSM_C_ADR_FLD_DC_NM_TX_INDICATOR;
   au8AddressField[1] = u8Node;
#if 0   //Due to coverity warning
   if ( 0 )
   {
      bRequest = FALSE;
      //ETG_TRACE_USR1(("_bCheckCommunicationState_TX() CSM_lGetCommunicationState failed !!"));
   }
   else
   {
#endif
      tU8 u8DiagIndex;
      switch (au8AddressField[1])
      {
		  /*
      case CSM_C_ADR_FLD_RN_NM_AUDIO: //MCAN - AUDIO
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_AUD_;
         break;

      case CSM_C_ADR_FLD_RN_NM_SWC: //MCAN - SWC
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_SWC_;
         break;

      case CSM_C_ADR_FLD_RN_NM_NAVI: //MCAN - NAVI
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_NAV_;
         break;

      case CSM_C_ADR_FLD_RN_NM_NAVI2: // MCAN Navi Gen2
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_NAV2;
         break;

      case CSM_C_ADR_FLD_RN_NM_TCU: //MCAN - TCU
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_TCU_;
         break;

      case CSM_C_ADR_FLD_RN_NM_BOSE: //MCAN - BOSE
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_BOSE;
         break;

      case CSM_C_ADR_FLD_RN_NM_RSE: //MCAN - RSE
         u8DiagIndex = VEDA_DIAG_MUTE_MCAN_RSE_;
         break;

      case CSM_C_ADR_FLD_RN_NM_AVM:
         // VCAN Tx Telegram 0x5FE
         u8DiagIndex = VEDA_DIAG_MUTE_VCAN_____;
         break;*/
      default:
         u8DiagIndex = VEDA_DIAG_LAST;
         break;
      }

	u8FaultState = BUS_FAULT_UNKNOWN;

//   }

   return bRequest;
}

tBool veda_tclClientVcanCanAdaptor::_bCheckCommunicationState_BusOff(const tU8 u8Bus, tU8& u8FaultState) const
{
   tBool bRequest = TRUE;
   tU8  u8CommunicationState = CNM_OSEKI_C_STATE_ERROR;

   tU8 au8AddressField[2];
   //au8AddressField[0] = CSM_C_ADR_FLD_DC_NM_BUSOFF_INDICATOR;  (piyush)
   au8AddressField[1] = 0xFF;

   VEDA_NULL_POINTER_CHECK_VAL(_poMyCSMInterface);

   // if ( 0 )
   // {
      // bRequest = FALSE;
     // // ETG_TRACE_USR1(("_bCheckCommunicationState_BusOff() CSM_lGetCommunicationState failed !!"));
   // }
   
   // else
   // {
      tU8 u8DiagIndex;
      switch (u8Bus)
      {
      case CSM_C_CAN_BUS_MCAN:
         u8DiagIndex = VEDA_DIAG_BUS_OFF_MCAN__;
         break;
      case CSM_C_CAN_BUS_VCAN:
         u8DiagIndex = VEDA_DIAG_BUS_OFF_VCAN__;
         break;
      default:
         u8DiagIndex = VEDA_DIAG_LAST;
         break;
      }

      switch (u8CommunicationState)
      {
		// CID: 220026
	 /*
	  case CNM_OSEKI_C_STATE_BUS_ON:
    	  u8FaultState = BUS_FAULT_INACTIVE;
         break;
      case CNM_OSEKI_C_STATE_BUS_OFF:
    	  u8FaultState = BUS_FAULT_ACTIVE;
         break;
      case CNM_OSEKI_C_STATE_CONFIRMED_BUS_OFF:
    	  u8FaultState = BUS_FAULT_CONFIRMED;
         break;
		 */
      default:
    	  u8FaultState = BUS_FAULT_UNKNOWN;
         break;
      }
 //  }

   return bRequest;
}

tVoid veda_tclClientVcanCanAdaptor::_vHandleMessagePosting(const veda_tclBaseIf::ECmdTypes, const tU8 u8DiagIndex, const tU8 u8Result, const tU8 u8ForceUpdate) const
{
   veda_tclBaseIf::TMsg oMsg;
   (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
   oMsg.eCmd = veda_tclBaseIf::eCmdCsmBusIndReceived;
   memset(oMsg.strClassName, 0, 50);
   OSAL_szStringNCopy(oMsg.strClassName, "veda_tclClientVcan", strlen("veda_tclClientVcan"));

   oMsg.u.au8Data[0] = u8DiagIndex;
   oMsg.u.au8Data[2] = u8ForceUpdate;

   // Map the received error state to vehicle data internally defined state
   switch (u8Result)
   {
   case CNM_OSEKI_C_STATE_BUS_ON:
      oMsg.u.au8Data[1] = BUS_FAULT_INACTIVE;
      break;
   case CNM_OSEKI_C_STATE_BUS_OFF:
      oMsg.u.au8Data[1] = BUS_FAULT_ACTIVE;
      break;
   case CNM_OSEKI_C_STATE_CONFIRMED_BUS_OFF:
      oMsg.u.au8Data[1] = BUS_FAULT_CONFIRMED;
      break;
   default:
      oMsg.u.au8Data[1] = BUS_FAULT_UNKNOWN;
      break;
   }

   _pMyStaticRef->_cpoMain->theServer()->vPostInternalMessage(&oMsg);
}

tVoid veda_tclClientVcanCanAdaptor::_vSendKDSCodingChangedInfoToCSM() const
{
   tU8 pbData = 0;
   tU32 wDataLength = 0x01;

   //CID: 578161

   tU8 au8AddressField[4]; 
   au8AddressField[0] = 0x27;//CSM_C_ADDRESS_FIELD_LCTRL_DIA_KDS_CHANGED;// (== 0x27)
   au8AddressField[1] = 0x00;

   VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);

   if ( CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lDataReq( NULL, CSM_C_PTYPE_USED_STD_CAN_LOCAL_CTRL/*CSM_C_PTYPE_PSGEN_CAN_LOCAL_CTRL CSM_C_PTYPE_RN_CAN_LOCAL_CTRL commented as it is not required for g3inf4cv*/,
      &au8AddressField[0], &pbData, wDataLength) )
   {
      ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::vSendKDSCodingChangedInfoToCSM() Failed!!"));
   }
   else
   {
      ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::vSendKDSCodingChangedInfoToCSM() Sent Success!!"));
   }
}

/*tVoid veda_tclClientVcanCanAdaptor::vReinitCsmNetworkManagement(tVoid) const
{
	//CID: 578165

	tU8 au8AddressField[4];
	//au8AddressField[0] = CSM_C_ADR_FLD_DC_NM_CMD_INDICATOR; (piyush)
	au8AddressField[1] = 0xFF;

	VEDA_NULL_POINTER_CHECK(_poMyCSMInterface);

	if( _poMyCSMInterface->CSM_lCommunicationReq(OSAL_NULL,
			CSM_C_CAN_BUS_VCAN,
			CSM_C_PTYPE_USED_STD_CAN_LOCAL_CTRL,Jayashree: CSM_C_PTYPE_RN_OSEKI_NWM replaced with 0x01 as per g3inf4cv 
			au8AddressField,
			CNM_OSEKI_CMD_REINIT_MONITOR,
			(tU16) CSM_C_APPL_ID_DC_CAN_NM_VEHICLE_DATA) < CSM_C_NO_ERROR ) Jayashree: CSM_C_APPL_ID_RN_CAN_NM_VEHICLE_DATA replaced with 0x01 as per g3inf4cv 
	{
		ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::vReinitCsmNetworkManagement() CSM_lCommunicationReq failed"));
	}
}*/

tVoid veda_tclClientVcanCanAdaptor::vGetSpeed_Limit_Display_Request(TSpeed_Limit_Display_Request& tSpeed_Limit_Display_Request) {
        vReadSpeed_Limit_Display_Request();
        memcpy(&tSpeed_Limit_Display_Request, &_tSpeed_Limit_Display_Request, sizeof(TSpeed_Limit_Display_Request));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetNavi_display_speed_limit_1(TNavi_display_speed_limit_1& tNavi_display_speed_limit_1) {
        vReadNavi_display_speed_limit_1();
        memcpy(&tNavi_display_speed_limit_1, &_tNavi_display_speed_limit_1, sizeof(TNavi_display_speed_limit_1));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetNavi_display_speed_limit_2(TNavi_display_speed_limit_2& tNavi_display_speed_limit_2) {
        vReadNavi_display_speed_limit_2();
        memcpy(&tNavi_display_speed_limit_2, &_tNavi_display_speed_limit_2, sizeof(TNavi_display_speed_limit_2));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetIgnitionSupplyConfirmation(TIgnitionSupplyConfirmation& tIgnitionSupplyConfirmation) {
        vReadIgnitionSupplyConfirmation();
        memcpy(&tIgnitionSupplyConfirmation, &_tIgnitionSupplyConfirmation, sizeof(TIgnitionSupplyConfirmation));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetVehicleSpeed(TVehicleSpeed& tVehicleSpeed) {
        vReadVehicleSpeed();
        memcpy(&tVehicleSpeed, &_tVehicleSpeed, sizeof(TVehicleSpeed));
    }
	//TCOVehiclespeed
	tVoid veda_tclClientVcanCanAdaptor::vGetTCOVehicleSpeed(TTCOVehicleSpeed& tTCOVehicleSpeed) {
        vReadTCOVehicleSpeed();
        memcpy(&tTCOVehicleSpeed, &_tTCOVehicleSpeed, sizeof(TTCOVehicleSpeed));
    }
	//partial mute
	tVoid veda_tclClientVcanCanAdaptor::vGetPartialMuteValue(TPartialMuteValue& tPartialMuteValue) {
        vReadPartialMuteValue();
        memcpy(&tPartialMuteValue, &_tPartialMuteValue, sizeof(TPartialMuteValue));
    }
	tVoid veda_tclClientVcanCanAdaptor::vGetSwivMonAutoOpenValue(TSwivMonAutoOpenValue& tSwivMonAutoOpenValue) {
        
    }
	tVoid veda_tclClientVcanCanAdaptor::vGetDateModeValue(TDateModeValue& tDateModeValue) {
        vReadDateModeValue();
        memcpy(&tDateModeValue, &_tDateModeValue, sizeof(TDateModeValue));
    }
	tVoid veda_tclClientVcanCanAdaptor::vGetTmModeValue(TTmModeValue& tTmModeValue) {
        vReadTmModeValue();
        memcpy(&tTmModeValue, &_tTmModeValue, sizeof(TTmModeValue));
    }
	//camera
	tVoid veda_tclClientVcanCanAdaptor::vGetActCam1Value(TActCam1Value& tActCam1Value) {
        vReadCam1_ReqValue();
		memcpy(&tActCam1Value, &_tActCam1Value, sizeof(TActCam1Value));
    }
	//camera2
	tVoid veda_tclClientVcanCanAdaptor::vGetActCam2Value(TActCam2Value& tActCam2Value) {
        vReadCam2_ReqValue();
		memcpy(&tActCam2Value, &_tActCam2Value, sizeof(TActCam2Value));
    }
	//camera3
	tVoid veda_tclClientVcanCanAdaptor::vGetActCam3Value(TActCam3Value& tActCam3Value) {
        vReadCam3_ReqValue();
		memcpy(&tActCam3Value, &_tActCam3Value, sizeof(TActCam3Value));
    }
	//camera4
	tVoid veda_tclClientVcanCanAdaptor::vGetActCam4Value(TActCam4Value& tActCam4Value) {
        vReadCam4_ReqValue();
		memcpy(&tActCam4Value, &_tActCam4Value, sizeof(TActCam4Value));
    }
	//camera5
	tVoid veda_tclClientVcanCanAdaptor::vGetActCam5Value(TActCam5Value& tActCam5Value) {
        vReadCam5_ReqValue();
		memcpy(&tActCam5Value, &_tActCam5Value, sizeof(TActCam5Value));
    }
	//camera6
	tVoid veda_tclClientVcanCanAdaptor::vGetActCam6Value(TActCam6Value& tActCam6Value) {
        vReadCam6_ReqValue();
		memcpy(&tActCam6Value, &_tActCam6Value, sizeof(TActCam6Value));
    }
	//camera7
	tVoid veda_tclClientVcanCanAdaptor::vGetActCam7Value(TActCam7Value& tActCam7Value) {
        vReadCam7_ReqValue();
		memcpy(&tActCam7Value, &_tActCam7Value, sizeof(TActCam7Value));
    }
	//camsplit
	tVoid veda_tclClientVcanCanAdaptor::vGetCamSplitQuadValue(TCamSplitQuadValue& tCamSplitQuadValue) {
        
    }
	//MuteDev
	tVoid veda_tclClientVcanCanAdaptor::vGetMuteDevStatus(TMuteDevStatus& tMuteDevStatus) {
        vReadMuteDevStatus();
        memcpy(&tMuteDevStatus, &_tMuteDevStatus, sizeof(TMuteDevStatus));
    }
	//sysVolt
	tVoid veda_tclClientVcanCanAdaptor::vGetSysVoltStatus(TSysVoltStatus& tSysVoltStatus) {
        
    }
	//ParkingBreakSwitch
	tVoid veda_tclClientVcanCanAdaptor::vGetParkingBreakSwitchValue(TParkingBreakSwitchValue& tParkingBreakSwitchValue) {
        vReadParkingBreakSwitchValue();
        memcpy(&tParkingBreakSwitchValue, &_tParkingBreakSwitchValue, sizeof(TParkingBreakSwitchValue));
    }
	//Distance Unit
	tVoid veda_tclClientVcanCanAdaptor::vGetUnitDistanceDisplayState(TUnitDistanceDisplayState& tUnitDistanceDisplayState) {
        vReadUnitDistanceDisplayState();
        memcpy(&tUnitDistanceDisplayState, &_tUnitDistanceDisplayState, sizeof(TUnitDistanceDisplayState));
    }
	//RearCamReq
	tVoid veda_tclClientVcanCanAdaptor::vGetRearCamReqValue(TRearCamReqValue& tRearCamReqValue) {
        vReadRearCamReqValue();
        memcpy(&tRearCamReqValue, &_tRearCamReqValue, sizeof(TRearCamReqValue));
    }
	//VIN
	tVoid veda_tclClientVcanCanAdaptor::vGetVINValue(TVINValue& tVINValue){
		
	}
		//Time Date
	tVoid veda_tclClientVcanCanAdaptor::vGetTimeDateValue(TTimeDateValue& tTimeDateValue) {
        vReadTimeDateValue();
        memcpy(&tTimeDateValue, &_tTimeDateValue, sizeof(TTimeDateValue));
    }
	
	//Phone Call Command
	tVoid veda_tclClientVcanCanAdaptor::vGetPhoneCallCmdValue(TPhoneCallCommand& tPhoneCallCommand) {
        vReadPhoneCallCommandValue();
        memcpy(&tPhoneCallCommand, &_tPhoneCallCommandStatus, sizeof(TPhoneCallCommand));
    }
	
	//System Language
	tVoid veda_tclClientVcanCanAdaptor::vGetSystemLanguageValue(TSystemLanguageValue& tSystemLanguageValue) {
		vReadSystemLanguageValue();
        memcpy(&tSystemLanguageValue, &_tSystemLanguageValue, sizeof(TSystemLanguageValue));
    }
	//CurrLang
	tVoid veda_tclClientVcanCanAdaptor::vGetCurrLangValue(TCurrLangValue& tCurrLangValue){
		
	}
	//CamTxt
	tVoid veda_tclClientVcanCanAdaptor::vGetCamTxtValue(TCamTxtValue& tCamTxtValue) {
        
    }
	tVoid veda_tclClientVcanCanAdaptor::vGetDistanceUnit(TDistanceUnit& tDistanceUnit) {
        vReadDistanceUnit();
        memcpy(&tDistanceUnit, &_tDistanceUnit, sizeof(TDistanceUnit));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetHandBrakeSwitch(THandBrakeSwitch& tHandBrakeSwitch) {
        vReadHandBrakeSwitch();
        memcpy(&tHandBrakeSwitch, &_tHandBrakeSwitch, sizeof(THandBrakeSwitch));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetDistanceTotalizer(TDistanceTotalizer& tDistanceTotalizer) {
        vReadDistanceTotalizer();
        memcpy(&tDistanceTotalizer, &_tDistanceTotalizer, sizeof(TDistanceTotalizer));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetAverage_Fuel_Economy(TAverage_Fuel_Economy& tAverage_Fuel_Economy) {
        vReadAverage_Fuel_Economy();
        memcpy(&tAverage_Fuel_Economy, &_tAverage_Fuel_Economy, sizeof(TAverage_Fuel_Economy));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetDiagMuxOn(TDiagMuxOn& tDiagMuxOn) {
        vReadDiagMuxOn();
        memcpy(&tDiagMuxOn, &_tDiagMuxOn, sizeof(TDiagMuxOn));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetDiagMuxOn_84(TDiagMuxOn_84& tDiagMuxOn_84) {
        vReadDiagMuxOn_84();
        memcpy(&tDiagMuxOn_84, &_tDiagMuxOn_84, sizeof(TDiagMuxOn_84));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetGADE(TGADE& tGADE) {
        vReadGADE();
        memcpy(&tGADE, &_tGADE, sizeof(TGADE));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetRearGearEngaged(TRearGearEngaged& tRearGearEngaged) {
		vReadRearGearEngaged();
        memcpy(&tRearGearEngaged, &_tRearGearEngaged, sizeof(TRearGearEngaged));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetOSPOverSpeedDisplayRequest(TOSPOverSpeedDisplayRequest& tOSPOverSpeedDisplayRequest) {
        vReadOSPOverSpeedDisplayRequest();
        memcpy(&tOSPOverSpeedDisplayRequest, &_tOSPOverSpeedDisplayRequest, sizeof(TOSPOverSpeedDisplayRequest));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetOSPSpeedUnit(TOSPSpeedUnit& tOSPSpeedUnit) {
        vReadOSPSpeedUnit();
        memcpy(&tOSPSpeedUnit, &_tOSPSpeedUnit, sizeof(TOSPSpeedUnit));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetTSR_OSP_ActivationStatus(TTSR_OSP_ActivationStatus& tTSR_OSP_ActivationStatus) {
        vReadTSR_OSP_ActivationStatus();
        memcpy(&tTSR_OSP_ActivationStatus, &_tTSR_OSP_ActivationStatus, sizeof(TTSR_OSP_ActivationStatus));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetMeterLanguageKnowledge(TMeterLanguageKnowledge& tMeterLanguageKnowledge) {
        vReadMeterLanguageKnowledge();
        memcpy(&tMeterLanguageKnowledge, &_tMeterLanguageKnowledge, sizeof(TMeterLanguageKnowledge));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetMeterLanguageStatus(TMeterLanguageStatus& tMeterLanguageStatus) {
        vReadMeterLanguageStatus();
        memcpy(&tMeterLanguageStatus, &_tMeterLanguageStatus, sizeof(TMeterLanguageStatus));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetReset_TPMS_answer_back(TReset_TPMS_answer_back& tReset_TPMS_answer_back) {
        vReadReset_TPMS_answer_back();
        memcpy(&tReset_TPMS_answer_back, &_tReset_TPMS_answer_back, sizeof(TReset_TPMS_answer_back));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetSelect_pressure_support(TSelect_pressure_support& tSelect_pressure_support) {
        vReadSelect_pressure_support();
        memcpy(&tSelect_pressure_support, &_tSelect_pressure_support, sizeof(TSelect_pressure_support));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetSetting_pressure_Front_answer_back(TSetting_pressure_Front_answer_back& tSetting_pressure_Front_answer_back) {
        vReadSetting_pressure_Front_answer_back();
        memcpy(&tSetting_pressure_Front_answer_back, &_tSetting_pressure_Front_answer_back, sizeof(TSetting_pressure_Front_answer_back));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetSetting_pressure_Rear_answer_back(TSetting_pressure_Rear_answer_back& tSetting_pressure_Rear_answer_back) {
        vReadSetting_pressure_Rear_answer_back();
        memcpy(&tSetting_pressure_Rear_answer_back, &_tSetting_pressure_Rear_answer_back, sizeof(TSetting_pressure_Rear_answer_back));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetGlobalVehicleWarningState(TGlobalVehicleWarningState& tGlobalVehicleWarningState) {
        vReadGlobalVehicleWarningState();
        memcpy(&tGlobalVehicleWarningState, &_tGlobalVehicleWarningState, sizeof(TGlobalVehicleWarningState));
    }
    tVoid veda_tclClientVcanCanAdaptor::vGetVehicleStates(TVehicleStates& tVehicleStates) {
        vReadVehicleStates();
        memcpy(&tVehicleStates, &_tVehicleStates, sizeof(TVehicleStates));
    }
    //SendMediaInfoToCluster
     tVoid veda_tclClientVcanCanAdaptor::vSendMediaInfoToCluster(TMediaInfo tTxSignal){
		  ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::vSendMediaInfoToCluster Called"));
	   if(tTxSignal.list.size() > 0)
	   {
		 stMediaInfo = tTxSignal;
	     PBYTE firstelement = &(stMediaInfo.list[0]);
	     WORD length = stMediaInfo.list.size();
		 //set pending flag 
		 mediaDataReqState = Pending;
		  ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::vSendMediaInfoToCluster MediaCsmState is %d",mediaCsmState));
		 if(mediaCsmState == Idle)
		 {
		  ETG_TRACE_USR1(("Calling J1939 "));
	         J1939DataReq(MEDIA,firstelement,length);
		 }
	   }
	    
     }

	 tVoid veda_tclClientVcanCanAdaptor::vSendCallInfoToCluster(TMediaInfo tTxSignal)
    {
		ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::vSendCallInfoToCluster Called"));
	   if(tTxSignal.list.size() > 0)
	   {
		 stCallInfo = tTxSignal;
	     PBYTE firstelement = &(stCallInfo.list[0]);
	     WORD length = stCallInfo.list.size();
		 phoneCallDataReqState = Pending;
		 if(mediaCsmState == Idle)
		 {
			
	         J1939DataReq(PHONECALL,firstelement,length);
		 }
	   }

    }
   tVoid veda_tclClientVcanCanAdaptor::vSendPhoneInfoToCluster(TMediaInfo tTxSignal)
   {
	   ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::vSendPhoneInfoToCluster Called"));
	   if(tTxSignal.list.size() > 0)
	   {
	     stPhoneInfo = tTxSignal;
	     PBYTE firstelement = &(stPhoneInfo.list[0]);
	     WORD length = stPhoneInfo.list.size();
	     phoneInfoDataReqState = Pending;
	     if(mediaCsmState == Idle)
	     {
			
	         J1939DataReq(PHONEINFO,firstelement,length);
	     }
	   }


   }
   tVoid veda_tclClientVcanCanAdaptor::vSendTurnToStreetInfoToCluster(TStreetInfo tTxSignal)
   {
	   ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::vSendTurnToStreetInfoToCluster Called"));
	   if(tTxSignal.list.size() > 0)
	   {
	     stTurntoStreetInfo  = tTxSignal;
	     PBYTE firstelement = &(stStreetInfo.list[0]);
	     WORD length = stStreetInfo.list.size();
	     turntoStreetDataReqState = Pending;
	     if(naviCsmState == Idle)
	     {
               J1939NaviDataReq(NAVI_TURNTO_STREET_INFO,firstelement,length);
	     }
	   }
   }
   tVoid veda_tclClientVcanCanAdaptor::vSendCurrentStreetInfoToCluster(TStreetInfo tTxSignal)
   {
	   ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::vSendCurrentStreetInfoToCluster Called"));
	   if(tTxSignal.list.size() > 0)
	   {
	     stStreetInfo = tTxSignal;
	     PBYTE firstelement = &(stTurntoStreetInfo.list[0]);
	     WORD length = stTurntoStreetInfo.list.size();
	     currentstreetDataReqState = Pending;
	     if(naviCsmState == Idle)
	     {
               J1939NaviDataReq(NAVI_CURRENT_STREET_INFO,firstelement,length);
	     }
	   }
   }
   tVoid veda_tclClientVcanCanAdaptor::vSendDestinationInfoToCluster(TNaviInfo tTxSignal)
   {
	   ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::vSendDestinationInfoToCluster Called"));
	   if(tTxSignal.list.size() > 0)
	   {
	     stDestinatioInfo = tTxSignal;
	     PBYTE firstelement = &(stDestinatioInfo.list[0]);
	     WORD length = stDestinatioInfo.list.size();
	     destinationInfoDataReqState = Pending; 
	     if(naviCsmState == Idle)
	     {
               J1939NaviDataReq(NAVI_DESTINATION_INFO,firstelement,length);
	     }
	   }

   }
   tVoid veda_tclClientVcanCanAdaptor::vSendTurnToSymbolsInfoToCluster(TNaviInfo tTxSignal)
   {
	   ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::vSendTurnToSymbolsInfoToCluster Called"));
	   if(tTxSignal.list.size() > 0)
	   {
	     stTurnToSymbolsInfo = tTxSignal;
	     PBYTE firstelement = &(stTurnToSymbolsInfo.list[0]);
	     WORD length = stTurnToSymbolsInfo.list.size();
	     turntoSymbolsDataReqState = Pending;
	     if(naviCsmState == Idle)
	     {
               J1939NaviDataReq(NAVI_TURNTO_SYMBOLS_INFO,firstelement,length);
	     }
	   }
   }
   tVoid veda_tclClientVcanCanAdaptor::vSendNaviLaneGuidanceInfoToCluster(TNaviInfo tTxSignal)
   {
	   ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::vSendNaviLaneGuidanceInfoToCluster Called"));
	   if(tTxSignal.list.size() > 0)
	   {
	     stLaneGuidanceInfo = tTxSignal;
	     PBYTE firstelement = &(stLaneGuidanceInfo.list[0]);
	     WORD length = stLaneGuidanceInfo.list.size();
	     laneGuidanceInfoDataReqState = Pending;
	     if(naviCsmState == Idle)
	     {
               J1939NaviDataReq(NAVI_LANEGUIDANCE_INFO,firstelement,length);
	     }
	   }
   }
   tVoid veda_tclClientVcanCanAdaptor::vSendNaviWarningInfoToCluster(TNaviInfo tTxSignal)
   {
	   ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::vSendNaviWarningInfoToCluster Called"));
	   if(tTxSignal.list.size() > 0)
	   {
	     stNaviWarningInfo = tTxSignal;
	     PBYTE firstelement = &(stNaviWarningInfo.list[0]);
	     WORD length = stNaviWarningInfo.list.size();
	     warningInfoDataReqState = Pending;
	     if(naviCsmState == Idle)
	     {
               J1939NaviDataReq(NAVI_WARNING_INFO,firstelement,length);
	     }
	   }
   }
bool veda_tclClientVcanCanAdaptor::getTimerStatus()
{
	return timerStatus;
}
tVoid veda_tclClientVcanCanAdaptor::setTimerStatus(bool status)
{
	timerStatus = status;
}
tU8 veda_tclClientVcanCanAdaptor::getCurretActiveDataReqtype()
{
	return currentDataReqType;
}
tU8 veda_tclClientVcanCanAdaptor::getCabinACurrentActiveDataReqtype()
{
	return currentCabinADataReqType;
}
 tVoid veda_tclClientVcanCanAdaptor::CCS_J1939Nav_vCSMMsgCon( void * pvHandle, DWORD ulwProtocolType, const void * pvAddressField, BYTE ubTransferResult)
 {
	  ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::CCS_J1939Nav_vCSMMsgCon Received"));
	  adapterInstance->setNaviCsmState(Idle);
	   if(ubTransferResult == 0)
		 {
		    tU8 currentReqType = adapterInstance->getCurretActiveDataReqtype();
			if(currentReqType == NAVI_CURRENT_STREET_INFO)
			{
				if(adapterInstance->getNaviTurnToStreetInfoReqState() == Pending)
				{
					adapterInstance->SendPendingTurnToStreetInfo();
				}
				else if(adapterInstance->getDestinationInfoDataReqState() == Pending)
				{
					adapterInstance->SendPendingDestingnationInfo();
				}
				else if(adapterInstance->getTurnToSymbolsDataReqState() == Pending)
				{
					adapterInstance->SendPendingTurnToSymbolsInfo();
				}
				else if(adapterInstance->getNaviLaneGuidanceReqState() == Pending)
				{
					adapterInstance->SendPendingNaviLaneGuidanceInfo();
				}
				else if(adapterInstance->getNaviWarningInfoReqState() == Pending)
				{
					adapterInstance->SendPendingNaviWarningInfo();
				}
				else if(adapterInstance->getNaviCurrentStreetInfoReqState() == Pending)
				{
					adapterInstance->SendPendingCurrentStreetInfo();
				}
				else
				{
					//Do Nothing
				}
			}
			else if(currentReqType == NAVI_TURNTO_STREET_INFO)
			{
				if(adapterInstance->getNaviCurrentStreetInfoReqState() == Pending)
				{
					adapterInstance->SendPendingCurrentStreetInfo();
				}
				else if(adapterInstance->getDestinationInfoDataReqState() == Pending)
				{
					adapterInstance->SendPendingDestingnationInfo();
				}
				else if(adapterInstance->getTurnToSymbolsDataReqState() == Pending)
				{
					adapterInstance->SendPendingTurnToSymbolsInfo();
				}
				else if(adapterInstance->getNaviLaneGuidanceReqState() == Pending)
				{
					adapterInstance->SendPendingNaviLaneGuidanceInfo();
				}
				else if(adapterInstance->getNaviWarningInfoReqState() == Pending)
				{
					adapterInstance->SendPendingNaviWarningInfo();
				}
				else if(adapterInstance->getNaviTurnToStreetInfoReqState() == Pending)
				{
					adapterInstance->SendPendingTurnToStreetInfo();
					
				}
				else
				{
					//Do Nothing
				}
			}
			else if(currentReqType == NAVI_DESTINATION_INFO)
			{
				if(adapterInstance->getNaviTurnToStreetInfoReqState() == Pending)
				{
					adapterInstance->SendPendingTurnToStreetInfo();
				}
				else if(adapterInstance->getNaviCurrentStreetInfoReqState() == Pending)
				{
					adapterInstance->SendPendingCurrentStreetInfo();
				}
				else if(adapterInstance->getTurnToSymbolsDataReqState() == Pending)
				{
					adapterInstance->SendPendingTurnToSymbolsInfo();
				}
				else if(adapterInstance->getNaviLaneGuidanceReqState() == Pending)
				{
					adapterInstance->SendPendingNaviLaneGuidanceInfo();
				}
				else if(adapterInstance->getNaviWarningInfoReqState() == Pending)
				{
					adapterInstance->SendPendingNaviWarningInfo();
				}
				else if(adapterInstance->getDestinationInfoDataReqState() == Pending)
				{
					adapterInstance->SendPendingDestingnationInfo();
				}
				else
				{
					//Do Nothing
				}
			}
			else if(currentReqType == NAVI_TURNTO_SYMBOLS_INFO)
			{
				if(adapterInstance->getNaviCurrentStreetInfoReqState() == Pending)
				{
					adapterInstance->SendPendingCurrentStreetInfo();
				}
				else if(adapterInstance->getDestinationInfoDataReqState() == Pending)
				{
					adapterInstance->SendPendingDestingnationInfo();
				}
				else if(adapterInstance->getNaviTurnToStreetInfoReqState() == Pending)
				{
					adapterInstance->SendPendingTurnToStreetInfo();
				}
				else if(adapterInstance->getNaviLaneGuidanceReqState() == Pending)
				{
					adapterInstance->SendPendingNaviLaneGuidanceInfo();
				}
				else if(adapterInstance->getNaviWarningInfoReqState() == Pending)
				{
					adapterInstance->SendPendingNaviWarningInfo();
				}
				else if(adapterInstance->getTurnToSymbolsDataReqState() == Pending)
				{
					adapterInstance->SendPendingTurnToSymbolsInfo();
				}
				else
				{
					//Do Nothing
				}
			}
			else if(currentReqType == NAVI_LANEGUIDANCE_INFO)
			{
				if(adapterInstance->getNaviTurnToStreetInfoReqState() == Pending)
				{
					adapterInstance->SendPendingTurnToStreetInfo();
				}
				else if(adapterInstance->getDestinationInfoDataReqState() == Pending)
				{
					adapterInstance->SendPendingDestingnationInfo();
				}
				else if(adapterInstance->getTurnToSymbolsDataReqState() == Pending)
				{
					adapterInstance->SendPendingTurnToSymbolsInfo();
				}
				else if(adapterInstance->getNaviCurrentStreetInfoReqState() == Pending)
				{
					adapterInstance->SendPendingCurrentStreetInfo();
				}
				else if(adapterInstance->getNaviWarningInfoReqState() == Pending)
				{
					adapterInstance->SendPendingNaviWarningInfo();
				}
				else if(adapterInstance->getNaviLaneGuidanceReqState() == Pending)
				{
					adapterInstance->SendPendingNaviLaneGuidanceInfo();
				}
				else
				{
					//Do Nothing
				}
			}
			else if(currentReqType == NAVI_WARNING_INFO)
			{
				if(adapterInstance->getNaviCurrentStreetInfoReqState() == Pending)
				{
					adapterInstance->SendPendingCurrentStreetInfo();
				}
				else if(adapterInstance->getDestinationInfoDataReqState() == Pending)
				{
					adapterInstance->SendPendingDestingnationInfo();
				}
				else if(adapterInstance->getTurnToSymbolsDataReqState() == Pending)
				{
					adapterInstance->SendPendingTurnToSymbolsInfo();
				}
				else if(adapterInstance->getNaviLaneGuidanceReqState() == Pending)
				{
					adapterInstance->SendPendingNaviLaneGuidanceInfo();
				}
				else if(adapterInstance->getNaviTurnToStreetInfoReqState() == Pending)
				{
					adapterInstance->SendPendingTurnToStreetInfo();
				}
				else if(adapterInstance->getNaviWarningInfoReqState() == Pending)
				{
					adapterInstance->SendPendingNaviWarningInfo();
				}
				else
				{
					//Do Nothing
				}
			}
			else
	        {
		       if(false == adapterInstance->getTimerStatus())
               {
//                   adapterInstance->_bSetTimer_InputHandler(200);
               }
		    }
	}
 }
 tVoid veda_tclClientVcanCanAdaptor::CCS_J1939Nav_vCSMMsgReceived(void * pvHandle, DWORD ulwProtocolType, const void * pvAddressField, PBYTE pubData, WORD uwDataLength)
 {
 }
tVoid veda_tclClientVcanCanAdaptor::setMediaCsmState(csmState state)
{
		 ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::SetMediaCsmState called %d",state));
	         mediaCsmState = state;
}
tVoid veda_tclClientVcanCanAdaptor::setNaviCsmState(csmState state)
{
		 ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::setNaviCsmState called %d",state));
	     naviCsmState = state;
		
}
tVoid veda_tclClientVcanCanAdaptor::setCabinAMediaCsmState(csmState state)
{
	ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::setCabinAMediaCsmState called %d",state));
	mediaCabinACsmState = state;
}
tVoid veda_tclClientVcanCanAdaptor::setMediaInfoDataReqState(dataReqState state)
{
	ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::Received Media Data Request State is %d",state));
	mediaDataReqState = state;
}
tVoid veda_tclClientVcanCanAdaptor::setPhoneInfoDataReqState(dataReqState state)
{
	ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::Received Phone Info Data Request State is %d",state));
	phoneInfoDataReqState = state;
}
tVoid veda_tclClientVcanCanAdaptor::setPhoneCallDataReqState(dataReqState state)
{
	ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::Received Phone Call Data Request State is %d",state));
	phoneCallDataReqState = state;
}
tVoid veda_tclClientVcanCanAdaptor::setCabinADataReqState(dataReqState state)
{
       ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::SetCabinADataReqState State is %d",state));
       mediaCabADataReqState = state;
}


tVoid veda_tclClientVcanCanAdaptor::CCS_J1939CabinA_vCSMMsgCon( void * pvHandle, DWORD ulwProtocolType, const void * pvAddressField, BYTE ubTransferResult)
{
       ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::CCS_J1939CabinA_vCSMMsgCon Received"));
       adapterInstance->setCabinAMediaCsmState(Idle);
       tU8 currentReqType = adapterInstance->getCabinACurrentActiveDataReqtype();
       if(ubTransferResult == 0)
       {
        	 ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::CCS_J1939CabinA_vCSMMsgCon Success"));
       }
       else
       {
	   if(currentReqType == CABINAMEDIA)
	   {
               adapterInstance->setCabinADataReqState(Pending);
	   }
       }
}

tVoid veda_tclClientVcanCanAdaptor::CCS_J1939CabinA_vCSMMsgReceived(void * pvHandle, DWORD ulwProtocolType, const void * pvAddressField, PBYTE pubData, WORD uwDataLength)
{
}

     tVoid veda_tclClientVcanCanAdaptor::CCS_J1939_vCSMMsgReceived(void * pvHandle, DWORD ulwProtocolType, const void * pvAddressField, PBYTE pubData, WORD uwDataLength)
     {
     }
     tVoid veda_tclClientVcanCanAdaptor::CCS_J1939_vCSMMsgCon( void * pvHandle, DWORD ulwProtocolType, const void * pvAddressField, BYTE ubTransferResult)
     {
		 ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::CCS_J1939_vCSMMsgCon Received"));
	        
                 adapterInstance->setMediaCsmState(Idle);
		       tU8 currentReqType = adapterInstance->getCurretActiveDataReqtype();
		 if(ubTransferResult == 0)
		 {
	         #ifdef PRIORITY_HANDLING
		       tU8 currentReqType = adapterInstance->getCurretActiveDataReqtype();
		       
                       if(currentReqType == MEDIA)
		       {
	                  if(adapterInstance->getPhoneCallDataReqState() == Pending)
                          {
                             adapterInstance->SendPendingCallInfo();
                          }
                          if(adapterInstance->getPhoneInfoDataReqState() == Pending)
                          {
                             adapterInstance->SendPendingPhoneInfo();
                          }
			  if(adapterInstance->getMediaInfoDataReqState() == Pending)
			  {
                             adapterInstance->SendPendingMediaInfo();
			  }
		       }
                       else if(currentReqType == PHONECALL)
                       {
                          if(adapterInstance->getPhoneInfoDataReqState() == Pending)
			  {
                             adapterInstance->SendPendingPhoneInfo();
			  }
			  if(adapterInstance->getMediaInfoDataReqState() == Pending)
			  {
                             adapterInstance->SendPendingMediaInfo();
			  }
	                  if(adapterInstance->getPhoneCallDataReqState() == Pending)
			  {
                             adapterInstance->SendPendingCallInfo();
			  }
                       }
		       else if(currentReqType == PHONEINFO)
		       {
			  if(adapterInstance->getPhoneCallDataReqState() == Pending)
                          {
                             adapterInstance->SendPendingCallInfo();
                          }
			  if(adapterInstance->getMediaInfoDataReqState() == Pending)
			  {
                             adapterInstance->SendPendingMediaInfo();
			  }
                          if(adapterInstance->getPhoneInfoDataReqState() == Pending)
			  {
                             adapterInstance->SendPendingPhoneInfo();
			  }

		       }
                       else
                       {
                          //       //Do nothing
                       }
                    #endif


		 }
		 else
		 {
			 if(currentReqType == MEDIA)
			 {
				 adapterInstance->setMediaInfoDataReqState(Pending);
			 }
			 else if(currentReqType == PHONECALL)
			 {
				 adapterInstance->setPhoneCallDataReqState(Pending);
			 }
			 else if(currentReqType == PHONEINFO)
			 {
				 adapterInstance->setPhoneInfoDataReqState(Pending);
			 }
			 else
			 {
				//Do Nothing
			 }

		 }
     }
	tVoid veda_tclClientVcanCanAdaptor::SendPendingCurrentStreetInfo()
	{
		ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::SendPendingCurrentStreetInfo Called"));
		PBYTE firstelement = &(stStreetInfo.list[0]);
	     WORD length = stStreetInfo.list.size();
		 currentstreetDataReqState = Pending;
		 if(naviCsmState == Idle)
		 {
	
	         J1939NaviDataReq(NAVI_CURRENT_STREET_INFO,firstelement,length);
		 }

	}
	tVoid veda_tclClientVcanCanAdaptor::SendPendingTurnToStreetInfo()
	{
		ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::SendPendingTurnToStreetInfo Called"));
		PBYTE firstelement = &(stTurntoStreetInfo.list[0]);
	     WORD length = stTurntoStreetInfo.list.size();
		 turntoStreetDataReqState = Pending;
		 if(naviCsmState == Idle)
		 {
	
	         J1939NaviDataReq(NAVI_TURNTO_STREET_INFO,firstelement,length);
		 }
		
	}
	tVoid veda_tclClientVcanCanAdaptor::SendPendingDestingnationInfo()
	{
	   ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::SendPendingDestingnationInfo Called"));
	   PBYTE firstelement = &(stDestinatioInfo.list[0]);
	     WORD length = stDestinatioInfo.list.size();
		 destinationInfoDataReqState = Pending;
		 if(naviCsmState == Idle)
		 {
	
	         J1939NaviDataReq(NAVI_DESTINATION_INFO,firstelement,length);
		 }
	}
	tVoid veda_tclClientVcanCanAdaptor::SendPendingTurnToSymbolsInfo()
	{
		ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::SendPendingTurnToSymbolsInfo Called"));
		PBYTE firstelement = &(stTurnToSymbolsInfo.list[0]);
	     WORD length = stTurnToSymbolsInfo.list.size();
		 turntoSymbolsDataReqState = Pending;
		 if(naviCsmState == Idle)
		 {
	
	         J1939NaviDataReq(NAVI_TURNTO_SYMBOLS_INFO,firstelement,length);
		 }
	}
	tVoid veda_tclClientVcanCanAdaptor::SendPendingNaviLaneGuidanceInfo()
	{
		ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::SendPendingNaviLaneGuidanceInfo Called"));
		PBYTE firstelement = &(stLaneGuidanceInfo.list[0]);
	     WORD length = stLaneGuidanceInfo.list.size();
		 laneGuidanceInfoDataReqState = Pending;
		 if(naviCsmState == Idle)
		 {
	
	         J1939NaviDataReq(NAVI_LANEGUIDANCE_INFO,firstelement,length);
		 }
	}
	tVoid veda_tclClientVcanCanAdaptor::SendPendingNaviWarningInfo()
	{
		ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::SendPendingNaviWarningInfo Called"));
		PBYTE firstelement = &(stNaviWarningInfo.list[0]);
	     WORD length = stNaviWarningInfo.list.size();
		 warningInfoDataReqState = Pending;
		 if(naviCsmState == Idle)
		 {
	
	         J1939NaviDataReq(NAVI_WARNING_INFO,firstelement,length);
		 }
	}
   dataReqState veda_tclClientVcanCanAdaptor::getNaviCurrentStreetInfoReqState()
   {
	   return currentstreetDataReqState;
   }
   dataReqState veda_tclClientVcanCanAdaptor::getNaviTurnToStreetInfoReqState()
   {
	   return turntoStreetDataReqState;
   }
   dataReqState veda_tclClientVcanCanAdaptor::getDestinationInfoDataReqState()
   {
	   return destinationInfoDataReqState;
   }
   dataReqState veda_tclClientVcanCanAdaptor::getTurnToSymbolsDataReqState()
   {
	   return turntoSymbolsDataReqState;
   }
   dataReqState veda_tclClientVcanCanAdaptor::getNaviLaneGuidanceReqState()
   {
	   return laneGuidanceInfoDataReqState;
   }
   dataReqState veda_tclClientVcanCanAdaptor::getNaviWarningInfoReqState()
   {
	   return warningInfoDataReqState;
   }
   

	tVoid veda_tclClientVcanCanAdaptor::SendPendingMediaInfo()
	 {
		 ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::SendPendingMediaInfo Called"));
		 PBYTE firstelement = &(stMediaInfo.list[0]);
	     WORD length = stMediaInfo.list.size();
		 mediaDataReqState = Pending;
		 if(mediaCsmState == Idle)
		 {
	
	         J1939DataReq(MEDIA,firstelement,length);
		 }
	 }
	 tVoid veda_tclClientVcanCanAdaptor::SendPendingCallInfo()
	 {
		 ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::SendPendingCallInfo Called"));
		 PBYTE firstelement = &(stCallInfo.list[0]);
	     WORD length = stCallInfo.list.size();
		 phoneCallDataReqState = Pending;
		 if(mediaCsmState == Idle)
		 {
			
	         J1939DataReq(PHONECALL,firstelement,length);
		 }
	 }
	 tVoid veda_tclClientVcanCanAdaptor::SendPendingPhoneInfo()
	 {
		 ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::SendPendingPhoneInfo Called"));
		 PBYTE firstelement = &(stPhoneInfo.list[0]);
	     WORD length = stPhoneInfo.list.size();
	     phoneInfoDataReqState = Pending;
	     if(mediaCsmState == Idle)
	     {
			
	         //J1939DataReq(PHONEINFO,firstelement,(stPhoneInfo.list.size() > 21) ? 21:stPhoneInfo.list.size());
	         J1939DataReq(PHONEINFO,firstelement,length);
	     }
	 }
         tVoid veda_tclClientVcanCanAdaptor::J1939CabinADataReq(tU8 currentactivedata,PBYTE pubData, WORD uwDataLength)
         {
	       ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::J1939CabinADataReq Called"));
	       tU32 dwProtocolType;
//        tU8 abAddressField[2];//address field needs to be filled
           tU8 csmhandle;
	   void* csmhandl = &csmhandle;
            dwProtocolType = CSM_C_PTYPE_J1939;
            currentCabinADataReqType = currentactivedata;
	    mediaCabinACsmState = WaitForConf;
            mediaCabADataReqState = Sent;

	    tS32 s32retVal = _poMyCSMInterface->CSM_lDataReq(csmhandl, dwProtocolType,(const void*)&abJ1939CabAAddr,pubData,uwDataLength);
	    if(s32retVal == 0)       //Success case
            {
                 ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::J1939CabinADataReq Return is Success"));
	    }
	    else
	    {
                 ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::J1939CabinADataReq Return Failed"));
		 mediaCabinACsmState = Idle;
                 mediaCabADataReqState = Pending;
 
	    }
         }
	 tVoid veda_tclClientVcanCanAdaptor::J1939NaviDataReq(tU8 currentactivedata,PBYTE pubData, WORD uwDataLength)   
	 {
		ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::J1939NaviDataReq Called"));
		 tU32 dwProtocolType;
		 tU8 csmhandle;
		 void* csmhandl = &csmhandle;
		 dwProtocolType = CSM_C_PTYPE_J1939;
		 currentNaviDataReqType = currentactivedata;
		 naviCsmState = WaitForConf;
		 if(currentNaviDataReqType == NAVI_CURRENT_STREET_INFO)
                 {
                        currentstreetDataReqState = Sent;
                        printNaviData();
                 }
                 else if(currentNaviDataReqType == NAVI_TURNTO_STREET_INFO)
                 {
                        turntoStreetDataReqState = Sent;
                        printNaviData();
                 }
                 else if(currentNaviDataReqType == NAVI_DESTINATION_INFO)
                 {
                       destinationInfoDataReqState = Sent;
                       printNaviData();
                 }
                 else if(currentNaviDataReqType == NAVI_TURNTO_SYMBOLS_INFO)
                 {
                       turntoSymbolsDataReqState = Sent;
                       printNaviData();
                 }
                 else if(currentNaviDataReqType == NAVI_LANEGUIDANCE_INFO)
                 {
                      laneGuidanceInfoDataReqState = Sent;
                      printNaviData();
                 }
                 else if(currentNaviDataReqType == NAVI_WARNING_INFO)
                 {
                      warningInfoDataReqState = Sent;
                      printNaviData();
                 }
                 else
                 {
                     //Do Nothing
                 }

		 tS32 s32retVal = _poMyCSMInterface->CSM_lDataReq(csmhandl, dwProtocolType,(const void*)&abJ1939NavAddr, pubData, uwDataLength);//return handling is required

	   if(s32retVal == 0)       //Success case
	   {
		    ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::J1939NaviDataReq Return is Success"));
	   }
	   else
	   {
		    ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::J1939NaviDataReq Return Failed"));
		    naviCsmState = Idle;
		    if(currentNaviDataReqType == NAVI_CURRENT_STREET_INFO)
                    {
                        currentstreetDataReqState = Pending;
                    }
                    else if(currentNaviDataReqType == NAVI_TURNTO_STREET_INFO)
                    {
                        turntoStreetDataReqState = Pending;
                    }
                   else if(currentNaviDataReqType == NAVI_DESTINATION_INFO)
                   {
                       destinationInfoDataReqState = Pending;
                   }
                   else if(currentNaviDataReqType == NAVI_TURNTO_SYMBOLS_INFO)
                   {
                       turntoSymbolsDataReqState = Pending;
                   }
                   else if(currentNaviDataReqType == NAVI_LANEGUIDANCE_INFO)
                   {
                      laneGuidanceInfoDataReqState = Pending;
                   }
                   else if(currentNaviDataReqType == NAVI_WARNING_INFO)
                   {
                      warningInfoDataReqState = Pending;
                   }
                   else
                   {
                     //Do Nothing
                   }

	   }
	 }
     tVoid veda_tclClientVcanCanAdaptor::J1939DataReq(tU8 currentactivedata,PBYTE pubData, WORD uwDataLength)     
     {
		 ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::J1939DataReq Called"));

	    tU32 dwProtocolType;
//        tU8 abAddressField[2];//address field needs to be filled
	   tU8 csmhandle;
	   void* csmhandl = &csmhandle;
	    dwProtocolType = CSM_C_PTYPE_J1939;
	    currentDataReqType = currentactivedata;
		
		//check for State Machine
		   mediaCsmState = WaitForConf;
		     if(currentDataReqType == MEDIA)
                   {
                      print();
                      mediaDataReqState = Sent;
                   }
                   else if(currentDataReqType == PHONECALL)
                   {
                           print();
                           phoneCallDataReqState = Sent;
                   }
                   else if(currentDataReqType == PHONEINFO)
                   {
                           print();
                           phoneInfoDataReqState = Sent;
                   }
                   else
                   {
                           //Do nothing
                   }

       tS32 s32retVal = _poMyCSMInterface->CSM_lDataReq(csmhandl, dwProtocolType,(const void*)&abJ1939Addr, pubData, uwDataLength);//return handling is required

	   if(s32retVal == 0)       //Success case
	   {
		 ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::J1939DataReq Return is Success"));

	   }
	   else
	   {
		 ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::J1939DataReq Return Failed"));
		   mediaCsmState = Idle;
		    if(currentDataReqType == MEDIA)
			 {
				mediaDataReqState =  Pending;
			 }
			 else if(currentDataReqType == PHONECALL)
			 {
				phoneCallDataReqState =  Pending;
			 }
			 else if(currentDataReqType == PHONEINFO)
			 {
				phoneInfoDataReqState = Pending;
			 }
			 else
			 {
				//Do Nothing
			 }
		   //start the timer for 200 ms
//
	   }
     }

tVoid veda_tclClientVcanCanAdaptor::vSendMeidaDataToCluster(vehicle_fi_tcl_CAN_Mesg msg)
{
    ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::vSendMediaData to Cluster"));
    if(msg.listData.size() > 0)
    {
     stMediaInfo.u8txtype = msg.u8MediaType;
     stMediaInfo.list  = msg.listData;
     PBYTE firstelement = &(stMediaInfo.list[0]);
     WORD length = msg.listData.size();
     mediaDataReqState = Pending;
     ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::vSendMediaInfoToCluster MediaCsmState is %d",mediaCsmState));
     if(mediaCsmState == Idle)
     {
         ETG_TRACE_USR1(("Calling J1939 "));
         J1939DataReq(MEDIA,firstelement,length);
     }
    }
}
tVoid veda_tclClientVcanCanAdaptor::print()
{

    ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::Entered Print"));
    bpstl::vector<tU8>::iterator ptr;
    bpstl::vector<tU8> currentList;
    tU8 currentReqType = adapterInstance->getCurretActiveDataReqtype();
    if(currentReqType == MEDIA)
    {
	    currentList = stMediaInfo.list;
            ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::Current list is of Media type"));
    }
    else if(currentReqType == PHONECALL)
    {
	    currentList = stCallInfo.list;
            ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::Current list is of Phone call type"));
    }
    else if(currentReqType == PHONEINFO)
    {
	    currentList = stPhoneInfo.list;
            ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::Current list is of Phone Info type"));
    }
    else
    {
	    //Do Nothing
    }
    ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::Current List size is %d",currentList.size()));
    if(currentList.size() > 0)
    {
	BYTE* pu8Data = &(currentList[0]); 
	DWORD u32Length = currentList.size();
	ETG_TRACE_USR3(("CurrentList Data - Len:0x%04X  Data:0x%02X", u32Length, ETG_LIST_LEN(u32Length), ETG_LIST_PTR_T8(pu8Data) ));
	/*for(ptr = currentList.begin(); ptr < currentList.end(); ptr++)
	{
	    	
           ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::Content of list is  %d",*ptr));
	}*/
    }
}
tVoid veda_tclClientVcanCanAdaptor::printNaviData()
{
    ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::Entered PrintNaviData"));
    bpstl::vector<tU8>::iterator ptr;
    bpstl::vector<tU8> currentList;
    if(currentNaviDataReqType   == NAVI_CURRENT_STREET_INFO)
    {
	    currentList = stStreetInfo.list;
    
    }
    else if(currentNaviDataReqType  == NAVI_TURNTO_STREET_INFO)
    {
           currentList = stTurntoStreetInfo.list;
    }
    else if(currentNaviDataReqType == NAVI_DESTINATION_INFO)
    {
          currentList = stDestinatioInfo.list;
    }
    else if(currentNaviDataReqType == NAVI_TURNTO_SYMBOLS_INFO)
    {
          currentList = stTurnToSymbolsInfo.list;
    }
    else if(currentNaviDataReqType == NAVI_LANEGUIDANCE_INFO)
    {
         currentList = stLaneGuidanceInfo.list;
    }
    else if(currentNaviDataReqType == NAVI_WARNING_INFO)
    {
        currentList = stNaviWarningInfo.list;
    }
    else
    {
         //Do Nothing
    }
    ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::Current Navi List size is %d",currentList.size()));
    if(currentList.size() > 0)
    {
        BYTE* pu8Data = &(currentList[0]);
        DWORD u32Length = currentList.size();
        ETG_TRACE_USR3(("Current Navi List Data - Len:0x%04X  Data:0x%02X", u32Length, ETG_LIST_LEN(u32Length), ETG_LIST_PTR_T8(pu8Data) ));
    }



}

tVoid veda_tclClientVcanCanAdaptor::vSendCallDataToCluster(vehicle_fi_tcl_CAN_Mesg msg)
{
	   ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::vSendCallDataToCluster Called"));
	 if(msg.listData.size() > 0)
	 {
	  stCallInfo.u8txtype = msg.u8MediaType;
         stCallInfo.list  = msg.listData;
             PBYTE firstelement = &(stCallInfo.list[0]);
             WORD length = stCallInfo.list.size();
                 phoneCallDataReqState = Pending;
                 if(mediaCsmState == Idle)
                 {

                 J1939DataReq(PHONECALL,firstelement,length);
                 }
	 }

}
tVoid veda_tclClientVcanCanAdaptor:: vSendPhoneDataToCluster(vehicle_fi_tcl_CAN_Mesg msg)
{
	 ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::vSendPhoneDataToCluster Called"));
	 if(msg.listData.size() > 0)
	 {
	   stPhoneInfo.u8txtype = msg.u8MediaType;
	   stPhoneInfo.list = msg.listData;
	   PBYTE firstelement = &(stPhoneInfo.list[0]);
	   WORD length = stPhoneInfo.list.size();
	   phoneInfoDataReqState = Pending;
	   if(mediaCsmState == Idle)
	   {

	         J1939DataReq(PHONEINFO,firstelement,length);
	   }
	 }
}
tVoid veda_tclClientVcanCanAdaptor::vSendCabinAMeidaDataToCluster(vehicle_fi_tcl_CAN_Mesg msg)
{
    ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::vSendCabinAMeidaDataToCluster Called"));
    if(msg.listData.size() > 0)
    {
      stCabinAMediaInfo.u8txtype = msg.u8MediaType;
        stCabinAMediaInfo .list  = msg.listData;
    PBYTE firstelement = &(stCabinAMediaInfo.list[0]);
    WORD length = stCabinAMediaInfo.list.size();
    mediaCabADataReqState = Pending;
    ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::vSendCabinAMediaDataToCluster mediaCabinACsmState is %d",mediaCabinACsmState));
    if(mediaCabinACsmState == Idle)
    {
         ETG_TRACE_USR1(("Calling J1939 for CabinA"));
         J1939CabinADataReq(CABINAMEDIA,firstelement,length);
    }
    }

}
tVoid veda_tclClientVcanCanAdaptor::SendPendingCabinAMeidaDataToCluster()
{
    ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::SendPendingCabinAMeidaDataToCluster Called"));
    PBYTE firstelement = &(stCabinAMediaInfo.list[0]);
    WORD length = stCabinAMediaInfo.list.size();
    mediaCabADataReqState = Pending;
    ETG_TRACE_USR1(("veda_tclClientVcanCanAdaptor::SendPendingCabinAMeidaDataToCluster mediaCabinACsmState is %d",mediaCabinACsmState));
    if(mediaCabinACsmState == Idle)
    {
         ETG_TRACE_USR1(("Calling Pending J1939 for CabinA"));
         J1939CabinADataReq(CABINAMEDIA,firstelement,length);
    }
}

    //Cam1ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam1ManAct(TCam1ManAct tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.Cam1ManAct, 1, CSM_C_SIG_TX_Camera1_Status_Camera_Status, tTxSignal.u8TxType);
	}
	//Cam2ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam2ManAct(TCam2ManAct tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.Cam2ManAct, 1, CSM_C_SIG_TX_Camera2_Status_Camera_Status, tTxSignal.u8TxType);
	}
	//Cam3ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam3ManAct(TCam3ManAct tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.Cam3ManAct, 1, CSM_C_SIG_TX_Camera3_Status_Camera_Status, tTxSignal.u8TxType);
	}
	//Cam4ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam4ManAct(TCam4ManAct tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.Cam4ManAct, 1, CSM_C_SIG_TX_Camera4_Status_Camera_Status, tTxSignal.u8TxType);
	}
	//Cam5ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam5ManAct(TCam5ManAct tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.Cam5ManAct, 1, CSM_C_SIG_TX_Camera5_Status_Camera_Status, tTxSignal.u8TxType);
	}
	//Cam6ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam6ManAct(TCam6ManAct tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.Cam6ManAct, 1, CSM_C_SIG_TX_Camera6_Status_Camera_Status, tTxSignal.u8TxType);
	}
	//Cam7ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam7ManAct(TCam7ManAct tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.Cam7ManAct, 1, CSM_C_SIG_TX_Camera7_Status_Camera_Status, tTxSignal.u8TxType);
	}
	//Cam8ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam8ManAct(TCam8ManAct tTxSignal){
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vSendCam8ManAct(): Called!. The Value= %d,", tTxSignal.Cam8ManAct));
		vSendCsmBroadcastSignal(&tTxSignal.Cam8ManAct, 1, CSM_C_SIG_TX_Camera8_Status_Camera_Status, tTxSignal.u8TxType);
	}
	//Cam9ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam9ManAct(TCam9ManAct tTxSignal){
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vSendCam9ManAct(): Called!. The Value= %d,", tTxSignal.Cam9ManAct));
		vSendCsmBroadcastSignal(&tTxSignal.Cam9ManAct, 1, CSM_C_SIG_TX_Camera9_Status_Camera_Status, tTxSignal.u8TxType);
	}
	//Cam10ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam10ManAct(TCam10ManAct tTxSignal){
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vSendCam10ManAct(): Called!. The Value= %d,", tTxSignal.Cam10ManAct));
		vSendCsmBroadcastSignal(&tTxSignal.Cam10ManAct, 1, CSM_C_SIG_TX_Camera10_Status_Camera_Status, tTxSignal.u8TxType);
	}
	//Cam11ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam11ManAct(TCam11ManAct tTxSignal){
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vSendCam11ManAct(): Called!. The Value= %d,", tTxSignal.Cam11ManAct));
		vSendCsmBroadcastSignal(&tTxSignal.Cam11ManAct, 1, CSM_C_SIG_TX_Camera11_Status_Camera_Status, tTxSignal.u8TxType);
	}
	//Cam12ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam12ManAct(TCam12ManAct tTxSignal){
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vSendCam12ManAct(): Called!. The Value= %d,", tTxSignal.Cam12ManAct));
		vSendCsmBroadcastSignal(&tTxSignal.Cam12ManAct, 1, CSM_C_SIG_TX_Camera12_Status_Camera_Status, tTxSignal.u8TxType);
	}
     //Cam13ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam13ManAct(TCam13ManAct tTxSignal){
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vSendCam13ManAct(): Called!. The Value= %d,", tTxSignal.Cam13ManAct));
		vSendCsmBroadcastSignal(&tTxSignal.Cam13ManAct, 1, CSM_C_SIG_TX_Camera13_Status_Camera_Status, tTxSignal.u8TxType);
	}
	//Cam14ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam14ManAct(TCam14ManAct tTxSignal){
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vSendCam14ManAct(): Called!. The Value= %d,", tTxSignal.Cam14ManAct));
		vSendCsmBroadcastSignal(&tTxSignal.Cam14ManAct, 1, CSM_C_SIG_TX_Camera14_Status_Camera_Status, tTxSignal.u8TxType);
	}
	//Cam15ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam15ManAct(TCam15ManAct tTxSignal){
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vSendCam15ManAct(): Called!. The Value= %d,", tTxSignal.Cam15ManAct));
		vSendCsmBroadcastSignal(&tTxSignal.Cam15ManAct, 1, CSM_C_SIG_TX_Camera15_Status_Camera_Status, tTxSignal.u8TxType);
	}
		//Cam16ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam16ManAct(TCam16ManAct tTxSignal){
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vSendCam16ManAct(): Called!. The Value= %d,", tTxSignal.Cam16ManAct));
		vSendCsmBroadcastSignal(&tTxSignal.Cam16ManAct, 1, CSM_C_SIG_TX_Camera16_Status_Camera_Status, tTxSignal.u8TxType);
	}
		//Cam17ManAct
	tVoid veda_tclClientVcanCanAdaptor::vSendCam17ManAct(TCam17ManAct tTxSignal){
		ETG_TRACE_USR4(("veda_tclClientVcanCanAdaptor::vSendCam17ManAct(): Called!. The Value= %d,", tTxSignal.Cam17ManAct));
		vSendCsmBroadcastSignal(&tTxSignal.Cam17ManAct, 1, CSM_C_SIG_TX_Camera17_Status_Camera_Status, tTxSignal.u8TxType);
	}
	//PrivacyResetAck
	tVoid veda_tclClientVcanCanAdaptor::vSendPrivacyResetAck(TPrivacyResetAck tTxSignal) {
		
    }
	//DispCamCls
	tVoid veda_tclClientVcanCanAdaptor::vSendDispCamCls(TDispCamCls tTxSignal) {
		
    }
	//PhoneBTLinkStatus
	tVoid veda_tclClientVcanCanAdaptor::vSendPhoneBTLinkStatus(TPhoneBTLinkStatus tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.BTLinkStatus, 1, CSM_C_SIG_TX_BTlinkStatus_PhoneStatus, tTxSignal.u8TxType);
	}
	//PhoneBookSyncstatus  
	tVoid veda_tclClientVcanCanAdaptor::vSendPhoneBookSyncstatus(TPhoneBookSyncStatus tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.PhoneBookSyncStatusValue, 1, CSM_C_SIG_TX_PhonebookSyncStatus_PhoneStatus, tTxSignal.u8TxType);
	}
	//CallHistorySyncStatus  
	tVoid veda_tclClientVcanCanAdaptor::vSendCallHistorySyncStatus(TCallHistorySyncStatus tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.CallHistorySyncStatusValue, 1, CSM_C_SIG_TX_CallHistorySyncStatus_PhoneStatus, tTxSignal.u8TxType);
	}
	//PhoneStatusRoaming  
	tVoid veda_tclClientVcanCanAdaptor::vSendPhoneStatusRoaming(TPhoneStatusRoaming tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.PhoneStatusRoamingValue, 1, CSM_C_SIG_TX_Roaming_PhoneStatus, tTxSignal.u8TxType);
	}
	//CallDuration  
	tVoid veda_tclClientVcanCanAdaptor::vSendCallDuration(TCallDuration tTxSignal){
		vSendCsmBroadcastSignal((tU8*)&tTxSignal.CallDurationValue, 2, CSM_C_SIG_TX_CallDuration_PhoneStatus, tTxSignal.u8TxType);
	}
	//GSMSignalStrength  
	tVoid veda_tclClientVcanCanAdaptor::vSendGSMSignalStrength(TGSMSignalStrength tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.GSMSignalStrengthValue, 1, CSM_C_SIG_TX_GSMFieldstrength_PhoneStatus, tTxSignal.u8TxType);
	}
	//PhoneCallStatus  
	tVoid veda_tclClientVcanCanAdaptor::vSendPhoneCallStatus(TPhoneCallStatus tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.CallStatusValue, 1, CSM_C_SIG_TX_CallStatus_PhoneStatus, tTxSignal.u8TxType);
	}
	//PhoneBatteryLevelStatus  
	tVoid veda_tclClientVcanCanAdaptor::vSendPhoneBatteryLevelStatus(TPhoneBatteryLevelStatus tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.PhoneBatteryLevelStatusValue, 1, CSM_C_SIG_TX_PhoneBatteryLevel_PhoneStatus, tTxSignal.u8TxType);
	}
	//DeviceStatusWifiAvailable  
	tVoid veda_tclClientVcanCanAdaptor::vSendDeviceStatusWifiAvailable(TDeviceStatusWifiAvailable tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.DeviceStatusWifiStatus, 1, CSM_C_SIG_TX_Wifi_Avail_DeviceStatus, tTxSignal.u8TxType);
	}
	//MediaStatusAudioSource  
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusAudioSource(TMediaStatusAudioSource tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.AudioSource, 1, CSM_C_SIG_TX_AudioSource_MediaStatus1, tTxSignal.u8TxType);
	}
	//PhoneAvailableStatus  
	tVoid veda_tclClientVcanCanAdaptor::vSendPhoneAvailableStatus(TPhoneAvailableStatus tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.PhoneAvailableStatusValue, 1, CSM_C_SIG_TX_Phone_Avail_DeviceStatus, tTxSignal.u8TxType);
	}
		//PhoneVRAvailable 
	tVoid veda_tclClientVcanCanAdaptor::vSendPhoneVRAvailable(TPhoneVRAvailable tTxSignal){
	vSendCsmBroadcastSignal(&tTxSignal.PhoneVRAvailableValue, 1, CSM_C_SIG_TX_Phone_VR_Avail_DeviceStatus, tTxSignal.u8TxType);
		
	}

	//DeviceStatusBTStatus  
	tVoid veda_tclClientVcanCanAdaptor::vSendDeviceStatusBTStatus(TDeviceStatusBTStatus tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.DeviceStatusBTStatusValue, 1, CSM_C_SIG_TX_BluetoothStatus_DeviceStatus, tTxSignal.u8TxType);
	}
	//DeviceStatusBluetoothAvail  
	tVoid veda_tclClientVcanCanAdaptor::vSendDeviceStatusBluetoothAvail(TDeviceStatusBluetoothAvail tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.DeviceStatusBluetoothAvailValue, 1, CSM_C_SIG_TX_SourceBluetooth_Avail_DeviceStatus, tTxSignal.u8TxType);
	}	
	//Req_DeviceInfo  
	tVoid veda_tclClientVcanCanAdaptor::vSendReq_DeviceInfo(TReq_DeviceInfo tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.Req_DeviceInfoValue, 1, CSM_C_SIG_TX_Req_DeviceInformation_Req_DeviceInformation, tTxSignal.u8TxType);
	}
	//MediaStatusVolume  
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusVolume(TMediaStatusVolume tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.volume, 1, CSM_C_SIG_TX_Volume_MediaStatus1, tTxSignal.u8TxType);
	}
	//CabinMediaStatusAudioSource  
	tVoid veda_tclClientVcanCanAdaptor::vSendCabinMediaStatusAudioSource(TCabinMediaStatusAudioSource tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.CabinAudioSource, 1, CSM_C_SIG_TX_CabinAudioSource_CabinMedia_Status, tTxSignal.u8TxType);
	}
	//CabinMediaStatusTunerBand  
	tVoid veda_tclClientVcanCanAdaptor::vSendCabinMediaStatusTunerBand(TCabinMediaStatusTunerBand tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.CabinMediaStatusTunerBandValue, 1, CSM_C_SIG_TX_TunerBand_CabinMedia_Status, tTxSignal.u8TxType);
	}
	//CabinMediaStatusVolume  
	tVoid veda_tclClientVcanCanAdaptor::vSendCabinMediaStatusVolume(TCabinMediaStatusVolume tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.CabinVolume, 1, CSM_C_SIG_TX_Cabin_vol_CabinMedia_Status, tTxSignal.u8TxType);
	}
	//MediaStatusMuteStatus  
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusMuteStatus(TMediaStatusMuteStatus tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.MediaStatusMuteValue, 1, CSM_C_SIG_TX_MuteStatus_MediaStatus1, tTxSignal.u8TxType);
	}
	//CabinMediaStatusMuteStatus  
	tVoid veda_tclClientVcanCanAdaptor::vSendCabinMediaStatusMuteStatus(TCabinMediaStatusMuteStatus tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.CabinMediaStatusMuteValue, 1, CSM_C_SIG_TX_CabinMute_Status_CabinMedia_Status, tTxSignal.u8TxType);
	}
	//MediaStatusPlayStatus  
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusPlayStatus(TMediaStatusPlayStatus tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.MediaStatusPlayStatusValue, 1, CSM_C_SIG_TX_PlayState_MediaStatus2, tTxSignal.u8TxType);
	}
	//MediaStatusMixState  
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusMixState(TMediaStatusMixState tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.MediaStatusMixStateValue, 1, CSM_C_SIG_TX_MixState_MediaStatus2, tTxSignal.u8TxType);
	}
	//MediaStatusPlaylistMode  
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusPlaylistMode(TMediaStatusPlaylistMode tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.MediaStatusPlaylistModeValue, 1, CSM_C_SIG_TX_PlaylistMode_MediaStatus2, tTxSignal.u8TxType);
	}	
	//MediaStatusTrackTime  
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusTrackTime(TMediaStatusTrackTime tTxSignal){
		vSendCsmBroadcastSignal((tU8*)&tTxSignal.MediaStatusTrackTimeValue, 2, CSM_C_SIG_TX_TrackTime_MediaStatus2, tTxSignal.u8TxType);
	}	
	//MediaStatusCurrTrackNum  
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusCurrTrackNum(TMediaStatusCurrTrackNum tTxSignal){
		vSendCsmBroadcastSignal((tU8*)&tTxSignal.MediaStatusCurrTrackNumValue, 2, CSM_C_SIG_TX_CurrTrackNum_MediaStatus2, tTxSignal.u8TxType);
	}
	//DeviceStatusRadioStatus  
	tVoid veda_tclClientVcanCanAdaptor::vSendDeviceStatusRadioStatus(TDeviceStatusRadioStatus tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.DeviceStatusRadioStatusValue, 1, CSM_C_SIG_TX_Radio_Status_DeviceStatus, tTxSignal.u8TxType);
	}
	//DeviceStatusDABAvailStatus  
	tVoid veda_tclClientVcanCanAdaptor::vSendDeviceStatusDABAvailStatus(TDeviceStatusDABAvailStatus tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.DeviceStatusDABAvailStatusValue, 1, CSM_C_SIG_TX_SourceDAB_Avail_DeviceStatus, tTxSignal.u8TxType);
	}
	//DeviceStatusNavData  
	tVoid veda_tclClientVcanCanAdaptor::vSendDeviceStatusNavData(TDeviceStatusNavData tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.DeviceStatusNavDataValue, 1, CSM_C_SIG_TX_NavData_Present_DeviceStatus, tTxSignal.u8TxType);
	}
	//DeviceStatusUSB1Present  
	tVoid veda_tclClientVcanCanAdaptor::vSendDeviceStatusUSB1Present(TDeviceStatusUSB1Present tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.DeviceStatusUSB1PresentValue, 1, CSM_C_SIG_TX_USB1_Present_DeviceStatus, tTxSignal.u8TxType);
	}	
	//DeviceStatusUSB2Present  
	tVoid veda_tclClientVcanCanAdaptor::vSendDeviceStatusUSB2Present(TDeviceStatusUSB2Present tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.DeviceStatusUSB2PresentValue, 1, CSM_C_SIG_TX_USB2_Present_DeviceStatus, tTxSignal.u8TxType);
	}	
	//DeviceStatusNaviAvail  
	tVoid veda_tclClientVcanCanAdaptor::vSendDeviceStatusNaviAvail(TDeviceStatusNaviAvail tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.DeviceStatusNaviAvailValue, 1, CSM_C_SIG_TX_Navigation_Avail_DeviceStatus, tTxSignal.u8TxType);
	}	
	//DeviceStatusUSB1Src  
	tVoid veda_tclClientVcanCanAdaptor::vSendDeviceStatusUSB1Src(TDeviceStatusUSB1Src tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.DeviceStatusUSB1SrcValue, 1, CSM_C_SIG_TX_SourceUSB1_Avail_DeviceStatus, tTxSignal.u8TxType);
	}
	//DeviceStatusUSB2Src  
	tVoid veda_tclClientVcanCanAdaptor::vSendDeviceStatusUSB2Src(TDeviceStatusUSB2Src tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.DeviceStatusUSB2SrcValue, 1, CSM_C_SIG_TX_SourceUSB2_Avail_DeviceStatus, tTxSignal.u8TxType);
	}	
	//DeviceStatusAMFMAvail  
	tVoid veda_tclClientVcanCanAdaptor::vSendDeviceStatusAMFMAvail(TDeviceStatusAMFMAvail tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.DeviceStatusAMFMAvailValue, 1, CSM_C_SIG_TX_SourceAMFM_Avail_DeviceStatus, tTxSignal.u8TxType);
	}
		//MediaStatusSeekStatus  
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusSeekStatus(TMediaStatusSeekStatus tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.MediaStatusSeekStatusValue, 1, CSM_C_SIG_TX_SeekState_MediaStatus2, tTxSignal.u8TxType);
	}
	//MediaStatusRepeatStatus  
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusRepeatStatus(TMediaStatusRepeatStatus tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.MediaStatusRepeatStatusValue, 1, CSM_C_SIG_TX_RepeatState_MediaStatus2, tTxSignal.u8TxType);
	}
	//MediaStatusDABFMStatus  
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusDABFMStatus(TMediaStatusDABFMStatus tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.MediaStatusDABFMStatusValue, 1, CSM_C_SIG_TX_DABFMstatus_MediaStatus1, tTxSignal.u8TxType);
	}
	//VehicleNaviLatitude  
	tVoid veda_tclClientVcanCanAdaptor::vSendVehicleNaviLatitude(TVehicleNaviLatitude tTxSignal){
		vSendCsmBroadcastSignal((tU8*)&tTxSignal.VehicleNaviLatitudeValue, 4,  CSM_C_SIG_TX_Latitude_VehiclePositionNav, tTxSignal.u8TxType);
	}
	//VehicleNaviLongitude  
	tVoid veda_tclClientVcanCanAdaptor::vSendVehicleNaviLongitude(TVehicleNaviLongitude tTxSignal){
		vSendCsmBroadcastSignal((tU8*)&tTxSignal.VehicleNaviLongitudeValue, 4,  CSM_C_SIG_TX_Longitude_VehiclePositionNav, tTxSignal.u8TxType);
	}
	//MediaStatusTREGStatus  
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusTREGStatus(TMediaStatusTREGStatus tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.MediaStatusTREGStatusValue, 1, CSM_C_SIG_TX_TPEGstatus_MediaStatus1, tTxSignal.u8TxType);
	}
	//MediaStatusTREGRTMStatus  
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusTREGRTMStatus(TMediaStatusTREGRTMStatus tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.MediaStatusTREGRTMStatusValue, 1, CSM_C_SIG_TX_TPEGRTMstatus_MediaStatus1, tTxSignal.u8TxType);
	}
	//MediaStatusRDSStatus  
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusRDSStatus(TMediaStatusRDSStatus tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.MediaStatusRDSStatusValue, 1, CSM_C_SIG_TX_RDSstatus_MediaStatus1, tTxSignal.u8TxType);
	}
	//MediaStatusTAStatus  
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusTAStatus(TMediaStatusTAStatus tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.MediaStatusTAStatusValue, 1, CSM_C_SIG_TX_TAstatus_MediaStatus1, tTxSignal.u8TxType);
	}
	//MediaStatusTPStatus  
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusTPStatus(TMediaStatusTPStatus tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.MediaStatusTPStatusValue, 1, CSM_C_SIG_TX_TPstatus_MediaStatus1, tTxSignal.u8TxType);
	}
	//MediaStatusTunerBandStatus  
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusTunerBandStatus(TMediaStatusTunerBandStatus tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.MediaStatusTunerBandStatusValue, 1, CSM_C_SIG_TX_TunerBand_MediaStatus1, tTxSignal.u8TxType);
	}
	//MediaStatusTunerPresetStatus  
	tVoid veda_tclClientVcanCanAdaptor::vSendMediaStatusTunerPresetStatus(TMediaStatusTunerPresetStatus tTxSignal){
		vSendCsmBroadcastSignal(&tTxSignal.MediaStatusTunerPresetStatusValue, 1, CSM_C_SIG_TX_TunerPreset_MediaStatus1, tTxSignal.u8TxType);
	}
	//HUS_DM1_Status  
	tVoid veda_tclClientVcanCanAdaptor::vSendHUS_DM1_Status(THUS_DM1_Status tTxSignal){
		
	}
	tVoid veda_tclClientVcanCanAdaptor::vSendVoice_Recognition_Executing(TVoice_Recognition_Executing tTxSignal) {
        /* vSendCsmBroadcastSignal (&tTxSignal.Voice_Recognition_Executing, 1, CSM_C_ASIG_TX_Voice_Recognition_Executing, tTxSignal.u8TxType); */
    }
    tVoid veda_tclClientVcanCanAdaptor::vSendBlowerReductionRequest(TBlowerReductionRequest tTxSignal) {
        /* vSendCsmBroadcastSignal(&tTxSignal.BlowerReductionRequest, 1, CSM_C_ASIG_TX_BlowerReductionRequest, tTxSignal.u8TxType); */
    }
    tVoid veda_tclClientVcanCanAdaptor::vSendTSR_OSPActivationRequest2(TTSR_OSPActivationRequest2 tTxSignal) {
        /* vSendCsmBroadcastSignal(&tTxSignal.TSR_OSPActivationRequest2, 1, CSM_C_ASIG_TX_TSR_OSPActivationRequest2, tTxSignal.u8TxType); */
    }
    tVoid veda_tclClientVcanCanAdaptor::vSendMeterLanguageSyncMenu(TMeterLanguageSyncMenu tTxSignal) {
        /* vSendCsmBroadcastSignal(&tTxSignal.MeterLanguageSyncMenu, 1, CSM_C_ASIG_TX_MeterLanguageSyncMenu, tTxSignal.u8TxType); */
    }
    tVoid veda_tclClientVcanCanAdaptor::vSendCockpitLanguageRequest(TCockpitLanguageRequest tTxSignal) {
        /* vSendCsmBroadcastSignal(&tTxSignal.CockpitLanguageRequest, 1, CSM_C_ASIG_TX_CockpitLanguageRequest, tTxSignal.u8TxType); */
    }
    tVoid veda_tclClientVcanCanAdaptor::vSendUnitDistanceDisplayRequest(TUnitDistanceDisplayRequest tTxSignal) {
        /* vSendCsmBroadcastSignal(&tTxSignal.UnitDistanceDisplayRequest, 1, CSM_C_ASIG_TX_UnitDistanceDisplayRequest, tTxSignal.u8TxType); */
    }
    tVoid veda_tclClientVcanCanAdaptor::vSendSetting_Change_Request_for_TPMS(TSetting_Change_Request_for_TPMS tTxSignal) {
        /* vSendCsmBroadcastSignal(&tTxSignal.Setting_Change_Request_for_TPMS, 1, CSM_C_ASIG_TX_Setting_Change_Request_for_TPMS, tTxSignal.u8TxType); */
    }

// veda_tclClientVcanCanAdaptor::ClassImplementation: user specific code end

//EOF
