/*****************************************************************************
* FILE:         veda_ClientVcanCanAdaptor.h
* PROJECT:      G3G project
* SW-COMPONENT: vehicledata
* Template:     csmAdaptor.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               DO NOT CHANGE --> 
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/
#ifndef _VCANCANADAPTOR_H_
#define _VCANCANADAPTOR_H_

// veda_tclClientVcanCanAdaptor::Include: user specific code start
// veda_tclClientVcanCanAdaptor::Include: user specific code end

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
#include "I_veda_ClientVcanCanAdaptor.h"

class CSMInterface;

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class veda_tclClientVcanCanAdaptor :
    public I_veda_tclClientVcanCanAdaptor
{
public:
    veda_tclClientVcanCanAdaptor(veda_tclAppMain* poMainAppl);
    virtual ~veda_tclClientVcanCanAdaptor();
/**************************************************************************
* Copy Constructor, will not be implemented.
* To Avoids Coverity  warning: new in constructor for class 
* 'veda_tclClientVcanCanAdaptor' which has no copy constructor.
* NOTE: This is a technique to disable the copy constructor for this
* class. So if an attempt for the copy constructor is made compiler complains.
**************************************************************************/
    veda_tclClientVcanCanAdaptor(const veda_tclClientVcanCanAdaptor& oVcan);

/**************************************************************************
* Assingment Operater, will not be implemented.
* To Avoids Coverity warning: new in constructor for class 
* 'veda_tclClientVcanCanAdaptor' which has no assignment operator.
* NOTE: This is a technique to disable the assignment operator for this
* class. So if an attempt for the assignment is made compiler complains.
**************************************************************************/
     veda_tclClientVcanCanAdaptor& operator=(const veda_tclClientVcanCanAdaptor& oVcan);

    virtual const tChar* getName() const { return "veda_tclClientVcanCanAdaptor"; };
   
    virtual tVoid vHandleMessage(veda_tclBaseIf::TMsg* pMsg);
    virtual tVoid vHandleTraceMessage(const tUChar* puchData);
    virtual tVoid vGetReferences();
    virtual tVoid vStartCommunication();
    virtual tVoid vTraceInfo();

    virtual tVoid vSendCsmBroadcastSignal(tU8* pabData, tU8 u8Len, tU32 u32CsmSignal, tU8 u8TxType);
    virtual tVoid vConnect();

    virtual tVoid vSetCallbackIf(CsmCallbackIF* poCallback) {
      _pCallbackIf = poCallback;
    }

    tVoid vGetSpeed_Limit_Display_Request(TSpeed_Limit_Display_Request& tSpeed_Limit_Display_Request);
    tVoid vGetNavi_display_speed_limit_1(TNavi_display_speed_limit_1& tNavi_display_speed_limit_1);
    tVoid vGetNavi_display_speed_limit_2(TNavi_display_speed_limit_2& tNavi_display_speed_limit_2);
    tVoid vGetIgnitionSupplyConfirmation(TIgnitionSupplyConfirmation& tIgnitionSupplyConfirmation);
    tVoid vGetVehicleSpeed(TVehicleSpeed& tVehicleSpeed);
	tVoid vGetPartialMuteValue(TPartialMuteValue& tPartialMuteValue);
	tVoid vGetSwivMonAutoOpenValue(TSwivMonAutoOpenValue& tSwivMonAutoOpenValue);
	tVoid vGetDateModeValue(TDateModeValue& tDateModeValue);
	tVoid vGetTmModeValue(TTmModeValue& tTmModeValue);
	tVoid onEveryFiveSeconds();
	//camera
	tVoid vGetActCam1Value(TActCam1Value& tActCam1Value);
	//camera2
	tVoid vGetActCam2Value(TActCam2Value& tActCam2Value);
	//camera3
	tVoid vGetActCam3Value(TActCam3Value& tActCam3Value);
	//camera4
	tVoid vGetActCam4Value(TActCam4Value& tActCam4Value);
	//camera5
	tVoid vGetActCam5Value(TActCam5Value& tActCam5Value);
	//camera6
	tVoid vGetActCam6Value(TActCam6Value& tActCam6Value);
	//camera7
	tVoid vGetActCam7Value(TActCam7Value& tActCam7Value);
	//TCOVehiclespeed
	tVoid vGetTCOVehicleSpeed(TTCOVehicleSpeed& tTCOVehicleSpeed);
	//camsplit
	tVoid vGetCamSplitQuadValue(TCamSplitQuadValue& tCamSplitQuadValue);
	//MuteDev
	tVoid vGetMuteDevStatus(TMuteDevStatus& tMuteDevStatus);
	//SysVolt
	tVoid vGetSysVoltStatus(TSysVoltStatus& tSysVoltStatus) ;
	//ParkingBreakSwitch
	tVoid vGetParkingBreakSwitchValue(TParkingBreakSwitchValue& tParkingBreakSwitchValue);
	//Disatnce Unit
	tVoid vGetUnitDistanceDisplayState(TUnitDistanceDisplayState& tUnitDistanceDisplayState) ;
	//RearCamReq
	tVoid vGetRearCamReqValue(TRearCamReqValue& tRearCamReqValue);
	//VIN
	tVoid vGetVINValue(TVINValue& tVINValue);
	//Time Date
	tVoid vGetTimeDateValue(TTimeDateValue& tTimeDateValue);
	//Phone Call Command 
	tVoid vGetPhoneCallCmdValue(TPhoneCallCommand& tPhoneCallCommand); 
	//System Language
	tVoid vGetSystemLanguageValue(TSystemLanguageValue& tSystemLanguageValue);
	//CurrLang
	tVoid vGetCurrLangValue(TCurrLangValue& tCurrLangValue);
	//CamTxt
	tVoid vGetCamTxtValue(TCamTxtValue& tCamTxtValue);
	
	tVoid vGetDistanceUnit(TDistanceUnit& tDistanceUnit) ;
	tVoid vGetHandBrakeSwitch(THandBrakeSwitch& tHandBrakeSwitch);
    tVoid vGetDistanceTotalizer(TDistanceTotalizer& tDistanceTotalizer) ;
    tVoid vGetAverage_Fuel_Economy(TAverage_Fuel_Economy& tAverage_Fuel_Economy) ;
    tVoid vGetDiagMuxOn(TDiagMuxOn& tDiagMuxOn) ;
    tVoid vGetDiagMuxOn_84(TDiagMuxOn_84& tDiagMuxOn_84);
    tVoid vGetGADE(TGADE& tGADE) ;
    tVoid vGetRearGearEngaged(TRearGearEngaged& tRearGearEngaged) ;
    tVoid vGetOSPOverSpeedDisplayRequest(TOSPOverSpeedDisplayRequest& tOSPOverSpeedDisplayRequest) ;
    tVoid vGetOSPSpeedUnit(TOSPSpeedUnit& tOSPSpeedUnit) ;
    tVoid vGetTSR_OSP_ActivationStatus(TTSR_OSP_ActivationStatus& tTSR_OSP_ActivationStatus) ;
    tVoid vGetMeterLanguageKnowledge(TMeterLanguageKnowledge& tMeterLanguageKnowledge) ;
    tVoid vGetMeterLanguageStatus(TMeterLanguageStatus& tMeterLanguageStatus);
    tVoid vGetReset_TPMS_answer_back(TReset_TPMS_answer_back& tReset_TPMS_answer_back) ;
    tVoid vGetSelect_pressure_support(TSelect_pressure_support& tSelect_pressure_support) ;
    tVoid vGetSetting_pressure_Front_answer_back(TSetting_pressure_Front_answer_back& tSetting_pressure_Front_answer_back) ;
    tVoid vGetSetting_pressure_Rear_answer_back(TSetting_pressure_Rear_answer_back& tSetting_pressure_Rear_answer_back) ;
    tVoid vGetGlobalVehicleWarningState(TGlobalVehicleWarningState& tGlobalVehicleWarningState) ;
    tVoid vGetVehicleStates(TVehicleStates& tVehicleStates) ;
    tVoid vSendMediaInfoToCluster(TMediaInfo tTxSignal);
	tVoid vSendCallInfoToCluster(TMediaInfo tTxSignal);
	tVoid vSendPhoneInfoToCluster(TMediaInfo tTxSignal);
	tVoid vSendTurnToStreetInfoToCluster(TStreetInfo tTxSignal);
	tVoid vSendCurrentStreetInfoToCluster(TStreetInfo tTxSignal);
	tVoid vSendDestinationInfoToCluster(TNaviInfo tTxSignal);
	tVoid vSendTurnToSymbolsInfoToCluster(TNaviInfo tTxSignal);
	tVoid vSendNaviLaneGuidanceInfoToCluster(TNaviInfo tTxSignal);
	tVoid vSendNaviWarningInfoToCluster(TNaviInfo tTxSignal);

    //Cam1ManAct
	tVoid vSendCam1ManAct(TCam1ManAct tTxSignal);
	//Cam2ManAct
	tVoid vSendCam2ManAct(TCam2ManAct tTxSignal);
	//Cam3ManAct
	tVoid vSendCam3ManAct(TCam3ManAct tTxSignal);
	//Cam4ManAct
	tVoid vSendCam4ManAct(TCam4ManAct tTxSignal);
	//Cam5ManAct
	tVoid vSendCam5ManAct(TCam5ManAct tTxSignal);
	//Cam6ManAct
	tVoid vSendCam6ManAct(TCam6ManAct tTxSignal);
	//Cam7ManAct
	tVoid vSendCam7ManAct(TCam7ManAct tTxSignal);
	//Cam8ManAct
	tVoid vSendCam8ManAct(TCam8ManAct tTxSignal);
	//Cam9ManAct
	tVoid vSendCam9ManAct(TCam9ManAct tTxSignal);
	//Cam10ManAct
	tVoid vSendCam10ManAct(TCam10ManAct tTxSignal);
	//Cam11ManAct
	tVoid vSendCam11ManAct(TCam11ManAct tTxSignal);
	//Cam12ManAct
	tVoid vSendCam12ManAct(TCam12ManAct tTxSignal);
	//Cam13ManAct
	tVoid vSendCam13ManAct(TCam13ManAct tTxSignal);
	//Cam14ManAct
	tVoid vSendCam14ManAct(TCam14ManAct tTxSignal);
	//Cam15ManAct
	tVoid vSendCam15ManAct(TCam15ManAct tTxSignal);
	//Cam16ManAct
	tVoid vSendCam16ManAct(TCam16ManAct tTxSignal);
	//Cam17ManAct
	tVoid vSendCam17ManAct(TCam17ManAct tTxSignal);
	//PrivacyResetAck
	tVoid vSendPrivacyResetAck(TPrivacyResetAck tTxSignal);
	//DispCamCls
	tVoid vSendDispCamCls(TDispCamCls tTxSignal);
	//PhoneBTLinkStatus
	tVoid vSendPhoneBTLinkStatus(TPhoneBTLinkStatus tTxSignal);
	//PhoneBookSyncstatus
	tVoid vSendPhoneBookSyncstatus(TPhoneBookSyncStatus tTxSignal);
	//CallHistorySyncStatus
	tVoid vSendCallHistorySyncStatus(TCallHistorySyncStatus tTxSignal);
	//PhoneStatusRoaming
	tVoid vSendPhoneStatusRoaming(TPhoneStatusRoaming tTxSignal);
	//CallDuration
	tVoid vSendCallDuration(TCallDuration tTxSignal);
	//GSMSignalStrength
	tVoid vSendGSMSignalStrength(TGSMSignalStrength tTxSignal);
	//PhoneCallStatus
	tVoid vSendPhoneCallStatus(TPhoneCallStatus tTxSignal);
	//PhoneBatteryLevelStatus
	tVoid vSendPhoneBatteryLevelStatus(TPhoneBatteryLevelStatus tTxSignal);
	//DeviceStatusWifiAvailable
	tVoid vSendDeviceStatusWifiAvailable(TDeviceStatusWifiAvailable tTxSignal);
	//MediaStatusAudioSource
	tVoid vSendMediaStatusAudioSource(TMediaStatusAudioSource tTxSignal);
	//PhoneAvailableStatus
	tVoid vSendPhoneAvailableStatus(TPhoneAvailableStatus tTxSignal);
	//PhoneVRAvailable
	tVoid vSendPhoneVRAvailable(TPhoneVRAvailable tTxSignal);
	//DeviceStatusBTStatus
	tVoid vSendDeviceStatusBTStatus(TDeviceStatusBTStatus tTxSignal);
	//DeviceStatusBluetoothAvail
	tVoid vSendDeviceStatusBluetoothAvail(TDeviceStatusBluetoothAvail tTxSignal);
	//Req_DeviceInfo
	tVoid vSendReq_DeviceInfo(TReq_DeviceInfo tTxSignal);
	//MediaStatusVolume
	tVoid vSendMediaStatusVolume(TMediaStatusVolume tTxSignal);
	//CabinMediaStatusAudioSource
	tVoid vSendCabinMediaStatusAudioSource(TCabinMediaStatusAudioSource tTxSignal);
	//CabinMediaStatusTunerBand
	tVoid vSendCabinMediaStatusTunerBand(TCabinMediaStatusTunerBand tTxSignal);
	//CabinMediaStatusVolume
	tVoid vSendCabinMediaStatusVolume(TCabinMediaStatusVolume tTxSignal);
	//MediaStatusMuteStatus
	tVoid vSendMediaStatusMuteStatus(TMediaStatusMuteStatus tTxSignal);
	//CabinMediaStatusMuteStatus
	tVoid vSendCabinMediaStatusMuteStatus(TCabinMediaStatusMuteStatus tTxSignal);
	//MediaStatusPlayStatus
	tVoid vSendMediaStatusPlayStatus(TMediaStatusPlayStatus tTxSignal);
	//MediaStatusMixState
	tVoid vSendMediaStatusMixState(TMediaStatusMixState tTxSignal);
	//MediaStatusPlaylistMode
	tVoid vSendMediaStatusPlaylistMode(TMediaStatusPlaylistMode tTxSignal);
	//MediaStatusTrackTime
	tVoid vSendMediaStatusTrackTime(TMediaStatusTrackTime tTxSignal);
	//MediaStatusCurrTrackNum
	tVoid vSendMediaStatusCurrTrackNum(TMediaStatusCurrTrackNum tTxSignal);
	//DeviceStatusRadioStatus
	tVoid vSendDeviceStatusRadioStatus(TDeviceStatusRadioStatus tTxSignal);
	//DeviceStatusDABAvailStatus
	tVoid vSendDeviceStatusDABAvailStatus(TDeviceStatusDABAvailStatus tTxSignal);
	//DeviceStatusNavData
	tVoid vSendDeviceStatusNavData(TDeviceStatusNavData tTxSignal);
	//DeviceStatusUSB1Present
	tVoid vSendDeviceStatusUSB1Present(TDeviceStatusUSB1Present tTxSignal);
	//DeviceStatusUSB2Present
	tVoid vSendDeviceStatusUSB2Present(TDeviceStatusUSB2Present tTxSignal);
	//DeviceStatusNaviAvail
	tVoid vSendDeviceStatusNaviAvail(TDeviceStatusNaviAvail tTxSignal);
	//DeviceStatusUSB1Src
	tVoid vSendDeviceStatusUSB1Src(TDeviceStatusUSB1Src tTxSignal);
	//DeviceStatusUSB2Src
	tVoid vSendDeviceStatusUSB2Src(TDeviceStatusUSB2Src tTxSignal);
	//DeviceStatusAMFMAvail
	tVoid vSendDeviceStatusAMFMAvail(TDeviceStatusAMFMAvail tTxSignal);
	//MediaStatusSeekStatus
	tVoid vSendMediaStatusSeekStatus(TMediaStatusSeekStatus tTxSignal);
	//MediaStatusRepeatStatus
	tVoid vSendMediaStatusRepeatStatus(TMediaStatusRepeatStatus tTxSignal);
	//MediaStatusDABFMStatus
	tVoid vSendMediaStatusDABFMStatus(TMediaStatusDABFMStatus tTxSignal);
	//VehicleNaviLatitude
	tVoid vSendVehicleNaviLatitude(TVehicleNaviLatitude tTxSignal);
	//VehicleNaviLongitude
	tVoid vSendVehicleNaviLongitude(TVehicleNaviLongitude tTxSignal);
	//MediaStatustregStatus
	tVoid vSendMediaStatusTREGStatus(TMediaStatusTREGStatus tTxSignal);
	//MediaStatusTREGRTMStatus
	tVoid vSendMediaStatusTREGRTMStatus(TMediaStatusTREGRTMStatus tTxSignal);
	//MediaStatusRDSStatus
	tVoid vSendMediaStatusRDSStatus(TMediaStatusRDSStatus tTxSignal);
	//MediaStatusTAStatus
	tVoid vSendMediaStatusTAStatus(TMediaStatusTAStatus tTxSignal);
	//MediaStatusTPstatus
	tVoid vSendMediaStatusTPStatus(TMediaStatusTPStatus tTxSignal);
	//MediaStatusTunerBandstatus
	tVoid vSendMediaStatusTunerBandStatus(TMediaStatusTunerBandStatus tTxSignal);
	//MediaStatusTunerPresetstatus
	tVoid vSendMediaStatusTunerPresetStatus(TMediaStatusTunerPresetStatus tTxSignal);
	//HUS_DM1_Status
	tVoid vSendHUS_DM1_Status(THUS_DM1_Status tTxSignal);
	tVoid vSendVoice_Recognition_Executing(TVoice_Recognition_Executing tTxSignal) ;
    tVoid vSendBlowerReductionRequest(TBlowerReductionRequest tTxSignal) ;
    tVoid vSendTSR_OSPActivationRequest2(TTSR_OSPActivationRequest2 tTxSignal) ;
    tVoid vSendMeterLanguageSyncMenu(TMeterLanguageSyncMenu tTxSignal) ;
    tVoid vSendCockpitLanguageRequest(TCockpitLanguageRequest tTxSignal) ;
    tVoid vSendUnitDistanceDisplayRequest(TUnitDistanceDisplayRequest tTxSignal) ;
    tVoid vSendSetting_Change_Request_for_TPMS(TSetting_Change_Request_for_TPMS tTxSignal) ;
    tVoid vSendMeidaDataToCluster(vehicle_fi_tcl_CAN_Mesg msg);
    tVoid vSendCallDataToCluster(vehicle_fi_tcl_CAN_Mesg msg);
    tVoid vSendPhoneDataToCluster(vehicle_fi_tcl_CAN_Mesg msg);
	tVoid vSendCabinAMeidaDataToCluster(vehicle_fi_tcl_CAN_Mesg msg);
private:
    CsmCallbackIF* _pCallbackIf;

    virtual tVoid vSignalIndSync(tU32 u32SignalId);
    TSpeed_Limit_Display_Request _tSpeed_Limit_Display_Request;
    TNavi_display_speed_limit_1 _tNavi_display_speed_limit_1;
    TNavi_display_speed_limit_2 _tNavi_display_speed_limit_2;
    TIgnitionSupplyConfirmation _tIgnitionSupplyConfirmation;
    TVehicleSpeed _tVehicleSpeed;
	TPartialMuteValue _tPartialMuteValue;
	TSwivMonAutoOpenValue _tSwivMonAutoOpenValue;
	TDateModeValue _tDateModeValue;
	TTmModeValue _tTmModeValue;
	TTimeDateValue _tTimeDateValue;
	//Phone Call Command 
	TPhoneCallCommand _tPhoneCallCommandStatus;
	//Volume Command 
	TVolumeCommand _tVolumeCommandValue;
	//ActCam8  
	TActCam8 _tActCam8Value;
	//ActCam9  
	TActCam9 _tActCam9Value;
	//ActCam10  
	TActCam10 _tActCam10Value;
	//ActCam11 
	TActCam11 _tActCam11Value;
	//ActCam12
	TActCam12 _tActCam12Value;
	//ActCam13
	TActCam13 _tActCam13Value;
	//ActCam14
	TActCam14 _tActCam14Value;
	//ActCam15
	TActCam15 _tActCam15Value;
	//ActCam16
	TActCam16 _tActCam16Value;
	//ActCam17
	TActCam17 _tActCam17Value;
	//Spurce Command 
	TSourceCommand _tSourceCommandValue;
	//CabinSource Command 
	TCabinSourceCommand _tCabinSourceCommandValue;
	//CabinVolume Command 
	TCabinVolumeCommand _tCabinVolumeCommandValue;
	//CabinTuner Command 
	TCabinTunerCommand _tCabinTunerCommandValue;
	//CabinTrack Command 
	TCabinTrackCommand _tCabinTrackCommandValue;
	//CabinPlaylist Command 
	TCabinPlaylistCommand _tCabinPlaylistCommandValue;
	//Track Command
	TTrackCommand _tTrackCommandValue;
	//SMARTVR
	TSMARTVR _tSMARTVRValue;
	//Tuner Command
	TTunerCommand _tTunerCommandValue;
	//TA Command
	TTACommand _tTACommandValue;
	//RDS Command
	TRDSCommand _tRDSCommandValue;
	//Voice Recg command
	TVoiceRecgCommand _tVoiceRecgCommandValue;
	//PhonePwrCmd 
	TPhonePwrCmd _tPhonePwrCmdValue;
	//RadioPwrCmd 
	TRadioPwrCmd _tRadioPwrCmdValue;
	//RCNextBtn 
	TRCNextBtn _tRCNextBtnValue;
	//RCPrevBtn 
	TRCPrevBtn _tRCPrevBtnValue;
	//Camera
	TActCam1Value _tActCam1Value;
	//Camera2
	TActCam2Value _tActCam2Value;
	//Camera3
	TActCam3Value _tActCam3Value;
	//Camera4
	TActCam4Value _tActCam4Value;
	//Camera5
	TActCam5Value _tActCam5Value;
	//Camera6
	TActCam6Value _tActCam6Value;
	//Camera7
	TActCam7Value _tActCam7Value;
	//Camsplit
	TCamSplitQuadValue _tCamSplitQuadValue;
	//MuteDev
	TMuteDevStatus _tMuteDevStatus;
	//CurrGr
	TTxCurrGrStatus _tTxCurrGrStatus;
	//SysVolt
	TSysVoltStatus _tSysVoltStatus;
	//Distance Unit
	TUnitDistanceDisplayState _tUnitDistanceDisplayState;
	//CurrLang
	TCurrLangValue _tCurrLangValue;
	//Device Info SW version 
	TDeviceInfoSWversion _tDeviceInfoSWversionValue;	
	//TotalVehDistDiag 
	TTotalVehDistDiag _tTotalVehDistDiagValue;
	//VIN_64 
	TVIN_64 _tVIN_64Value;
	//CamTxt
	TCamTxtValue _tCamTxtValue;
	//ParkingBreakSwitch
	TParkingBreakSwitchValue _tParkingBreakSwitchValue;
	
	THandBrakeSwitch _tHandBrakeSwitch;
    TDistanceTotalizer _tDistanceTotalizer;
    TDistanceUnit _tDistanceUnit;
    TAverage_Fuel_Economy _tAverage_Fuel_Economy;
    TDiagMuxOn _tDiagMuxOn;
    TDiagMuxOn_84 _tDiagMuxOn_84;
    TGADE _tGADE;
    TRearGearEngaged _tRearGearEngaged;
	/////////////////////////////////////////////////////////
		TRearGearEngaged _tReverseSwitch;
	TRearGearEngaged _tDirectionIndication;
	//////////////////////////////////////////////////////////////////
    TOSPOverSpeedDisplayRequest _tOSPOverSpeedDisplayRequest;
    TOSPSpeedUnit _tOSPSpeedUnit;
    TTSR_OSP_ActivationStatus _tTSR_OSP_ActivationStatus;
    TMeterLanguageKnowledge _tMeterLanguageKnowledge;
    TMeterLanguageStatus _tMeterLanguageStatus;
    TReset_TPMS_answer_back _tReset_TPMS_answer_back;
    TSelect_pressure_support _tSelect_pressure_support;
    TSetting_pressure_Front_answer_back _tSetting_pressure_Front_answer_back;
    TSetting_pressure_Rear_answer_back _tSetting_pressure_Rear_answer_back;
    TGlobalVehicleWarningState _tGlobalVehicleWarningState;
    TVehicleStates _tVehicleStates;

    static veda_tclClientVcanCanAdaptor* _pMyStaticRef;
    static tVoid vSignalIndCallback(tVoid* pHandle, tU32 u32SignalId, tU32 u32SignalStatus);
    CSMInterface* _poMyCSMInterface;

    tVoid vReadSpeed_Limit_Display_Request();
    tVoid vReadNavi_display_speed_limit_1();
    tVoid vReadNavi_display_speed_limit_2();
    tVoid vReadIgnitionSupplyConfirmation();
    tVoid vReadVehicleSpeed();
	tVoid vReadPartialMuteValue();
	tVoid vReadSwivMonAutoOpenValue();
	tVoid vReadDateModeValue();
	tVoid vReadTmModeValue();
	tVoid vReadTimeDateValue();
	//camera
	tVoid vReadActCam1Value();
	//camera2
	tVoid vReadActCam2Value();
	//camera3
	tVoid vReadActCam3Value();
	//camera4
	tVoid vReadActCam4Value();
	//camera5
	tVoid vReadActCam5Value();
	//camera6
	tVoid vReadActCam6Value();
	//camera7
	tVoid vReadActCam7Value();
	//camsplit
	tVoid vReadCamSplitQuadValue();
	//MuteDev
	tVoid vReadMuteDevStatus();
	//CurrGr
	tVoid vReadTxCurrGrStatus();
	//SysVolt
	tVoid vReadSysVoltStatus();
	//Distance Unit
	tVoid vReadUnitDistanceDisplayState();
	//CurrLang
	tVoid vReadCurrLangValue();
	//Device Info SW version
	tVoid vReadDeviceInfoSWversionValue();
	//TotalVehDistDiag
	tVoid vReadTotalVehDistDiagValue();
		//VIN_64
	tVoid vReadVIN_64Value();
	//CamTxt
	tVoid vReadCamTxtValue();
	//ParkingBreakSwitch
	tVoid vReadParkingBreakSwitchValue();
	
	tVoid vReadDistanceUnit();
	tVoid vReadHandBrakeSwitch();
    tVoid vReadDistanceTotalizer();
    tVoid vReadAverage_Fuel_Economy();
    tVoid vReadDiagMuxOn();
    tVoid vReadDiagMuxOn_84();
    tVoid vReadGADE();
    tVoid vReadRearGearEngaged();
    tVoid vReadOSPOverSpeedDisplayRequest();
    tVoid vReadOSPSpeedUnit();
    tVoid vReadTSR_OSP_ActivationStatus();
    tVoid vReadMeterLanguageKnowledge();
    tVoid vReadMeterLanguageStatus();
    tVoid vReadReset_TPMS_answer_back();
    tVoid vReadSelect_pressure_support();
    tVoid vReadSetting_pressure_Front_answer_back();
    tVoid vReadSetting_pressure_Rear_answer_back();
    tVoid vReadGlobalVehicleWarningState();
    tVoid vReadVehicleStates();

    // veda_tclClientVcanCanAdaptor::ClassImplementation: user specific code start
    tVoid _vSendKDSCodingChangedInfoToCSM() const;
    tVoid _vHandleMessagePosting(const veda_tclBaseIf::ECmdTypes, const tU8 u8DiagIndex, const tU8 u8Result, const tU8 u8ForceUpdate) const;

    //virtual tVoid vRegisterNodeFaultStates(tVoid) const;
    //virtual tVoid vReadNodeFaultStates(const tBool bForceUpdate) const;

    virtual tBool _bCheckCommunicationState_RX(const tU8 u8Bus, const tU8 u8Node, tU8& u8FaultState) const;
    virtual tBool _bCheckCommunicationState_TX(const tU8 u8Bus, const tU8 u8Node, tU8& u8FaultState) const;
    virtual tBool _bCheckCommunicationState_BusOff(const tU8 u8Bus, tU8& u8FaultState) const;

    virtual tBool _bRegisterForBusOffErrorIndication(const tU8 u8Bus, tBool& bInitializationError) const;
    virtual tBool _bRegisterForRxBusErrorIndication(const tU8 u8Bus, const tU8 u8Node) const;
    virtual tBool _bRegisterForTxBusErrorIndication(const tU8 u8Bus, const tU8 u8Node) const;

    static tVoid vBusOffErrorIndication( tVoid* /* pvHandle */,
       tU8 u8Bus,
       tU32 /* u32ProtocolType */,
       const tVoid * pvAddressField,
       tU8 u8State,
       tU16 /* u16ApplId */);
    static tVoid vRxBusErrorIndication( tVoid* /* pvHandle */,
       tU8 u8Bus,
       tU32 /* u32ProtocolType */,
       const tVoid * pvAddressField,
       tU8 u8State,
       tU16 /* u16ApplId */);
    static tVoid vTxBusErrorIndication( tVoid* /* pvHandle */,
       tU8 u8Bus,
       tU32 /* u32ProtocolType */,
       const tVoid * pvAddressField,
       tU8 u8State,
       tU16 /* u16ApplId */);

public:
    //virtual tVoid vReinitCsmNetworkManagement(tVoid) const;
    // veda_tclClientVcanCanAdaptor::ClassImplementation: user specific code end

};

#endif // _VCANCANADAPTOR_H_

