/*****************************************************************************
 * @file:         AsfClientStarter.cpp
 * @PROJECT:      CMD project
 * @SW-COMPONENT: vehicledata
 * @Template:     AsfClientStarter.cpp.tpl
 * ----------------------------------------------------------------------------
 *
 * @brief:  generated file
 *          create ASF proxies
 *
 *          Do manual changes only inside tags
 *
 *          //......................: user specific code start 
 *          //......................: user specific code end 
 *
 * ----------------------------------------------------------------------------
 * @copyright   (c) 2017 Robert Bosch GmbH.
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 *****************************************************************************/
#include <iostream>

#include "veda_AppMain.h"

#include "CcaSrvProxy.h"

// AsfClientStarterIncludeTop: user specific code start
// AsfClientStarterIncludeTop: user specific code end

#include "veda_ClientSpm.h"
#include "veda_ClientDiaglog.h"
#include "veda_ClientSDSAdapter.h"
#include "veda_ClientProfile.h"

// AsfClientStarterInclude: user specific code start
// AsfClientStarterInclude: user specific code end

namespace org { namespace bosch { namespace cm { namespace veda {

    void vProxyStarter(veda_tclAppMain *poServer){
        {
            CcaSrvProxy *poCcaSrvProxy = new CcaSrvProxy(poServer);
            poServer->vAddObj(poCcaSrvProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStarterveda_tclClientSpm: user specific code start
        // AsfClientStarterveda_tclClientSpm: user specific code end
        {
            veda_tclClientSpm *poCcaProxy = new veda_tclClientSpm(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStarterveda_tclClientDiaglog: user specific code start
        // AsfClientStarterveda_tclClientDiaglog: user specific code end
        {
            veda_tclClientDiaglog *poCcaProxy = new veda_tclClientDiaglog(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStarterveda_tclClientSDSAdapter: user specific code start
        // AsfClientStarterveda_tclClientSDSAdapter: user specific code end
        {
            veda_tclClientSDSAdapter *poCcaProxy = new veda_tclClientSDSAdapter(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStarterveda_tclClientProfile: user specific code start
        // AsfClientStarterveda_tclClientProfile: user specific code end
        {
            veda_tclClientProfile *poCcaProxy = new veda_tclClientProfile(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list

        // AsfClientProxyStarter: user specific code start
        // AsfClientProxyStarter: user specific code end
    }

}}}} //namespace org { namespace bosch { namespace cm { namespace veda {
