#ifndef _VEDA_CLIENTSDSADAPTER_H
#define _VEDA_CLIENTSDSADAPTER_H

#include <iostream>

#include "asf/core/Logger.h"
#include "asf/core/Proxy.h"
#include "asf/core/Timer.h"

#include "sds_gui_fi/SdsGuiServiceProxy.h"

#include "asf/stream/MemoryStream.h"

#include "Iveda_ClientSDSAdapter.h"

// veda_ClientSDSAdapterInclude: user specific code start
// veda_ClientSDSAdapterInclude: user specific code end

namespace org { namespace bosch { namespace cm { namespace veda {

    using namespace::asf::core;
    using namespace::asf::stream;
    using namespace::sds_gui_fi::SdsGuiService;
    using namespace::asf::core;
    using namespace::org::bosch::cm::veda;

    // veda_Server__SERVER_NAME__NameSpace: user specific code start
    // veda_Server__SERVER_NAME__NameSpace: user specific code end

    class veda_tclClientSDSAdapter : public Iveda_tclClientSDSAdapter
        , public ServiceAvailableIF
        , private TimerCallbackIF
        , public SdsStatusCallbackIF
    {
    private:
        DECLARE_CLASS_LOGGER();

        tBool _bSrvAvailable;

    public:
        veda_tclClientSDSAdapter(veda_tclAppMain* baseRef);
        virtual ~veda_tclClientSDSAdapter();

        // ServiceAvailableIF
        virtual void onAvailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);
        virtual void onUnavailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);

        // TimerCallbackIF
        virtual void onExpired(asf::core::Timer                          & timer,
                               boost::shared_ptr <asf::core::TimerPayload> payload);
        // SdsStatusCallbackIF
        virtual void onSdsStatusError(const ::boost::shared_ptr< SdsGuiServiceProxy >& proxy, const boost::shared_ptr< SdsStatusError >& error);
        virtual void onSdsStatusUpdate(const ::boost::shared_ptr< SdsGuiServiceProxy >& proxy, const boost::shared_ptr< SdsStatusUpdate >& update);


    private:

        ::boost::shared_ptr <SdsGuiServiceProxy> _SDSAdapterProxy;

    public:
        virtual const tChar* getName() const { return "veda_tclClientSDSAdapter"; }

        virtual tVoid vHandleMessage(veda_tclBaseIf::TMsg* pMsg);
        virtual tVoid vHandleTraceMessage(const tUChar* puchData) {}  //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
        virtual tVoid vGetReferences();
        virtual tVoid vStartCommunication();
        virtual tVoid vTraceInfo();

        virtual tVoid sendSdsStatusGetValue(tVoid) {
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2
            if (_SDSAdapterProxy) _SDSAdapterProxy->sendSdsStatusGet(* this);
#endif
        }


        // veda_ClientSDSAdapterDeclarationsPart: user specific code start
    private:
        tBool _bIsVoiceRecognitionExecuting;
        // veda_ClientSDSAdapterDeclarationsPart: user specific code end
    };

}}}} // namespace org { namespace bosch { namespace cm { namespace veda {

#endif // ifndef _VEDA_CLIENTSDSADAPTER_H

