#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

// veda_ClientSDSAdapterIncludePart: user specific code start
#include "Iveda_ClientVcan.h"
// veda_ClientSDSAdapterIncludePart: user specific code end

#include "veda_ClientSDSAdapter.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VEHICLEDATA_CLIENT_SDSADAPTER
#include "trcGenProj/Header/veda_ClientSDSAdapter.cpp.trc.h"
#endif


namespace org { namespace bosch { namespace cm { namespace veda {

using namespace::asf::core;
using namespace::asf::stream;
using namespace::sds_gui_fi::SdsGuiService;

DEFINE_CLASS_LOGGER_AND_LEVEL("org/bosch/cm/veda/veda_tclClientSDSAdapter", veda_tclClientSDSAdapter, Info);


veda_tclClientSDSAdapter::veda_tclClientSDSAdapter(veda_tclAppMain* baseRef)
   : Iveda_tclClientSDSAdapter(baseRef)
   , _bSrvAvailable(FALSE)
#if defined(VARIANT_S_FTR_ENABLE_AIVI_SCOPE2) || defined(VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1) || defined (VARIANT_S_FTR_ENABLE_PIVI)
   , _SDSAdapterProxy(SdsGuiServiceProxy::createProxy("SDSAdapterFiPort", * this) )
#endif
{
   LOG_INFO("Constructor for veda_tclClientSDSAdapter called");
   ETG_TRACE_USR1( ( "Constructor for veda_tclClientSDSAdapter called" ) );
   
   // veda_ClientSDSAdapterveda_tclClientSDSAdapter: user specific code start
   _bIsVoiceRecognitionExecuting = FALSE;
   // veda_ClientSDSAdapterveda_tclClientSDSAdapter: user specific code end
}

veda_tclClientSDSAdapter::~veda_tclClientSDSAdapter(){
   LOG_INFO("~veda_tclClientSDSAdapter called");
   ETG_TRACE_USR1( ( "~veda_tclClientSDSAdapter called" ) );
   // veda_tclClientSDSAdapterveda_tclClientSDSAdapterDest: user specific code start
   // veda_tclClientSDSAdapterveda_tclClientSDSAdapterDest: user specific code end
}

// ServiceAvailableIF
void veda_tclClientSDSAdapter::onAvailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange){
   (tVoid)stateChange;

   ETG_TRACE_USR1( ( "veda_tclClientSDSAdapter::onAvailable(): CALLED" ) );
   if (_SDSAdapterProxy == proxy){
      ETG_TRACE_USR1( ( "veda_tclClientSDSAdapter : onAvailable _SDSAdapterProxy " ) );
#if defined(VARIANT_S_FTR_ENABLE_AIVI_SCOPE2) || defined(VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1) || defined (VARIANT_S_FTR_ENABLE_PIVI)
      _SDSAdapterProxy->sendSdsStatusRegister(*this);
      _SDSAdapterProxy->sendSdsStatusGet(*this);
#endif
      _bSrvAvailable = TRUE;
   }
   // veda_ClientSDSAdapteronAvailable: user specific code start
   // veda_ClientSDSAdapteronAvailable: user specific code end
}

void veda_tclClientSDSAdapter::onUnavailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange){
   (tVoid)stateChange;
   ETG_TRACE_USR1( ( "veda_tclClientSDSAdapter::onUnavailable(): CALLED" ) );
   if (_SDSAdapterProxy == proxy){
      _bSrvAvailable = FALSE;
      ETG_TRACE_USR1( ( "veda_tclClientSDSAdapter : onUnavailable _SDSAdapterProxy " ) );
   }
   // veda_ClientSDSAdapteronUnavailable: user specific code start
   // veda_ClientSDSAdapteronUnavailable: user specific code end

}

// TimerCallbackIF
void veda_tclClientSDSAdapter::onExpired(asf::core::Timer& timer, boost::shared_ptr <asf::core::TimerPayload> payload){
   // veda_ClientSDSAdapteronExpired: user specific code start
   (tVoid) timer;
   (tVoid) payload;
   // veda_ClientSDSAdapteronExpired: user specific code end
}
void veda_tclClientSDSAdapter::onSdsStatusError(const::boost::shared_ptr <SdsGuiServiceProxy>  & proxy, const boost::shared_ptr <SdsStatusError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "veda_tclClientSDSAdapter::onSdsStatusError(): CALLED" ) );
   // veda_ClientSDSAdapteronSdsStatusError: user specific code start
   // veda_ClientSDSAdapteronSdsStatusError: user specific code end
}
void veda_tclClientSDSAdapter::onSdsStatusUpdate(const::boost::shared_ptr <SdsGuiServiceProxy> & proxy, const boost::shared_ptr <SdsStatusUpdate>& update){
   (tVoid)proxy;
   (tVoid)update;
   ETG_TRACE_USR1( ( "veda_tclClientSDSAdapter::onSdsStatusUpdate(): CALLED" ) );
   // veda_ClientSDSAdapteronSdsStatusUpdate: user specific code start
   tBool bSDSStatus = FALSE;

   switch(update->getSdsStatus())
   {
   case SpeechInputState__ACTIVE:
   case SpeechInputState__LISTENING:
   // As per comments in NCG3D-38085 & NCG3D-37971 Active needs to be handled for following states also
   case SpeechInputState__DIALOGOPEN:
   case SpeechInputState__PAUSE:
   case SpeechInputState__ACTIVE_PROMPTONLY:
       bSDSStatus = TRUE;
       break;

   default: //nothing
       break;
   }

   if ( _bIsVoiceRecognitionExecuting != bSDSStatus )
   {
      _bIsVoiceRecognitionExecuting = bSDSStatus;  
      I_veda_tclClientVcan* poClientCAN = dynamic_cast<I_veda_tclClientVcan*>(_cpoMain->theServer()->getHandler("I_veda_tclClientVcan"));
      VEDA_NULL_POINTER_CHECK(poClientCAN);
      
      poClientCAN->vSendSDSStatusUpdate(bSDSStatus);
   }
   // veda_ClientSDSAdapteronSdsStatusUpdate: user specific code end
}



tVoid veda_tclClientSDSAdapter::vHandleMessage(veda_tclBaseIf::TMsg* pMsg) {
   // veda_ClientSDSAdaptervHandleMessage: user specific code start
   (tVoid) pMsg;
   // veda_ClientSDSAdaptervHandleMessage: user specific code end
}

tVoid veda_tclClientSDSAdapter::vGetReferences() {
   // veda_ClientSDSAdaptervGetReferences: user specific code start
   // veda_ClientSDSAdaptervGetReferences: user specific code end
}

tVoid veda_tclClientSDSAdapter::vStartCommunication() {
   // veda_ClientSDSAdaptervStartCommunication: user specific code start
   // veda_ClientSDSAdaptervStartCommunication: user specific code end
}

tVoid veda_tclClientSDSAdapter::vTraceInfo() {
   // veda_ClientSDSAdaptervTraceInfo: user specific code start
   // veda_ClientSDSAdaptervTraceInfo: user specific code end
}

// veda_ClientSDSAdapterDefinitioPart: user specific code start
// veda_ClientSDSAdapterDefinitioPart: user specific code end

}}}} // namespace org { namespace bosch { namespace cm { namespace veda {

