#ifndef _VEDA_CLIENTPROFILE_H
#define _VEDA_CLIENTPROFILE_H

/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          veda_ClientProfile.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: vehicledata
  * @Template:     FrancaProxy.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                Franca interface file
  *
  *                Do manual changes only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#include <iostream>

#include "asf/core/Logger.h"
#include "asf/core/Proxy.h"
#include "asf/core/Timer.h"

#include "bosch/cm/profileProxy.h"

#include "asf/stream/MemoryStream.h"

#include "Iveda_ClientProfile.h"

// veda_ClientProfileInclude: user specific code start
// veda_ClientProfileInclude: user specific code end

namespace org { namespace bosch { namespace cm { namespace veda {

    using namespace::asf::core;
    using namespace::asf::stream;
    using namespace::bosch::cm::profile;
    using namespace::asf::core;
    using namespace::org::bosch::cm::veda;

    // veda_Server__SERVER_NAME__NameSpace: user specific code start
    // veda_Server__SERVER_NAME__NameSpace: user specific code end

    class veda_tclClientProfile : public Iveda_tclClientProfile
        , public ServiceAvailableIF
        , private TimerCallbackIF
        , public ActiveProfileCallbackIF
        , public StatusCallbackIF
        , public CopyProfileCallbackIF
        , public DeleteProfileCallbackIF
        , public DataChangedCallbackIF
        , public DoRegisterAppCallbackIF
//        , public OnDataChangedCallbackIF
//        , public OnProfileDeletedCallbackIF
//        , public OnProfileCopiedCallbackIF
//        , public OnProfileCreatedCallbackIF
//        , public GetProfileTypesCallbackIF
    {
    private:
        DECLARE_CLASS_LOGGER();

        tBool _bSrvAvailable;

    public:
        veda_tclClientProfile(veda_tclAppMain* baseRef);
        virtual ~veda_tclClientProfile();

        // ServiceAvailableIF
        virtual void onAvailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);
        virtual void onUnavailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);

        // TimerCallbackIF
        virtual void onExpired(asf::core::Timer                          & timer,
                               boost::shared_ptr <asf::core::TimerPayload> payload);
        // ActiveProfileCallbackIF
        virtual void onActiveProfileError(const ::boost::shared_ptr< ProfileProxy >& proxy, const boost::shared_ptr< ActiveProfileError >& error);
        virtual void onActiveProfileUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const boost::shared_ptr< ActiveProfileUpdate >& update);

        // StatusCallbackIF
        virtual void onStatusError(const ::boost::shared_ptr< ProfileProxy >& proxy, const boost::shared_ptr< StatusError >& error);
        virtual void onStatusUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const boost::shared_ptr< StatusUpdate >& update);

        // CopyProfileCallbackIF
        virtual void onCopyProfileError(const ::boost::shared_ptr< ProfileProxy >& proxy, const boost::shared_ptr< CopyProfileError >& error);
        virtual void onCopyProfileUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const boost::shared_ptr< CopyProfileUpdate >& update);

        // DeleteProfileCallbackIF
        virtual void onDeleteProfileError(const ::boost::shared_ptr< ProfileProxy >& proxy, const boost::shared_ptr< DeleteProfileError >& error);
        virtual void onDeleteProfileUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const boost::shared_ptr< DeleteProfileUpdate >& update);

        // DataChangedCallbackIF
        virtual void onDataChangedError(const ::boost::shared_ptr< ProfileProxy >& proxy, const boost::shared_ptr< DataChangedError >& error);
        virtual void onDataChangedUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const boost::shared_ptr< DataChangedUpdate >& update);

        // DoRegisterAppCallbackIF
        virtual void onDoRegisterAppError(const ::boost::shared_ptr< ProfileProxy >& proxy, const boost::shared_ptr< DoRegisterAppError >& error);
        virtual void onDoRegisterAppResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const boost::shared_ptr< DoRegisterAppResponse >& response);

        // OnDataChangedCallbackIF
        virtual void onOnDataChangedError(const ::boost::shared_ptr< ProfileProxy >& proxy, const boost::shared_ptr< OnDataChangedError >& error);
        virtual void onOnDataChangedResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const boost::shared_ptr< OnDataChangedResponse >& response);

        // OnProfileDeletedCallbackIF
        virtual void onOnProfileDeletedError(const ::boost::shared_ptr< ProfileProxy >& proxy, const boost::shared_ptr< OnProfileDeletedError >& error);
        virtual void onOnProfileDeletedResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const boost::shared_ptr< OnProfileDeletedResponse >& response);

        // OnProfileCopiedCallbackIF
        virtual void onOnProfileCopiedError(const ::boost::shared_ptr< ProfileProxy >& proxy, const boost::shared_ptr< OnProfileCopiedError >& error);
        virtual void onOnProfileCopiedResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const boost::shared_ptr< OnProfileCopiedResponse >& response);

        // OnProfileCreatedCallbackIF
        virtual void onOnProfileCreatedError(const ::boost::shared_ptr< ProfileProxy >& proxy, const boost::shared_ptr< OnProfileCreatedError >& error);
        virtual void onOnProfileCreatedResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const boost::shared_ptr< OnProfileCreatedResponse >& response);

        // GetProfileTypesCallbackIF
        virtual void onGetProfileTypesError(const ::boost::shared_ptr< ProfileProxy >& proxy, const boost::shared_ptr< GetProfileTypesError >& error);
        virtual void onGetProfileTypesResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const boost::shared_ptr< GetProfileTypesResponse >& response);


    private:

        ::boost::shared_ptr <ProfileProxy> _ProfileProxy;

    public:
        virtual const tChar* getName() const { return "veda_tclClientProfile"; }

        virtual tVoid vHandleMessage(veda_tclBaseIf::TMsg* pMsg);
        virtual tVoid vHandleTraceMessage(const tUChar* puchData) {}  //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
        virtual tVoid vGetReferences();
        virtual tVoid vStartCommunication();
        virtual tVoid vTraceInfo();

        virtual tVoid sendActiveProfileGetValue(tVoid) {
            if (_ProfileProxy) _ProfileProxy->sendActiveProfileGet(* this);
        }

        virtual tVoid sendStatusGetValue(tVoid) {
            if (_ProfileProxy) _ProfileProxy->sendStatusGet(* this);
        }

        virtual tVoid sendCopyProfileGetValue(tVoid) {
            if (_ProfileProxy) _ProfileProxy->sendCopyProfileGet(* this);
        }

        virtual tVoid sendDeleteProfileGetValue(tVoid) {
            if (_ProfileProxy) _ProfileProxy->sendDeleteProfileGet(* this);
        }

        virtual tVoid sendDataChangedGetValue(tVoid) {
            if (_ProfileProxy) _ProfileProxy->sendDataChangedGet(* this);
        }



        // veda_ClientProfileDeclarationsPart: user specific code start
        tU32 _appid;
        // veda_ClientProfileDeclarationsPart: user specific code end
    };

}}}} // namespace org { namespace bosch { namespace cm { namespace veda {

#endif // ifndef _VEDA_CLIENTPROFILE_H

