/*****************************************************************************
 * @file:         veda_ClientProfile.cpp
 * @PROJECT:      CMD project
 * @SW-COMPONENT: vehicledata
 * @Template:     FrancaProxy.cpp.tpl
 * ----------------------------------------------------------------------------
 *
 * @brief:  generated file
 *          Franca interface file
 *
 *          Do manual changes only inside tags
 *
 *          //......................: user specific code start 
 *          //......................: user specific code end 
 *
 * ----------------------------------------------------------------------------
 * @copyright   (c) 2018 Robert Bosch GmbH.
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 *****************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

// veda_ClientProfileIncludePart: user specific code start
#define ERROR 255
#include "I_veda_language_handler.h"
// veda_ClientProfileIncludePart: user specific code end

#include "veda_ClientProfile.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VEHICLEDATA_CLIENT_PROFILE
#include "trcGenProj/Header/veda_ClientProfile.cpp.trc.h"
#endif


namespace org { namespace bosch { namespace cm { namespace veda {

using namespace::asf::core;
using namespace::asf::stream;
using namespace::bosch::cm::profile;

DEFINE_CLASS_LOGGER_AND_LEVEL("org/bosch/cm/veda/veda_tclClientProfile", veda_tclClientProfile, Info);


veda_tclClientProfile::veda_tclClientProfile(veda_tclAppMain* baseRef)
   : Iveda_tclClientProfile(baseRef)
   , _bSrvAvailable(FALSE)
   , _ProfileProxy(ProfileProxy::createProxy("profileFiPort", * this) )
{
   LOG_INFO("Constructor for veda_tclClientProfile called");
   ETG_TRACE_USR1( ( "Constructor for veda_tclClientProfile called" ) );
   
   // veda_ClientProfileveda_tclClientProfile: user specific code start
   _appid = 0;
   // veda_ClientProfileveda_tclClientProfile: user specific code end
}

veda_tclClientProfile::~veda_tclClientProfile(){
   LOG_INFO("~veda_tclClientProfile called");
   ETG_TRACE_USR1( ( "~veda_tclClientProfile called" ) );
   // veda_tclClientProfileveda_tclClientProfileDest: user specific code start
   // veda_tclClientProfileveda_tclClientProfileDest: user specific code end
}

// ServiceAvailableIF
void veda_tclClientProfile::onAvailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange){
   (tVoid)stateChange;

   ETG_TRACE_USR1( ( "veda_tclClientProfile::onAvailable(): CALLED" ) );
   if (_ProfileProxy == proxy){
      ETG_TRACE_USR1( ( "veda_tclClientProfile : onAvailable _ProfileProxy " ) );

      _ProfileProxy->sendActiveProfileGet(* this);
      _ProfileProxy->sendActiveProfileRegister(* this);
      _ProfileProxy->sendStatusGet(* this);
      _ProfileProxy->sendStatusRegister(* this);
      _ProfileProxy->sendCopyProfileGet(* this);
      _ProfileProxy->sendCopyProfileRegister(* this);
      _ProfileProxy->sendDeleteProfileGet(* this);
      _ProfileProxy->sendDeleteProfileRegister(* this);
      _ProfileProxy->sendDataChangedGet(* this);
      _ProfileProxy->sendDataChangedRegister(* this);

      _bSrvAvailable = TRUE;
   }
   // veda_ClientProfileonAvailable: user specific code start
   // veda_ClientProfileonAvailable: user specific code end
}

void veda_tclClientProfile::onUnavailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange){
   (tVoid)stateChange;
   ETG_TRACE_USR1( ( "veda_tclClientProfile::onUnavailable(): CALLED" ) );
   if (_ProfileProxy == proxy){
      _bSrvAvailable = FALSE;
      ETG_TRACE_USR1( ( "veda_tclClientProfile : onUnavailable _ProfileProxy " ) );
   }
   // veda_ClientProfileonUnavailable: user specific code start
   // veda_ClientProfileonUnavailable: user specific code end

}

// TimerCallbackIF
void veda_tclClientProfile::onExpired(asf::core::Timer& timer, boost::shared_ptr <asf::core::TimerPayload> payload){
   // veda_ClientProfileonExpired: user specific code start
   // veda_ClientProfileonExpired: user specific code end
}
void veda_tclClientProfile::onActiveProfileError(const::boost::shared_ptr <ProfileProxy>  & proxy, const boost::shared_ptr <ActiveProfileError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "veda_tclClientProfile::onActiveProfileError(): CALLED" ) );
   // veda_ClientProfileonActiveProfileError: user specific code start
   // veda_ClientProfileonActiveProfileError: user specific code end
}
void veda_tclClientProfile::onActiveProfileUpdate(const::boost::shared_ptr <ProfileProxy> & proxy, const boost::shared_ptr <ActiveProfileUpdate>& update){
   (tVoid)proxy;
   (tVoid)update;
   ETG_TRACE_USR1( ( "veda_tclClientProfile::onActiveProfileUpdate(): CALLED" ) );
   // veda_ClientProfileonActiveProfileUpdate: user specific code start
   // veda_ClientProfileonActiveProfileUpdate: user specific code end
}

void veda_tclClientProfile::onStatusError(const::boost::shared_ptr <ProfileProxy>  & proxy, const boost::shared_ptr <StatusError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "veda_tclClientProfile::onStatusError(): CALLED" ) );
   // veda_ClientProfileonStatusError: user specific code start
   // veda_ClientProfileonStatusError: user specific code end
}
void veda_tclClientProfile::onStatusUpdate(const::boost::shared_ptr <ProfileProxy> & proxy, const boost::shared_ptr <StatusUpdate>& update){
   (tVoid)proxy;
   (tVoid)update;
   ETG_TRACE_USR1( ( "veda_tclClientProfile::onStatusUpdate(): CALLED" ) );
   // veda_ClientProfileonStatusUpdate: user specific code start
   // veda_ClientProfileonStatusUpdate: user specific code end
}

void veda_tclClientProfile::onCopyProfileError(const::boost::shared_ptr <ProfileProxy>  & proxy, const boost::shared_ptr <CopyProfileError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "veda_tclClientProfile::onCopyProfileError(): CALLED" ) );
   // veda_ClientProfileonCopyProfileError: user specific code start
   // veda_ClientProfileonCopyProfileError: user specific code end
}
void veda_tclClientProfile::onCopyProfileUpdate(const::boost::shared_ptr <ProfileProxy> & proxy, const boost::shared_ptr <CopyProfileUpdate>& update){
   (tVoid)proxy;
   (tVoid)update;
   ETG_TRACE_USR1( ( "veda_tclClientProfile::onCopyProfileUpdate(): CALLED" ) );
   // veda_ClientProfileonCopyProfileUpdate: user specific code start
   // veda_ClientProfileonCopyProfileUpdate: user specific code end
}

void veda_tclClientProfile::onDeleteProfileError(const::boost::shared_ptr <ProfileProxy>  & proxy, const boost::shared_ptr <DeleteProfileError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "veda_tclClientProfile::onDeleteProfileError(): CALLED" ) );
   // veda_ClientProfileonDeleteProfileError: user specific code start
   // veda_ClientProfileonDeleteProfileError: user specific code end
}
void veda_tclClientProfile::onDeleteProfileUpdate(const::boost::shared_ptr <ProfileProxy> & proxy, const boost::shared_ptr <DeleteProfileUpdate>& update){
   (tVoid)proxy;
   (tVoid)update;
   ETG_TRACE_USR1( ( "veda_tclClientProfile::onDeleteProfileUpdate(): CALLED" ) );
   // veda_ClientProfileonDeleteProfileUpdate: user specific code start
   Iveda_tclLanguageHandler* pLanguageHandler = dynamic_cast<Iveda_tclLanguageHandler*>(_cpoMain->getHandler("Iveda_tclLanguageHandler"));
   tU8 u8delprofile = update->getDeleteProfile();
   ETG_TRACE_USR1( ( "vehfunc_tclClientProfile::onDeleteProfileUpdate():delete profile %d",u8delprofile ) );
   if(u8delprofile != ERROR){
	   if (pLanguageHandler)
	   {
		   pLanguageHandler->_vUpdateLanguageProfile();
	   }
	   clientResult eRes = clientResult__SUCCESS;
	   _ProfileProxy->sendOnProfileDeletedRequest(_appid,eRes);
   }
   // veda_ClientProfileonDeleteProfileUpdate: user specific code end
}

void veda_tclClientProfile::onDataChangedError(const::boost::shared_ptr <ProfileProxy>  & proxy, const boost::shared_ptr <DataChangedError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "veda_tclClientProfile::onDataChangedError(): CALLED" ) );
   // veda_ClientProfileonDataChangedError: user specific code start
   // veda_ClientProfileonDataChangedError: user specific code end
}
void veda_tclClientProfile::onDataChangedUpdate(const::boost::shared_ptr <ProfileProxy> & proxy, const boost::shared_ptr <DataChangedUpdate>& update){
   (tVoid)proxy;
   (tVoid)update;
   ETG_TRACE_USR1( ( "veda_tclClientProfile::onDataChangedUpdate(): CALLED" ) );
   // veda_ClientProfileonDataChangedUpdate: user specific code start
   dataChangedResult eResult = dataChangedResult__PREPARED;//Note: update the enum value before using
   dataChangeReason eReason = update->getDataChanged();
   Iveda_tclLanguageHandler* pLanguageHandler = dynamic_cast<Iveda_tclLanguageHandler*>(_cpoMain->getHandler("Iveda_tclLanguageHandler"));

   switch(eReason)
   {
   case dataChangeReason__IDLE:
	   break;
   case dataChangeReason__PROFILE_RESET:
	   break;
   case dataChangeReason__PROFILE_CHANGED:
	   ETG_TRACE_USR1( ( "vehfunc_tclClientProfile::onDataChangedUpdate(): dataChangeReason__PROFILE_CHANGED" ) );
	   //TODO:load the settings for the current user profile,send the ack once settings are loaded
	   if (pLanguageHandler)
	   {
		   pLanguageHandler->_vUpdateLanguageProfile();
	   }
	   eResult = dataChangedResult__PROFILE_CHANGED;
	   _ProfileProxy->sendOnDataChangedRequest(_appid,eResult);
	   break;
   case dataChangeReason__DOWNLOAD:
	   break;
   case dataChangeReason__PREPARE:
	   ETG_TRACE_USR1( ( "vehfunc_tclClientProfile::onDataChangedUpdate(): dataChangeReason__PROFILE_CHANGED" ) );
	   //pSettingHandler->vWritetoDatapool();
	   eResult = dataChangedResult__PREPARED;
	   _ProfileProxy->sendOnDataChangedRequest(_appid,eResult);
	   break;
   }
   // veda_ClientProfileonDataChangedUpdate: user specific code end
}

void veda_tclClientProfile::onDoRegisterAppError(const::boost::shared_ptr <ProfileProxy>  & proxy, const boost::shared_ptr <DoRegisterAppError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "veda_tclClientProfile::onDoRegisterAppError(): CALLED" ) );
   // veda_ClientProfileonDoRegisterAppError: user specific code start
   // veda_ClientProfileonDoRegisterAppError: user specific code end
}
void veda_tclClientProfile::onDoRegisterAppResponse(const::boost::shared_ptr <ProfileProxy> & proxy, const boost::shared_ptr <DoRegisterAppResponse>& response){
   (tVoid)proxy;
   (tVoid)response;
   ETG_TRACE_USR1( ( "veda_tclClientProfile::onDoRegisterAppResponse(): CALLED" ) );
   // veda_ClientProfileonDoRegisterAppResponse: user specific code start
   _appid = response->getAppID();
   // veda_ClientProfileonDoRegisterAppResponse: user specific code end
}

void veda_tclClientProfile::onOnDataChangedError(const::boost::shared_ptr <ProfileProxy>  & proxy, const boost::shared_ptr <OnDataChangedError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "veda_tclClientProfile::onOnDataChangedError(): CALLED" ) );
   // veda_ClientProfileonOnDataChangedError: user specific code start
   // veda_ClientProfileonOnDataChangedError: user specific code end
}
void veda_tclClientProfile::onOnDataChangedResponse(const::boost::shared_ptr <ProfileProxy> & proxy, const boost::shared_ptr <OnDataChangedResponse>& response){
   (tVoid)proxy;
   (tVoid)response;
   ETG_TRACE_USR1( ( "veda_tclClientProfile::onOnDataChangedResponse(): CALLED" ) );
   // veda_ClientProfileonOnDataChangedResponse: user specific code start
   // veda_ClientProfileonOnDataChangedResponse: user specific code end
}

void veda_tclClientProfile::onOnProfileDeletedError(const::boost::shared_ptr <ProfileProxy>  & proxy, const boost::shared_ptr <OnProfileDeletedError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "veda_tclClientProfile::onOnProfileDeletedError(): CALLED" ) );
   // veda_ClientProfileonOnProfileDeletedError: user specific code start
   // veda_ClientProfileonOnProfileDeletedError: user specific code end
}
void veda_tclClientProfile::onOnProfileDeletedResponse(const::boost::shared_ptr <ProfileProxy> & proxy, const boost::shared_ptr <OnProfileDeletedResponse>& response){
   (tVoid)proxy;
   (tVoid)response;
   ETG_TRACE_USR1( ( "veda_tclClientProfile::onOnProfileDeletedResponse(): CALLED" ) );
   // veda_ClientProfileonOnProfileDeletedResponse: user specific code start
   // veda_ClientProfileonOnProfileDeletedResponse: user specific code end
}

void veda_tclClientProfile::onOnProfileCopiedError(const::boost::shared_ptr <ProfileProxy>  & proxy, const boost::shared_ptr <OnProfileCopiedError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "veda_tclClientProfile::onOnProfileCopiedError(): CALLED" ) );
   // veda_ClientProfileonOnProfileCopiedError: user specific code start
   // veda_ClientProfileonOnProfileCopiedError: user specific code end
}
void veda_tclClientProfile::onOnProfileCopiedResponse(const::boost::shared_ptr <ProfileProxy> & proxy, const boost::shared_ptr <OnProfileCopiedResponse>& response){
   (tVoid)proxy;
   (tVoid)response;
   ETG_TRACE_USR1( ( "veda_tclClientProfile::onOnProfileCopiedResponse(): CALLED" ) );
   // veda_ClientProfileonOnProfileCopiedResponse: user specific code start
   // veda_ClientProfileonOnProfileCopiedResponse: user specific code end
}

void veda_tclClientProfile::onOnProfileCreatedError(const::boost::shared_ptr <ProfileProxy>  & proxy, const boost::shared_ptr <OnProfileCreatedError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "veda_tclClientProfile::onOnProfileCreatedError(): CALLED" ) );
   // veda_ClientProfileonOnProfileCreatedError: user specific code start
   // veda_ClientProfileonOnProfileCreatedError: user specific code end
}
void veda_tclClientProfile::onOnProfileCreatedResponse(const::boost::shared_ptr <ProfileProxy> & proxy, const boost::shared_ptr <OnProfileCreatedResponse>& response){
   (tVoid)proxy;
   (tVoid)response;
   ETG_TRACE_USR1( ( "veda_tclClientProfile::onOnProfileCreatedResponse(): CALLED" ) );
   // veda_ClientProfileonOnProfileCreatedResponse: user specific code start
   // veda_ClientProfileonOnProfileCreatedResponse: user specific code end
}

void veda_tclClientProfile::onGetProfileTypesError(const::boost::shared_ptr <ProfileProxy>  & proxy, const boost::shared_ptr <GetProfileTypesError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "veda_tclClientProfile::onGetProfileTypesError(): CALLED" ) );
   // veda_ClientProfileonGetProfileTypesError: user specific code start
   // veda_ClientProfileonGetProfileTypesError: user specific code end
}
void veda_tclClientProfile::onGetProfileTypesResponse(const::boost::shared_ptr <ProfileProxy> & proxy, const boost::shared_ptr <GetProfileTypesResponse>& response){
   (tVoid)proxy;
   (tVoid)response;
   ETG_TRACE_USR1( ( "veda_tclClientProfile::onGetProfileTypesResponse(): CALLED" ) );
   // veda_ClientProfileonGetProfileTypesResponse: user specific code start
   // veda_ClientProfileonGetProfileTypesResponse: user specific code end
}



tVoid veda_tclClientProfile::vHandleMessage(veda_tclBaseIf::TMsg* pMsg) {
   // veda_ClientProfilevHandleMessage: user specific code start
   // veda_ClientProfilevHandleMessage: user specific code end
}

tVoid veda_tclClientProfile::vGetReferences() {
   // veda_ClientProfilevGetReferences: user specific code start
   // veda_ClientProfilevGetReferences: user specific code end
}

tVoid veda_tclClientProfile::vStartCommunication() {
   // veda_ClientProfilevStartCommunication: user specific code start
   // veda_ClientProfilevStartCommunication: user specific code end
}

tVoid veda_tclClientProfile::vTraceInfo() {
   // veda_ClientProfilevTraceInfo: user specific code start
   // veda_ClientProfilevTraceInfo: user specific code end
}

// veda_ClientProfileDefinitioPart: user specific code start
// veda_ClientProfileDefinitioPart: user specific code end

}}}} // namespace org { namespace bosch { namespace cm { namespace veda {

