
#ifndef _VEDA_CLIENTSPM_H
#define _VEDA_CLIENTSPM_H

/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          veda_ClientSpm.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: vehicledata
  * @Template:     CcaProxy.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                CCA client
  *
  *                Do manual changes only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2017 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#include <iostream>

#include "asf/core/Logger.h"
#include "asf/core/Proxy.h"

#include "SPM_CORE_FIProxy.h"

#include "asf/stream/MemoryStream.h"

#include "Iveda_ClientSpm.h"

// veda_ClientSpmInclude: user specific code start
class Iveda_tclApplHandler;
class Iveda_tclServiceVehicleIf;
// veda_ClientSpmInclude: user specific code end

namespace org { namespace bosch { namespace cm { namespace veda {

    using namespace::asf::core;
    using namespace::asf::stream;
    using namespace::SPM_CORE_FI;
    using namespace::asf::core;
    using namespace::org::bosch::cm::veda;

    // veda_Server__SERVER_NAME__NameSpace: user specific code start
    // veda_Server__SERVER_NAME__NameSpace: user specific code end

    class veda_tclClientSpm : public Iveda_tclClientSpm
        , public ServiceAvailableIF
        , public CvmEventCallbackIF
        , public SysPwrModeCallbackIF
    {
    private:
        DECLARE_CLASS_LOGGER();

        tBool _bSrvAvailable;

    public:
        veda_tclClientSpm(veda_tclAppMain* baseRef);
        virtual ~veda_tclClientSpm();

        // ServiceAvailableIF
        virtual void onAvailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);

        virtual void onUnavailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);

        // CvmEventCallbackIF
        virtual void onCvmEventError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< CvmEventError >& error);
        virtual void onCvmEventStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< CvmEventStatus >& status);

        // SysPwrModeCallbackIF
        virtual void onSysPwrModeError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SysPwrModeError >& error);
        virtual void onSysPwrModeStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SysPwrModeStatus >& status);

    private:

        ::boost::shared_ptr <SPM_CORE_FIProxy> _SpmProxy;

    public:
        virtual const tChar* getName() const { return "veda_tclClientSpm"; }

        virtual tVoid vHandleMessage(veda_tclBaseIf::TMsg* pMsg);
        virtual tVoid vHandleTraceMessage(const tUChar* puchData) {} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
        virtual tVoid vGetReferences();
        virtual tVoid vStartCommunication();
        virtual tVoid vTraceInfo();

        virtual tVoid sendSysPwrModeGet();
        virtual tVoid sendCvmEventGet();

        // veda_ClientSpmDeclarationsPart: user specific code start
        tVoid vHandleSysPowerModeUpdate(tBool bNewAccessoryState, tBool bNewIgnitionState);
        
        tBool _bCurrentIgnitionState;
        tBool _bCurrentAccessoryState;
        
        Iveda_tclApplHandler* _poApplHdl;
        Iveda_tclServiceVehicleIf* _poCCAServiceHdl;
        // veda_ClientSpmDeclarationsPart: user specific code end
    };

}}}} // namespace org { namespace bosch { namespace cm { namespace veda {

#endif // ifndef _VEDA_CLIENTSPM_H
