/*****************************************************************************
 * @file:         veda_ClientSpm.cpp
 * @PROJECT:      CMD project
 * @SW-COMPONENT: vehicledata
 * @Template:     CcaProxy.cpp.tpl
 * ----------------------------------------------------------------------------
 *
 * @brief:  generated file
 *          CCA client
 *
 *          Do manual changes only inside tags
 *
 *          //......................: user specific code start 
 *          //......................: user specific code end 
 *
 * ----------------------------------------------------------------------------
 * @copyright   (c) 2017 Robert Bosch GmbH.
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 *****************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"


// veda_ClientSpmIncludePart: user specific code start
#include "I_veda_appl_handler.h"
#include "I_veda_ServiceVehicleIf.h"
// veda_ClientSpmIncludePart: user specific code end

#include "veda_ClientSpm.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VEHICLEDATA_CLIENT_SPM
#include "trcGenProj/Header/veda_ClientSpm.cpp.trc.h"
#endif


namespace org { namespace bosch { namespace cm { namespace veda {

using namespace::asf::core;
using namespace::asf::stream;
using namespace::SPM_CORE_FI;

// veda_ClientSpmIncludePart2: user specific code start
// veda_ClientSpmIncludePart2: user specific code end

DEFINE_CLASS_LOGGER_AND_LEVEL("org/bosch/cm/Veda/veda_tclClientSpm", veda_tclClientSpm, Info);


veda_tclClientSpm::veda_tclClientSpm(veda_tclAppMain* baseRef)
   : Iveda_tclClientSpm(baseRef)
   , _bSrvAvailable(FALSE)
   , _SpmProxy(SPM_CORE_FIProxy::createProxy("spmFiPort", * this) )
{
   LOG_INFO("Constructor for veda_tclClientSpm called");
   ETG_TRACE_USR1( ( "Constructor for veda_tclClientSpm called" ) );
   
   // veda_ClientSpmveda_tclClientSpm: user specific code start
   _poApplHdl = NULL;
   _poCCAServiceHdl = NULL;
   _bCurrentIgnitionState = FALSE;
   _bCurrentAccessoryState = FALSE;
   // veda_ClientSpmveda_tclClientSpm: user specific code end
}

veda_tclClientSpm::~veda_tclClientSpm(){
   LOG_INFO("~veda_tclClientSpm called");
   ETG_TRACE_USR1( ( "~veda_tclClientSpm called" ) );
   
   // veda_ClientSpmveda_tclClientSpmDest: user specific code start
   _poApplHdl = NULL;
   _poCCAServiceHdl = NULL;
   // veda_ClientSpmveda_tclClientSpmDest: user specific code end
}

void veda_tclClientSpm::onAvailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange){
   (tVoid)stateChange;

   ETG_TRACE_USR1( ( "veda_tclClientSpm::onAvailable(): CALLED" ) );
   if (_SpmProxy == proxy){
      ETG_TRACE_USR1( ( "veda_tclClientSpm : onAvailable _SpmProxy " ) );
      _SpmProxy->sendCvmEventUpReg(* this);
      _SpmProxy->sendSysPwrModeUpReg(* this);

      // !!! Any UpReg's with parameter will not be generated --> parameter value are specific !!!

      // veda_ClientSpmonAvailableUpregParam: user specific code start
      // veda_ClientSpmonAvailableUpregParam: user specific code end

      _bSrvAvailable = TRUE;
   }
   // veda_ClientSpmonAvailable: user specific code start
   // veda_ClientSpmonAvailable: user specific code end
}

void veda_tclClientSpm::onUnavailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange){
   (tVoid)stateChange;
   ETG_TRACE_USR1( ( "veda_tclClientSpm::onUnavailable(): CALLED" ) );
   if (_SpmProxy == proxy){
      _bSrvAvailable = FALSE;
      ETG_TRACE_USR1( ( "veda_tclClientSpm : onUnavailable _SpmProxy " ) );
   }
   // veda_ClientSpmonUnavailable: user specific code start
   // veda_ClientSpmonUnavailable: user specific code end

}

void veda_tclClientSpm::onCvmEventError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <CvmEventError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "veda_tclClientSpm::onCvmEventError(): CALLED" ) );
   // veda_ClientSpmonCvmEventError: user specific code start
   // veda_ClientSpmonCvmEventError: user specific code end
}

void veda_tclClientSpm::onCvmEventStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <CvmEventStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "veda_tclClientSpm::onCvmEventStatus(): CALLED" ) );

   // veda_ClientSpmonCvmEventStart: user specific code start
   ETG_TRACE_USR1( ( "veda_tclClientSpm::onCvmEventStatus Received as %u", 
                      ETG_CENUM(::spm_core_fi_types::T_SPM_e32_CVM_EVENT, status->getCvmEvent()) ) );
   veda_tclBaseIf::TMsg oMsg;
   (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
   oMsg.eCmd = eCvmEvent;
   oMsg.strClassName[0]=0;

   switch (status->getCvmEvent())
   {
   case ::spm_core_fi_types::T_SPM_e32_CVM_EVENT__SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_START:
   case ::spm_core_fi_types::T_SPM_e32_CVM_EVENT__SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_START:
   case ::spm_core_fi_types::T_SPM_e32_CVM_EVENT__SPM_U32_CVM_LOW_VOLTAGE_START:
   case ::spm_core_fi_types::T_SPM_e32_CVM_EVENT__SPM_U32_CVM_HIGH_VOLTAGE_START:
      {
         ETG_TRACE_USR1( ( "veda_tclClientSpmIf::Abnormal Voltage Started" ) );
         oMsg.u.u32Data = 0x01;
      }
      break;

   case ::spm_core_fi_types::T_SPM_e32_CVM_EVENT__SPM_U32_CVM_HIGH_VOLTAGE_END:
   case ::spm_core_fi_types::T_SPM_e32_CVM_EVENT__SPM_U32_CVM_LOW_VOLTAGE_END:
   case ::spm_core_fi_types::T_SPM_e32_CVM_EVENT__SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_END:
   case ::spm_core_fi_types::T_SPM_e32_CVM_EVENT__SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_END:
      {
         ETG_TRACE_USR1( ( "veda_tclClientSpmIf::Abnormal Voltage Ended" ) );
         oMsg.u.u32Data = 0x00;
      }
      break;

   default:      
      oMsg.u.u32Data = 0x00;
      break;
   };

   _cpoMain->theServer()->vPostInternalMessage(&oMsg);
   // veda_ClientSpmonCvmEventStart: user specific code end
}

void veda_tclClientSpm::onSysPwrModeError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <SysPwrModeError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "veda_tclClientSpm::onSysPwrModeError(): CALLED" ) );
   // veda_ClientSpmonSysPwrModeError: user specific code start
   // veda_ClientSpmonSysPwrModeError: user specific code end
}

void veda_tclClientSpm::onSysPwrModeStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <SysPwrModeStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "veda_tclClientSpm::onSysPwrModeStatus(): CALLED" ) );

   // veda_ClientSpmonSysPwrModeStart: user specific code start
   ETG_TRACE_USR1( ( "veda_tclClientSpm::onSysPwrModeStatus Received as %u", 
                      ETG_CENUM(::spm_core_fi_types::T_SPM_e32_SYSPWRMODE, (status->getSysPwrMode())) ) );
   
   tBool bNewIgnitionState = FALSE;
   tBool bNewAccessoryState = FALSE;

   switch (status->getSysPwrMode())
   {
   case ::spm_core_fi_types::T_SPM_e32_SYSPWRMODE__SPM_U32_SYSPWRMODE_ACCESSORY:
   {
	   // Battery and ACC ON
	   bNewIgnitionState = FALSE;
	   bNewAccessoryState = TRUE;
   }
   break;
   case ::spm_core_fi_types::T_SPM_e32_SYSPWRMODE__SPM_U32_SYSPWRMODE_RUN:
   case ::spm_core_fi_types::T_SPM_e32_SYSPWRMODE__SPM_U32_SYSPWRMODE_CRANK:
   {
	   // Ignition ON
	   bNewIgnitionState = TRUE;
	   bNewAccessoryState = TRUE;
   }
   break;
   default:
   {
	   // Battery and ACC OFF
	   bNewIgnitionState = FALSE;
	   bNewAccessoryState = FALSE;
   }
   break;
   };

   vHandleSysPowerModeUpdate(bNewAccessoryState, bNewIgnitionState);
   // veda_ClientSpmonSysPwrModeStart: user specific code end
}


tVoid veda_tclClientSpm::vHandleMessage(veda_tclBaseIf::TMsg* pMsg) {
   // veda_ClientSpmvHandleMessage: user specific code start
   (tVoid) pMsg;
   // veda_ClientSpmvHandleMessage: user specific code end
}

tVoid veda_tclClientSpm::vGetReferences() {
   // veda_ClientSpmvGetReferences: user specific code start
   _poApplHdl = dynamic_cast<Iveda_tclApplHandler*>(_cpoMain->getHandler("Iveda_tclApplHandler"));
   VEDA_NULL_POINTER_CHECK(_poApplHdl);

   _poCCAServiceHdl = dynamic_cast<Iveda_tclServiceVehicleIf*>(_cpoMain->theServer()->getHandler("Iveda_tclServiceVehicleIf"));
   VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
   // veda_ClientSpmvGetReferences: user specific code end
}

tVoid veda_tclClientSpm::vStartCommunication() {
   // veda_ClientSpmvStartCommunication: user specific code start
   // veda_ClientSpmvStartCommunication: user specific code end
}

tVoid veda_tclClientSpm::vTraceInfo() {
   // veda_ClientSpmvTraceInfo: user specific code start
   // veda_ClientSpmvTraceInfo: user specific code end
}

tVoid veda_tclClientSpm::sendSysPwrModeGet() {
    // veda_tclClientSpm::sendSysPwrModeGet: user specific code start
    // veda_tclClientSpm::sendSysPwrModeGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendSysPwrModeGet(* this);

    // veda_tclClientSpm::sendSysPwrModeGetEnd: user specific code start
    // veda_tclClientSpm::sendSysPwrModeGetEnd: user specific code end
}
tVoid veda_tclClientSpm::sendCvmEventGet() {
    // veda_tclClientSpm::sendCvmEventGet: user specific code start
    // veda_tclClientSpm::sendCvmEventGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendCvmEventGet(* this);

    // veda_tclClientSpm::sendCvmEventGetEnd: user specific code start
    // veda_tclClientSpm::sendCvmEventGetEnd: user specific code end
}

// veda_ClientSpmDefinitioPart: user specific code start
tVoid veda_tclClientSpm::vHandleSysPowerModeUpdate(tBool bNewAccessoryState, tBool bNewIgnitionState)
{
	if ( _bCurrentAccessoryState != bNewAccessoryState )
	{
		_bCurrentAccessoryState = bNewAccessoryState;

		tChar cClassName[] = "I_veda_tclClientVcan";
		_cpoMain->theServer()->vPostMsgAccessoryStateChanged(cClassName, _bCurrentAccessoryState);
	}

	if ( _bCurrentIgnitionState != bNewIgnitionState )
	{
		_bCurrentIgnitionState = bNewIgnitionState;

		tChar cClassName[] = "I_veda_tclClientVcan";
		_cpoMain->theServer()->vPostMsgIgnitionStateChanged(cClassName, _bCurrentIgnitionState);

		// communicate it to all the CCA clients
		vehicle_fi_tcl_e8_Vehicle_Ignition oIgnition;

		if ( _bCurrentIgnitionState )
			oIgnition.enType = vehicle_fi_tcl_e8_Vehicle_Ignition::FI_EN_ON;
		else
			oIgnition.enType = vehicle_fi_tcl_e8_Vehicle_Ignition::FI_EN_OFF;

		// communicate it to the clients
		VEDA_NULL_POINTER_CHECK(_poCCAServiceHdl);
		_poCCAServiceHdl->sendIgnitionStatus(oIgnition);
	}
}
// veda_ClientSpmDefinitioPart: user specific code end

}}}} // namespace org { namespace bosch { namespace cm { namespace veda {
