
#ifndef _VEDA_CLIENTDIAGLOG_H
#define _VEDA_CLIENTDIAGLOG_H

/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          veda_ClientDiaglog.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: vehicledata
  * @Template:     CcaProxy.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                CCA client
  *
  *                Do manual changes only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2017 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#include <iostream>

#include "asf/core/Logger.h"
#include "asf/core/Proxy.h"

#include "diaglog_main_fiProxy.h"

#include "asf/stream/MemoryStream.h"

#include "Iveda_ClientDiaglog.h"

// veda_ClientDiaglogInclude: user specific code start
// veda_ClientDiaglogInclude: user specific code end

namespace org { namespace bosch { namespace cm { namespace veda {

    using namespace::asf::core;
    using namespace::asf::stream;
    using namespace::diaglog_main_fi;
    using namespace::asf::core;
    using namespace::org::bosch::cm::veda;

    // veda_Server__SERVER_NAME__NameSpace: user specific code start
    // veda_Server__SERVER_NAME__NameSpace: user specific code end

    class veda_tclClientDiaglog : public Iveda_tclClientDiaglog
        , public ServiceAvailableIF
        , public SaveTestResultCallbackIF
        , public SendNextTestResultCallbackIF
    {
    private:
        DECLARE_CLASS_LOGGER();

        tBool _bSrvAvailable;

    public:
        veda_tclClientDiaglog(veda_tclAppMain* baseRef);
        virtual ~veda_tclClientDiaglog();

        // ServiceAvailableIF
        virtual void onAvailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);

        virtual void onUnavailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);

        // SaveTestResultCallbackIF
        virtual void onSaveTestResultError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const boost::shared_ptr< SaveTestResultError >& error);
        virtual void onSaveTestResultResult(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const boost::shared_ptr< SaveTestResultResult >& result);

        // SendNextTestResultCallbackIF
        virtual void onSendNextTestResultError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const boost::shared_ptr< SendNextTestResultError >& error);
        virtual void onSendNextTestResultStatus(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const boost::shared_ptr< SendNextTestResultStatus >& status);

    private:

        ::boost::shared_ptr <Diaglog_main_fiProxy> _DiaglogProxy;

    public:
        virtual const tChar* getName() const { return "veda_tclClientDiaglog"; }

        virtual tVoid vHandleMessage(veda_tclBaseIf::TMsg* pMsg);
        virtual tVoid vHandleTraceMessage(const tUChar* puchData) {} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
        virtual tVoid vGetReferences();
        virtual tVoid vStartCommunication();
        virtual tVoid vTraceInfo();

        virtual tVoid sendSaveTestResultStart(::diaglog_main_fi_types::T_TestResultList testResultList);

        // veda_ClientDiaglogDeclarationsPart: user specific code start
        tBool _bIsStartMResultPending;
        ::diaglog_main_fi_types::T_TestResultList _TestResultList;
        virtual tVoid prepareSaveTestResultData(const tU16 u16ITCId, const tU8 u8Status);
        // veda_ClientDiaglogDeclarationsPart: user specific code end
    };

}}}} // namespace org { namespace bosch { namespace cm { namespace veda {

#endif // ifndef _VEDA_CLIENTDIAGLOG_H
