/*****************************************************************************
 * @file:         veda_ClientDiaglog.cpp
 * @PROJECT:      CMD project
 * @SW-COMPONENT: vehicledata
 * @Template:     CcaProxy.cpp.tpl
 * ----------------------------------------------------------------------------
 *
 * @brief:  generated file
 *          CCA client
 *
 *          Do manual changes only inside tags
 *
 *          //......................: user specific code start 
 *          //......................: user specific code end 
 *
 * ----------------------------------------------------------------------------
 * @copyright   (c) 2017 Robert Bosch GmbH.
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 *****************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"


// veda_ClientDiaglogIncludePart: user specific code start
// veda_ClientDiaglogIncludePart: user specific code end

#include "veda_ClientDiaglog.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VEHICLEDATA_CLIENT_DIAGLOG
#include "trcGenProj/Header/veda_ClientDiaglog.cpp.trc.h"
#endif


namespace org { namespace bosch { namespace cm { namespace veda {

using namespace::asf::core;
using namespace::asf::stream;
using namespace::diaglog_main_fi;

// veda_ClientDiaglogIncludePart2: user specific code start
// veda_ClientDiaglogIncludePart2: user specific code end

DEFINE_CLASS_LOGGER_AND_LEVEL("org/bosch/cm/Veda/veda_tclClientDiaglog", veda_tclClientDiaglog, Info);


veda_tclClientDiaglog::veda_tclClientDiaglog(veda_tclAppMain* baseRef)
   : Iveda_tclClientDiaglog(baseRef)
   , _bSrvAvailable(FALSE)
   , _DiaglogProxy(Diaglog_main_fiProxy::createProxy("diaglogFiPort", * this) )
{
   LOG_INFO("Constructor for veda_tclClientDiaglog called");
   ETG_TRACE_USR1( ( "Constructor for veda_tclClientDiaglog called" ) );
   
   // veda_ClientDiaglogveda_tclClientDiaglog: user specific code start
   _TestResultList.clear();
   _bIsStartMResultPending = FALSE;
   // veda_ClientDiaglogveda_tclClientDiaglog: user specific code end
}

veda_tclClientDiaglog::~veda_tclClientDiaglog(){
   LOG_INFO("~veda_tclClientDiaglog called");
   ETG_TRACE_USR1( ( "~veda_tclClientDiaglog called" ) );
   
   // veda_ClientDiaglogveda_tclClientDiaglogDest: user specific code start
   // veda_ClientDiaglogveda_tclClientDiaglogDest: user specific code end
}

void veda_tclClientDiaglog::onAvailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange){
   (tVoid)stateChange;

   ETG_TRACE_USR1( ( "veda_tclClientDiaglog::onAvailable(): CALLED" ) );
   if (_DiaglogProxy == proxy){
      ETG_TRACE_USR1( ( "veda_tclClientDiaglog : onAvailable _DiaglogProxy " ) );
      _DiaglogProxy->sendSendNextTestResultUpReg(* this);

      // !!! Any UpReg's with parameter will not be generated --> parameter value are specific !!!

      // veda_ClientDiaglogonAvailableUpregParam: user specific code start
      if ( _bIsStartMResultPending )
      {
         sendSaveTestResultStart(_TestResultList);
         _bIsStartMResultPending = FALSE;
      }
      else
      {
         ETG_TRACE_USR4(("veda_tclClientDiaglog::onAvailable() _bIsStartMResultPending Not Pending"));
      }
      // veda_ClientDiaglogonAvailableUpregParam: user specific code end

      _bSrvAvailable = TRUE;
   }
   // veda_ClientDiaglogonAvailable: user specific code start
   // veda_ClientDiaglogonAvailable: user specific code end
}

void veda_tclClientDiaglog::onUnavailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange){
   (tVoid)stateChange;
   ETG_TRACE_USR1( ( "veda_tclClientDiaglog::onUnavailable(): CALLED" ) );
   if (_DiaglogProxy == proxy){
      _bSrvAvailable = FALSE;
      ETG_TRACE_USR1( ( "veda_tclClientDiaglog : onUnavailable _DiaglogProxy " ) );
   }
   // veda_ClientDiaglogonUnavailable: user specific code start
   // veda_ClientDiaglogonUnavailable: user specific code end

}

void veda_tclClientDiaglog::onSaveTestResultError(const::boost::shared_ptr <Diaglog_main_fiProxy>  & proxy, const boost::shared_ptr <SaveTestResultError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "veda_tclClientDiaglog::onSaveTestResultError(): CALLED" ) );
   // veda_ClientDiaglogonSaveTestResultError: user specific code start
   // veda_ClientDiaglogonSaveTestResultError: user specific code end
}

void veda_tclClientDiaglog::onSaveTestResultResult(const::boost::shared_ptr <Diaglog_main_fiProxy> & proxy, const boost::shared_ptr <SaveTestResultResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "veda_tclClientDiaglog::onSaveTestResultResult(): CALLED" ) );

   // veda_ClientDiaglogonSaveTestResultResult: user specific code start
   // veda_ClientDiaglogonSaveTestResultResult: user specific code end
}
void veda_tclClientDiaglog::onSendNextTestResultError(const::boost::shared_ptr <Diaglog_main_fiProxy>  & proxy, const boost::shared_ptr <SendNextTestResultError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "veda_tclClientDiaglog::onSendNextTestResultError(): CALLED" ) );
   // veda_ClientDiaglogonSendNextTestResultError: user specific code start
   // veda_ClientDiaglogonSendNextTestResultError: user specific code end
}

void veda_tclClientDiaglog::onSendNextTestResultStatus(const::boost::shared_ptr <Diaglog_main_fiProxy> & proxy, const boost::shared_ptr <SendNextTestResultStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "veda_tclClientDiaglog::onSendNextTestResultStatus(): CALLED" ) );

   // veda_ClientDiaglogonSendNextTestResultStart: user specific code start
   VEDA_NULL_POINTER_CHECK(_cpoMain);
   VEDA_NULL_POINTER_CHECK(_cpoMain->theServer());

   // Additional check for checking ITCList size is needed for C1A configuration because
   // Diaglog needs to be updated with ITC list only when the list is empty reference
   // ticket Number NCG3D-77148
   if ((status->getStatus()) == TRUE && (status->getNextTestResultStruct().getITCList().size() == 0))
   {
      tChar cClassName[] = "veda_tclClientVcan";
      _cpoMain->theServer()->vPostMsgReadCsmBusStates(cClassName, 1);
   }
   else
   {
      ETG_TRACE_USR1( ( "veda_tclClientDiaglog::onSendNextTestResultStatus() Status received as %u", status->getStatus() ) );
   }
   // veda_ClientDiaglogonSendNextTestResultStart: user specific code end
}


tVoid veda_tclClientDiaglog::vHandleMessage(veda_tclBaseIf::TMsg* pMsg) {
   // veda_ClientDiaglogvHandleMessage: user specific code start
   (tVoid) pMsg;
   // veda_ClientDiaglogvHandleMessage: user specific code end
}

tVoid veda_tclClientDiaglog::vGetReferences() {
   // veda_ClientDiaglogvGetReferences: user specific code start
   // veda_ClientDiaglogvGetReferences: user specific code end
}

tVoid veda_tclClientDiaglog::vStartCommunication() {
   // veda_ClientDiaglogvStartCommunication: user specific code start
   // veda_ClientDiaglogvStartCommunication: user specific code end
}

tVoid veda_tclClientDiaglog::vTraceInfo() {
   // veda_ClientDiaglogvTraceInfo: user specific code start
   // veda_ClientDiaglogvTraceInfo: user specific code end
}

tVoid veda_tclClientDiaglog::sendSaveTestResultStart(::diaglog_main_fi_types::T_TestResultList testResultList) {
    // veda_tclClientDiaglog::sendSaveTestResultStart: user specific code start
    // veda_tclClientDiaglog::sendSaveTestResultStart: user specific code end
    
    if (_DiaglogProxy) _DiaglogProxy->sendSaveTestResultStart(* this, testResultList);

    // veda_tclClientDiaglog::sendSaveTestResultStartEnd: user specific code start
    // veda_tclClientDiaglog::sendSaveTestResultStartEnd: user specific code end
}

// veda_ClientDiaglogDefinitioPart: user specific code start
tVoid veda_tclClientDiaglog::prepareSaveTestResultData(const tU16 u16ITCId, const tU8 u8Status)
{
   ETG_TRACE_USR1(("veda_tclClientDiaglog::prepareSaveTestResultData() for ITC %u Result as %u", \
	      ETG_ENUM(VEDA_INT_ITC, u16ITCId), ETG_CENUM(enITCResult, u8Status)));

   tBool bUpdated = FALSE;
   
   // iterate through the local list and check if the same ITC is already present in the list just update the Test Result
   ::diaglog_main_fi_types::T_TestResultList::iterator it = _TestResultList.begin();

	for (; it != _TestResultList.end(); it++ )
	{
		if ( u16ITCId == it->getTroubleCode() ) 
		{
			it->setResult(static_cast< ::diaglog_main_fi_types::T_e8_TestResult >(u8Status));
			bUpdated = TRUE;
			_bIsStartMResultPending = TRUE;
			break;
		}
	}

	// if the ITC is not present in the local list already, add a new entry in the list
	if ( !bUpdated )
	{
       ::diaglog_main_fi_types::T_TestResult tempTestResult;   
          
       tempTestResult.setTroubleCode(u16ITCId);
       tempTestResult.setResult(static_cast< ::diaglog_main_fi_types::T_e8_TestResult >(u8Status));   
       
       _TestResultList.push_back(tempTestResult);
       _bIsStartMResultPending = TRUE;
	}
	
	// Trigger a Method Start
	sendSaveTestResultStart(_TestResultList);
}
// veda_ClientDiaglogDefinitioPart: user specific code end

}}}} // namespace org { namespace bosch { namespace cm { namespace veda {
