/*****************************************************************************
* FILE:         veda_ClientVcan.h
* PROJECT:      G3G project
* SW-COMPONENT: vehicledata
* Template:     CsmClient.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/
#ifndef _VCANCAN_CLIENT_H_
#define _VCANCAN_CLIENT_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
//include base class
#include "Iveda_ClientVcan.h"

#ifdef USE_EVOBUS_ADAPTOR
#include "I_veda_ClientVcanCanAdaptor.h"
#endif
#ifdef USE_INF4CV_ADAPTOR
#include "I_veda_ClientVcanInf4cvCanAdaptor.h"
#endif
#ifdef USE_SMART_ADAPTOR
#include "I_veda_ClientVcanSmartCanAdaptor.h"
#endif
#ifdef USE_EVOBUSB2E_ADAPTOR
#include "I_veda_ClientVcanEvobusb2eCanAdaptor.h"
#endif

// veda_tclClientVcan::ClassIncludes: user specific code start
class Iveda_tclApplHandler;
class Iveda_tclServiceVehicleIf;
class Iveda_tclClientDiaglog;

enum ten_UnitDistanceRequest{
   UNIT_DISTANCE_NO_REQUEST = 0,
   UNIT_DISTANCE_REQUEST_KM,
   UNIT_DISTANCE_REQUEST_MILES,
   UNIT_DISTANCE_RESET_REQUEST
};

enum ten_MeterLangSyncMenuRequest{
   METER_LANG_SYNC_MENU_NO_REQUEST = 0,
   METER_LANG_SYNC_MENU_REQUEST_SYNC,
   METER_LANG_SYNC_MENU_REQUEST_NO_SYNC,
   METER_LANG_SYNC_MENU_REQUEST_LIST_MENU
};

// veda_tclClientVcan::ClassIncludes: user specific code end


class veda_tclClientVcan : 
    public I_veda_tclClientVcan,
    public CsmCallbackIF
{
private:
    I_veda_tclClientVcanCanAdaptor* _pCsmBase;
public:
   veda_tclClientVcan(veda_tclAppMain* poMainAppl);
   virtual ~veda_tclClientVcan();
   bool cmsMediaflag;
   TMediaInfo stmediamsg;
/**************************************************************************
* Copy Constructor, will not be implemented.
* To Avoids Coverity  warning: new in constructor for class 
* 'veda_tclClientVcan' which has no copy constructor.
* NOTE: This is a technique to disable the copy constructor for this
* class. So if an attempt for the copy constructor is made compiler complains.
**************************************************************************/
   veda_tclClientVcan(const veda_tclClientVcan& ocVcan);

/**************************************************************************
* Assingment Operater, will not be implemented.
* To Avoids Coverity warning: new in constructor for class 
* 'veda_tclClientVcan' which has no assignment operator.
* NOTE: This is a technique to disable the assignment operator for this
* class. So if an attempt for the assignment is made compiler complains.
**************************************************************************/
   veda_tclClientVcan& operator=(const veda_tclClientVcan& ocVcan);

   virtual const tChar* getName() const { return "veda_tclClientVcan"; };
   
   virtual tVoid vHandleMessage(veda_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();
   //Added by Shrisha
   tU8 _u8ReadConfiguredRegion(tVoid) const;


    virtual tVoid vGetSpeed_Limit_Display_Request();
    virtual tVoid vGetNavi_display_speed_limit_1();
    virtual tVoid vGetNavi_display_speed_limit_2();
    virtual tVoid vGetIgnitionSupplyConfirmation();
    virtual tVoid vGetVehicleSpeed();
	//TCOVehiclespeed
	 virtual tVoid vGetTCOVehicleSpeed();
	//Mutedev
	virtual tVoid vGetMuteDevStatus();
	virtual tVoid vGetPartialMuteValue();
	virtual tVoid vGetSwivMonAutoOpenValue();
	virtual tVoid vGetDateModeValue();
	virtual tVoid vGetTmModeValue();
	//camera
	virtual tVoid vGetActCam1Value();
	//camera2
	virtual tVoid vGetActCam2Value();
	//camera3
	virtual tVoid vGetActCam3Value();
	//camera4
	virtual tVoid vGetActCam4Value();
	//camera5
	virtual tVoid vGetActCam5Value();
	//camera6
	virtual tVoid vGetActCam6Value();
	//camera7
	virtual tVoid vGetActCam7Value();
	//camsplit
	virtual tVoid vGetCamSplitQuadValue();
	//SysVolt
	virtual tVoid vGetSysVoltStatus();
	//ParkingBreakSwitch
	virtual tVoid vGetParkingBreakSwitchValue();
	//Disatance Unit
	virtual tVoid vGetUnitDistanceDisplayState();
	//RearCamReq
	virtual tVoid vGetRearCamReqValue();
	//VIN
	virtual tVoid vGetVINValue();
	//Time Date
	virtual tVoid vGetTimeDateValue();
	//phonecallCommand
	virtual tVoid vGetPhoneCallCmdValue();
	
	//System Language
	virtual tVoid vGetSystemLanguageValue();
	//CurrLang
	virtual tVoid vGetCurrLangValue();
	//CamTxt
	virtual tVoid vGetCamTxtValue();

	
    virtual tVoid vGetHandBrakeSwitch();
    virtual tVoid vGetDistanceTotalizer();
    virtual tVoid vGetDistanceUnit();
    virtual tVoid vGetAverage_Fuel_Economy();
    virtual tVoid vGetDiagMuxOn();
    virtual tVoid vGetDiagMuxOn_84();
    virtual tVoid vGetGADE();
    virtual tVoid vGetRearGearEngaged();
    virtual tVoid vGetOSPOverSpeedDisplayRequest();
    virtual tVoid vGetOSPSpeedUnit();
    virtual tVoid vGetTSR_OSP_ActivationStatus();
    virtual tVoid vGetMeterLanguageKnowledge();
    virtual tVoid vGetMeterLanguageStatus();
    virtual tVoid vGetReset_TPMS_answer_back();
    virtual tVoid vGetSelect_pressure_support();
    virtual tVoid vGetSetting_pressure_Front_answer_back();
    virtual tVoid vGetSetting_pressure_Rear_answer_back();
    virtual tVoid vGetGlobalVehicleWarningState();
    virtual tVoid vGetVehicleStates();
    virtual tVoid vSendMediaInfo(vehicle_fi_tcl_CAN_Mesg msg);
    virtual tVoid vSendCallInfo(vehicle_fi_tcl_CAN_Mesg msg);
    virtual tVoid vSendPhoneInfo(vehicle_fi_tcl_CAN_Mesg msg);
    virtual tVoid vSendXMInfo(vehicle_fi_tcl_CAN_Mesg msg);
    virtual tVoid vSendMainlineInfo(vehicle_fi_tcl_CAN_Mesg msg);
	virtual tVoid vSendCurrentStreetName(vehicle_fi_tcl_CAN_Mesg msg);
	virtual tVoid vSendTurnToStreetNameInfo(vehicle_fi_tcl_CAN_Mesg msg);
	virtual tVoid VSendDestinationInfo(vehicle_fi_tcl_CAN_Navi_Mesg msg);
	virtual tVoid VSendTurnToSymbolsInfo(vehicle_fi_tcl_CAN_Navi_Mesg msg);
	virtual tVoid VSendLaneGuidanceInfo(vehicle_fi_tcl_CAN_Navi_Mesg msg);
	virtual tVoid VSendNaviWarningInfo(vehicle_fi_tcl_CAN_Navi_Mesg msg);
	virtual tVoid vSendCabAMediaInfo(vehicle_fi_tcl_CAN_Mesg msg);
	
	//Cam1ManAct
	virtual tVoid vSendCam1ManAct(TCam1ManAct tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendCam1ManAct(tTxSignal);
        }
    }
	
	//Cam2ManAct
	virtual tVoid vSendCam2ManAct(TCam2ManAct tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendCam2ManAct(tTxSignal);
        }
    }
	
	//Cam3ManAct
	virtual tVoid vSendCam3ManAct(TCam3ManAct tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendCam3ManAct(tTxSignal);
        }
    }
	
	//Cam4ManAct
	virtual tVoid vSendCam4ManAct(TCam4ManAct tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendCam4ManAct(tTxSignal);
        }
    }
	
	//Cam5ManAct
	virtual tVoid vSendCam5ManAct(TCam5ManAct tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendCam5ManAct(tTxSignal);
        }
    }
	
	//Cam6ManAct
	virtual tVoid vSendCam6ManAct(TCam6ManAct tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendCam6ManAct(tTxSignal);
        }
    }
	
	//Cam7ManAct
	virtual tVoid vSendCam7ManAct(TCam7ManAct tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendCam7ManAct(tTxSignal);
        }
    }
	
	//Cam8ManAct
	virtual tVoid vSendCam8ManAct(TCam8ManAct tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendCam8ManAct(tTxSignal);
        }
    }
	
	//Cam9ManAct
	virtual tVoid vSendCam9ManAct(TCam9ManAct tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendCam9ManAct(tTxSignal);
        }
    }
	//Cam10ManAct
	virtual tVoid vSendCam10ManAct(TCam10ManAct tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendCam10ManAct(tTxSignal);
        }
    }
	
	//Cam11ManAct
	virtual tVoid vSendCam11ManAct(TCam11ManAct tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendCam11ManAct(tTxSignal);
        }
    }
	//Cam12ManAct
	virtual tVoid vSendCam12ManAct(TCam12ManAct tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendCam12ManAct(tTxSignal);
        }
    }
	//Cam13ManAct
	virtual tVoid vSendCam13ManAct(TCam13ManAct tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendCam13ManAct(tTxSignal);
        }
    }
	//Cam14ManAct
	virtual tVoid vSendCam14ManAct(TCam14ManAct tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendCam14ManAct(tTxSignal);
        }
    }
	//Cam15ManAct
	virtual tVoid vSendCam15ManAct(TCam15ManAct tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendCam15ManAct(tTxSignal);
        }
    }
	//Cam16ManAct
	virtual tVoid vSendCam16ManAct(TCam16ManAct tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendCam16ManAct(tTxSignal);
        }
    }
	//Cam17ManAct
	virtual tVoid vSendCam17ManAct(TCam17ManAct tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendCam17ManAct(tTxSignal);
        }
    }
	//PrivacyResetAck
	virtual tVoid vSendPrivacyResetAck(TPrivacyResetAck tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendPrivacyResetAck(tTxSignal);
        }
    }
	
	//DispCamCls
	virtual tVoid vSendDispCamCls(TDispCamCls tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendDispCamCls(tTxSignal);
        }
    }
	
	//PhoneBTLinkStatus
	virtual tVoid vSendPhoneBTLinkStatus(TPhoneBTLinkStatus tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendPhoneBTLinkStatus(tTxSignal);
        }
    }

	//PhoneBookSyncstatus
	virtual tVoid vSendPhoneBookSyncstatus(TPhoneBookSyncStatus tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendPhoneBookSyncstatus(tTxSignal);
        }
    }

	//CallHistorySyncStatus
	virtual tVoid vSendCallHistorySyncStatus(TCallHistorySyncStatus tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendCallHistorySyncStatus(tTxSignal);
        }
    }
	//PhoneStatusRoaming
	virtual tVoid vSendPhoneStatusRoaming(TPhoneStatusRoaming tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendPhoneStatusRoaming(tTxSignal);
        }
    }

	//CallDuration
	virtual tVoid vSendCallDuration(TCallDuration tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendCallDuration(tTxSignal);
        }
    }

	
	//GSMSignalStrength
	virtual tVoid vSendGSMSignalStrength(TGSMSignalStrength tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendGSMSignalStrength(tTxSignal);
        }
    }
	
	//PhoneCallStatus
	virtual tVoid vSendPhoneCallStatus(TPhoneCallStatus tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendPhoneCallStatus(tTxSignal);
        }
    }
	
		
	//PhoneBatteryLevelStatus
	virtual tVoid vSendPhoneBatteryLevelStatus(TPhoneBatteryLevelStatus tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendPhoneBatteryLevelStatus(tTxSignal);
        }
    }

		
	//DeviceStatusWifiAvailable
	virtual tVoid vSendDeviceStatusWifiAvailable(TDeviceStatusWifiAvailable tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendDeviceStatusWifiAvailable(tTxSignal);
        }
    }

	//MediaStatusAudioSource
	virtual tVoid vSendMediaStatusAudioSource(TMediaStatusAudioSource tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendMediaStatusAudioSource(tTxSignal);
        }
    }
	
	//PhoneAvailableStatus
	virtual tVoid vSendPhoneAvailableStatus(TPhoneAvailableStatus tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendPhoneAvailableStatus(tTxSignal);
        }
    }
		//PhoneVRAvailable
	virtual tVoid vSendPhoneVRAvailable(TPhoneVRAvailable tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendPhoneVRAvailable(tTxSignal);
        }
    }
	//DeviceStatusBTStatus
	virtual tVoid vSendDeviceStatusBTStatus(TDeviceStatusBTStatus tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendDeviceStatusBTStatus(tTxSignal);
        }
    }
	//DeviceStatusBluetoothAvail
	virtual tVoid vSendDeviceStatusBluetoothAvail(TDeviceStatusBluetoothAvail tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendDeviceStatusBluetoothAvail(tTxSignal);
        }
    }	
	//Req_DeviceInfo
	virtual tVoid vSendReq_DeviceInfo(TReq_DeviceInfo tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendReq_DeviceInfo(tTxSignal);
        }
    }
	//MediaStatusVolume
	virtual tVoid vSendMediaStatusVolume(TMediaStatusVolume tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendMediaStatusVolume(tTxSignal);
        }
    }
	//CabinMediaStatusAudioSource
	virtual tVoid vSendCabinMediaStatusAudioSource(TCabinMediaStatusAudioSource tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendCabinMediaStatusAudioSource(tTxSignal);
        }
    }
	
	//CabinMediaStatusTunerBand
	virtual tVoid vSendCabinMediaStatusTunerBand(TCabinMediaStatusTunerBand tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendCabinMediaStatusTunerBand(tTxSignal);
        }
    }
	//CabinMediaStatusVolume
	virtual tVoid vSendCabinMediaStatusVolume(TCabinMediaStatusVolume tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendCabinMediaStatusVolume(tTxSignal);
        }
    }
	//MediaStatusMuteStatus
	virtual tVoid vSendMediaStatusMuteStatus(TMediaStatusMuteStatus tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendMediaStatusMuteStatus(tTxSignal);
        }
    }
		//CabinMediaStatusMuteStatus
	virtual tVoid vSendCabinMediaStatusMuteStatus(TCabinMediaStatusMuteStatus tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendCabinMediaStatusMuteStatus(tTxSignal);
        }
    }
	//MediaStatusPlayStatus
	virtual tVoid vSendMediaStatusPlayStatus(TMediaStatusPlayStatus tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendMediaStatusPlayStatus(tTxSignal);
        }
    }	
	//MediaStatusMixState
	virtual tVoid vSendMediaStatusMixState(TMediaStatusMixState tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendMediaStatusMixState(tTxSignal);
        }
    }
	//MediaStatusPlaylistMode
	virtual tVoid vSendMediaStatusPlaylistMode(TMediaStatusPlaylistMode tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendMediaStatusPlaylistMode(tTxSignal);
        }
    }	
	//MediaStatusTrackTime
	virtual tVoid vSendMediaStatusTrackTime(TMediaStatusTrackTime tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendMediaStatusTrackTime(tTxSignal);
        }
    }	
	//MediaStatusCurrTrackNum
	virtual tVoid vSendMediaStatusCurrTrackNum(TMediaStatusCurrTrackNum tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendMediaStatusCurrTrackNum(tTxSignal);
        }
    }	
	//DeviceStatusRadioStatus
	virtual tVoid vSendDeviceStatusRadioStatus(TDeviceStatusRadioStatus tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendDeviceStatusRadioStatus(tTxSignal);
        }
    }
	//DeviceStatusDABAvailStatus
	virtual tVoid vSendDeviceStatusDABAvailStatus(TDeviceStatusDABAvailStatus tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendDeviceStatusDABAvailStatus(tTxSignal);
        }
    }	
	//DeviceStatusNavData
	virtual tVoid vSendDeviceStatusNavData(TDeviceStatusNavData tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendDeviceStatusNavData(tTxSignal);
        }
    }	
	//DeviceStatusUSB1Present
	virtual tVoid vSendDeviceStatusUSB1Present(TDeviceStatusUSB1Present tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendDeviceStatusUSB1Present(tTxSignal);
        }
    }
	//DeviceStatusUSB2Present
	virtual tVoid vSendDeviceStatusUSB2Present(TDeviceStatusUSB2Present tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendDeviceStatusUSB2Present(tTxSignal);
        }
    }	
	//DeviceStatusNaviAvail
	virtual tVoid vSendDeviceStatusNaviAvail(TDeviceStatusNaviAvail tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendDeviceStatusNaviAvail(tTxSignal);
        }
    }
	//DeviceStatusUSB1Src
	virtual tVoid vSendDeviceStatusUSB1Src(TDeviceStatusUSB1Src tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendDeviceStatusUSB1Src(tTxSignal);
        }
    }	
	//DeviceStatusUSB2Src
	virtual tVoid vSendDeviceStatusUSB2Src(TDeviceStatusUSB2Src tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendDeviceStatusUSB2Src(tTxSignal);
        }
    }
	//DeviceStatusAMFMAvail
	virtual tVoid vSendDeviceStatusAMFMAvail(TDeviceStatusAMFMAvail tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendDeviceStatusAMFMAvail(tTxSignal);
        }
    }

	//MediaStatusSeekStatus
	virtual tVoid vSendMediaStatusSeekStatus(TMediaStatusSeekStatus tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendMediaStatusSeekStatus(tTxSignal);
        }
    }

	//MediaStatusRepeatStatus
	virtual tVoid vSendMediaStatusRepeatStatus(TMediaStatusRepeatStatus tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendMediaStatusRepeatStatus(tTxSignal);
        }
    }
	
		//MediaStatusDABFMStatus
	virtual tVoid vSendMediaStatusDABFMStatus(TMediaStatusDABFMStatus tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendMediaStatusDABFMStatus(tTxSignal);
        }
    }
		//VehicleNaviLatitude
	virtual tVoid vSendVehicleNaviLatitude(TVehicleNaviLatitude tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendVehicleNaviLatitude(tTxSignal);
        }
    }
	//VehicleNaviLongitude
	virtual tVoid vSendVehicleNaviLongitude(TVehicleNaviLongitude tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendVehicleNaviLongitude(tTxSignal);
        }
    }
	//MediaStatusTREGStatus
	virtual tVoid vSendMediaStatusTREGStatus(TMediaStatusTREGStatus tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendMediaStatusTREGStatus(tTxSignal);
        }
    }
	//MediaStatusTREGRTMStatus
	virtual tVoid vSendMediaStatusTREGRTMStatus(TMediaStatusTREGRTMStatus tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendMediaStatusTREGRTMStatus(tTxSignal);
        }
    }
	//MediaStatusRDSStatus
	virtual tVoid vSendMediaStatusRDSStatus(TMediaStatusRDSStatus tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendMediaStatusRDSStatus(tTxSignal);
        }
    }
	//MediaStatusTAStatus
	virtual tVoid vSendMediaStatusTAStatus(TMediaStatusTAStatus tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendMediaStatusTAStatus(tTxSignal);
        }
    }
	//MediaStatusTPStatus
	virtual tVoid vSendMediaStatusTPStatus(TMediaStatusTPStatus tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendMediaStatusTPStatus(tTxSignal);
        }
    }
	//MediaStatusTunerBandStatus
	virtual tVoid vSendMediaStatusTunerBandStatus(TMediaStatusTunerBandStatus tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendMediaStatusTunerBandStatus(tTxSignal);
        }
    }
	//MediaStatusTunerPresetStatus
	virtual tVoid vSendMediaStatusTunerPresetStatus(TMediaStatusTunerPresetStatus tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendMediaStatusTunerPresetStatus(tTxSignal);
        }
    }
	
	//HUS_DM1_Status
	virtual tVoid vSendHUS_DM1_Status(THUS_DM1_Status tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendHUS_DM1_Status(tTxSignal);
        }
    }
    virtual tVoid vSendVoice_Recognition_Executing(TVoice_Recognition_Executing tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendVoice_Recognition_Executing(tTxSignal);
        }
    }
    virtual tVoid vSendBlowerReductionRequest(TBlowerReductionRequest tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendBlowerReductionRequest(tTxSignal);
        }
    }
    virtual tVoid vSendTSR_OSPActivationRequest2(TTSR_OSPActivationRequest2 tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendTSR_OSPActivationRequest2(tTxSignal);
        }
    }
    virtual tVoid vSendMeterLanguageSyncMenu(TMeterLanguageSyncMenu tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendMeterLanguageSyncMenu(tTxSignal);
        }
    }
    virtual tVoid vSendCockpitLanguageRequest(TCockpitLanguageRequest tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendCockpitLanguageRequest(tTxSignal);
        }
    }
    virtual tVoid vSendUnitDistanceDisplayRequest(TUnitDistanceDisplayRequest tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendUnitDistanceDisplayRequest(tTxSignal);
        }
    }
    virtual tVoid vSendSetting_Change_Request_for_TPMS(TSetting_Change_Request_for_TPMS tTxSignal) {
        if (_pCsmBase) {
            _pCsmBase->vSendSetting_Change_Request_for_TPMS(tTxSignal);
        }
    }
       tVoid CheckandSendDatatoAdapter();
private:
   virtual void onSpeed_Limit_Display_RequestStatus(TSpeed_Limit_Display_Request tSpeed_Limit_Display_Request);
   virtual void onNavi_display_speed_limit_1Status(TNavi_display_speed_limit_1 tNavi_display_speed_limit_1);
   virtual void onNavi_display_speed_limit_2Status(TNavi_display_speed_limit_2 tNavi_display_speed_limit_2);
   virtual void onIgnitionSupplyConfirmationStatus(TIgnitionSupplyConfirmation tIgnitionSupplyConfirmation);
   virtual void onVehicleSpeedStatus(TVehicleSpeed tVehicleSpeed);
   //TCOVehiclespeed
    virtual void onTCOVehicleSpeedStatus(TTCOVehicleSpeed tTCOVehicleSpeed);
   virtual void onVehiclePartialMuteStatus(TPartialMuteValue tPartialMuteValue);
   virtual void onVehicleSwivMonAutoOpenStatus(TSwivMonAutoOpenValue tSwivMonAutoOpenValue);
   virtual void onVehicleDateModeStatus(TDateModeValue tDateModeValue);
   virtual void onVehicleTmModeStatus(TTmModeValue tTmModeValue);
   //camera
   virtual void onVehicleActCam1Status(TActCam1Value tActCam1Value);
   //camera2
   virtual void onVehicleActCam2Status(TActCam2Value tActCam2Value);
   //camera3
   virtual void onVehicleActCam3Status(TActCam3Value tActCam3Value);
   //camera4
   virtual void onVehicleActCam4Status(TActCam4Value tActCam4Value);
   //camera5
   virtual void onVehicleActCam5Status(TActCam5Value tActCam5Value);
   //camera6
   virtual void onVehicleActCam6Status(TActCam6Value tActCam6Value);
   //camera7
   virtual void onVehicleActCam7Status(TActCam7Value tActCam7Value);
   //camsplit
   virtual void onVehicleCamSplitQuadStatus(TCamSplitQuadValue tCamSplitQuadValue);
   //Mutedev
   virtual void onVehicleMuteDevStatus(TMuteDevStatus tMuteDevStatus);
   //SysVolt
   virtual void onVehicleSysVoltStatus(TSysVoltStatus tSysVoltStatus);
   //ParkingBreakSwitch
   virtual void onVehicleParkingBreakSwitchStatus(TParkingBreakSwitchValue tParkingBreakSwitchValue);
   //Distance Unit
   virtual void onUnitDistanceDisplayStateStatus(TUnitDistanceDisplayState tUnitDistanceDisplayState);
   //RearCamReq
   virtual void onVehicleRearCamReqStatus(TRearCamReqValue tRearCamReqValue);
   //VIN
   virtual void onVehicleVINStatus(TVINValue tVINValue);
   //Time Date
   virtual void onTimeDateStatus(TTimeDateValue tTimeDateValue);
   //Phone Call Command 
   virtual void onPhoneCallCommandStatus(TPhoneCallCommand tPhoneCallCommandValue);
   //Device Info SW version 
	virtual void onDeviceInfoSWversionStatus(TDeviceInfoSWversion tDeviceInfoSWversionValue);   
	//TotalVehDistDiag
	virtual void onTotalVehDistDiagStatus(TTotalVehDistDiag tTotalVehDistDiagValue);
	//VIN_64
	virtual void onVIN_64Status(TVIN_64 tVIN_64Value);
   //Volume Command 
   virtual void onVolumeCommandStatus(TVolumeCommand tVolumeCommandValue);
   //ActCam8  
   virtual void onActCam8Status(TActCam8 tActCam8Value);
   //ActCam9  
   virtual void onActCam9Status(TActCam9 tActCam9Value);
   //ActCam10  
   virtual void onActCam10Status(TActCam10 tActCam10Value);
   //ActCam11  
   virtual void onActCam11Status(TActCam11 tActCam11Value);
    //ActCam12  
   virtual void onActCam12Status(TActCam12 tActCam12Value);
    //ActCam13 
   virtual void onActCam13Status(TActCam13 tActCam13Value);
    //ActCam14
   virtual void onActCam14Status(TActCam14 tActCam14Value);
    //ActCam15
   virtual void onActCam15Status(TActCam15 tActCam15Value);
    //ActCam16
   virtual void onActCam16Status(TActCam16 tActCam16Value);
   //ActCam17
   virtual void onActCam17Status(TActCam17 tActCam17Value);
    //Source Command 
   virtual void onSourceCommandStatus(TSourceCommand tSourceCommandValue); 
   //CabinSource Command 
   virtual void onCabinSourceCommandStatus(TCabinSourceCommand tCabinSourceCommandValue); 
   //CabinVolume Command 
   virtual void onCabinVolumeCommandStatus(TCabinVolumeCommand tCabinVolumeCommandValue); 
   //CabinTuner Command 
   virtual void onCabinTunerCommandStatus(TCabinTunerCommand tCabinTunerCommandValue);
   //CabinTrackCommand 
   virtual void onCabinTrackCommandStatus(TCabinTrackCommand tCabinTrackCommandValue);
   //CabinPlaylistCommand 
   virtual void onCabinPlaylistCommandStatus(TCabinPlaylistCommand tCabinPlaylistCommandValue);
   	//Track Command
	virtual void onTrackCommandStatus(TTrackCommand tTrackCommandValue) ;
	 //SMARTVR 
	virtual void onSMARTVRStatus(TSMARTVR tSMARTVRValue) ;
	//Tuner Command
	virtual void onTunerCommandStatus(TTunerCommand tTunerCommandValue) ;
	//TA Command
	virtual void onTACommandStatus(TTACommand tTACommandValue) ;
	//RDS Command
	virtual void onRDSCommandStatus(TRDSCommand tRDSCommandValue) ;
	   	// RC Next Btn
	virtual void onRCNextBtnStatus(TRCNextBtn tRCNextBtnValue) ;
	// RC Prev Btn
	virtual void onRCPrevBtnStatus(TRCPrevBtn tRCPrevBtnValue) ;
   //Voice Recgn Command 
   virtual void onVoiceRecgCommandStatus(TVoiceRecgCommand tVoiceRecgCommandValue);
    //Phone Pwr command 
   virtual void onPhonePwrCmdStatus(TPhonePwrCmd tPhonePwrCmdValue);
   //System Language
   virtual void onVehicleSystemLanguageStatus(TSystemLanguageValue tSystemLanguageValue);
   //CurrLang
   virtual void onVehicleCurrLangStatus(TCurrLangValue tCurrLangValue);   
   // Radio Pwr command 
   virtual void onRadioPwrCmdStatus(TRadioPwrCmd tRadioPwrCmdValue);
   //CamTxt
   virtual void onVehicleCamTxtStatus(TCamTxtValue tCamTxtValue);
   //PrivacyResetReq
   virtual void onVehiclePrivacyResetReqStatus(TPrivacyResetReqValue tPrivacyResetReqValue);

   
   virtual void onHandBrakeSwitchStatus(THandBrakeSwitch tHandBrakeSwitch);
   virtual void onDistanceTotalizerStatus(TDistanceTotalizer tDistanceTotalizer);
   virtual void onDistanceUnitStatus(TDistanceUnit tDistanceUnit);
   virtual void onAverage_Fuel_EconomyStatus(TAverage_Fuel_Economy tAverage_Fuel_Economy);
   virtual void onDiagMuxOnStatus(TDiagMuxOn tDiagMuxOn);
   virtual void onDiagMuxOn_84Status(TDiagMuxOn_84 tDiagMuxOn_84);
   virtual void onGADEStatus(TGADE tGADE);
   virtual void onRearGearEngagedStatus(TRearGearEngaged tRearGearEngaged);
   virtual void onOSPOverSpeedDisplayRequestStatus(TOSPOverSpeedDisplayRequest tOSPOverSpeedDisplayRequest);
   virtual void onOSPSpeedUnitStatus(TOSPSpeedUnit tOSPSpeedUnit);
   virtual void onTSR_OSP_ActivationStatusStatus(TTSR_OSP_ActivationStatus tTSR_OSP_ActivationStatus);
   virtual void onMeterLanguageKnowledgeStatus(TMeterLanguageKnowledge tMeterLanguageKnowledge);
   virtual void onMeterLanguageStatusStatus(TMeterLanguageStatus tMeterLanguageStatus);
   virtual void onReset_TPMS_answer_backStatus(TReset_TPMS_answer_back tReset_TPMS_answer_back);
   virtual void onSelect_pressure_supportStatus(TSelect_pressure_support tSelect_pressure_support);
   virtual void onSetting_pressure_Front_answer_backStatus(TSetting_pressure_Front_answer_back tSetting_pressure_Front_answer_back);
   virtual void onSetting_pressure_Rear_answer_backStatus(TSetting_pressure_Rear_answer_back tSetting_pressure_Rear_answer_back);
   virtual void onGlobalVehicleWarningStateStatus(TGlobalVehicleWarningState tGlobalVehicleWarningState);
   virtual void onVehicleStatesStatus(TVehicleStates tVehicleStates);
    //Driver door open status
    virtual void onVehicleDriverDoorOpenStatus(TDriverDoorstatusCmd tDriverDoorstatusCmd);


// veda_tclClientVcan::ClassImplementation: user specific code start
   bool bIsSignalValid(const tU32 u32Status) const;

   tVoid vHandleAllNodeFaultRegistration(tVoid);
   tVoid vRegisterNodeFaultStates(tVoid) const;
   tVoid vReadAllNodeFaultStates(const tBool bForceUpdate);
   tVoid _vReadAllCatDNodeFaultStates(const tBool bUpdateDiag);
   // Load and Check Speed Limits (SpeedLock)
   tVoid vLoadCheckSpeedLimit(tVoid);

   tBool _bSaveAndCheckForUpdate(const tU8 u8DiagIndex, tU8 u8FaultState);
   tVoid _vHandleITCLogging(const tU16 u16ITCId, const tU8 u8State) const;
   tBool _bIsCANFaultCategoryD_Masked() const;
   tBool _bIsCANFaultCategoryC_Masked() const;

   tVoid _vUpdateCANBusState(tVoid) const;

   tVoid _vReadVehicleSpeed();
   //TCOVehiclespeed
    tVoid _vReadTCOVehicleSpeed();
   tVoid _vReadPartialMuteValue();
   tVoid _vReadSwivMonAutoOpenValue();
   tVoid _vReadDateModeValue();
   tVoid _vReadTmModeValue();
   //camera
   tVoid _vReadActCam1Value();
   //camera2
   tVoid _vReadActCam2Value();
   //camera3
   tVoid _vReadActCam3Value();
   //camera4
   tVoid _vReadActCam4Value();
   //camera5
   tVoid _vReadActCam5Value();
   //camera6
   tVoid _vReadActCam6Value();
   //camera7
   tVoid _vReadActCam7Value();
   //camsplit
   tVoid _vReadCamSplitQuadValue();
   //MuteDev
   tVoid _vReadMuteDevStatus();
   //SysVolt
   tVoid _vReadSysVoltStatus();
   //ParkingBreakSwitch
   tVoid _vReadParkingBreakSwitchValue();
   //RearCamReq
   tVoid _vReadRearCamReqValue();
   //VIN
   tVoid _vReadVINValue();
   //TimeDate
   tVoid _vReadTimeDateValue();
   //Phone Call Command
   tVoid _vReadPhoneCallCommandValue();
   
   //CamTxt
   tVoid _vReadCamTxtValue();

   
   tU32 _u32AccumulatedMileage;
   tU32 u32ConfigMask;
   tU8 u8VCANDiversity;
   tU8 u8CANActivationC1A;
   tBool _bVCANInitializationError;
   tBool _bMCANInitializationError;
   tBool _bHWIgnition;
   tBool _bNodeFaultCallbackRegistered;
   tBool _bDiagMuxState;
   tU8   u8GADEState;

   tU16 _u16CANSpeed;
   tU32  _u32CANSpeedStatus; 
   
   //TCOVehiclespeed
   tU16 _u16CANTCOSpeed;
   tU32  _u32CANTCOSpeedStatus;
   
   tU8 _u8PartialMuteValue;
   tU32  _u32CANPartialMuteStatus;
   tU8 _u8SwivMonAutoOpenValue;
   tU32  _u32CANSwivMonAutoOpenStatus;
   tU8 _u8DateModeValue;
   tU32  _u32CANDateModeStatus;
   tU8 _u8TmModeValue;
   tU32  _u32CANTmModeStatus;   
   //camera
   tU8 _u8ActCam1Value;
   tU32  _u32CANActCam1Status;   
   //camera2
   tU8 _u8ActCam2Value;
   tU32  _u32CANActCam2Status; 
  //camera3
   tU8 _u8ActCam3Value;
   tU32  _u32CANActCam3Status;   
  //camera4
   tU8 _u8ActCam4Value;
   tU32  _u32CANActCam4Status; 
   //camera5
   tU8 _u8ActCam5Value;
   tU32  _u32CANActCam5Status; 
   //camera6
   tU8 _u8ActCam6Value;
   tU32  _u32CANActCam6Status; 
   //camera7
   tU8 _u8ActCam7Value;
   tU32  _u32CANActCam7Status; 
   //camsplit
   tU16 _u16CamSplitQuadValue;
   tU32  _u32CANCamSplitQuadStatus; 
   //MuteDev
   tU8 _u8MuteDevStatusValue;
   tU32  _u32CANMuteDevStatus;
   //SysVolt
   tU8 _u8SysVoltStatusValue;
   tU32  _u32CANSysVoltStatus;
   //ParkingBreakSwitch
   tU8 _u8ParkingBreakSwitchValue;
   tU32  _u32CANParkingBreakSwitchStatus;
   //RearCamReq
   tU8 _u8RearCamReqValue;
   tU32  _u32CANRearCamReqStatus;
   //VIN
   tU32 _u32VINValue;
   tU32  _u32CANVINStatus;
   //Time Date
   tU64 _u64TimeDateValue;
   tU32  _u32CANTimeDateStatus;
      
   //Phone Call Command
   tU8 _u8PhoneCallCommandValue;
   tU32  _u32PhoneCallCommandStatus;
   
   
   	   //RC Next Btn
   tU8 _u8RCNextBtnValue;
   tU32  _u32RCNextBtnStatus;
   
   
      
   	   //RC Prev Btn
   tU8 _u8RCPrevBtnValue;
   tU32  _u32RCPrevBtnStatus;
     
	   //Phone pwr Command
   tU8 _u8PhonePwrCmdValue;
   tU32  _u32PhonePwrCmdStatus;
   
   //Volume Command
   tU8 _u8VolumeCommandValue;
   tU32  _u32VolumeCommandStatus;
   
   // ActCam8
   tU8 _u8ActCam8Value;
   tU32  _u32ActCam8Status;
  
   // ActCam9
   tU8 _u8ActCam9Value;
   tU32  _u32ActCam9Status;
   
   // ActCam10
   tU8 _u8ActCam10Value;
   tU32  _u32ActCam10Status;
      
   // ActCam11
   tU8 _u8ActCam11Value;
   tU32  _u32ActCam11Status;
   
    // ActCam12
   tU8 _u8ActCam12Value;
   tU32  _u32ActCam12Status;
   
   // ActCam13
   tU8 _u8ActCam13Value;
   tU32  _u32ActCam13Status;
   
      // ActCam14
   tU8 _u8ActCam14Value;
   tU32  _u32ActCam14Status;
       
	   // ActCam15
   tU8 _u8ActCam15Value;
   tU32  _u32ActCam15Status;
   
   	   // ActCam16
   tU8 _u8ActCam16Value;
   tU32  _u32ActCam16Status;
   
    // ActCam17
   tU8 _u8ActCam17Value;
   tU32  _u32ActCam17Status;
   
      
   //Source Command
   tU8 _u8SourceCommandValue;
   tU32  _u32SourceCommandStatus;
       
   //CabinSource Command
   tU8 _u8CabinSourceCommandValue;
   tU32  _u32CabinSourceCommandStatus;
          
   //CabinVolume Command
   tU8 _u8CabinVolumeCommandValue;
   tU32  _u32CabinVolumeCommandStatus;    
   
   //CabinTuner Command
   tU8 _u8CabinTunerCommandValue;
   tU32  _u32CabinTunerCommandStatus;
   
   //CabinTrack Command
   tU8 _u8CabinTrackCommandValue;
   tU32  _u32CabinTrackCommandStatus;
      
   //CabinPlaylist Command
   tU8 _u8CabinPlaylistCommandValue;
   tU32  _u32CabinPlaylistCommandStatus;
   
   //Radio pwr Command
   tU8 _u8RadioPwrCmdValue;
   tU32  _u32RadioPwrCmdStatus;
    
   //Track Command
   tU8 _u8TrackCommandValue;
   tU32  _u32TrackCommandStatus;
       
   // SMARTVR
   tU8 _u8SMARTVRValue;
   tU32  _u32SMARTVRStatus;
   
   //Tuner Command
   tU8 _u8TunerCommandValue;
   tU32  _u32TunerCommandStatus;
   
   //TA Command
   tU8 _u8TACommandValue;
   tU32  _u32TACommandStatus;
   //RDS Command
   tU8 _u8RDSCommandValue;
   tU32  _u32RDSCommandStatus;
      
   //VoiceRecgn Command
   tU8 _u8VoiceRecgCommandValue;
   tU32  _u32VoiceRecgnCommandStatus;      

   
      //TotalVehDistDiag
   tU32 _u32TotalVehDistDiagValue;
   tU32  _u32TotalVehDistDiagStatus;
   
      //Device Info SW version 
   tU32 _u32SWversionValue;
   tU32  _u32DeviceInfoSWversionStatus;
   
   
   //System Language
   tU16 _u16SystemLanguageValue;
   tU32  _u32CANSystemLanguageStatus;
   //CurrLang
   tU16 _u16CurrLangValue;
   tU32  _u32CANCurrLangStatus;
   //CamTxt
   tU64 _u64CamTxtValue;
   tU32  _u32CANCamTxtStatus;  
   //VIN_64
   tU64 _u64VIN_64Value;
   tU32  _u32VIN_64Status;
   //PrivacyResetReq
   tU8 _u8PrivacyResetReqValue;
   tU32  _u32CANPrivacyResetReqStatus;

   
   tU8  _u8Value_MeterLangStatus;
   tU32  _u32Status_MeterLangStatus;

   bpstl::vector<tU8, bpstl::allocator<tU8> > _u8AbsentMCANECU;
   bpstl::vector<tU8, bpstl::allocator<tU8> > _u8AbsentVCANECU;

   tU8* _pu8CANNodeFaultState;

   Iveda_tclApplHandler* _poApplHdl;
   Iveda_tclClientDiaglog* _poDiaglogHdl;
   Iveda_tclServiceVehicleIf* _poCCAServiceHdl;
   
   //Speed Lock Min and Max Values
   tU8 _u8MinSpeed;
   tU8 _u8MaxSpeed;
   tU8 _u8SpeedLockValue;
   tU8 _u8DriveState;
   
   tU8 _u8TwoSecondTimerCount;
   tBool _bTPMSRequestFlag;
   tU8 _u8counter;
   tU8 _u8driverdoorstatus;
   tU32 _u32Driverdoorstatus;

public:
   virtual tVoid vHandleKDSConfigRead(tVoid);
   virtual tVoid vHandleCsmFaultIndication(const tU8 u8DiagIndex, tU8 u8FaultState, const tU8 u8ForceUpdate);
   //Cam1ManAct
   virtual tVoid vSendCam1ManActUpdate(const tU8 u8Request);
   //Cam2ManAct
   virtual tVoid vSendCam2ManActUpdate(const tU8 u8Request);
   //Cam3ManAct
   virtual tVoid vSendCam3ManActUpdate(const tU8 u8Request);
   //Cam4ManAct
   virtual tVoid vSendCam4ManActUpdate(const tU8 u8Request);
   //Cam5ManAct
   virtual tVoid vSendCam5ManActUpdate(const tU8 u8Request);
   //Cam6ManAct
   virtual tVoid vSendCam6ManActUpdate(const tU8 u8Request);
   //Cam7ManAct
   virtual tVoid vSendCam7ManActUpdate(const tU8 u8Request);
   //Cam8ManAct
   virtual tVoid vSendCam8ManActUpdate(const tU8 u8Request);
   //Cam9ManAct
   virtual tVoid vSendCam9ManActUpdate(const tU8 u8Request);
   //Cam10ManAct
   virtual tVoid vSendCam10ManActUpdate(const tU8 u8Request);
  //Cam11ManAct
   virtual tVoid vSendCam11ManActUpdate(const tU8 u8Request);
   //Cam12ManAct
   virtual tVoid vSendCam12ManActUpdate(const tU8 u8Request);
  //Cam13ManAct
   virtual tVoid vSendCam13ManActUpdate(const tU8 u8Request);
  //Cam14ManAct
   virtual tVoid vSendCam14ManActUpdate(const tU8 u8Request);
  //Cam15ManAct
   virtual tVoid vSendCam15ManActUpdate(const tU8 u8Request);
   //Cam16ManAct
   virtual tVoid vSendCam16ManActUpdate(const tU8 u8Request);
   //Cam17ManAct
   virtual tVoid vSendCam17ManActUpdate(const tU8 u8Request);
   //PrivacyResetAck
   virtual tVoid vSendPrivacyResetAckUpdate(const tU8 u8Request);
   //DispCamCls
   virtual tVoid vSendDispCamClsUpdate(const tU8 u8Request);
   //PhoneBTLinkStatus
   virtual tVoid vSendPhoneBTLinkStatusUpdate(const tU8 BTLinkStatus);
   //PhoneBookSyncstatus
   virtual tVoid vSendPhoneBookSyncstatusUpdate(const tU8 PhoneBookSyncStatusValue);
    //CallHistorySyncStatus
   virtual tVoid vSendCallHistorySyncStatusUpdate(const tU8 CallHistorySyncStatusValue);
   //PhoneStatusRoaming
   virtual tVoid vSendPhoneStatusRoamingUpdate(const tU8 PhoneStatusRoamingValue);
   //CallDuration
   virtual tVoid vSendCallDurationUpdate(const tU16 CallDurationValue);
   //GSMSignalStrength
   virtual tVoid vSendGSMSignalStrengthUpdate(const tU8 GSMSignalStrengthValue);
   //PhoneCallStatus
   virtual tVoid vSendPhoneCallStatusUpdate(const tU8 CallStatusValue);
   //PhoneBatteryLevelStatus
   virtual tVoid vSendPhoneBatteryLevelStatusUpdate(const tU8 PhoneBatteryLevelStatusValue);
    //PhoneBatteryLevelStatus
   virtual tVoid vSendDeviceStatusWifiAvailableUpdate(const tU8 DeviceStatusWifiStatus);
   //MediaStatusAudioSource
   virtual tVoid vSendMediaStatusAudioSourceUpdate(const tU8 AudioSource);
	//PhoneAvailableStatus
   virtual tVoid vSendPhoneAvailableStatusUpdate(const tU8 PhoneAvailableStatusValue);
   	//PhoneVRAvailable
   virtual tVoid vSendPhoneVRAvailableUpdate(const tU8 PhoneVRAvailableValue);
	//DeviceStatusBTStatus
   virtual tVoid vSendDeviceStatusBTStatusUpdate(const tU8 DeviceStatusBTStatusValue);
   //DeviceStatusBluetoothAvail
   virtual tVoid vSendDeviceStatusBluetoothAvailUpdate(const tU8 DeviceStatusBluetoothAvailValue); 
   //Req_DeviceInfo
   virtual tVoid vSendReq_DeviceInfoUpdate(const tU8 Req_DeviceInfoValue);
   	//MediaStatusVolume
   virtual tVoid vSendMediaStatusVolumeUpdate(const tU8 volume);
   //CabinMediaStatusAudioSource
   virtual tVoid vSendCabinMediaStatusAudioSourceUpdate(const tU8 CabinAudioSource);
    //CabinMediaStatusTunerBand
   virtual tVoid vSendCabinMediaStatusTunerBandUpdate(const tU8 CabinMediaStatusTunerBandValue);
   //CabinMediaStatusVolume
   virtual tVoid vSendCabinMediaStatusVolumeUpdate(const tU8 CabinVolume);
   //MediaStatusMuteStatus
   virtual tVoid vSendMediaStatusMuteStatusUpdate(const tU8 MediaStatusMuteValue);
   //CabinMediaStatusMuteStatus
   virtual tVoid vSendCabinMediaStatusMuteStatusUpdate(const tU8 CabinMediaStatusMuteValue);
   //MediaStatusPlayStatus
   virtual tVoid vSendMediaStatusPlayStatusUpdate(const tU8 MediaStatusPlayStatusValue);
   //MediaStatusMixState
   virtual tVoid vSendMediaStatusMixStateUpdate(const tU8 MediaStatusMixStateValue);
   //MediaStatusPlaylistMode
   virtual tVoid vSendMediaStatusPlaylistModeUpdate(const tU8 MediaStatusPlaylistModeValue);
   //MediaStatusTrackTime
   virtual tVoid vSendMediaStatusTrackTimeUpdate(const tU16 MediaStatusTrackTimeValue);
   //MediaStatusCurrTrackNum
   virtual tVoid vSendMediaStatusCurrTrackNumUpdate(const tU16 MediaStatusCurrTrackNumValue);
   //DeviceStatusRadioStatus
   virtual tVoid vSendDeviceStatusRadioStatusUpdate(const tU8 DeviceStatusRadioStatusValue); 
   //DeviceStatusDABAvailStatus
   virtual tVoid vSendDeviceStatusDABAvailStatusUpdate(const tU8 DeviceStatusDABAvailStatusValue);
   //DeviceStatusNavData
   virtual tVoid vSendDeviceStatusNavDataUpdate(const tU8 DeviceStatusNavDataValue);
   //DeviceStatusUSB1Present
   virtual tVoid vSendDeviceStatusUSB1PresentUpdate(const tU8 DeviceStatusUSB1PresentValue);
   //DeviceStatusUSB2Present
   virtual tVoid vSendDeviceStatusUSB2PresentUpdate(const tU8 DeviceStatusUSB2PresentValue); 
   //DeviceStatusNaviAvail
   virtual tVoid vSendDeviceStatusNaviAvailUpdate(const tU8 DeviceStatusNaviAvailValue);
   //DeviceStatusUSB1Src
   virtual tVoid vSendDeviceStatusUSB1SrcUpdate(const tU8 DeviceStatusUSB1SrcValue);
   //DeviceStatusUSB2Src
   virtual tVoid vSendDeviceStatusUSB2SrcUpdate(const tU8 DeviceStatusUSB2SrcValue);
   //DeviceStatusAMFMAvail
   virtual tVoid vSendDeviceStatusAMFMAvailUpdate(const tU8 DeviceStatusAMFMAvailValue);
   //MediaStatusSeekStatus
   virtual tVoid vSendMediaStatusSeekStatusUpdate(const tU8 MediaStatusSeekStatusValue);
   //MediaStatusRepeatStatus
   virtual tVoid vSendMediaStatusRepeatStatusUpdate(const tU8 MediaStatusRepeatStatusValue);
   //MediaStatusDABFMStatus
   virtual tVoid vSendMediaStatusDABFMStatusUpdate(const tU8 MediaStatusDABFMStatusValue);
   //VehicleNaviLatitude
   virtual tVoid vSendVehicleNaviLatitudeUpdate(const tU32 VehicleNaviLatitudeValue);
   //VehicleNaviLongitude
   virtual tVoid vSendVehicleNaviLongitudeUpdate(const tU32 VehicleNaviLongitudeValue);
    //MediaStatusTREGStatus
   virtual tVoid vSendMediaStatusTREGStatusUpdate(const tU8 MediaStatusTREGStatusValue);
   //MediaStatusTREGRTMStatus
   virtual tVoid vSendMediaStatusTREGRTMStatusUpdate(const tU8 MediaStatusTREGRTMStatusValue);
  //MediaStatusRDSStatus
   virtual tVoid vSendMediaStatusRDSStatusUpdate(const tU8 MediaStatusRDSStatusValue);
  //MediaStatusTAStatus
   virtual tVoid vSendMediaStatusTAStatusUpdate(const tU8 MediaStatusTAStatusValue);
  //MediaStatusTPStatus
   virtual tVoid vSendMediaStatusTPStatusUpdate(const tU8 MediaStatusTPStatusValue);
  //MediaStatusTunerBandStatus
   virtual tVoid vSendMediaStatusTunerBandStatusUpdate(const tU8 MediaStatusTunerBandStatusValue);
  //MediaStatusTunerPresetStatus
   virtual tVoid vSendMediaStatusTunerPresetStatusUpdate(const tU8 MediaStatusTunerPresetStatusValue);
   //HUS_DM1_Status
   virtual tVoid vSendHUS_DM1_StatusUpdate(const tU64 HUS_DM1_StatusValue);
   
   virtual tVoid vSendSDSStatusUpdate(const tBool bSDSStatus);
   virtual tVoid vSendCockpitLanguageUpdate(const tU8 u8RequestedLang);
   virtual tVoid vSendMeterLanguageSyncMenuUpdate(const tU8 u8LangSyncMenu);
   virtual tVoid vSendUnitDistanceDisplayRequestUpdate(const tU8 u8Request);
   
   //For P-IVI
   virtual tVoid vSendTire_Pressure_Set ( tU8 u8TirePressure);
   
// veda_tclClientVcan::ClassImplementation: user specific code end


};

#endif // _VCANCAN_CLIENT_H_

