#ifndef _VEDA_CONFIG_H_
#define _VEDA_CONFIG_H_

#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"

typedef enum {
   VCAN_HANDBRAKE_UNUSED = 0,
   VCAN_HANDBRAKE_OFF,
   VCAN_HANDBRAKE_ON,
   VCAN_HANDBRAKE_UNKNOWN
} enVCANHandBrake;

typedef enum {
   VCAN_REARGEAR_UNUSED = 0,
   VCAN_REARGEAR_OFF,
   VCAN_REARGEAR_ON,
   VCAN_REARGEAR_UNAVAILABLE
} enVCANRearGear;

typedef enum {
   BUS_FAULT_INACTIVE = 0x00,
   BUS_FAULT_ACTIVE = 0x80,
   BUS_FAULT_CONFIRMED = 0xC0,
   BUS_FAULT_UNKNOWN = 0xFF
} enCANFaultState;

typedef enum {
   BUS_STATE = 0x00,
   BUS_RX_STATE = 0x01,
   BUS_TX_STATE = 0x02,
   BUS_INIT = 0x03
} enBusIndicationType;

typedef enum {
   VCAN = 0x00,
   MCAN = 0x01
} enBusType;

typedef enum {
   Passed, // This test result indicates a completed test with no errors.
   Failed, // This test result indicates a completed test with errors.
   NoResult, // The test routine did not run to completion or could not determine whether a malfunction exists or not.
   PassedDiagnostic, // This test result indicates a completed test in diagnostic mode with no error.
   FailedDiagnostic, // This test result indicates a completed test in diagnostic mode with errors.
   NoResultDiagnostic, // The test routine started in diagnostic mode did not run to completion or could not determine whether a malfunction exists or not
   Disable, // Disables the specified ITC until the next system start or Enable command. The DTC will not be visible in status queries
   Enable // Enables the specified ITC until the next system start.
} enITCResult;

//**************************************************************************************************
// Configuration of the DIAG interface -> indexes for a MAP with locally stored states/errors 
//************************************************************************************************** 


typedef enum
{
  // !!! changing the position of these commented defines below may require changes in 
  // !!! _vTraceCurrentFaultStateForPropertyNetworkstate() and
  // !!! _vTraceCurrentFaultState()
  VEDA_DIAG_BUS_OFF_MCAN__ = 0,
  VEDA_DIAG_BUS_OFF_VCAN__,
  VEDA_DIAG_MUTE_MCAN_SWC_,
  VEDA_DIAG_MUTE_MCAN_AUD_,
  VEDA_DIAG_MUTE_MCAN_NAV_,
  VEDA_DIAG_MUTE_MCAN_NAV2,
  VEDA_DIAG_MUTE_MCAN_TCU_,
  VEDA_DIAG_MUTE_MCAN_BOSE,
  VEDA_DIAG_MUTE_MCAN_RSE_,
  VEDA_DIAG_MUTE_VCAN_____,
  VEDA_DIAG_ECU_BCM_454___,
  VEDA_DIAG_ECU_USM_224___,
  VEDA_DIAG_ECU_STRG_002__,
  VEDA_DIAG_ECU_METER_4F2_,
  VEDA_DIAG_ECU_SONAR_57A_,
  VEDA_DIAG_ECU_ISA_5EA___,
  VEDA_DIAG_ECU_AVM_5C2___,
  VEDA_DIAG_ECU_HCM_15C___,
  VEDA_DIAG_ECU_SBW_0C1___,
  VEDA_DIAG_ECU_ATCU______,
  VEDA_DIAG_ECU_EPS_A3___,
  VEDA_DIAG_ECU_VDC_438__,
  VEDA_DIAG_ECU_FCAM_____,
  VEDA_DIAG_ECU_FWS_179___,
  VEDA_DIAG_ECU_HFM_46F___,
  VEDA_DIAG_ECU_HVAC_A1__,
  VEDA_DIAG_ECU_HUD_______,
  VEDA_DIAG_ECU_TCU_43C___,
  VEDA_DIAG_ECU_ACU_538___,
  VEDA_DIAG_ECU_ADAS_A6___,
  VEDA_DIAG_ECU_BSW_______,
  VEDA_DIAG_ECU_HSM_______,
  VEDA_DIAG_ECU_SR________,
  VEDA_DIAG_ECU_DSMU______,
  VEDA_DIAG_ECU_PSCU______,
  VEDA_DIAG_ECU_ECM_______,
  VEDA_DIAG_ECU_AMP_______,
  VEDA_DIAG_MCAN_INIT_____,
  VEDA_DIAG_VCAN_INIT_____,
  VEDA_DIAG_ECU_ITM_______,
  VEDA_DIAG_LAST
}tenDiagTMapIndex;

typedef enum {
  IDX_BUS_OFF_MCAN   = ITC_AIVI_MCAN_BUS_OFF - ITC_AIVI_MCAN_START,
  IDX_BUS_OFF_VCAN   = ITC_AIVI_VCAN_BUS_OFF - ITC_AIVI_VCAN_START,
  IDX_MUTE_MCAN_SWC  = ITC_AIVI_MCAN_METER_SWC_CMF_MUTE_ERR - ITC_AIVI_MCAN_START, 
  IDX_MUTE_MCAN_AUD  = ITC_AIVI_MCAN_METER_AUD_CMF_MUTE_ERR - ITC_AIVI_MCAN_START, 
  IDX_MUTE_MCAN_NAV  = ITC_AIVI_MCAN_METER_NAV_CMF_MUTE_ERR - ITC_AIVI_MCAN_START, 
  IDX_MUTE_MCAN_TCU  = ITC_AIVI_MCAN_TCU_CMF_MUTE_ERR - ITC_AIVI_MCAN_START, 
  IDX_MUTE_MCAN_BOSE = ITC_AIVI_MCAN_BOSE_CMF_MUTE_ERR - ITC_AIVI_MCAN_START,
  IDX_MUTE_MCAN_RSE  = ITC_AIVI_MCAN_RSE_CMF_MUTE_ERR - ITC_AIVI_MCAN_START, 
  IDX_MUTE_VCAN      = ITC_AIVI_VCAN_MUTE_ERROR - ITC_AIVI_VCAN_START,
  IDX_ECU_STRG_002   = ITC_AIVI_VCAN_ABSENT_STRG - ITC_AIVI_VCAN_START,    
  IDX_ECU_METER_4F2  = ITC_AIVI_VCAN_ABSENT_CLUSTER - ITC_AIVI_VCAN_START, 
  IDX_ECU_SONAR_57A  = ITC_AIVI_VCAN_ABSENT_SONAR - ITC_AIVI_VCAN_START, 
  IDX_ECU_ISA_5EA    = ITC_AIVI_VCAN_ABSENT_COP - ITC_AIVI_VCAN_START,   
  IDX_ECU_AVM_5C2    = ITC_AIVI_VCAN_AVM_COM_ERR - ITC_AIVI_VCAN_START,   
  IDX_ECU_HCM_15C    = ITC_AIVI_VCAN_ABSENT_HCM - ITC_AIVI_VCAN_START,
  IDX_ECU_BCM_454    = ITC_AIVI_VCAN_ABSENT_BCM - ITC_AIVI_VCAN_START,   
  IDX_ECU_USM_224    = ITC_AIVI_VCAN_ABSENT_USM - ITC_AIVI_VCAN_START,   
  IDX_ECU_SBW_0C1    = ITC_AIVI_VCAN_ABSENT_SBW - ITC_AIVI_VCAN_START,
  IDX_ECU_ATCU		 = ITC_AIVI_DIAGMUX_VCAN_AUT_TRAN_LOST_COM - ITC_AIVI_DIAGMUX_START,
  IDX_ECU_EPS_A3	 = ITC_AIVI_DIAGMUX_VCAN_E_POW_STEER_LOST_COM - ITC_AIVI_DIAGMUX_START,
  IDX_ECU_VDC_438	 = ITC_AIVI_DIAGMUX_VCAN_E_STAB_CON_LOST_COM - ITC_AIVI_DIAGMUX_START,
  IDX_ECU_FCAM		 = ITC_AIVI_DIAGMUX_VCAN_FR_CAMERA_LOST_COM - ITC_AIVI_DIAGMUX_START,
  IDX_ECU_FWS_179	 = ITC_AIVI_DIAGMUX_VCAN_FOUR_WHEEL_ST_LOST_COM - ITC_AIVI_DIAGMUX_START,
  IDX_ECU_HFM_46F    = ITC_AIVI_DIAGMUX_VCAN_HAND_FREE_MOD_LOST_COM - ITC_AIVI_DIAGMUX_START,
  IDX_ECU_HVAC_A1    = ITC_AIVI_DIAGMUX_VCAN_CLIM_CONTROL_LOST_COM - ITC_AIVI_DIAGMUX_START,
  IDX_ECU_HUD        = ITC_AIVI_DIAGMUX_VCAN_HUD_LOST_COM - ITC_AIVI_DIAGMUX_START,
  IDX_ECU_TCU_43C    = ITC_AIVI_DIAGMUX_VCAN_TCU_LOST_COM - ITC_AIVI_DIAGMUX_START,
  IDX_ECU_ACU_538    = ITC_AIVI_DIAGMUX_VCAN_AIRBAG_CONT_LOST_COM - ITC_AIVI_DIAGMUX_START,
  IDX_ECU_ADAS_A6    = ITC_AIVI_DIAGMUX_VCAN_ADV_DRIV_ASSIST_LOST_COM - ITC_AIVI_DIAGMUX_START,
  IDX_ECU_BSW        = ITC_AIVI_DIAGMUX_VCAN_BL_SPOT_WARN_LOST_COM - ITC_AIVI_DIAGMUX_START,
  IDX_ECU_HSM        = ITC_AIVI_DIAGMUX_VCAN_HYBR_ELEC_VEH_LOST_COM - ITC_AIVI_DIAGMUX_START,
  IDX_ECU_SR         = ITC_AIVI_DIAGMUX_VCAN_SCENE_REC_LOST_COM - ITC_AIVI_DIAGMUX_START,
  IDX_ECU_DSMU       = ITC_AIVI_DIAGMUX_VCAN_AUT_DRI_SEAT_LOST_COM - ITC_AIVI_DIAGMUX_START,
  IDX_ECU_PSCU       = ITC_AIVI_DIAGMUX_PASSENGER_SEAT_LOST_COM - ITC_AIVI_DIAGMUX_START,
  IDX_ECU_ECM        = ITC_AIVI_DIAGMUX_VCAN_ENG_CONT_MOD_LOST_COM - ITC_AIVI_DIAGMUX_START,
  IDX_ECU_AMP        = ITC_AIVI_DIAGMUX_AMP_V1_CAN_LOST_COM - ITC_AIVI_DIAGMUX_START,
  IDX_MCAN_INIT      = 0xFF,     
  IDX_VCAN_INIT      = 0xFF,
  IDX_VCAN_ITM       = ITC_AIVI_VCAN_ABSENT_ITM - ITC_AIVI_VCAN_START
}enDiagFaultIndex;

#define VD_DIAG_BUSOFF_START    VEDA_DIAG_BUS_OFF_MCAN__
#define VD_DIAG_BUSOFF_END      VEDA_DIAG_BUS_OFF_VCAN__

#define VD_DIAG_FAULTNODE_START VEDA_DIAG_MUTE_MCAN_SWC_
#define VD_DIAG_FAULTNODE_END   VEDA_DIAG_ECU_AMP_______

#define VD_DIAG_CATD_NODE_BEGIN VEDA_DIAG_ECU_STRG_002__
#define VD_DIAG_CATD_NODE_END   VEDA_DIAG_ECU_SBW_0C1___


#define VD_FEATURE_ALL_OFF                         0x00000000

#define VD_FEATURE_D                               0x00800000   // reserved
#define VD_FEATURE_C                               0x00400000   // reserved
#define VD_FEATURE_B                               0x00200000   // reserved
#define VD_FEATURE_A                               0x00100000   // reserved

#define VD_FEATURE_CLIMATE_CONTROL                 0x00080000   // HVAC type
#define VD_FEATURE_TRANSMISSION_TYPE               0x00040000   // Automatic Transmission PowerTrain
#define VD_FEATURE_SR                              0x00020000   // VCAN SR absence
#define VD_FEATURE_TPMS                            0x00010000   // P-IVI TPMS Configuration

#define VD_FEATURE_SPEED_LOCK                      0x00008000   // SPEED_LOCK supervision
#define VD_FEATURE_TSR_AVAILABLE                   0x00004000   // ADAS_OSP
#define VD_FEATURE_VCAN_MONITORING                 0x00002000   // VCAN supervision
#define VD_FEATURE_ISA_AVAILABLE                   0x00001000   // VCAN ISA absence

#define VD_FEATURE_HEV_AVAILABLE                   0x00000800   // VCAN HEV absence
#define VD_FEATURE_AVM_AVAILABLE                   0x00000400   // VCAN AVM absence
#define VD_FEATURE_SONAR_AVAILABLE                 0x00000200   // VCAN SONAR absence
#define VD_FEATURE_RVC_AVAILABLE                   0x00000100   // VCAN RVC absence

#define VD_FEATURE_SBW_AVAILABLE                   0x00000080   // VCAN SBW
#define VD_FEATURE_STRG_AVAILABLE                  0x00000040   // VCAN STRG
#define VD_FEATURE_MCAN_NAVI_AVAILABLE             0x00000020   // MCAN Navi
#define VD_FEATURE_MCAN_RSE_AVAILABLE              0x00000010   // MCAN RSE

#define VD_FEATURE_MCAN_TCU_AVAILABLE              0x00000008   // MCAN TCU
#define VD_FEATURE_MCAN_BOSE_AVAILABLE             0x00000004   // MCAN AMP
#define VD_FEATURE_MCAN_SWC_AVAILABLE              0x00000002   // MCAN SWC
#define VD_FEATURE_MCAN_METER_AVAILABLE            0x00000001   // MCAN Meter

typedef struct
{
  tU16  u16MapIndex;
  tU16  u16ITC[2];
  tU8   u8AddrField;
  tU8   u8Bus;
  tU8   u8IndicationType;
  tU8   u8FaultIndex;
  tU32  u32FeatureMask;
}TDiagFaultConfiguration;

// the following config data are used to update the diagbytes and the diaglog more generic
//----------------------------------------------------------------------------------------------------------------------------------------------------------
//   u16MapIndex               u16ITC                                u8AddrField
//   |                         |                                     |                        u8Bus
//   |                         |                                     |                        |      u8IndicationType
//   |                         |                                     |                        |      |
//   |                         |                                     |                        |      |             u8FaultIndex
//   |                         |                                     |                        |      |             |                   u16FeatureMask
//----------------------------------------------------------------------------- ----------------------------------------------------------------------------
static TDiagFaultConfiguration tConfig[VEDA_DIAG_LAST] =
{
   // do not change orders and amounts without digging for side-effects !!!! be warned !!!!
   { VEDA_DIAG_BUS_OFF_MCAN__, 	ITC_AIVI_MCAN_BUS_OFF,               0xFFFF,           	                            CSM_C_CAN_BUS_MCAN,        	 MCAN, BUS_STATE,    IDX_BUS_OFF_MCAN,         VD_FEATURE_ALL_OFF},
   { VEDA_DIAG_BUS_OFF_VCAN__, 	ITC_AIVI_VCAN_BUS_OFF,               0xFFFF,           	                            CSM_C_CAN_BUS_VCAN,        	 VCAN, BUS_STATE,    IDX_BUS_OFF_VCAN,         VD_FEATURE_VCAN_MONITORING},
   { VEDA_DIAG_MUTE_MCAN_SWC_, 	ITC_AIVI_MCAN_METER_SWC_CMF_MUTE_ERR,0xFFFF,                                        0xFF,   	 MCAN, BUS_TX_STATE, IDX_MUTE_MCAN_SWC,        VD_FEATURE_MCAN_SWC_AVAILABLE},
   { VEDA_DIAG_MUTE_MCAN_AUD_, 	ITC_AIVI_MCAN_METER_AUD_CMF_MUTE_ERR,0xFFFF,                                        0xFF, 	 MCAN, BUS_TX_STATE, IDX_MUTE_MCAN_AUD,        VD_FEATURE_MCAN_METER_AVAILABLE},
   { VEDA_DIAG_MUTE_MCAN_NAV_, 	ITC_AIVI_MCAN_METER_NAV_CMF_MUTE_ERR,0xFFFF,                                        0xFF,  	 MCAN, BUS_TX_STATE, IDX_MUTE_MCAN_NAV,        VD_FEATURE_MCAN_NAVI_AVAILABLE},
   { VEDA_DIAG_MUTE_MCAN_NAV2, 	ITC_AIVI_MCAN_METER_NAV_CMF_MUTE_ERR,0xFFFF,                                        0xFF, 	 MCAN, BUS_TX_STATE, IDX_MUTE_MCAN_NAV,        VD_FEATURE_MCAN_NAVI_AVAILABLE},
   { VEDA_DIAG_MUTE_MCAN_TCU_, 	ITC_AIVI_MCAN_TCU_CMF_MUTE_ERR,      0xFFFF,   	                                    0xFF,   	 MCAN, BUS_TX_STATE, IDX_MUTE_MCAN_TCU,        VD_FEATURE_MCAN_TCU_AVAILABLE},
   { VEDA_DIAG_MUTE_MCAN_BOSE, 	ITC_AIVI_MCAN_BOSE_CMF_MUTE_ERR,     0xFFFF,   	                                    0xFF,  	 MCAN, BUS_TX_STATE, IDX_MUTE_MCAN_BOSE,       VD_FEATURE_MCAN_BOSE_AVAILABLE},
   { VEDA_DIAG_MUTE_MCAN_RSE_, 	ITC_AIVI_MCAN_RSE_CMF_MUTE_ERR,      0xFFFF,   	                                    0xFF,   	 MCAN, BUS_TX_STATE, IDX_MUTE_MCAN_RSE,        VD_FEATURE_MCAN_RSE_AVAILABLE  },
   { VEDA_DIAG_MUTE_VCAN_____, 	ITC_AIVI_VCAN_MUTE_ERROR,            0xFFFF,       	                                0xFF, VCAN, BUS_TX_STATE, IDX_MUTE_VCAN,            VD_FEATURE_ALL_OFF             },
   { VEDA_DIAG_ECU_BCM_454___, 	ITC_AIVI_VCAN_ABSENT_BCM,            ITC_AIVI_DIAGMUX_VCAN_BCM_LOST_COM,          	0xFF,   	 VCAN, BUS_RX_STATE, IDX_ECU_BCM_454,          VD_FEATURE_ALL_OFF             },
   { VEDA_DIAG_ECU_USM_224___, 	ITC_AIVI_VCAN_ABSENT_USM,            ITC_AIVI_DIAGMUX_VCAN_UN_SWITCH_MOD_LOST_COM,  0xFF,   	 VCAN, BUS_RX_STATE, IDX_ECU_USM_224,          VD_FEATURE_ALL_OFF             },
   { VEDA_DIAG_ECU_STRG_002__, 	ITC_AIVI_VCAN_ABSENT_STRG,           ITC_AIVI_DIAGMUX_VCAN_INT_DYN_CON_LOST_COM,    0xFF,  	 VCAN, BUS_RX_STATE, IDX_ECU_STRG_002,         (VD_FEATURE_STRG_AVAILABLE | VD_FEATURE_RVC_AVAILABLE) },
   { VEDA_DIAG_ECU_METER_4F2_, 	ITC_AIVI_VCAN_ABSENT_CLUSTER,        ITC_AIVI_DIAGMUX_VCAN_CLUSTER_LOST_COM,       	0xFF, 	 VCAN, BUS_RX_STATE, IDX_ECU_METER_4F2,        VD_FEATURE_ALL_OFF             },
   { VEDA_DIAG_ECU_SONAR_57A_, 	ITC_AIVI_VCAN_ABSENT_SONAR,          ITC_AIVI_DIAGMUX_VCAN_ULT_SON_ADAS_LOST_COM,   0xFF, 	 VCAN, BUS_RX_STATE, IDX_ECU_SONAR_57A,        VD_FEATURE_SONAR_AVAILABLE     },
   { VEDA_DIAG_ECU_ISA_5EA___, 	ITC_AIVI_VCAN_ABSENT_COP,            0xFFFF,   										0xFF,   	 VCAN, BUS_RX_STATE, IDX_ECU_ISA_5EA,          VD_FEATURE_ISA_AVAILABLE},
   { VEDA_DIAG_ECU_AVM_5C2___, 	ITC_AIVI_VCAN_AVM_COM_ERR,           ITC_AIVI_DIAGMUX_VCAN_AVM_LOST_COM   ,         0xFF,   	 VCAN, BUS_RX_STATE, IDX_ECU_AVM_5C2,          VD_FEATURE_AVM_AVAILABLE},
   { VEDA_DIAG_ECU_HCM_15C___, 	ITC_AIVI_VCAN_ABSENT_HCM,            0xFFFF,       	                                0xFF,   	 VCAN, BUS_RX_STATE, IDX_ECU_HCM_15C,          VD_FEATURE_HEV_AVAILABLE},
   { VEDA_DIAG_ECU_SBW_0C1___, 	ITC_AIVI_VCAN_ABSENT_SBW,            0xFFFF,       	                                0xFF,   	 VCAN, BUS_RX_STATE, IDX_ECU_SBW_0C1,          (VD_FEATURE_SBW_AVAILABLE | VD_FEATURE_RVC_AVAILABLE)},
   { VEDA_DIAG_ECU_ATCU______,  0xFFFF,                              ITC_AIVI_DIAGMUX_VCAN_AUT_TRAN_LOST_COM,       0xFF,    VCAN, BUS_RX_STATE, IDX_ECU_ATCU,			   VD_FEATURE_ALL_OFF},
   { VEDA_DIAG_ECU_EPS_A3___,   0xFFFF,                              ITC_AIVI_DIAGMUX_VCAN_E_POW_STEER_LOST_COM,    0xFF,     VCAN, BUS_RX_STATE, IDX_ECU_EPS_A3,		   VD_FEATURE_ALL_OFF},
   { VEDA_DIAG_ECU_VDC_438__,   0xFFFF,                              ITC_AIVI_DIAGMUX_VCAN_E_STAB_CON_LOST_COM,     0xFF,     VCAN, BUS_RX_STATE, IDX_ECU_VDC_438, 		   VD_FEATURE_ALL_OFF},
   { VEDA_DIAG_ECU_FCAM_____,   0xFFFF,                              ITC_AIVI_DIAGMUX_VCAN_FR_CAMERA_LOST_COM,      0xFF,    VCAN, BUS_RX_STATE, IDX_ECU_FCAM,             VD_FEATURE_ALL_OFF},
   { VEDA_DIAG_ECU_FWS_179___,  0xFFFF,                              ITC_AIVI_DIAGMUX_VCAN_FOUR_WHEEL_ST_LOST_COM,  0xFF,     VCAN, BUS_RX_STATE, IDX_ECU_FWS_179,          VD_FEATURE_ALL_OFF},
   { VEDA_DIAG_ECU_HFM_46F___,  0xFFFF,                              ITC_AIVI_DIAGMUX_VCAN_HAND_FREE_MOD_LOST_COM,  0xFF,     VCAN, BUS_RX_STATE, IDX_ECU_HFM_46F,          VD_FEATURE_ALL_OFF},
   { VEDA_DIAG_ECU_HVAC_A1__,   0xFFFF,                              ITC_AIVI_DIAGMUX_VCAN_CLIM_CONTROL_LOST_COM,   0xFF,    VCAN, BUS_RX_STATE, IDX_ECU_HVAC_A1,          VD_FEATURE_ALL_OFF},
   { VEDA_DIAG_ECU_HUD_______,  0xFFFF,                              ITC_AIVI_DIAGMUX_VCAN_HUD_LOST_COM,            0xFF,     VCAN, BUS_RX_STATE, IDX_ECU_HUD,              VD_FEATURE_ALL_OFF},
   { VEDA_DIAG_ECU_TCU_43C___,  0xFFFF,                              ITC_AIVI_DIAGMUX_VCAN_TCU_LOST_COM,            0xFF,    VCAN, BUS_RX_STATE, IDX_ECU_TCU_43C,          VD_FEATURE_MCAN_TCU_AVAILABLE},
   { VEDA_DIAG_ECU_ACU_538___,  0xFFFF,                              ITC_AIVI_DIAGMUX_VCAN_AIRBAG_CONT_LOST_COM,    0xFF,     VCAN, BUS_RX_STATE, IDX_ECU_ACU_538,          VD_FEATURE_ALL_OFF},
   { VEDA_DIAG_ECU_ADAS_A6___,  0xFFFF,                              ITC_AIVI_DIAGMUX_VCAN_ADV_DRIV_ASSIST_LOST_COM,0xFF,    VCAN, BUS_RX_STATE, IDX_ECU_ADAS_A6,          VD_FEATURE_ALL_OFF},
   { VEDA_DIAG_ECU_BSW_______,  0xFFFF,                              ITC_AIVI_DIAGMUX_VCAN_BL_SPOT_WARN_LOST_COM,   0xFF,     VCAN, BUS_RX_STATE, IDX_ECU_BSW,              VD_FEATURE_ALL_OFF},
   { VEDA_DIAG_ECU_HSM_______,  0xFFFF,                              ITC_AIVI_DIAGMUX_VCAN_HYBR_ELEC_VEH_LOST_COM,   0xFF,     VCAN, BUS_RX_STATE, IDX_ECU_HSM,             VD_FEATURE_ALL_OFF},
   { VEDA_DIAG_ECU_SR________,  0xFFFF,                              ITC_AIVI_DIAGMUX_VCAN_SCENE_REC_LOST_COM,      0xFF,      VCAN, BUS_RX_STATE, IDX_ECU_SR,               VD_FEATURE_SR},
   { VEDA_DIAG_ECU_DSMU______,  0xFFFF,                              ITC_AIVI_DIAGMUX_VCAN_AUT_DRI_SEAT_LOST_COM,   0xFF,    VCAN, BUS_RX_STATE, IDX_ECU_DSMU,             VD_FEATURE_ALL_OFF},
   { VEDA_DIAG_ECU_PSCU______,  0xFFFF,                              ITC_AIVI_DIAGMUX_PASSENGER_SEAT_LOST_COM,      0xFF,    VCAN, BUS_RX_STATE, IDX_ECU_PSCU,             VD_FEATURE_ALL_OFF},
   { VEDA_DIAG_ECU_ECM_______,  0xFFFF,                              ITC_AIVI_DIAGMUX_VCAN_ENG_CONT_MOD_LOST_COM,   0xFF,     VCAN, BUS_RX_STATE, IDX_ECU_ECM,              VD_FEATURE_ALL_OFF},
   { VEDA_DIAG_ECU_AMP_______,  0xFFFF,                              ITC_AIVI_DIAGMUX_AMP_V1_CAN_LOST_COM,          0xFF,     VCAN, BUS_RX_STATE, IDX_ECU_AMP,              VD_FEATURE_ALL_OFF},
   { VEDA_DIAG_MCAN_INIT_____, 	ITC_AIVI_MCAN_INITIALISATION_ERROR,  0xFFFF,                                        0xFF,                      	 VCAN, BUS_INIT,     IDX_MCAN_INIT,            VD_FEATURE_ALL_OFF},
   { VEDA_DIAG_VCAN_INIT_____, 	ITC_AIVI_VCAN_INITIALISATION_ERROR,  0xFFFF,                                        0xFF,                      	 VCAN, BUS_INIT,     IDX_VCAN_INIT,            VD_FEATURE_VCAN_MONITORING},
   { VEDA_DIAG_ECU_ITM_______, 	ITC_AIVI_VCAN_ABSENT_ITM,            0xFFFF,       	                                0xFF,                      	 VCAN, 0xFF,         IDX_VCAN_ITM,             VD_FEATURE_ALL_OFF}
};

#endif // _VEDA_CONFIG_H_

