/*****************************************************************************
* FILE:         veda_appl_main.h
* PROJECT:      G3G project
* SW-COMPONENT: VehicleData
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Main Application handler for VehicleData
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2015 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#ifndef __VEDA_APPL_HANLDER__H_
#define __VEDA_APPL_HANDLER__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

//! include base class
#include "I_veda_appl_handler.h"
#include "I_veda_ServiceVehicleIf.h"

typedef enum {
   KMPH = 0,
   MPH = 1,
   SPEED_UNIT_UNKNOWN = 255
} enSpeedLimitUnit;

typedef struct BusComm {
   tU8 u8BusState;
   tU8 u8BusRxState;
   tU8 u8BusTxState;
   bpstl::vector<tU8, bpstl::allocator<tU8> > u8AbsentECU;
} TBusComInfo;

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

//! Forward Declaration
class Iveda_tclServiceVehicleIf;
class I_veda_tclClientVcan;
class Iveda_tclClientDiaglogIf;

//! General Application Handler Class
class veda_tclApplHandler : public Iveda_tclApplHandler
{
public:
   veda_tclApplHandler();
   veda_tclApplHandler(veda_tclAppMain* poMainAppl);
   virtual ~veda_tclApplHandler();

   virtual const tChar* getName() const { return "veda_tclApplHandler"; }

   virtual tVoid vHandleMessage(TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   void vUpdateReverseGear(const tU8 u8ReverseGear) const;
   virtual void vUpdateCSMEngineeringData(tU32 u32MessageId, tU32 u32Status, tU8* u8Payload);

private:

   void vTraceCSMEnggDataInfo() const;

   void vGetCSMEngineeringData(void);

   static OSAL_tpfGPIOCallback _pfCallbackGpioStateChange_Reverse(tVoid* pArg);
   void _vConfigureGpio_Reverse(void);
   void _vCloseGpio_Reverse(void);
   bool _bReadGPIOState_Reverse(void);

   void _vHandleAbnormalVoltageEnd(void);
   void _vHandleAbnormalVoltageStart(void);

   tBool _bUnderVoltageOngoing;
   tBool _bIsIgnitionOn;

   bpstl::vector<vehicle_fi_tcl_CAN_Message, bpstl::allocator<vehicle_fi_tcl_CAN_Message> > _tCSMEnggData;

   OSAL_tGPIODevID    _GpioId_Reverse;
   OSAL_tIODescriptor _hGpioHandle_Reverse;

   Iveda_tclServiceVehicleIf* _poCCAServiceHdl;
   I_veda_tclClientVcan* _poCANClientHdl;
};

#endif // __VEDA_APPL_HANLDER__H_
