/************************************************************************
* FILE        :  veda_DiagSystemSetListener.cpp       
* PROJECT     :  IVI
* SW-COMPONENT:  vd_vehicledata
*----------------------------------------------------------------------
*
* DESCRIPTION : 
*
*----------------------------------------------------------------------
* COPYRIGHT   :    (c) 2010 Robert Bosch GmbH, Hildesheim
* HISTORY     :
*
* Date      | Author             | Modification
*
*************************************************************************/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS  TR_CLASS_VEHICLEDATA_DIAG_HANDLER
#include "trcGenProj/Header/veda_DiagSystemSetListener.cpp.trc.h"
#endif

#define DIAGNOSTICS_KDS_ENTRY_IMPORT_INTERFACE
#include "fc_diagnosis_if.h"

#include "veda_DiagSystemSetListener.h"
#include "veda_AppMain.h"

/*************************************************************************
*
* FUNCTION: Constructor
* 
* DESCRIPTION: Init Members 
*
* PARAMETER: poMainAppl Pointer to main application
*            poIF Pointer to diaglib SystemSet interface 
*
* RETURNVALUE:
*
*************************************************************************/
veda_tclSystemSetListener::veda_tclSystemSetListener(diaglib::tclSystemSetIF * poIF, veda_tclAppMain* poMainAppl)
{
  ETG_TRACE_USR1(("CONSTRUCTOR: veda_tclSystemSetListener() entered"));

  m_poSystemSetIF = poIF;
  m_poMainAppl = poMainAppl;
}

/*************************************************************************
*
* FUNCTION: Destructor
* 
* DESCRIPTION:  
*
* PARAMETER:  
*
* RETURNVALUE:
*
*************************************************************************/
veda_tclSystemSetListener::~veda_tclSystemSetListener()
{
  // +++ Free resources you might have created/used +++
  m_poSystemSetIF = OSAL_NULL;
  m_poMainAppl = OSAL_NULL;
}

/*************************************************************************
*
* FUNCTION: vOnSystemSet
* 
* DESCRIPTION:  
*
* PARAMETER:  
*
* RETURNVALUE:
*
*************************************************************************/
tU32 veda_tclSystemSetListener::vOnSystemSet( tU32 u32SystemSetID, 
                                                        diaglib::tenSystemSetType u32SystemSetType,
                                                        diaglib::tContext MsgContext
                                                      )
{
  ETG_TRACE_USR1(("INPUT: SystemSetListener::vOnSystemSet() - MsgContext: %X ", MsgContext ));
  ETG_TRACE_USR1(("INPUT: SystemSetListener::vOnSystemSet() %u", u32SystemSetType));
  OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetID );

  // temp vars  
  diaglib::tenSystemSetResult _enSysSetResult = diaglib::EN_SYSTEMSET_OK;
  diaglib::tclParameterVector _oErrorList;
  if ( (diaglib::EN_TYPE_DEFAULT_TEF == u32SystemSetType) ||
       (diaglib::EN_TYPE_DEFAULT_HMI == u32SystemSetType) ||
	   (diaglib::EN_TYPE_DEFAULT_CUSTOMER == u32SystemSetType) ||
       (diaglib::EN_TYPE_CODING == u32SystemSetType) )
  {
     veda_tclBaseIf::TMsg oMsg;
     (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
     oMsg.eCmd = veda_tclBaseIf::eDefaultSetting;
     oMsg.u.u8Data = (tU8) u32SystemSetType;
     memset(oMsg.strClassName, 0, 50);
     if ( m_poMainAppl != OSAL_NULL )
        m_poMainAppl->vPostInternalMessage(&oMsg);
  }
  else
  {
    // other system type -> not supported
    // probably better NOT to return an error, since diag might trigger again and again
  }

  if (m_poSystemSetIF != OSAL_NULL)
  {
    if (TRUE == m_poSystemSetIF->bSendSystemSetResult( _enSysSetResult, _oErrorList, MsgContext) )
    {
      // +++ Trace info +++
    }
    else
    {
      ETG_TRACE_USR1(("SystemSetListener::vOnSystemSet() - ERROR sending result"));
    }
  }
  else
  {
    ETG_TRACE_USR1(("SystemSetListener::vOnSystemSet() - ERROR invalid pointer"));
  } 

  return diaglib::U32_DIAGLIB_RETURN_OK;
}

/*************************************************************************
*
* FUNCTION: vOnSystemSetFinished
* 
* DESCRIPTION:  
*
* PARAMETER:  
*
* RETURNVALUE:
*
*************************************************************************/
tU32 veda_tclSystemSetListener::vOnSystemSetFinished( tU32 u32SystemSetID, 
                                                                diaglib::tenSystemSetType u32SystemSetType,
                                                                diaglib::tContext MsgContext
                                                              )
{
  ETG_TRACE_USR1(("INPUT: SystemSetListener::vOnSystemSetFinished() entered"));
  // +++ Reallow access to values that needed default setting, then send positive response +++
  OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetID );
  OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetType );

  if (m_poSystemSetIF != OSAL_NULL)
  {
    if (TRUE == m_poSystemSetIF->bAcknowledgeSystemSetFinished(MsgContext))
    {
      // +++ Trace info +++
    }
    else
    {
      ETG_TRACE_USR1(("SystemSetListener::vOnSystemSetFinished() - ERROR giving acknowledge"));
    }
  }
  else
  {
    ETG_TRACE_USR1(("SystemSetListener::vOnSystemSetFinished()- ERROR invalid pointer"));
  }
  
  return diaglib::U32_DIAGLIB_RETURN_OK;
}

/*************************************************************************
*
* FUNCTION: vOnSystemSetPrepare
* 
* DESCRIPTION:  
*
* PARAMETER:  
*
* RETURNVALUE:
*
*************************************************************************/
tU32 veda_tclSystemSetListener::vOnSystemSetPrepare( tU32 u32SystemSetID, 
                                                               diaglib::tenSystemSetType u32SystemSetType,
                                                               diaglib::tContext MsgContext
                                                             )
{
  ETG_TRACE_USR1(("SystemSetListener::vOnSystemSetPrepare() entered"));
  // +++ Stop access to values that need default setting, then send positive response +++
  OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetID );
  OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetType );

  diaglib::tenSystemSetResult _enSysSetResult = diaglib::EN_SYSTEMSET_OK;
  diaglib::tclParameterVector _oErrorList;
  
  if (m_poSystemSetIF != OSAL_NULL)
  {
    if (TRUE == m_poSystemSetIF->bSendSystemSetPrepareResult( _enSysSetResult, _oErrorList, MsgContext ) )
    {
      // +++ Trace info +++
    }
    else
    {
      ETG_TRACE_USR1(("SystemSetListener::vOnSystemSetPrepare() - ERROR sending result"));
    }
  }
  else
  {
    ETG_TRACE_USR1(("SystemSetListener::vOnSystemSetPrepare() - ERROR: invalid pointer"));
  }

  return diaglib::U32_DIAGLIB_RETURN_OK;
}

/*************************************************************************
*
* FUNCTION: vOnSystemSetCheck
* 
* DESCRIPTION:  
*
* PARAMETER:  
*
* RETURNVALUE:
*
*************************************************************************/
tU32 veda_tclSystemSetListener::vOnSystemSetCheck( tU32 u32SystemSetID, 
                                                             diaglib::tenSystemSetType u32SystemSetType,
                                                             diaglib::tContext MsgContext
                                                           )
{
  ETG_TRACE_USR1(("SystemSetListener::vOnSystemSetCheck() entered"));
  // +++ Check if all values are set to default. +++
  OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetID );
  OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetType );

  diaglib::tenSystemSetResult _enSysSetResult = diaglib::EN_SYSTEMSET_OK;
  diaglib::tclParameterVector _oErrorList;

  if (m_poSystemSetIF != OSAL_NULL)
  {
    if (TRUE == m_poSystemSetIF->bSendSystemSetCheckResult( _enSysSetResult, _oErrorList, MsgContext) )
    {
      // +++ Trace info +++
    }
    else
    {
      ETG_TRACE_USR1(("SystemSetListener::vOnSystemSetCheck() - ERROR sending result"));
    }
  }
  else
  {
    ETG_TRACE_USR1(("SystemSetListener::vOnSystemSetCheck() - ERROR invalid pointer"));
  }

  return diaglib::U32_DIAGLIB_RETURN_OK;
}

