#ifndef __MCAN_GENERIC_TYPES_CLASS_H_
   #define __MCAN_GENERIC_TYPES_CLASS_H_

#include <string>

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "mcanMsg.h"

class tcl_MCAN_GenericType_UnsignedInteger
{
public:
   
   tcl_MCAN_GenericType_UnsignedInteger(tU32 u32Data, tU16 u16BitSize);

   tBool   bUpdateData(tclMcanMsgData* poMcanMsg);
   tBool   bUpdateMcanMessage(tclMcanMsgData* poMcanMsg);

   tU32    u32GetData() {return _u32Data;};
   tVoid   vSetData(tU32 u32Data) {_u32Data = u32Data;};
   tU32    cu32GetData() const {return _u32Data;};

private:
   tU32   _u32Data;
   tU16   _u16BitSize;
};
tBool operator==(tcl_MCAN_GenericType_UnsignedInteger const& lhs, tcl_MCAN_GenericType_UnsignedInteger const& rhs);
tBool operator!=(tcl_MCAN_GenericType_UnsignedInteger const& lhs, tcl_MCAN_GenericType_UnsignedInteger const& rhs);

class tcl_MCAN_GenericType_Integer
{
public:
   
   tcl_MCAN_GenericType_Integer(tS32 s32Data, tU16 u16BitSize);

   tBool   bUpdateData(tclMcanMsgData* poMcanMsg);
   tBool   bUpdateMcanMessage(tclMcanMsgData* poMcanMsg);

   tS32    s32GetData() {return _s32Data;};
   tS32    cs32GetData() const {return _s32Data;};
   tVoid   vSetData(tS32 s32Data) {_s32Data = s32Data;};


private:
   tS32   _s32Data;
   tU16   _u16BitSize;
};
tBool operator==(tcl_MCAN_GenericType_Integer const& lhs, tcl_MCAN_GenericType_Integer const& rhs);
tBool operator!=(tcl_MCAN_GenericType_Integer const& lhs, tcl_MCAN_GenericType_Integer const& rhs);

class tcl_MCAN_GenericType_String
{
public:
   
   tcl_MCAN_GenericType_String(tChar* strData, tU16 u16BitSize);
   ~tcl_MCAN_GenericType_String();


   tBool   bUpdateLength(tU32 u32BitSize);

   tBool   bUpdateData(tclMcanMsgData* poMcanMsg);
   tBool   bUpdateMcanMessage(tclMcanMsgData* poMcanMsg);

   const tChar*  strGetData() {return _strMsgData.c_str();};
   const tChar*  cstrGetData() const {return _strMsgData.c_str();};
   tVoid   vSetData(tChar* strData, tU16 u16BitSize = 0);

private:
   std::string _strMsgData;
   tChar* _strData;
   tU16   _u16BitSize;
};
tBool operator==(tcl_MCAN_GenericType_String const& lhs, tcl_MCAN_GenericType_String const& rhs);
tBool operator!=(tcl_MCAN_GenericType_String const& lhs, tcl_MCAN_GenericType_String const& rhs);

class tcl_MCAN_GenericType_StreamData
{
public:
   
   tcl_MCAN_GenericType_StreamData(tU8* pu8Data, tU16 u16BitSize);
   tcl_MCAN_GenericType_StreamData(const tcl_MCAN_GenericType_StreamData &obj);  // copy constructor

   ~tcl_MCAN_GenericType_StreamData();

   tcl_MCAN_GenericType_StreamData& operator = (const tcl_MCAN_GenericType_StreamData& src);

   tBool   bUpdateLength(tU32 u32BitSize);

   tBool   bUpdateData(tclMcanMsgData* poMcanMsg);
   tBool   bUpdateMcanMessage(tclMcanMsgData* poMcanMsg);

   tU8*    pu8GetData() {return _pu8Data;};
   tVoid   vSetData(tU8* pu8Data, tU16 u16BitSize = 0);
   tVoid   vSetDataStream(tU8* pu8Data, tU16 u16ByteCount);

   const tU8* cpu8GetData() const {return _pu8Data;};
   const tU16 cu16GetDatalen() const {return _u16BitSize/8;};

private:
   tU8*   _pu8Data;
   tU16   _u16BitSize;
};
tBool operator==(tcl_MCAN_GenericType_StreamData const& lhs, tcl_MCAN_GenericType_StreamData const& rhs);
tBool operator!=(tcl_MCAN_GenericType_StreamData const& lhs, tcl_MCAN_GenericType_StreamData const& rhs);
#endif // __MCAN_GENERIC_TYPES_CLASS_H_
