/*!
  *  \file mcanGenericTypes.cpp
*/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "mcanGenericTypes.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FD_CSM_MCAN
#include "trcGenProj/Header/mcanGenericTypes.cpp.trc.h"
#endif



tcl_MCAN_GenericType_UnsignedInteger::tcl_MCAN_GenericType_UnsignedInteger(tU32 u32Data, tU16 u16BitSize) : 
   _u32Data(u32Data),
   _u16BitSize(u16BitSize) {
}

tBool tcl_MCAN_GenericType_UnsignedInteger::bUpdateData(tclMcanMsgData* poMcanMsg) {
    tU32 u32Data = (tU32) _u32Data;
    tBool bRet = poMcanMsg->bGetData(u32Data, _u16BitSize);
    if (bRet) {
        _u32Data = u32Data;
    } else {
        ETG_TRACE_FATAL(("tcl_MCAN_GenericType_UnsignedInteger::bUpdateData(): FAILED"));
    }
    return bRet;
}
   
tBool tcl_MCAN_GenericType_UnsignedInteger::bUpdateMcanMessage(tclMcanMsgData* poMcanMsg) {
    return poMcanMsg->bSetData(_u32Data, _u16BitSize);
}

tBool operator==(tcl_MCAN_GenericType_UnsignedInteger const& lhs, tcl_MCAN_GenericType_UnsignedInteger const& rhs){
    if (lhs.cu32GetData() != rhs.cu32GetData()) return FALSE;
    return TRUE;
}
tBool operator!=(tcl_MCAN_GenericType_UnsignedInteger const& lhs, tcl_MCAN_GenericType_UnsignedInteger const& rhs){
    if (lhs.cu32GetData() == rhs.cu32GetData()) return FALSE;
    return TRUE;
}


tcl_MCAN_GenericType_Integer::tcl_MCAN_GenericType_Integer(tS32 s32Data, tU16 u16BitSize) : 
   _s32Data(s32Data),
   _u16BitSize(u16BitSize) {
}

tBool tcl_MCAN_GenericType_Integer::bUpdateData(tclMcanMsgData* poMcanMsg) {
    tU32 u32Data = (tU32) _s32Data;
    tBool bRet = poMcanMsg->bGetData(u32Data, _u16BitSize);
    if (bRet) {
        _s32Data = (tS32)u32Data;
    } else {
        ETG_TRACE_FATAL(("tcl_MCAN_GenericType_Integer::bUpdateData(): FAILED"));
    }
    return bRet;
}
   
tBool tcl_MCAN_GenericType_Integer::bUpdateMcanMessage(tclMcanMsgData* poMcanMsg) {
    return poMcanMsg->bSetData((tU32)_s32Data, _u16BitSize);
}
tBool operator==(tcl_MCAN_GenericType_Integer const& lhs, tcl_MCAN_GenericType_Integer const& rhs){
    if (lhs.cs32GetData() != rhs.cs32GetData()) return FALSE;
    return TRUE;
}
tBool operator!=(tcl_MCAN_GenericType_Integer const& lhs, tcl_MCAN_GenericType_Integer const& rhs){
    if (lhs.cs32GetData() == rhs.cs32GetData()) return FALSE;
    return TRUE;
}


tcl_MCAN_GenericType_String::tcl_MCAN_GenericType_String(tChar* strData, tU16 u16BitSize) : 
_strData(NULL),
_u16BitSize(u16BitSize) 
{
    if (strData != NULL) {
        _strMsgData =  strData;
        _u16BitSize = _strMsgData.size()*8;
    }
}

tcl_MCAN_GenericType_String::~tcl_MCAN_GenericType_String() {
}

tBool tcl_MCAN_GenericType_String::bUpdateLength(tU32 u32BitSize) {
    _u16BitSize = (tU16)u32BitSize;
}

tBool tcl_MCAN_GenericType_String::bUpdateData(tclMcanMsgData* poMcanMsg) {
    tChar* pcData = NULL;
    if (_u16BitSize != 0) {
        pcData = new tChar[(_u16BitSize/8)+1];
            memset(pcData, 0, (_u16BitSize/8)+1);
    }
    tBool bRet = poMcanMsg->bGetStreamData((tU8*)pcData, _u16BitSize/8);
    _strMsgData = pcData;
    delete[] pcData;
    
    return bRet;
}
   
tBool tcl_MCAN_GenericType_String::bUpdateMcanMessage(tclMcanMsgData* poMcanMsg) {
    tBool bRet = FALSE;
    if (_strMsgData.size() != 0) {
        bRet = poMcanMsg->bSetStreamData((tU8*)_strMsgData.c_str(), _strMsgData.size());
    }
    return bRet;
}

tVoid tcl_MCAN_GenericType_String::vSetData(tChar* strData, tU16 u16BitSize) {
    ETG_TRACE_USR4(("tcl_MCAN_GenericType_String::vSetData(): %08x", ETG_LIST_LEN(u16BitSize/8), ETG_LIST_PTR_T8((tU8*)strData)));
    if (strlen(strData) != 0) {
        _strMsgData = strData;
        _u16BitSize = _strMsgData.size()*8;
    }
    //ETG_TRACE_FATAL(("tcl_MCAN_GenericType_String::vSetData(): %20s", _strMsgData.c_str()));
}
tBool operator==(tcl_MCAN_GenericType_String const& lhs, tcl_MCAN_GenericType_String const& rhs){
    if (strcmp (lhs.cstrGetData(),rhs.cstrGetData()) != 0) return FALSE;
    return TRUE;
}
tBool operator!=(tcl_MCAN_GenericType_String const& lhs, tcl_MCAN_GenericType_String const& rhs){
    if (strcmp (lhs.cstrGetData(),rhs.cstrGetData()) == 0) return FALSE;
    return TRUE;
}

tcl_MCAN_GenericType_StreamData::tcl_MCAN_GenericType_StreamData(tU8* pu8Data, tU16 u16BitSize) : 
_pu8Data(NULL),
_u16BitSize(u16BitSize) 
{
     if (u16BitSize != 0){
        tU8 u8ByteLen = u16BitSize/8;
        if ((u16BitSize%8)!= 0) {
            u8ByteLen += 1;
        }

        _pu8Data = new tU8[u8ByteLen];

        if (_pu8Data != NULL) {
            memset(_pu8Data, 0, u8ByteLen);
            if(pu8Data != NULL) {
            	memcpy ( _pu8Data, pu8Data, u8ByteLen);
            }
        }
    }
    ETG_TRACE_USR4(("tcl_MCAN_GenericType_StreamData::tcl_MCAN_GenericType_StreamData(): %08x, %d", _pu8Data, _u16BitSize));
}

tcl_MCAN_GenericType_StreamData::tcl_MCAN_GenericType_StreamData(const tcl_MCAN_GenericType_StreamData &obj) {

    ETG_TRACE_USR4(("tcl_MCAN_GenericType_StreamData::tcl_MCAN_GenericType_StreamData(const tcl_MCAN_GenericType_StreamData &obj): %08x, %d", obj._pu8Data, obj._u16BitSize));
    _u16BitSize = obj._u16BitSize;
    _pu8Data    = NULL;

    if ((obj._pu8Data != NULL) && (_u16BitSize != 0)) {
        tU8 u8ByteLen = _u16BitSize/8;
        if (u8ByteLen == 0) {
            u8ByteLen = 1;
        }

        //ETG_TRACE_FATAL(("tcl_MCAN_GenericType_StreamData::tcl_MCAN_GenericType_StreamData(): org data: %02x", ETG_LIST_LEN(obj._u16BitSize/8), ETG_LIST_PTR_T8((tU8*)obj._pu8Data)));
        _pu8Data = new tU8[u8ByteLen];
        if (_pu8Data != NULL) {
            memset(_pu8Data, 0, u8ByteLen);
            memcpy ( _pu8Data, obj._pu8Data, u8ByteLen);
            //ETG_TRACE_FATAL(("tcl_MCAN_GenericType_StreamData::tcl_MCAN_GenericType_StreamData(): copied data: %02x", ETG_LIST_LEN(_u16BitSize/8), ETG_LIST_PTR_T8((tU8*)_pu8Data)));
        }
    }

    //ETG_TRACE_FATAL(("tcl_MCAN_GenericType_StreamData::tcl_MCAN_GenericType_StreamData(): %08x, %d", _pu8Data, _u16BitSize));
}


tcl_MCAN_GenericType_StreamData::~tcl_MCAN_GenericType_StreamData() {
    ETG_TRACE_USR4(("tcl_MCAN_GenericType_StreamData::~tcl_MCAN_GenericType_StreamData(): %08x, %d", _pu8Data, _u16BitSize));
    if (_pu8Data != NULL) {
        delete[] _pu8Data;
    }
}

tcl_MCAN_GenericType_StreamData& tcl_MCAN_GenericType_StreamData::operator = (const tcl_MCAN_GenericType_StreamData& obj)
{
    ETG_TRACE_USR4(("tcl_MCAN_GenericType_StreamData::operator =(): %08x, %d", obj._pu8Data, obj._u16BitSize));
    if (this == &obj) return *this;

    _u16BitSize = obj._u16BitSize;
    _pu8Data    = NULL;
    if ((obj._pu8Data != NULL) && (_u16BitSize != 0)) {
        tU8 u8ByteLen = _u16BitSize/8;
        if (u8ByteLen == 0) {
            u8ByteLen = 1;
        }

        //ETG_TRACE_FATAL(("tcl_MCAN_GenericType_StreamData::tcl_MCAN_GenericType_StreamData(): org data: %02x", ETG_LIST_LEN(obj._u16BitSize/8), ETG_LIST_PTR_T8((tU8*)obj._pu8Data)));
        _pu8Data = new tU8[u8ByteLen];
        if (_pu8Data != NULL) {
            memset(_pu8Data, 0, u8ByteLen);
            memcpy ( _pu8Data, obj._pu8Data, u8ByteLen);
            //ETG_TRACE_FATAL(("tcl_MCAN_GenericType_StreamData::tcl_MCAN_GenericType_StreamData(): copied data: %02x", ETG_LIST_LEN(_u16BitSize/8), ETG_LIST_PTR_T8((tU8*)_pu8Data)));
        }
    }

    //ETG_TRACE_FATAL(("tcl_MCAN_GenericType_StreamData::tcl_MCAN_GenericType_StreamData(): %08x, %d", _pu8Data, _u16BitSize));

    return *this;      // Referenz zurckgeben
}

tBool tcl_MCAN_GenericType_StreamData::bUpdateLength(tU32 u32BitSize) {
    _u16BitSize = (tU16)u32BitSize;
}

tBool tcl_MCAN_GenericType_StreamData::bUpdateData(tclMcanMsgData* poMcanMsg) {
    tBool bRet = FALSE;
    ETG_TRACE_USR4(("tcl_MCAN_GenericType_StreamData::bUpdateData(): %08x, %d", _pu8Data, _u16BitSize));
    if ((_u16BitSize%8 == 0) && (poMcanMsg->u32GetCurBitPos() == 7)) {
    	if(NULL != _pu8Data){
    		bRet = poMcanMsg->bGetStreamData(_pu8Data, _u16BitSize/8);
    	}
    } else {
        if (_pu8Data == NULL) {
           _pu8Data = new tU8[(_u16BitSize+7)/8];
        }
        if (_pu8Data != NULL) {
            tU16 u16RemainingBits = _u16BitSize;
            tU32 u32ByteIdx = 0;
            while (u16RemainingBits > 0) {
                tU32 u32Data;
                tU16 u16NumCurrBits = (u16RemainingBits >= 8) ? 8 : u16RemainingBits;
                bRet = poMcanMsg->bGetData(u32Data,u16NumCurrBits);
                if (FALSE == bRet) {
                    break;
                }
                if (u16NumCurrBits < 8) {
                    u32Data <<= (8-u16NumCurrBits);
                }
                _pu8Data[u32ByteIdx++] = (tU8) (u32Data&0x000000ff);
                u16RemainingBits -= u16NumCurrBits;
            }
        }
    }
    if (FALSE == bRet) {
        ETG_TRACE_FATAL(("tcl_MCAN_GenericType_StreamData::bUpdateData(): FAILED"));
    }
    return bRet;
}
   
tBool tcl_MCAN_GenericType_StreamData::bUpdateMcanMessage(tclMcanMsgData* poMcanMsg) {
    tBool bRet = FALSE;

    ETG_TRACE_USR4(("tcl_MCAN_GenericType_StreamData::bUpdateMcanMessage(): %08x, %d", _pu8Data, _u16BitSize));
    if (_pu8Data == NULL) {
        //just create dummy data with given length
        _pu8Data = new tU8[(_u16BitSize/8)+1];
        if (_pu8Data) {
            memset(_pu8Data, 0, (_u16BitSize/8)+1);
        }
    }

    if (_pu8Data != NULL) {
        //ETG_TRACE_FATAL(("tcl_MCAN_GenericType_StreamData::bUpdateMcanMessage(): %02x", ETG_LIST_LEN(_u16BitSize/8), ETG_LIST_PTR_T8((tU8*)_pu8Data)));
        if (_u16BitSize%8 == 0) {
            bRet = poMcanMsg->bSetStreamData(_pu8Data, _u16BitSize/8);
        } else if (_u16BitSize<8){
            bRet = poMcanMsg->bSetData((tU32)_pu8Data[0], _u16BitSize);
        } else {
            bRet = poMcanMsg->bSetBitStreamData(_pu8Data, _u16BitSize);
        }
    } else {
        ETG_TRACE_FATAL(("tcl_MCAN_GenericType_StreamData::bUpdateMcanMessage(): FAILED: data=NULL, size=%d", _u16BitSize));
    }
    return bRet;
}

tVoid tcl_MCAN_GenericType_StreamData::vSetData(tU8* pu8Data, tU16 u16BitSize) {
    //ETG_TRACE_FATAL(("tcl_MCAN_GenericType_StreamData::vSetData(): %08x, %d", _pu8Data, _u16BitSize));
    ETG_TRACE_USR4(("tcl_MCAN_GenericType_StreamData::vSetData(): %02x", ETG_LIST_LEN(u16BitSize/8), ETG_LIST_PTR_T8((tU8*)pu8Data)));
    if (u16BitSize != 0) {
        if (_pu8Data != NULL) {
            delete[] _pu8Data;
            _pu8Data = NULL;
        }
        _pu8Data = new tU8[u16BitSize/8];
    }
    _u16BitSize = u16BitSize;
    if (_pu8Data != NULL) {
        memset(_pu8Data, 0, _u16BitSize/8);
        memcpy ( _pu8Data, pu8Data, (_u16BitSize/8) );
        //ETG_TRACE_FATAL(("tcl_MCAN_GenericType_StreamData::vSetData(): %02x", ETG_LIST_LEN(_u16BitSize/8), ETG_LIST_PTR_T8((tU8*)_pu8Data)));
    }
    //ETG_TRACE_FATAL(("tcl_MCAN_GenericType_StreamData::vSetData(): end %08x, %d", _pu8Data, _u16BitSize));
}

tVoid tcl_MCAN_GenericType_StreamData::vSetDataStream(tU8* pu8Data, tU16 u16ByteCount) {
    //ETG_TRACE_FATAL(("tcl_MCAN_GenericType_StreamData::vSetData(): %08x, %d", _pu8Data, _u16BitSize));
    ETG_TRACE_USR4(("tcl_MCAN_GenericType_StreamData::vSetData(): %02x", ETG_LIST_LEN(u16ByteCount), ETG_LIST_PTR_T8((tU8*)pu8Data)));
    if (u16ByteCount != 0) {
        if (_pu8Data != NULL) {
            delete[] _pu8Data;
            _pu8Data = NULL;
        }
        _pu8Data = new tU8[u16ByteCount];
    }
    _u16BitSize = u16ByteCount*8;
    if (_pu8Data != NULL) {
        memset(_pu8Data, 0, _u16BitSize/8);
        memcpy ( _pu8Data, pu8Data, (_u16BitSize/8) );
    }
}

tBool operator==(tcl_MCAN_GenericType_StreamData const& lhs, tcl_MCAN_GenericType_StreamData const& rhs){
    if (lhs.cu16GetDatalen() != rhs.cu16GetDatalen()) {
        return FALSE;
    } else {
        if (memcmp(lhs.cpu8GetData(), rhs.cpu8GetData(), lhs.cu16GetDatalen()) != 0) return FALSE;
    }
    return TRUE;
}
tBool operator!=(tcl_MCAN_GenericType_StreamData const& lhs, tcl_MCAN_GenericType_StreamData const& rhs){
    if (lhs.cu16GetDatalen() == rhs.cu16GetDatalen()) {
        if (memcmp(lhs.cpu8GetData(), rhs.cpu8GetData(), lhs.cu16GetDatalen()) == 0) return FALSE;
    }
    return TRUE;
}


