/**
 * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
 *               The reproduction, distribution and utilization of this file as well as the
 *               communication of its contents to others without express authorization is prohibited.
 *               Offenders will be held liable for the payment of damages.
 *               All rights reserved in the event of the grant of a patent, utility model or design.
 * @brief        class dp_tclDpPersPddAccess, which access to the PDD dynamical
 * @addtogroup   Datapool persistent
 * @{
 */
#ifndef _DP_PERS_PDD_ACC
#define _DP_PERS_PDD_ACC

#include "pdd.h"
#include "pdd_variant_gen.h"
/************************************************************************
|defines and macros (scope: global)
|-----------------------------------------------------------------------*/

/************************************************************************
|typedefs and struct defs (scope: global)
|-----------------------------------------------------------------------*/
 /* function pointer to the PDD */
typedef  tS32   (*tfpPddGetDataStreamSize)(const char*, tePddLocation);
typedef  tS32   (*tfpPddReadDataStream)(const char*, tePddLocation, tU8*, tS32, tU32, tU8*);
typedef  tS32   (*tfpPddWriteDataStream)(const char*, tePddLocation, tU8*, tS32, tU32, tBool);
typedef  tS32   (*tfpPddDeleteDataStream)(const char*, tePddLocation);
typedef  tS32   (*tfpPddDeleteOldDataPool)(const char*, tePddLocation);
typedef  tS32   (*tfpPddSyncSccStreams)(void);
typedef  tS32   (*tfpPddSyncNorStreams)(void);
typedef  tS32   (*tfpPddSyncRaweMMCStreams)(void);

typedef  void   (*tfpPddTraceCmd)(char* Pu8pData);

/************************************************************************
|class definition
|-----------------------------------------------------------------------*/
class dp_tclDpPersPddAccess
{
private:
    tVoid                    *vpHandlePdd;
    tfpPddGetDataStreamSize  fpPddGetDataStreamSize;
    tfpPddReadDataStream     fpPddReadDataStream;
    tfpPddWriteDataStream    fpPddWriteDataStream;
    tfpPddDeleteDataStream   fpPddDeleteDataStream;
    tfpPddDeleteOldDataPool  fpPddDeleteOldDataPool;
    tfpPddSyncSccStreams     fpPddSyncSccStreams;
    tfpPddSyncNorStreams     fpPddSyncNorStreams;
    tfpPddTraceCmd           fpPddTraceCmd;
    tfpPddSyncRaweMMCStreams fpPddSyncRaweMMCStreams;

    virtual tS32           s32LoadLibPdd();
    virtual void           vTraceErrorForDLsym(const tChar*);
    virtual tePddLocation  eGetPddLocation(eDpLocation eLocation);
public:
    dp_tclDpPersPddAccess();
    virtual ~dp_tclDpPersPddAccess();

    virtual tS32 s32PddGetDataStreamSize(const char* PtsDataStreamName, eDpLocation);
    virtual tS32 s32PddReadDataStream(const char* PtsDataStreamName, eDpLocation, tU8*, tS32, tU32, tU8*);
    virtual tS32 s32PddWriteDataStream(const char* PtsDataStreamName, eDpLocation, tU8*, tS32, tU32, tBool);
    virtual tS32 s32PddDeleteDataStream(const char* PtsDataStreamName, eDpLocation);
    virtual tS32 s32PddDeleteOldDataPool(const char* PtsDataPool, eDpLocation);
    virtual tS32 s32PddSyncSccStreams(void);
    virtual tS32 s32PddSyncNorStreams(void);
    virtual tS32 s32PddSyncRaweMMCStreams(void);

    virtual void vPddTraceCommand(char* Pu8pData);
    virtual void vDlClose(void);
};
#endif
//EOF
